/*
 * Decompiled with CFR 0.152.
 */
package com.itextpdf.testutils;

import com.itextpdf.text.BaseColor;
import com.itextpdf.text.DocumentException;
import com.itextpdf.text.Rectangle;
import com.itextpdf.text.io.RandomAccessSourceFactory;
import com.itextpdf.text.pdf.PRIndirectReference;
import com.itextpdf.text.pdf.PRStream;
import com.itextpdf.text.pdf.PRTokeniser;
import com.itextpdf.text.pdf.PdfAnnotation;
import com.itextpdf.text.pdf.PdfArray;
import com.itextpdf.text.pdf.PdfBoolean;
import com.itextpdf.text.pdf.PdfContentByte;
import com.itextpdf.text.pdf.PdfContentParser;
import com.itextpdf.text.pdf.PdfDictionary;
import com.itextpdf.text.pdf.PdfIndirectReference;
import com.itextpdf.text.pdf.PdfLiteral;
import com.itextpdf.text.pdf.PdfName;
import com.itextpdf.text.pdf.PdfNumber;
import com.itextpdf.text.pdf.PdfObject;
import com.itextpdf.text.pdf.PdfReader;
import com.itextpdf.text.pdf.PdfStamper;
import com.itextpdf.text.pdf.PdfString;
import com.itextpdf.text.pdf.RandomAccessFileOrArray;
import com.itextpdf.text.pdf.RefKey;
import com.itextpdf.text.pdf.parser.ContentByteUtils;
import com.itextpdf.text.pdf.parser.ImageRenderInfo;
import com.itextpdf.text.pdf.parser.InlineImageInfo;
import com.itextpdf.text.pdf.parser.InlineImageUtils;
import com.itextpdf.text.pdf.parser.PdfContentStreamProcessor;
import com.itextpdf.text.pdf.parser.RenderListener;
import com.itextpdf.text.pdf.parser.SimpleTextExtractionStrategy;
import com.itextpdf.text.pdf.parser.TaggedPdfReaderTool;
import com.itextpdf.text.pdf.parser.TextExtractionStrategy;
import com.itextpdf.text.pdf.parser.TextRenderInfo;
import com.itextpdf.text.xml.XMLUtil;
import com.itextpdf.xmp.XMPException;
import com.itextpdf.xmp.XMPMeta;
import com.itextpdf.xmp.XMPMetaFactory;
import com.itextpdf.xmp.XMPUtils;
import com.itextpdf.xmp.options.SerializeOptions;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileFilter;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Stack;
import java.util.StringTokenizer;
import java.util.TreeSet;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.xml.sax.SAXException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CompareTool {
    private String gsExec = System.getProperty("gsExec");
    private String compareExec;
    private final String gsParams = " -dNOPAUSE -dBATCH -sDEVICE=png16m -r150 -sOutputFile=<outputfile> <inputfile>";
    private final String compareParams = " \"<image1>\" \"<image2>\" \"<difference>\"";
    private static final String cannotOpenTargetDirectory = "Cannot open target directory for <filename>.";
    private static final String gsFailed = "GhostScript failed for <filename>.";
    private static final String unexpectedNumberOfPages = "Unexpected number of pages for <filename>.";
    private static final String differentPages = "File <filename> differs on page <pagenumber>.";
    private static final String undefinedGsPath = "Path to GhostScript is not specified. Please use -DgsExec=<path_to_ghostscript> (e.g. -DgsExec=\"C:/Program Files/gs/gs9.14/bin/gswin32c.exe\")";
    private static final String ignoredAreasPrefix = "ignored_areas_";
    private String cmpPdf;
    private String cmpPdfName;
    private String cmpImage;
    private String outPdf;
    private String outPdfName;
    private String outImage;
    List<PdfDictionary> outPages;
    List<RefKey> outPagesRef;
    List<PdfDictionary> cmpPages;
    List<RefKey> cmpPagesRef;
    private int compareByContentErrorsLimit = 1;
    private boolean generateCompareByContentXmlReport = false;
    private String xmlReportName = "report";
    private double floatComparisonError = 0.0;
    private boolean absoluteError = true;

    public CompareTool() {
        if (this.gsExec == null) {
            this.gsExec = System.getenv("gsExec");
        }
        this.compareExec = System.getProperty("compareExec");
        if (this.compareExec == null) {
            this.compareExec = System.getenv("compareExec");
        }
    }

    private String compare(String outPath, String differenceImagePrefix, Map<Integer, List<Rectangle>> ignoredAreas) throws IOException, InterruptedException, DocumentException {
        return this.compare(outPath, differenceImagePrefix, ignoredAreas, null);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private String compare(String outPath, String differenceImagePrefix, Map<Integer, List<Rectangle>> ignoredAreas, List<Integer> equalPages) throws IOException, InterruptedException, DocumentException {
        int cnt;
        String line2;
        File[] cmpImageFiles;
        File[] imageFiles;
        File targetDir;
        if (this.gsExec == null) {
            return undefinedGsPath;
        }
        if (!new File(this.gsExec).exists()) {
            return new File(this.gsExec).getAbsolutePath() + " does not exist";
        }
        if (!outPath.endsWith("/")) {
            outPath = outPath + "/";
        }
        if (!(targetDir = new File(outPath)).exists()) {
            targetDir.mkdirs();
        } else {
            for (File file : imageFiles = targetDir.listFiles(new PngFileFilter())) {
                file.delete();
            }
            for (File file : cmpImageFiles = targetDir.listFiles(new CmpPngFileFilter())) {
                file.delete();
            }
        }
        File diffFile = new File(outPath + differenceImagePrefix);
        if (diffFile.exists()) {
            diffFile.delete();
        }
        if (ignoredAreas != null && !ignoredAreas.isEmpty()) {
            PdfReader cmpReader = new PdfReader(this.cmpPdf);
            PdfReader outReader = new PdfReader(this.outPdf);
            PdfStamper outStamper = new PdfStamper(outReader, new FileOutputStream(outPath + ignoredAreasPrefix + this.outPdfName));
            PdfStamper cmpStamper = new PdfStamper(cmpReader, new FileOutputStream(outPath + ignoredAreasPrefix + this.cmpPdfName));
            for (Map.Entry<Integer, List<Rectangle>> entry : ignoredAreas.entrySet()) {
                int pageNumber = entry.getKey();
                List<Rectangle> rectangles = entry.getValue();
                if (rectangles == null || rectangles.isEmpty()) continue;
                PdfContentByte outCB = outStamper.getOverContent(pageNumber);
                PdfContentByte cmpCB = cmpStamper.getOverContent(pageNumber);
                for (Rectangle rect : rectangles) {
                    rect.setBackgroundColor(BaseColor.BLACK);
                    outCB.rectangle(rect);
                    cmpCB.rectangle(rect);
                }
            }
            outStamper.close();
            cmpStamper.close();
            outReader.close();
            cmpReader.close();
            this.init(outPath + ignoredAreasPrefix + this.outPdfName, outPath + ignoredAreasPrefix + this.cmpPdfName);
        }
        if (!targetDir.exists()) return cannotOpenTargetDirectory.replace("<filename>", this.outPdf);
        String gsParams = this.gsParams.replace("<outputfile>", outPath + this.cmpImage).replace("<inputfile>", this.cmpPdf);
        Process p2 = this.runProcess(this.gsExec, gsParams);
        BufferedReader bri = new BufferedReader(new InputStreamReader(p2.getInputStream()));
        BufferedReader bre = new BufferedReader(new InputStreamReader(p2.getErrorStream()));
        while ((line2 = bri.readLine()) != null) {
            System.out.println(line2);
        }
        bri.close();
        while ((line2 = bre.readLine()) != null) {
            System.out.println(line2);
        }
        bre.close();
        if (p2.waitFor() != 0) return gsFailed.replace("<filename>", this.cmpPdf);
        gsParams = this.gsParams.replace("<outputfile>", outPath + this.outImage).replace("<inputfile>", this.outPdf);
        p2 = this.runProcess(this.gsExec, gsParams);
        bri = new BufferedReader(new InputStreamReader(p2.getInputStream()));
        bre = new BufferedReader(new InputStreamReader(p2.getErrorStream()));
        while ((line2 = bri.readLine()) != null) {
            System.out.println(line2);
        }
        bri.close();
        while ((line2 = bre.readLine()) != null) {
            System.out.println(line2);
        }
        bre.close();
        int exitValue = p2.waitFor();
        if (exitValue != 0) return gsFailed.replace("<filename>", this.outPdf);
        imageFiles = targetDir.listFiles(new PngFileFilter());
        cmpImageFiles = targetDir.listFiles(new CmpPngFileFilter());
        boolean bUnexpectedNumberOfPages = false;
        if (imageFiles.length != cmpImageFiles.length) {
            bUnexpectedNumberOfPages = true;
        }
        if ((cnt = Math.min(imageFiles.length, cmpImageFiles.length)) < 1) {
            return "No files for comparing!!!\nThe result or sample pdf file is not processed by GhostScript.";
        }
        Arrays.sort(imageFiles, new ImageNameComparator());
        Arrays.sort(cmpImageFiles, new ImageNameComparator());
        String differentPagesFail = null;
        for (int i2 = 0; i2 < cnt; ++i2) {
            if (equalPages != null && equalPages.contains(i2)) continue;
            System.out.print("Comparing page " + Integer.toString(i2 + 1) + " (" + imageFiles[i2].getAbsolutePath() + ")...");
            FileInputStream is1 = new FileInputStream(imageFiles[i2]);
            FileInputStream is2 = new FileInputStream(cmpImageFiles[i2]);
            boolean cmpResult = this.compareStreams(is1, is2);
            is1.close();
            is2.close();
            if (!cmpResult) {
                if (this.compareExec != null && new File(this.compareExec).exists()) {
                    String compareParams = this.compareParams.replace("<image1>", imageFiles[i2].getAbsolutePath()).replace("<image2>", cmpImageFiles[i2].getAbsolutePath()).replace("<difference>", outPath + differenceImagePrefix + Integer.toString(i2 + 1) + ".png");
                    p2 = this.runProcess(this.compareExec, compareParams);
                    bre = new BufferedReader(new InputStreamReader(p2.getErrorStream()));
                    while ((line2 = bre.readLine()) != null) {
                        System.out.println(line2);
                    }
                    bre.close();
                    int cmpExitValue = p2.waitFor();
                    if (cmpExitValue == 0) {
                        if (differentPagesFail == null) {
                            differentPagesFail = differentPages.replace("<filename>", this.outPdf).replace("<pagenumber>", Integer.toString(i2 + 1));
                            differentPagesFail = differentPagesFail + "\nPlease, examine " + outPath + differenceImagePrefix + Integer.toString(i2 + 1) + ".png for more details.";
                        } else {
                            differentPagesFail = "File " + this.outPdf + " differs.\nPlease, examine difference images for more details.";
                        }
                    } else {
                        differentPagesFail = differentPages.replace("<filename>", this.outPdf).replace("<pagenumber>", Integer.toString(i2 + 1));
                    }
                } else {
                    differentPagesFail = differentPages.replace("<filename>", this.outPdf).replace("<pagenumber>", Integer.toString(i2 + 1));
                    differentPagesFail = differentPagesFail + "\nYou can optionally specify path to ImageMagick compare tool (e.g. -DcompareExec=\"C:/Program Files/ImageMagick-6.5.4-2/compare.exe\") to visualize differences.";
                    break;
                }
                System.out.println(differentPagesFail);
                continue;
            }
            System.out.println("done.");
        }
        if (differentPagesFail != null) {
            return differentPagesFail;
        }
        if (!bUnexpectedNumberOfPages) return null;
        return unexpectedNumberOfPages.replace("<filename>", this.outPdf);
    }

    private Process runProcess(String execPath, String params) throws IOException, InterruptedException {
        StringTokenizer st = new StringTokenizer(params);
        String[] cmdArray = new String[st.countTokens() + 1];
        cmdArray[0] = execPath;
        int i2 = 1;
        while (st.hasMoreTokens()) {
            cmdArray[i2] = st.nextToken();
            ++i2;
        }
        Process p2 = Runtime.getRuntime().exec(cmdArray);
        return p2;
    }

    public String compare(String outPdf, String cmpPdf, String outPath, String differenceImagePrefix, Map<Integer, List<Rectangle>> ignoredAreas) throws IOException, InterruptedException, DocumentException {
        this.init(outPdf, cmpPdf);
        return this.compare(outPath, differenceImagePrefix, ignoredAreas);
    }

    public String compare(String outPdf, String cmpPdf, String outPath, String differenceImagePrefix) throws IOException, InterruptedException, DocumentException {
        return this.compare(outPdf, cmpPdf, outPath, differenceImagePrefix, null);
    }

    public CompareTool setCompareByContentErrorsLimit(int compareByContentMaxErrorCount) {
        this.compareByContentErrorsLimit = compareByContentMaxErrorCount;
        return this;
    }

    public void setGenerateCompareByContentXmlReport(boolean generateCompareByContentXmlReport) {
        this.generateCompareByContentXmlReport = generateCompareByContentXmlReport;
    }

    public CompareTool setFloatAbsoluteError(float error2) {
        this.floatComparisonError = error2;
        this.absoluteError = true;
        return this;
    }

    public CompareTool setFloatRelativeError(float error2) {
        this.floatComparisonError = error2;
        this.absoluteError = false;
        return this;
    }

    public String getXmlReportName() {
        return this.xmlReportName;
    }

    public void setXmlReportName(String xmlReportName) {
        this.xmlReportName = xmlReportName;
    }

    protected String compareByContent(String outPath, String differenceImagePrefix, Map<Integer, List<Rectangle>> ignoredAreas) throws DocumentException, InterruptedException, IOException {
        System.out.print("[itext] INFO  Comparing by content..........");
        PdfReader outReader = new PdfReader(this.outPdf);
        this.outPages = new ArrayList<PdfDictionary>();
        this.outPagesRef = new ArrayList<RefKey>();
        this.loadPagesFromReader(outReader, this.outPages, this.outPagesRef);
        PdfReader cmpReader = new PdfReader(this.cmpPdf);
        this.cmpPages = new ArrayList<PdfDictionary>();
        this.cmpPagesRef = new ArrayList<RefKey>();
        this.loadPagesFromReader(cmpReader, this.cmpPages, this.cmpPagesRef);
        if (this.outPages.size() != this.cmpPages.size()) {
            return this.compare(outPath, differenceImagePrefix, ignoredAreas);
        }
        CompareResult compareResult = new CompareResult(this.compareByContentErrorsLimit);
        ArrayList<Integer> equalPages = new ArrayList<Integer>(this.cmpPages.size());
        for (int i2 = 0; i2 < this.cmpPages.size(); ++i2) {
            ObjectPath currentPath = new ObjectPath(this.cmpPagesRef.get(i2), this.outPagesRef.get(i2));
            if (!this.compareDictionariesExtended(this.outPages.get(i2), this.cmpPages.get(i2), currentPath, compareResult)) continue;
            equalPages.add(i2);
        }
        PdfObject outStructTree = outReader.getCatalog().get(PdfName.STRUCTTREEROOT);
        PdfObject cmpStructTree = cmpReader.getCatalog().get(PdfName.STRUCTTREEROOT);
        RefKey outStructTreeRef = outStructTree == null ? null : new RefKey((PdfIndirectReference)outStructTree);
        RefKey cmpStructTreeRef = cmpStructTree == null ? null : new RefKey((PdfIndirectReference)cmpStructTree);
        this.compareObjects(outStructTree, cmpStructTree, new ObjectPath(outStructTreeRef, cmpStructTreeRef), compareResult);
        PdfObject outOcProperties = outReader.getCatalog().get(PdfName.OCPROPERTIES);
        PdfObject cmpOcProperties = cmpReader.getCatalog().get(PdfName.OCPROPERTIES);
        RefKey outOcPropertiesRef = outOcProperties instanceof PdfIndirectReference ? new RefKey((PdfIndirectReference)outOcProperties) : null;
        RefKey cmpOcPropertiesRef = cmpOcProperties instanceof PdfIndirectReference ? new RefKey((PdfIndirectReference)cmpOcProperties) : null;
        this.compareObjects(outOcProperties, cmpOcProperties, new ObjectPath(outOcPropertiesRef, cmpOcPropertiesRef), compareResult);
        outReader.close();
        cmpReader.close();
        if (this.generateCompareByContentXmlReport) {
            try {
                compareResult.writeReportToXml(new FileOutputStream(outPath + "/" + this.xmlReportName + ".xml"));
            }
            catch (Exception exc) {
                // empty catch block
            }
        }
        if (equalPages.size() == this.cmpPages.size() && compareResult.isOk()) {
            System.out.println("OK");
            System.out.flush();
            return null;
        }
        System.out.println("Fail");
        System.out.flush();
        String compareByContentReport = "Compare by content report:\n" + compareResult.getReport();
        System.out.println(compareByContentReport);
        System.out.flush();
        String message2 = this.compare(outPath, differenceImagePrefix, ignoredAreas, equalPages);
        if (message2 == null || message2.length() == 0) {
            return "Compare by content fails. No visual differences";
        }
        return message2;
    }

    public String compareByContent(String outPdf, String cmpPdf, String outPath, String differenceImagePrefix, Map<Integer, List<Rectangle>> ignoredAreas) throws DocumentException, InterruptedException, IOException {
        this.init(outPdf, cmpPdf);
        return this.compareByContent(outPath, differenceImagePrefix, ignoredAreas);
    }

    public String compareByContent(String outPdf, String cmpPdf, String outPath, String differenceImagePrefix) throws DocumentException, InterruptedException, IOException {
        return this.compareByContent(outPdf, cmpPdf, outPath, differenceImagePrefix, null);
    }

    private void loadPagesFromReader(PdfReader reader, List<PdfDictionary> pages, List<RefKey> pagesRef) {
        PdfObject pagesDict = reader.getCatalog().get(PdfName.PAGES);
        this.addPagesFromDict(pagesDict, pages, pagesRef);
    }

    private void addPagesFromDict(PdfObject dictRef, List<PdfDictionary> pages, List<RefKey> pagesRef) {
        PdfDictionary dict = (PdfDictionary)PdfReader.getPdfObject(dictRef);
        if (dict.isPages()) {
            PdfArray kids = dict.getAsArray(PdfName.KIDS);
            if (kids == null) {
                return;
            }
            for (PdfObject kid : kids) {
                this.addPagesFromDict(kid, pages, pagesRef);
            }
        } else if (dict.isPage()) {
            pages.add(dict);
            pagesRef.add(new RefKey((PdfIndirectReference)((PRIndirectReference)dictRef)));
        }
    }

    private boolean compareObjects(PdfObject outObj, PdfObject cmpObj, ObjectPath currentPath, CompareResult compareResult) throws IOException {
        PdfObject outDirectObj = PdfReader.getPdfObject(outObj);
        PdfObject cmpDirectObj = PdfReader.getPdfObject(cmpObj);
        if (cmpDirectObj == null && outDirectObj == null) {
            return true;
        }
        if (outDirectObj == null) {
            compareResult.addError(currentPath, "Expected object was not found.");
            return false;
        }
        if (cmpDirectObj == null) {
            compareResult.addError(currentPath, "Found object which was not expected to be found.");
            return false;
        }
        if (cmpDirectObj.type() != outDirectObj.type()) {
            compareResult.addError(currentPath, String.format("Types do not match. Expected: %s. Found: %s.", cmpDirectObj.getClass().getSimpleName(), outDirectObj.getClass().getSimpleName()));
            return false;
        }
        if (cmpObj.isIndirect() && outObj.isIndirect()) {
            if (currentPath.isComparing(new RefKey((PdfIndirectReference)cmpObj), new RefKey((PdfIndirectReference)outObj))) {
                return true;
            }
            currentPath = currentPath.resetDirectPath(new RefKey((PdfIndirectReference)cmpObj), new RefKey((PdfIndirectReference)outObj));
        }
        if (cmpDirectObj.isDictionary() && ((PdfDictionary)cmpDirectObj).isPage()) {
            if (!outDirectObj.isDictionary() || !((PdfDictionary)outDirectObj).isPage()) {
                if (compareResult != null && currentPath != null) {
                    compareResult.addError(currentPath, "Expected a page. Found not a page.");
                }
                return false;
            }
            RefKey cmpRefKey = new RefKey((PdfIndirectReference)((PRIndirectReference)cmpObj));
            RefKey outRefKey = new RefKey((PdfIndirectReference)((PRIndirectReference)outObj));
            if (this.cmpPagesRef.contains(cmpRefKey) && this.cmpPagesRef.indexOf(cmpRefKey) == this.outPagesRef.indexOf(outRefKey)) {
                return true;
            }
            if (compareResult != null && currentPath != null) {
                compareResult.addError(currentPath, String.format("The dictionaries refer to different pages. Expected page number: %s. Found: %s", this.cmpPagesRef.indexOf(cmpRefKey), this.outPagesRef.indexOf(outRefKey)));
            }
            return false;
        }
        if (cmpDirectObj.isDictionary()) {
            if (!this.compareDictionariesExtended((PdfDictionary)outDirectObj, (PdfDictionary)cmpDirectObj, currentPath, compareResult)) {
                return false;
            }
        } else if (cmpDirectObj.isStream()) {
            if (!this.compareStreamsExtended((PRStream)outDirectObj, (PRStream)cmpDirectObj, currentPath, compareResult)) {
                return false;
            }
        } else if (cmpDirectObj.isArray()) {
            if (!this.compareArraysExtended((PdfArray)outDirectObj, (PdfArray)cmpDirectObj, currentPath, compareResult)) {
                return false;
            }
        } else if (cmpDirectObj.isName()) {
            if (!this.compareNamesExtended((PdfName)outDirectObj, (PdfName)cmpDirectObj, currentPath, compareResult)) {
                return false;
            }
        } else if (cmpDirectObj.isNumber()) {
            if (!this.compareNumbersExtended((PdfNumber)outDirectObj, (PdfNumber)cmpDirectObj, currentPath, compareResult)) {
                return false;
            }
        } else if (cmpDirectObj.isString()) {
            if (!this.compareStringsExtended((PdfString)outDirectObj, (PdfString)cmpDirectObj, currentPath, compareResult)) {
                return false;
            }
        } else if (cmpDirectObj.isBoolean()) {
            if (!this.compareBooleansExtended((PdfBoolean)outDirectObj, (PdfBoolean)cmpDirectObj, currentPath, compareResult)) {
                return false;
            }
        } else if (cmpDirectObj instanceof PdfLiteral) {
            if (!this.compareLiteralsExtended((PdfLiteral)outDirectObj, (PdfLiteral)cmpDirectObj, currentPath, compareResult)) {
                return false;
            }
        } else if (!outDirectObj.isNull() || !cmpDirectObj.isNull()) {
            throw new UnsupportedOperationException();
        }
        return true;
    }

    public boolean compareDictionaries(PdfDictionary outDict, PdfDictionary cmpDict) throws IOException {
        return this.compareDictionariesExtended(outDict, cmpDict, null, null);
    }

    private boolean compareDictionariesExtended(PdfDictionary outDict, PdfDictionary cmpDict, ObjectPath currentPath, CompareResult compareResult) throws IOException {
        if (cmpDict != null && outDict == null || outDict != null && cmpDict == null) {
            compareResult.addError(currentPath, "One of the dictionaries is null, the other is not.");
            return false;
        }
        boolean dictsAreSame = true;
        TreeSet<PdfName> mergedKeys = new TreeSet<PdfName>(cmpDict.getKeys());
        mergedKeys.addAll(outDict.getKeys());
        for (PdfName key2 : mergedKeys) {
            PdfObject cmpObj;
            if (key2.compareTo(PdfName.PARENT) == 0 || key2.compareTo(PdfName.P) == 0 || outDict.isStream() && cmpDict.isStream() && (key2.equals(PdfName.FILTER) || key2.equals(PdfName.LENGTH))) continue;
            if ((key2.compareTo(PdfName.BASEFONT) == 0 || key2.compareTo(PdfName.FONTNAME) == 0) && (cmpObj = cmpDict.getDirectObject(key2)).isName() && cmpObj.toString().indexOf(43) > 0) {
                String outName;
                String cmpName;
                PdfObject outObj = outDict.getDirectObject(key2);
                if (!outObj.isName() || outObj.toString().indexOf(43) == -1) {
                    if (compareResult != null && currentPath != null) {
                        compareResult.addError(currentPath, String.format("PdfDictionary %s entry: Expected: %s. Found: %s", key2.toString(), cmpObj.toString(), outObj.toString()));
                    }
                    dictsAreSame = false;
                }
                if ((cmpName = cmpObj.toString().substring(cmpObj.toString().indexOf(43))).equals(outName = outObj.toString().substring(outObj.toString().indexOf(43)))) continue;
                if (compareResult != null && currentPath != null) {
                    compareResult.addError(currentPath, String.format("PdfDictionary %s entry: Expected: %s. Found: %s", key2.toString(), cmpObj.toString(), outObj.toString()));
                }
                dictsAreSame = false;
                continue;
            }
            if (this.floatComparisonError != 0.0 && cmpDict.isPage() && outDict.isPage() && key2.equals(PdfName.CONTENTS)) {
                if (this.compareContentStreamsByParsingExtended(outDict.getDirectObject(key2), cmpDict.getDirectObject(key2), (PdfDictionary)outDict.getDirectObject(PdfName.RESOURCES), (PdfDictionary)cmpDict.getDirectObject(PdfName.RESOURCES), currentPath, compareResult)) continue;
                dictsAreSame = false;
                continue;
            }
            if (currentPath != null) {
                currentPath.pushDictItemToPath(key2.toString());
            }
            boolean bl = dictsAreSame = this.compareObjects(outDict.get(key2), cmpDict.get(key2), currentPath, compareResult) && dictsAreSame;
            if (currentPath != null) {
                currentPath.pop();
            }
            if (dictsAreSame || currentPath != null && compareResult != null && !compareResult.isMessageLimitReached()) continue;
            return false;
        }
        return dictsAreSame;
    }

    public boolean compareContentStreamsByParsing(PdfObject outObj, PdfObject cmpObj) throws IOException {
        return this.compareContentStreamsByParsingExtended(outObj, cmpObj, null, null, null, null);
    }

    public boolean compareContentStreamsByParsing(PdfObject outObj, PdfObject cmpObj, PdfDictionary outResources, PdfDictionary cmpResources) throws IOException {
        return this.compareContentStreamsByParsingExtended(outObj, cmpObj, outResources, cmpResources, null, null);
    }

    private boolean compareContentStreamsByParsingExtended(PdfObject outObj, PdfObject cmpObj, PdfDictionary outResources, PdfDictionary cmpResources, ObjectPath currentPath, CompareResult compareResult) throws IOException {
        if (outObj.type() != outObj.type()) {
            compareResult.addError(currentPath, String.format("PdfObject. Types are different. Expected: %s. Found: %s", cmpObj.type(), outObj.type()));
            return false;
        }
        if (outObj.isArray()) {
            PdfArray outArr = (PdfArray)outObj;
            PdfArray cmpArr = (PdfArray)cmpObj;
            if (cmpArr.size() != outArr.size()) {
                compareResult.addError(currentPath, String.format("PdfArray. Sizes are different. Expected: %s. Found: %s", cmpArr.size(), outArr.size()));
                return false;
            }
            for (int i2 = 0; i2 < cmpArr.size(); ++i2) {
                if (this.compareContentStreamsByParsingExtended(outArr.getPdfObject(i2), cmpArr.getPdfObject(i2), outResources, cmpResources, currentPath, compareResult)) continue;
                return false;
            }
        }
        PRTokeniser cmpTokeniser = new PRTokeniser(new RandomAccessFileOrArray(new RandomAccessSourceFactory().createSource(ContentByteUtils.getContentBytesFromContentObject(cmpObj))));
        PRTokeniser outTokeniser = new PRTokeniser(new RandomAccessFileOrArray(new RandomAccessSourceFactory().createSource(ContentByteUtils.getContentBytesFromContentObject(outObj))));
        PdfContentParser cmpPs = new PdfContentParser(cmpTokeniser);
        PdfContentParser outPs = new PdfContentParser(outTokeniser);
        ArrayList<PdfObject> cmpOperands = new ArrayList<PdfObject>();
        ArrayList<PdfObject> outOperands = new ArrayList<PdfObject>();
        while (cmpPs.parse(cmpOperands).size() > 0) {
            outPs.parse(outOperands);
            if (cmpOperands.size() != outOperands.size()) {
                compareResult.addError(currentPath, String.format("PdfObject. Different commands lengths. Expected: %s. Found: %s", cmpOperands.size(), outOperands.size()));
                return false;
            }
            if (cmpOperands.size() == 1 && this.compareLiterals((PdfLiteral)cmpOperands.get(0), new PdfLiteral("BI")) && this.compareLiterals((PdfLiteral)outOperands.get(0), new PdfLiteral("BI"))) {
                PRStream cmpStr = (PRStream)cmpObj;
                PRStream outStr = (PRStream)outObj;
                if (null != outStr.getDirectObject(PdfName.RESOURCES) && null != cmpStr.getDirectObject(PdfName.RESOURCES)) {
                    outResources = (PdfDictionary)outStr.getDirectObject(PdfName.RESOURCES);
                    cmpResources = (PdfDictionary)cmpStr.getDirectObject(PdfName.RESOURCES);
                }
                if (this.compareInlineImagesExtended(outPs, cmpPs, outResources, cmpResources, currentPath, compareResult)) continue;
                return false;
            }
            for (int i3 = 0; i3 < cmpOperands.size(); ++i3) {
                if (this.compareObjects(outOperands.get(i3), cmpOperands.get(i3), currentPath, compareResult)) continue;
                return false;
            }
        }
        return true;
    }

    private boolean compareInlineImagesExtended(PdfContentParser outPs, PdfContentParser cmpPs, PdfDictionary outDict, PdfDictionary cmpDict, ObjectPath currentPath, CompareResult compareResult) throws IOException {
        InlineImageInfo cmpInfo = InlineImageUtils.parseInlineImage(cmpPs, cmpDict);
        InlineImageInfo outInfo = InlineImageUtils.parseInlineImage(outPs, outDict);
        return this.compareObjects(outInfo.getImageDictionary(), cmpInfo.getImageDictionary(), currentPath, compareResult) && Arrays.equals(outInfo.getSamples(), cmpInfo.getSamples());
    }

    public boolean compareStreams(PRStream outStream, PRStream cmpStream) throws IOException {
        return this.compareStreamsExtended(outStream, cmpStream, null, null);
    }

    private boolean compareStreamsExtended(PRStream outStream, PRStream cmpStream, ObjectPath currentPath, CompareResult compareResult) throws IOException {
        boolean decodeStreams = PdfName.FLATEDECODE.equals(outStream.get(PdfName.FILTER));
        byte[] outStreamBytes = PdfReader.getStreamBytesRaw(outStream);
        byte[] cmpStreamBytes = PdfReader.getStreamBytesRaw(cmpStream);
        if (decodeStreams) {
            outStreamBytes = PdfReader.decodeBytes(outStreamBytes, outStream);
            cmpStreamBytes = PdfReader.decodeBytes(cmpStreamBytes, cmpStream);
        }
        if (this.floatComparisonError != 0.0 && PdfName.XOBJECT.equals(cmpStream.getDirectObject(PdfName.TYPE)) && PdfName.XOBJECT.equals(outStream.getDirectObject(PdfName.TYPE)) && PdfName.FORM.equals(cmpStream.getDirectObject(PdfName.SUBTYPE)) && PdfName.FORM.equals(outStream.getDirectObject(PdfName.SUBTYPE))) {
            return this.compareContentStreamsByParsingExtended(outStream, cmpStream, outStream.getAsDict(PdfName.RESOURCES), cmpStream.getAsDict(PdfName.RESOURCES), currentPath, compareResult) && this.compareDictionariesExtended(outStream, cmpStream, currentPath, compareResult);
        }
        if (Arrays.equals(outStreamBytes, cmpStreamBytes)) {
            return this.compareDictionariesExtended(outStream, cmpStream, currentPath, compareResult);
        }
        if (cmpStreamBytes.length != outStreamBytes.length) {
            if (compareResult != null && currentPath != null) {
                compareResult.addError(currentPath, String.format("PRStream. Lengths are different. Expected: %s. Found: %s", cmpStreamBytes.length, outStreamBytes.length));
            }
        } else {
            for (int i2 = 0; i2 < cmpStreamBytes.length; ++i2) {
                if (cmpStreamBytes[i2] == outStreamBytes[i2]) continue;
                int l2 = Math.max(0, i2 - 10);
                int r2 = Math.min(cmpStreamBytes.length, i2 + 10);
                if (compareResult == null || currentPath == null) continue;
                currentPath.pushOffsetToPath(i2);
                compareResult.addError(currentPath, String.format("PRStream. The bytes differ at index %s. Expected: %s (%s). Found: %s (%s)", i2, new String(new byte[]{cmpStreamBytes[i2]}), new String(cmpStreamBytes, l2, r2 - l2).replaceAll("\\n", "\\\\n"), new String(new byte[]{outStreamBytes[i2]}), new String(outStreamBytes, l2, r2 - l2).replaceAll("\\n", "\\\\n")));
                currentPath.pop();
            }
        }
        return false;
    }

    public boolean compareArrays(PdfArray outArray, PdfArray cmpArray) throws IOException {
        return this.compareArraysExtended(outArray, cmpArray, null, null);
    }

    private boolean compareArraysExtended(PdfArray outArray, PdfArray cmpArray, ObjectPath currentPath, CompareResult compareResult) throws IOException {
        if (outArray == null) {
            if (compareResult != null && currentPath != null) {
                compareResult.addError(currentPath, "Found null. Expected PdfArray.");
            }
            return false;
        }
        if (outArray.size() != cmpArray.size()) {
            if (compareResult != null && currentPath != null) {
                compareResult.addError(currentPath, String.format("PdfArrays. Lengths are different. Expected: %s. Found: %s.", cmpArray.size(), outArray.size()));
            }
            return false;
        }
        boolean arraysAreEqual = true;
        for (int i2 = 0; i2 < cmpArray.size(); ++i2) {
            if (currentPath != null) {
                currentPath.pushArrayItemToPath(i2);
            }
            boolean bl = arraysAreEqual = this.compareObjects(outArray.getPdfObject(i2), cmpArray.getPdfObject(i2), currentPath, compareResult) && arraysAreEqual;
            if (currentPath != null) {
                currentPath.pop();
            }
            if (arraysAreEqual || currentPath != null && compareResult != null && !compareResult.isMessageLimitReached()) continue;
            return false;
        }
        return arraysAreEqual;
    }

    public boolean compareNames(PdfName outName, PdfName cmpName) {
        return cmpName.compareTo(outName) == 0;
    }

    private boolean compareNamesExtended(PdfName outName, PdfName cmpName, ObjectPath currentPath, CompareResult compareResult) {
        if (cmpName.compareTo(outName) == 0) {
            return true;
        }
        if (compareResult != null && currentPath != null) {
            compareResult.addError(currentPath, String.format("PdfName. Expected: %s. Found: %s", cmpName.toString(), outName.toString()));
        }
        return false;
    }

    public boolean compareNumbers(PdfNumber outNumber, PdfNumber cmpNumber) {
        double difference = Math.abs(outNumber.doubleValue() - cmpNumber.doubleValue());
        if (!this.absoluteError && cmpNumber.doubleValue() != 0.0) {
            difference /= cmpNumber.doubleValue();
        }
        return difference <= this.floatComparisonError;
    }

    private boolean compareNumbersExtended(PdfNumber outNumber, PdfNumber cmpNumber, ObjectPath currentPath, CompareResult compareResult) {
        if (this.compareNumbers(outNumber, cmpNumber)) {
            return true;
        }
        if (compareResult != null && currentPath != null) {
            compareResult.addError(currentPath, String.format("PdfNumber. Expected: %s. Found: %s", cmpNumber, outNumber));
        }
        return false;
    }

    public boolean compareStrings(PdfString outString, PdfString cmpString) {
        return Arrays.equals(cmpString.getBytes(), outString.getBytes());
    }

    private boolean compareStringsExtended(PdfString outString, PdfString cmpString, ObjectPath currentPath, CompareResult compareResult) {
        block3: {
            String outStr;
            String cmpStr;
            block2: {
                if (Arrays.equals(cmpString.getBytes(), outString.getBytes())) {
                    return true;
                }
                cmpStr = cmpString.toUnicodeString();
                outStr = outString.toUnicodeString();
                if (cmpStr.length() == outStr.length()) break block2;
                if (compareResult == null || currentPath == null) break block3;
                compareResult.addError(currentPath, String.format("PdfString. Lengths are different. Expected: %s. Found: %s", cmpStr.length(), outStr.length()));
                break block3;
            }
            for (int i2 = 0; i2 < cmpStr.length(); ++i2) {
                if (cmpStr.charAt(i2) == outStr.charAt(i2)) continue;
                int l2 = Math.max(0, i2 - 10);
                int r2 = Math.min(cmpStr.length(), i2 + 10);
                if (compareResult == null || currentPath == null) break;
                currentPath.pushOffsetToPath(i2);
                compareResult.addError(currentPath, String.format("PdfString. Characters differ at position %s. Expected: %s (%s). Found: %s (%s).", i2, Character.toString(cmpStr.charAt(i2)), cmpStr.substring(l2, r2).replace("\n", "\\n"), Character.toString(outStr.charAt(i2)), outStr.substring(l2, r2).replace("\n", "\\n")));
                currentPath.pop();
                break;
            }
        }
        return false;
    }

    public boolean compareLiterals(PdfLiteral outLiteral, PdfLiteral cmpLiteral) {
        return Arrays.equals(cmpLiteral.getBytes(), outLiteral.getBytes());
    }

    private boolean compareLiteralsExtended(PdfLiteral outLiteral, PdfLiteral cmpLiteral, ObjectPath currentPath, CompareResult compareResult) {
        if (this.compareLiterals(outLiteral, cmpLiteral)) {
            return true;
        }
        if (compareResult != null && currentPath != null) {
            compareResult.addError(currentPath, String.format("PdfLiteral. Expected: %s. Found: %s", cmpLiteral, outLiteral));
        }
        return false;
    }

    public boolean compareBooleans(PdfBoolean outBoolean, PdfBoolean cmpBoolean) {
        return Arrays.equals(cmpBoolean.getBytes(), outBoolean.getBytes());
    }

    private boolean compareBooleansExtended(PdfBoolean outBoolean, PdfBoolean cmpBoolean, ObjectPath currentPath, CompareResult compareResult) {
        if (cmpBoolean.booleanValue() == outBoolean.booleanValue()) {
            return true;
        }
        if (compareResult != null && currentPath != null) {
            compareResult.addError(currentPath, String.format("PdfBoolean. Expected: %s. Found: %s.", cmpBoolean.booleanValue(), outBoolean.booleanValue()));
        }
        return false;
    }

    public String compareXmp(byte[] xmp1, byte[] xmp2) {
        return this.compareXmp(xmp1, xmp2, false);
    }

    public String compareXmp(byte[] xmp1, byte[] xmp2, boolean ignoreDateAndProducerProperties) {
        try {
            if (ignoreDateAndProducerProperties) {
                XMPMeta xmpMeta = XMPMetaFactory.parseFromBuffer(xmp1);
                XMPUtils.removeProperties(xmpMeta, "http://ns.adobe.com/xap/1.0/", "CreateDate", true, true);
                XMPUtils.removeProperties(xmpMeta, "http://ns.adobe.com/xap/1.0/", "ModifyDate", true, true);
                XMPUtils.removeProperties(xmpMeta, "http://ns.adobe.com/xap/1.0/", "MetadataDate", true, true);
                XMPUtils.removeProperties(xmpMeta, "http://ns.adobe.com/pdf/1.3/", "Producer", true, true);
                xmp1 = XMPMetaFactory.serializeToBuffer(xmpMeta, new SerializeOptions(8192));
                xmpMeta = XMPMetaFactory.parseFromBuffer(xmp2);
                XMPUtils.removeProperties(xmpMeta, "http://ns.adobe.com/xap/1.0/", "CreateDate", true, true);
                XMPUtils.removeProperties(xmpMeta, "http://ns.adobe.com/xap/1.0/", "ModifyDate", true, true);
                XMPUtils.removeProperties(xmpMeta, "http://ns.adobe.com/xap/1.0/", "MetadataDate", true, true);
                XMPUtils.removeProperties(xmpMeta, "http://ns.adobe.com/pdf/1.3/", "Producer", true, true);
                xmp2 = XMPMetaFactory.serializeToBuffer(xmpMeta, new SerializeOptions(8192));
            }
            if (!this.compareXmls(xmp1, xmp2)) {
                return "The XMP packages different!";
            }
        }
        catch (XMPException xmpExc) {
            return "XMP parsing failure!";
        }
        catch (IOException ioExc) {
            return "XMP parsing failure!";
        }
        catch (ParserConfigurationException parseExc) {
            return "XMP parsing failure!";
        }
        catch (SAXException parseExc) {
            return "XMP parsing failure!";
        }
        return null;
    }

    public String compareXmp(String outPdf, String cmpPdf) {
        return this.compareXmp(outPdf, cmpPdf, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String compareXmp(String outPdf, String cmpPdf, boolean ignoreDateAndProducerProperties) {
        this.init(outPdf, cmpPdf);
        PdfReader cmpReader = null;
        PdfReader outReader = null;
        try {
            cmpReader = new PdfReader(this.cmpPdf);
            outReader = new PdfReader(this.outPdf);
            byte[] cmpBytes = cmpReader.getMetadata();
            byte[] outBytes = outReader.getMetadata();
            String string2 = this.compareXmp(cmpBytes, outBytes, ignoreDateAndProducerProperties);
            return string2;
        }
        catch (IOException e2) {
            String string3 = "XMP parsing failure!";
            return string3;
        }
        finally {
            if (cmpReader != null) {
                cmpReader.close();
            }
            if (outReader != null) {
                outReader.close();
            }
        }
    }

    public boolean compareXmls(byte[] xml1, byte[] xml2) throws ParserConfigurationException, SAXException, IOException {
        DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
        dbf.setNamespaceAware(true);
        dbf.setCoalescing(true);
        dbf.setIgnoringElementContentWhitespace(true);
        dbf.setIgnoringComments(true);
        DocumentBuilder db = dbf.newDocumentBuilder();
        Document doc1 = db.parse(new ByteArrayInputStream(xml1));
        doc1.normalizeDocument();
        Document doc2 = db.parse(new ByteArrayInputStream(xml2));
        doc2.normalizeDocument();
        return doc2.isEqualNode(doc1);
    }

    public String compareDocumentInfo(String outPdf, String cmpPdf) throws IOException {
        System.out.print("[itext] INFO  Comparing document info.......");
        String message2 = null;
        PdfReader outReader = new PdfReader(outPdf);
        PdfReader cmpReader = new PdfReader(cmpPdf);
        String[] cmpInfo = this.convertInfo(cmpReader.getInfo());
        String[] outInfo = this.convertInfo(outReader.getInfo());
        for (int i2 = 0; i2 < cmpInfo.length; ++i2) {
            if (cmpInfo[i2].equals(outInfo[i2])) continue;
            message2 = "Document info fail";
            break;
        }
        outReader.close();
        cmpReader.close();
        if (message2 == null) {
            System.out.println("OK");
        } else {
            System.out.println("Fail");
        }
        System.out.flush();
        return message2;
    }

    private boolean linksAreSame(PdfAnnotation.PdfImportedLink cmpLink, PdfAnnotation.PdfImportedLink outLink) {
        if (cmpLink.getDestinationPage() != outLink.getDestinationPage()) {
            return false;
        }
        if (!cmpLink.getRect().toString().equals(outLink.getRect().toString())) {
            return false;
        }
        Map<PdfName, PdfObject> cmpParams = cmpLink.getParameters();
        Map<PdfName, PdfObject> outParams = outLink.getParameters();
        if (cmpParams.size() != outParams.size()) {
            return false;
        }
        for (Map.Entry<PdfName, PdfObject> cmpEntry : cmpParams.entrySet()) {
            PdfObject cmpObj = cmpEntry.getValue();
            if (!outParams.containsKey(cmpEntry.getKey())) {
                return false;
            }
            PdfObject outObj = outParams.get(cmpEntry.getKey());
            if (cmpObj.type() != outObj.type()) {
                return false;
            }
            switch (cmpObj.type()) {
                case 1: 
                case 2: 
                case 3: 
                case 4: 
                case 8: {
                    if (cmpObj.toString().equals(outObj.toString())) break;
                    return false;
                }
            }
        }
        return true;
    }

    public String compareLinks(String outPdf, String cmpPdf) throws IOException {
        System.out.print("[itext] INFO  Comparing link annotations....");
        String message2 = null;
        PdfReader outReader = new PdfReader(outPdf);
        PdfReader cmpReader = new PdfReader(cmpPdf);
        block0: for (int i2 = 0; i2 < outReader.getNumberOfPages() && i2 < cmpReader.getNumberOfPages(); ++i2) {
            ArrayList<PdfAnnotation.PdfImportedLink> outLinks = outReader.getLinks(i2 + 1);
            ArrayList<PdfAnnotation.PdfImportedLink> cmpLinks = cmpReader.getLinks(i2 + 1);
            if (cmpLinks.size() != outLinks.size()) {
                message2 = String.format("Different number of links on page %d.", i2 + 1);
                break;
            }
            for (int j2 = 0; j2 < cmpLinks.size(); ++j2) {
                if (this.linksAreSame((PdfAnnotation.PdfImportedLink)cmpLinks.get(j2), (PdfAnnotation.PdfImportedLink)outLinks.get(j2))) continue;
                message2 = String.format("Different links on page %d.\n%s\n%s", i2 + 1, ((PdfAnnotation.PdfImportedLink)cmpLinks.get(j2)).toString(), ((PdfAnnotation.PdfImportedLink)outLinks.get(j2)).toString());
                continue block0;
            }
        }
        outReader.close();
        cmpReader.close();
        if (message2 == null) {
            System.out.println("OK");
        } else {
            System.out.println("Fail");
        }
        System.out.flush();
        return message2;
    }

    public String compareTagStructures(String outPdf, String cmpPdf) throws IOException, ParserConfigurationException, SAXException {
        System.out.print("[itext] INFO  Comparing tag structures......");
        String outXml = outPdf.replace(".pdf", ".xml");
        String cmpXml = outPdf.replace(".pdf", ".cmp.xml");
        String message2 = null;
        PdfReader reader = new PdfReader(outPdf);
        FileOutputStream xmlOut1 = new FileOutputStream(outXml);
        new CmpTaggedPdfReaderTool().convertToXml(reader, xmlOut1);
        reader.close();
        reader = new PdfReader(cmpPdf);
        FileOutputStream xmlOut2 = new FileOutputStream(cmpXml);
        new CmpTaggedPdfReaderTool().convertToXml(reader, xmlOut2);
        reader.close();
        if (!this.compareXmls(outXml, cmpXml)) {
            message2 = "The tag structures are different.";
        }
        xmlOut1.close();
        xmlOut2.close();
        if (message2 == null) {
            System.out.println("OK");
        } else {
            System.out.println("Fail");
        }
        System.out.flush();
        return message2;
    }

    private String[] convertInfo(HashMap<String, String> info) {
        String[] convertedInfo = new String[]{"", "", "", ""};
        for (Map.Entry<String, String> entry : info.entrySet()) {
            if ("title".equalsIgnoreCase(entry.getKey())) {
                convertedInfo[0] = entry.getValue();
                continue;
            }
            if ("author".equalsIgnoreCase(entry.getKey())) {
                convertedInfo[1] = entry.getValue();
                continue;
            }
            if ("subject".equalsIgnoreCase(entry.getKey())) {
                convertedInfo[2] = entry.getValue();
                continue;
            }
            if (!"keywords".equalsIgnoreCase(entry.getKey())) continue;
            convertedInfo[3] = entry.getValue();
        }
        return convertedInfo;
    }

    public boolean compareXmls(String xml1, String xml2) throws ParserConfigurationException, SAXException, IOException {
        DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
        dbf.setNamespaceAware(true);
        dbf.setCoalescing(true);
        dbf.setIgnoringElementContentWhitespace(true);
        dbf.setIgnoringComments(true);
        DocumentBuilder db = dbf.newDocumentBuilder();
        Document doc1 = db.parse(new File(xml1));
        doc1.normalizeDocument();
        Document doc2 = db.parse(new File(xml2));
        doc2.normalizeDocument();
        return doc2.isEqualNode(doc1);
    }

    private void init(String outPdf, String cmpPdf) {
        this.outPdf = outPdf;
        this.cmpPdf = cmpPdf;
        this.outPdfName = new File(outPdf).getName();
        this.cmpPdfName = new File(cmpPdf).getName();
        this.outImage = this.outPdfName + "-%03d.png";
        this.cmpImage = this.cmpPdfName.startsWith("cmp_") ? this.cmpPdfName + "-%03d.png" : "cmp_" + this.cmpPdfName + "-%03d.png";
    }

    private boolean compareStreams(InputStream is1, InputStream is2) throws IOException {
        int len1;
        byte[] buffer1 = new byte[65536];
        byte[] buffer2 = new byte[65536];
        do {
            int len2;
            if ((len1 = is1.read(buffer1)) != (len2 = is2.read(buffer2))) {
                return false;
            }
            if (Arrays.equals(buffer1, buffer2)) continue;
            return false;
        } while (len1 != -1);
        return true;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class CmpMarkedContentRenderFilter
    implements RenderListener {
        Map<Integer, TextExtractionStrategy> tagsByMcid = new HashMap<Integer, TextExtractionStrategy>();

        CmpMarkedContentRenderFilter() {
        }

        public Map<Integer, String> getParsedTagContent() {
            HashMap<Integer, String> content = new HashMap<Integer, String>();
            for (int id : this.tagsByMcid.keySet()) {
                content.put(id, this.tagsByMcid.get(id).getResultantText());
            }
            return content;
        }

        @Override
        public void beginTextBlock() {
            for (int id : this.tagsByMcid.keySet()) {
                this.tagsByMcid.get(id).beginTextBlock();
            }
        }

        @Override
        public void renderText(TextRenderInfo renderInfo) {
            Integer mcid = renderInfo.getMcid();
            if (mcid != null && this.tagsByMcid.containsKey(mcid)) {
                this.tagsByMcid.get(mcid).renderText(renderInfo);
            } else if (mcid != null) {
                this.tagsByMcid.put(mcid, new SimpleTextExtractionStrategy());
                this.tagsByMcid.get(mcid).renderText(renderInfo);
            }
        }

        @Override
        public void endTextBlock() {
            for (int id : this.tagsByMcid.keySet()) {
                this.tagsByMcid.get(id).endTextBlock();
            }
        }

        @Override
        public void renderImage(ImageRenderInfo renderInfo) {
        }
    }

    class CmpTaggedPdfReaderTool
    extends TaggedPdfReaderTool {
        Map<PdfDictionary, Map<Integer, String>> parsedTags = new HashMap<PdfDictionary, Map<Integer, String>>();

        CmpTaggedPdfReaderTool() {
        }

        public void parseTag(String tag, PdfObject object, PdfDictionary page) throws IOException {
            if (object instanceof PdfNumber) {
                if (!this.parsedTags.containsKey(page)) {
                    CmpMarkedContentRenderFilter listener2 = new CmpMarkedContentRenderFilter();
                    PdfContentStreamProcessor processor = new PdfContentStreamProcessor(listener2);
                    processor.processContent(PdfReader.getPageContent(page), page.getAsDict(PdfName.RESOURCES));
                    this.parsedTags.put(page, listener2.getParsedTagContent());
                }
                String tagContent = "";
                if (this.parsedTags.get(page).containsKey(((PdfNumber)object).intValue())) {
                    tagContent = this.parsedTags.get(page).get(((PdfNumber)object).intValue());
                }
                this.out.print(XMLUtil.escapeXML(tagContent, true));
            } else {
                super.parseTag(tag, object, page);
            }
        }

        public void inspectChildDictionary(PdfDictionary k2) throws IOException {
            this.inspectChildDictionary(k2, true);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class ImageNameComparator
    implements Comparator<File> {
        ImageNameComparator() {
        }

        @Override
        public int compare(File f1, File f2) {
            String f1Name = f1.getAbsolutePath();
            String f2Name = f2.getAbsolutePath();
            return f1Name.compareTo(f2Name);
        }
    }

    class CmpPngFileFilter
    implements FileFilter {
        CmpPngFileFilter() {
        }

        public boolean accept(File pathname) {
            String ap = pathname.getAbsolutePath();
            boolean b1 = ap.endsWith(".png");
            boolean b2 = ap.contains("cmp_");
            return b1 && b2 && ap.contains(CompareTool.this.cmpPdfName);
        }
    }

    class PngFileFilter
    implements FileFilter {
        PngFileFilter() {
        }

        public boolean accept(File pathname) {
            String ap = pathname.getAbsolutePath();
            boolean b1 = ap.endsWith(".png");
            boolean b2 = ap.contains("cmp_");
            return b1 && !b2 && ap.contains(CompareTool.this.outPdfName);
        }
    }

    protected class CompareResult {
        protected Map<ObjectPath, String> differences = new LinkedHashMap<ObjectPath, String>();
        protected int messageLimit = 1;

        public CompareResult(int messageLimit) {
            this.messageLimit = messageLimit;
        }

        public boolean isOk() {
            return this.differences.size() == 0;
        }

        public int getErrorCount() {
            return this.differences.size();
        }

        protected boolean isMessageLimitReached() {
            return this.differences.size() >= this.messageLimit;
        }

        public String getReport() {
            StringBuilder sb = new StringBuilder();
            boolean firstEntry = true;
            for (Map.Entry<ObjectPath, String> entry : this.differences.entrySet()) {
                if (!firstEntry) {
                    sb.append("-----------------------------").append("\n");
                }
                ObjectPath diffPath = entry.getKey();
                sb.append(entry.getValue()).append("\n").append(diffPath.toString()).append("\n");
                firstEntry = false;
            }
            return sb.toString();
        }

        protected void addError(ObjectPath path2, String message2) {
            if (this.differences.size() < this.messageLimit) {
                this.differences.put((ObjectPath)path2.clone(), message2);
            }
        }

        public void writeReportToXml(OutputStream stream) throws ParserConfigurationException, TransformerException {
            Document xmlReport = DocumentBuilderFactory.newInstance().newDocumentBuilder().newDocument();
            Element root2 = xmlReport.createElement("report");
            Element errors = xmlReport.createElement("errors");
            errors.setAttribute("count", String.valueOf(this.differences.size()));
            root2.appendChild(errors);
            for (Map.Entry<ObjectPath, String> entry : this.differences.entrySet()) {
                Element errorNode = xmlReport.createElement("error");
                Element message2 = xmlReport.createElement("message");
                message2.appendChild(xmlReport.createTextNode(entry.getValue()));
                Node path2 = entry.getKey().toXmlNode(xmlReport);
                errorNode.appendChild(message2);
                errorNode.appendChild(path2);
                errors.appendChild(errorNode);
            }
            xmlReport.appendChild(root2);
            TransformerFactory tFactory = TransformerFactory.newInstance();
            Transformer transformer = tFactory.newTransformer();
            transformer.setOutputProperty("indent", "yes");
            DOMSource source = new DOMSource(xmlReport);
            StreamResult result2 = new StreamResult(stream);
            transformer.transform(source, result2);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class ObjectPath {
        protected RefKey baseCmpObject;
        protected RefKey baseOutObject;
        protected Stack<PathItem> path = new Stack();
        protected Stack<Pair<RefKey>> indirects = new Stack();

        public ObjectPath() {
        }

        protected ObjectPath(RefKey baseCmpObject, RefKey baseOutObject) {
            this.baseCmpObject = baseCmpObject;
            this.baseOutObject = baseOutObject;
        }

        private ObjectPath(RefKey baseCmpObject, RefKey baseOutObject, Stack<PathItem> path2) {
            this.baseCmpObject = baseCmpObject;
            this.baseOutObject = baseOutObject;
            this.path = path2;
        }

        public ObjectPath resetDirectPath(RefKey baseCmpObject, RefKey baseOutObject) {
            ObjectPath newPath = new ObjectPath(baseCmpObject, baseOutObject);
            newPath.indirects = (Stack)this.indirects.clone();
            newPath.indirects.add(new Pair<RefKey>(baseCmpObject, baseOutObject));
            return newPath;
        }

        public boolean isComparing(RefKey baseCmpObject, RefKey baseOutObject) {
            return this.indirects.contains(new Pair<RefKey>(baseCmpObject, baseOutObject));
        }

        public void pushArrayItemToPath(int index) {
            this.path.add(new ArrayPathItem(index));
        }

        public void pushDictItemToPath(String key2) {
            this.path.add(new DictPathItem(key2));
        }

        public void pushOffsetToPath(int offset) {
            this.path.add(new OffsetPathItem(offset));
        }

        public void pop() {
            this.path.pop();
        }

        public String toString() {
            StringBuilder sb = new StringBuilder();
            sb.append(String.format("Base cmp object: %s obj. Base out object: %s obj", this.baseCmpObject, this.baseOutObject));
            for (PathItem pathItem : this.path) {
                sb.append("\n");
                sb.append(pathItem.toString());
            }
            return sb.toString();
        }

        public int hashCode() {
            int hashCode1 = this.baseCmpObject != null ? this.baseCmpObject.hashCode() : 1;
            int hashCode2 = this.baseOutObject != null ? this.baseOutObject.hashCode() : 1;
            int hashCode3 = hashCode1 * 31 + hashCode2;
            for (PathItem pathItem : this.path) {
                hashCode3 *= 31;
                hashCode3 += pathItem.hashCode();
            }
            return hashCode3;
        }

        public boolean equals(Object obj) {
            return obj instanceof ObjectPath && this.baseCmpObject.equals(((ObjectPath)obj).baseCmpObject) && this.baseOutObject.equals(((ObjectPath)obj).baseOutObject) && this.path.equals(((ObjectPath)obj).path);
        }

        protected Object clone() {
            return new ObjectPath(this.baseCmpObject, this.baseOutObject, (Stack)this.path.clone());
        }

        public Node toXmlNode(Document document) {
            Element element = document.createElement("path");
            Element baseNode = document.createElement("base");
            baseNode.setAttribute("cmp", this.baseCmpObject.toString() + " obj");
            baseNode.setAttribute("out", this.baseOutObject.toString() + " obj");
            element.appendChild(baseNode);
            for (PathItem pathItem : this.path) {
                element.appendChild(pathItem.toXmlNode(document));
            }
            return element;
        }

        private class OffsetPathItem
        extends PathItem {
            int offset;

            public OffsetPathItem(int offset) {
                this.offset = offset;
            }

            public String toString() {
                return "Offset: " + String.valueOf(this.offset);
            }

            public int hashCode() {
                return this.offset;
            }

            public boolean equals(Object obj) {
                return obj instanceof OffsetPathItem && this.offset == ((OffsetPathItem)obj).offset;
            }

            protected Node toXmlNode(Document document) {
                Element element = document.createElement("offset");
                element.appendChild(document.createTextNode(String.valueOf(this.offset)));
                return element;
            }
        }

        private class ArrayPathItem
        extends PathItem {
            int index;

            public ArrayPathItem(int index) {
                this.index = index;
            }

            public String toString() {
                return "Array index: " + String.valueOf(this.index);
            }

            public int hashCode() {
                return this.index;
            }

            public boolean equals(Object obj) {
                return obj instanceof ArrayPathItem && this.index == ((ArrayPathItem)obj).index;
            }

            protected Node toXmlNode(Document document) {
                Element element = document.createElement("arrayIndex");
                element.appendChild(document.createTextNode(String.valueOf(this.index)));
                return element;
            }
        }

        private class DictPathItem
        extends PathItem {
            String key;

            public DictPathItem(String key2) {
                this.key = key2;
            }

            public String toString() {
                return "Dict key: " + this.key;
            }

            public int hashCode() {
                return this.key.hashCode();
            }

            public boolean equals(Object obj) {
                return obj instanceof DictPathItem && this.key.equals(((DictPathItem)obj).key);
            }

            protected Node toXmlNode(Document document) {
                Element element = document.createElement("dictKey");
                element.appendChild(document.createTextNode(this.key));
                return element;
            }
        }

        private abstract class PathItem {
            private PathItem() {
            }

            protected abstract Node toXmlNode(Document var1);
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        private class Pair<T> {
            private T first;
            private T second;

            public Pair(T first, T second) {
                this.first = first;
                this.second = second;
            }

            public int hashCode() {
                return this.first.hashCode() * 31 + this.second.hashCode();
            }

            public boolean equals(Object obj) {
                return obj instanceof Pair && this.first.equals(((Pair)obj).first) && this.second.equals(((Pair)obj).second);
            }
        }
    }
}

