/*
 * Decompiled with CFR 0.152.
 */
package org.xhtmlrenderer.simple.xhtml;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import org.w3c.dom.Element;
import org.xhtmlrenderer.simple.extend.URLUTF8Encoder;
import org.xhtmlrenderer.simple.xhtml.FormControl;
import org.xhtmlrenderer.simple.xhtml.FormListener;
import org.xhtmlrenderer.simple.xhtml.controls.ButtonControl;
import org.xhtmlrenderer.simple.xhtml.controls.CheckControl;
import org.xhtmlrenderer.simple.xhtml.controls.HiddenControl;
import org.xhtmlrenderer.simple.xhtml.controls.SelectControl;
import org.xhtmlrenderer.simple.xhtml.controls.TextControl;

public class XhtmlForm {
    protected String _action;
    protected String _method;
    protected List _controls = new LinkedList();
    private List _listeners = new ArrayList();

    public XhtmlForm(String action2, String method) {
        this._action = action2;
        this._method = method;
    }

    public void addFormListener(FormListener listener2) {
        this._listeners.add(listener2);
    }

    public void removeFormListener(FormListener listener2) {
        this._listeners.remove(listener2);
    }

    public FormControl getControl(String name) {
        for (FormControl control : this._controls) {
            if (!control.getName().equals(name)) continue;
            return control;
        }
        return null;
    }

    public List getAllControls(String name) {
        ArrayList<FormControl> result2 = new ArrayList<FormControl>();
        for (FormControl control : this._controls) {
            if (!control.getName().equals(name)) continue;
            result2.add(control);
        }
        return result2;
    }

    public Iterator getControls() {
        return this._controls.iterator();
    }

    public FormControl createControl(Element e2) {
        return XhtmlForm.createControl(this, e2);
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static FormControl createControl(XhtmlForm form2, Element e2) {
        void var2_12;
        if (e2 == null) {
            return null;
        }
        String name = e2.getNodeName();
        if (name.equals("input")) {
            String type2 = e2.getAttribute("type");
            if (type2.equals("text") || type2.equals("password")) {
                TextControl textControl = new TextControl(form2, e2);
            } else if (type2.equals("hidden")) {
                HiddenControl hiddenControl = new HiddenControl(form2, e2);
            } else if (type2.equals("button") || type2.equals("submit") || type2.equals("reset")) {
                ButtonControl buttonControl = new ButtonControl(form2, e2);
            } else {
                if (!type2.equals("checkbox") && !type2.equals("radio")) return null;
                CheckControl checkControl = new CheckControl(form2, e2);
            }
        } else if (name.equals("textarea")) {
            TextControl textControl = new TextControl(form2, e2);
        } else if (name.equals("button")) {
            ButtonControl buttonControl = new ButtonControl(form2, e2);
        } else {
            if (!name.equals("select")) return null;
            SelectControl selectControl = new SelectControl(form2, e2);
        }
        if (form2 == null) return var2_12;
        form2._controls.add(var2_12);
        return var2_12;
    }

    public void reset() {
        Iterator iter = this._listeners.iterator();
        while (iter.hasNext()) {
            ((FormListener)iter.next()).resetted(this);
        }
    }

    public void submit() {
        StringBuffer data2 = new StringBuffer();
        Iterator iter = this.getControls();
        while (iter.hasNext()) {
            FormControl control = (FormControl)iter.next();
            if (!control.isSuccessful()) continue;
            if (control.isMultiple()) {
                String[] values2 = control.getMultipleValues();
                for (int i2 = 0; i2 < values2.length; ++i2) {
                    if (data2.length() > 0) {
                        data2.append('&');
                    }
                    data2.append(URLUTF8Encoder.encode(control.getName()));
                    data2.append('=');
                    data2.append(URLUTF8Encoder.encode(values2[i2]));
                }
                continue;
            }
            if (data2.length() > 0) {
                data2.append('&');
            }
            data2.append(URLUTF8Encoder.encode(control.getName()));
            data2.append('=');
            data2.append(URLUTF8Encoder.encode(control.getValue()));
        }
        System.out.println("Form submitted!");
        System.out.println("Action: ".concat(this._action));
        System.out.println("Method: ".concat(this._method));
        System.out.println("Data: ".concat(data2.toString()));
        iter = this._listeners.iterator();
        while (iter.hasNext()) {
            ((FormListener)iter.next()).submitted(this);
        }
    }
}

