/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.dnd;

import org.eclipse.swt.internal.C;
import org.eclipse.swt.internal.ole.win32.COM;
import org.eclipse.swt.internal.ole.win32.COMObject;
import org.eclipse.swt.internal.ole.win32.FORMATETC;
import org.eclipse.swt.internal.ole.win32.GUID;
import org.eclipse.swt.internal.win32.OS;

final class OleEnumFORMATETC {
    private COMObject iEnumFORMATETC;
    private int refCount;
    private int index;
    private FORMATETC[] formats;

    OleEnumFORMATETC() {
        this.createCOMInterfaces();
    }

    int AddRef() {
        ++this.refCount;
        return this.refCount;
    }

    private void createCOMInterfaces() {
        int[] nArray = new int[7];
        nArray[0] = 2;
        nArray[3] = 3;
        nArray[4] = 1;
        nArray[6] = 1;
        this.iEnumFORMATETC = new COMObject(nArray){

            @Override
            public long method0(long[] args2) {
                return OleEnumFORMATETC.this.QueryInterface(args2[0], args2[1]);
            }

            @Override
            public long method1(long[] args2) {
                return OleEnumFORMATETC.this.AddRef();
            }

            @Override
            public long method2(long[] args2) {
                return OleEnumFORMATETC.this.Release();
            }

            @Override
            public long method3(long[] args2) {
                return OleEnumFORMATETC.this.Next((int)args2[0], args2[1], args2[2]);
            }

            @Override
            public long method4(long[] args2) {
                return OleEnumFORMATETC.this.Skip((int)args2[0]);
            }

            @Override
            public long method5(long[] args2) {
                return OleEnumFORMATETC.this.Reset();
            }
        };
    }

    private void disposeCOMInterfaces() {
        if (this.iEnumFORMATETC != null) {
            this.iEnumFORMATETC.dispose();
        }
        this.iEnumFORMATETC = null;
    }

    long getAddress() {
        return this.iEnumFORMATETC.getAddress();
    }

    private FORMATETC[] getNextItems(int numItems) {
        if (this.formats == null || numItems < 1) {
            return null;
        }
        int endIndex = this.index + numItems - 1;
        if (endIndex > this.formats.length - 1) {
            endIndex = this.formats.length - 1;
        }
        if (this.index > endIndex) {
            return null;
        }
        FORMATETC[] items = new FORMATETC[endIndex - this.index + 1];
        int i2 = 0;
        while (i2 < items.length) {
            items[i2] = this.formats[this.index];
            ++this.index;
            ++i2;
        }
        return items;
    }

    private int Next(int celt, long rgelt, long pceltFetched) {
        if (rgelt == 0L) {
            return -2147024809;
        }
        if (pceltFetched == 0L && celt != 1) {
            return -2147024809;
        }
        FORMATETC[] nextItems = this.getNextItems(celt);
        if (nextItems != null) {
            int i2 = 0;
            while (i2 < nextItems.length) {
                COM.MoveMemory(rgelt + (long)(i2 * FORMATETC.sizeof), nextItems[i2], FORMATETC.sizeof);
                ++i2;
            }
            if (pceltFetched != 0L) {
                OS.MoveMemory(pceltFetched, new int[]{nextItems.length}, 4);
            }
            if (nextItems.length == celt) {
                return 0;
            }
        } else {
            if (pceltFetched != 0L) {
                OS.MoveMemory(pceltFetched, new int[1], 4);
            }
            COM.MoveMemory(rgelt, new FORMATETC(), FORMATETC.sizeof);
        }
        return 1;
    }

    private int QueryInterface(long riid, long ppvObject) {
        if (riid == 0L || ppvObject == 0L) {
            return -2147467262;
        }
        GUID guid = new GUID();
        COM.MoveMemory(guid, riid, GUID.sizeof);
        if (COM.IsEqualGUID(guid, COM.IIDIUnknown) || COM.IsEqualGUID(guid, COM.IIDIEnumFORMATETC)) {
            OS.MoveMemory(ppvObject, new long[]{this.iEnumFORMATETC.getAddress()}, C.PTR_SIZEOF);
            this.AddRef();
            return 0;
        }
        OS.MoveMemory(ppvObject, new long[1], C.PTR_SIZEOF);
        return -2147467262;
    }

    int Release() {
        --this.refCount;
        if (this.refCount == 0) {
            this.disposeCOMInterfaces();
            if (COM.FreeUnusedLibraries) {
                COM.CoFreeUnusedLibraries();
            }
        }
        return this.refCount;
    }

    private int Reset() {
        this.index = 0;
        return 0;
    }

    void setFormats(FORMATETC[] newFormats) {
        this.formats = newFormats;
        this.index = 0;
    }

    private int Skip(int celt) {
        if (celt < 1) {
            return -2147024809;
        }
        this.index += celt;
        if (this.index > this.formats.length - 1) {
            this.index = this.formats.length - 1;
            return 1;
        }
        return 0;
    }
}

