/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.math3.optimization.direct;

import org.apache.commons.math3.analysis.MultivariateFunction;
import org.apache.commons.math3.analysis.UnivariateFunction;
import org.apache.commons.math3.analysis.function.Logit;
import org.apache.commons.math3.analysis.function.Sigmoid;
import org.apache.commons.math3.exception.DimensionMismatchException;
import org.apache.commons.math3.exception.NumberIsTooSmallException;
import org.apache.commons.math3.util.FastMath;
import org.apache.commons.math3.util.MathUtils;

@Deprecated
public class MultivariateFunctionMappingAdapter
implements MultivariateFunction {
    private final MultivariateFunction bounded;
    private final Mapper[] mappers;

    public MultivariateFunctionMappingAdapter(MultivariateFunction bounded, double[] lower, double[] upper) {
        int i2;
        MathUtils.checkNotNull(lower);
        MathUtils.checkNotNull(upper);
        if (lower.length != upper.length) {
            throw new DimensionMismatchException(lower.length, upper.length);
        }
        for (i2 = 0; i2 < lower.length; ++i2) {
            if (upper[i2] >= lower[i2]) continue;
            throw new NumberIsTooSmallException(upper[i2], (Number)lower[i2], true);
        }
        this.bounded = bounded;
        this.mappers = new Mapper[lower.length];
        for (i2 = 0; i2 < this.mappers.length; ++i2) {
            if (Double.isInfinite(lower[i2])) {
                if (Double.isInfinite(upper[i2])) {
                    this.mappers[i2] = new NoBoundsMapper();
                    continue;
                }
                this.mappers[i2] = new UpperBoundMapper(upper[i2]);
                continue;
            }
            this.mappers[i2] = Double.isInfinite(upper[i2]) ? new LowerBoundMapper(lower[i2]) : new LowerUpperBoundMapper(lower[i2], upper[i2]);
        }
    }

    public double[] unboundedToBounded(double[] point) {
        double[] mapped = new double[this.mappers.length];
        for (int i2 = 0; i2 < this.mappers.length; ++i2) {
            mapped[i2] = this.mappers[i2].unboundedToBounded(point[i2]);
        }
        return mapped;
    }

    public double[] boundedToUnbounded(double[] point) {
        double[] mapped = new double[this.mappers.length];
        for (int i2 = 0; i2 < this.mappers.length; ++i2) {
            mapped[i2] = this.mappers[i2].boundedToUnbounded(point[i2]);
        }
        return mapped;
    }

    public double value(double[] point) {
        return this.bounded.value(this.unboundedToBounded(point));
    }

    private static class LowerUpperBoundMapper
    implements Mapper {
        private final UnivariateFunction boundingFunction;
        private final UnivariateFunction unboundingFunction;

        LowerUpperBoundMapper(double lower, double upper) {
            this.boundingFunction = new Sigmoid(lower, upper);
            this.unboundingFunction = new Logit(lower, upper);
        }

        public double unboundedToBounded(double y2) {
            return this.boundingFunction.value(y2);
        }

        public double boundedToUnbounded(double x2) {
            return this.unboundingFunction.value(x2);
        }
    }

    private static class UpperBoundMapper
    implements Mapper {
        private final double upper;

        UpperBoundMapper(double upper) {
            this.upper = upper;
        }

        public double unboundedToBounded(double y2) {
            return this.upper - FastMath.exp(-y2);
        }

        public double boundedToUnbounded(double x2) {
            return -FastMath.log(this.upper - x2);
        }
    }

    private static class LowerBoundMapper
    implements Mapper {
        private final double lower;

        LowerBoundMapper(double lower) {
            this.lower = lower;
        }

        public double unboundedToBounded(double y2) {
            return this.lower + FastMath.exp(y2);
        }

        public double boundedToUnbounded(double x2) {
            return FastMath.log(x2 - this.lower);
        }
    }

    private static class NoBoundsMapper
    implements Mapper {
        NoBoundsMapper() {
        }

        public double unboundedToBounded(double y2) {
            return y2;
        }

        public double boundedToUnbounded(double x2) {
            return x2;
        }
    }

    private static interface Mapper {
        public double unboundedToBounded(double var1);

        public double boundedToUnbounded(double var1);
    }
}

