/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.math3.optim.linear;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.TreeSet;
import org.apache.commons.math3.linear.Array2DRowRealMatrix;
import org.apache.commons.math3.linear.MatrixUtils;
import org.apache.commons.math3.linear.RealVector;
import org.apache.commons.math3.optim.PointValuePair;
import org.apache.commons.math3.optim.linear.LinearConstraint;
import org.apache.commons.math3.optim.linear.LinearObjectiveFunction;
import org.apache.commons.math3.optim.linear.Relationship;
import org.apache.commons.math3.optim.nonlinear.scalar.GoalType;
import org.apache.commons.math3.util.Precision;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class SimplexTableau
implements Serializable {
    private static final String NEGATIVE_VAR_COLUMN_LABEL = "x-";
    private static final long serialVersionUID = -1369660067587938365L;
    private final LinearObjectiveFunction f;
    private final List<LinearConstraint> constraints;
    private final boolean restrictToNonNegative;
    private final List<String> columnLabels = new ArrayList<String>();
    private transient Array2DRowRealMatrix tableau;
    private final int numDecisionVariables;
    private final int numSlackVariables;
    private int numArtificialVariables;
    private final double epsilon;
    private final int maxUlps;
    private int[] basicVariables;
    private int[] basicRows;

    SimplexTableau(LinearObjectiveFunction f2, Collection<LinearConstraint> constraints, GoalType goalType, boolean restrictToNonNegative, double epsilon) {
        this(f2, constraints, goalType, restrictToNonNegative, epsilon, 10);
    }

    SimplexTableau(LinearObjectiveFunction f2, Collection<LinearConstraint> constraints, GoalType goalType, boolean restrictToNonNegative, double epsilon, int maxUlps) {
        this.f = f2;
        this.constraints = this.normalizeConstraints(constraints);
        this.restrictToNonNegative = restrictToNonNegative;
        this.epsilon = epsilon;
        this.maxUlps = maxUlps;
        this.numDecisionVariables = f2.getCoefficients().getDimension() + (restrictToNonNegative ? 0 : 1);
        this.numSlackVariables = this.getConstraintTypeCounts(Relationship.LEQ) + this.getConstraintTypeCounts(Relationship.GEQ);
        this.numArtificialVariables = this.getConstraintTypeCounts(Relationship.EQ) + this.getConstraintTypeCounts(Relationship.GEQ);
        this.tableau = this.createTableau(goalType == GoalType.MAXIMIZE);
        this.initializeBasicVariables(this.getSlackVariableOffset());
        this.initializeColumnLabels();
    }

    protected void initializeColumnLabels() {
        int i2;
        if (this.getNumObjectiveFunctions() == 2) {
            this.columnLabels.add("W");
        }
        this.columnLabels.add("Z");
        for (i2 = 0; i2 < this.getOriginalNumDecisionVariables(); ++i2) {
            this.columnLabels.add("x" + i2);
        }
        if (!this.restrictToNonNegative) {
            this.columnLabels.add(NEGATIVE_VAR_COLUMN_LABEL);
        }
        for (i2 = 0; i2 < this.getNumSlackVariables(); ++i2) {
            this.columnLabels.add("s" + i2);
        }
        for (i2 = 0; i2 < this.getNumArtificialVariables(); ++i2) {
            this.columnLabels.add("a" + i2);
        }
        this.columnLabels.add("RHS");
    }

    protected Array2DRowRealMatrix createTableau(boolean maximize) {
        int width = this.numDecisionVariables + this.numSlackVariables + this.numArtificialVariables + this.getNumObjectiveFunctions() + 1;
        int height = this.constraints.size() + this.getNumObjectiveFunctions();
        Array2DRowRealMatrix matrix = new Array2DRowRealMatrix(height, width);
        if (this.getNumObjectiveFunctions() == 2) {
            matrix.setEntry(0, 0, -1.0);
        }
        int zIndex = this.getNumObjectiveFunctions() == 1 ? 0 : 1;
        matrix.setEntry(zIndex, zIndex, maximize ? 1.0 : -1.0);
        RealVector objectiveCoefficients = maximize ? this.f.getCoefficients().mapMultiply(-1.0) : this.f.getCoefficients();
        this.copyArray(objectiveCoefficients.toArray(), matrix.getDataRef()[zIndex]);
        matrix.setEntry(zIndex, width - 1, maximize ? this.f.getConstantTerm() : -1.0 * this.f.getConstantTerm());
        if (!this.restrictToNonNegative) {
            matrix.setEntry(zIndex, this.getSlackVariableOffset() - 1, SimplexTableau.getInvertedCoefficientSum(objectiveCoefficients));
        }
        int slackVar = 0;
        int artificialVar = 0;
        for (int i2 = 0; i2 < this.constraints.size(); ++i2) {
            LinearConstraint constraint = this.constraints.get(i2);
            int row2 = this.getNumObjectiveFunctions() + i2;
            this.copyArray(constraint.getCoefficients().toArray(), matrix.getDataRef()[row2]);
            if (!this.restrictToNonNegative) {
                matrix.setEntry(row2, this.getSlackVariableOffset() - 1, SimplexTableau.getInvertedCoefficientSum(constraint.getCoefficients()));
            }
            matrix.setEntry(row2, width - 1, constraint.getValue());
            if (constraint.getRelationship() == Relationship.LEQ) {
                matrix.setEntry(row2, this.getSlackVariableOffset() + slackVar++, 1.0);
            } else if (constraint.getRelationship() == Relationship.GEQ) {
                matrix.setEntry(row2, this.getSlackVariableOffset() + slackVar++, -1.0);
            }
            if (constraint.getRelationship() != Relationship.EQ && constraint.getRelationship() != Relationship.GEQ) continue;
            matrix.setEntry(0, this.getArtificialVariableOffset() + artificialVar, 1.0);
            matrix.setEntry(row2, this.getArtificialVariableOffset() + artificialVar++, 1.0);
            matrix.setRowVector(0, matrix.getRowVector(0).subtract(matrix.getRowVector(row2)));
        }
        return matrix;
    }

    public List<LinearConstraint> normalizeConstraints(Collection<LinearConstraint> originalConstraints) {
        ArrayList<LinearConstraint> normalized = new ArrayList<LinearConstraint>(originalConstraints.size());
        for (LinearConstraint constraint : originalConstraints) {
            normalized.add(this.normalize(constraint));
        }
        return normalized;
    }

    private LinearConstraint normalize(LinearConstraint constraint) {
        if (constraint.getValue() < 0.0) {
            return new LinearConstraint(constraint.getCoefficients().mapMultiply(-1.0), constraint.getRelationship().oppositeRelationship(), -1.0 * constraint.getValue());
        }
        return new LinearConstraint(constraint.getCoefficients(), constraint.getRelationship(), constraint.getValue());
    }

    protected final int getNumObjectiveFunctions() {
        return this.numArtificialVariables > 0 ? 2 : 1;
    }

    private int getConstraintTypeCounts(Relationship relationship) {
        int count = 0;
        for (LinearConstraint constraint : this.constraints) {
            if (constraint.getRelationship() != relationship) continue;
            ++count;
        }
        return count;
    }

    protected static double getInvertedCoefficientSum(RealVector coefficients) {
        double sum = 0.0;
        for (double coefficient : coefficients.toArray()) {
            sum -= coefficient;
        }
        return sum;
    }

    protected Integer getBasicRow(int col) {
        int row2 = this.basicVariables[col];
        return row2 == -1 ? null : Integer.valueOf(row2);
    }

    protected int getBasicVariable(int row2) {
        return this.basicRows[row2];
    }

    private void initializeBasicVariables(int startColumn) {
        this.basicVariables = new int[this.getWidth() - 1];
        this.basicRows = new int[this.getHeight()];
        Arrays.fill(this.basicVariables, -1);
        for (int i2 = startColumn; i2 < this.getWidth() - 1; ++i2) {
            Integer row2 = this.findBasicRow(i2);
            if (row2 == null) continue;
            this.basicVariables[i2] = row2;
            this.basicRows[row2.intValue()] = i2;
        }
    }

    private Integer findBasicRow(int col) {
        Integer row2 = null;
        for (int i2 = 0; i2 < this.getHeight(); ++i2) {
            double entry = this.getEntry(i2, col);
            if (Precision.equals(entry, 1.0, this.maxUlps) && row2 == null) {
                row2 = i2;
                continue;
            }
            if (Precision.equals(entry, 0.0, this.maxUlps)) continue;
            return null;
        }
        return row2;
    }

    protected void dropPhase1Objective() {
        int i2;
        if (this.getNumObjectiveFunctions() == 1) {
            return;
        }
        TreeSet<Integer> columnsToDrop = new TreeSet<Integer>();
        columnsToDrop.add(0);
        for (i2 = this.getNumObjectiveFunctions(); i2 < this.getArtificialVariableOffset(); ++i2) {
            double entry = this.getEntry(0, i2);
            if (Precision.compareTo(entry, 0.0, this.epsilon) <= 0) continue;
            columnsToDrop.add(i2);
        }
        for (i2 = 0; i2 < this.getNumArtificialVariables(); ++i2) {
            int col = i2 + this.getArtificialVariableOffset();
            if (this.getBasicRow(col) != null) continue;
            columnsToDrop.add(col);
        }
        double[][] matrix = new double[this.getHeight() - 1][this.getWidth() - columnsToDrop.size()];
        for (int i3 = 1; i3 < this.getHeight(); ++i3) {
            int col = 0;
            for (int j2 = 0; j2 < this.getWidth(); ++j2) {
                if (columnsToDrop.contains(j2)) continue;
                matrix[i3 - 1][col++] = this.getEntry(i3, j2);
            }
        }
        Integer[] drop = columnsToDrop.toArray(new Integer[columnsToDrop.size()]);
        for (int i4 = drop.length - 1; i4 >= 0; --i4) {
            this.columnLabels.remove(drop[i4]);
        }
        this.tableau = new Array2DRowRealMatrix(matrix);
        this.numArtificialVariables = 0;
        this.initializeBasicVariables(this.getNumObjectiveFunctions());
    }

    private void copyArray(double[] src, double[] dest) {
        System.arraycopy(src, 0, dest, this.getNumObjectiveFunctions(), src.length);
    }

    boolean isOptimal() {
        double[] objectiveFunctionRow = this.getRow(0);
        int end = this.getRhsOffset();
        for (int i2 = this.getNumObjectiveFunctions(); i2 < end; ++i2) {
            double entry = objectiveFunctionRow[i2];
            if (Precision.compareTo(entry, 0.0, this.epsilon) >= 0) continue;
            return false;
        }
        return true;
    }

    protected PointValuePair getSolution() {
        int negativeVarColumn = this.columnLabels.indexOf(NEGATIVE_VAR_COLUMN_LABEL);
        Integer negativeVarBasicRow = negativeVarColumn > 0 ? this.getBasicRow(negativeVarColumn) : null;
        double mostNegative = negativeVarBasicRow == null ? 0.0 : this.getEntry(negativeVarBasicRow, this.getRhsOffset());
        HashSet<Integer> usedBasicRows = new HashSet<Integer>();
        double[] coefficients = new double[this.getOriginalNumDecisionVariables()];
        for (int i2 = 0; i2 < coefficients.length; ++i2) {
            int colIndex = this.columnLabels.indexOf("x" + i2);
            if (colIndex < 0) {
                coefficients[i2] = 0.0;
                continue;
            }
            Integer basicRow = this.getBasicRow(colIndex);
            if (basicRow != null && basicRow == 0) {
                coefficients[i2] = 0.0;
                continue;
            }
            if (usedBasicRows.contains(basicRow)) {
                coefficients[i2] = 0.0 - (this.restrictToNonNegative ? 0.0 : mostNegative);
                continue;
            }
            usedBasicRows.add(basicRow);
            coefficients[i2] = (basicRow == null ? 0.0 : this.getEntry(basicRow, this.getRhsOffset())) - (this.restrictToNonNegative ? 0.0 : mostNegative);
        }
        return new PointValuePair(coefficients, this.f.value(coefficients));
    }

    protected void performRowOperations(int pivotCol, int pivotRow) {
        double pivotVal = this.getEntry(pivotRow, pivotCol);
        this.divideRow(pivotRow, pivotVal);
        for (int i2 = 0; i2 < this.getHeight(); ++i2) {
            double multiplier;
            if (i2 == pivotRow || (multiplier = this.getEntry(i2, pivotCol)) == 0.0) continue;
            this.subtractRow(i2, pivotRow, multiplier);
        }
        int previousBasicVariable = this.getBasicVariable(pivotRow);
        this.basicVariables[previousBasicVariable] = -1;
        this.basicVariables[pivotCol] = pivotRow;
        this.basicRows[pivotRow] = pivotCol;
    }

    protected void divideRow(int dividendRowIndex, double divisor) {
        double[] dividendRow = this.getRow(dividendRowIndex);
        int j2 = 0;
        while (j2 < this.getWidth()) {
            int n2 = j2++;
            dividendRow[n2] = dividendRow[n2] / divisor;
        }
    }

    protected void subtractRow(int minuendRowIndex, int subtrahendRowIndex, double multiplier) {
        double[] minuendRow = this.getRow(minuendRowIndex);
        double[] subtrahendRow = this.getRow(subtrahendRowIndex);
        for (int i2 = 0; i2 < this.getWidth(); ++i2) {
            int n2 = i2;
            minuendRow[n2] = minuendRow[n2] - subtrahendRow[i2] * multiplier;
        }
    }

    protected final int getWidth() {
        return this.tableau.getColumnDimension();
    }

    protected final int getHeight() {
        return this.tableau.getRowDimension();
    }

    protected final double getEntry(int row2, int column2) {
        return this.tableau.getEntry(row2, column2);
    }

    protected final void setEntry(int row2, int column2, double value) {
        this.tableau.setEntry(row2, column2, value);
    }

    protected final int getSlackVariableOffset() {
        return this.getNumObjectiveFunctions() + this.numDecisionVariables;
    }

    protected final int getArtificialVariableOffset() {
        return this.getNumObjectiveFunctions() + this.numDecisionVariables + this.numSlackVariables;
    }

    protected final int getRhsOffset() {
        return this.getWidth() - 1;
    }

    protected final int getNumDecisionVariables() {
        return this.numDecisionVariables;
    }

    protected final int getOriginalNumDecisionVariables() {
        return this.f.getCoefficients().getDimension();
    }

    protected final int getNumSlackVariables() {
        return this.numSlackVariables;
    }

    protected final int getNumArtificialVariables() {
        return this.numArtificialVariables;
    }

    protected final double[] getRow(int row2) {
        return this.tableau.getDataRef()[row2];
    }

    protected final double[][] getData() {
        return this.tableau.getData();
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (other instanceof SimplexTableau) {
            SimplexTableau rhs = (SimplexTableau)other;
            return this.restrictToNonNegative == rhs.restrictToNonNegative && this.numDecisionVariables == rhs.numDecisionVariables && this.numSlackVariables == rhs.numSlackVariables && this.numArtificialVariables == rhs.numArtificialVariables && this.epsilon == rhs.epsilon && this.maxUlps == rhs.maxUlps && this.f.equals(rhs.f) && this.constraints.equals(rhs.constraints) && this.tableau.equals(rhs.tableau);
        }
        return false;
    }

    public int hashCode() {
        return Boolean.valueOf(this.restrictToNonNegative).hashCode() ^ this.numDecisionVariables ^ this.numSlackVariables ^ this.numArtificialVariables ^ Double.valueOf(this.epsilon).hashCode() ^ this.maxUlps ^ this.f.hashCode() ^ this.constraints.hashCode() ^ this.tableau.hashCode();
    }

    private void writeObject(ObjectOutputStream oos) throws IOException {
        oos.defaultWriteObject();
        MatrixUtils.serializeRealMatrix(this.tableau, oos);
    }

    private void readObject(ObjectInputStream ois) throws ClassNotFoundException, IOException {
        ois.defaultReadObject();
        MatrixUtils.deserializeRealMatrix(this, "tableau", ois);
    }
}

