/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.math3.fitting.leastsquares;

import org.apache.commons.math3.exception.ConvergenceException;
import org.apache.commons.math3.exception.NullArgumentException;
import org.apache.commons.math3.exception.util.LocalizedFormats;
import org.apache.commons.math3.fitting.leastsquares.LeastSquaresOptimizer;
import org.apache.commons.math3.fitting.leastsquares.LeastSquaresProblem;
import org.apache.commons.math3.fitting.leastsquares.OptimumImpl;
import org.apache.commons.math3.linear.ArrayRealVector;
import org.apache.commons.math3.linear.CholeskyDecomposition;
import org.apache.commons.math3.linear.LUDecomposition;
import org.apache.commons.math3.linear.MatrixUtils;
import org.apache.commons.math3.linear.NonPositiveDefiniteMatrixException;
import org.apache.commons.math3.linear.QRDecomposition;
import org.apache.commons.math3.linear.RealMatrix;
import org.apache.commons.math3.linear.RealVector;
import org.apache.commons.math3.linear.SingularMatrixException;
import org.apache.commons.math3.linear.SingularValueDecomposition;
import org.apache.commons.math3.optim.ConvergenceChecker;
import org.apache.commons.math3.util.Incrementor;
import org.apache.commons.math3.util.Pair;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GaussNewtonOptimizer
implements LeastSquaresOptimizer {
    private static final double SINGULARITY_THRESHOLD = 1.0E-11;
    private final Decomposition decomposition;

    public GaussNewtonOptimizer() {
        this(Decomposition.QR);
    }

    public GaussNewtonOptimizer(Decomposition decomposition) {
        this.decomposition = decomposition;
    }

    public Decomposition getDecomposition() {
        return this.decomposition;
    }

    public GaussNewtonOptimizer withDecomposition(Decomposition newDecomposition) {
        return new GaussNewtonOptimizer(newDecomposition);
    }

    @Override
    public LeastSquaresOptimizer.Optimum optimize(LeastSquaresProblem lsp) {
        Incrementor evaluationCounter = lsp.getEvaluationCounter();
        Incrementor iterationCounter = lsp.getIterationCounter();
        ConvergenceChecker<LeastSquaresProblem.Evaluation> checker = lsp.getConvergenceChecker();
        if (checker == null) {
            throw new NullArgumentException();
        }
        RealVector currentPoint = lsp.getStart();
        LeastSquaresProblem.Evaluation current = null;
        while (true) {
            iterationCounter.incrementCount();
            LeastSquaresProblem.Evaluation previous = current;
            evaluationCounter.incrementCount();
            current = lsp.evaluate(currentPoint);
            RealVector currentResiduals = current.getResiduals();
            RealMatrix weightedJacobian = current.getJacobian();
            currentPoint = current.getPoint();
            if (previous != null && checker.converged(iterationCounter.getCount(), previous, current)) {
                return new OptimumImpl(current, evaluationCounter.getCount(), iterationCounter.getCount());
            }
            RealVector dX = this.decomposition.solve(weightedJacobian, currentResiduals);
            currentPoint = currentPoint.add(dX);
        }
    }

    public String toString() {
        return "GaussNewtonOptimizer{decomposition=" + (Object)((Object)this.decomposition) + '}';
    }

    private static Pair<RealMatrix, RealVector> computeNormalMatrix(RealMatrix jacobian, RealVector residuals) {
        int j2;
        int i2;
        int nR = jacobian.getRowDimension();
        int nC = jacobian.getColumnDimension();
        RealMatrix normal = MatrixUtils.createRealMatrix(nC, nC);
        ArrayRealVector jTr = new ArrayRealVector(nC);
        for (i2 = 0; i2 < nR; ++i2) {
            for (j2 = 0; j2 < nC; ++j2) {
                ((RealVector)jTr).setEntry(j2, ((RealVector)jTr).getEntry(j2) + residuals.getEntry(i2) * jacobian.getEntry(i2, j2));
            }
            for (int k2 = 0; k2 < nC; ++k2) {
                for (int l2 = k2; l2 < nC; ++l2) {
                    normal.setEntry(k2, l2, normal.getEntry(k2, l2) + jacobian.getEntry(i2, k2) * jacobian.getEntry(i2, l2));
                }
            }
        }
        for (i2 = 0; i2 < nC; ++i2) {
            for (j2 = 0; j2 < i2; ++j2) {
                normal.setEntry(i2, j2, normal.getEntry(j2, i2));
            }
        }
        return new Pair<RealMatrix, RealVector>(normal, jTr);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Decomposition {
        LU{

            protected RealVector solve(RealMatrix jacobian, RealVector residuals) {
                try {
                    Pair normalEquation = GaussNewtonOptimizer.computeNormalMatrix(jacobian, residuals);
                    RealMatrix normal = (RealMatrix)normalEquation.getFirst();
                    RealVector jTr = (RealVector)normalEquation.getSecond();
                    return new LUDecomposition(normal, 1.0E-11).getSolver().solve(jTr);
                }
                catch (SingularMatrixException e2) {
                    throw new ConvergenceException(LocalizedFormats.UNABLE_TO_SOLVE_SINGULAR_PROBLEM, e2);
                }
            }
        }
        ,
        QR{

            protected RealVector solve(RealMatrix jacobian, RealVector residuals) {
                try {
                    return new QRDecomposition(jacobian, 1.0E-11).getSolver().solve(residuals);
                }
                catch (SingularMatrixException e2) {
                    throw new ConvergenceException(LocalizedFormats.UNABLE_TO_SOLVE_SINGULAR_PROBLEM, e2);
                }
            }
        }
        ,
        CHOLESKY{

            protected RealVector solve(RealMatrix jacobian, RealVector residuals) {
                try {
                    Pair normalEquation = GaussNewtonOptimizer.computeNormalMatrix(jacobian, residuals);
                    RealMatrix normal = (RealMatrix)normalEquation.getFirst();
                    RealVector jTr = (RealVector)normalEquation.getSecond();
                    return new CholeskyDecomposition(normal, 1.0E-11, 1.0E-11).getSolver().solve(jTr);
                }
                catch (NonPositiveDefiniteMatrixException e2) {
                    throw new ConvergenceException(LocalizedFormats.UNABLE_TO_SOLVE_SINGULAR_PROBLEM, e2);
                }
            }
        }
        ,
        SVD{

            protected RealVector solve(RealMatrix jacobian, RealVector residuals) {
                return new SingularValueDecomposition(jacobian).getSolver().solve(residuals);
            }
        };


        protected abstract RealVector solve(RealMatrix var1, RealVector var2);
    }
}

