/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.math3.distribution;

import org.apache.commons.math3.distribution.AbstractRealDistribution;
import org.apache.commons.math3.exception.NumberIsTooSmallException;
import org.apache.commons.math3.exception.util.Localizable;
import org.apache.commons.math3.exception.util.LocalizedFormats;
import org.apache.commons.math3.random.RandomGenerator;
import org.apache.commons.math3.random.Well19937c;
import org.apache.commons.math3.special.Beta;
import org.apache.commons.math3.special.Gamma;
import org.apache.commons.math3.util.FastMath;
import org.apache.commons.math3.util.Precision;

public class BetaDistribution
extends AbstractRealDistribution {
    public static final double DEFAULT_INVERSE_ABSOLUTE_ACCURACY = 1.0E-9;
    private static final long serialVersionUID = -1221965979403477668L;
    private final double alpha;
    private final double beta;
    private double z;
    private final double solverAbsoluteAccuracy;

    public BetaDistribution(double alpha, double beta) {
        this(alpha, beta, 1.0E-9);
    }

    public BetaDistribution(double alpha, double beta, double inverseCumAccuracy) {
        this(new Well19937c(), alpha, beta, inverseCumAccuracy);
    }

    public BetaDistribution(RandomGenerator rng, double alpha, double beta) {
        this(rng, alpha, beta, 1.0E-9);
    }

    public BetaDistribution(RandomGenerator rng, double alpha, double beta, double inverseCumAccuracy) {
        super(rng);
        this.alpha = alpha;
        this.beta = beta;
        this.z = Double.NaN;
        this.solverAbsoluteAccuracy = inverseCumAccuracy;
    }

    public double getAlpha() {
        return this.alpha;
    }

    public double getBeta() {
        return this.beta;
    }

    private void recomputeZ() {
        if (Double.isNaN(this.z)) {
            this.z = Gamma.logGamma(this.alpha) + Gamma.logGamma(this.beta) - Gamma.logGamma(this.alpha + this.beta);
        }
    }

    public double density(double x2) {
        double logDensity = this.logDensity(x2);
        return logDensity == Double.NEGATIVE_INFINITY ? 0.0 : FastMath.exp(logDensity);
    }

    public double logDensity(double x2) {
        this.recomputeZ();
        if (x2 < 0.0 || x2 > 1.0) {
            return Double.NEGATIVE_INFINITY;
        }
        if (x2 == 0.0) {
            if (this.alpha < 1.0) {
                throw new NumberIsTooSmallException((Localizable)LocalizedFormats.CANNOT_COMPUTE_BETA_DENSITY_AT_0_FOR_SOME_ALPHA, (Number)this.alpha, 1, false);
            }
            return Double.NEGATIVE_INFINITY;
        }
        if (x2 == 1.0) {
            if (this.beta < 1.0) {
                throw new NumberIsTooSmallException((Localizable)LocalizedFormats.CANNOT_COMPUTE_BETA_DENSITY_AT_1_FOR_SOME_BETA, (Number)this.beta, 1, false);
            }
            return Double.NEGATIVE_INFINITY;
        }
        double logX = FastMath.log(x2);
        double log1mX = FastMath.log1p(-x2);
        return (this.alpha - 1.0) * logX + (this.beta - 1.0) * log1mX - this.z;
    }

    public double cumulativeProbability(double x2) {
        if (x2 <= 0.0) {
            return 0.0;
        }
        if (x2 >= 1.0) {
            return 1.0;
        }
        return Beta.regularizedBeta(x2, this.alpha, this.beta);
    }

    protected double getSolverAbsoluteAccuracy() {
        return this.solverAbsoluteAccuracy;
    }

    public double getNumericalMean() {
        double a2 = this.getAlpha();
        return a2 / (a2 + this.getBeta());
    }

    public double getNumericalVariance() {
        double a2 = this.getAlpha();
        double b2 = this.getBeta();
        double alphabetasum = a2 + b2;
        return a2 * b2 / (alphabetasum * alphabetasum * (alphabetasum + 1.0));
    }

    public double getSupportLowerBound() {
        return 0.0;
    }

    public double getSupportUpperBound() {
        return 1.0;
    }

    public boolean isSupportLowerBoundInclusive() {
        return false;
    }

    public boolean isSupportUpperBoundInclusive() {
        return false;
    }

    public boolean isSupportConnected() {
        return true;
    }

    public double sample() {
        return ChengBetaSampler.sample(this.random, this.alpha, this.beta);
    }

    private static final class ChengBetaSampler {
        private ChengBetaSampler() {
        }

        static double sample(RandomGenerator random, double alpha, double beta) {
            double a2 = FastMath.min(alpha, beta);
            double b2 = FastMath.max(alpha, beta);
            if (a2 > 1.0) {
                return ChengBetaSampler.algorithmBB(random, alpha, a2, b2);
            }
            return ChengBetaSampler.algorithmBC(random, alpha, b2, a2);
        }

        private static double algorithmBB(RandomGenerator random, double a0, double a2, double b2) {
            double t2;
            double u2;
            double z2;
            double w2;
            double u1;
            double v2;
            double r2;
            double s2;
            double alpha = a2 + b2;
            double beta = FastMath.sqrt((alpha - 2.0) / (2.0 * a2 * b2 - alpha));
            double gamma = a2 + 1.0 / beta;
            do {
                u1 = random.nextDouble();
                u2 = random.nextDouble();
            } while (!((s2 = a2 + (r2 = gamma * (v2 = beta * (FastMath.log(u1) - FastMath.log1p(-u1))) - 1.3862944) - (w2 = a2 * FastMath.exp(v2))) + 2.609438 >= 5.0 * (z2 = u1 * u1 * u2)) && !(s2 >= (t2 = FastMath.log(z2))) && r2 + alpha * (FastMath.log(alpha) - FastMath.log(b2 + w2)) < t2);
            w2 = FastMath.min(w2, Double.MAX_VALUE);
            return Precision.equals(a2, a0) ? w2 / (b2 + w2) : b2 / (b2 + w2);
        }

        private static double algorithmBC(RandomGenerator random, double a0, double a2, double b2) {
            double w2;
            double alpha = a2 + b2;
            double beta = 1.0 / b2;
            double delta = 1.0 + a2 - b2;
            double k1 = delta * (0.0138889 + 0.0416667 * b2) / (a2 * beta - 0.777778);
            double k2 = 0.25 + (0.5 + 0.25 / delta) * b2;
            while (true) {
                double v2;
                double u1 = random.nextDouble();
                double u2 = random.nextDouble();
                double y2 = u1 * u2;
                double z2 = u1 * y2;
                if (u1 < 0.5) {
                    if (0.25 * u2 + z2 - y2 >= k1) {
                        continue;
                    }
                } else {
                    if (z2 <= 0.25) {
                        v2 = beta * (FastMath.log(u1) - FastMath.log1p(-u1));
                        w2 = a2 * FastMath.exp(v2);
                        break;
                    }
                    if (z2 >= k2) continue;
                }
                v2 = beta * (FastMath.log(u1) - FastMath.log1p(-u1));
                w2 = a2 * FastMath.exp(v2);
                if (alpha * (FastMath.log(alpha) - FastMath.log(b2 + w2) + v2) - 1.3862944 >= FastMath.log(z2)) break;
            }
            w2 = FastMath.min(w2, Double.MAX_VALUE);
            return Precision.equals(a2, a0) ? w2 / (b2 + w2) : b2 / (b2 + w2);
        }
    }
}

