/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.math3.distribution;

import org.apache.commons.math3.distribution.MultivariateRealDistribution;
import org.apache.commons.math3.exception.NotStrictlyPositiveException;
import org.apache.commons.math3.exception.util.Localizable;
import org.apache.commons.math3.exception.util.LocalizedFormats;
import org.apache.commons.math3.random.RandomGenerator;

public abstract class AbstractMultivariateRealDistribution
implements MultivariateRealDistribution {
    protected final RandomGenerator random;
    private final int dimension;

    protected AbstractMultivariateRealDistribution(RandomGenerator rng, int n2) {
        this.random = rng;
        this.dimension = n2;
    }

    public void reseedRandomGenerator(long seed) {
        this.random.setSeed(seed);
    }

    public int getDimension() {
        return this.dimension;
    }

    public abstract double[] sample();

    public double[][] sample(int sampleSize) {
        if (sampleSize <= 0) {
            throw new NotStrictlyPositiveException((Localizable)LocalizedFormats.NUMBER_OF_SAMPLES, sampleSize);
        }
        double[][] out = new double[sampleSize][this.dimension];
        for (int i2 = 0; i2 < sampleSize; ++i2) {
            out[i2] = this.sample();
        }
        return out;
    }
}

