/*
 * Decompiled with CFR 0.152.
 */
package com.itextpdf.text.pdf.parser;

import java.util.Arrays;

public class Matrix {
    public static final int I11 = 0;
    public static final int I12 = 1;
    public static final int I13 = 2;
    public static final int I21 = 3;
    public static final int I22 = 4;
    public static final int I23 = 5;
    public static final int I31 = 6;
    public static final int I32 = 7;
    public static final int I33 = 8;
    private final float[] vals = new float[]{1.0f, 0.0f, 0.0f, 0.0f, 1.0f, 0.0f, 0.0f, 0.0f, 1.0f};

    public Matrix() {
    }

    public Matrix(float tx, float ty) {
        this.vals[6] = tx;
        this.vals[7] = ty;
    }

    public Matrix(float a2, float b2, float c2, float d2, float e2, float f2) {
        this.vals[0] = a2;
        this.vals[1] = b2;
        this.vals[2] = 0.0f;
        this.vals[3] = c2;
        this.vals[4] = d2;
        this.vals[5] = 0.0f;
        this.vals[6] = e2;
        this.vals[7] = f2;
        this.vals[8] = 1.0f;
    }

    public float get(int index) {
        return this.vals[index];
    }

    public Matrix multiply(Matrix by) {
        Matrix rslt = new Matrix();
        float[] a2 = this.vals;
        float[] b2 = by.vals;
        float[] c2 = rslt.vals;
        c2[0] = a2[0] * b2[0] + a2[1] * b2[3] + a2[2] * b2[6];
        c2[1] = a2[0] * b2[1] + a2[1] * b2[4] + a2[2] * b2[7];
        c2[2] = a2[0] * b2[2] + a2[1] * b2[5] + a2[2] * b2[8];
        c2[3] = a2[3] * b2[0] + a2[4] * b2[3] + a2[5] * b2[6];
        c2[4] = a2[3] * b2[1] + a2[4] * b2[4] + a2[5] * b2[7];
        c2[5] = a2[3] * b2[2] + a2[4] * b2[5] + a2[5] * b2[8];
        c2[6] = a2[6] * b2[0] + a2[7] * b2[3] + a2[8] * b2[6];
        c2[7] = a2[6] * b2[1] + a2[7] * b2[4] + a2[8] * b2[7];
        c2[8] = a2[6] * b2[2] + a2[7] * b2[5] + a2[8] * b2[8];
        return rslt;
    }

    public Matrix subtract(Matrix arg) {
        Matrix rslt = new Matrix();
        float[] a2 = this.vals;
        float[] b2 = arg.vals;
        float[] c2 = rslt.vals;
        c2[0] = a2[0] - b2[0];
        c2[1] = a2[1] - b2[1];
        c2[2] = a2[2] - b2[2];
        c2[3] = a2[3] - b2[3];
        c2[4] = a2[4] - b2[4];
        c2[5] = a2[5] - b2[5];
        c2[6] = a2[6] - b2[6];
        c2[7] = a2[7] - b2[7];
        c2[8] = a2[8] - b2[8];
        return rslt;
    }

    public float getDeterminant() {
        return this.vals[0] * this.vals[4] * this.vals[8] + this.vals[1] * this.vals[5] * this.vals[6] + this.vals[2] * this.vals[3] * this.vals[7] - this.vals[0] * this.vals[5] * this.vals[7] - this.vals[1] * this.vals[3] * this.vals[8] - this.vals[2] * this.vals[4] * this.vals[6];
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof Matrix)) {
            return false;
        }
        return Arrays.equals(this.vals, ((Matrix)obj).vals);
    }

    public int hashCode() {
        int result2 = 1;
        for (int i2 = 0; i2 < this.vals.length; ++i2) {
            result2 = 31 * result2 + Float.floatToIntBits(this.vals[i2]);
        }
        return result2;
    }

    public String toString() {
        return this.vals[0] + "\t" + this.vals[1] + "\t" + this.vals[2] + "\n" + this.vals[3] + "\t" + this.vals[4] + "\t" + this.vals[2] + "\n" + this.vals[6] + "\t" + this.vals[7] + "\t" + this.vals[8];
    }
}

