/*
 * Decompiled with CFR 0.152.
 */
package gde.ui.dialog.edit;

import gde.GDE;
import gde.device.DataTypes;
import gde.device.DeviceConfiguration;
import gde.device.RespondType;
import gde.log.Level;
import gde.messages.Messages;
import gde.ui.DataExplorer;
import gde.ui.SWTResourceManager;
import gde.ui.dialog.edit.ChannelTypeTabItem;
import gde.ui.dialog.edit.ContextMenu;
import gde.ui.dialog.edit.DevicePropertiesEditor;
import gde.utils.StringHelper;
import java.util.logging.Logger;
import org.eclipse.swt.custom.CCombo;
import org.eclipse.swt.custom.CTabFolder;
import org.eclipse.swt.custom.CTabItem;
import org.eclipse.swt.events.FocusAdapter;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.HelpEvent;
import org.eclipse.swt.events.HelpListener;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.events.VerifyEvent;
import org.eclipse.swt.events.VerifyListener;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Decorations;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Widget;

public class TcpPortTypeTabItem
extends CTabItem {
    static final Logger log = Logger.getLogger(ChannelTypeTabItem.class.getName());
    Composite tcpPortComposite;
    Composite timeOutComposite;
    Label tcpPortDescriptionLabel;
    Label timeOutDescriptionLabel;
    Label tcpHostAddressLabel;
    Label portNumberLabel;
    Label respondLabel;
    Label requestLabel;
    Label timeOutLabel;
    Text tcpHostAddressText;
    Text portNumberText;
    Text requestText;
    CCombo respondCombo;
    Button requestButton;
    Button timeOutButton;
    Label ReadTimeoutLabel;
    Label ReadStableIndexLabel;
    Label _WTOCharDelayTimeLabel;
    Label _WTOExtraDelayTimeLabel;
    Text ReadTimeoutText;
    Text ReadStableIndexText;
    Text _WTOCharDelayTimeText;
    Text _WTOExtraDelayTimeText;
    String tcpHostAddress = "";
    String portNumber = "";
    RespondType respondType = RespondType.fromValue("CSV");
    String request = "";
    boolean isUseRequest = false;
    boolean useTimeOut = false;
    int ReadTimeout = 0;
    int ReadStableIndex = 0;
    int WTOCharDelayTime = 0;
    int WTOExtraDelayTime = 0;
    DeviceConfiguration deviceConfig;
    Menu popupMenu;
    ContextMenu contextMenu;
    final CTabFolder tabFolder;
    final DevicePropertiesEditor propsEditor;

    public TcpPortTypeTabItem(CTabFolder parent, int style, int index) {
        super(parent, style, index);
        this.tabFolder = parent;
        this.propsEditor = DevicePropertiesEditor.getInstance();
        log.log(java.util.logging.Level.FINE, "TcpPortTypeTabItem ");
        this.initGUI();
    }

    private void initGUI() {
        try {
            SWTResourceManager.registerResourceUser((Widget)this);
            this.setText(Messages.getString("GDE_MSGT0975"));
            this.setFont(SWTResourceManager.getFont(GDE.WIDGET_FONT_NAME, GDE.WIDGET_FONT_SIZE, 0));
            this.tcpPortComposite = new Composite((Composite)this.tabFolder, 0);
            this.tcpPortComposite.setLayout(null);
            this.setControl((Control)this.tcpPortComposite);
            this.tcpPortComposite.addHelpListener(new HelpListener(this){

                public void helpRequested(HelpEvent evt) {
                    log.log(Level.FINEST, "tcpPortComposite.helpRequested " + String.valueOf(evt));
                    DataExplorer.getInstance().openHelpDialog("", "HelpInfo_A1.html#device_properties_serial_port");
                }
            });
            this.tcpPortComposite.addFocusListener((FocusListener)new FocusAdapter(){

                public void focusLost(FocusEvent focusevent) {
                    log.log(java.util.logging.Level.FINEST, "tcpPortComposite.focusLost, event=" + String.valueOf(focusevent));
                    TcpPortTypeTabItem.this.enableContextmenu(false);
                }

                public void focusGained(FocusEvent focusevent) {
                    log.log(java.util.logging.Level.FINEST, "tcpPortComposite.focusGained, event=" + String.valueOf(focusevent));
                    TcpPortTypeTabItem.this.enableContextmenu(true);
                }
            });
            this.tcpPortDescriptionLabel = new Label(this.tcpPortComposite, 0x1000040);
            this.tcpPortDescriptionLabel.setText(Messages.getString("GDE_MSGT0976"));
            this.tcpPortDescriptionLabel.setFont(SWTResourceManager.getFont(GDE.WIDGET_FONT_NAME, GDE.WIDGET_FONT_SIZE, 0));
            this.tcpPortDescriptionLabel.setBounds(12, 6, 602, 56);
            this.tcpHostAddressLabel = new Label(this.tcpPortComposite, 16384);
            this.tcpHostAddressLabel.setText(Messages.getString("GDE_MSGT0977"));
            this.tcpHostAddressLabel.setFont(SWTResourceManager.getFont(GDE.WIDGET_FONT_NAME, GDE.WIDGET_FONT_SIZE, 0));
            this.tcpHostAddressLabel.setBounds(15, 74, 100, 20);
            this.tcpHostAddressText = new Text(this.tcpPortComposite, 2048);
            this.tcpHostAddressText.setBounds(141, 76, 180, 20);
            this.tcpHostAddressText.setFont(SWTResourceManager.getFont(GDE.WIDGET_FONT_NAME, GDE.WIDGET_FONT_SIZE, 0));
            this.tcpHostAddressText.setEditable(true);
            this.tcpHostAddressText.addKeyListener((KeyListener)new KeyAdapter(){

                public void keyReleased(KeyEvent evt) {
                    log.log(java.util.logging.Level.FINEST, "tcpHostAddressText.keyReleased, event=" + String.valueOf(evt));
                    TcpPortTypeTabItem.this.portNumber = TcpPortTypeTabItem.this.tcpHostAddressText.getText();
                    if (TcpPortTypeTabItem.this.deviceConfig != null) {
                        TcpPortTypeTabItem.this.deviceConfig.setTcpHostAddress(TcpPortTypeTabItem.this.tcpHostAddressText.getText().trim());
                        TcpPortTypeTabItem.this.propsEditor.enableSaveButton(true);
                    }
                }
            });
            this.portNumberLabel = new Label(this.tcpPortComposite, 16384);
            this.portNumberLabel.setText(Messages.getString("GDE_MSGT0978"));
            this.portNumberLabel.setFont(SWTResourceManager.getFont(GDE.WIDGET_FONT_NAME, GDE.WIDGET_FONT_SIZE, 0));
            this.portNumberLabel.setBounds(15, 104, 100, 20);
            this.portNumberText = new Text(this.tcpPortComposite, 2048);
            this.portNumberText.setBounds(141, 106, 180, 20);
            this.portNumberText.setFont(SWTResourceManager.getFont(GDE.WIDGET_FONT_NAME, GDE.WIDGET_FONT_SIZE, 0));
            this.portNumberText.setEditable(true);
            this.portNumberText.addVerifyListener(new VerifyListener(this){

                public void verifyText(VerifyEvent evt) {
                    log.log(java.util.logging.Level.FINEST, "portNumberText.verifyText, event=" + String.valueOf(evt));
                    evt.doit = StringHelper.verifyTypedInput(DataTypes.INTEGER, evt.text);
                }
            });
            this.portNumberText.addKeyListener((KeyListener)new KeyAdapter(){

                public void keyReleased(KeyEvent evt) {
                    log.log(java.util.logging.Level.FINEST, "portNumberText.keyReleased, event=" + String.valueOf(evt));
                    TcpPortTypeTabItem.this.portNumber = TcpPortTypeTabItem.this.portNumberText.getText();
                    if (TcpPortTypeTabItem.this.deviceConfig != null) {
                        TcpPortTypeTabItem.this.deviceConfig.setTcpPortNumber(TcpPortTypeTabItem.this.portNumberText.getText().trim());
                        TcpPortTypeTabItem.this.propsEditor.enableSaveButton(true);
                    }
                }
            });
            this.respondLabel = new Label(this.tcpPortComposite, 16384);
            this.respondLabel.setText("Respond Type");
            this.respondLabel.setFont(SWTResourceManager.getFont(GDE.WIDGET_FONT_NAME, GDE.WIDGET_FONT_SIZE, 0));
            this.respondLabel.setBounds(25, 200, 150, 20);
            this.respondCombo = new CCombo(this.tcpPortComposite, 2048);
            this.respondCombo.setFont(SWTResourceManager.getFont(GDE.WIDGET_FONT_NAME, GDE.WIDGET_FONT_SIZE, 0));
            this.respondCombo.setItems(RespondType.valuesAsStingArray());
            this.respondCombo.setBounds(160, 201, 100, 20);
            this.respondCombo.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent evt) {
                    log.log(java.util.logging.Level.FINEST, "flowControlCombo.widgetSelected, event=" + String.valueOf(evt));
                    if (TcpPortTypeTabItem.this.deviceConfig != null) {
                        TcpPortTypeTabItem.this.deviceConfig.setTcpRespondType(RespondType.fromValue(RespondType.valuesAsStingArray()[TcpPortTypeTabItem.this.respondCombo.getSelectionIndex()]));
                        TcpPortTypeTabItem.this.propsEditor.enableSaveButton(true);
                    }
                }
            });
            Group requestGroup = new Group(this.tcpPortComposite, 2048);
            requestGroup.setText("Request (optional)");
            requestGroup.setFont(SWTResourceManager.getFont(GDE.WIDGET_FONT_NAME, GDE.WIDGET_FONT_SIZE, 0));
            requestGroup.setBounds(15, 230, 320, 120);
            Label requestGroupLabel = new Label((Composite)requestGroup, 0x1000040);
            requestGroupLabel.setText("Optional request, will be send as byte array, if required to request a respond");
            requestGroupLabel.setFont(SWTResourceManager.getFont(GDE.WIDGET_FONT_NAME, GDE.WIDGET_FONT_SIZE, 0));
            requestGroupLabel.setBounds(10, 10, 250, 40);
            this.requestButton = new Button((Composite)requestGroup, 2080);
            this.requestButton.setBounds(8, 62, 15, 15);
            this.requestButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent evt) {
                    log.log(java.util.logging.Level.FINEST, "requestButton.widgetSelected, event=" + String.valueOf(evt));
                    TcpPortTypeTabItem.this.isUseRequest = TcpPortTypeTabItem.this.requestButton.getSelection();
                    TcpPortTypeTabItem.this.requestLabel.setEnabled(TcpPortTypeTabItem.this.isUseRequest);
                    TcpPortTypeTabItem.this.requestText.setEnabled(TcpPortTypeTabItem.this.isUseRequest);
                    TcpPortTypeTabItem.this.requestText.setEditable(TcpPortTypeTabItem.this.isUseRequest);
                    if (TcpPortTypeTabItem.this.isUseRequest) {
                        if (TcpPortTypeTabItem.this.deviceConfig != null) {
                            TcpPortTypeTabItem.this.request = "51";
                            TcpPortTypeTabItem.this.requestText.setText(TcpPortTypeTabItem.this.request);
                            byte[] request = StringHelper.byteString2ByteArray(TcpPortTypeTabItem.this.requestText.getText());
                            TcpPortTypeTabItem.this.deviceConfig.setTcpRequest(request);
                            TcpPortTypeTabItem.this.propsEditor.enableSaveButton(true);
                        }
                    } else if (TcpPortTypeTabItem.this.deviceConfig != null) {
                        TcpPortTypeTabItem.this.deviceConfig.removeTcpRequest();
                        TcpPortTypeTabItem.this.propsEditor.enableSaveButton(true);
                    }
                    TcpPortTypeTabItem.this.enableTimeout();
                }
            });
            this.requestLabel = new Label((Composite)requestGroup, 16384);
            this.requestLabel.setText("two char per byte");
            this.requestLabel.setFont(SWTResourceManager.getFont(GDE.WIDGET_FONT_NAME, GDE.WIDGET_FONT_SIZE, 0));
            this.requestLabel.setBounds(30, 60, 140, 20);
            this.requestText = new Text((Composite)requestGroup, 2048);
            this.requestText.setBounds(160, 60, 100, 20);
            this.requestText.setFont(SWTResourceManager.getFont(GDE.WIDGET_FONT_NAME, GDE.WIDGET_FONT_SIZE, 0));
            this.requestText.setEditable(true);
            this.requestText.addVerifyListener(new VerifyListener(this){

                public void verifyText(VerifyEvent evt) {
                    log.log(java.util.logging.Level.FINEST, "requestText.verifyText, event=" + String.valueOf(evt));
                    evt.doit = StringHelper.verifyTypedInput(DataTypes.HEXADECIMAL, evt.text);
                }
            });
            this.requestText.addKeyListener((KeyListener)new KeyAdapter(){

                public void keyReleased(KeyEvent evt) {
                    log.log(java.util.logging.Level.FINEST, "requestText.keyReleased, event=" + String.valueOf(evt));
                    TcpPortTypeTabItem.this.request = TcpPortTypeTabItem.this.requestText.getText();
                    if (TcpPortTypeTabItem.this.deviceConfig != null) {
                        byte[] request = StringHelper.byteString2ByteArray(TcpPortTypeTabItem.this.requestText.getText());
                        TcpPortTypeTabItem.this.deviceConfig.setTcpRequest(request);
                        TcpPortTypeTabItem.this.propsEditor.enableSaveButton(true);
                    }
                }
            });
            this.timeOutComposite = new Composite(this.tcpPortComposite, 2048);
            this.timeOutComposite.setLayout(null);
            this.timeOutComposite.setBounds(355, 80, 250, 220);
            this.timeOutDescriptionLabel = new Label(this.timeOutComposite, 64);
            this.timeOutDescriptionLabel.setText(Messages.getString("GDE_MSGT0591"));
            this.timeOutDescriptionLabel.setFont(SWTResourceManager.getFont(GDE.WIDGET_FONT_NAME, GDE.WIDGET_FONT_SIZE, 0));
            this.timeOutDescriptionLabel.setBounds(6, 3, 232, 69);
            this.timeOutLabel = new Label(this.timeOutComposite, 131072);
            this.timeOutLabel.setText(Messages.getString("GDE_MSGT0586"));
            this.timeOutLabel.setFont(SWTResourceManager.getFont(GDE.WIDGET_FONT_NAME, GDE.WIDGET_FONT_SIZE, 0));
            this.timeOutLabel.setBounds(6, 70, 140, 20);
            this.timeOutButton = new Button(this.timeOutComposite, 32);
            this.timeOutButton.setFont(SWTResourceManager.getFont(GDE.WIDGET_FONT_NAME, GDE.WIDGET_FONT_SIZE, 0));
            this.timeOutButton.setBounds(161, 70, 70, 20);
            this.timeOutButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent evt) {
                    log.log(java.util.logging.Level.FINEST, "timeOutButton.widgetSelected, event=" + String.valueOf(evt));
                    TcpPortTypeTabItem.this.useTimeOut = TcpPortTypeTabItem.this.timeOutButton.getSelection();
                    if (TcpPortTypeTabItem.this.useTimeOut) {
                        if (TcpPortTypeTabItem.this.deviceConfig != null) {
                            TcpPortTypeTabItem.this.ReadTimeout = TcpPortTypeTabItem.this.deviceConfig.getReadTimeOut();
                            TcpPortTypeTabItem.this.deviceConfig.setReadTimeOut(TcpPortTypeTabItem.this.ReadTimeout);
                            TcpPortTypeTabItem.this.ReadStableIndex = TcpPortTypeTabItem.this.deviceConfig.getReadStableIndex();
                            TcpPortTypeTabItem.this.deviceConfig.setReadStableIndex(TcpPortTypeTabItem.this.ReadStableIndex);
                            TcpPortTypeTabItem.this.WTOCharDelayTime = TcpPortTypeTabItem.this.deviceConfig.getWriteCharDelayTime();
                            TcpPortTypeTabItem.this.deviceConfig.setWriteCharDelayTime(TcpPortTypeTabItem.this.WTOCharDelayTime);
                            TcpPortTypeTabItem.this.WTOExtraDelayTime = TcpPortTypeTabItem.this.deviceConfig.getWriteDelayTime();
                            TcpPortTypeTabItem.this.deviceConfig.setWriteDelayTime(TcpPortTypeTabItem.this.WTOExtraDelayTime);
                            TcpPortTypeTabItem.this.propsEditor.enableSaveButton(true);
                        } else {
                            TcpPortTypeTabItem.this.ReadTimeout = 0;
                            TcpPortTypeTabItem.this.ReadStableIndex = 0;
                            TcpPortTypeTabItem.this.WTOCharDelayTime = 0;
                            TcpPortTypeTabItem.this.WTOExtraDelayTime = 0;
                        }
                    } else {
                        if (TcpPortTypeTabItem.this.deviceConfig != null) {
                            TcpPortTypeTabItem.this.deviceConfig.removeSerialPortTimeOut();
                        }
                        TcpPortTypeTabItem.this.ReadTimeout = 0;
                        TcpPortTypeTabItem.this.ReadStableIndex = 0;
                        TcpPortTypeTabItem.this.WTOCharDelayTime = 0;
                        TcpPortTypeTabItem.this.WTOExtraDelayTime = 0;
                    }
                    TcpPortTypeTabItem.this.enableTimeout();
                }
            });
            this.ReadTimeoutLabel = new Label(this.timeOutComposite, 131072);
            this.ReadTimeoutLabel.setText(Messages.getString("GDE_MSGT0587"));
            this.ReadTimeoutLabel.setFont(SWTResourceManager.getFont(GDE.WIDGET_FONT_NAME, GDE.WIDGET_FONT_SIZE, 0));
            this.ReadTimeoutLabel.setBounds(6, 100, 140, 20);
            this.ReadTimeoutText = new Text(this.timeOutComposite, 2048);
            this.ReadTimeoutText.setFont(SWTResourceManager.getFont(GDE.WIDGET_FONT_NAME, GDE.WIDGET_FONT_SIZE, 0));
            this.ReadTimeoutText.setBounds(162, 100, 70, 20);
            this.ReadTimeoutText.addVerifyListener(new VerifyListener(this){

                public void verifyText(VerifyEvent evt) {
                    log.log(java.util.logging.Level.FINEST, "ReadTimeoutText.verifyText, event=" + String.valueOf(evt));
                    evt.doit = StringHelper.verifyTypedInput(DataTypes.INTEGER, evt.text);
                }
            });
            this.ReadTimeoutText.addKeyListener((KeyListener)new KeyAdapter(){

                public void keyReleased(KeyEvent evt) {
                    log.log(java.util.logging.Level.FINEST, "ReadTimeoutText.keyReleased, event=" + String.valueOf(evt));
                    int n = TcpPortTypeTabItem.this.ReadTimeout = TcpPortTypeTabItem.this.ReadTimeoutText.getText().equals("") ? 0 : Integer.parseInt(TcpPortTypeTabItem.this.ReadTimeoutText.getText());
                    if (TcpPortTypeTabItem.this.deviceConfig != null) {
                        TcpPortTypeTabItem.this.deviceConfig.setReadTimeOut(TcpPortTypeTabItem.this.ReadTimeout);
                        TcpPortTypeTabItem.this.propsEditor.enableSaveButton(true);
                    }
                }
            });
            this.ReadStableIndexLabel = new Label(this.timeOutComposite, 131072);
            this.ReadStableIndexLabel.setText(Messages.getString("GDE_MSGT0588"));
            this.ReadStableIndexLabel.setFont(SWTResourceManager.getFont(GDE.WIDGET_FONT_NAME, GDE.WIDGET_FONT_SIZE, 0));
            this.ReadStableIndexLabel.setBounds(6, 130, 140, 20);
            this.ReadStableIndexText = new Text(this.timeOutComposite, 2048);
            this.ReadStableIndexText.setFont(SWTResourceManager.getFont(GDE.WIDGET_FONT_NAME, GDE.WIDGET_FONT_SIZE, 0));
            this.ReadStableIndexText.setBounds(162, 130, 70, 20);
            this.ReadStableIndexText.addVerifyListener(new VerifyListener(this){

                public void verifyText(VerifyEvent evt) {
                    log.log(java.util.logging.Level.FINEST, "ReadStableIndexText.verifyText, event=" + String.valueOf(evt));
                    evt.doit = StringHelper.verifyTypedInput(DataTypes.INTEGER, evt.text);
                }
            });
            this.ReadStableIndexText.addKeyListener((KeyListener)new KeyAdapter(){

                public void keyReleased(KeyEvent evt) {
                    log.log(java.util.logging.Level.FINEST, "ReadStableIndexText.keyReleased, event=" + String.valueOf(evt));
                    int n = TcpPortTypeTabItem.this.ReadStableIndex = TcpPortTypeTabItem.this.ReadStableIndexText.getText().equals("") ? 0 : Integer.parseInt(TcpPortTypeTabItem.this.ReadStableIndexText.getText());
                    if (TcpPortTypeTabItem.this.deviceConfig != null) {
                        TcpPortTypeTabItem.this.deviceConfig.setReadStableIndex(TcpPortTypeTabItem.this.ReadStableIndex);
                        TcpPortTypeTabItem.this.propsEditor.enableSaveButton(true);
                    }
                }
            });
            this._WTOCharDelayTimeLabel = new Label(this.timeOutComposite, 131072);
            this._WTOCharDelayTimeLabel.setText(Messages.getString("GDE_MSGT0589"));
            this._WTOCharDelayTimeLabel.setFont(SWTResourceManager.getFont(GDE.WIDGET_FONT_NAME, GDE.WIDGET_FONT_SIZE, 0));
            this._WTOCharDelayTimeLabel.setBounds(6, 160, 140, 20);
            this._WTOCharDelayTimeText = new Text(this.timeOutComposite, 2048);
            this._WTOCharDelayTimeText.setFont(SWTResourceManager.getFont(GDE.WIDGET_FONT_NAME, GDE.WIDGET_FONT_SIZE, 0));
            this._WTOCharDelayTimeText.setBounds(162, 160, 70, 20);
            this._WTOCharDelayTimeText.addVerifyListener(new VerifyListener(this){

                public void verifyText(VerifyEvent evt) {
                    log.log(java.util.logging.Level.FINEST, "_WRTOCharDelayTimeText.verifyText, event=" + String.valueOf(evt));
                    evt.doit = StringHelper.verifyTypedInput(DataTypes.INTEGER, evt.text);
                }
            });
            this._WTOCharDelayTimeText.addKeyListener((KeyListener)new KeyAdapter(){

                public void keyReleased(KeyEvent evt) {
                    log.log(java.util.logging.Level.FINEST, "_WRTOCharDelayTimeText.keyReleased, event=" + String.valueOf(evt));
                    int n = TcpPortTypeTabItem.this.WTOCharDelayTime = TcpPortTypeTabItem.this._WTOCharDelayTimeText.getText().equals("") ? 0 : Integer.parseInt(TcpPortTypeTabItem.this._WTOCharDelayTimeText.getText());
                    if (TcpPortTypeTabItem.this.deviceConfig != null) {
                        TcpPortTypeTabItem.this.deviceConfig.setWriteCharDelayTime(TcpPortTypeTabItem.this.WTOCharDelayTime);
                        TcpPortTypeTabItem.this.propsEditor.enableSaveButton(true);
                    }
                }
            });
            this._WTOExtraDelayTimeLabel = new Label(this.timeOutComposite, 131072);
            this._WTOExtraDelayTimeLabel.setText(Messages.getString("GDE_MSGT0590"));
            this._WTOExtraDelayTimeLabel.setFont(SWTResourceManager.getFont(GDE.WIDGET_FONT_NAME, GDE.WIDGET_FONT_SIZE, 0));
            this._WTOExtraDelayTimeLabel.setBounds(6, 190, 140, 20);
            this._WTOExtraDelayTimeText = new Text(this.timeOutComposite, 2048);
            this._WTOExtraDelayTimeText.setFont(SWTResourceManager.getFont(GDE.WIDGET_FONT_NAME, GDE.WIDGET_FONT_SIZE, 0));
            this._WTOExtraDelayTimeText.setBounds(162, 190, 70, 20);
            this._WTOExtraDelayTimeText.addVerifyListener(new VerifyListener(this){

                public void verifyText(VerifyEvent evt) {
                    log.log(java.util.logging.Level.FINEST, "_WTOExtraDelayTimeText.verifyText, event=" + String.valueOf(evt));
                    evt.doit = StringHelper.verifyTypedInput(DataTypes.INTEGER, evt.text);
                }
            });
            this._WTOExtraDelayTimeText.addKeyListener((KeyListener)new KeyAdapter(){

                public void keyReleased(KeyEvent evt) {
                    log.log(java.util.logging.Level.FINEST, "_WTOExtraDelayTimeText.keyReleased, event=" + String.valueOf(evt));
                    int n = TcpPortTypeTabItem.this.WTOExtraDelayTime = TcpPortTypeTabItem.this._WTOExtraDelayTimeText.getText().equals("") ? 0 : Integer.parseInt(TcpPortTypeTabItem.this._WTOExtraDelayTimeText.getText());
                    if (TcpPortTypeTabItem.this.deviceConfig != null) {
                        TcpPortTypeTabItem.this.deviceConfig.setWriteDelayTime(TcpPortTypeTabItem.this.WTOExtraDelayTime);
                        TcpPortTypeTabItem.this.propsEditor.enableSaveButton(true);
                    }
                }
            });
            this.initialize();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    void enableContextmenu(boolean enable) {
        if (enable && (this.popupMenu == null || this.contextMenu == null)) {
            this.popupMenu = new Menu((Decorations)this.tabFolder.getShell(), 8);
            this.contextMenu = new ContextMenu(this.popupMenu, this.tabFolder);
            this.contextMenu.create();
        } else {
            this.popupMenu = null;
            this.contextMenu = null;
        }
        this.tcpPortComposite.setMenu(this.popupMenu);
        this.tcpPortDescriptionLabel.setMenu(this.popupMenu);
        this.portNumberLabel.setMenu(this.popupMenu);
        this.timeOutComposite.setMenu(this.popupMenu);
        this.timeOutLabel.setMenu(this.popupMenu);
        this.timeOutButton.setMenu(this.popupMenu);
        this.ReadTimeoutLabel.setMenu(this.popupMenu);
        this.ReadStableIndexLabel.setMenu(this.popupMenu);
        this._WTOCharDelayTimeLabel.setMenu(this.popupMenu);
        this._WTOExtraDelayTimeLabel.setMenu(this.popupMenu);
        this.timeOutDescriptionLabel.setMenu(this.popupMenu);
    }

    public void setDeviceConfig(DeviceConfiguration deviceConfig) {
        this.deviceConfig = deviceConfig;
        if (deviceConfig.getTcpPortType() == null) {
            deviceConfig.createTcpPort();
        }
        this.tcpHostAddress = deviceConfig.getTcpPortType().getAddress();
        this.portNumber = deviceConfig.getTcpPortType().getPort();
        this.respondType = deviceConfig.getTcpPortType().getRespond();
        if (deviceConfig.getTcpPortType().getRequest() != null) {
            this.isUseRequest = true;
            this.requestButton.setSelection(true);
            StringBuilder sb = new StringBuilder();
            for (byte b : deviceConfig.getTcpPortType().getRequest()) {
                sb.append(String.format("%02X", b));
            }
            this.request = sb.toString();
        } else {
            this.isUseRequest = false;
            this.requestButton.setSelection(false);
        }
        if (deviceConfig.getTcpPortType().getTimeOut() != null) {
            this.useTimeOut = true;
            this.timeOutButton.setSelection(true);
        } else {
            this.useTimeOut = false;
            this.timeOutButton.setSelection(false);
        }
        this.ReadTimeout = deviceConfig.getReadTimeOut();
        this.ReadStableIndex = deviceConfig.getReadStableIndex();
        this.WTOCharDelayTime = deviceConfig.getWriteCharDelayTime();
        this.WTOExtraDelayTime = deviceConfig.getWriteDelayTime();
        this.timeOutComposite.redraw();
        this.initialize();
    }

    private int getSelectionIndex(CCombo useCombo, String searchString) {
        int searchIndex = 0;
        for (String item : useCombo.getItems()) {
            if (item.equals(searchString)) break;
            ++searchIndex;
        }
        return searchIndex;
    }

    private void initialize() {
        this.tcpHostAddressText.setText(this.tcpHostAddress);
        this.portNumberText.setText(this.portNumber);
        this.respondCombo.select(this.getSelectionIndex(this.respondCombo, this.respondType.toString()));
        this.requestText.setEnabled(this.isUseRequest);
        this.requestText.setEditable(this.isUseRequest);
        if (this.isUseRequest) {
            this.requestButton.setSelection(true);
            this.requestText.setText(this.request);
        }
        this.ReadTimeoutText.setText("" + this.ReadTimeout);
        this.ReadStableIndexText.setText("" + this.ReadStableIndex);
        this._WTOCharDelayTimeText.setText("" + this.WTOCharDelayTime);
        this._WTOExtraDelayTimeText.setText("" + this.WTOExtraDelayTime);
        this.timeOutButton.setSelection(this.useTimeOut);
        this.enableTimeout();
    }

    private void enableTimeout() {
        if (this.timeOutButton.getSelection()) {
            this.ReadTimeoutLabel.setEnabled(true);
            this.ReadTimeoutText.setEnabled(true);
            this.ReadStableIndexLabel.setEnabled(true);
            this.ReadStableIndexText.setEnabled(true);
            this._WTOCharDelayTimeLabel.setEnabled(true);
            this._WTOCharDelayTimeText.setEnabled(true);
            this._WTOExtraDelayTimeLabel.setEnabled(true);
            this._WTOExtraDelayTimeText.setEnabled(true);
        } else {
            this.ReadTimeoutLabel.setEnabled(false);
            this.ReadTimeoutText.setEnabled(false);
            this.ReadStableIndexLabel.setEnabled(false);
            this.ReadStableIndexText.setEnabled(false);
            this._WTOCharDelayTimeLabel.setEnabled(false);
            this._WTOCharDelayTimeText.setEnabled(false);
            this._WTOExtraDelayTimeLabel.setEnabled(false);
            this._WTOExtraDelayTimeText.setEnabled(false);
        }
    }
}

