/*
 * Decompiled with CFR 0.152.
 */
package gde.histo.recordings;

import gde.log.Logger;
import java.util.Vector;

public final class SuiteRecord
extends Vector<Integer> {
    private static final String $CLASS_NAME = SuiteRecord.class.getName();
    private static final long serialVersionUID = 8757759753520551985L;
    private static final Logger log = Logger.getLogger($CLASS_NAME);
    private final int trailOrdinal;
    private int maxRecordValue = Integer.MIN_VALUE;
    private int minRecordValue = Integer.MAX_VALUE;

    public SuiteRecord(int newTrailOrdinal, int initialCapacity) {
        super(initialCapacity);
        this.trailOrdinal = newTrailOrdinal;
    }

    @Override
    public synchronized void addElement(Integer point) {
        if (point == null) {
            if (this.isEmpty()) {
                this.maxRecordValue = Integer.MIN_VALUE;
                this.minRecordValue = Integer.MAX_VALUE;
            }
        } else if (this.isEmpty()) {
            this.minRecordValue = this.maxRecordValue = point.intValue();
        } else {
            if (point > this.maxRecordValue) {
                this.maxRecordValue = point;
            }
            if (point < this.minRecordValue) {
                this.minRecordValue = point;
            }
        }
        super.addElement(point);
        log.finer(() -> this.trailOrdinal + " adding point = " + point);
        log.finest(() -> this.trailOrdinal + " minValue = " + this.minRecordValue + " maxValue = " + this.maxRecordValue);
    }

    public int getTrailOrdinal() {
        return this.trailOrdinal;
    }

    public int getMaxRecordValue() {
        return this.maxRecordValue;
    }

    public int getMinRecordValue() {
        return this.minRecordValue;
    }
}

