/*
 * Decompiled with CFR 0.152.
 */
package gde.device.skyrc;

import gde.GDE;
import gde.data.Channels;
import gde.device.DeviceDialog;
import gde.device.IDevice;
import gde.device.MeasurementType;
import gde.device.skyrc.MC3000;
import gde.device.skyrc.MC3000Dialog;
import gde.device.skyrc.MC3000UsbPort;
import gde.messages.Messages;
import gde.ui.DataExplorer;
import gde.ui.MeasurementControl;
import gde.ui.SWTResourceManager;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Logger;
import org.eclipse.swt.custom.CTabFolder;
import org.eclipse.swt.custom.CTabItem;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;

public class MC3000TabItem
extends CTabItem {
    static final Logger log = Logger.getLogger(MC3000TabItem.class.getName());
    Composite measurementComposite;
    Button measurement;
    Button inputFileButton;
    Composite buttonComposite;
    Button stopCollectDataButton;
    Button startCollectDataButton;
    Label measurementUnitLabel;
    Label measurementSymbolLabel;
    Label tabItemLabel;
    Composite mainTabComposite;
    boolean isVisibilityChanged = false;
    final CTabFolder parent;
    final MC3000 device;
    final MC3000UsbPort serialPort;
    final DataExplorer application;
    final Channels channels;
    final MC3000Dialog dialog;
    final int channelConfigNumber;
    final List<MeasurementControl> measurementTypes = new ArrayList<MeasurementControl>();

    public MC3000TabItem(CTabFolder parentTabFolder, MC3000Dialog parentDialog, int useChannelConfigNumber, MC3000 useDevice) {
        super(parentTabFolder, 0);
        this.parent = parentTabFolder;
        this.dialog = parentDialog;
        this.device = useDevice;
        this.serialPort = useDevice.getCommunicationPort();
        this.application = DataExplorer.getInstance();
        this.channels = Channels.getInstance();
        this.channelConfigNumber = useChannelConfigNumber;
        this.setText(this.device.getChannelNameReplacement(this.channelConfigNumber));
        this.create();
    }

    void create() {
        this.mainTabComposite = new Composite((Composite)this.parent, 0);
        GridLayout mainTabCompositeLayout = new GridLayout();
        mainTabCompositeLayout.makeColumnsEqualWidth = true;
        mainTabCompositeLayout.numColumns = 2;
        this.mainTabComposite.setLayout((Layout)mainTabCompositeLayout);
        this.setControl((Control)this.mainTabComposite);
        this.tabItemLabel = new Label(this.mainTabComposite, 0x1000000);
        GridData tabItemLabelLData = new GridData();
        tabItemLabelLData.horizontalSpan = 2;
        tabItemLabelLData.grabExcessHorizontalSpace = true;
        tabItemLabelLData.horizontalAlignment = 2;
        tabItemLabelLData.verticalAlignment = 1;
        tabItemLabelLData.heightHint = 25;
        tabItemLabelLData.widthHint = 595;
        this.tabItemLabel.setLayoutData((Object)tabItemLabelLData);
        this.tabItemLabel.setFont(SWTResourceManager.getFont((String)GDE.WIDGET_FONT_NAME, (int)(GDE.WIDGET_FONT_SIZE + 2), (int)1));
        this.tabItemLabel.setText(Messages.getString((String)"GDE_MSGT3601"));
        for (int i = 0; i < this.device.getChannelMeasuremtsReplacedNames(this.channelConfigNumber).size(); ++i) {
            this.measurementTypes.add(new MeasurementControl(this.mainTabComposite, (DeviceDialog)this.dialog, this.channelConfigNumber, i, (MeasurementType)this.device.getChannelMeasuremtsReplacedNames(this.channelConfigNumber).get(i), (IDevice)this.device, i == 10 ? 2 : 1));
        }
    }
}

