/*
 * Decompiled with CFR 0.152.
 */
package gde.device.skyrc;

import gde.data.Channel;
import gde.data.Channels;
import gde.device.DeviceConfiguration;
import gde.device.DeviceDialog;
import gde.device.skyrc.Q200;
import gde.device.skyrc.Q200UsbPort;
import gde.device.skyrc.X200neoGathererThread;
import gde.exception.ApplicationConfigurationException;
import gde.io.DataParser;
import gde.log.Level;
import gde.messages.Messages;
import gde.utils.StringHelper;
import gde.utils.WaitTimer;
import java.io.FileNotFoundException;
import java.util.logging.Logger;
import javax.usb.UsbClaimException;
import javax.usb.UsbException;
import javax.xml.bind.JAXBException;

public class D200neo
extends Q200 {
    static final Logger log1 = Logger.getLogger(D200neo.class.getName());
    X200neoGathererThread xdataGatherThread;
    SystemInfo[] neoSystemInfo = new SystemInfo[4];

    public D200neo(String xmlFileName) throws FileNotFoundException, JAXBException {
        super(xmlFileName);
    }

    public D200neo(DeviceConfiguration deviceConfig) {
        super(deviceConfig);
    }

    @Override
    public String getHarwareString(int channelId) {
        return this.neoSystemInfo[channelId - 1].getHardwareVersion();
    }

    @Override
    public String getFirmwareString(int channelId) {
        return this.neoSystemInfo[channelId - 1].getFirmwareVersion();
    }

    @Override
    public DeviceDialog getDialog() {
        return null;
    }

    @Override
    public int[] convertDataBytes(int[] points, byte[] dataBuffer) {
        int maxVoltage = Integer.MIN_VALUE;
        int minVoltage = Integer.MAX_VALUE;
        log1.log(Level.FINE, StringHelper.byte2Hex2CharString((byte[])dataBuffer, (int)dataBuffer.length));
        points[0] = DataParser.parse2Short((byte)dataBuffer[10], (byte)dataBuffer[9]);
        points[1] = DataParser.parse2Short((byte)dataBuffer[12], (byte)dataBuffer[11]);
        points[2] = DataParser.parse2Short((byte)dataBuffer[6], (byte)dataBuffer[5]) * 1000;
        points[3] = Double.valueOf((double)points[0] / 1000.0 * (double)points[1]).intValue();
        switch (dataBuffer[1]) {
            case 0: {
                switch (dataBuffer[3]) {
                    case 1: {
                        this.energy[0] = this.energy[0] + (double)points[0] / 1000.0 * (double)points[1] / 3600.0;
                        points[4] = Double.valueOf(this.energy[0]).intValue();
                        break;
                    }
                    case 2: {
                        this.energy[1] = this.energy[1] + (double)points[0] / 1000.0 * (double)points[1] / 3600.0;
                        points[4] = Double.valueOf(this.energy[1]).intValue();
                        break;
                    }
                    case 4: {
                        this.energy[2] = this.energy[2] + (double)points[0] / 1000.0 * (double)points[1] / 3600.0;
                        points[4] = Double.valueOf(this.energy[2]).intValue();
                        break;
                    }
                    case 8: {
                        this.energy[3] = this.energy[3] + (double)points[0] / 1000.0 * (double)points[1] / 3600.0;
                        points[4] = Double.valueOf(this.energy[3]).intValue();
                        break;
                    }
                }
                if (!log1.isLoggable(java.util.logging.Level.FINE)) break;
                log1.log(java.util.logging.Level.FINE, "add up Energy");
                break;
            }
            case 1: {
                switch (dataBuffer[3]) {
                    case 1: {
                        this.energy[0] = 0.0;
                        points[4] = 0;
                        break;
                    }
                    case 2: {
                        this.energy[1] = 0.0;
                        points[4] = 0;
                        break;
                    }
                    case 4: {
                        this.energy[2] = 0.0;
                        points[4] = 0;
                        break;
                    }
                    case 8: {
                        this.energy[3] = 0.0;
                        points[4] = 0;
                        break;
                    }
                }
                points[4] = 0;
                if (!log1.isLoggable(java.util.logging.Level.FINE)) break;
                log1.log(java.util.logging.Level.FINE, "reset Energy");
                break;
            }
            default: {
                points[4] = points[4];
                if (!log1.isLoggable(java.util.logging.Level.FINE)) break;
                log1.log(java.util.logging.Level.FINE, "untouche Energy");
            }
        }
        points[5] = dataBuffer[14] * 1000;
        points[6] = DataParser.parse2Short((byte)dataBuffer[16], (byte)dataBuffer[15]) * 100;
        if (dataBuffer[0] <= 3) {
            int j = 0;
            int i = 8;
            while (i < points.length) {
                if (dataBuffer[j + 17] != 0) {
                    points[i] = DataParser.parse2Short((byte)dataBuffer[j + 18], (byte)dataBuffer[j + 17]);
                    maxVoltage = points[i] > maxVoltage ? points[i] : maxVoltage;
                    minVoltage = points[i] < minVoltage ? points[i] : minVoltage;
                } else {
                    points[i] = 0;
                }
                ++i;
                j += 2;
            }
            points[7] = 1000 * (maxVoltage != Integer.MIN_VALUE && minVoltage != Integer.MAX_VALUE ? maxVoltage - minVoltage : 0);
        }
        return points;
    }

    @Override
    public void open_closeCommPort() {
        block27: {
            if (this.usbPort != null) {
                if (!this.usbPort.isConnected()) {
                    try {
                        Channel activChannel = Channels.getInstance().getActiveChannel();
                        if (activChannel == null) break block27;
                        this.xdataGatherThread = new X200neoGathererThread(this.application, this, this.usbPort, activChannel.getNumber(), this.getDialog());
                        try {
                            if (this.xdataGatherThread != null && this.usbPort.isConnected()) {
                                block18: for (int i = 0; i < this.neoSystemInfo.length; ++i) {
                                    switch (i) {
                                        default: {
                                            this.neoSystemInfo[i] = new SystemInfo(this, this.usbPort.getSystemInfo(this.xdataGatherThread.getUsbInterface(), Q200UsbPort.QuerySystemInfo.CHANNEL_A.value()));
                                            this.systemSetting[i] = new Q200.SystemSetting(this, this.usbPort.getSystemSetting(this.xdataGatherThread.getUsbInterface(), Q200UsbPort.QuerySystemSetting.CHANNEL_A.value()));
                                            continue block18;
                                        }
                                        case 1: {
                                            this.neoSystemInfo[i] = new SystemInfo(this, this.usbPort.getSystemInfo(this.xdataGatherThread.getUsbInterface(), Q200UsbPort.QuerySystemInfo.CHANNEL_B.value()));
                                            this.systemSetting[i] = new Q200.SystemSetting(this, this.usbPort.getSystemSetting(this.xdataGatherThread.getUsbInterface(), Q200UsbPort.QuerySystemSetting.CHANNEL_B.value()));
                                            continue block18;
                                        }
                                        case 2: {
                                            this.neoSystemInfo[i] = new SystemInfo(this, this.usbPort.getSystemInfo(this.xdataGatherThread.getUsbInterface(), Q200UsbPort.QuerySystemInfo.CHANNEL_C.value()));
                                            this.systemSetting[i] = new Q200.SystemSetting(this, this.usbPort.getSystemSetting(this.xdataGatherThread.getUsbInterface(), Q200UsbPort.QuerySystemSetting.CHANNEL_C.value()));
                                            continue block18;
                                        }
                                        case 3: {
                                            this.neoSystemInfo[i] = new SystemInfo(this, this.usbPort.getSystemInfo(this.xdataGatherThread.getUsbInterface(), Q200UsbPort.QuerySystemInfo.CHANNEL_D.value()));
                                            this.systemSetting[i] = new Q200.SystemSetting(this, this.usbPort.getSystemSetting(this.xdataGatherThread.getUsbInterface(), Q200UsbPort.QuerySystemSetting.CHANNEL_D.value()));
                                        }
                                    }
                                }
                                WaitTimer.delay((long)100L);
                                this.xdataGatherThread.start();
                            }
                        }
                        catch (Throwable e) {
                            log1.log(java.util.logging.Level.SEVERE, e.getMessage(), e);
                        }
                    }
                    catch (UsbClaimException e) {
                        log1.log(java.util.logging.Level.SEVERE, e.getMessage(), e);
                        this.application.openMessageDialog(this.dialog.getDialogShell(), Messages.getString((String)"GDE_MSGE0051", (Object[])new Object[]{((Object)((Object)e)).getClass().getSimpleName() + " : " + e.getMessage()}));
                        try {
                            if (this.usbPort != null && this.usbPort.isConnected()) {
                                this.usbPort.closeUsbPort(null);
                            }
                        }
                        catch (UsbException ex) {
                            log1.log(java.util.logging.Level.SEVERE, ex.getMessage(), ex);
                        }
                    }
                    catch (UsbException e) {
                        log1.log(java.util.logging.Level.SEVERE, e.getMessage(), e);
                        this.application.openMessageDialog(this.dialog.getDialogShell(), Messages.getString((String)"GDE_MSGE0050"));
                        try {
                            if (this.usbPort != null && this.usbPort.isConnected()) {
                                this.usbPort.closeUsbPort(null);
                            }
                        }
                        catch (UsbException ex) {
                            log1.log(java.util.logging.Level.SEVERE, ex.getMessage(), ex);
                        }
                    }
                    catch (ApplicationConfigurationException e) {
                        log1.log(java.util.logging.Level.SEVERE, e.getMessage(), e);
                        this.application.openMessageDialog(this.dialog.getDialogShell(), Messages.getString((String)"GDE_MSGE0010"));
                        this.application.getDeviceSelectionDialog().open();
                    }
                    catch (Throwable e) {
                        log1.log(java.util.logging.Level.SEVERE, e.getMessage(), e);
                    }
                } else {
                    if (this.xdataGatherThread != null) {
                        this.xdataGatherThread.stopDataGatheringThread(false, null);
                    }
                    try {
                        WaitTimer.delay((long)1000L);
                        if (this.usbPort != null && this.usbPort.isConnected()) {
                            this.usbPort.closeUsbPort(null);
                        }
                    }
                    catch (UsbException e) {
                        log1.log(java.util.logging.Level.SEVERE, e.getMessage(), e);
                    }
                }
            }
        }
    }

    protected class SystemInfo {
        byte channelId;
        byte[] machineId = new byte[16];

        public SystemInfo(D200neo this$0, byte[] buffer) {
            this.channelId = buffer[4];
            for (int i = 0; i < 15; ++i) {
                this.machineId[i] = buffer[i + 5];
            }
        }

        public byte getChannelId() {
            return this.channelId;
        }

        public String getFirmwareVersion() {
            return String.format("Firmware: %d.%02d", this.machineId[11], this.machineId[12]);
        }

        public int getFirmwareVersionAsInt() {
            return Integer.valueOf(String.format("%d%02d", this.machineId[11], this.machineId[12]));
        }

        public String getHardwareVersion() {
            return String.format("Hardware: %d.0", this.machineId[13]);
        }

        public int getHardwareVersionAsInt() {
            return this.machineId[13];
        }
    }
}

