/*
 * Decompiled with CFR 0.152.
 */
package gde.device.smmodellbau;

import gde.data.Channel;
import gde.data.Channels;
import gde.data.RecordSet;
import gde.device.IDevice;
import gde.device.smmodellbau.UniLog;
import gde.device.smmodellbau.UniLogDialog;
import gde.device.smmodellbau.UniLogSerialPort;
import gde.exception.ApplicationConfigurationException;
import gde.exception.DataInconsitsentException;
import gde.exception.TimeOutException;
import gde.log.Level;
import gde.messages.Messages;
import gde.ui.DataExplorer;
import gde.utils.CalculationThread;
import gde.utils.WaitTimer;
import java.io.IOException;
import java.util.Vector;
import java.util.logging.Logger;

public class UniLogDataGatherer
extends Thread {
    static final Logger log = Logger.getLogger(UniLogDataGatherer.class.getName());
    final DataExplorer application;
    final UniLogSerialPort serialPort;
    final UniLogDialog dialog;
    final UniLog device;
    final Integer channelNumber;
    final String configKey;
    CalculationThread calculationThread;

    public UniLogDataGatherer(DataExplorer currrentApplication, UniLog useDevice, UniLogSerialPort useSerialPort, String useConfigKey) {
        super("dataGatherer");
        this.application = currrentApplication;
        this.device = useDevice;
        this.serialPort = useSerialPort;
        this.dialog = useDevice.getDialog();
        this.channelNumber = Integer.valueOf(useConfigKey.trim().split(":")[0].trim());
        this.configKey = useConfigKey.trim().split(":")[1].trim();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        if (log.isLoggable(Level.FINE)) {
            log.log(Level.FINE, "entry data gatherer : " + this.channelNumber + " : " + this.configKey);
        }
        Channel channel = (Channel)Channels.getInstance().get((Object)this.channelNumber);
        String recordSetKey = null;
        RecordSet recordSet = null;
        boolean isPortOpenedByMe = false;
        try {
            if (!this.serialPort.isConnected()) {
                this.serialPort.open();
                isPortOpenedByMe = true;
                WaitTimer.delay((long)3000L);
            }
            byte[] readBuffer = this.serialPort.readConfiguration();
            if (this.dialog != null) {
                this.dialog.updateConfigurationValues(readBuffer);
                this.dialog.updateActualConfigTabItemAnalogModi(this.channelNumber);
                this.dialog.resetDataSetsLabel();
            }
            this.serialPort.setTransmitFinished(false);
            Vector<Vector<byte[]>> dataCollection = this.serialPort.getData(this.dialog);
            if (log.isLoggable(Level.FINE)) {
                log.log(Level.FINE, "back from gathering data");
            }
            for (Vector<byte[]> telegrams : dataCollection) {
                recordSetKey = channel.getNextRecordSetNumber() + this.device.getRecordSetStemNameReplacement();
                this.device.updateMeasurementByAnalogModi(telegrams.get(3), this.channelNumber);
                channel.put((Object)recordSetKey, (Object)RecordSet.createRecordSet((String)recordSetKey, (IDevice)this.device, (int)channel.getNumber(), (boolean)true, (boolean)false, (boolean)true));
                if (log.isLoggable(Level.FINE)) {
                    log.log(Level.FINE, recordSetKey + " created");
                }
                recordSet = (RecordSet)channel.get((Object)recordSetKey);
                this.device.updateInitialRecordSetComment(recordSet);
                channel.applyTemplateBasics(recordSetKey);
                int[] points = new int[recordSet.realSize()];
                for (int j = 2; j < telegrams.size(); ++j) {
                    byte[] dataBuffer = telegrams.get(j);
                    recordSet.addPoints(this.device.convertDataBytes(points, dataBuffer));
                }
                if (channel.getActiveRecordSet() == null) {
                    Channels.getInstance().switchChannel(this.channelNumber.intValue(), recordSetKey);
                    channel.switchRecordSet(recordSetKey);
                }
                this.device.makeInActiveDisplayable(recordSet);
                this.application.updateStatisticsData();
                this.application.updateDataTable(recordSetKey, false);
            }
            this.application.getMenuToolBar().updateRecordSetSelectCombo();
            if (log.isLoggable(Level.FINE)) {
                log.log(Level.FINE, "exit data gatherer");
            }
        }
        catch (DataInconsitsentException e) {
            log.log(Level.SEVERE, e.getMessage(), e);
            this.application.openMessageDialog(this.dialog.getDialogShell(), Messages.getString((String)"GDE_MSGE0028", (Object[])new Object[]{((Object)((Object)e)).getClass().getSimpleName(), e.getMessage()}));
        }
        catch (ApplicationConfigurationException e) {
            log.log(Level.SEVERE, e.getMessage(), e);
            this.application.openMessageDialog(this.dialog.getDialogShell(), ((Object)((Object)e)).getClass().getSimpleName() + " - " + e.getMessage());
        }
        catch (TimeOutException e) {
            log.log(Level.SEVERE, e.getMessage(), e);
            this.application.openMessageDialog(this.dialog.getDialogShell(), Messages.getString((String)"GDE_MSGE0022", (Object[])new Object[]{((Object)((Object)e)).getClass().getSimpleName(), e.getMessage()}) + System.getProperty("line.separator") + Messages.getString((String)"GDE_MSGW1300"));
        }
        catch (IOException e) {
            log.log(Level.SEVERE, e.getMessage(), e);
            this.application.openMessageDialog(this.dialog.getDialogShell(), Messages.getString((String)"GDE_MSGE0022", (Object[])new Object[]{e.getClass().getSimpleName(), e.getMessage()}) + System.getProperty("line.separator") + Messages.getString((String)"GDE_MSGW1300"));
        }
        catch (Throwable e) {
            log.log(Level.SEVERE, e.getMessage(), e);
            this.application.openMessageDialog(this.dialog.getDialogShell(), e.getClass().getSimpleName() + " - " + e.getMessage());
        }
        finally {
            this.device.getDialog().resetButtons();
            if (isPortOpenedByMe) {
                this.serialPort.close();
            }
        }
    }

    public void setThreadStop() {
        try {
            WaitTimer.delay((long)5L);
            this.serialPort.setTransmitFinished(true);
        }
        catch (Exception e) {
            log.log(Level.WARNING, e.getMessage());
        }
    }
}

