/*
 * Decompiled with CFR 0.152.
 */
package gde.device.htronic;

import gde.config.Settings;
import gde.data.Channel;
import gde.data.Channels;
import gde.data.Record;
import gde.data.RecordSet;
import gde.device.DeviceConfiguration;
import gde.device.IDevice;
import gde.device.htronic.AkkuMasterC4Dialog;
import gde.device.htronic.AkkuMasterC4SerialPort;
import gde.device.htronic.AkkuMasterCalculationThread;
import gde.exception.DataInconsitsentException;
import gde.log.Level;
import gde.messages.Messages;
import gde.ui.DataExplorer;
import java.io.FileNotFoundException;
import java.util.HashMap;
import java.util.Locale;
import java.util.logging.Logger;
import javax.xml.bind.JAXBException;

public class AkkuMasterC4
extends DeviceConfiguration
implements IDevice {
    static final Logger log = Logger.getLogger(AkkuMasterC4.class.getName());
    final DataExplorer application;
    final AkkuMasterC4Dialog dialog;
    final AkkuMasterC4SerialPort serialPort;
    final Channels channels;
    HashMap<String, AkkuMasterCalculationThread> calculationThreads = new HashMap();

    public AkkuMasterC4(String deviceProperties) throws FileNotFoundException, JAXBException {
        super(deviceProperties);
        Messages.setDeviceResourceBundle((String)"gde.device.htronic.messages", (Locale)Settings.getInstance().getLocale(), (ClassLoader)((Object)((Object)this)).getClass().getClassLoader());
        this.application = DataExplorer.getInstance();
        this.serialPort = new AkkuMasterC4SerialPort(this, this.application);
        this.dialog = new AkkuMasterC4Dialog(this.application.getShell(), this);
        this.channels = Channels.getInstance();
        if (this.application.getMenuToolBar() != null) {
            this.configureSerialPortMenu(1, "", "");
        }
    }

    public AkkuMasterC4(DeviceConfiguration deviceConfig) {
        super(deviceConfig);
        Messages.setDeviceResourceBundle((String)"gde.device.htronic.messages", (Locale)Settings.getInstance().getLocale(), (ClassLoader)((Object)((Object)this)).getClass().getClassLoader());
        this.application = DataExplorer.getInstance();
        this.serialPort = new AkkuMasterC4SerialPort(this, this.application);
        this.dialog = new AkkuMasterC4Dialog(this.application.getShell(), this);
        this.channels = Channels.getInstance();
        this.configureSerialPortMenu(1, "", "");
    }

    public HashMap<String, String> getLovKeyMappings(HashMap<String, String> lov2osdMap) {
        return lov2osdMap;
    }

    public String getConvertedRecordConfigurations(HashMap<String, String> header, HashMap<String, String> lov2osdMap, int channelNumber) {
        return "";
    }

    public int getLovDataByteSize() {
        return 55;
    }

    public synchronized void addConvertedLovDataBufferAsRawDataPoints(RecordSet recordSet, byte[] dataBuffer, int recordDataSize, boolean doUpdateProgressBar) throws DataInconsitsentException {
        int lovDataSize = this.getLovDataByteSize();
        byte[] convertDataBuffer = new byte[30];
        int[] points = new int[this.getNumberOfMeasurements(1)];
        String sThreadId = String.format("%06d", Thread.currentThread().threadId());
        int progressCycle = 0;
        if (doUpdateProgressBar) {
            this.application.setProgress(progressCycle, sThreadId);
        }
        for (int i = 0; i < recordDataSize; ++i) {
            System.arraycopy(dataBuffer, 4 + i * lovDataSize, convertDataBuffer, 0, 14);
            System.arraycopy(dataBuffer, 23 + i * lovDataSize, convertDataBuffer, 14, 16);
            recordSet.addPoints(this.convertDataBytes(points, convertDataBuffer));
            if (!doUpdateProgressBar || i % 50 != 0) continue;
            this.application.setProgress(++progressCycle * 5000 / recordDataSize, sThreadId);
        }
        if (doUpdateProgressBar) {
            this.application.setProgress(100, sThreadId);
        }
    }

    public int[] convertDataBytes(int[] points, byte[] dataBuffer) {
        HashMap<String, Object> values = new HashMap<String, Object>(7);
        byte[] configurationBuffer = new byte[14];
        System.arraycopy(dataBuffer, 0, configurationBuffer, 0, configurationBuffer.length);
        byte[] measurementsBuffer = new byte[16];
        System.arraycopy(dataBuffer, 14, measurementsBuffer, 0, measurementsBuffer.length);
        values = AkkuMasterC4SerialPort.getConvertedValues(values, AkkuMasterC4SerialPort.convertConfigurationAnswer(configurationBuffer), AkkuMasterC4SerialPort.convertMeasurementValues(measurementsBuffer));
        points[0] = (Integer)values.get(AkkuMasterC4SerialPort.PROCESS_VOLTAGE);
        points[1] = (Integer)values.get(AkkuMasterC4SerialPort.PROCESS_CURRENT);
        points[2] = (Integer)values.get(AkkuMasterC4SerialPort.PROCESS_CAPACITY) * 1000;
        points[3] = Double.valueOf((double)points[0] / 1000.0 * ((double)points[1] / 1000.0) * 1000.0).intValue();
        points[4] = Double.valueOf((double)points[0] / 1000.0 * ((double)points[2] / 1000.0)).intValue();
        log.log(Level.FINE, points[0] + " mV; " + points[1] + " mA; " + points[2] + " mAh; " + points[3] + " mW; " + points[4] + " mWh");
        return points;
    }

    public void addDataBufferAsRawDataPoints(RecordSet recordSet, byte[] dataBuffer, int recordDataSize, boolean doUpdateProgressBar) throws DataInconsitsentException {
        int dataBufferSize = 4 * recordSet.getNoneCalculationRecordNames().length;
        byte[] convertBuffer = new byte[dataBufferSize];
        int[] points = new int[recordSet.size()];
        String sThreadId = String.format("%06d", Thread.currentThread().threadId());
        int progressCycle = 0;
        if (doUpdateProgressBar) {
            this.application.setProgress(progressCycle, sThreadId);
        }
        for (int i = 0; i < recordDataSize; ++i) {
            System.arraycopy(dataBuffer, i * dataBufferSize, convertBuffer, 0, dataBufferSize);
            points[0] = ((convertBuffer[0] & 0xFF) << 24) + ((convertBuffer[1] & 0xFF) << 16) + ((convertBuffer[2] & 0xFF) << 8) + ((convertBuffer[3] & 0xFF) << 0);
            points[1] = ((convertBuffer[4] & 0xFF) << 24) + ((convertBuffer[5] & 0xFF) << 16) + ((convertBuffer[6] & 0xFF) << 8) + ((convertBuffer[7] & 0xFF) << 0);
            points[2] = ((convertBuffer[8] & 0xFF) << 24) + ((convertBuffer[9] & 0xFF) << 16) + ((convertBuffer[10] & 0xFF) << 8) + ((convertBuffer[11] & 0xFF) << 0);
            points[3] = Double.valueOf((double)points[0] / 1000.0 * ((double)points[1] / 1000.0) * 1000.0).intValue();
            points[4] = Double.valueOf((double)points[0] / 1000.0 * ((double)points[2] / 1000.0)).intValue();
            log.log(Level.FINE, points[0] + " mV; " + points[1] + " mA; " + points[2] + " mAh; " + points[3] + " mW; " + points[4] + " mWh");
            recordSet.addPoints(points);
            if (!doUpdateProgressBar || i % 50 != 0) continue;
            this.application.setProgress(++progressCycle * 5000 / recordDataSize, sThreadId);
        }
        if (doUpdateProgressBar) {
            this.application.setProgress(100, sThreadId);
        }
        recordSet.syncScaleOfSyncableRecords();
    }

    public String[] prepareDataTableRow(RecordSet recordSet, String[] dataTableRow, int rowIndex) {
        try {
            int index = 0;
            for (Record record : recordSet.getVisibleAndDisplayableRecordsForTable()) {
                dataTableRow[index + 1] = record.getDecimalFormat().format((double)record.realGet(rowIndex).intValue() / 1000.0);
                ++index;
            }
        }
        catch (RuntimeException e) {
            log.log(Level.SEVERE, e.getMessage(), e);
        }
        return dataTableRow;
    }

    public double translateValue(Record record, double value) {
        double newValue = value;
        log.log(Level.FINEST, String.format("input value for %s - %f", record.getName(), value));
        log.log(Level.FINEST, String.format("value calculated for %s - %f", record.getName(), newValue));
        return newValue;
    }

    public double reverseTranslateValue(Record record, double value) {
        double newValue = value;
        log.log(Level.FINEST, String.format("input value for %s - %f", record.getName(), value));
        log.log(Level.FINEST, String.format("value calculated for %s - %f", record.getName(), newValue));
        return newValue;
    }

    public void updateVisibilityStatus(RecordSet recordSet, boolean includeReasonableDataCheck) {
        recordSet.setAllDisplayable();
    }

    public void makeInActiveDisplayable(RecordSet recordSet) {
        if (recordSet.isRaw()) {
            try {
                Record record = recordSet.get(3);
                if (record != null && (record.size() == 0 || record.getRealMinValue() == 0 && record.getRealMaxValue() == 0)) {
                    this.calculationThreads.put(record.getName(), new AkkuMasterCalculationThread(record.getName(), this.channels.getActiveChannel().getActiveRecordSet()));
                    try {
                        this.calculationThreads.get(record.getName()).start();
                    }
                    catch (RuntimeException e) {
                        log.log(Level.WARNING, e.getMessage(), e);
                    }
                }
                if ((record = recordSet.get(4)) != null && (record.size() == 0 || record.getRealMinValue() == 0 && record.getRealMaxValue() == 0)) {
                    this.calculationThreads.put(record.getName(), new AkkuMasterCalculationThread(record.getName(), this.channels.getActiveChannel().getActiveRecordSet()));
                    try {
                        this.calculationThreads.get(record.getName()).start();
                    }
                    catch (RuntimeException e) {
                        log.log(Level.WARNING, e.getMessage(), e);
                    }
                }
            }
            catch (RuntimeException e) {
                log.log(Level.SEVERE, e.getMessage(), e);
            }
        }
    }

    public AkkuMasterC4Dialog getDialog() {
        return this.dialog;
    }

    public AkkuMasterC4SerialPort getCommunicationPort() {
        return this.serialPort;
    }

    public String[] getUsedPropertyKeys() {
        return new String[0];
    }

    public void open_closeCommPort() {
        if (this.serialPort != null) {
            if (!this.serialPort.isConnected()) {
                Channel activChannel = Channels.getInstance().getActiveChannel();
                if (activChannel != null) {
                    if (this.getDialog().isDisposed()) {
                        this.getDialog().open();
                    } else {
                        this.getDialog().startUpdateVersionThread();
                    }
                }
            } else {
                this.serialPort.close();
            }
        }
    }

    public int getCurrentSmoothIndex() {
        return 2;
    }
}

