/*
 * Decompiled with CFR 0.152.
 */
package gde.device.wb;

import gde.data.Channel;
import gde.data.Channels;
import gde.device.DeviceConfiguration;
import gde.device.wb.AV4msSerialPort;
import gde.device.wb.CSV2SerialAdapter;
import gde.device.wb.GathererThread_AV4ms;
import gde.exception.ApplicationConfigurationException;
import gde.exception.SerialPortException;
import gde.log.Level;
import gde.messages.Messages;
import java.io.FileNotFoundException;
import javax.xml.bind.JAXBException;

public class AV4ms_FV_762
extends CSV2SerialAdapter {
    protected final AV4msSerialPort serialPort;
    protected GathererThread_AV4ms gathererThread;

    public AV4ms_FV_762(String deviceProperties) throws FileNotFoundException, JAXBException {
        super(deviceProperties);
        this.serialPort = new AV4msSerialPort(this, this.application);
    }

    public AV4ms_FV_762(DeviceConfiguration deviceConfig) {
        super(deviceConfig);
        this.serialPort = new AV4msSerialPort(this, this.application);
    }

    public boolean recordSetNumberFollowChannel() {
        return true;
    }

    public boolean useChannelWithSyncedDescription() {
        return true;
    }

    @Override
    public void open_closeCommPort() {
        block14: {
            if (this.isSerialIO) {
                if (this.serialPort != null) {
                    if (!this.serialPort.isConnected()) {
                        try {
                            Channel activChannel = Channels.getInstance().getActiveChannel();
                            if (activChannel == null) break block14;
                            this.gathererThread = new GathererThread_AV4ms(this.application, this, this.serialPort, activChannel.getNumber());
                            try {
                                if (this.serialPort.isConnected()) {
                                    this.gathererThread.start();
                                }
                            }
                            catch (RuntimeException e) {
                                log.log(Level.SEVERE, e.getMessage(), e);
                            }
                            catch (Throwable e) {
                                log.log(Level.SEVERE, e.getMessage(), e);
                            }
                        }
                        catch (SerialPortException e) {
                            log.log(Level.SEVERE, e.getMessage(), e);
                            this.application.openMessageDialog(Messages.getString((String)"GDE_MSGE0015", (Object[])new Object[]{((Object)((Object)e)).getClass().getSimpleName() + " : " + e.getMessage()}));
                        }
                        catch (ApplicationConfigurationException e) {
                            log.log(Level.SEVERE, e.getMessage(), e);
                            this.application.openMessageDialog(Messages.getString((String)"GDE_MSGE0010"));
                            this.application.getDeviceSelectionDialog().open();
                        }
                        catch (Throwable e) {
                            log.log(Level.SEVERE, e.getMessage(), e);
                        }
                    } else {
                        if (this.gathererThread != null) {
                            this.gathererThread.stopDataGatheringThread(false, null);
                        }
                        this.serialPort.close();
                    }
                }
            } else {
                this.importCsvFiles();
            }
        }
    }
}

