/*
 * Decompiled with CFR 0.152.
 */
package gde.device.renschler;

import gde.comm.DeviceCommPort;
import gde.device.IDevice;
import gde.device.renschler.Picolario;
import gde.device.renschler.PicolarioDialog;
import gde.log.Level;
import gde.messages.Messages;
import gde.ui.DataExplorer;
import gde.utils.Checksum;
import gde.utils.WaitTimer;
import java.io.IOException;
import java.util.Vector;
import java.util.logging.Logger;

public class PicolarioSerialPort
extends DeviceCommPort {
    static final Logger log = Logger.getLogger(PicolarioSerialPort.class.getName());
    boolean isTransmitFinished = false;
    final byte[] readNumberRecordSets = new byte[]{-86, -86};
    final byte[] readRecordSets = new byte[]{-86, 0};

    public PicolarioSerialPort(IDevice currentDevice, DataExplorer currentApplication) {
        super(currentDevice, currentApplication);
    }

    public int readNumberAvailableRecordSets() throws Exception {
        int recordSets = 0;
        boolean isPortOpenedByMe = false;
        try {
            if (!this.isConnected()) {
                this.open();
                isPortOpenedByMe = true;
            }
            this.write(this.readNumberRecordSets);
            WaitTimer.delay((long)30L);
            this.write(this.readNumberRecordSets);
            byte[] answer = new byte[4];
            answer = this.read(answer, 2000);
            if (answer[0] != this.readNumberRecordSets[0] && answer[2] != this.readNumberRecordSets[0]) {
                throw new IOException(Messages.getString((String)"GDE_MSGE1201"));
            }
            recordSets = answer[1] & 0xFF;
        }
        catch (Exception e) {
            this.close();
            log.log(Level.SEVERE, e.getMessage(), e);
            throw e;
        }
        finally {
            if (isPortOpenedByMe) {
                this.close();
            }
        }
        log.log(Level.FINE, "number available record sets = " + recordSets);
        return recordSets;
    }

    public Vector<byte[]> getData(int datagramNumber, Picolario picolario) throws Exception {
        Vector<byte[]> dataBuffer = new Vector<byte[]>(100);
        int numberRed = 0;
        byte[] readRecordSetsWithNumber = new byte[]{this.readRecordSets[0], (byte)datagramNumber, this.readRecordSets[0], (byte)datagramNumber};
        try {
            this.write(readRecordSetsWithNumber);
            this.isTransmitFinished = false;
            WaitTimer.delay((long)256L);
            while (!this.isTransmitFinished) {
                ((PicolarioDialog)picolario.getDialog()).setAlreadyRedText(numberRed++);
                byte[] readBuffer = new byte[31];
                readBuffer = this.read(readBuffer, 2000, 100);
                if (readBuffer.length != 0) {
                    if (this.checkGoodPackage(readBuffer, 31, 3)) {
                        dataBuffer.add(readBuffer);
                        this.write(new byte[]{readBuffer[readBuffer.length - 1], readBuffer[readBuffer.length - 1]});
                    } else {
                        log.log(Level.WARNING, "write wrong checksum required");
                        byte wrongChecksum = readBuffer[readBuffer.length - 1];
                        byte[] requestAgain = new byte[]{wrongChecksum, wrongChecksum};
                        this.write(requestAgain);
                        --numberRed;
                    }
                    this.isTransmitFinished = this.checkTransmissionFinished(3000);
                    continue;
                }
                this.isTransmitFinished = this.checkTransmissionFinished(3000);
            }
        }
        catch (Exception e) {
            log.log(Level.SEVERE, e.getMessage(), e);
            throw e;
        }
        return dataBuffer;
    }

    private boolean checkTransmissionFinished(int timeout_msec) throws InterruptedException, IOException {
        int sleepTime = 8;
        int timeCounter = timeout_msec / sleepTime;
        int availableBytes = 0;
        WaitTimer.delay((long)sleepTime);
        while (0 == (availableBytes = this.getAvailableBytes()) && timeCounter-- > 0) {
            WaitTimer.delay((long)sleepTime);
        }
        return availableBytes == 0 || this.isTransmitFinished;
    }

    private boolean checkGoodPackage(byte[] readBuffer, int maxBytes, int modulo) {
        boolean isGoodPackage = false;
        isGoodPackage = readBuffer.length == maxBytes ? true : (readBuffer.length < maxBytes && (readBuffer.length - 1) % modulo == 0 ? true : this.verifyChecksum(readBuffer));
        return isGoodPackage;
    }

    private boolean verifyChecksum(byte[] readBuffer) {
        return readBuffer[readBuffer.length - 1] == Checksum.XOR((byte[])readBuffer);
    }

    public void setTransmitFinished(boolean enabled) {
        this.isTransmitFinished = enabled;
    }
}

