/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.math3.analysis.function;

import org.apache.commons.math3.analysis.DifferentiableUnivariateFunction;
import org.apache.commons.math3.analysis.FunctionUtils;
import org.apache.commons.math3.analysis.ParametricUnivariateFunction;
import org.apache.commons.math3.analysis.UnivariateFunction;
import org.apache.commons.math3.analysis.differentiation.DerivativeStructure;
import org.apache.commons.math3.analysis.differentiation.UnivariateDifferentiableFunction;
import org.apache.commons.math3.exception.DimensionMismatchException;
import org.apache.commons.math3.exception.NullArgumentException;
import org.apache.commons.math3.exception.OutOfRangeException;
import org.apache.commons.math3.util.FastMath;

public class Logit
implements UnivariateDifferentiableFunction,
DifferentiableUnivariateFunction {
    private final double lo;
    private final double hi;

    public Logit() {
        this(0.0, 1.0);
    }

    public Logit(double lo, double hi) {
        this.lo = lo;
        this.hi = hi;
    }

    public double value(double x2) throws OutOfRangeException {
        return Logit.value(x2, this.lo, this.hi);
    }

    @Deprecated
    public UnivariateFunction derivative() {
        return FunctionUtils.toDifferentiableUnivariateFunction(this).derivative();
    }

    private static double value(double x2, double lo, double hi) throws OutOfRangeException {
        if (x2 < lo || x2 > hi) {
            throw new OutOfRangeException(x2, (Number)lo, hi);
        }
        return FastMath.log((x2 - lo) / (hi - x2));
    }

    public DerivativeStructure value(DerivativeStructure t2) throws OutOfRangeException {
        double x2 = t2.getValue();
        if (x2 < this.lo || x2 > this.hi) {
            throw new OutOfRangeException(x2, (Number)this.lo, this.hi);
        }
        double[] f2 = new double[t2.getOrder() + 1];
        f2[0] = FastMath.log((x2 - this.lo) / (this.hi - x2));
        if (Double.isInfinite(f2[0])) {
            if (f2.length > 1) {
                f2[1] = Double.POSITIVE_INFINITY;
            }
            for (int i2 = 2; i2 < f2.length; ++i2) {
                f2[i2] = f2[i2 - 2];
            }
        } else {
            double invH;
            double invL;
            double xL = invL = 1.0 / (x2 - this.lo);
            double xH = invH = 1.0 / (this.hi - x2);
            for (int i3 = 1; i3 < f2.length; ++i3) {
                f2[i3] = xL + xH;
                xL *= (double)(-i3) * invL;
                xH *= (double)i3 * invH;
            }
        }
        return t2.compose(f2);
    }

    public static class Parametric
    implements ParametricUnivariateFunction {
        public double value(double x2, double ... param2) throws NullArgumentException, DimensionMismatchException {
            this.validateParameters(param2);
            return Logit.value(x2, param2[0], param2[1]);
        }

        public double[] gradient(double x2, double ... param2) throws NullArgumentException, DimensionMismatchException {
            this.validateParameters(param2);
            double lo = param2[0];
            double hi = param2[1];
            return new double[]{1.0 / (lo - x2), 1.0 / (hi - x2)};
        }

        private void validateParameters(double[] param2) throws NullArgumentException, DimensionMismatchException {
            if (param2 == null) {
                throw new NullArgumentException();
            }
            if (param2.length != 2) {
                throw new DimensionMismatchException(param2.length, 2);
            }
        }
    }
}

