/*
 * Decompiled with CFR 0.152.
 */
package de.treichels.hott.model.firmware;

import de.treichels.hott.model.enums.Registered;
import de.treichels.hott.util.Callback;
import de.treichels.hott.util.CallbackInputStream;
import de.treichels.hott.util.HashUtilsKt;
import java.io.Closeable;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.Charset;
import java.security.MessageDigest;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.CancellationException;
import java.util.logging.Logger;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.io.CloseableKt;
import kotlin.io.TextStreamsKt;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.text.Charsets;
import kotlin.text.StringsKt;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.StatusLine;
import org.apache.http.client.ResponseHandler;
import org.apache.http.client.fluent.Request;
import org.apache.http.message.BasicNameValuePair;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=1, d1={"\u0000:\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u000b\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u0000 \u001f*\f\b\u0000\u0010\u0001*\u0006\u0012\u0002\b\u00030\u00022\u00020\u0003:\u0001\u001fB%\u0012\u0006\u0010\u0004\u001a\u00028\u0000\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\u0006\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0002\u0010\nJ\u0006\u0010\u001b\u001a\u00020\fJ\u0010\u0010\u001b\u001a\u00020\f2\b\u0010\u001c\u001a\u0004\u0018\u00010\u001dJ\b\u0010\u001e\u001a\u00020\u0006H\u0016R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0013\u0010\u0004\u001a\u00028\u0000\u00a2\u0006\n\n\u0002\u0010\u000f\u001a\u0004\b\r\u0010\u000eR\u0011\u0010\u0010\u001a\u00020\f\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R\u0011\u0010\u0013\u001a\u00020\u00148F\u00a2\u0006\u0006\u001a\u0004\b\u0013\u0010\u0015R\u0011\u0010\u0007\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0017R\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0018\u0010\u0017R\u0011\u0010\b\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0019\u0010\u001a\u00a8\u0006 "}, d2={"Lde/treichels/hott/model/firmware/Firmware;", "T", "Lde/treichels/hott/model/enums/Registered;", "", "device", "path", "", "name", "size", "", "(Lde/treichels/hott/model/enums/Registered;Ljava/lang/String;Ljava/lang/String;J)V", "cacheDir", "Ljava/io/File;", "getDevice", "()Lde/treichels/hott/model/enums/Registered;", "Lde/treichels/hott/model/enums/Registered;", "file", "getFile", "()Ljava/io/File;", "isCached", "", "()Z", "getName", "()Ljava/lang/String;", "getPath", "getSize", "()J", "download", "task", "Lde/treichels/hott/util/Callback;", "toString", "Companion", "HoTT-Model"})
public final class Firmware<T extends Registered<?>> {
    private final File cacheDir;
    @NotNull
    private final File file;
    @NotNull
    private final T device;
    @NotNull
    private final String path;
    @NotNull
    private final String name;
    private final long size;
    private static final Logger LOG;
    private static final String FTP_SERVER_ADDRESS = "gdownload.duckdns.org";
    private static final String FILE_LIST = "file_list.php";
    private static final String FILE_DOWN = "file_down.php";
    @NotNull
    public static final Companion Companion;

    @NotNull
    public String toString() {
        return this.device + " -> " + this.path + this.name + ':' + this.size;
    }

    @NotNull
    public final File getFile() {
        return this.file;
    }

    public final boolean isCached() {
        return this.file.exists() && this.file.length() == this.size;
    }

    @NotNull
    public final File download(@Nullable Callback task2) {
        if (!this.isCached()) {
            Callback callback = task2;
            if (callback == null || !callback.isCancelled()) {
                this.cacheDir.mkdirs();
                Companion.download(task2, this.path + this.name, this.file);
            }
        }
        return this.file;
    }

    @NotNull
    public final File download() {
        return this.download(null);
    }

    @NotNull
    public final T getDevice() {
        return this.device;
    }

    @NotNull
    public final String getPath() {
        return this.path;
    }

    @NotNull
    public final String getName() {
        return this.name;
    }

    public final long getSize() {
        return this.size;
    }

    public Firmware(@NotNull T device, @NotNull String path2, @NotNull String name, long size) {
        Intrinsics.checkNotNullParameter(device, "device");
        Intrinsics.checkNotNullParameter(path2, "path");
        Intrinsics.checkNotNullParameter(name, "name");
        this.device = device;
        this.path = path2;
        this.name = name;
        this.size = size;
        this.cacheDir = new File(System.getProperty("user.home") + "/.java/cache/HoTT/firmware/" + this.device.getName());
        this.file = new File(this.cacheDir, this.name);
    }

    static {
        Companion = new Companion(null);
        LOG = Logger.getLogger("javaClass");
    }

    public static final /* synthetic */ Logger access$getLOG$cp() {
        return LOG;
    }

    @Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=1, d1={"\u0000\\\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\t\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002JL\u0010\n\u001a\u0002H\u000b\"\u0004\b\u0001\u0010\u000b2\b\u0010\f\u001a\u0004\u0018\u00010\r2\u0006\u0010\u000e\u001a\u00020\u00042'\u0010\u000f\u001a#\u0012\u0004\u0012\u00020\u0011\u0012\u0013\u0012\u00110\u0012\u00a2\u0006\f\b\u0013\u0012\b\b\u0014\u0012\u0004\b\b(\u0015\u0012\u0004\u0012\u0002H\u000b0\u0010\u00a2\u0006\u0002\u0010\u0016J \u0010\n\u001a\u00020\u00042\b\u0010\f\u001a\u0004\u0018\u00010\r2\u0006\u0010\u000e\u001a\u00020\u00042\u0006\u0010\u0017\u001a\u00020\u0018J-\u0010\u0019\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u0002H\u000b0\u001b0\u001a\"\f\b\u0001\u0010\u000b*\u0006\u0012\u0002\b\u00030\u001c2\u0006\u0010\u001d\u001a\u0002H\u000b\u00a2\u0006\u0002\u0010\u001eJ5\u0010\u0019\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u0002H\u000b0\u001b0\u001a\"\f\b\u0001\u0010\u000b*\u0006\u0012\u0002\b\u00030\u001c2\u0006\u0010\u001d\u001a\u0002H\u000b2\u0006\u0010\u001f\u001a\u00020 \u00a2\u0006\u0002\u0010!J=\u0010\u0019\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u0002H\u000b0\u001b0\u001a\"\f\b\u0001\u0010\u000b*\u0006\u0012\u0002\b\u00030\u001c2\u0006\u0010\u001d\u001a\u0002H\u000b2\u0006\u0010\u001f\u001a\u00020 2\u0006\u0010\"\u001a\u00020 \u00a2\u0006\u0002\u0010#J5\u0010\u0019\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u0002H\u000b0\u001b0\u001a\"\f\b\u0001\u0010\u000b*\u0006\u0012\u0002\b\u00030\u001c2\u0006\u0010\u001d\u001a\u0002H\u000b2\u0006\u0010$\u001a\u00020\u0004\u00a2\u0006\u0002\u0010%J=\u0010\u0019\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u0002H\u000b0\u001b0\u001a\"\f\b\u0001\u0010\u000b*\u0006\u0012\u0002\b\u00030\u001c2\u0006\u0010\u001d\u001a\u0002H\u000b2\u0006\u0010$\u001a\u00020\u00042\u0006\u0010\u001f\u001a\u00020\u0001\u00a2\u0006\u0002\u0010&J \u0010\u0019\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00120'0\u001a2\u0006\u0010\u000e\u001a\u00020\u0004R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0007\u001a\n \t*\u0004\u0018\u00010\b0\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006("}, d2={"Lde/treichels/hott/model/firmware/Firmware$Companion;", "", "()V", "FILE_DOWN", "", "FILE_LIST", "FTP_SERVER_ADDRESS", "LOG", "Ljava/util/logging/Logger;", "kotlin.jvm.PlatformType", "download", "T", "task", "Lde/treichels/hott/util/Callback;", "path", "func", "Lkotlin/Function2;", "Ljava/io/InputStream;", "", "Lkotlin/ParameterName;", "name", "size", "(Lde/treichels/hott/util/Callback;Ljava/lang/String;Lkotlin/jvm/functions/Function2;)Ljava/lang/Object;", "file", "Ljava/io/File;", "list", "", "Lde/treichels/hott/model/firmware/Firmware;", "Lde/treichels/hott/model/enums/Registered;", "device", "(Lde/treichels/hott/model/enums/Registered;)Ljava/util/List;", "productCode", "", "(Lde/treichels/hott/model/enums/Registered;I)Ljava/util/List;", "mask", "(Lde/treichels/hott/model/enums/Registered;II)Ljava/util/List;", "category", "(Lde/treichels/hott/model/enums/Registered;Ljava/lang/String;)Ljava/util/List;", "(Lde/treichels/hott/model/enums/Registered;Ljava/lang/String;Ljava/lang/Object;)Ljava/util/List;", "Lkotlin/Pair;", "HoTT-Model"})
    public static final class Companion {
        @NotNull
        public final <T extends Registered<?>> List<Firmware<T>> list(@NotNull T device) {
            Intrinsics.checkNotNullParameter(device, "device");
            return this.list(device, device.getCategory(), (Object)device.getProductCode());
        }

        @NotNull
        public final <T extends Registered<?>> List<Firmware<T>> list(@NotNull T device, @NotNull String category) {
            Intrinsics.checkNotNullParameter(device, "device");
            Intrinsics.checkNotNullParameter(category, "category");
            return this.list(device, category, (Object)device.getProductCode());
        }

        @NotNull
        public final <T extends Registered<?>> List<Firmware<T>> list(@NotNull T device, int productCode) {
            Intrinsics.checkNotNullParameter(device, "device");
            return this.list(device, device.getCategory(), (Object)productCode);
        }

        @NotNull
        public final <T extends Registered<?>> List<Firmware<T>> list(@NotNull T device, int productCode, int mask) {
            Intrinsics.checkNotNullParameter(device, "device");
            int part = productCode % mask;
            int min = mask / 10;
            return part >= min ? this.list(device, device.getCategory(), (Object)part) : CollectionsKt.emptyList();
        }

        /*
         * WARNING - void declaration
         */
        @NotNull
        public final <T extends Registered<?>> List<Firmware<T>> list(@NotNull T device, @NotNull String category, @NotNull Object productCode) {
            void $this$mapTo$iv$iv;
            Intrinsics.checkNotNullParameter(device, "device");
            Intrinsics.checkNotNullParameter(category, "category");
            Intrinsics.checkNotNullParameter(productCode, "productCode");
            String path2 = "/Firmware/" + category + '/' + productCode + '/';
            Iterable $this$map$iv = this.list(path2);
            boolean $i$f$map = false;
            Iterable iterable = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void name;
                void $dstr$name$size;
                Pair pair = (Pair)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl = false;
                String string2 = (String)$dstr$name$size.component1();
                long size = ((Number)$dstr$name$size.component2()).longValue();
                Firmware<T> firmware = new Firmware<T>(device, path2, (String)name, size);
                collection.add(firmware);
            }
            return (List)destination$iv$iv;
        }

        @NotNull
        public final List<Pair<String, Long>> list(@NotNull String path2) {
            Intrinsics.checkNotNullParameter(path2, "path");
            Object t2 = Request.Post("http://gdownload.duckdns.org/file_list.php").bodyForm(new BasicNameValuePair("path", path2)).execute().handleResponse(new ResponseHandler<List<? extends Pair<? extends String, ? extends Long>>>(path2){
                final /* synthetic */ String $path;

                /*
                 * WARNING - void declaration
                 */
                public final List<Pair<String, Long>> handleResponse(HttpResponse response) {
                    void $this$mapTo$iv$iv;
                    HttpResponse httpResponse = response;
                    Intrinsics.checkNotNullExpressionValue(httpResponse, "response");
                    Object object = httpResponse.getStatusLine();
                    boolean bl = false;
                    boolean bl2 = false;
                    StatusLine $this$apply = object;
                    boolean bl3 = false;
                    Firmware.access$getLOG$cp().finer(this.$path + " -> " + $this$apply);
                    if ($this$apply.getStatusCode() != 200) {
                        throw (Throwable)new IOException($this$apply.toString());
                    }
                    HttpEntity httpEntity = response.getEntity();
                    Intrinsics.checkNotNullExpressionValue(httpEntity, "response.entity");
                    InputStream inputStream2 = httpEntity.getContent();
                    Intrinsics.checkNotNullExpressionValue(inputStream2, "response.entity.content");
                    object = inputStream2;
                    Charset charset = Charsets.UTF_8;
                    bl2 = false;
                    Iterable $this$map$iv = TextStreamsKt.readLines(new InputStreamReader((InputStream)object, charset));
                    boolean $i$f$map = false;
                    Iterable iterable = $this$map$iv;
                    Collection destination$iv$iv = new ArrayList<E>(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
                    boolean $i$f$mapTo = false;
                    for (T item$iv$iv : $this$mapTo$iv$iv) {
                        void line2;
                        String string2 = (String)item$iv$iv;
                        Collection collection = destination$iv$iv;
                        boolean bl4 = false;
                        Firmware.access$getLOG$cp().finer((String)line2);
                        List parts = StringsKt.split$default((CharSequence)line2, new String[]{"|"}, false, 0, 6, null);
                        String name = (String)parts.get(0);
                        String string3 = (String)parts.get(1);
                        boolean bl5 = false;
                        long size = Long.parseLong(string3);
                        Pair<String, Long> pair = new Pair<String, Long>(name, size);
                        collection.add(pair);
                    }
                    return (List)destination$iv$iv;
                }
                {
                    this.$path = string2;
                }
            });
            Intrinsics.checkNotNullExpressionValue(t2, "Request.Post(\"http://$FT\u2026      }\n                }");
            return (List)t2;
        }

        public final <T> T download(@Nullable Callback task2, @NotNull String path2, @NotNull Function2<? super InputStream, ? super Long, ? extends T> func) {
            Intrinsics.checkNotNullParameter(path2, "path");
            Intrinsics.checkNotNullParameter(func, "func");
            Request request = Request.Post("http://gdownload.duckdns.org/file_down.php").bodyForm(new BasicNameValuePair("file", path2));
            return request.execute().handleResponse(new ResponseHandler<T>(func, task2, request){
                final /* synthetic */ Function2 $func;
                final /* synthetic */ Callback $task;
                final /* synthetic */ Request $request;

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public final T handleResponse(HttpResponse response) {
                    R r2;
                    HttpResponse httpResponse = response;
                    Intrinsics.checkNotNullExpressionValue(httpResponse, "response");
                    HttpEntity httpEntity = httpResponse.getEntity();
                    Intrinsics.checkNotNullExpressionValue(httpEntity, "response.entity");
                    long size = httpEntity.getContentLength();
                    Object object = response.getStatusLine();
                    boolean bl = false;
                    boolean bl2 = false;
                    StatusLine $this$apply = object;
                    boolean bl3 = false;
                    if ($this$apply.getStatusCode() != 200) {
                        throw (Throwable)new IOException($this$apply.toString());
                    }
                    HttpEntity httpEntity2 = response.getEntity();
                    Intrinsics.checkNotNullExpressionValue(httpEntity2, "response.entity");
                    object = httpEntity2.getContent();
                    bl = false;
                    bl2 = false;
                    Throwable throwable = null;
                    try {
                        R r3;
                        InputStream it = (InputStream)object;
                        boolean bl4 = false;
                        try {
                            InputStream inputStream2 = it;
                            Intrinsics.checkNotNullExpressionValue(inputStream2, "it");
                            r3 = this.$func.invoke(new CallbackInputStream(this.$task, inputStream2, size), size);
                        }
                        catch (CancellationException e2) {
                            this.$request.abort();
                            throw (Throwable)e2;
                        }
                        r2 = r3;
                    }
                    catch (Throwable throwable2) {
                        throwable = throwable2;
                        throw throwable2;
                    }
                    finally {
                        CloseableKt.closeFinally((Closeable)object, throwable);
                    }
                    return (T)r2;
                }
                {
                    this.$func = function2;
                    this.$task = callback;
                    this.$request = request;
                }
            });
        }

        /*
         * WARNING - void declaration
         */
        @NotNull
        public final String download(@Nullable Callback task2, @NotNull String path2, @NotNull File file) {
            void bytesRead;
            Intrinsics.checkNotNullParameter(path2, "path");
            Intrinsics.checkNotNullParameter(file, "file");
            MessageDigest md = MessageDigest.getInstance("MD5");
            byte[] buffer = new byte[1024];
            Ref.LongRef longRef = new Ref.LongRef();
            longRef.element = 0L;
            this.download(task2, path2, (Function2)new Function2<InputStream, Long, Unit>(file, buffer, (Ref.LongRef)bytesRead, md){
                final /* synthetic */ File $file;
                final /* synthetic */ byte[] $buffer;
                final /* synthetic */ Ref.LongRef $bytesRead;
                final /* synthetic */ MessageDigest $md;

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public final void invoke(@NotNull InputStream inputStream2, long size) {
                    Intrinsics.checkNotNullParameter(inputStream2, "inputStream");
                    Object object = this.$file;
                    boolean bl = false;
                    object = new FileOutputStream((File)object);
                    bl = false;
                    boolean bl2 = false;
                    Throwable throwable = null;
                    try {
                        int len;
                        FileOutputStream outputStream = (FileOutputStream)object;
                        boolean bl3 = false;
                        while ((len = inputStream2.read(this.$buffer)) >= 0) {
                            this.$bytesRead.element += (long)len;
                            outputStream.write(this.$buffer, 0, len);
                            this.$md.update(this.$buffer, 0, len);
                        }
                        Unit unit = Unit.INSTANCE;
                    }
                    catch (Throwable throwable2) {
                        throwable = throwable2;
                        throw throwable2;
                    }
                    finally {
                        CloseableKt.closeFinally((Closeable)object, throwable);
                    }
                    if (size > 0L && this.$bytesRead.element != size) {
                        throw (Throwable)new IOException("Size mismatch: expected " + size + ", but got " + this.$bytesRead.element + '.');
                    }
                }
                {
                    this.$file = file;
                    this.$buffer = byArray;
                    this.$bytesRead = longRef;
                    this.$md = messageDigest;
                    super(2);
                }
            });
            MessageDigest messageDigest = md;
            Intrinsics.checkNotNullExpressionValue(messageDigest, "md");
            return HashUtilsKt.getHash(messageDigest);
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

