/*
 * Decompiled with CFR 0.152.
 */
package javax.usb.util;

import javax.usb.UsbControlIrp;
import javax.usb.UsbDevice;
import javax.usb.UsbException;

public class StandardRequest {
    protected UsbDevice usbDevice = null;
    protected static final byte REQUESTTYPE_CLEAR_FEATURE = 0;
    protected static final byte REQUESTTYPE_GET_CONFIGURATION = -128;
    protected static final byte REQUESTTYPE_GET_DESCRIPTOR = -128;
    protected static final byte REQUESTTYPE_GET_INTERFACE = -127;
    protected static final byte REQUESTTYPE_GET_STATUS = -128;
    protected static final byte REQUESTTYPE_SET_ADDRESS = 0;
    protected static final byte REQUESTTYPE_SET_CONFIGURATION = 0;
    protected static final byte REQUESTTYPE_SET_DESCRIPTOR = 0;
    protected static final byte REQUESTTYPE_SET_FEATURE = 0;
    protected static final byte REQUESTTYPE_SET_INTERFACE = 1;
    protected static final byte REQUESTTYPE_SYNCH_FRAME = -126;

    public StandardRequest(UsbDevice usbDevice) {
        this.usbDevice = usbDevice;
    }

    public void clearFeature(byte by, short s, short s2) throws UsbException, IllegalArgumentException {
        StandardRequest.clearFeature(this.usbDevice, by, s, s2);
    }

    public byte getConfiguration() throws UsbException {
        return StandardRequest.getConfiguration(this.usbDevice);
    }

    public int getDescriptor(byte by, byte by2, short s, byte[] byArray) throws UsbException {
        return StandardRequest.getDescriptor(this.usbDevice, by, by2, s, byArray);
    }

    public byte getInterface(short s) throws UsbException {
        return StandardRequest.getInterface(this.usbDevice, s);
    }

    public short getStatus(byte by, short s) throws UsbException, IllegalArgumentException {
        return StandardRequest.getStatus(this.usbDevice, by, s);
    }

    public void setAddress(short s) throws UsbException {
        StandardRequest.setAddress(this.usbDevice, s);
    }

    public void setConfiguration(short s) throws UsbException {
        StandardRequest.setConfiguration(this.usbDevice, s);
    }

    public int setDescriptor(byte by, byte by2, short s, byte[] byArray) throws UsbException {
        return StandardRequest.setDescriptor(this.usbDevice, by, by2, s, byArray);
    }

    public void setFeature(byte by, short s, short s2) throws UsbException, IllegalArgumentException {
        StandardRequest.setFeature(this.usbDevice, by, s, s2);
    }

    public void setInterface(short s, short s2) throws UsbException {
        StandardRequest.setInterface(this.usbDevice, s, s2);
    }

    public short synchFrame(short s) throws UsbException {
        return StandardRequest.synchFrame(this.usbDevice, s);
    }

    public static void clearFeature(UsbDevice usbDevice, byte by, short s, short s2) throws UsbException, IllegalArgumentException {
        StandardRequest.checkRecipient(by);
        if (0 == by && 0 != s2) {
            throw new IllegalArgumentException("If the recipient is device, the target must be 0");
        }
        byte by2 = (byte)(0 | by);
        byte by3 = 1;
        short s3 = s;
        short s4 = s2;
        usbDevice.syncSubmit(usbDevice.createUsbControlIrp(by2, by3, s3, s4));
    }

    public static byte getConfiguration(UsbDevice usbDevice) throws UsbException {
        byte by = -128;
        byte by2 = 8;
        short s = 0;
        short s2 = 0;
        byte[] byArray = new byte[1];
        UsbControlIrp usbControlIrp = usbDevice.createUsbControlIrp(by, by2, s, s2);
        usbControlIrp.setData(byArray);
        usbControlIrp.setAcceptShortPacket(false);
        usbDevice.syncSubmit(usbControlIrp);
        return byArray[0];
    }

    public static int getDescriptor(UsbDevice usbDevice, byte by, byte by2, short s, byte[] byArray) throws UsbException {
        byte by3 = -128;
        byte by4 = 6;
        short s2 = (short)(by << 8 | by2 & 0xFF);
        short s3 = s;
        UsbControlIrp usbControlIrp = usbDevice.createUsbControlIrp(by3, by4, s2, s3);
        usbControlIrp.setData(byArray);
        usbDevice.syncSubmit(usbControlIrp);
        return usbControlIrp.getActualLength();
    }

    public static byte getInterface(UsbDevice usbDevice, short s) throws UsbException {
        byte by = -127;
        byte by2 = 10;
        short s2 = 0;
        short s3 = s;
        byte[] byArray = new byte[1];
        UsbControlIrp usbControlIrp = usbDevice.createUsbControlIrp(by, by2, s2, s3);
        usbControlIrp.setData(byArray);
        usbControlIrp.setAcceptShortPacket(false);
        usbDevice.syncSubmit(usbControlIrp);
        return byArray[0];
    }

    public static short getStatus(UsbDevice usbDevice, byte by, short s) throws UsbException, IllegalArgumentException {
        StandardRequest.checkRecipient(by);
        if (0 == by && 0 != s) {
            throw new IllegalArgumentException("If the recipient is device, the target must be 0");
        }
        byte by2 = (byte)(0xFFFFFF80 | by);
        byte by3 = 0;
        short s2 = 0;
        short s3 = s;
        byte[] byArray = new byte[2];
        UsbControlIrp usbControlIrp = usbDevice.createUsbControlIrp(by2, by3, s2, s3);
        usbControlIrp.setData(byArray);
        usbControlIrp.setAcceptShortPacket(false);
        usbDevice.syncSubmit(usbControlIrp);
        return (short)(byArray[1] << 8 | byArray[0]);
    }

    public static void setAddress(UsbDevice usbDevice, short s) throws UsbException {
        byte by = 0;
        byte by2 = 5;
        short s2 = s;
        short s3 = 0;
        usbDevice.syncSubmit(usbDevice.createUsbControlIrp(by, by2, s2, s3));
    }

    public static void setConfiguration(UsbDevice usbDevice, short s) throws UsbException {
        byte by = 0;
        byte by2 = 9;
        short s2 = s;
        short s3 = 0;
        usbDevice.syncSubmit(usbDevice.createUsbControlIrp(by, by2, s2, s3));
    }

    public static int setDescriptor(UsbDevice usbDevice, byte by, byte by2, short s, byte[] byArray) throws UsbException {
        byte by3 = 0;
        byte by4 = 7;
        short s2 = (short)(by << 8 | by2);
        short s3 = s;
        UsbControlIrp usbControlIrp = usbDevice.createUsbControlIrp(by3, by4, s2, s3);
        usbControlIrp.setData(byArray);
        usbDevice.syncSubmit(usbControlIrp);
        return usbControlIrp.getActualLength();
    }

    public static void setFeature(UsbDevice usbDevice, byte by, short s, short s2) throws UsbException, IllegalArgumentException {
        StandardRequest.checkRecipient(by);
        byte by2 = (byte)(0 | by);
        byte by3 = 3;
        short s3 = s;
        short s4 = s2;
        usbDevice.syncSubmit(usbDevice.createUsbControlIrp(by2, by3, s3, s4));
    }

    public static void setInterface(UsbDevice usbDevice, short s, short s2) throws UsbException {
        byte by = 1;
        byte by2 = 11;
        short s3 = s2;
        short s4 = s;
        usbDevice.syncSubmit(usbDevice.createUsbControlIrp(by, by2, s3, s4));
    }

    public static short synchFrame(UsbDevice usbDevice, short s) throws UsbException {
        byte by = -126;
        byte by2 = 12;
        short s2 = 0;
        short s3 = s;
        byte[] byArray = new byte[2];
        UsbControlIrp usbControlIrp = usbDevice.createUsbControlIrp(by, by2, s2, s3);
        usbControlIrp.setData(byArray);
        usbControlIrp.setAcceptShortPacket(false);
        usbDevice.syncSubmit(usbControlIrp);
        return (short)(byArray[1] << 8 | byArray[0]);
    }

    protected static void checkRecipient(byte by) throws IllegalArgumentException {
        switch (by) {
            case 0: 
            case 1: 
            case 2: {
                break;
            }
            default: {
                throw new IllegalArgumentException("Recipient must be device (0x00), interface (0x01), or endpoint (0x02)");
            }
        }
    }
}

