/*
 * Decompiled with CFR 0.152.
 */
package kotlin.reflect.jvm.internal.pcollections;

import kotlin.reflect.jvm.internal.pcollections.ConsPStack;
import kotlin.reflect.jvm.internal.pcollections.IntTreePMap;
import kotlin.reflect.jvm.internal.pcollections.MapEntry;
import org.jetbrains.annotations.NotNull;

public final class HashPMap<K, V> {
    private static final HashPMap<Object, Object> EMPTY = new HashPMap(IntTreePMap.empty(), 0);
    private final IntTreePMap<ConsPStack<MapEntry<K, V>>> intMap;
    private final int size;

    @NotNull
    public static <K, V> HashPMap<K, V> empty() {
        HashPMap<Object, Object> hashPMap = EMPTY;
        if (hashPMap == null) {
            HashPMap.$$$reportNull$$$0(0);
        }
        return hashPMap;
    }

    private HashPMap(IntTreePMap<ConsPStack<MapEntry<K, V>>> intMap, int size) {
        this.intMap = intMap;
        this.size = size;
    }

    public int size() {
        return this.size;
    }

    public boolean containsKey(Object key2) {
        return HashPMap.keyIndexIn(this.getEntries(key2.hashCode()), key2) != -1;
    }

    public V get(Object key2) {
        ConsPStack<MapEntry<K, V>> entries = this.getEntries(key2.hashCode());
        while (entries != null && entries.size() > 0) {
            MapEntry entry = (MapEntry)entries.first;
            if (entry.key.equals(key2)) {
                return entry.value;
            }
            entries = entries.rest;
        }
        return null;
    }

    @NotNull
    public HashPMap<K, V> plus(K key2, V value) {
        ConsPStack<MapEntry<K, V>> entries = this.getEntries(key2.hashCode());
        int size0 = entries.size();
        int i2 = HashPMap.keyIndexIn(entries, key2);
        if (i2 != -1) {
            entries = entries.minus(i2);
        }
        entries = entries.plus(new MapEntry<K, V>(key2, value));
        return new HashPMap<K, V>(this.intMap.plus(key2.hashCode(), entries), this.size - size0 + entries.size());
    }

    @NotNull
    public HashPMap<K, V> minus(Object key2) {
        ConsPStack<MapEntry<K, V>> entries = this.getEntries(key2.hashCode());
        int i2 = HashPMap.keyIndexIn(entries, key2);
        if (i2 == -1) {
            HashPMap hashPMap = this;
            if (hashPMap == null) {
                HashPMap.$$$reportNull$$$0(1);
            }
            return hashPMap;
        }
        if ((entries = entries.minus(i2)).size() == 0) {
            return new HashPMap<K, V>(this.intMap.minus(key2.hashCode()), this.size - 1);
        }
        return new HashPMap<K, V>(this.intMap.plus(key2.hashCode(), entries), this.size - 1);
    }

    private ConsPStack<MapEntry<K, V>> getEntries(int hash) {
        ConsPStack<MapEntry<K, V>> entries = this.intMap.get(hash);
        if (entries == null) {
            return ConsPStack.empty();
        }
        return entries;
    }

    private static <K, V> int keyIndexIn(ConsPStack<MapEntry<K, V>> entries, Object key2) {
        int i2 = 0;
        while (entries != null && entries.size() > 0) {
            MapEntry entry = (MapEntry)entries.first;
            if (entry.key.equals(key2)) {
                return i2;
            }
            entries = entries.rest;
            ++i2;
        }
        return -1;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n2) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[2];
        objectArray2[0] = "kotlin/reflect/jvm/internal/pcollections/HashPMap";
        switch (n2) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "empty";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "minus";
                break;
            }
        }
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
    }
}

