/*
 * Decompiled with CFR 0.152.
 */
package gde.device.igc;

import gde.GDE;
import gde.data.Channel;
import gde.data.Channels;
import gde.data.Record;
import gde.data.RecordSet;
import gde.device.IDevice;
import gde.device.InputTypes;
import gde.device.igc.GpsLap;
import gde.device.igc.GpsTaskResult;
import gde.device.igc.IgcExtension;
import gde.exception.DataInconsitsentException;
import gde.exception.DataTypeException;
import gde.exception.DevicePropertiesInconsistenceException;
import gde.exception.NotSupportedFileFormatException;
import gde.log.Level;
import gde.messages.Messages;
import gde.ui.DataExplorer;
import gde.utils.GPSHelper;
import gde.utils.StringHelper;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.Locale;
import java.util.Vector;
import java.util.logging.Logger;

public class IGCReaderWriter {
    static Logger log = Logger.getLogger(IGCReaderWriter.class.getName());
    static final DataExplorer application = DataExplorer.getInstance();
    static final Channels channels = Channels.getInstance();
    public static final char[] igcShortDate = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F', 'G', 'H', 'I', 'J', 'K', 'L', 'M', 'N', 'O', 'P', 'Q', 'R', 'S', 'T', 'U', 'V', 'W', 'X', 'Y', 'Z'};

    public static String getIGCShortFileName(char manufacturersIGCCodeLetter, String threeCharFnId, int sequenceNumber) {
        long date = new Date().getTime();
        char year = igcShortDate[Integer.parseInt(new SimpleDateFormat("YY", Locale.getDefault()).format(date))];
        char month = igcShortDate[Integer.parseInt(new SimpleDateFormat("MM", Locale.getDefault()).format(date))];
        char day = igcShortDate[Integer.parseInt(new SimpleDateFormat("dd", Locale.getDefault()).format(date))];
        return String.format("%c%c%c%c%s%c.igc", Character.valueOf(year), Character.valueOf(month), Character.valueOf(day), Character.valueOf(manufacturersIGCCodeLetter), threeCharFnId, Character.valueOf(igcShortDate[sequenceNumber]));
    }

    public static String getIGCLongFileName(String threeCharFnId, int sequenceNumber) {
        return String.format(Locale.ENGLISH, "%s-%s-%s-%02d.igc", StringHelper.getDateAndTime((String)"yyyy-MM-dd"), threeCharFnId, sequenceNumber);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static RecordSet read(String filePath, IDevice device, String recordNameExtend, Integer channelConfigNumber) throws NotSupportedFileFormatException, IOException, DataInconsitsentException, DataTypeException {
        String line = "*";
        RecordSet recordSet = null;
        Channel activeChannel = null;
        int lineNumber = 1;
        int activeChannelConfigNumber = 1;
        Object recordSetNameExtend = device.getRecordSetStemNameReplacement();
        long timeStamp = -1L;
        long actualTimeStamp = -1L;
        long startTimeStamp = -1L;
        long lastTimeStamp = -1L;
        StringBuilder header = new StringBuilder();
        StringBuilder triangles = new StringBuilder();
        StringBuilder error = new StringBuilder();
        StringBuilder albatrossTask = new StringBuilder();
        StringBuilder gpsTriangleRelated = new StringBuilder();
        String date = "000000";
        int lastLatitude = 0;
        int lastLongitude = 0;
        int lastAltBaro = 0;
        int lastAltGPS = 0;
        int[] values = new int[device.getNumberOfMeasurements(1) - 2];
        File inputFile = new File(filePath);
        String dllID = "XXX";
        IgcExtension bTimeStepExtension = null;
        IgcExtension kTimeStepExtension = null;
        Vector<IgcExtension> bExtensions = new Vector<IgcExtension>();
        Vector<IgcExtension> kExtensions = new Vector<IgcExtension>();
        GDE.getUiNotification().setProgress(0);
        GpsTaskResult result = null;
        try {
            activeChannel = channelConfigNumber == null ? channels.getActiveChannel() : (Channel)channels.get((Object)channelConfigNumber);
            if (activeChannel != null) {
                int day;
                int month;
                int year;
                GDE.getUiNotification().setStatusMessage(Messages.getString((String)"GDE_MSGT0594") + filePath);
                activeChannelConfigNumber = activeChannel.getNumber();
                if (GDE.isWithUi()) {
                    channels.switchChannel(activeChannelConfigNumber, "");
                    application.getMenuToolBar().updateChannelSelector();
                    activeChannel = channels.getActiveChannel();
                }
                Object recordSetName = activeChannel.size() + 1 + ") " + (String)recordSetNameExtend;
                int measurementSize = device.getNumberOfMeasurements(activeChannelConfigNumber);
                int dataBlockSize = Math.abs(device.getDataBlockSize(InputTypes.FILE_IO));
                log.log(java.util.logging.Level.FINE, "measurementSize = " + measurementSize + "; dataBlockSize = " + dataBlockSize);
                if (measurementSize < dataBlockSize) {
                    dataBlockSize = measurementSize;
                }
                long approximateLines = inputFile.length() / 35L;
                BufferedReader reader = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(filePath), "ISO-8859-1"));
                while ((line = reader.readLine()) != null && !line.startsWith("A") && lineNumber < 10) {
                    ++lineNumber;
                }
                if (lineNumber >= 10) {
                    reader.close();
                    log.log(Level.SEVERE, filePath + " Check IGC header");
                    throw new IOException(filePath + " Check IGC header");
                }
                while ((line = reader.readLine()) != null && !line.startsWith(device.getDataBlockLeader()) && lineNumber < 50) {
                    log.log(Level.FINE, line);
                    if (line.startsWith("HFDTE")) {
                        date = line.substring(5).trim();
                    } else if (line.startsWith("H")) {
                        header.append(line).append(GDE.LINE_SEPARATOR);
                    } else if (line.startsWith("LTSK:T:")) {
                        albatrossTask.append(line.substring(7));
                    } else if (line.startsWith("LRCE_LTSK:T:")) {
                        albatrossTask.append(line.substring(12));
                    } else if (line.startsWith("C")) {
                        if (line.startsWith("WP", 18)) {
                            albatrossTask.append(" - ").append(line.substring(1));
                        }
                        gpsTriangleRelated.append(GDE.LINE_SEPARATOR).append(line);
                    } else if (line.startsWith("LSTAT")) {
                        log.log(Level.OFF, line);
                    } else if (line.startsWith("A")) {
                        dllID = line.substring(1, 4);
                        log.log(Level.FINE, "IGCDLL iddentifier = " + dllID);
                    } else if (line.startsWith("I")) {
                        try {
                            int numExtensions = Integer.parseInt(line.substring(1, 3));
                            for (i = 0; i < numExtensions; ++i) {
                                extension = new IgcExtension(Integer.parseInt(line.substring(7 * i + 3, 7 * i + 5)) - 1, Integer.parseInt(line.substring(7 * i + 5, 7 * i + 7)), line.substring(7 * i + 7, 7 * i + 10));
                                if (extension.getThreeLetterCode().equals("TDS") || extension.getThreeLetterCode().equals("SUS")) {
                                    bTimeStepExtension = extension;
                                    continue;
                                }
                                bExtensions.add(extension);
                            }
                        }
                        catch (Exception e) {
                            log.log(Level.SEVERE, e.getMessage(), e);
                        }
                    } else if (line.startsWith("J")) {
                        try {
                            int numExtensions = Integer.parseInt(line.substring(1, 3));
                            for (i = 0; i < numExtensions; ++i) {
                                extension = new IgcExtension(Integer.parseInt(line.substring(7 * i + 3, 7 * i + 5)) - 1, Integer.parseInt(line.substring(7 * i + 5, 7 * i + 7)), line.substring(7 * i + 7, 7 * i + 10));
                                if (extension.getThreeLetterCode().equals("TDS") || extension.getThreeLetterCode().equals("SUS")) {
                                    kTimeStepExtension = extension;
                                    continue;
                                }
                                kExtensions.add(extension);
                            }
                        }
                        catch (Exception e) {
                            log.log(Level.SEVERE, e.getMessage(), e);
                        }
                    }
                    ++lineNumber;
                }
                if (lineNumber >= 180) {
                    reader.close();
                    log.log(Level.SEVERE, filePath + " Check IGC header");
                    throw new IOException(filePath + " Check IGC header");
                }
                if (date.contains(":")) {
                    int startIndex = date.indexOf(":");
                    year = Integer.parseInt(date.substring(startIndex + 5, startIndex + 7)) + 2000;
                    month = Integer.parseInt(date.substring(startIndex + 3, startIndex + 5));
                    day = Integer.parseInt(date.substring(startIndex + 1, startIndex + 3));
                } else {
                    year = Integer.parseInt(date.substring(4, 6)) + 2000;
                    month = Integer.parseInt(date.substring(2, 4));
                    day = Integer.parseInt(date.substring(0, 2));
                }
                if (line == null) {
                    reader.close();
                    throw new DevicePropertiesInconsistenceException("Error");
                }
                String time = line.substring(1, 7);
                while (Integer.parseInt(time) == 0) {
                    log.log(Level.WARNING, String.format("time entry B record zero, line %d", lineNumber));
                    line = reader.readLine();
                    ++lineNumber;
                    time = line.substring(1, 7);
                }
                int hour = Integer.parseInt(time.substring(0, 2));
                int minute = Integer.parseInt(time.substring(2, 4));
                int second = Integer.parseInt(time.substring(4, 6));
                startTimeStamp = new GregorianCalendar(year, month - 1, day, hour, minute, second).getTimeInMillis();
                if (bTimeStepExtension != null) {
                    startTimeStamp += Long.parseLong(line.substring(bTimeStepExtension.start, bTimeStepExtension.end));
                }
                do {
                    String lastLine = line = line.trim();
                    ++lineNumber;
                    if (line.length() >= 35 && line.startsWith(device.getDataBlockLeader())) {
                        int progress;
                        time = line.substring(1, 7);
                        if (hour == 23 && hour > Integer.parseInt(time.substring(0, 2))) {
                            ++day;
                        }
                        hour = Integer.parseInt(time.substring(0, 2));
                        minute = Integer.parseInt(time.substring(2, 4));
                        second = Integer.parseInt(time.substring(4, 6));
                        actualTimeStamp = new GregorianCalendar(year, month - 1, day, hour, minute, second).getTimeInMillis();
                        if (bTimeStepExtension != null) {
                            actualTimeStamp += Long.parseLong(line.substring(bTimeStepExtension.start, bTimeStepExtension.end));
                        }
                        if ((progress = (int)((long)(lineNumber * 100) / approximateLines)) % 5 == 0) {
                            GDE.getUiNotification().setProgress(progress);
                        }
                        if (device.getStateType() == null) {
                            reader.close();
                            throw new DevicePropertiesInconsistenceException(Messages.getString((String)"GDE_MSGE0043", (Object[])new Object[]{device.getPropertiesFileName()}));
                        }
                        try {
                            recordSetNameExtend = device.getRecordSetStateNameReplacement(1);
                            if (recordNameExtend.length() > 0) {
                                recordSetNameExtend = (String)recordSetNameExtend + " [" + recordNameExtend + "]";
                            }
                        }
                        catch (Exception e) {
                            reader.close();
                            throw new DevicePropertiesInconsistenceException(Messages.getString((String)"GDE_MSGE0044", (Object[])new Object[]{0, filePath, device.getPropertiesFileName()}));
                        }
                        if (recordSet == null || !recordSet.getName().contains((CharSequence)recordSetNameExtend)) {
                            recordSetName = activeChannel.size() + 1 + ") " + (String)recordSetNameExtend;
                            recordSet = RecordSet.createRecordSet((String)recordSetName, (IDevice)device, (int)activeChannel.getNumber(), (boolean)true, (boolean)true, (boolean)true);
                            recordSetName = recordSet.getName();
                            String dateTime = new SimpleDateFormat("yyyy-MM-dd, HH:mm:ss").format(actualTimeStamp);
                            String recordDescription = device.getName() + " - " + Messages.getString((String)"GDE_MSGT0129") + dateTime + GDE.LINE_SEPARATOR + albatrossTask.toString();
                            recordSet.setRecordSetDescription(recordDescription);
                            recordSet.descriptionAppendFilename(filePath.substring(filePath.lastIndexOf(47) + 1));
                            if (!activeChannel.getFileDescription().contains("HFGTYGLIDERTYPE")) {
                                activeChannel.setFileDescription(dateTime.substring(0, 10) + (activeChannel.getFileDescription().length() < 11 ? "" : activeChannel.getFileDescription().substring(10)) + GDE.LINE_SEPARATOR + header.toString());
                            }
                            activeChannel.put(recordSetName, (Object)recordSet);
                            ((RecordSet)activeChannel.get(recordSetName)).setStartTimeStamp(actualTimeStamp);
                            activeChannel.setActiveRecordSet((String)recordSetName);
                            activeChannel.applyTemplate((String)recordSetName, true);
                            int i = 0;
                            for (IgcExtension extension : bExtensions) {
                                if (recordSet.realSize() > 6 + i && !recordSet.get(6 + i).getName().equals(extension.getThreeLetterCode())) {
                                    if (log.isLoggable(Level.INFO)) {
                                        log.log(Level.INFO, String.format("set record with name %s # %d to name %s", recordSet.get(6 + i).getName(), 6 + i, extension.getThreeLetterCode()));
                                    }
                                    recordSet.get(6 + i).setName(extension.getThreeLetterCode());
                                }
                                ++i;
                            }
                            for (IgcExtension extension : kExtensions) {
                                if (recordSet.realSize() > 6 + i && !recordSet.get(6 + i).getName().equals(extension.getThreeLetterCode())) {
                                    if (log.isLoggable(Level.INFO)) {
                                        log.log(Level.INFO, String.format("set record with name %s # %d to name %s", recordSet.get(6 + i).getName(), 6 + i, extension.getThreeLetterCode()));
                                    }
                                    recordSet.get(6 + i).setName(extension.getThreeLetterCode());
                                }
                                ++i;
                            }
                        }
                        if (timeStamp < actualTimeStamp) {
                            int altGPS;
                            int altBaro;
                            int longitude;
                            int latitude;
                            if (timeStamp > 0L && actualTimeStamp - timeStamp > 2500L) {
                                log.log(Level.WARNING, String.format(Locale.getDefault(), "High time\t deviation at line %d %s %2d", lineNumber - 1, line.substring(1, 7), actualTimeStamp - timeStamp));
                                boolean isHighTimeDeviation = actualTimeStamp - timeStamp > 20000L;
                                boolean isToNextLowDeviation = lastTimeStamp > 0L && lastTimeStamp - timeStamp < 2000L;
                                log.log(Level.OFF, "isHighTimeDeviation = " + isHighTimeDeviation + " isToNextLowDeviation = " + isToNextLowDeviation);
                                if (isHighTimeDeviation && !isToNextLowDeviation) {
                                    lastTimeStamp = timeStamp;
                                    log.log(Level.SEVERE, String.format(Locale.getDefault(), "High time\t deviation at line %d %s", lineNumber - 1, line));
                                    error.append(String.format(Locale.getDefault(), "High time deviation %dms at line %d %s", actualTimeStamp - timeStamp, lineNumber - 1, line)).append(GDE.LINE_SEPARATOR);
                                    if (hour != 23) continue;
                                    hour = 0;
                                    continue;
                                }
                            }
                            try {
                                latitude = Integer.valueOf(line.substring(7, 14));
                                int n = latitude = line.substring(14, 15).equalsIgnoreCase("N") ? latitude : -1 * latitude;
                                if (lastLatitude != 0 && Math.abs(lastLatitude - latitude) > 30) {
                                    log.log(Level.WARNING, String.format(Locale.getDefault(), "High latitude\t deviation at line %d %s %2d", lineNumber - 1, line.substring(1, 7), latitude - lastLatitude));
                                }
                                lastLatitude = latitude;
                            }
                            catch (Exception e) {
                                latitude = values[0];
                            }
                            try {
                                longitude = Integer.valueOf(line.substring(15, 23));
                                int n = longitude = line.substring(23, 24).equalsIgnoreCase("E") ? longitude : -1 * longitude;
                                if (lastLongitude != 0 && Math.abs(lastLongitude - longitude) > 35) {
                                    log.log(Level.WARNING, String.format(Locale.getDefault(), "High longitude\t deviation at line %d %s %2d", lineNumber - 1, line.substring(1, 7), longitude - lastLongitude));
                                }
                                lastLongitude = longitude;
                            }
                            catch (Exception e) {
                                longitude = values[1];
                            }
                            try {
                                altBaro = Integer.valueOf(line.substring(25, 30));
                                if (lastAltBaro != 0 && Math.abs(lastAltBaro - altBaro) > 30) {
                                    log.log(Level.WARNING, String.format(Locale.getDefault(), "High altBaro\t deviation at line %d %s %2d", lineNumber - 1, line.substring(1, 7), altBaro - lastAltBaro));
                                }
                                lastAltBaro = altBaro;
                            }
                            catch (Exception e) {
                                altBaro = values[2];
                            }
                            try {
                                altGPS = Integer.valueOf(line.substring(31, 35));
                                if (lastAltGPS != 0 && Math.abs(lastAltGPS - altGPS) > 30) {
                                    log.log(Level.WARNING, String.format(Locale.getDefault(), "High altGPS\t deviation at line %d %s %2d", lineNumber - 1, line.substring(1, 7), altGPS - lastAltGPS));
                                }
                                lastAltGPS = altGPS;
                            }
                            catch (Exception e) {
                                altGPS = values[3];
                            }
                            values[0] = latitude * 10;
                            values[1] = longitude * 10;
                            values[2] = altBaro * 1000;
                            values[3] = altGPS * 1000;
                            for (int i = 0; i < bExtensions.size() && i + 4 < values.length; ++i) {
                                values[i + 4] = ((IgcExtension)bExtensions.get(i)).getValue(line);
                            }
                            recordSet.addNoneCalculationRecordsPoints(values, (double)(actualTimeStamp - startTimeStamp));
                            timeStamp = actualTimeStamp;
                            continue;
                        }
                        if (actualTimeStamp - timeStamp == 0L || Math.abs(actualTimeStamp - timeStamp) <= 1000L) continue;
                        log.log(Level.SEVERE, String.format(Locale.getDefault(), "High time\t deviation at line %d %s", lineNumber - 1, line));
                        error.append(String.format(Locale.getDefault(), "High time deviation %dms at line %d %s", actualTimeStamp - timeStamp, lineNumber - 1, line)).append(GDE.LINE_SEPARATOR);
                        continue;
                    }
                    if (line.startsWith("K")) {
                        log.log(Level.FINE, "K RECORD - Data extensioni = " + line);
                        time = line.substring(1, 7);
                        hour = Integer.parseInt(time.substring(0, 2));
                        minute = Integer.parseInt(time.substring(2, 4));
                        second = Integer.parseInt(time.substring(4, 6));
                        actualTimeStamp = new GregorianCalendar(year, month - 1, day, hour, minute, second).getTimeInMillis();
                        if (kTimeStepExtension != null) {
                            actualTimeStamp += Long.parseLong(line.substring(kTimeStepExtension.start, kTimeStepExtension.end));
                        }
                        for (int i = 0; i < kExtensions.size() && i + 4 + bExtensions.size() < values.length; ++i) {
                            values[i + 4 + bExtensions.size()] = ((IgcExtension)kExtensions.get(i)).getValue(line);
                            log.log(Level.FINE, String.format("%s = %d", ((IgcExtension)kExtensions.get((int)i)).threeLetterCode, ((IgcExtension)kExtensions.get(i)).getValue(line) / 1000));
                        }
                        if (actualTimeStamp > timeStamp) {
                            recordSet.addNoneCalculationRecordsPoints(values, (double)(actualTimeStamp - startTimeStamp));
                        } else if (actualTimeStamp == timeStamp) {
                            if (log.isLoggable(Level.INFO)) {
                                log.log(Level.INFO, String.format("%s at %s ms %s", recordSet.getName(), new SimpleDateFormat("HH:mm:ss.SSS").format(actualTimeStamp), StringHelper.arrayToString1000((int[])values)));
                            }
                            recordSet.replaceUpdateNoneCalculationRecordsPoints(values);
                        }
                        timeStamp = actualTimeStamp;
                        continue;
                    }
                    if (line.startsWith("F")) {
                        log.log(Level.FINE, "F RECORD - SATELLITE CONSTELLATION = " + line);
                        continue;
                    }
                    if (line.startsWith("E")) {
                        if (line.endsWith("ARM")) {
                            log.log(Level.FINE, "E RECORD - Albatross task arm = " + line);
                        }
                        if ((line.endsWith("STA") || line.endsWith("STO")) && result != null) {
                            log.log(Level.FINE, "E RECORD - Albatross task start/stop = " + line);
                            String taskType = "Sport";
                            if (albatrossTask.toString().contains("200,250,70")) {
                                taskType = "Light";
                            } else if (albatrossTask.toString().contains("500,500,120")) {
                                taskType = "SLS";
                            }
                            log.log(Level.OFF, result.toString(taskType));
                            triangles.append(result.toString(taskType));
                            result = null;
                            continue;
                        }
                        if (line.endsWith("TPC")) {
                            log.log(Level.FINE, "E RECORD - Albatross task turn point condition = " + line);
                            continue;
                        }
                        log.log(Level.FINE, "E RECORD - Albatross entry = " + line);
                        continue;
                    }
                    if (line.startsWith("LISTAT") || line.startsWith("LRCE_TRIANGLE_LAP_STAT")) {
                        log.log(Level.FINE, "L RECORD - Albatross stat = " + line);
                        if (line.startsWith("LISTAT{") || !line.startsWith("LISTAT:LAP:{") && !line.startsWith("LRCE_TRIANGLE_LAP_STAT")) continue;
                        if (result == null) {
                            result = new GpsTaskResult();
                        }
                        result.addLap(new GpsLap(line));
                        continue;
                    }
                    if (line.startsWith("LSTAT")) {
                        log.log(Level.FINE, "L RECORD - Albatross stat = " + line);
                        if (result == null) continue;
                        result.add(line);
                        String taskType = "Sport";
                        if (albatrossTask.toString().contains("200,250,70")) {
                            taskType = "Light";
                        } else if (albatrossTask.toString().contains("500,500,120")) {
                            taskType = "SLS";
                        }
                        log.log(Level.OFF, result.toString(taskType));
                        triangles.append(result.toString(taskType));
                        result = null;
                        continue;
                    }
                    if (line.startsWith("LRCE_GPS_TRIANGLE")) {
                        log.log(Level.FINE, "L RECORD - Albatross stat = " + line);
                        if (result == null) continue;
                        result.add(line);
                        continue;
                    }
                    if (line.startsWith("LSTART")) {
                        log.log(Level.FINE, "L RECORD - Albatross start = " + line);
                        continue;
                    }
                    if (line.startsWith("LSECT")) {
                        log.log(Level.FINE, "L RECORD - Albatross section = " + line);
                        continue;
                    }
                    if (line.startsWith("LHRSTAT")) {
                        log.log(Level.FINE, "L RECORD - Albatross task stats = " + line);
                        continue;
                    }
                    if (line.startsWith("LPNP")) {
                        log.log(Level.FINE, "L RECORD - Albatross lap add penalty = " + line);
                        continue;
                    }
                    if (line.startsWith("L")) {
                        log.log(Level.FINE, "L RECORD - ??? = " + line);
                        continue;
                    }
                    if (line.startsWith("G")) {
                        log.log(Level.FINE, "line number " + lineNumber + " contains security code and is voted as last line! " + lastLine);
                        break;
                    }
                    log.log(Level.WARNING, "line number " + lineNumber + " line length to short or missing " + device.getDataBlockLeader() + " !");
                } while ((line = reader.readLine()) != null);
                device.updateVisibilityStatus((RecordSet)activeChannel.get(recordSetName), true);
                if (GDE.isWithUi()) {
                    activeChannel.switchRecordSet((String)recordSetName);
                } else {
                    activeChannel.setActiveRecordSet(recordSet);
                }
                ((RecordSet)activeChannel.get(recordSetName)).checkAllDisplayable();
                reader.close();
                reader = null;
            }
            if (error.length() > 10) {
                recordSet.setRecordSetDescription(recordSet.getRecordSetDescription() + GDE.LINE_SEPARATOR + String.valueOf(error));
            }
        }
        catch (FileNotFoundException e) {
            log.log(java.util.logging.Level.WARNING, e.getMessage(), e);
            application.openMessageDialog(e.getMessage());
        }
        catch (IOException e) {
            log.log(java.util.logging.Level.WARNING, e.getMessage(), e);
            application.openMessageDialog(e.getMessage());
        }
        catch (Exception e) {
            if (activeChannel != null && activeChannel.size() > 0) {
                String recordSetName = activeChannel.getFirstRecordSetName();
                activeChannel.setActiveRecordSet(recordSetName);
                device.updateVisibilityStatus((RecordSet)activeChannel.get((Object)recordSetName), true);
                ((RecordSet)activeChannel.get((Object)recordSetName)).checkAllDisplayable();
                if (GDE.isWithUi()) {
                    activeChannel.switchRecordSet(recordSetName);
                }
            }
            String msg = filePath + " - " + Messages.getString((String)"GDE_MSGE0045", (Object[])new Object[]{e.getMessage(), lineNumber});
            log.log(java.util.logging.Level.WARNING, msg, e);
            if (GDE.isWithUi()) {
                application.openMessageDialog(msg);
            }
        }
        finally {
            GDE.getUiNotification().setProgress(100);
            GDE.getUiNotification().setStatusMessage("");
        }
        return recordSet;
    }

    public static void write(IDevice device, String igcFilePath, StringBuilder header, RecordSet recordSet, int ordinalLongitude, int ordinalLatitude, int ordinalAltitude, int startAltitude) throws Exception {
        StringBuilder content = new StringBuilder().append((CharSequence)header);
        long startTime = new Date().getTime();
        try {
            GDE.getUiNotification().setStatusMessage(Messages.getString((String)"GDE_MSGT0138", (Object[])new String[]{"igc", igcFilePath}));
            if (recordSet != null) {
                int startIndex = GPSHelper.getStartIndexGPS((RecordSet)recordSet, (int)ordinalLatitude, (int)ordinalLongitude);
                Record recordAlitude = recordSet.get(ordinalAltitude);
                SimpleDateFormat sdf = new SimpleDateFormat("HHmmss");
                int offsetHeight = (int)((double)startAltitude - device.translateValue(recordAlitude, (double)recordAlitude.get(startIndex).intValue() / 1000.0));
                char fixValidity = offsetHeight == 0 ? (char)'A' : 'V';
                long lastTimeStamp = -1L;
                long recordSetStartTimeStamp = recordSet.getStartTimeStamp();
                log.log(Level.TIME, "start time stamp = " + StringHelper.getFormatedTime((String)"yyyy-MM-dd HH:mm:ss", (long)recordSetStartTimeStamp));
                for (int i = startIndex; startIndex >= 0 && i < recordSet.get(ordinalLongitude).realSize(); ++i) {
                    long timeStamp = recordSet.getTime(i) / 10L + recordSetStartTimeStamp;
                    if (timeStamp - lastTimeStamp < 950L && lastTimeStamp != -1L) continue;
                    content.append(String.format("B%s%s\r\n", sdf.format(timeStamp), device.translateGPS2IGC(recordSet, i, fixValidity, startAltitude, offsetHeight)));
                    lastTimeStamp = timeStamp;
                }
            }
            BufferedWriter writer = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(igcFilePath), "ISO-8859-1"));
            writer.append(content.toString());
            writer.flush();
            writer.close();
            writer = null;
            GDE.getUiNotification().setProgress(100);
        }
        catch (RuntimeException e) {
            log.log(java.util.logging.Level.SEVERE, e.getMessage(), e);
            throw new Exception(Messages.getString((String)"GDE_MSGE0007") + e.getClass().getSimpleName() + " - " + e.getMessage());
        }
        finally {
            GDE.getUiNotification().setStatusMessage("");
        }
        if (log.isLoggable(Level.TIME)) {
            log.log(Level.TIME, "IGC file = " + igcFilePath + " written successfulywrite time = " + StringHelper.getFormatedTime((String)"ss:SSS", (long)(new Date().getTime() - startTime)));
        }
    }
}

