/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.math3.analysis.function;

import org.apache.commons.math3.analysis.DifferentiableUnivariateFunction;
import org.apache.commons.math3.analysis.FunctionUtils;
import org.apache.commons.math3.analysis.ParametricUnivariateFunction;
import org.apache.commons.math3.analysis.UnivariateFunction;
import org.apache.commons.math3.analysis.differentiation.DerivativeStructure;
import org.apache.commons.math3.analysis.differentiation.UnivariateDifferentiableFunction;
import org.apache.commons.math3.exception.DimensionMismatchException;
import org.apache.commons.math3.exception.NotStrictlyPositiveException;
import org.apache.commons.math3.exception.NullArgumentException;
import org.apache.commons.math3.util.FastMath;

public class Logistic
implements UnivariateDifferentiableFunction,
DifferentiableUnivariateFunction {
    private final double a;
    private final double k;
    private final double b;
    private final double oneOverN;
    private final double q;
    private final double m;

    public Logistic(double k2, double m2, double b2, double q2, double a2, double n2) throws NotStrictlyPositiveException {
        if (n2 <= 0.0) {
            throw new NotStrictlyPositiveException(n2);
        }
        this.k = k2;
        this.m = m2;
        this.b = b2;
        this.q = q2;
        this.a = a2;
        this.oneOverN = 1.0 / n2;
    }

    public double value(double x2) {
        return Logistic.value(this.m - x2, this.k, this.b, this.q, this.a, this.oneOverN);
    }

    @Deprecated
    public UnivariateFunction derivative() {
        return FunctionUtils.toDifferentiableUnivariateFunction(this).derivative();
    }

    private static double value(double mMinusX, double k2, double b2, double q2, double a2, double oneOverN) {
        return a2 + (k2 - a2) / FastMath.pow(1.0 + q2 * FastMath.exp(b2 * mMinusX), oneOverN);
    }

    public DerivativeStructure value(DerivativeStructure t2) {
        return t2.negate().add(this.m).multiply(this.b).exp().multiply(this.q).add(1.0).pow(this.oneOverN).reciprocal().multiply(this.k - this.a).add(this.a);
    }

    public static class Parametric
    implements ParametricUnivariateFunction {
        public double value(double x2, double ... param2) throws NullArgumentException, DimensionMismatchException, NotStrictlyPositiveException {
            this.validateParameters(param2);
            return Logistic.value(param2[1] - x2, param2[0], param2[2], param2[3], param2[4], 1.0 / param2[5]);
        }

        public double[] gradient(double x2, double ... param2) throws NullArgumentException, DimensionMismatchException, NotStrictlyPositiveException {
            this.validateParameters(param2);
            double b2 = param2[2];
            double q2 = param2[3];
            double mMinusX = param2[1] - x2;
            double oneOverN = 1.0 / param2[5];
            double exp = FastMath.exp(b2 * mMinusX);
            double qExp = q2 * exp;
            double qExp1 = qExp + 1.0;
            double factor1 = (param2[0] - param2[4]) * oneOverN / FastMath.pow(qExp1, oneOverN);
            double factor2 = -factor1 / qExp1;
            double gk = Logistic.value(mMinusX, 1.0, b2, q2, 0.0, oneOverN);
            double gm = factor2 * b2 * qExp;
            double gb = factor2 * mMinusX * qExp;
            double gq = factor2 * exp;
            double ga = Logistic.value(mMinusX, 0.0, b2, q2, 1.0, oneOverN);
            double gn = factor1 * FastMath.log(qExp1) * oneOverN;
            return new double[]{gk, gm, gb, gq, ga, gn};
        }

        private void validateParameters(double[] param2) throws NullArgumentException, DimensionMismatchException, NotStrictlyPositiveException {
            if (param2 == null) {
                throw new NullArgumentException();
            }
            if (param2.length != 6) {
                throw new DimensionMismatchException(param2.length, 6);
            }
            if (param2[5] <= 0.0) {
                throw new NotStrictlyPositiveException(param2[5]);
            }
        }
    }
}

