/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.custom;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.swt.SWT;
import org.eclipse.swt.custom.StyledTextContent;
import org.eclipse.swt.custom.StyledTextEvent;
import org.eclipse.swt.custom.StyledTextListener;
import org.eclipse.swt.custom.TextChangeListener;
import org.eclipse.swt.internal.Compatibility;
import org.eclipse.swt.widgets.TypedListener;

class DefaultContent
implements StyledTextContent {
    private static final String LineDelimiter = System.getProperty("line.separator");
    List<StyledTextListener> textListeners = new ArrayList<StyledTextListener>();
    char[] textStore = new char[0];
    int gapStart = -1;
    int gapEnd = -1;
    int gapLine = -1;
    int highWatermark = 300;
    int lowWatermark = 50;
    int[][] lines = new int[50][2];
    int lineCount = 0;
    int expandExp = 1;
    int replaceExpandExp = 1;

    DefaultContent() {
        this.setText("");
    }

    void addLineIndex(int start, int length) {
        int size = this.lines.length;
        if (this.lineCount == size) {
            int[][] newLines = new int[size + Compatibility.pow2(this.expandExp)][2];
            System.arraycopy(this.lines, 0, newLines, 0, size);
            this.lines = newLines;
            ++this.expandExp;
        }
        int[] range = new int[]{start, length};
        this.lines[this.lineCount] = range;
        ++this.lineCount;
    }

    int[][] addLineIndex(int start, int length, int[][] linesArray, int count) {
        int size = linesArray.length;
        int[][] newLines = linesArray;
        if (count == size) {
            newLines = new int[size + Compatibility.pow2(this.replaceExpandExp)][2];
            ++this.replaceExpandExp;
            System.arraycopy(linesArray, 0, newLines, 0, size);
        }
        int[] range = new int[]{start, length};
        newLines[count] = range;
        return newLines;
    }

    @Override
    public void addTextChangeListener(TextChangeListener listener2) {
        if (listener2 == null) {
            this.error(4);
        }
        StyledTextListener typedListener = new StyledTextListener(listener2);
        this.textListeners.add(typedListener);
    }

    void adjustGap(int position, int sizeHint, int line2) {
        int size;
        if (position == this.gapStart ? this.lowWatermark <= (size = this.gapEnd - this.gapStart - sizeHint) && size <= this.highWatermark : position + sizeHint == this.gapStart && sizeHint < 0 && this.lowWatermark <= (size = this.gapEnd - this.gapStart - sizeHint) && size <= this.highWatermark) {
            return;
        }
        this.moveAndResizeGap(position, sizeHint, line2);
    }

    void indexLines() {
        int start = 0;
        this.lineCount = 0;
        int textLength = this.textStore.length;
        int i2 = start;
        while (i2 < textLength) {
            char ch = this.textStore[i2];
            if (ch == '\r') {
                if (i2 + 1 < textLength && (ch = this.textStore[i2 + 1]) == '\n') {
                    ++i2;
                }
                this.addLineIndex(start, i2 - start + 1);
                start = i2 + 1;
            } else if (ch == '\n') {
                this.addLineIndex(start, i2 - start + 1);
                start = i2 + 1;
            }
            ++i2;
        }
        this.addLineIndex(start, i2 - start);
    }

    boolean isDelimiter(char ch) {
        if (ch == '\r') {
            return true;
        }
        return ch == '\n';
    }

    protected boolean isValidReplace(int start, int replaceLength, String newText) {
        if (replaceLength == 0) {
            char after;
            if (start == 0) {
                return true;
            }
            if (start == this.getCharCount()) {
                return true;
            }
            char before = this.getTextRange(start - 1, 1).charAt(0);
            if (before == '\r' && (after = this.getTextRange(start, 1).charAt(0)) == '\n') {
                return false;
            }
        } else {
            char after;
            char before;
            char startChar = this.getTextRange(start, 1).charAt(0);
            if (startChar == '\n' && start != 0 && (before = this.getTextRange(start - 1, 1).charAt(0)) == '\r') {
                return false;
            }
            char endChar = this.getTextRange(start + replaceLength - 1, 1).charAt(0);
            if (endChar == '\r' && start + replaceLength != this.getCharCount() && (after = this.getTextRange(start + replaceLength, 1).charAt(0)) == '\n') {
                return false;
            }
        }
        return true;
    }

    int[][] indexLines(int offset, int length, int numLines) {
        int[][] indexedLines = new int[numLines][2];
        int start = 0;
        int lineCount = 0;
        this.replaceExpandExp = 1;
        int i2 = start;
        while (i2 < length) {
            int location = i2 + offset;
            if (location < this.gapStart || location >= this.gapEnd) {
                char ch = this.textStore[location];
                if (ch == '\r') {
                    if (location + 1 < this.textStore.length && (ch = this.textStore[location + 1]) == '\n') {
                        ++i2;
                    }
                    indexedLines = this.addLineIndex(start, i2 - start + 1, indexedLines, lineCount);
                    ++lineCount;
                    start = i2 + 1;
                } else if (ch == '\n') {
                    indexedLines = this.addLineIndex(start, i2 - start + 1, indexedLines, lineCount);
                    ++lineCount;
                    start = i2 + 1;
                }
            }
            ++i2;
        }
        int[][] newLines = new int[lineCount + 1][2];
        System.arraycopy(indexedLines, 0, newLines, 0, lineCount);
        int[] range = new int[]{start, i2 - start};
        newLines[lineCount] = range;
        return newLines;
    }

    void insert(int position, String text2) {
        int numNewLines;
        int[][] newLines;
        if (text2.length() == 0) {
            return;
        }
        int startLine = this.getLineAtOffset(position);
        int change = text2.length();
        boolean endInsert = position == this.getCharCount();
        this.adjustGap(position, change, startLine);
        int startLineOffset = this.getOffsetAtLine(startLine);
        int startLineLength = this.getPhysicalLine(startLine).length();
        if (change > 0) {
            this.gapStart += change;
            int i2 = 0;
            while (i2 < text2.length()) {
                this.textStore[position + i2] = text2.charAt(i2);
                ++i2;
            }
        }
        if ((newLines = this.indexLines(startLineOffset, startLineLength, 10))[numNewLines = newLines.length - 1][1] == 0) {
            numNewLines = endInsert ? ++numNewLines : --numNewLines;
        }
        this.expandLinesBy(numNewLines);
        int i3 = this.lineCount - 1;
        while (i3 > startLine) {
            this.lines[i3 + numNewLines] = this.lines[i3];
            --i3;
        }
        i3 = 0;
        while (i3 < numNewLines) {
            int[] nArray = newLines[i3];
            nArray[0] = nArray[0] + startLineOffset;
            this.lines[startLine + i3] = newLines[i3];
            ++i3;
        }
        if (numNewLines < newLines.length) {
            int[] nArray = newLines[numNewLines];
            nArray[0] = nArray[0] + startLineOffset;
            this.lines[startLine + numNewLines] = newLines[numNewLines];
        }
        this.lineCount += numNewLines;
        this.gapLine = this.getLineAtPhysicalOffset(this.gapStart);
    }

    void moveAndResizeGap(int position, int size, int newGapLine) {
        int delta;
        char[] content = null;
        int oldSize = this.gapEnd - this.gapStart;
        int newSize = size > 0 ? this.highWatermark + size : this.lowWatermark - size;
        if (this.gapExists()) {
            this.lines[this.gapLine][1] = this.lines[this.gapLine][1] - oldSize;
            int i2 = this.gapLine + 1;
            while (i2 < this.lineCount) {
                this.lines[i2][0] = this.lines[i2][0] - oldSize;
                ++i2;
            }
        }
        if (newSize < 0) {
            if (oldSize > 0) {
                content = new char[this.textStore.length - oldSize];
                System.arraycopy(this.textStore, 0, content, 0, this.gapStart);
                System.arraycopy(this.textStore, this.gapEnd, content, this.gapStart, content.length - this.gapStart);
                this.textStore = content;
            }
            this.gapStart = this.gapEnd = position;
            return;
        }
        content = new char[this.textStore.length + (newSize - oldSize)];
        int newGapStart = position;
        int newGapEnd = newGapStart + newSize;
        if (oldSize == 0) {
            System.arraycopy(this.textStore, 0, content, 0, newGapStart);
            System.arraycopy(this.textStore, newGapStart, content, newGapEnd, content.length - newGapEnd);
        } else if (newGapStart < this.gapStart) {
            delta = this.gapStart - newGapStart;
            System.arraycopy(this.textStore, 0, content, 0, newGapStart);
            System.arraycopy(this.textStore, newGapStart, content, newGapEnd, delta);
            System.arraycopy(this.textStore, this.gapEnd, content, newGapEnd + delta, this.textStore.length - this.gapEnd);
        } else {
            delta = newGapStart - this.gapStart;
            System.arraycopy(this.textStore, 0, content, 0, this.gapStart);
            System.arraycopy(this.textStore, this.gapEnd, content, this.gapStart, delta);
            System.arraycopy(this.textStore, this.gapEnd + delta, content, newGapEnd, content.length - newGapEnd);
        }
        this.textStore = content;
        this.gapStart = newGapStart;
        this.gapEnd = newGapEnd;
        if (this.gapExists()) {
            this.gapLine = newGapLine;
            int gapLength = this.gapEnd - this.gapStart;
            this.lines[this.gapLine][1] = this.lines[this.gapLine][1] + gapLength;
            int i3 = this.gapLine + 1;
            while (i3 < this.lineCount) {
                this.lines[i3][0] = this.lines[i3][0] + gapLength;
                ++i3;
            }
        }
    }

    int lineCount(int startOffset, int length) {
        if (length == 0) {
            return 0;
        }
        int lineCount = 0;
        int count = 0;
        int i2 = startOffset;
        if (i2 >= this.gapStart) {
            i2 += this.gapEnd - this.gapStart;
        }
        while (count < length) {
            if (i2 < this.gapStart || i2 >= this.gapEnd) {
                char ch = this.textStore[i2];
                if (ch == '\r') {
                    if (i2 + 1 < this.textStore.length && (ch = this.textStore[i2 + 1]) == '\n') {
                        ++i2;
                        ++count;
                    }
                    ++lineCount;
                } else if (ch == '\n') {
                    ++lineCount;
                }
                ++count;
            }
            ++i2;
        }
        return lineCount;
    }

    int lineCount(String text2) {
        int lineCount = 0;
        int length = text2.length();
        int i2 = 0;
        while (i2 < length) {
            char ch = text2.charAt(i2);
            if (ch == '\r') {
                if (i2 + 1 < length && text2.charAt(i2 + 1) == '\n') {
                    ++i2;
                }
                ++lineCount;
            } else if (ch == '\n') {
                ++lineCount;
            }
            ++i2;
        }
        return lineCount;
    }

    @Override
    public int getCharCount() {
        int length = this.gapEnd - this.gapStart;
        return this.textStore.length - length;
    }

    @Override
    public String getLine(int index) {
        if (index >= this.lineCount || index < 0) {
            this.error(5);
        }
        int start = this.lines[index][0];
        int length = this.lines[index][1];
        int end = start + length - 1;
        if (!this.gapExists() || end < this.gapStart || start >= this.gapEnd) {
            while (length - 1 >= 0 && this.isDelimiter(this.textStore[start + length - 1])) {
                --length;
            }
            return new String(this.textStore, start, length);
        }
        StringBuilder buf = new StringBuilder();
        int gapLength = this.gapEnd - this.gapStart;
        buf.append(this.textStore, start, this.gapStart - start);
        buf.append(this.textStore, this.gapEnd, length - gapLength - (this.gapStart - start));
        length = buf.length();
        while (length - 1 >= 0 && this.isDelimiter(buf.charAt(length - 1))) {
            --length;
        }
        return buf.toString().substring(0, length);
    }

    @Override
    public String getLineDelimiter() {
        return LineDelimiter;
    }

    String getFullLine(int index) {
        int start = this.lines[index][0];
        int length = this.lines[index][1];
        int end = start + length - 1;
        if (!this.gapExists() || end < this.gapStart || start >= this.gapEnd) {
            return new String(this.textStore, start, length);
        }
        StringBuilder buffer = new StringBuilder();
        int gapLength = this.gapEnd - this.gapStart;
        buffer.append(this.textStore, start, this.gapStart - start);
        buffer.append(this.textStore, this.gapEnd, length - gapLength - (this.gapStart - start));
        return buffer.toString();
    }

    String getPhysicalLine(int index) {
        int start = this.lines[index][0];
        int length = this.lines[index][1];
        return this.getPhysicalText(start, length);
    }

    @Override
    public int getLineCount() {
        return this.lineCount;
    }

    @Override
    public int getLineAtOffset(int charPosition) {
        int lastLine;
        if (charPosition > this.getCharCount() || charPosition < 0) {
            this.error(5);
        }
        int position = charPosition < this.gapStart ? charPosition : charPosition + (this.gapEnd - this.gapStart);
        if (this.lineCount > 0 && position == this.lines[lastLine = this.lineCount - 1][0] + this.lines[lastLine][1]) {
            return lastLine;
        }
        int high = this.lineCount;
        int low = -1;
        int index = this.lineCount;
        while (high - low > 1) {
            index = (high + low) / 2;
            int lineStart = this.lines[index][0];
            int lineEnd = lineStart + this.lines[index][1] - 1;
            if (position <= lineStart) {
                high = index;
                continue;
            }
            if (position <= lineEnd) {
                high = index;
                break;
            }
            low = index;
        }
        return high;
    }

    int getLineAtPhysicalOffset(int position) {
        int high = this.lineCount;
        int low = -1;
        int index = this.lineCount;
        while (high - low > 1) {
            index = (high + low) / 2;
            int lineStart = this.lines[index][0];
            int lineEnd = lineStart + this.lines[index][1] - 1;
            if (position <= lineStart) {
                high = index;
                continue;
            }
            if (position <= lineEnd) {
                high = index;
                break;
            }
            low = index;
        }
        return high;
    }

    @Override
    public int getOffsetAtLine(int lineIndex) {
        int start;
        if (lineIndex == 0) {
            return 0;
        }
        if (lineIndex >= this.lineCount || lineIndex < 0) {
            this.error(5);
        }
        if ((start = this.lines[lineIndex][0]) > this.gapEnd) {
            return start - (this.gapEnd - this.gapStart);
        }
        return start;
    }

    void expandLinesBy(int numLines) {
        int size = this.lines.length;
        if (size - this.lineCount >= numLines) {
            return;
        }
        int[][] newLines = new int[size + Math.max(10, numLines)][2];
        System.arraycopy(this.lines, 0, newLines, 0, size);
        this.lines = newLines;
    }

    void error(int code) {
        SWT.error(code);
    }

    boolean gapExists() {
        return this.gapStart != this.gapEnd;
    }

    String getPhysicalText(int start, int length) {
        return new String(this.textStore, start, length);
    }

    @Override
    public String getTextRange(int start, int length) {
        if (this.textStore == null) {
            return "";
        }
        if (length == 0) {
            return "";
        }
        int end = start + length;
        if (!this.gapExists() || end < this.gapStart) {
            return new String(this.textStore, start, length);
        }
        if (this.gapStart < start) {
            int gapLength = this.gapEnd - this.gapStart;
            return new String(this.textStore, start + gapLength, length);
        }
        StringBuilder buf = new StringBuilder();
        buf.append(this.textStore, start, this.gapStart - start);
        buf.append(this.textStore, this.gapEnd, end - this.gapStart);
        return buf.toString();
    }

    @Override
    public void removeTextChangeListener(TextChangeListener listener2) {
        if (listener2 == null) {
            this.error(4);
        }
        int i2 = 0;
        while (i2 < this.textListeners.size()) {
            TypedListener typedListener = this.textListeners.get(i2);
            if (typedListener.getEventListener() == listener2) {
                this.textListeners.remove(i2);
                break;
            }
            ++i2;
        }
    }

    @Override
    public void replaceTextRange(int start, int replaceLength, String newText) {
        if (!this.isValidReplace(start, replaceLength, newText)) {
            SWT.error(5);
        }
        StyledTextEvent event = new StyledTextEvent(this);
        event.type = 3003;
        event.start = start;
        event.replaceLineCount = this.lineCount(start, replaceLength);
        event.text = newText;
        event.newLineCount = this.lineCount(newText);
        event.replaceCharCount = replaceLength;
        event.newCharCount = newText.length();
        this.sendTextEvent(event);
        this.delete(start, replaceLength, event.replaceLineCount + 1);
        this.insert(start, newText);
        event = new StyledTextEvent(this);
        event.type = 3006;
        this.sendTextEvent(event);
    }

    void sendTextEvent(StyledTextEvent event) {
        int i2 = 0;
        while (i2 < this.textListeners.size()) {
            this.textListeners.get(i2).handleEvent(event);
            ++i2;
        }
    }

    @Override
    public void setText(String text2) {
        this.textStore = text2.toCharArray();
        this.gapStart = -1;
        this.gapEnd = -1;
        this.expandExp = 1;
        this.indexLines();
        StyledTextEvent event = new StyledTextEvent(this);
        event.type = 3004;
        event.text = "";
        this.sendTextEvent(event);
    }

    void delete(int position, int length, int numLines) {
        if (length == 0) {
            return;
        }
        int startLine = this.getLineAtOffset(position);
        int startLineOffset = this.getOffsetAtLine(startLine);
        int endLine = this.getLineAtOffset(position + length);
        String endText = "";
        boolean splittingDelimiter = false;
        if (position + length < this.getCharCount() && (endText = this.getTextRange(position + length - 1, 2)).charAt(0) == '\r' && endText.charAt(1) == '\n') {
            splittingDelimiter = true;
        }
        this.adjustGap(position + length, -length, startLine);
        int[][] oldLines = this.indexLines(position, length + (this.gapEnd - this.gapStart), numLines);
        if (position + length == this.gapStart) {
            this.gapStart -= length;
        } else {
            this.gapEnd += length;
        }
        int j2 = position;
        boolean eol = false;
        while (j2 < this.textStore.length && !eol) {
            char ch;
            if ((j2 < this.gapStart || j2 >= this.gapEnd) && this.isDelimiter(ch = this.textStore[j2])) {
                if (j2 + 1 < this.textStore.length && ch == '\r' && this.textStore[j2 + 1] == '\n') {
                    ++j2;
                }
                eol = true;
            }
            ++j2;
        }
        this.lines[startLine][1] = position - startLineOffset + (j2 - position);
        int numOldLines = oldLines.length - 1;
        if (splittingDelimiter) {
            --numOldLines;
        }
        int i2 = endLine + 1;
        while (i2 < this.lineCount) {
            this.lines[i2 - numOldLines] = this.lines[i2];
            ++i2;
        }
        this.lineCount -= numOldLines;
        this.gapLine = this.getLineAtPhysicalOffset(this.gapStart);
    }
}

