/*
 * Decompiled with CFR 0.152.
 */
package gde.comm;

import com.fazecast.jSerialComm.SerialPort;
import gde.GDE;
import gde.comm.DeviceCommPort;
import gde.comm.IDeviceCommPort;
import gde.config.Settings;
import gde.device.DeviceConfiguration;
import gde.device.IDevice;
import gde.exception.ApplicationConfigurationException;
import gde.exception.FailedQueryException;
import gde.exception.SerialPortException;
import gde.exception.TimeOutException;
import gde.log.Level;
import gde.messages.Messages;
import gde.ui.DataExplorer;
import gde.ui.dialog.LibUsbDeviceSelectionDialog;
import gde.ui.dialog.UsbDeviceSelectionDialog;
import gde.utils.WaitTimer;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.IntBuffer;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;
import java.util.Vector;
import java.util.logging.Logger;
import javax.usb.UsbClaimException;
import javax.usb.UsbConfiguration;
import javax.usb.UsbDevice;
import javax.usb.UsbDeviceDescriptor;
import javax.usb.UsbDisconnectedException;
import javax.usb.UsbEndpoint;
import javax.usb.UsbException;
import javax.usb.UsbHostManager;
import javax.usb.UsbHub;
import javax.usb.UsbInterface;
import javax.usb.UsbInterfacePolicy;
import javax.usb.UsbNotActiveException;
import javax.usb.UsbNotClaimedException;
import javax.usb.UsbPipe;
import javax.usb.UsbServices;
import javax.usb.event.UsbPipeDataEvent;
import javax.usb.event.UsbPipeErrorEvent;
import javax.usb.event.UsbPipeListener;
import org.usb4java.BufferUtils;
import org.usb4java.ConfigDescriptor;
import org.usb4java.Context;
import org.usb4java.Device;
import org.usb4java.DeviceDescriptor;
import org.usb4java.DeviceHandle;
import org.usb4java.DeviceList;
import org.usb4java.LibUsb;
import org.usb4java.LibUsbException;

public class DeviceUsbPortImpl
extends DeviceCommPort
implements IDeviceCommPort {
    private static final Logger log = Logger.getLogger(DeviceUsbPortImpl.class.getName());
    protected final DeviceConfiguration usbDeviceConfig;
    protected final DataExplorer usbApplication;
    final Settings usbSettings;
    boolean isConnected = false;
    int asyncReceived = 0;
    boolean isAsyncReceived = false;
    int endpointTransferType = 3;
    Set<UsbDevice> usbDevices = new HashSet<UsbDevice>();
    Set<Device> libUsbDevices = new HashSet<Device>();
    static Device selectedUsbDevice = null;

    public DeviceUsbPortImpl(DeviceConfiguration currentDeviceConfig, DataExplorer currentApplication) {
        this.usbDeviceConfig = currentDeviceConfig;
        this.usbApplication = currentApplication;
        this.usbSettings = Settings.getInstance();
    }

    public DeviceUsbPortImpl() {
        this.usbDeviceConfig = null;
        this.usbApplication = null;
        this.usbSettings = null;
    }

    public SerialPort open() throws ApplicationConfigurationException, SerialPortException {
        return null;
    }

    @Override
    public void close() {
    }

    @Override
    public byte[] read(byte[] readBuffer, int timeout_msec) throws IOException, TimeOutException {
        return null;
    }

    @Override
    public synchronized byte[] read(byte[] readBuffer, int timeout_msec, boolean checkFailedQuery) throws IOException, FailedQueryException, TimeOutException {
        return null;
    }

    @Override
    public byte[] read(byte[] readBuffer, int timeout_msec, int stableIndex) throws IOException, TimeOutException {
        return null;
    }

    @Override
    public byte[] read(byte[] readBuffer, int timeout_msec, int stableIndex, int minCountBytes) throws IOException, TimeOutException {
        return null;
    }

    @Override
    public byte[] read(byte[] readBuffer, int timeout_msec, Vector<Long> waitTimes) throws IOException, TimeOutException {
        return null;
    }

    @Override
    public void write(byte[] writeBuffer) throws IOException {
    }

    @Override
    public void write(byte[] writeBuffer, long gap_ms) throws IOException {
    }

    @Override
    public int cleanInputStream() throws IOException {
        return 0;
    }

    @Override
    public long wait4Bytes(int timeout_msec) throws InterruptedException, TimeOutException, IOException {
        return 0L;
    }

    @Override
    public int wait4Bytes(int numBytes, int timeout_msec) throws IOException {
        return 0;
    }

    @Override
    public int waitForStableReceiveBuffer(int expectedBytes, int timeout_msec, int stableIndex) throws InterruptedException, TimeOutException, IOException {
        return 0;
    }

    @Override
    public int waitForStableReceiveBuffer(int expectedBytes, int timeout_msec, int stableIndex, int minCount) throws InterruptedException, TimeOutException, IOException {
        return 0;
    }

    @Override
    public boolean isConnected() {
        return this.isConnected;
    }

    @Override
    public int getXferErrors() {
        return 0;
    }

    @Override
    public void addXferError() {
    }

    @Override
    public int getTimeoutErrors() {
        return 0;
    }

    @Override
    public void addTimeoutError() {
    }

    @Override
    public boolean isMatchAvailablePorts(String newSerialPortStr) {
        return false;
    }

    @Override
    public int getAvailableBytes() throws IOException {
        return 0;
    }

    @Override
    public Set<UsbDevice> findUsbDevices(short vendorId, short productId) throws UsbException {
        this.usbDevices.clear();
        UsbServices services = UsbHostManager.getUsbServices();
        return this.findDevices(services.getRootUsbHub(), vendorId, productId);
    }

    @Override
    public Set<UsbDevice> findUsbDevices(short vendorId, short productId, String productString) throws UsbException {
        this.usbDevices.clear();
        UsbServices services = UsbHostManager.getUsbServices();
        return this.findDevices(services.getRootUsbHub(), vendorId, productId, productString);
    }

    @Override
    public Set<UsbDevice> findDevices(UsbHub hub, short vendorId, short productId) {
        for (Object tmpDevice : hub.getAttachedUsbDevices()) {
            UsbDeviceDescriptor desc;
            if (!(tmpDevice instanceof UsbDevice)) continue;
            UsbDevice usbDevice = (UsbDevice)tmpDevice;
            if (log.isLoggable(Level.FINER)) {
                log.log(Level.FINER, usbDevice.toString());
                log.log(Level.FINER, usbDevice.getUsbDeviceDescriptor().toString());
            }
            if ((desc = usbDevice.getUsbDeviceDescriptor()).idVendor() == vendorId && desc.idProduct() == productId) {
                if (log.isLoggable(Level.FINE)) {
                    log.log(Level.FINE, usbDevice.toString());
                    log.log(Level.FINE, usbDevice.getUsbDeviceDescriptor().toString());
                }
                this.usbDevices.add(usbDevice);
                continue;
            }
            if (!usbDevice.isUsbHub()) continue;
            this.usbDevices.addAll(this.findDevices((UsbHub)usbDevice, vendorId, productId));
        }
        return this.usbDevices;
    }

    @Override
    public Set<UsbDevice> findDevices(UsbHub hub, short vendorId, short productId, String productString) {
        for (Object tmpDevice : hub.getAttachedUsbDevices()) {
            if (!(tmpDevice instanceof UsbDevice)) continue;
            UsbDevice usbDevice = (UsbDevice)tmpDevice;
            if (log.isLoggable(Level.FINER)) {
                log.log(Level.FINER, usbDevice.toString());
                log.log(Level.FINER, usbDevice.getUsbDeviceDescriptor().toString());
            }
            UsbDeviceDescriptor desc = usbDevice.getUsbDeviceDescriptor();
            String deviceProductString = "";
            try {
                deviceProductString = usbDevice.getString(desc.iProduct());
            }
            catch (UnsupportedEncodingException | UsbDisconnectedException | UsbException e) {
                log.log(Level.WARNING, e.getMessage(), e);
            }
            if (desc.idVendor() == vendorId && desc.idProduct() == productId && productString.equals(deviceProductString)) {
                if (log.isLoggable(Level.FINE)) {
                    log.log(Level.FINE, usbDevice.toString());
                    log.log(Level.FINE, usbDevice.getUsbDeviceDescriptor().toString());
                }
                this.usbDevices.add(usbDevice);
                continue;
            }
            if (!usbDevice.isUsbHub()) continue;
            this.usbDevices.addAll(this.findDevices((UsbHub)usbDevice, vendorId, productId));
        }
        return this.usbDevices;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set<Device> findDevices(short vendorId, short productId, String productString) throws LibUsbException {
        this.libUsbDevices.clear();
        DeviceList list = new DeviceList();
        Context context = new Context();
        int result = LibUsb.init((Context)context);
        if (result < 0) {
            throw new LibUsbException("Unable to initialize libusb", result);
        }
        result = LibUsb.getDeviceList((Context)context, (DeviceList)list);
        if (result < 0) {
            throw new LibUsbException("Unable to get device list", result);
        }
        try {
            for (Device libUsbDevice : list) {
                String[] descriptorStringArray;
                DeviceDescriptor descriptor;
                result = LibUsb.getDeviceDescriptor((Device)libUsbDevice, (DeviceDescriptor)(descriptor = new DeviceDescriptor()));
                if (result != 0) {
                    throw new LibUsbException("Unable to read device descriptor", result);
                }
                if (descriptor.idVendor() != vendorId || descriptor.idProduct() != productId) continue;
                if (productString == null || productString.length() == 0) {
                    this.libUsbDevices.add(libUsbDevice);
                    continue;
                }
                DeviceHandle handle = new DeviceHandle();
                result = LibUsb.open((Device)libUsbDevice, (DeviceHandle)handle);
                if (result < 0) {
                    log.log(Level.WARNING, String.format("Unable to open device: %s. Continuing without device handle.", LibUsb.strError((int)result)));
                    handle = null;
                }
                for (String descriptorString : descriptorStringArray = descriptor.dump(handle).split("\\n")) {
                    if (!descriptorString.contains("iProduct") || !descriptorString.contains(productString)) continue;
                    this.libUsbDevices.add(libUsbDevice);
                }
            }
        }
        finally {
            LibUsb.freeDeviceList((DeviceList)list, (boolean)true);
        }
        return this.libUsbDevices;
    }

    public void findUsbDevices(UsbHub hub) {
        for (Object tmpDevice : hub.getAttachedUsbDevices()) {
            if (!(tmpDevice instanceof UsbDevice)) continue;
            UsbDevice usbDevice = (UsbDevice)tmpDevice;
            log.log(Level.INFO, usbDevice.toString());
            log.log(Level.INFO, usbDevice.getUsbDeviceDescriptor().toString());
            if (!usbDevice.isUsbHub()) continue;
            this.findUsbDevices((UsbHub)usbDevice);
        }
    }

    public void dumpUsbDevices() throws UsbException {
        log.log(Level.INFO, "Use UsbHostManager.getUsbServices()\n");
        UsbServices services = UsbHostManager.getUsbServices();
        UsbHub hub = services.getRootUsbHub();
        this.findUsbDevices(hub);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void dumpLibUsbDevices() throws LibUsbException {
        log.log(Level.INFO, "Use LibUsb.getDeviceList()\n");
        DeviceList list = new DeviceList();
        Context context = new Context();
        int result = LibUsb.init((Context)context);
        if (result < 0) {
            throw new LibUsbException("Unable to initialize libusb", result);
        }
        result = LibUsb.getDeviceList((Context)context, (DeviceList)list);
        if (result < 0) {
            throw new LibUsbException("Unable to get device list", result);
        }
        try {
            for (Device libUsbDevice : list) {
                DeviceDescriptor descriptor;
                result = LibUsb.getDeviceDescriptor((Device)libUsbDevice, (DeviceDescriptor)(descriptor = new DeviceDescriptor()));
                if (result != 0) continue;
                log.log(Level.INFO, libUsbDevice.toString());
                DeviceHandle handle = new DeviceHandle();
                result = LibUsb.open((Device)libUsbDevice, (DeviceHandle)handle);
                if (result < 0) {
                    log.log(Level.WARNING, String.format("Unable to open device: %s. Continuing without device handle.", LibUsb.strError((int)result)));
                    handle = null;
                }
                log.log(Level.INFO, descriptor.dump(handle));
                DeviceUsbPortImpl.dumpConfigurationDescriptors(libUsbDevice, descriptor.bNumConfigurations());
                if (handle == null) continue;
                LibUsb.close((DeviceHandle)handle);
            }
        }
        finally {
            LibUsb.freeDeviceList((DeviceList)list, (boolean)true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void dumpConfigurationDescriptors(Device device, int numConfigurations) {
        for (byte i = 0; i < numConfigurations; i = (byte)(i + 1)) {
            ConfigDescriptor descriptor = new ConfigDescriptor();
            int result = LibUsb.getConfigDescriptor((Device)device, (byte)i, (ConfigDescriptor)descriptor);
            if (result < 0) {
                log.log(Level.SEVERE, new LibUsbException("Unable to read config descriptor", result).getMessage());
                continue;
            }
            try {
                log.log(Level.INFO, descriptor.dump().replaceAll("(?m)^", "  "));
                continue;
            }
            finally {
                try {
                    LibUsb.freeConfigDescriptor((ConfigDescriptor)descriptor);
                }
                catch (Exception exception) {}
            }
        }
    }

    @Override
    public void dumpUsbDevices(short vendorId, short productId) throws UsbException {
        Set<UsbDevice> myUsbDevices = this.findUsbDevices(vendorId, productId);
        for (UsbDevice myUsbDevice : myUsbDevices) {
            log.log(Level.FINE, myUsbDevice.toString());
            log.log(Level.FINE, myUsbDevice.getUsbDeviceDescriptor().toString());
        }
        Set<Device> myLibUsbDevices = this.findDevices(vendorId, productId, new String());
        for (Device myLibUsbDevice : myLibUsbDevices) {
            DeviceDescriptor descriptor;
            int result = LibUsb.getDeviceDescriptor((Device)myLibUsbDevice, (DeviceDescriptor)(descriptor = new DeviceDescriptor()));
            if (result != 0) continue;
            DeviceHandle handle = new DeviceHandle();
            result = LibUsb.open((Device)myLibUsbDevice, (DeviceHandle)handle);
            if (result < 0) {
                log.log(Level.WARNING, String.format("Unable to open device: %s. Continuing without device handle.", LibUsb.strError((int)result)));
                handle = null;
            }
            log.log(Level.FINE, myLibUsbDevice.toString());
            log.log(Level.FINE, String.format("Device %03d/%03d", LibUsb.getBusNumber((Device)myLibUsbDevice), LibUsb.getDeviceAddress((Device)myLibUsbDevice)));
            log.log(Level.FINE, descriptor.dump(handle));
            if (handle == null) continue;
            LibUsb.close((DeviceHandle)handle);
        }
    }

    @Override
    public synchronized UsbInterface openUsbPort(IDevice activeDevice) throws UsbClaimException, UsbException {
        if (log.isLoggable(Level.FINE)) {
            this.dumpUsbDevices();
        } else if (log.isLoggable(Level.INFO)) {
            this.dumpUsbDevices();
            this.dumpLibUsbDevices();
        }
        byte ifaceId = activeDevice.getUsbInterface();
        UsbInterface usbInterface = null;
        Set<UsbDevice> myUsbDevices = activeDevice.getUsbProductString() == null || activeDevice.getUsbProductString().equalsIgnoreCase("") ? this.findUsbDevices(activeDevice.getUsbVendorId(), activeDevice.getUsbProductId()) : this.findUsbDevices(activeDevice.getUsbVendorId(), activeDevice.getUsbProductId(), activeDevice.getUsbProductString());
        if (myUsbDevices.size() == 0) {
            this.usbApplication.openMessageDialog(Messages.getString("GDE_MSGE0050"));
        } else if (myUsbDevices.size() == 1) {
            for (UsbDevice usbDevice : myUsbDevices) {
                if (usbDevice == null) {
                    throw new UsbException(Messages.getString("GDE_MSGE0050"));
                }
                usbInterface = this.claimUsbInterface(usbDevice, ifaceId);
            }
        } else {
            HashMap<String, UsbDevice> fondUsbDevices = new HashMap<String, UsbDevice>();
            for (UsbDevice usbDevice : myUsbDevices) {
                try {
                    String usbDeviceString = usbDevice.getProductString() + " S/N " + usbDevice.getSerialNumberString();
                    fondUsbDevices.put(usbDeviceString, usbDevice);
                }
                catch (UnsupportedEncodingException | UsbDisconnectedException | UsbException e) {
                    e.printStackTrace();
                }
            }
            UsbDevice selUsbDevice = null;
            if (fondUsbDevices.size() > 1 && selUsbDevice == null) {
                selUsbDevice = (UsbDevice)new UsbDeviceSelectionDialog(fondUsbDevices).open();
                usbInterface = this.claimUsbInterface(selUsbDevice, ifaceId);
            } else if (fondUsbDevices.size() > 1 && selUsbDevice != null) {
                usbInterface = this.claimUsbInterface(selUsbDevice, ifaceId);
            } else {
                throw new UsbException(String.format("%s\n===>>>  %s", Messages.getString("GDE_MSGE0050"), activeDevice.getUsbProductString()));
            }
        }
        if (usbInterface == null) {
            throw new UsbException(Messages.getString("GDE_MSGE0050"));
        }
        log.log(Level.FINE, "interface claimed");
        this.isConnected = true;
        if (this.usbApplication != null) {
            this.usbApplication.setPortConnected(true);
        }
        return usbInterface;
    }

    @Override
    public synchronized DeviceHandle openLibUsbPort(IDevice activeDevice) throws LibUsbException, UsbClaimException, UsbException {
        int result;
        DeviceHandle libUsbDeviceHandle = new DeviceHandle();
        byte ifaceId = activeDevice.getUsbInterface();
        if (log.isLoggable(Level.FINE)) {
            this.dumpLibUsbDevices();
        }
        if ((result = LibUsb.init(null)) != 0) {
            throw new LibUsbException("Unable to initialize libusb", result);
        }
        Set<Device> myLibUsbDevices = this.findDevices(activeDevice.getUsbVendorId(), activeDevice.getUsbProductId(), activeDevice.getUsbProductString());
        if (myLibUsbDevices.size() == 0) {
            throw new UsbException(String.format("%s\n===>>>  %s", Messages.getString("GDE_MSGE0050"), activeDevice.getUsbProductString()));
        }
        if (myLibUsbDevices.size() == 1) {
            for (Device libUsbDevice : myLibUsbDevices) {
                this.claimLibUsbDevice(libUsbDevice, libUsbDeviceHandle, ifaceId);
            }
        } else {
            HashMap<String, Device> myUsbDevices = new HashMap<String, Device>();
            for (Device libUsbDevice : myLibUsbDevices) {
                String descriptorString;
                DeviceDescriptor descriptor;
                result = LibUsb.getDeviceDescriptor((Device)libUsbDevice, (DeviceDescriptor)(descriptor = new DeviceDescriptor()));
                if (result != 0) {
                    throw new LibUsbException("Unable to read device descriptor", result);
                }
                DeviceHandle handle = new DeviceHandle();
                result = LibUsb.open((Device)libUsbDevice, (DeviceHandle)handle);
                if (result < 0) {
                    log.log(Level.WARNING, String.format("Unable to open device: %s. Continuing without device handle.", LibUsb.strError((int)result)));
                    handle = null;
                }
                if ((descriptorString = descriptor.dump(handle)).contains("iProduct") && descriptorString.contains(activeDevice.getUsbProductString()) && descriptorString.contains("iSerial")) {
                    String usbDeviceString = LibUsb.getStringDescriptor((DeviceHandle)handle, (byte)descriptor.iProduct()) + " S/N " + LibUsb.getStringDescriptor((DeviceHandle)handle, (byte)descriptor.iSerialNumber());
                    myUsbDevices.put(usbDeviceString, libUsbDevice);
                }
                LibUsb.close((DeviceHandle)handle);
            }
            if (myUsbDevices.size() > 0 && selectedUsbDevice == null) {
                selectedUsbDevice = (Device)new LibUsbDeviceSelectionDialog(myUsbDevices).open();
                this.claimLibUsbDevice(selectedUsbDevice, libUsbDeviceHandle, ifaceId);
            } else if (myUsbDevices.size() > 0 && selectedUsbDevice != null) {
                this.claimLibUsbDevice(selectedUsbDevice, libUsbDeviceHandle, ifaceId);
            } else {
                throw new UsbException(String.format("%s\n===>>>  %s", Messages.getString("GDE_MSGE0050"), activeDevice.getUsbProductString()));
            }
        }
        log.log(Level.FINE, "interface claimed");
        this.isConnected = true;
        if (this.usbApplication != null) {
            this.usbApplication.setPortConnected(true);
        }
        return libUsbDeviceHandle;
    }

    private void claimLibUsbDevice(Device libUsbDevice, DeviceHandle libUsbDeviceHandle, byte ifaceId) throws UsbException, UsbClaimException {
        if (libUsbDevice == null) {
            throw new UsbException(Messages.getString("GDE_MSGE0050"));
        }
        int result = LibUsb.open((Device)libUsbDevice, (DeviceHandle)libUsbDeviceHandle);
        if (result < 0) {
            LibUsb.close((DeviceHandle)libUsbDeviceHandle);
            log.log(Level.SEVERE, String.format("Unable to open device: %s.", LibUsb.strError((int)result)));
            throw new UsbClaimException(new LibUsbException(result).getMessage());
        }
        if (GDE.IS_LINUX && (result = LibUsb.kernelDriverActive((DeviceHandle)libUsbDeviceHandle, (int)ifaceId)) == 1 && (result = LibUsb.detachKernelDriver((DeviceHandle)libUsbDeviceHandle, (int)ifaceId)) != 0) {
            throw new UsbClaimException(new LibUsbException(result).getMessage());
        }
        result = LibUsb.claimInterface((DeviceHandle)libUsbDeviceHandle, (int)ifaceId);
        if (result < 0) {
            LibUsb.close((DeviceHandle)libUsbDeviceHandle);
            log.log(Level.SEVERE, String.format("Unable to claim device: %s.", LibUsb.strError((int)result)));
            throw new UsbClaimException(new LibUsbException(result).getMessage());
        }
    }

    private UsbInterface claimUsbInterface(UsbDevice usbDevice, byte ifaceId) throws UsbClaimException, UsbException {
        UsbInterface usbInterface = ((UsbConfiguration)usbDevice.getUsbConfigurations().get(0)).getUsbInterface(ifaceId);
        log.log(Level.INFO, usbInterface.toString());
        if (GDE.IS_LINUX) {
            usbInterface.claim(new UsbInterfacePolicy(){

                public boolean forceClaim(UsbInterface usbInterface_) {
                    return true;
                }
            });
        } else {
            usbInterface.claim();
        }
        return usbInterface;
    }

    @Override
    public synchronized void closeUsbPort(UsbInterface usbInterface) throws UsbClaimException, UsbException {
        this.isConnected = false;
        WaitTimer.delay(200L);
        if (usbInterface != null && usbInterface.isClaimed()) {
            usbInterface.release();
            log.log(Level.FINE, "interface released");
        }
        if (this.usbApplication != null) {
            this.usbApplication.setSerialTxOff();
            this.usbApplication.setSerialRxOff();
            this.usbApplication.setPortConnected(false);
        }
    }

    @Override
    public synchronized void closeLibUsbPort(DeviceHandle usbDeviceHandle, boolean cacheSelectedUsbDevice) throws UsbClaimException, UsbException {
        this.isConnected = false;
        WaitTimer.delay(200L);
        if (usbDeviceHandle != null) {
            LibUsb.close((DeviceHandle)usbDeviceHandle);
            LibUsb.exit(null);
            log.log(Level.FINE, "interface released");
        }
        if (this.usbApplication != null) {
            this.usbApplication.setSerialTxOff();
            this.usbApplication.setSerialRxOff();
            this.usbApplication.setPortConnected(false);
            if (!cacheSelectedUsbDevice) {
                selectedUsbDevice = null;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized int write(UsbInterface iface, byte endpointAddress, byte[] data) throws UsbNotActiveException, UsbNotClaimedException, UsbDisconnectedException, UsbException {
        UsbEndpoint endpoint = iface.getUsbEndpoint(endpointAddress);
        int sent = 0;
        pipe.open();
        try (UsbPipe pipe = endpoint.getUsbPipe();){
            sent = pipe.syncSubmit(data);
            if (log.isLoggable(Level.FINE)) {
                log.log(Level.FINE, sent + " bytes sent");
            }
        }
        return sent;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized int read(UsbInterface iface, byte endpointAddress, byte[] data) throws UsbNotActiveException, UsbNotClaimedException, UsbDisconnectedException, UsbException {
        UsbEndpoint endpoint = iface.getUsbEndpoint(endpointAddress);
        int received = 0;
        pipe.open();
        try (UsbPipe pipe = endpoint.getUsbPipe();){
            received = pipe.syncSubmit(data);
            if (log.isLoggable(Level.FINE)) {
                log.log(Level.FINE, received + " bytes received");
            }
        }
        return received;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized int read(UsbInterface iface, byte endpointAddress, byte[] data, int timeout_msec) throws UsbNotActiveException, UsbNotClaimedException, UsbDisconnectedException, UsbException {
        UsbEndpoint endpoint = iface.getUsbEndpoint(endpointAddress);
        int waitDelay_msec = timeout_msec / 100;
        this.asyncReceived = 0;
        this.isAsyncReceived = false;
        UsbPipe pipe = endpoint.getUsbPipe();
        UsbPipeListener usbPipeListener = new UsbPipeListener(){

            public void errorEventOccurred(UsbPipeErrorEvent evt) {
                log.log(Level.WARNING, evt.toString());
            }

            public void dataEventOccurred(UsbPipeDataEvent evt) {
                byte[] tmpData = evt.getData();
                DeviceUsbPortImpl.this.isAsyncReceived = true;
                if (log.isLoggable(Level.FINE)) {
                    DeviceUsbPortImpl.this.asyncReceived = tmpData.length;
                    log.log(Level.FINE, DeviceUsbPortImpl.this.asyncReceived + " bytes received");
                }
            }
        };
        try {
            pipe.open();
            pipe.addUsbPipeListener(usbPipeListener);
            pipe.asyncSubmit(data);
            for (int waitTime_msec = timeout_msec; this.isConnected && !this.isAsyncReceived && waitTime_msec > 0; waitTime_msec -= waitDelay_msec) {
                WaitTimer.delay(waitDelay_msec);
            }
        }
        finally {
            pipe.removeUsbPipeListener(usbPipeListener);
            if (pipe.isOpen()) {
                pipe.abortAllSubmissions();
                pipe.close();
            }
        }
        return this.asyncReceived;
    }

    @Override
    public void write(DeviceHandle handle, byte outEndpoint, byte[] data, long timeout_ms) throws IllegalStateException, TimeOutException {
        int result;
        ByteBuffer buffer = BufferUtils.allocateByteBuffer((int)data.length);
        buffer.put(data);
        IntBuffer transferred = BufferUtils.allocateIntBuffer();
        int n = result = this.endpointTransferType == 2 ? LibUsb.bulkTransfer((DeviceHandle)handle, (byte)outEndpoint, (ByteBuffer)buffer, (IntBuffer)transferred, (long)timeout_ms) : LibUsb.interruptTransfer((DeviceHandle)handle, (byte)outEndpoint, (ByteBuffer)buffer, (IntBuffer)transferred, (long)timeout_ms);
        if (result != 0) {
            switch (result) {
                case -7: {
                    throw new TimeOutException(new LibUsbException(result).getMessage());
                }
                case -4: 
                case -3: 
                case -1: {
                    throw new UsbDisconnectedException(new LibUsbException(result).getMessage());
                }
            }
            throw new IllegalStateException(new LibUsbException(result).getMessage());
        }
        if (log.isLoggable(Level.FINE)) {
            log.log(Level.FINE, transferred.get() + " bytes sent");
        }
    }

    @Override
    public int read(DeviceHandle handle, byte inEndpoint, byte[] data, long timeout_ms) throws IllegalStateException, TimeOutException {
        int result;
        int readBytes = 0;
        ByteBuffer buffer = BufferUtils.allocateByteBuffer((int)data.length).order(ByteOrder.LITTLE_ENDIAN);
        IntBuffer transferred = BufferUtils.allocateIntBuffer();
        int n = result = this.endpointTransferType == 2 ? LibUsb.bulkTransfer((DeviceHandle)handle, (byte)inEndpoint, (ByteBuffer)buffer, (IntBuffer)transferred, (long)timeout_ms) : LibUsb.interruptTransfer((DeviceHandle)handle, (byte)inEndpoint, (ByteBuffer)buffer, (IntBuffer)transferred, (long)timeout_ms);
        if (result != 0) {
            readBytes = transferred.get();
            if (readBytes == 0 || readBytes != (buffer.get(0) & 0xFF)) {
                switch (result) {
                    case -7: {
                        throw new TimeOutException(new LibUsbException(result).getMessage());
                    }
                    case -4: 
                    case -3: 
                    case -1: {
                        throw new UsbDisconnectedException(new LibUsbException(result).getMessage());
                    }
                }
                throw new IllegalStateException(new LibUsbException(result).getMessage());
            }
            buffer.get(data, 0, readBytes);
            if (log.isLoggable(Level.FINE)) {
                log.log(Level.FINE, readBytes + " bytes received");
            }
            return readBytes;
        }
        readBytes = transferred.get();
        buffer.get(data, 0, readBytes);
        if (log.isLoggable(Level.FINE)) {
            log.log(Level.FINE, readBytes + " bytes received");
        }
        return readBytes;
    }
}

