/*
 * Decompiled with CFR 0.152.
 */
package gde.device.htronic;

import gde.comm.DeviceCommPort;
import gde.device.IDevice;
import gde.exception.TimeOutException;
import gde.log.Level;
import gde.messages.Messages;
import gde.ui.DataExplorer;
import java.io.IOException;
import java.util.HashMap;
import java.util.logging.Logger;

public class AkkuMasterC4SerialPort
extends DeviceCommPort {
    static final Logger log = Logger.getLogger(AkkuMasterC4SerialPort.class.getName());
    public static final String PROCESS_NAME = Messages.getString((String)"GDE_MSGT1114");
    public static final String PROCESS_ERROR_NO = Messages.getString((String)"GDE_MSGT1115");
    public static final String PROCESS_VOLTAGE = Messages.getString((String)"GDE_MSGT1116");
    public static final String PROCESS_CURRENT = Messages.getString((String)"GDE_MSGT1117");
    public static final String PROCESS_CAPACITY = Messages.getString((String)"GDE_MSGT1118");
    public static final String PROCESS_POWER = Messages.getString((String)"GDE_MSGT1119");
    public static final String PROCESS_ENERGIE = Messages.getString((String)"GDE_MSGT1120");
    public static final String PROCESS_TIME = Messages.getString((String)"GDE_MSGT1121");
    public static final String VERSION_NUMBER = Messages.getString((String)"GDE_MSGT1122").trim();
    public static final String VERSION_DATE = Messages.getString((String)"GDE_MSGT1123").trim();
    public static final String VERSION_TYPE_CURRENT = Messages.getString((String)"GDE_MSGT1124").trim();
    public static final String VERSION_TYPE_FRONT = Messages.getString((String)"GDE_MSGT1125").trim();
    public static final byte[] channel_1 = new byte[]{0};
    public static final byte[] channel_2 = new byte[]{64};
    public static final byte[] channel_3 = new byte[]{-128};
    public static final byte[] channel_4 = new byte[]{-64};
    static final byte[] readVersion = new byte[]{22};
    static final byte[] readConfiguration = new byte[]{17};
    static final byte[] readMeasuredValues = new byte[]{18};
    static final byte[] readAdjustedValues = new byte[]{33};
    static final byte setNewProgramm = 20;
    static final byte setMomoryCycleSleep = 36;
    static final byte startProgram = 21;
    static final byte stopProgram = 19;
    static final byte okStartProgram = 25;
    byte[] version = new byte[11];
    byte[] adjustedValues = new byte[5];
    byte ok = 0;
    static final byte stateWaiting = 0;
    static final byte stateCharge = 1;
    static final byte stateDischarge = 2;
    static final byte stateKeepCharge = 4;
    static final byte stateDeviceActive = -128;
    static final byte programChargeOnly = 1;
    static final byte programDischargeOnly = 2;
    static final byte programDischargeCharge = 3;
    static final byte programChargeDischargeCharge = 4;
    static final byte programDischargeChargeTwoTimes = 5;
    static final byte programFormUp = 6;
    static final byte programOverWinter = 7;
    static final byte programRefresh = 8;
    static final byte programDiagnostic = 9;
    static final byte typeNC = 0;
    static final byte typeNiMh = 1;
    static final byte typePB = 2;

    public AkkuMasterC4SerialPort(IDevice currentDevice, DataExplorer currentApplication) {
        super(currentDevice, currentApplication);
    }

    public synchronized void ok(byte[] channel) throws IOException, TimeOutException {
        byte[] command = new byte[]{Integer.valueOf(25 + channel[0]).byteValue()};
        this.write(command);
        byte[] answer = new byte[2];
        answer = this.read(answer, 2000);
        if (answer[0] != command[0]) {
            throw new IOException(Messages.getString((String)"GDE_MSGE1100"));
        }
        if (answer[1] != this.ok) {
            throw new IOException(Messages.getString((String)"GDE_MSGE1101"));
        }
    }

    public synchronized void start(byte[] channel) throws IOException, TimeOutException {
        byte[] command = new byte[]{Integer.valueOf(21 + channel[0]).byteValue()};
        this.write(command);
        byte[] answer = new byte[2];
        answer = this.read(answer, 2000);
        if (answer[0] != command[0]) {
            throw new IOException(Messages.getString((String)"GDE_MSGE1100"));
        }
        if (answer[1] != this.ok) {
            throw new IOException(Messages.getString((String)"GDE_MSGE1102"));
        }
    }

    public synchronized void stop(byte[] channel) throws IOException, TimeOutException {
        byte[] command = new byte[]{Integer.valueOf(19 + channel[0]).byteValue()};
        this.write(command);
        byte[] answer = new byte[2];
        answer = this.read(answer, 2000);
        if (answer[0] != command[0]) {
            throw new IOException(Messages.getString((String)"GDE_MSGE1100"));
        }
        if (answer[1] != this.ok) {
            throw new IOException(Messages.getString((String)"GDE_MSGE1103"));
        }
    }

    public synchronized void writeNewProgram(byte[] channel, int programNumber, int waitTime_days, int akkuTyp, int cellCount, int akkuCapacity, int dischargeCurrent_mA, int chargeCurrent_mA) throws IOException, TimeOutException {
        byte[] command = new byte[]{Integer.valueOf(20 + channel[0]).byteValue(), Integer.valueOf(programNumber).byteValue(), Integer.valueOf(waitTime_days).byteValue(), Integer.valueOf(akkuTyp).byteValue(), Integer.valueOf(cellCount).byteValue(), Integer.valueOf(akkuCapacity >> 8 & 0xFF).byteValue(), Integer.valueOf(akkuCapacity & 0xFF).byteValue(), Integer.valueOf(dischargeCurrent_mA >> 8 & 0xFF).byteValue(), Integer.valueOf(dischargeCurrent_mA & 0xFF).byteValue(), Integer.valueOf(chargeCurrent_mA >> 8 & 0xFF).byteValue(), Integer.valueOf(chargeCurrent_mA & 0xFF).byteValue()};
        this.write(command);
        byte[] answer = new byte[2];
        answer = this.read(answer, 2000);
        if (answer[0] != command[0]) {
            throw new IOException(Messages.getString((String)"GDE_MSGE1100"));
        }
        if (answer[1] != this.ok) {
            throw new IOException(Messages.getString((String)"GDE_MSGE1104"));
        }
    }

    public synchronized void setMemoryNumberCycleCountSleepTime(byte[] channel, int memoryNumber, int cycleCount, int sleepTime_min) throws IOException, TimeOutException {
        byte[] command = new byte[]{Integer.valueOf(36 + channel[0]).byteValue(), Integer.valueOf(memoryNumber).byteValue(), Integer.valueOf(cycleCount).byteValue(), Integer.valueOf(sleepTime_min >> 8 & 0xFF).byteValue(), Integer.valueOf(sleepTime_min & 0xFF).byteValue()};
        this.write(command);
        byte[] answer = new byte[2];
        answer = this.read(answer, 2000);
        if (answer[0] != command[0]) {
            throw new IOException(Messages.getString((String)"GDE_MSGE1100"));
        }
        if (answer[1] != this.ok) {
            throw new IOException(Messages.getString((String)"GDE_MSGE1105"));
        }
    }

    public synchronized HashMap<String, Object> getData(byte[] channelSignature) throws Exception {
        boolean isPortOpenedByMe = false;
        try {
            if (!this.isConnected()) {
                this.open();
                isPortOpenedByMe = true;
            }
            HashMap<String, Object> values = new HashMap<String, Object>(7);
            HashMap<String, Object> hashMap = AkkuMasterC4SerialPort.getConvertedValues(values, this.getConfiguration(channelSignature), this.getMeasuredValues(channelSignature));
            return hashMap;
        }
        catch (Exception e) {
            log.log(Level.SEVERE, e.getMessage(), e);
            throw e;
        }
        finally {
            if (isPortOpenedByMe) {
                this.close();
            }
        }
    }

    public static HashMap<String, Object> getConvertedValues(HashMap<String, Object> values, String[] currentConfiguration, String[] currentMeasurements) {
        boolean isActive = true;
        values.put(PROCESS_NAME, currentConfiguration[0].split(" ")[0]);
        values.put(PROCESS_ERROR_NO, Integer.valueOf(currentConfiguration[1].split(" ")[0]));
        values.put(PROCESS_VOLTAGE, Integer.valueOf(currentMeasurements[2].split(" ")[0]));
        switch (Integer.valueOf(currentConfiguration[0].split(" ")[0])) {
            case 1: {
                values.put(PROCESS_NAME, currentConfiguration[0].split(" ")[0] + Messages.getString((String)"GDE_MSGT1126"));
                values.put(PROCESS_CURRENT, Integer.valueOf(currentConfiguration[7].split(" ")[0]));
                values.put(PROCESS_CAPACITY, Integer.valueOf(currentMeasurements[1].split(" ")[0]));
                break;
            }
            case 2: {
                values.put(PROCESS_NAME, currentConfiguration[0].split(" ")[0] + Messages.getString((String)"GDE_MSGT1127"));
                values.put(PROCESS_CURRENT, Integer.valueOf(currentConfiguration[6].split(" ")[0]));
                values.put(PROCESS_CAPACITY, Integer.valueOf(currentMeasurements[0].split(" ")[0]));
                break;
            }
            case 3: {
                values.put(PROCESS_NAME, currentConfiguration[0].split(" ")[0] + Messages.getString((String)"GDE_MSGT1128"));
                values.put(PROCESS_CAPACITY, Integer.valueOf("0"));
                break;
            }
            default: {
                isActive = false;
                values.put(PROCESS_NAME, currentConfiguration[0].split(" ")[0] + Messages.getString((String)"GDE_MSGT1129"));
                values.put(PROCESS_CAPACITY, 0);
            }
        }
        if (isActive) {
            int voltage = (Integer)values.get(PROCESS_VOLTAGE);
            values.put(PROCESS_POWER, voltage * (Integer)values.get(PROCESS_CURRENT));
            values.put(PROCESS_ENERGIE, voltage * (Integer)values.get(PROCESS_CAPACITY));
        }
        return values;
    }

    public synchronized String[] getConfiguration(byte[] channel) throws IOException, TimeOutException {
        byte[] readConfigOfChannel = new byte[1];
        byte a = readConfiguration[0];
        byte b = channel[0];
        readConfigOfChannel[0] = Integer.valueOf(a + b).byteValue();
        this.write(readConfigOfChannel);
        byte[] configuration = new byte[14];
        configuration = this.read(configuration, 2000);
        if (configuration[0] != readConfigOfChannel[0]) {
            throw new IOException(Messages.getString((String)"GDE_MSGE1100"));
        }
        return AkkuMasterC4SerialPort.convertConfigurationAnswer(configuration);
    }

    public static String[] convertConfigurationAnswer(byte[] configurationDataBytes) {
        String[] configStrings = new String[9];
        byte state = (byte)(configurationDataBytes[1] - -128);
        configStrings[0] = state == 0 ? Messages.getString((String)"GDE_MSGT1130") : (state == 1 ? Messages.getString((String)"GDE_MSGT1131") : (state == 2 ? Messages.getString((String)"GDE_MSGT1132") : (state == 4 ? Messages.getString((String)"GDE_MSGT1133") : Messages.getString((String)"GDE_MSGT1134"))));
        configStrings[1] = Messages.getString((String)"GDE_MSGT1135", (Object[])new Object[]{configurationDataBytes[2]});
        byte program = configurationDataBytes[3];
        configStrings[2] = program == 1 ? Messages.getString((String)"GDE_MSGT1136") : (program == 2 ? Messages.getString((String)"GDE_MSGT1137") : (program == 3 ? Messages.getString((String)"GDE_MSGT1138") : (program == 4 ? Messages.getString((String)"GDE_MSGT1139") : (program == 5 ? Messages.getString((String)"GDE_MSGT1140") : (program == 6 ? Messages.getString((String)"GDE_MSGT1141") : (program == 7 ? Messages.getString((String)"GDE_MSGT1142") : (program == 8 ? Messages.getString((String)"GDE_MSGT1143") : (program == 9 ? Messages.getString((String)"GDE_MSGT1144") : Messages.getString((String)"GDE_MSGT0279")))))))));
        byte accuTyp = configurationDataBytes[4];
        configStrings[3] = accuTyp == 0 ? Messages.getString((String)"GDE_MSGT1145") : (accuTyp == 1 ? Messages.getString((String)"GDE_MSGT1146") : (accuTyp == 2 ? Messages.getString((String)"GDE_MSGT1147") : Messages.getString((String)"GDE_MSGT0279")));
        configStrings[4] = configurationDataBytes[5] + Messages.getString((String)"GDE_MSGT1148");
        int accuCapacity = (configurationDataBytes[6] & 0xFF) << 8;
        configStrings[5] = (accuCapacity += (configurationDataBytes[7] & 0xFF) << 0) + Messages.getString((String)"GDE_MSGT1149");
        int current = (configurationDataBytes[8] & 0xFF) << 8;
        configStrings[6] = (current += (configurationDataBytes[9] & 0xFF) << 0) + Messages.getString((String)"GDE_MSGT1150");
        current = (configurationDataBytes[10] & 0xFF) << 8;
        configStrings[7] = (current += (configurationDataBytes[11] & 0xFF) << 0) + Messages.getString((String)"GDE_MSGT1151");
        int latencyTime = (configurationDataBytes[12] & 0xFF) << 8;
        configStrings[8] = (latencyTime += (configurationDataBytes[13] & 0xFF) << 0) + Messages.getString((String)"GDE_MSGT1152");
        return configStrings;
    }

    public synchronized String[] getAdjustedValues(byte[] channel) throws IOException, TimeOutException {
        String[] adjustments = new String[3];
        byte[] readAdjustmentsOfChannel = new byte[1];
        byte a = readAdjustedValues[0];
        byte b = channel[0];
        readAdjustmentsOfChannel[0] = Integer.valueOf(a + b).byteValue();
        this.write(readAdjustmentsOfChannel);
        this.adjustedValues = this.read(this.adjustedValues, 2000);
        if (this.adjustedValues[0] != readAdjustmentsOfChannel[0]) {
            throw new IOException(Messages.getString((String)"GDE_MSGE1100"));
        }
        adjustments[0] = this.adjustedValues[1] + Messages.getString((String)"GDE_MSGT1153");
        adjustments[1] = this.adjustedValues[2] + Messages.getString((String)"GDE_MSGT1154");
        int current = (this.adjustedValues[3] & 0xFF) << 8;
        adjustments[2] = (current += (this.adjustedValues[4] & 0xFF) << 0) + Messages.getString((String)"GDE_MSGT1155");
        return adjustments;
    }

    public synchronized String[] getMeasuredValues(byte[] channel) throws IOException, TimeOutException {
        byte[] readValuesOfChannel = new byte[1];
        byte a = readMeasuredValues[0];
        byte b = channel[0];
        readValuesOfChannel[0] = Integer.valueOf(a + b).byteValue();
        this.write(readValuesOfChannel);
        byte[] measuredValues = new byte[16];
        measuredValues = this.read(measuredValues, 2000);
        if (measuredValues[0] != readValuesOfChannel[0]) {
            throw new IOException(Messages.getString((String)"GDE_MSGE1100"));
        }
        return AkkuMasterC4SerialPort.convertMeasurementValues(measuredValues);
    }

    public static String[] convertMeasurementValues(byte[] measuredValuesDataBytes) {
        String[] measurements = new String[11];
        int current = (measuredValuesDataBytes[1] & 0xFF) << 8;
        measurements[0] = (current += (measuredValuesDataBytes[2] & 0xFF) << 0) + Messages.getString((String)"GDE_MSGT1156");
        current = (measuredValuesDataBytes[3] & 0xFF) << 8;
        measurements[1] = (current += (measuredValuesDataBytes[4] & 0xFF) << 0) + Messages.getString((String)"GDE_MSGT1157");
        int voltage = (measuredValuesDataBytes[5] & 0xFF) << 8;
        measurements[2] = (voltage += (measuredValuesDataBytes[6] & 0xFF) << 0) * 10 / 2 + Messages.getString((String)"GDE_MSGT1158");
        measurements[3] = measuredValuesDataBytes[7] + Messages.getString((String)"GDE_MSGT1159");
        measurements[4] = measuredValuesDataBytes[8] + Messages.getString((String)"GDE_MSGT1160");
        measurements[5] = measuredValuesDataBytes[9] + Messages.getString((String)"GDE_MSGT1161");
        measurements[6] = measuredValuesDataBytes[10] + Messages.getString((String)"GDE_MSGT1162");
        measurements[7] = measuredValuesDataBytes[11] + Messages.getString((String)"GDE_MSGT1163");
        measurements[8] = measuredValuesDataBytes[12] + Messages.getString((String)"GDE_MSGT1164");
        measurements[9] = measuredValuesDataBytes[13] + Messages.getString((String)"GDE_MSGT1165");
        int latencyCycleTime = (measuredValuesDataBytes[14] & 0xFF) << 8;
        measurements[10] = (latencyCycleTime += (measuredValuesDataBytes[15] & 0xFF) << 0) + Messages.getString((String)"GDE_MSGT1166");
        return measurements;
    }

    public synchronized HashMap<String, String> getVersion() throws Throwable {
        HashMap<String, String> result = new HashMap<String, String>(4);
        try {
            if (!this.isConnected()) {
                this.open();
            }
            this.write(readVersion);
            this.version = this.read(this.version, 2000);
            String versionsNummer = Integer.valueOf(this.version[1]).toString();
            String versionsIndex = Integer.valueOf(this.version[2]).toString();
            result.put(VERSION_NUMBER, versionsNummer + "." + versionsIndex);
            String day = Integer.valueOf(this.version[3]).toString();
            String month = Integer.valueOf(this.version[4]).toString();
            int iYear = (this.version[5] & 0xFF) << 8;
            String year = Integer.valueOf(iYear += (this.version[6] & 0xFF) << 0).toString();
            result.put(VERSION_DATE, day + "." + month + "." + year);
            if (this.version[7] == 0) {
                result.put(VERSION_TYPE_CURRENT, Messages.getString((String)"GDE_MSGT1167"));
            } else if (this.version[7] == 1) {
                result.put(VERSION_TYPE_CURRENT, Messages.getString((String)"GDE_MSGT1168"));
            } else {
                result.put(VERSION_TYPE_CURRENT, Messages.getString((String)"GDE_MSGT1169"));
            }
            if (this.version[8] == 0) {
                result.put(VERSION_TYPE_FRONT, Messages.getString((String)"GDE_MSGT1170"));
            } else if (this.version[8] == 1) {
                result.put(VERSION_TYPE_FRONT, Messages.getString((String)"GDE_MSGT1171"));
            } else {
                result.put(VERSION_TYPE_FRONT, Messages.getString((String)"GDE_MSGT1172"));
            }
        }
        catch (Throwable e) {
            log.log(Level.SEVERE, e.getMessage(), e);
            throw e;
        }
        return result;
    }

    public void print(String[] array) {
        for (String string : array) {
            if (string != null) {
                log.log(Level.FINE, string);
                continue;
            }
            log.log(Level.FINE, "no data");
        }
    }
}

