/*
 * Decompiled with CFR 0.152.
 */
package gde.device.graupner;

import java.util.Locale;
import java.util.Vector;
import java.util.logging.Logger;

public class PackageLoss
extends Vector<Integer> {
    private static final long serialVersionUID = -1434896150654661385L;
    static final Logger log = Logger.getLogger(PackageLoss.class.getSimpleName());
    int lossTotal = 0;
    int minValue = 0;
    int maxValue = 0;
    double avgValue = 0.0;
    double sigmaValue = 0.0;
    int numberTrackedSamples = 0;
    double percentage = 100.0;

    @Override
    public synchronized boolean add(Integer value) {
        if (super.size() == 0) {
            this.minValue = this.maxValue = value.intValue();
        } else if (value > this.maxValue) {
            this.maxValue = value;
        } else if (value < this.minValue) {
            this.minValue = value;
        }
        this.lossTotal += value.intValue();
        return super.add(value);
    }

    public int getLossTotal() {
        return this.lossTotal;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized double getAvgValue() {
        PackageLoss packageLoss = this;
        synchronized (packageLoss) {
            if (this.size() >= 2) {
                long sum = 0L;
                int zeroCount = 0;
                for (Integer xi : this) {
                    if (xi != 0) {
                        sum += (long)xi.intValue();
                        continue;
                    }
                    ++zeroCount;
                }
                this.avgValue = this.size() - zeroCount > 0 ? (double)Long.valueOf(sum / (long)(this.size() - zeroCount)).intValue() : 0.0;
            }
        }
        return this.avgValue;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized double getSigmaValue() {
        PackageLoss packageLoss = this;
        synchronized (packageLoss) {
            if (super.size() >= 2) {
                double average = this.getAvgValue() / 1000.0;
                double sumPoweredValues = 0.0;
                for (Integer xi : this) {
                    sumPoweredValues += Math.pow((double)xi.intValue() / 1000.0 - average, 2.0);
                }
                this.sigmaValue = Math.sqrt(sumPoweredValues / (double)(this.size() - 1)) * 1000.0;
            }
        }
        return this.sigmaValue;
    }

    public synchronized int getMinValue() {
        return this.minValue;
    }

    public synchronized int getMaxValue() {
        return this.maxValue;
    }

    public String getStatistics() {
        if (this.getMinValue() == this.getMaxValue()) {
            return " - ";
        }
        return String.format(Locale.getDefault(), "min=%.2f sec; max=%.2f sec; avg=%.2f sec; sigma=%.2f sec", (double)this.getMinValue() / 100.0, (double)this.getMaxValue() / 100.0, this.getAvgValue() / 100.0, this.getSigmaValue() / 100.0);
    }
}

