/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.math3.linear;

import org.apache.commons.math3.exception.DimensionMismatchException;
import org.apache.commons.math3.exception.MaxCountExceededException;
import org.apache.commons.math3.exception.NullArgumentException;
import org.apache.commons.math3.exception.util.ExceptionContext;
import org.apache.commons.math3.linear.ArrayRealVector;
import org.apache.commons.math3.linear.DefaultIterativeLinearSolverEvent;
import org.apache.commons.math3.linear.IllConditionedOperatorException;
import org.apache.commons.math3.linear.NonPositiveDefiniteOperatorException;
import org.apache.commons.math3.linear.NonSelfAdjointOperatorException;
import org.apache.commons.math3.linear.NonSquareOperatorException;
import org.apache.commons.math3.linear.PreconditionedIterativeLinearSolver;
import org.apache.commons.math3.linear.RealLinearOperator;
import org.apache.commons.math3.linear.RealVector;
import org.apache.commons.math3.linear.SingularOperatorException;
import org.apache.commons.math3.util.FastMath;
import org.apache.commons.math3.util.IterationManager;
import org.apache.commons.math3.util.MathUtils;

public class SymmLQ
extends PreconditionedIterativeLinearSolver {
    private static final String OPERATOR = "operator";
    private static final String THRESHOLD = "threshold";
    private static final String VECTOR = "vector";
    private static final String VECTOR1 = "vector1";
    private static final String VECTOR2 = "vector2";
    private final boolean check;
    private final double delta;

    public SymmLQ(int maxIterations, double delta, boolean check) {
        super(maxIterations);
        this.delta = delta;
        this.check = check;
    }

    public SymmLQ(IterationManager manager, double delta, boolean check) {
        super(manager);
        this.delta = delta;
        this.check = check;
    }

    public final boolean getCheck() {
        return this.check;
    }

    public RealVector solve(RealLinearOperator a2, RealLinearOperator m2, RealVector b2) throws NullArgumentException, NonSquareOperatorException, DimensionMismatchException, MaxCountExceededException, NonSelfAdjointOperatorException, NonPositiveDefiniteOperatorException, IllConditionedOperatorException {
        MathUtils.checkNotNull(a2);
        ArrayRealVector x2 = new ArrayRealVector(a2.getColumnDimension());
        return this.solveInPlace(a2, m2, b2, x2, false, 0.0);
    }

    public RealVector solve(RealLinearOperator a2, RealLinearOperator m2, RealVector b2, boolean goodb, double shift) throws NullArgumentException, NonSquareOperatorException, DimensionMismatchException, MaxCountExceededException, NonSelfAdjointOperatorException, NonPositiveDefiniteOperatorException, IllConditionedOperatorException {
        MathUtils.checkNotNull(a2);
        ArrayRealVector x2 = new ArrayRealVector(a2.getColumnDimension());
        return this.solveInPlace(a2, m2, b2, x2, goodb, shift);
    }

    public RealVector solve(RealLinearOperator a2, RealLinearOperator m2, RealVector b2, RealVector x2) throws NullArgumentException, NonSquareOperatorException, DimensionMismatchException, NonSelfAdjointOperatorException, NonPositiveDefiniteOperatorException, IllConditionedOperatorException, MaxCountExceededException {
        MathUtils.checkNotNull(x2);
        return this.solveInPlace(a2, m2, b2, x2.copy(), false, 0.0);
    }

    public RealVector solve(RealLinearOperator a2, RealVector b2) throws NullArgumentException, NonSquareOperatorException, DimensionMismatchException, NonSelfAdjointOperatorException, IllConditionedOperatorException, MaxCountExceededException {
        MathUtils.checkNotNull(a2);
        ArrayRealVector x2 = new ArrayRealVector(a2.getColumnDimension());
        ((RealVector)x2).set(0.0);
        return this.solveInPlace(a2, null, b2, x2, false, 0.0);
    }

    public RealVector solve(RealLinearOperator a2, RealVector b2, boolean goodb, double shift) throws NullArgumentException, NonSquareOperatorException, DimensionMismatchException, NonSelfAdjointOperatorException, IllConditionedOperatorException, MaxCountExceededException {
        MathUtils.checkNotNull(a2);
        ArrayRealVector x2 = new ArrayRealVector(a2.getColumnDimension());
        return this.solveInPlace(a2, null, b2, x2, goodb, shift);
    }

    public RealVector solve(RealLinearOperator a2, RealVector b2, RealVector x2) throws NullArgumentException, NonSquareOperatorException, DimensionMismatchException, NonSelfAdjointOperatorException, IllConditionedOperatorException, MaxCountExceededException {
        MathUtils.checkNotNull(x2);
        return this.solveInPlace(a2, null, b2, x2.copy(), false, 0.0);
    }

    public RealVector solveInPlace(RealLinearOperator a2, RealLinearOperator m2, RealVector b2, RealVector x2) throws NullArgumentException, NonSquareOperatorException, DimensionMismatchException, NonSelfAdjointOperatorException, NonPositiveDefiniteOperatorException, IllConditionedOperatorException, MaxCountExceededException {
        return this.solveInPlace(a2, m2, b2, x2, false, 0.0);
    }

    public RealVector solveInPlace(RealLinearOperator a2, RealLinearOperator m2, RealVector b2, RealVector x2, boolean goodb, double shift) throws NullArgumentException, NonSquareOperatorException, DimensionMismatchException, NonSelfAdjointOperatorException, NonPositiveDefiniteOperatorException, IllConditionedOperatorException, MaxCountExceededException {
        SymmLQ.checkParameters(a2, m2, b2, x2);
        IterationManager manager = this.getIterationManager();
        manager.resetIterationCount();
        manager.incrementIterationCount();
        State state = new State(a2, m2, b2, goodb, shift, this.delta, this.check);
        state.init();
        state.refineSolution(x2);
        DefaultIterativeLinearSolverEvent event = new DefaultIterativeLinearSolverEvent(this, manager.getIterations(), x2, b2, state.getNormOfResidual());
        if (state.bEqualsNullVector()) {
            manager.fireTerminationEvent(event);
            return x2;
        }
        boolean earlyStop = state.betaEqualsZero() || state.hasConverged();
        manager.fireInitializationEvent(event);
        if (!earlyStop) {
            do {
                manager.incrementIterationCount();
                event = new DefaultIterativeLinearSolverEvent(this, manager.getIterations(), x2, b2, state.getNormOfResidual());
                manager.fireIterationStartedEvent(event);
                state.update();
                state.refineSolution(x2);
                event = new DefaultIterativeLinearSolverEvent(this, manager.getIterations(), x2, b2, state.getNormOfResidual());
                manager.fireIterationPerformedEvent(event);
            } while (!state.hasConverged());
        }
        event = new DefaultIterativeLinearSolverEvent(this, manager.getIterations(), x2, b2, state.getNormOfResidual());
        manager.fireTerminationEvent(event);
        return x2;
    }

    public RealVector solveInPlace(RealLinearOperator a2, RealVector b2, RealVector x2) throws NullArgumentException, NonSquareOperatorException, DimensionMismatchException, NonSelfAdjointOperatorException, IllConditionedOperatorException, MaxCountExceededException {
        return this.solveInPlace(a2, null, b2, x2, false, 0.0);
    }

    private static class State {
        static final double CBRT_MACH_PREC;
        static final double MACH_PREC;
        private final RealLinearOperator a;
        private final RealVector b;
        private final boolean check;
        private final double delta;
        private double beta;
        private double beta1;
        private double bstep;
        private double cgnorm;
        private double dbar;
        private double gammaZeta;
        private double gbar;
        private double gmax;
        private double gmin;
        private final boolean goodb;
        private boolean hasConverged;
        private double lqnorm;
        private final RealLinearOperator m;
        private double minusEpsZeta;
        private final RealVector mb;
        private double oldb;
        private RealVector r1;
        private RealVector r2;
        private double rnorm;
        private final double shift;
        private double snprod;
        private double tnorm;
        private RealVector wbar;
        private final RealVector xL;
        private RealVector y;
        private double ynorm2;
        private boolean bIsNull;

        State(RealLinearOperator a2, RealLinearOperator m2, RealVector b2, boolean goodb, double shift, double delta, boolean check) {
            this.a = a2;
            this.m = m2;
            this.b = b2;
            this.xL = new ArrayRealVector(b2.getDimension());
            this.goodb = goodb;
            this.shift = shift;
            this.mb = m2 == null ? b2 : m2.operate(b2);
            this.hasConverged = false;
            this.check = check;
            this.delta = delta;
        }

        private static void checkSymmetry(RealLinearOperator l2, RealVector x2, RealVector y2, RealVector z2) throws NonSelfAdjointOperatorException {
            double s2 = y2.dotProduct(y2);
            double t2 = x2.dotProduct(z2);
            double epsa = (s2 + MACH_PREC) * CBRT_MACH_PREC;
            if (FastMath.abs(s2 - t2) > epsa) {
                NonSelfAdjointOperatorException e2 = new NonSelfAdjointOperatorException();
                ExceptionContext context = e2.getContext();
                context.setValue(SymmLQ.OPERATOR, l2);
                context.setValue(SymmLQ.VECTOR1, x2);
                context.setValue(SymmLQ.VECTOR2, y2);
                context.setValue(SymmLQ.THRESHOLD, epsa);
                throw e2;
            }
        }

        private static void throwNPDLOException(RealLinearOperator l2, RealVector v2) throws NonPositiveDefiniteOperatorException {
            NonPositiveDefiniteOperatorException e2 = new NonPositiveDefiniteOperatorException();
            ExceptionContext context = e2.getContext();
            context.setValue(SymmLQ.OPERATOR, l2);
            context.setValue(SymmLQ.VECTOR, v2);
            throw e2;
        }

        private static void daxpy(double a2, RealVector x2, RealVector y2) {
            int n2 = x2.getDimension();
            for (int i2 = 0; i2 < n2; ++i2) {
                y2.setEntry(i2, a2 * x2.getEntry(i2) + y2.getEntry(i2));
            }
        }

        private static void daxpbypz(double a2, RealVector x2, double b2, RealVector y2, RealVector z2) {
            int n2 = z2.getDimension();
            for (int i2 = 0; i2 < n2; ++i2) {
                double zi = a2 * x2.getEntry(i2) + b2 * y2.getEntry(i2) + z2.getEntry(i2);
                z2.setEntry(i2, zi);
            }
        }

        void refineSolution(RealVector x2) {
            int n2 = this.xL.getDimension();
            if (this.lqnorm < this.cgnorm) {
                if (!this.goodb) {
                    x2.setSubVector(0, this.xL);
                } else {
                    double step = this.bstep / this.beta1;
                    for (int i2 = 0; i2 < n2; ++i2) {
                        double bi = this.mb.getEntry(i2);
                        double xi = this.xL.getEntry(i2);
                        x2.setEntry(i2, xi + step * bi);
                    }
                }
            } else {
                double anorm = FastMath.sqrt(this.tnorm);
                double diag = this.gbar == 0.0 ? anorm * MACH_PREC : this.gbar;
                double zbar = this.gammaZeta / diag;
                double step = (this.bstep + this.snprod * zbar) / this.beta1;
                if (!this.goodb) {
                    for (int i3 = 0; i3 < n2; ++i3) {
                        double xi = this.xL.getEntry(i3);
                        double wi = this.wbar.getEntry(i3);
                        x2.setEntry(i3, xi + zbar * wi);
                    }
                } else {
                    for (int i4 = 0; i4 < n2; ++i4) {
                        double xi = this.xL.getEntry(i4);
                        double wi = this.wbar.getEntry(i4);
                        double bi = this.mb.getEntry(i4);
                        x2.setEntry(i4, xi + zbar * wi + step * bi);
                    }
                }
            }
        }

        void init() {
            this.xL.set(0.0);
            this.r1 = this.b.copy();
            RealVector realVector = this.y = this.m == null ? this.b.copy() : this.m.operate(this.r1);
            if (this.m != null && this.check) {
                State.checkSymmetry(this.m, this.r1, this.y, this.m.operate(this.y));
            }
            this.beta1 = this.r1.dotProduct(this.y);
            if (this.beta1 < 0.0) {
                State.throwNPDLOException(this.m, this.y);
            }
            if (this.beta1 == 0.0) {
                this.bIsNull = true;
                return;
            }
            this.bIsNull = false;
            this.beta1 = FastMath.sqrt(this.beta1);
            RealVector v2 = this.y.mapMultiply(1.0 / this.beta1);
            this.y = this.a.operate(v2);
            if (this.check) {
                State.checkSymmetry(this.a, v2, this.y, this.a.operate(this.y));
            }
            State.daxpy(-this.shift, v2, this.y);
            double alpha = v2.dotProduct(this.y);
            State.daxpy(-alpha / this.beta1, this.r1, this.y);
            double vty = v2.dotProduct(this.y);
            double vtv = v2.dotProduct(v2);
            State.daxpy(-vty / vtv, v2, this.y);
            this.r2 = this.y.copy();
            if (this.m != null) {
                this.y = this.m.operate(this.r2);
            }
            this.oldb = this.beta1;
            this.beta = this.r2.dotProduct(this.y);
            if (this.beta < 0.0) {
                State.throwNPDLOException(this.m, this.y);
            }
            this.beta = FastMath.sqrt(this.beta);
            this.cgnorm = this.beta1;
            this.gbar = alpha;
            this.dbar = this.beta;
            this.gammaZeta = this.beta1;
            this.minusEpsZeta = 0.0;
            this.bstep = 0.0;
            this.snprod = 1.0;
            this.tnorm = alpha * alpha + this.beta * this.beta;
            this.ynorm2 = 0.0;
            this.gmin = this.gmax = FastMath.abs(alpha) + MACH_PREC;
            if (this.goodb) {
                this.wbar = new ArrayRealVector(this.a.getRowDimension());
                this.wbar.set(0.0);
            } else {
                this.wbar = v2;
            }
            this.updateNorms();
        }

        void update() {
            RealVector v2 = this.y.mapMultiply(1.0 / this.beta);
            this.y = this.a.operate(v2);
            State.daxpbypz(-this.shift, v2, -this.beta / this.oldb, this.r1, this.y);
            double alpha = v2.dotProduct(this.y);
            State.daxpy(-alpha / this.beta, this.r2, this.y);
            this.r1 = this.r2;
            this.r2 = this.y;
            if (this.m != null) {
                this.y = this.m.operate(this.r2);
            }
            this.oldb = this.beta;
            this.beta = this.r2.dotProduct(this.y);
            if (this.beta < 0.0) {
                State.throwNPDLOException(this.m, this.y);
            }
            this.beta = FastMath.sqrt(this.beta);
            this.tnorm += alpha * alpha + this.oldb * this.oldb + this.beta * this.beta;
            double gamma = FastMath.sqrt(this.gbar * this.gbar + this.oldb * this.oldb);
            double c2 = this.gbar / gamma;
            double s2 = this.oldb / gamma;
            double deltak = c2 * this.dbar + s2 * alpha;
            this.gbar = s2 * this.dbar - c2 * alpha;
            double eps = s2 * this.beta;
            this.dbar = -c2 * this.beta;
            double zeta = this.gammaZeta / gamma;
            double zetaC = zeta * c2;
            double zetaS = zeta * s2;
            int n2 = this.xL.getDimension();
            for (int i2 = 0; i2 < n2; ++i2) {
                double xi = this.xL.getEntry(i2);
                double vi = v2.getEntry(i2);
                double wi = this.wbar.getEntry(i2);
                this.xL.setEntry(i2, xi + wi * zetaC + vi * zetaS);
                this.wbar.setEntry(i2, wi * s2 - vi * c2);
            }
            this.bstep += this.snprod * c2 * zeta;
            this.snprod *= s2;
            this.gmax = FastMath.max(this.gmax, gamma);
            this.gmin = FastMath.min(this.gmin, gamma);
            this.ynorm2 += zeta * zeta;
            this.gammaZeta = this.minusEpsZeta - deltak * zeta;
            this.minusEpsZeta = -eps * zeta;
            this.updateNorms();
        }

        private void updateNorms() {
            double anorm = FastMath.sqrt(this.tnorm);
            double ynorm = FastMath.sqrt(this.ynorm2);
            double epsa = anorm * MACH_PREC;
            double epsx = anorm * ynorm * MACH_PREC;
            double epsr = anorm * ynorm * this.delta;
            double diag = this.gbar == 0.0 ? epsa : this.gbar;
            this.lqnorm = FastMath.sqrt(this.gammaZeta * this.gammaZeta + this.minusEpsZeta * this.minusEpsZeta);
            double qrnorm = this.snprod * this.beta1;
            this.cgnorm = qrnorm * this.beta / FastMath.abs(diag);
            double acond = this.lqnorm <= this.cgnorm ? this.gmax / this.gmin : this.gmax / FastMath.min(this.gmin, FastMath.abs(diag));
            if (acond * MACH_PREC >= 0.1) {
                throw new IllConditionedOperatorException(acond);
            }
            if (this.beta1 <= epsx) {
                throw new SingularOperatorException();
            }
            this.rnorm = FastMath.min(this.cgnorm, this.lqnorm);
            this.hasConverged = this.cgnorm <= epsx || this.cgnorm <= epsr;
        }

        boolean hasConverged() {
            return this.hasConverged;
        }

        boolean bEqualsNullVector() {
            return this.bIsNull;
        }

        boolean betaEqualsZero() {
            return this.beta < MACH_PREC;
        }

        double getNormOfResidual() {
            return this.rnorm;
        }

        static {
            MACH_PREC = FastMath.ulp(1.0);
            CBRT_MACH_PREC = FastMath.cbrt(MACH_PREC);
        }
    }
}

