/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.graphics;

public class LineAttributes {
    public float width;
    public int style;
    public int cap;
    public int join;
    public float[] dash;
    public float dashOffset;
    public float miterLimit;

    public LineAttributes(float width) {
        this(width, 1, 1, 1, null, 0.0f, 10.0f);
    }

    public LineAttributes(float width, int cap, int join) {
        this(width, cap, join, 1, null, 0.0f, 10.0f);
    }

    public LineAttributes(float width, int cap, int join, int style, float[] dash, float dashOffset, float miterLimit) {
        this.width = width;
        this.cap = cap;
        this.join = join;
        this.style = style;
        this.dash = dash;
        this.dashOffset = dashOffset;
        this.miterLimit = miterLimit;
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof LineAttributes)) {
            return false;
        }
        LineAttributes p2 = (LineAttributes)object;
        if (p2.width != this.width) {
            return false;
        }
        if (p2.cap != this.cap) {
            return false;
        }
        if (p2.join != this.join) {
            return false;
        }
        if (p2.style != this.style) {
            return false;
        }
        if (p2.dashOffset != this.dashOffset) {
            return false;
        }
        if (p2.miterLimit != this.miterLimit) {
            return false;
        }
        if (p2.dash != null && this.dash != null) {
            if (p2.dash.length != this.dash.length) {
                return false;
            }
            int i2 = 0;
            while (i2 < this.dash.length) {
                if (p2.dash[i2] != this.dash[i2]) {
                    return false;
                }
                ++i2;
            }
        } else if (p2.dash != null || this.dash != null) {
            return false;
        }
        return true;
    }

    public int hashCode() {
        int hashCode2 = Float.floatToIntBits(this.width);
        hashCode2 = 31 * hashCode2 + this.cap;
        hashCode2 = 31 * hashCode2 + this.join;
        hashCode2 = 31 * hashCode2 + this.style;
        hashCode2 = 31 * hashCode2 + Float.floatToIntBits(this.dashOffset);
        hashCode2 = 31 * hashCode2 + Float.floatToIntBits(this.miterLimit);
        if (this.dash != null) {
            int i2 = 0;
            while (i2 < this.dash.length) {
                hashCode2 = 31 * hashCode2 + Float.floatToIntBits(this.dash[i2]);
                ++i2;
            }
        }
        return hashCode2;
    }
}

