/*
 * Decompiled with CFR 0.152.
 */
package org.xhtmlrenderer.swing;

import java.awt.Point;
import java.awt.Rectangle;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.StringSelection;
import java.awt.event.ActionEvent;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.text.StringCharacterIterator;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Stack;
import java.util.logging.Level;
import javax.swing.AbstractAction;
import javax.swing.SwingUtilities;
import javax.swing.TransferHandler;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.EventListenerList;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.Text;
import org.w3c.dom.ranges.DocumentRange;
import org.w3c.dom.ranges.Range;
import org.w3c.dom.traversal.DocumentTraversal;
import org.w3c.dom.traversal.NodeFilter;
import org.w3c.dom.traversal.NodeIterator;
import org.xhtmlrenderer.css.style.CalculatedStyle;
import org.xhtmlrenderer.layout.LayoutContext;
import org.xhtmlrenderer.render.BlockBox;
import org.xhtmlrenderer.render.Box;
import org.xhtmlrenderer.render.InlineLayoutBox;
import org.xhtmlrenderer.render.InlineText;
import org.xhtmlrenderer.simple.XHTMLPanel;
import org.xhtmlrenderer.swing.ScalableXHTMLPanel;
import org.xhtmlrenderer.util.Util;
import org.xhtmlrenderer.util.XRLog;

public class SelectionHighlighter
implements MouseMotionListener,
MouseListener {
    private static final String PARA_EQUIV = "&!<p2equiv!";
    private XHTMLPanel panel;
    private ViewModelInfo dotInfo;
    private ViewModelInfo markInfo;
    protected EventListenerList listenerList = new EventListenerList();
    protected transient ChangeEvent changeEvent = null;
    private DocumentRange docRange;
    private Range lastSelectionRange = null;
    private DocumentTraversal docTraversal;
    private Map elementBoxMap;
    private Map textInlineMap;
    private String lastHighlightedString = "";
    private TransferHandler handler;
    private Document document;
    public static final String copyAction = "Copy";

    public void addChangeListener(ChangeListener l2) {
        this.listenerList.add(ChangeListener.class, l2);
    }

    public void removeChangeListener(ChangeListener l2) {
        this.listenerList.remove(ChangeListener.class, l2);
    }

    protected void fireStateChanged() {
        Object[] listeners = this.listenerList.getListenerList();
        for (int i2 = listeners.length - 2; i2 >= 0; i2 -= 2) {
            if (listeners[i2] != ChangeListener.class) continue;
            if (this.changeEvent == null) {
                this.changeEvent = new ChangeEvent(this);
            }
            ((ChangeListener)listeners[i2 + 1]).stateChanged(this.changeEvent);
        }
    }

    public void install(XHTMLPanel panel) {
        this.panel = panel;
        if (!this.checkDocument()) {
            return;
        }
        panel.setTransferHandler(this.handler);
        panel.addMouseListener(this);
        panel.addMouseMotionListener(this);
    }

    public void deinstall(XHTMLPanel panel) {
        if (panel.getTransferHandler() == this.handler) {
            panel.setTransferHandler(null);
        }
        panel.removeMouseListener(this);
        panel.removeMouseMotionListener(this);
    }

    private boolean checkDocument() {
        if (this.document != this.panel.getDocument() || this.textInlineMap == null) {
            this.document = this.panel.getDocument();
            this.textInlineMap = null;
            this.dotInfo = null;
            this.markInfo = null;
            this.lastSelectionRange = null;
            try {
                this.docRange = (DocumentRange)((Object)this.panel.getDocument());
                this.docTraversal = (DocumentTraversal)((Object)this.panel.getDocument());
                if (this.document != null && this.createMaps()) {
                    return true;
                }
                try {
                    Thread.sleep(10L);
                }
                catch (InterruptedException e2) {
                    return false;
                }
            }
            catch (ClassCastException cce) {
                XRLog.layout(Level.WARNING, "Document instance cannot create ranges: no selection possible");
                return false;
            }
        }
        return true;
    }

    public void setDot(ViewModelInfo pos) {
        this.dotInfo = pos;
        this.markInfo = pos;
        this.fireStateChanged();
        this.updateHighlights();
        this.updateSystemSelection();
    }

    @Override
    public void mouseDragged(MouseEvent e2) {
        if (!e2.isConsumed() && SwingUtilities.isLeftMouseButton(e2)) {
            this.moveCaret(this.convertMouseEventToScale(e2));
        }
    }

    @Override
    public void mouseMoved(MouseEvent e2) {
    }

    @Override
    public void mouseClicked(MouseEvent e2) {
    }

    @Override
    public void mouseEntered(MouseEvent e2) {
    }

    @Override
    public void mouseExited(MouseEvent e2) {
    }

    @Override
    public void mousePressed(MouseEvent e2) {
        int nclicks = e2.getClickCount();
        if (SwingUtilities.isLeftMouseButton(e2) && !e2.isConsumed()) {
            this.adjustCaretAndFocus(e2);
            MouseEvent newE = this.convertMouseEventToScale(e2);
            this.adjustCaretAndFocus(newE);
            if (nclicks == 2) {
                this.selectWord(newE);
            }
        }
    }

    void adjustCaretAndFocus(MouseEvent e2) {
        this.adjustCaret(e2);
        this.adjustFocus(false);
    }

    private void adjustCaret(MouseEvent e2) {
        if ((e2.getModifiers() & 1) != 0 && this.dotInfo != null) {
            this.moveCaret(e2);
        } else {
            this.positionCaret(e2);
        }
    }

    private void positionCaret(MouseEvent e2) {
        ViewModelInfo pos = this.infoFromPoint(e2);
        if (pos != null) {
            this.setDot(pos);
        }
    }

    private void adjustFocus(boolean inWindow) {
        if (this.panel != null && this.panel.isEnabled() && this.panel.isRequestFocusEnabled()) {
            if (inWindow) {
                this.panel.requestFocusInWindow();
            } else {
                this.panel.requestFocus();
            }
        }
    }

    private void selectWord(MouseEvent e2) {
    }

    @Override
    public void mouseReleased(MouseEvent e2) {
    }

    public XHTMLPanel getComponent() {
        return this.panel;
    }

    protected void moveCaret(MouseEvent e2) {
        ViewModelInfo pos = this.infoFromPoint(e2);
        if (pos != null) {
            this.moveDot(pos);
        }
    }

    public void selectAll() {
        Node n2;
        if (this.getComponent() == null || this.getComponent().getWidth() == 0 || this.getComponent().getHeight() == 0) {
            return;
        }
        this.checkDocument();
        NodeIterator nodeIterator = this.docTraversal.createNodeIterator(this.document.getDocumentElement(), 4, null, false);
        Text firstText = null;
        Text lastText = null;
        while ((n2 = nodeIterator.nextNode()) != null) {
            if (!this.textInlineMap.containsKey(n2)) continue;
            lastText = (Text)n2;
            if (firstText != null) continue;
            firstText = lastText;
        }
        if (firstText == null) {
            return;
        }
        Range r2 = this.docRange.createRange();
        r2.setStart(firstText, 0);
        ViewModelInfo firstPoint = new ViewModelInfo(r2, (InlineText)((List)this.textInlineMap.get(firstText)).get(0));
        r2 = this.docRange.createRange();
        try {
            r2.setStart(lastText, lastText.getLength());
        }
        catch (Exception e2) {
            r2.setStart(lastText, Math.max(0, lastText.getLength() - 1));
        }
        List l2 = (List)this.textInlineMap.get(firstText);
        ViewModelInfo lastPoint = new ViewModelInfo(r2, (InlineText)l2.get(l2.size() - 1));
        this.setDot(firstPoint);
        this.moveDot(lastPoint);
    }

    public void moveDot(ViewModelInfo pos) {
        this.dotInfo = pos;
        if (this.markInfo == null) {
            this.markInfo = pos;
        }
        this.fireStateChanged();
        this.updateHighlights();
        this.updateSystemSelection();
        InlineText iT = this.dotInfo.text;
        InlineLayoutBox iB = iT.getParent();
        this.adjustVisibility(new Rectangle(iB.getAbsX() + iT.getX(), iB.getAbsY(), 1, iB.getBaseline()));
    }

    private void updateHighlights() {
        ArrayList modified = new ArrayList();
        StringBuffer hlText = new StringBuffer();
        if (this.dotInfo == null) {
            this.getComponent().getRootBox().clearSelection(modified);
            this.getComponent().repaint();
            this.lastHighlightedString = "";
            return;
        }
        Range range = this.getSelectionRange();
        if (this.lastSelectionRange != null && range.compareBoundaryPoints((short)0, this.lastSelectionRange) == 0 && range.compareBoundaryPoints((short)2, this.lastSelectionRange) == 0) {
            return;
        }
        this.lastHighlightedString = "";
        this.lastSelectionRange = range.cloneRange();
        if (range.compareBoundaryPoints((short)1, range) == 0) {
            this.getComponent().getRootBox().clearSelection(modified);
        } else {
            InlineText t2;
            boolean endBeforeStart = this.markInfo.range.compareBoundaryPoints((short)0, this.dotInfo.range) >= 0;
            this.getComponent().getRootBox().clearSelection(modified);
            InlineText t1 = endBeforeStart ? this.dotInfo.text : this.markInfo.text;
            InlineText inlineText = t2 = !endBeforeStart ? this.dotInfo.text : this.markInfo.text;
            if (t1 == null || t2 == null) {
                XRLog.general(Level.FINE, "null text node");
            }
            final Range acceptRange = this.docRange.createRange();
            final Range tr = range;
            NodeFilter f2 = new NodeFilter(){

                @Override
                public short acceptNode(Node n2) {
                    acceptRange.setStart(n2, 0);
                    if (tr.getStartContainer() == n2) {
                        return 1;
                    }
                    if ((acceptRange.compareBoundaryPoints((short)0, tr) < 0 || acceptRange.compareBoundaryPoints((short)3, tr) > 0) && n2 != tr.getStartContainer() && n2 != tr.getEndContainer()) {
                        return 3;
                    }
                    return 1;
                }
            };
            NodeIterator nodeIterator = this.docTraversal.createNodeIterator(range.getCommonAncestorContainer(), 13, f2, false);
            boolean lastNodeWasBox = false;
            Node n2 = nodeIterator.nextNode();
            while (n2 != null) {
                if (n2.getNodeType() == 1) {
                    Box box = this.getBoxForElement((Element)n2);
                    if (box instanceof BlockBox && !lastNodeWasBox) {
                        hlText.append(PARA_EQUIV);
                        lastNodeWasBox = true;
                    } else {
                        lastNodeWasBox = false;
                    }
                } else {
                    lastNodeWasBox = false;
                    Text t3 = (Text)n2;
                    List iTs = this.getInlineTextsForText(t3);
                    if (iTs != null) {
                        int selTxtSt = t3 == range.getStartContainer() ? range.getStartOffset() : 0;
                        int selTxtEnd = t3 == range.getEndContainer() ? range.getEndOffset() : t3.getNodeValue().length();
                        hlText.append(t3.getNodeValue().substring(selTxtSt, selTxtEnd));
                        for (InlineText iT : iTs) {
                            iT.setSelectionStart((short)Math.max(0, Math.min(selTxtSt, iT.getEnd()) - iT.getStart()));
                            iT.setSelectionEnd((short)Math.max(0, Math.min(iT.getEnd(), selTxtEnd) - iT.getStart()));
                        }
                    }
                }
                n2 = nodeIterator.nextNode();
            }
        }
        String s2 = this.normalizeSpaces(hlText.toString());
        this.getComponent().repaint();
        this.lastHighlightedString = Util.replace(s2, PARA_EQUIV, "\n\n");
    }

    public String normalizeSpaces(String s2) {
        if (s2 == null) {
            return null;
        }
        StringBuffer buf = new StringBuffer();
        StringCharacterIterator iter = new StringCharacterIterator(s2);
        boolean inWhitespace = false;
        char c2 = iter.first();
        while (c2 != '\uffff') {
            if (Character.isWhitespace(c2)) {
                if (!inWhitespace) {
                    buf.append(' ');
                    inWhitespace = true;
                }
            } else {
                inWhitespace = false;
                buf.append(c2);
            }
            c2 = iter.next();
        }
        return buf.toString();
    }

    private Box getElementContainerBox(InlineText t2) {
        Box b2 = t2.getParent();
        while (b2.getElement() == null) {
            b2 = b2.getParent();
        }
        return b2;
    }

    private boolean createMaps() {
        if (this.panel.getRootBox() == null) {
            return false;
        }
        this.textInlineMap = new LinkedHashMap();
        this.elementBoxMap = new HashMap();
        Stack<Box> s2 = new Stack<Box>();
        s2.push(this.panel.getRootBox());
        while (!s2.empty()) {
            Box b2 = (Box)s2.pop();
            Element element = b2.getElement();
            if (element != null && !this.elementBoxMap.containsKey(element)) {
                this.elementBoxMap.put(element, b2);
            }
            if (b2 instanceof InlineLayoutBox) {
                InlineLayoutBox ilb = (InlineLayoutBox)b2;
                for (Object o2 : ilb.getInlineChildren()) {
                    if (o2 instanceof InlineText) {
                        InlineText t2 = (InlineText)o2;
                        Text txt = t2.getTextNode();
                        if (!this.textInlineMap.containsKey(txt)) {
                            this.textInlineMap.put(txt, new ArrayList());
                        }
                        ((List)this.textInlineMap.get(txt)).add(t2);
                        continue;
                    }
                    s2.push((Box)o2);
                }
                continue;
            }
            Iterator childIterator = b2.getChildIterator();
            while (childIterator.hasNext()) {
                s2.push((Box)childIterator.next());
            }
        }
        return true;
    }

    private List getInlineTextsForText(Text t2) {
        return (List)this.textInlineMap.get(t2);
    }

    private Box getBoxForElement(Element elt) {
        return (Box)this.elementBoxMap.get(elt);
    }

    private void updateSystemSelection() {
        Clipboard clip;
        if (this.dotInfo != this.markInfo && this.panel != null && (clip = this.panel.getToolkit().getSystemSelection()) != null) {
            String selectedText = this.lastHighlightedString;
            try {
                clip.setContents(new StringSelection(selectedText), null);
            }
            catch (IllegalStateException illegalStateException) {
                // empty catch block
            }
        }
    }

    void copy() {
        Clipboard clip;
        if (this.dotInfo != this.markInfo && this.panel != null && (clip = this.panel.getToolkit().getSystemClipboard()) != null) {
            String selectedText = this.lastHighlightedString;
            try {
                clip.setContents(new StringSelection(selectedText), null);
            }
            catch (IllegalStateException illegalStateException) {
                // empty catch block
            }
        }
    }

    List getInlineLayoutBoxes(Box b2, boolean ignoreChildElements) {
        Stack<Box> boxes = new Stack<Box>();
        ArrayList<InlineLayoutBox> ilbs = new ArrayList<InlineLayoutBox>();
        boxes.push(b2);
        while (!boxes.empty()) {
            b2 = (Box)boxes.pop();
            if (b2 instanceof InlineLayoutBox) {
                ilbs.add((InlineLayoutBox)b2);
                continue;
            }
            Iterator it = b2.getChildIterator();
            while (it.hasNext()) {
                Box child = (Box)it.next();
                if (ignoreChildElements && child.getElement() != null) continue;
                boxes.push(child);
            }
        }
        return ilbs;
    }

    ViewModelInfo infoFromPoint(MouseEvent e2) {
        this.checkDocument();
        Range r2 = this.docRange.createRange();
        InlineText fndTxt = null;
        Box box = this.panel.getRootLayer().find(this.panel.getLayoutContext(), e2.getX(), e2.getY(), true);
        if (box == null) {
            return null;
        }
        Object elt = null;
        int offset = 0;
        InlineLayoutBox ilb = null;
        boolean containsWholeIlb = false;
        if (box instanceof InlineLayoutBox) {
            ilb = (InlineLayoutBox)box;
        } else {
            while (ilb == null) {
                List ilbs = this.getInlineLayoutBoxes(box, false);
                for (int i2 = ilbs.size() - 1; i2 >= 0; --i2) {
                    InlineLayoutBox ilbt = (InlineLayoutBox)ilbs.get(i2);
                    if (ilbt.getAbsY() > e2.getY() || ilbt.getAbsX() > e2.getX()) continue;
                    if ((ilb == null || ilbt.getAbsY() > ilb.getAbsY() || ilbt.getAbsY() == ilb.getAbsY() && ilbt.getX() > ilb.getX()) && ilbt.isContainsVisibleContent()) {
                        boolean hasDecentTextNode = false;
                        int x2 = ilbt.getAbsX();
                        for (Object o2 : ilbt.getInlineChildren()) {
                            InlineText txt;
                            if (!(o2 instanceof InlineText) || (txt = (InlineText)o2).getTextNode() == null) continue;
                            hasDecentTextNode = true;
                            break;
                        }
                        if (hasDecentTextNode) {
                            ilb = ilbt;
                        }
                    }
                    containsWholeIlb = true;
                }
                if (ilb != null) continue;
                if (box.getParent() == null) {
                    return null;
                }
                box = box.getParent();
            }
        }
        int x3 = ilb.getAbsX();
        InlineText lastItxt = null;
        for (Object o3 : ilb.getInlineChildren()) {
            if (!(o3 instanceof InlineText)) continue;
            InlineText txt = (InlineText)o3;
            if (txt.getTextNode() != null) {
                if (e2.getX() >= x3 + txt.getX() && e2.getX() < x3 + txt.getX() + txt.getWidth() || containsWholeIlb) {
                    fndTxt = txt;
                    break;
                }
                if (e2.getX() < x3 + txt.getX() && lastItxt != null) {
                    fndTxt = lastItxt;
                    break;
                }
            }
            lastItxt = txt;
        }
        LayoutContext lc = this.panel.getLayoutContext();
        if (fndTxt == null) {
            return null;
        }
        String txt = fndTxt.getMasterText();
        CalculatedStyle style = ilb.getStyle();
        if (containsWholeIlb) {
            offset = fndTxt.getEnd();
        } else {
            int w2;
            for (offset = fndTxt.getStart(); offset < fndTxt.getEnd() && (w2 = this.getTextWidth(lc, style, txt.substring(fndTxt.getStart(), offset + 1))) + x3 + fndTxt.getX() <= e2.getX(); ++offset) {
            }
        }
        Text node = fndTxt.getTextNode();
        try {
            r2.setStart(node, offset);
        }
        catch (Exception ex) {
            r2.setStart(node, node.getLength() - 1);
        }
        return new ViewModelInfo(r2, fndTxt);
    }

    private int getTextWidth(LayoutContext c2, CalculatedStyle cs, String s2) {
        return c2.getTextRenderer().getWidth(c2.getFontContext(), c2.getFont(cs.getFont(c2)), s2);
    }

    public Range getSelectionRange() {
        if (this.dotInfo == null || this.dotInfo.range == null) {
            return null;
        }
        Range r2 = this.docRange.createRange();
        if (this.markInfo.range.compareBoundaryPoints((short)0, this.dotInfo.range) <= 0) {
            r2.setStart(this.markInfo.range.getStartContainer(), this.markInfo.range.getStartOffset());
            r2.setEnd(this.dotInfo.range.getStartContainer(), this.dotInfo.range.getStartOffset());
        } else {
            r2.setStart(this.dotInfo.range.getStartContainer(), this.dotInfo.range.getStartOffset());
            r2.setEnd(this.markInfo.range.getStartContainer(), this.markInfo.range.getStartOffset());
        }
        return r2;
    }

    protected void adjustVisibility(Rectangle nloc) {
        if (this.panel == null) {
            return;
        }
        if (SwingUtilities.isEventDispatchThread()) {
            this.panel.scrollRectToVisible(nloc);
        } else {
            SwingUtilities.invokeLater(new SafeScroller(nloc));
        }
    }

    protected MouseEvent convertMouseEventToScale(MouseEvent e2) {
        if (!e2.isConsumed() && this.panel instanceof ScalableXHTMLPanel) {
            Point newP = ((ScalableXHTMLPanel)this.panel).convertFromScaled(e2.getX(), e2.getY());
            MouseEvent newE = new MouseEvent(e2.getComponent(), e2.getID(), e2.getWhen(), e2.getModifiersEx(), (int)newP.getX(), (int)newP.getY(), e2.getClickCount(), e2.isPopupTrigger(), e2.getButton());
            return newE;
        }
        return e2;
    }

    public void setHandler(TransferHandler handler) {
        this.handler = handler;
    }

    class SafeScroller
    implements Runnable {
        Rectangle r;

        SafeScroller(Rectangle r2) {
            this.r = r2;
        }

        @Override
        public void run() {
            if (SelectionHighlighter.this.panel != null) {
                SelectionHighlighter.this.panel.scrollRectToVisible(this.r);
            }
        }
    }

    public static class CopyAction
    extends AbstractAction {
        private SelectionHighlighter caret;

        public CopyAction() {
            super(SelectionHighlighter.copyAction);
        }

        public void install(SelectionHighlighter caret) {
            this.caret = caret;
        }

        @Override
        public void actionPerformed(ActionEvent e2) {
            if (this.caret != null) {
                this.caret.copy();
            }
        }
    }

    public class ViewModelInfo {
        Range range;
        InlineText text;

        ViewModelInfo(Range range, InlineText text2) {
            this.range = range;
            this.text = text2;
        }

        public String toString() {
            return this.range.getStartContainer() + ":" + this.range.getStartOffset();
        }

        public boolean equals(Object o2) {
            if (this == o2) {
                return true;
            }
            if (!(o2 instanceof ViewModelInfo)) {
                return false;
            }
            ViewModelInfo that = (ViewModelInfo)o2;
            if (!this.range.equals(that.range)) {
                return false;
            }
            return this.text.equals(that.text);
        }

        public int hashCode() {
            int result2 = this.range.hashCode();
            result2 = 31 * result2 + this.text.hashCode();
            return result2;
        }

        public boolean canCopy() {
            return SelectionHighlighter.this.lastHighlightedString.length() != 0;
        }
    }
}

