/*
 * Decompiled with CFR 0.152.
 */
package com.itextpdf.text.pdf;

import com.itextpdf.text.Document;
import com.itextpdf.text.DocumentException;
import com.itextpdf.text.ExceptionConverter;
import com.itextpdf.text.error_messages.MessageLocalization;
import com.itextpdf.text.log.Counter;
import com.itextpdf.text.log.CounterFactory;
import com.itextpdf.text.log.Logger;
import com.itextpdf.text.log.LoggerFactory;
import com.itextpdf.text.pdf.BadPdfFormatException;
import com.itextpdf.text.pdf.ByteBuffer;
import com.itextpdf.text.pdf.PRIndirectReference;
import com.itextpdf.text.pdf.PRStream;
import com.itextpdf.text.pdf.PdfArray;
import com.itextpdf.text.pdf.PdfCopy;
import com.itextpdf.text.pdf.PdfDictionary;
import com.itextpdf.text.pdf.PdfImportedPage;
import com.itextpdf.text.pdf.PdfIndirectReference;
import com.itextpdf.text.pdf.PdfName;
import com.itextpdf.text.pdf.PdfObject;
import com.itextpdf.text.pdf.PdfReader;
import com.itextpdf.text.pdf.RefKey;
import java.io.IOException;
import java.io.OutputStream;
import java.security.MessageDigest;
import java.util.Arrays;
import java.util.HashMap;

public class PdfSmartCopy
extends PdfCopy {
    private static final Logger LOGGER = LoggerFactory.getLogger(PdfSmartCopy.class);
    private HashMap<ByteStore, PdfIndirectReference> streamMap = null;
    private final HashMap<RefKey, Integer> serialized = new HashMap();
    protected Counter COUNTER = CounterFactory.getCounter(PdfSmartCopy.class);

    protected Counter getCounter() {
        return this.COUNTER;
    }

    public PdfSmartCopy(Document document, OutputStream os) throws DocumentException {
        super(document, os);
        this.streamMap = new HashMap();
    }

    protected PdfIndirectReference copyIndirect(PRIndirectReference in) throws IOException, BadPdfFormatException {
        PdfObject type2;
        PdfIndirectReference theRef;
        RefKey key2;
        PdfCopy.IndirectReferences iRef;
        PdfIndirectReference streamRef;
        PdfObject srcObj = PdfReader.getPdfObjectRelease(in);
        ByteStore streamKey = null;
        boolean validStream = false;
        if (srcObj.isStream()) {
            streamKey = new ByteStore((PRStream)srcObj, this.serialized);
            validStream = true;
            streamRef = this.streamMap.get(streamKey);
            if (streamRef != null) {
                return streamRef;
            }
        } else if (srcObj.isDictionary()) {
            streamKey = new ByteStore((PdfDictionary)srcObj, this.serialized);
            validStream = true;
            streamRef = this.streamMap.get(streamKey);
            if (streamRef != null) {
                return streamRef;
            }
        }
        if ((iRef = (PdfCopy.IndirectReferences)this.indirects.get(key2 = new RefKey(in))) != null) {
            theRef = iRef.getRef();
            if (iRef.getCopied()) {
                return theRef;
            }
        } else {
            theRef = this.body.getPdfIndirectReference();
            iRef = new PdfCopy.IndirectReferences(theRef);
            this.indirects.put(key2, iRef);
        }
        if (srcObj.isDictionary() && (type2 = PdfReader.getPdfObjectRelease(((PdfDictionary)srcObj).get(PdfName.TYPE))) != null) {
            if (PdfName.PAGE.equals(type2)) {
                return theRef;
            }
            if (PdfName.CATALOG.equals(type2)) {
                LOGGER.warn(MessageLocalization.getComposedMessage("make.copy.of.catalog.dictionary.is.forbidden", new Object[0]));
                return null;
            }
        }
        iRef.setCopied();
        if (validStream) {
            this.streamMap.put(streamKey, theRef);
        }
        PdfObject obj = this.copyObject(srcObj);
        this.addToBody(obj, theRef);
        return theRef;
    }

    public void freeReader(PdfReader reader) throws IOException {
        this.serialized.clear();
        super.freeReader(reader);
    }

    public void addPage(PdfImportedPage iPage) throws IOException, BadPdfFormatException {
        if (this.currentPdfReaderInstance.getReader() != this.reader) {
            this.serialized.clear();
        }
        super.addPage(iPage);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class ByteStore {
        private final byte[] b;
        private final int hash;
        private MessageDigest md5;

        private void serObject(PdfObject obj, int level, ByteBuffer bb, HashMap<RefKey, Integer> serialized) throws IOException {
            RefKey key2;
            if (level <= 0) {
                return;
            }
            if (obj == null) {
                bb.append("$Lnull");
                return;
            }
            PdfIndirectReference ref = null;
            ByteBuffer savedBb = null;
            if (obj.isIndirect()) {
                ref = (PdfIndirectReference)obj;
                key2 = new RefKey(ref);
                if (serialized.containsKey(key2)) {
                    bb.append(serialized.get(key2));
                    return;
                }
                savedBb = bb;
                bb = new ByteBuffer();
            }
            if ((obj = PdfReader.getPdfObject(obj)).isStream()) {
                bb.append("$B");
                this.serDic((PdfDictionary)obj, level - 1, bb, serialized);
                if (level > 0) {
                    this.md5.reset();
                    bb.append(this.md5.digest(PdfReader.getStreamBytesRaw((PRStream)obj)));
                }
            } else if (obj.isDictionary()) {
                this.serDic((PdfDictionary)obj, level - 1, bb, serialized);
            } else if (obj.isArray()) {
                this.serArray((PdfArray)obj, level - 1, bb, serialized);
            } else if (obj.isString()) {
                bb.append("$S").append(obj.toString());
            } else if (obj.isName()) {
                bb.append("$N").append(obj.toString());
            } else {
                bb.append("$L").append(obj.toString());
            }
            if (savedBb != null) {
                key2 = new RefKey(ref);
                if (!serialized.containsKey(key2)) {
                    serialized.put(key2, ByteStore.calculateHash(bb.getBuffer()));
                }
                savedBb.append(bb);
            }
        }

        private void serDic(PdfDictionary dic, int level, ByteBuffer bb, HashMap<RefKey, Integer> serialized) throws IOException {
            bb.append("$D");
            if (level <= 0) {
                return;
            }
            Object[] keys2 = dic.getKeys().toArray();
            Arrays.sort(keys2);
            for (int k2 = 0; k2 < keys2.length; ++k2) {
                if (keys2[k2].equals(PdfName.P) && (dic.get((PdfName)keys2[k2]).isIndirect() || dic.get((PdfName)keys2[k2]).isDictionary())) continue;
                this.serObject((PdfObject)keys2[k2], level, bb, serialized);
                this.serObject(dic.get((PdfName)keys2[k2]), level, bb, serialized);
            }
        }

        private void serArray(PdfArray array, int level, ByteBuffer bb, HashMap<RefKey, Integer> serialized) throws IOException {
            bb.append("$A");
            if (level <= 0) {
                return;
            }
            for (int k2 = 0; k2 < array.size(); ++k2) {
                this.serObject(array.getPdfObject(k2), level, bb, serialized);
            }
        }

        ByteStore(PRStream str, HashMap<RefKey, Integer> serialized) throws IOException {
            try {
                this.md5 = MessageDigest.getInstance("MD5");
            }
            catch (Exception e2) {
                throw new ExceptionConverter(e2);
            }
            ByteBuffer bb = new ByteBuffer();
            int level = 100;
            this.serObject(str, level, bb, serialized);
            this.b = bb.toByteArray();
            this.hash = ByteStore.calculateHash(this.b);
            this.md5 = null;
        }

        ByteStore(PdfDictionary dict, HashMap<RefKey, Integer> serialized) throws IOException {
            try {
                this.md5 = MessageDigest.getInstance("MD5");
            }
            catch (Exception e2) {
                throw new ExceptionConverter(e2);
            }
            ByteBuffer bb = new ByteBuffer();
            int level = 100;
            this.serObject(dict, level, bb, serialized);
            this.b = bb.toByteArray();
            this.hash = ByteStore.calculateHash(this.b);
            this.md5 = null;
        }

        private static int calculateHash(byte[] b2) {
            int hash = 0;
            int len = b2.length;
            for (int k2 = 0; k2 < len; ++k2) {
                hash = hash * 31 + (b2[k2] & 0xFF);
            }
            return hash;
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof ByteStore)) {
                return false;
            }
            if (this.hashCode() != obj.hashCode()) {
                return false;
            }
            return Arrays.equals(this.b, ((ByteStore)obj).b);
        }

        public int hashCode() {
            return this.hash;
        }
    }
}

