/*
 * Decompiled with CFR 0.152.
 */
package gde.device.graupner;

import com.sun.istack.Nullable;
import gde.Analyzer;
import gde.GDE;
import gde.config.Settings;
import gde.data.Channel;
import gde.data.Channels;
import gde.data.Record;
import gde.data.RecordSet;
import gde.device.ChannelPropertyTypes;
import gde.device.DataTypes;
import gde.device.DeviceConfiguration;
import gde.device.IDevice;
import gde.device.MeasurementPropertyTypes;
import gde.device.MeasurementType;
import gde.device.StatisticsType;
import gde.device.graupner.FileTransferTabItem;
import gde.device.graupner.HoTTAdapter2;
import gde.device.graupner.HoTTAdapter2M;
import gde.device.graupner.HoTTAdapterD;
import gde.device.graupner.HoTTAdapterDialog;
import gde.device.graupner.HoTTAdapterM;
import gde.device.graupner.HoTTAdapterSerialPort;
import gde.device.graupner.HoTTAdapterX;
import gde.device.graupner.HoTTViewer;
import gde.device.graupner.HoTTbinHistoReader;
import gde.device.graupner.HoTTbinReader;
import gde.device.graupner.HoTTbinReader2;
import gde.device.graupner.HoTTbinReaderD;
import gde.device.graupner.HoTTbinReaderX;
import gde.device.graupner.HoTTlogHistoReader;
import gde.device.graupner.HoTTlogReader;
import gde.device.graupner.HoTTlogReader2;
import gde.device.graupner.HoTTlogReaderD;
import gde.device.graupner.PackageLossDeque;
import gde.device.resource.DeviceXmlResource;
import gde.exception.DataInconsitsentException;
import gde.exception.DataTypeException;
import gde.histo.cache.VaultCollector;
import gde.histo.device.IHistoDevice;
import gde.histo.device.UniversalSampler;
import gde.histo.utils.PathUtils;
import gde.io.DataParser;
import gde.io.FileHandler;
import gde.messages.Messages;
import gde.ui.DataExplorer;
import gde.ui.SWTResourceManager;
import gde.utils.FileUtils;
import gde.utils.GPSHelper;
import gde.utils.LinearRegression;
import gde.utils.ObjectKeyCompliance;
import gde.utils.StringHelper;
import gde.utils.WaitTimer;
import java.io.BufferedInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Constructor;
import java.net.URL;
import java.nio.ByteBuffer;
import java.nio.IntBuffer;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.AbstractCollection;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.BitSet;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import java.util.Set;
import java.util.function.Supplier;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import javax.xml.bind.JAXBException;
import org.eclipse.swt.SWT;
import org.eclipse.swt.custom.CTabFolder;
import org.eclipse.swt.custom.CTabItem;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;

public class HoTTAdapter
extends DeviceConfiguration
implements IDevice,
IHistoDevice {
    static final Logger log = Logger.getLogger(HoTTAdapter.class.getName());
    static final String LOG_COUNT = "LogCount";
    static final String FILE_PATH = "FilePath";
    static final String SD_FORMAT = "SD_FORMAT";
    static final String DETECTED_SENSOR = "DETECTED SENSOR";
    static final String ASCII_LOG_SIZE = "ASCII_LOG_SIZE";
    static final String RAW_LOG_SIZE = "RAW_LOG_SIZE";
    static final String DATA_BLOCK_SIZE = "DATA_BLOCK_SIZE";
    static final String LOG_DATA_OFFSET = "LOG DATA OFFSET";
    static boolean IS_SLAVE_MODE = false;
    static final byte SENSOR_TYPE_RECEIVER_19200 = -128;
    static final byte SENSOR_TYPE_VARIO_19200 = -119;
    static final byte SENSOR_TYPE_GPS_19200 = -118;
    static final byte SENSOR_TYPE_GENERAL_19200 = -115;
    static final byte SENSOR_TYPE_ELECTRIC_19200 = -114;
    static final byte SENSOR_TYPE_SPEED_CONTROL_19200 = -116;
    static final byte ANSWER_SENSOR_VARIO_19200 = -112;
    static final byte ANSWER_SENSOR_GPS_19200 = -96;
    static final byte ANSWER_SENSOR_GENERAL_19200 = -48;
    static final byte ANSWER_SENSOR_ELECTRIC_19200 = -32;
    static final byte ANSWER_SENSOR_MOTOR_DRIVER_19200 = -64;
    static final byte ANSWER_SENSOR_ESC2_19200 = 80;
    static final byte ANSWER_SENSOR_ESC3_19200 = 96;
    static final byte ANSWER_SENSOR_ESC4_19200 = 112;
    static final byte SENSOR_TYPE_RECEIVER_115200 = 52;
    static final byte SENSOR_TYPE_VARIO_115200 = 55;
    static final byte SENSOR_TYPE_GPS_115200 = 56;
    static final byte SENSOR_TYPE_GENERAL_115200 = 53;
    static final byte SENSOR_TYPE_ELECTRIC_115200 = 54;
    static final byte SENSOR_TYPE_SPEED_CONTROL_115200 = 57;
    static final byte SENSOR_TYPE_SERVO_POSITION_115200 = 64;
    static final byte SENSOR_TYPE_PURPIL_POSITION_115200 = 65;
    static final byte SENSOR_TYPE_CONTROL_1_115200 = 66;
    static final byte SENSOR_TYPE_CONTROL_2_115200 = 67;
    static final boolean[] isSwitchS = new boolean[]{false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false};
    static final boolean[] isSwitchG = new boolean[]{false, false, false, false, false, false, false, false};
    static final boolean[] isSwitchL = new boolean[]{false, false, false, false, false, false, false, false};
    static final int QUERY_GAP_MS = 30;
    final DataExplorer application;
    final Channels channels;
    final Settings settings;
    final HoTTAdapterDialog dialog;
    final HoTTAdapterSerialPort serialPort;
    protected final PickerParameters pickerParameters = new PickerParameters(Analyzer.getInstance());
    protected List<String> importExtentions = null;

    public HoTTAdapter(String deviceProperties) throws FileNotFoundException, JAXBException {
        super(deviceProperties);
        Messages.setDeviceResourceBundle((String)"gde.device.graupner.hott.messages", (Locale)Settings.getInstance().getLocale(), (ClassLoader)((Object)((Object)this)).getClass().getClassLoader());
        this.application = DataExplorer.getInstance();
        this.channels = Channels.getInstance();
        this.settings = Settings.getInstance();
        this.serialPort = this.application != null ? new HoTTAdapterSerialPort(this, this.application) : new HoTTAdapterSerialPort(this, null);
        this.dialog = new HoTTAdapterDialog(this.application.getShell(), this);
        if (this.application.getMenuToolBar() != null) {
            String toolTipText = HoTTAdapter.getImportToolTip();
            this.configureSerialPortMenu(2, toolTipText, toolTipText);
            this.updateFileExportMenu(this.application.getMenuBar().getExportMenu());
            this.updateFileImportMenu(this.application.getMenuBar().getImportMenu());
        }
        this.setPickerParameters();
    }

    public HoTTAdapter(DeviceConfiguration deviceConfig) {
        super(deviceConfig);
        Messages.setDeviceResourceBundle((String)"gde.device.graupner.hott.messages", (Locale)Settings.getInstance().getLocale(), (ClassLoader)((Object)((Object)this)).getClass().getClassLoader());
        this.application = DataExplorer.getInstance();
        this.channels = Channels.getInstance();
        this.settings = Settings.getInstance();
        this.serialPort = this.application != null ? new HoTTAdapterSerialPort(this, this.application) : new HoTTAdapterSerialPort(this, null);
        this.dialog = new HoTTAdapterDialog(this.application.getShell(), this);
        if (this.application.getMenuToolBar() != null) {
            String toolTipText = HoTTAdapter.getImportToolTip();
            this.configureSerialPortMenu(2, toolTipText, toolTipText);
            this.updateFileExportMenu(this.application.getMenuBar().getExportMenu());
            this.updateFileImportMenu(this.application.getMenuBar().getImportMenu());
        }
        this.setPickerParameters();
    }

    private void setPickerParameters() {
        this.pickerParameters.isChannelsChannelEnabled = this.getChannelProperty(ChannelPropertyTypes.ENABLE_CHANNEL) != null && this.getChannelProperty(ChannelPropertyTypes.ENABLE_CHANNEL).getValue() != "" ? Boolean.parseBoolean(this.getChannelProperty(ChannelPropertyTypes.ENABLE_CHANNEL).getValue()) : false;
        this.pickerParameters.isFilterEnabled = this.getChannelProperty(ChannelPropertyTypes.ENABLE_FILTER) != null && this.getChannelProperty(ChannelPropertyTypes.ENABLE_FILTER).getValue() != "" ? Boolean.parseBoolean(this.getChannelProperty(ChannelPropertyTypes.ENABLE_FILTER).getValue()) : true;
        this.pickerParameters.isFilterTextModus = this.getChannelProperty(ChannelPropertyTypes.TEXT_MODE) != null && this.getChannelProperty(ChannelPropertyTypes.TEXT_MODE).getValue() != "" ? Boolean.parseBoolean(this.getChannelProperty(ChannelPropertyTypes.TEXT_MODE).getValue()) : false;
        try {
            this.pickerParameters.altitudeClimbSensorSelection = this.getChannelProperty(ChannelPropertyTypes.SENSOR_ALT_CLIMB) != null && this.getChannelProperty(ChannelPropertyTypes.SENSOR_ALT_CLIMB).getValue() != null ? Integer.parseInt(this.getChannelProperty(ChannelPropertyTypes.SENSOR_ALT_CLIMB).getValue()) : 0;
        }
        catch (NumberFormatException e) {
            this.pickerParameters.altitudeClimbSensorSelection = 0;
        }
        try {
            this.pickerParameters.isChannelPercentEnabled = this.getChannelProperty(ChannelPropertyTypes.CHANNEL_PERCENTAGE) != null && this.getChannelProperty(ChannelPropertyTypes.CHANNEL_PERCENTAGE).getValue() != null ? Boolean.parseBoolean(this.getChannelProperty(ChannelPropertyTypes.CHANNEL_PERCENTAGE).getValue()) : true;
        }
        catch (NumberFormatException e) {
            this.pickerParameters.isChannelPercentEnabled = true;
        }
        this.pickerParameters.latitudeToleranceFactor = this.getMeasurementPropertyValue(3, 1, MeasurementPropertyTypes.FILTER_FACTOR.value()).toString().length() > 0 ? Double.parseDouble(this.getMeasurementPropertyValue(3, 1, MeasurementPropertyTypes.FILTER_FACTOR.value()).toString()) : 50.0;
        this.pickerParameters.longitudeToleranceFactor = this.getMeasurementPropertyValue(3, 2, MeasurementPropertyTypes.FILTER_FACTOR.value()).toString().length() > 0 ? Double.parseDouble(this.getMeasurementPropertyValue(3, 2, MeasurementPropertyTypes.FILTER_FACTOR.value()).toString()) : 15.0;
    }

    public String getReaderSettingsCsv() {
        return this.pickerParameters.getReaderSettingsCsv();
    }

    public HoTTAdapterSerialPort getCommunicationPort() {
        return this.serialPort;
    }

    public HashMap<String, String> getLovKeyMappings(HashMap<String, String> lov2osdMap) {
        return lov2osdMap;
    }

    public String getConvertedRecordConfigurations(HashMap<String, String> header, HashMap<String, String> lov2osdMap, int channelNumber) {
        return "";
    }

    public int getLovDataByteSize() {
        return 0;
    }

    public synchronized void addConvertedLovDataBufferAsRawDataPoints(RecordSet recordSet, byte[] dataBuffer, int recordDataSize, boolean doUpdateProgressBar) throws DataInconsitsentException {
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public int[] convertDataBytes(int[] points, byte[] dataBuffer) {
        block85: {
            int maxVotage = Integer.MIN_VALUE;
            int minVotage = Integer.MAX_VALUE;
            block2 : switch (this.serialPort.protocolType.ordinal()) {
                case 0: {
                    switch (dataBuffer[1]) {
                        case -128: {
                            if (dataBuffer.length != 17) break;
                            points[0] = 0;
                            points[1] = (dataBuffer[9] & 0xFF) * 1000;
                            points[2] = (dataBuffer[5] & 0xFF) * 1000;
                            points[3] = DataParser.parse2Short((byte[])dataBuffer, (int)11) * 1000;
                            points[4] = (dataBuffer[13] & 0xFF) * -1000;
                            points[5] = (dataBuffer[9] & 0xFF) * -1000;
                            points[6] = (dataBuffer[6] & 0xFF) * 1000;
                            points[7] = (dataBuffer[7] & 0xFF) * 1000;
                            return points;
                        }
                        case -119: {
                            if (dataBuffer.length != 31) break;
                            points[0] = (dataBuffer[15] & 0xFF) * 1000;
                            points[1] = DataParser.parse2Short((byte[])dataBuffer, (int)16) * 1000;
                            points[2] = DataParser.parse2Short((byte[])dataBuffer, (int)22) * 1000;
                            points[3] = DataParser.parse2Short((byte[])dataBuffer, (int)24) * 1000;
                            points[4] = DataParser.parse2Short((byte[])dataBuffer, (int)26) * 1000;
                            points[5] = (dataBuffer[8] & 0xFF) * 1000;
                            points[6] = (dataBuffer[5] & 0xFF) * 1000;
                            return points;
                        }
                        case -118: {
                            if (dataBuffer.length != 40) break;
                            points[0] = (dataBuffer[15] & 0xFF) * 1000;
                            points[1] = DataParser.parse2Short((byte[])dataBuffer, (int)20) * 10000 + DataParser.parse2Short((byte[])dataBuffer, (int)22);
                            points[1] = dataBuffer[19] == 1 ? -1 * points[1] : points[1];
                            points[2] = DataParser.parse2Short((byte[])dataBuffer, (int)25) * 10000 + DataParser.parse2Short((byte[])dataBuffer, (int)27);
                            points[2] = dataBuffer[24] == 1 ? -1 * points[2] : points[2];
                            points[3] = DataParser.parse2Short((byte[])dataBuffer, (int)31) * 1000;
                            points[4] = DataParser.parse2Short((byte[])dataBuffer, (int)33) * 1000;
                            points[5] = (dataBuffer[35] & 0xFF) * 1000;
                            points[6] = DataParser.parse2Short((byte[])dataBuffer, (int)17) * 1000;
                            points[7] = DataParser.parse2Short((byte[])dataBuffer, (int)29) * 1000;
                            points[8] = (dataBuffer[16] & 0xFF) * 1000;
                            points[9] = 0;
                            points[10] = (dataBuffer[8] & 0xFF) * 1000;
                            points[11] = (dataBuffer[5] & 0xFF) * 1000;
                            return points;
                        }
                        case -115: {
                            if (dataBuffer.length != 48) break;
                            points[0] = (dataBuffer[15] & 0xFF) * 1000;
                            points[1] = DataParser.parse2Short((byte[])dataBuffer, (int)40) * 1000;
                            points[2] = DataParser.parse2Short((byte[])dataBuffer, (int)38) * 1000;
                            points[3] = DataParser.parse2Short((byte[])dataBuffer, (int)42) * 1000;
                            points[4] = Double.valueOf((double)points[1] / 1000.0 * (double)points[2]).intValue();
                            points[5] = 0;
                            for (int j = 0; j < 6; ++j) {
                                points[j + 6] = (dataBuffer[16 + j] & 0xFF) * 1000;
                                if (points[j + 6] <= 0) continue;
                                maxVotage = points[j + 6] > maxVotage ? points[j + 6] : maxVotage;
                                minVotage = points[j + 6] < minVotage ? points[j + 6] : minVotage;
                            }
                            points[5] = maxVotage != Integer.MIN_VALUE && minVotage != Integer.MAX_VALUE ? maxVotage - minVotage : 0;
                            points[12] = DataParser.parse2Short((byte[])dataBuffer, (int)31) * 1000;
                            points[13] = DataParser.parse2Short((byte[])dataBuffer, (int)33) * 1000;
                            points[14] = DataParser.parse2Short((byte[])dataBuffer, (int)35) * 1000;
                            points[15] = (dataBuffer[37] & 0xFF) * 1000;
                            points[16] = DataParser.parse2Short((byte[])dataBuffer, (int)29) * 1000;
                            points[17] = DataParser.parse2Short((byte[])dataBuffer, (int)22) * 1000;
                            points[18] = DataParser.parse2Short((byte[])dataBuffer, (int)24) * 1000;
                            points[19] = (dataBuffer[26] & 0xFF) * 1000;
                            points[20] = (dataBuffer[27] & 0xFF) * 1000;
                            return points;
                        }
                        case -114: {
                            if (dataBuffer.length != 51) break;
                            points[0] = (dataBuffer[15] & 0xFF) * 1000;
                            points[1] = DataParser.parse2Short((byte[])dataBuffer, (int)40) * 1000;
                            points[2] = DataParser.parse2Short((byte[])dataBuffer, (int)38) * 1000;
                            points[3] = DataParser.parse2Short((byte[])dataBuffer, (int)42) * 1000;
                            points[4] = Double.valueOf((double)points[1] / 1000.0 * (double)points[2]).intValue();
                            points[5] = 0;
                            for (int j = 0; j < 14; ++j) {
                                points[j + 6] = (dataBuffer[16 + j] & 0xFF) * 1000;
                                if (points[j + 6] <= 0) continue;
                                maxVotage = points[j + 6] > maxVotage ? points[j + 6] : maxVotage;
                                minVotage = points[j + 6] < minVotage ? points[j + 6] : minVotage;
                            }
                            points[5] = maxVotage != Integer.MIN_VALUE && minVotage != Integer.MAX_VALUE ? maxVotage - minVotage : 0;
                            points[20] = DataParser.parse2Short((byte[])dataBuffer, (int)36) * 1000;
                            points[21] = DataParser.parse2Short((byte[])dataBuffer, (int)44) * 1000;
                            points[22] = (dataBuffer[46] & 0xFF) * 1000;
                            points[23] = DataParser.parse2Short((byte[])dataBuffer, (int)30) * 1000;
                            points[24] = DataParser.parse2Short((byte[])dataBuffer, (int)32) * 1000;
                            points[25] = (dataBuffer[34] & 0xFF) * 1000;
                            points[26] = (dataBuffer[35] & 0xFF) * 1000;
                        }
                    }
                    return points;
                }
                case 1: {
                    switch (dataBuffer[1]) {
                        case -128: {
                            if (dataBuffer.length < 17) break;
                            short tmpPackageLoss = DataParser.parse2Short((byte[])dataBuffer, (int)11);
                            int tmpVoltageRx = dataBuffer[6] & 0xFF;
                            int tmpTemperatureRx = dataBuffer[7] & 0xFF;
                            if (this.pickerParameters.isFilterEnabled && (tmpPackageLoss <= -1 || tmpVoltageRx <= -1 || tmpVoltageRx >= 100 || tmpTemperatureRx >= 120)) break;
                            points[0] = 0;
                            points[1] = (dataBuffer[9] & 0xFF) * 1000;
                            points[2] = (dataBuffer[5] & 0xFF) * 1000;
                            points[3] = tmpPackageLoss * 1000;
                            points[4] = (dataBuffer[13] & 0xFF) * -1000;
                            points[5] = (dataBuffer[8] & 0xFF) * -1000;
                            points[6] = tmpVoltageRx * 1000;
                            points[7] = (tmpTemperatureRx - 20) * 1000;
                            points[8] = (dataBuffer[10] & 0xFF) * 1000;
                            return points;
                        }
                        case -119: {
                            if (dataBuffer.length != 57) break;
                            points[0] = (dataBuffer[9] & 0xFF) * 1000;
                            short tmpHeight = DataParser.parse2Short((byte[])dataBuffer, (int)16);
                            if (!this.pickerParameters.isFilterEnabled || tmpHeight > 10 && tmpHeight < 5000) {
                                points[1] = tmpHeight * 1000;
                                points[2] = (DataParser.parse2Short((byte[])dataBuffer, (int)22) - 30000) * 10;
                            }
                            short tmpClimb3 = DataParser.parse2Short((byte[])dataBuffer, (int)24);
                            short tmpClimb10 = DataParser.parse2Short((byte[])dataBuffer, (int)26);
                            if (!this.pickerParameters.isFilterEnabled || tmpClimb3 > 20000 && tmpClimb10 > 20000 && tmpClimb3 < 40000 && tmpClimb10 < 40000) {
                                points[3] = tmpClimb3 * 1000;
                                points[4] = tmpClimb10 * 1000;
                            }
                            points[5] = (dataBuffer[6] & 0xFF) * 1000;
                            points[6] = (dataBuffer[7] & 0xFF) * 1000;
                            return points;
                        }
                        case -118: {
                            if (dataBuffer.length != 57) break;
                            short tmpLatitude = DataParser.parse2Short((byte[])dataBuffer, (int)20);
                            short tmpLongitude = DataParser.parse2Short((byte[])dataBuffer, (int)25);
                            short tmpHeight = DataParser.parse2Short((byte[])dataBuffer, (int)31);
                            int tmpClimb3 = dataBuffer[35] & 0xFF;
                            if (this.pickerParameters.isFilterEnabled && (tmpLatitude != tmpLongitude && tmpLatitude <= 0 || tmpHeight <= 10 || tmpHeight >= 5000 || tmpClimb3 <= 80)) break;
                            points[0] = (dataBuffer[9] & 0xFF) * 1000;
                            points[1] = DataParser.parse2Short((byte[])dataBuffer, (int)20) * 10000 + DataParser.parse2Short((byte[])dataBuffer, (int)22);
                            points[1] = dataBuffer[19] == 1 ? -1 * points[1] : points[1];
                            points[2] = tmpLongitude * 10000 + DataParser.parse2Short((byte[])dataBuffer, (int)27);
                            points[2] = dataBuffer[24] == 1 ? -1 * points[2] : points[2];
                            points[3] = tmpHeight * 1000;
                            points[4] = DataParser.parse2Short((byte[])dataBuffer, (int)33) * 1000;
                            points[5] = tmpClimb3 * 1000;
                            points[6] = DataParser.parse2Short((byte[])dataBuffer, (int)17) * 1000;
                            points[7] = DataParser.parse2Short((byte[])dataBuffer, (int)29) * 1000;
                            points[8] = (dataBuffer[38] & 0xFF) * 1000;
                            points[9] = 0;
                            points[10] = (dataBuffer[6] & 0xFF) * 1000;
                            points[11] = (dataBuffer[7] & 0xFF) * 1000;
                            points[12] = (dataBuffer[36] & 0xFF) * 1000;
                            switch (dataBuffer[37]) {
                                case 45: {
                                    points[13] = 0;
                                    break;
                                }
                                case 50: {
                                    points[13] = 2000;
                                    break;
                                }
                                case 51: {
                                    points[13] = 3000;
                                    break;
                                }
                                case 68: {
                                    points[13] = 4000;
                                    break;
                                }
                                default: {
                                    try {
                                        points[13] = Integer.valueOf(String.format("%c", dataBuffer[37])) * 1000;
                                        break;
                                    }
                                    catch (NumberFormatException e1) {
                                        points[13] = 1000;
                                    }
                                }
                            }
                            points[14] = (dataBuffer[14] & 0xFF) * 1000;
                            points[15] = (dataBuffer[38] & 0xFF) * 1000;
                            if (log.isLoggable(gde.log.Level.INFO)) {
                                log.log(gde.log.Level.INFO, StringHelper.byte2Hex2CharString((byte[])dataBuffer, (int)39, (int)dataBuffer.length));
                                if (dataBuffer[41] > 40 && dataBuffer[41] <= 100 && dataBuffer[47] > 0 && dataBuffer[47] <= 100) {
                                    log.log(gde.log.Level.INFO, String.format("Sparrow: Voltage GU = %d; servo pulse = %d", dataBuffer[41] * 100, dataBuffer[47] * 1000));
                                }
                                if (dataBuffer[41] == 0 && dataBuffer[39] > -120 && dataBuffer[39] <= 120) {
                                    log.log(gde.log.Level.INFO, String.format("SM GPS-Logger: servo pulse = %d; not used = %d", dataBuffer[39] * 1000, dataBuffer[41]));
                                }
                            }
                            if (dataBuffer[41] > 40 && dataBuffer[41] <= 100 && dataBuffer[47] > 0 && dataBuffer[47] <= 100) {
                                points[16] = dataBuffer[47] * 1000;
                                points[17] = 0;
                                points[18] = dataBuffer[41] * 100;
                                points[19] = dataBuffer[42] * 10000000 + dataBuffer[43] * 100000 + dataBuffer[44] * 1000 + dataBuffer[45] * 10;
                                points[20] = ((dataBuffer[48] - 48) * 1000000 + (dataBuffer[50] - 48) * 10000 + (dataBuffer[49] - 48) * 100) * 10;
                                points[21] = DataParser.parse2Short((byte[])dataBuffer, (int)39) * 1000;
                                points[22] = (dataBuffer[46] & 0xFF) * 1000;
                                points[23] = 4000;
                                return points;
                            }
                            if (dataBuffer[41] != 0 || dataBuffer[39] <= -120 || dataBuffer[39] > 120) break;
                            points[16] = dataBuffer[39] * 1000;
                            points[17] = dataBuffer[40] * 1000;
                            points[18] = dataBuffer[41] * 1000;
                            points[19] = DataParser.parse2Short((byte[])dataBuffer, (int)42) * 1000;
                            points[20] = DataParser.parse2Short((byte[])dataBuffer, (int)44) * 1000;
                            points[21] = DataParser.parse2Short((byte[])dataBuffer, (int)46) * 1000;
                            points[22] = (dataBuffer[48] & 0xFF) * 1000;
                            points[23] = 125000;
                            return points;
                        }
                        case -115: {
                            if (dataBuffer.length != 57) break;
                            short tmpVoltage = DataParser.parse2Short((byte[])dataBuffer, (int)40);
                            short tmpCapacity = DataParser.parse2Short((byte[])dataBuffer, (int)42);
                            short tmpHeight = DataParser.parse2Short((byte[])dataBuffer, (int)33);
                            int tmpClimb3 = dataBuffer[37] & 0xFF;
                            short tmpVoltage1 = DataParser.parse2Short((byte[])dataBuffer, (int)22);
                            short tmpVoltage2 = DataParser.parse2Short((byte[])dataBuffer, (int)24);
                            points[0] = (dataBuffer[9] & 0xFF) * 1000;
                            if (this.pickerParameters.isFilterEnabled && (tmpClimb3 <= 30 || tmpHeight <= 10 || tmpHeight >= 5000 || Math.abs(tmpVoltage1) >= 600 || Math.abs(tmpVoltage2) >= 600)) break;
                            points[1] = tmpVoltage * 1000;
                            points[2] = DataParser.parse2Short((byte[])dataBuffer, (int)38) * 1000;
                            points[3] = tmpCapacity * 1000;
                            points[4] = Double.valueOf((double)points[1] / 1000.0 * (double)points[2]).intValue();
                            if (tmpVoltage > 0) {
                                for (int j = 0; j < 6; ++j) {
                                    int tmpCellVoltage = dataBuffer[16 + j] & 0xFF;
                                    int n = points[j + 6] = tmpCellVoltage > 0 ? tmpCellVoltage * 1000 : points[j + 6];
                                    if (points[j + 6] <= 0) continue;
                                    maxVotage = points[j + 6] > maxVotage ? points[j + 6] : maxVotage;
                                    minVotage = points[j + 6] < minVotage ? points[j + 6] : minVotage;
                                }
                                points[5] = (maxVotage != Integer.MIN_VALUE && minVotage != Integer.MAX_VALUE ? maxVotage - minVotage : 0) * 10;
                            }
                            points[12] = DataParser.parse2Short((byte[])dataBuffer, (int)31) * 1000;
                            points[13] = tmpHeight * 1000;
                            points[14] = DataParser.parse2Short((byte[])dataBuffer, (int)35) * 1000;
                            points[15] = tmpClimb3 * 1000;
                            points[16] = DataParser.parse2Short((byte[])dataBuffer, (int)29) * 1000;
                            points[17] = tmpVoltage1 * 1000;
                            points[18] = tmpVoltage2 * 1000;
                            points[19] = ((dataBuffer[26] & 0xFF) - 20) * 1000;
                            points[20] = ((dataBuffer[27] & 0xFF) - 20) * 1000;
                            return points;
                        }
                        case -114: {
                            if (dataBuffer.length != 57) break;
                            short tmpVoltage = DataParser.parse2Short((byte[])dataBuffer, (int)40);
                            short tmpCapacity = DataParser.parse2Short((byte[])dataBuffer, (int)42);
                            short tmpHeight = DataParser.parse2Short((byte[])dataBuffer, (int)36);
                            int tmpClimb3 = dataBuffer[46] & 0xFF;
                            short tmpVoltage1 = DataParser.parse2Short((byte[])dataBuffer, (int)30);
                            short tmpVoltage2 = DataParser.parse2Short((byte[])dataBuffer, (int)32);
                            points[0] = (dataBuffer[9] & 0xFF) * 1000;
                            if (this.pickerParameters.isFilterEnabled && (tmpClimb3 <= 30 || tmpHeight <= 10 || tmpHeight >= 5000 || Math.abs(tmpVoltage1) >= 600 || Math.abs(tmpVoltage2) >= 600)) break;
                            points[1] = tmpVoltage * 1000;
                            points[2] = DataParser.parse2Short((byte[])dataBuffer, (int)38) * 1000;
                            points[3] = tmpCapacity * 1000;
                            points[4] = Double.valueOf((double)points[1] / 1000.0 * (double)points[2]).intValue();
                            if (tmpVoltage > 0) {
                                for (int j = 0; j < 14; ++j) {
                                    int tmpCellVoltage = dataBuffer[16 + j] & 0xFF;
                                    int n = points[j + 6] = tmpCellVoltage > 0 ? tmpCellVoltage * 1000 : points[j + 6];
                                    if (points[j + 6] <= 0) continue;
                                    maxVotage = points[j + 6] > maxVotage ? points[j + 6] : maxVotage;
                                    minVotage = points[j + 6] < minVotage ? points[j + 6] : minVotage;
                                }
                                points[5] = (maxVotage != Integer.MIN_VALUE && minVotage != Integer.MAX_VALUE ? maxVotage - minVotage : 0) * 10;
                            }
                            points[20] = tmpHeight * 1000;
                            points[21] = DataParser.parse2Short((byte[])dataBuffer, (int)44) * 1000;
                            points[22] = tmpClimb3 * 1000;
                            points[23] = tmpVoltage1 * 1000;
                            points[24] = tmpVoltage2 * 1000;
                            points[25] = ((dataBuffer[34] & 0xFF) - 20) * 1000;
                            points[26] = ((dataBuffer[35] & 0xFF) - 20) * 1000;
                            points[27] = DataParser.parse2Short((byte[])dataBuffer, (int)47) * 1000;
                            return points;
                        }
                        case -116: {
                            if (dataBuffer.length != 57) break;
                            points[0] = (dataBuffer[9] & 0xFF) * 1000;
                            short tmpVoltage = DataParser.parse2Short((byte[])dataBuffer, (int)16);
                            short tmpCurrent = DataParser.parse2Short((byte[])dataBuffer, (int)24);
                            short tmpCapacity = DataParser.parse2Short((byte[])dataBuffer, (int)20);
                            short tmpRevolution = DataParser.parse2Short((byte[])dataBuffer, (int)28);
                            int tmpTemperatureFet = (dataBuffer[35] & 0xFF) + 20;
                            if (this.pickerParameters.isFilterEnabled && (tmpVoltage <= 0 || tmpVoltage >= 1000 || tmpCurrent >= 4000 || tmpCurrent <= -10 || tmpRevolution <= -1 || tmpRevolution >= 20000 || points[6] != 0 && points[6] / 1000 - tmpTemperatureFet > 20)) break;
                            points[1] = tmpVoltage * 1000;
                            points[2] = tmpCurrent * 1000;
                            points[3] = tmpCapacity * 1000;
                            points[4] = Double.valueOf((double)points[1] / 1000.0 * (double)points[2]).intValue();
                            points[5] = tmpRevolution * 1000;
                            points[6] = tmpTemperatureFet * 1000;
                        }
                    }
                    return points;
                }
                case 2: {
                    switch (dataBuffer[0]) {
                        case 52: {
                            if (dataBuffer.length < 21) return points;
                            short tmpPackageLoss = DataParser.parse2Short((byte[])dataBuffer, (int)12);
                            int tmpVoltageRx = dataBuffer[15] & 0xFF;
                            short tmpTemperatureRx = DataParser.parse2Short((byte[])dataBuffer, (int)10);
                            if (this.pickerParameters.isFilterEnabled && (tmpPackageLoss <= -1 || tmpVoltageRx <= -1 || tmpVoltageRx >= 100 || tmpTemperatureRx >= 100)) return points;
                            this.pickerParameters.reverseChannelPackageLossCounter.add((dataBuffer[5] & 0xFF) == 0 && (dataBuffer[4] & 0xFF) == 0 ? 0 : 1);
                            points[0] = this.pickerParameters.reverseChannelPackageLossCounter.getPercentage() * 1000;
                            points[1] = (dataBuffer[17] & 0xFF) * 1000;
                            points[2] = (dataBuffer[14] & 0xFF) * 1000;
                            points[3] = tmpPackageLoss * 1000;
                            points[4] = (dataBuffer[5] & 0xFF) * -1000;
                            points[5] = (dataBuffer[4] & 0xFF) * -1000;
                            points[6] = tmpVoltageRx * 1000;
                            points[7] = tmpTemperatureRx * 1000;
                            points[8] = (dataBuffer[18] & 0xFF) * 1000;
                            break block2;
                        }
                        case 55: {
                            if (dataBuffer.length < 25) return points;
                            points[0] = (dataBuffer[3] & 0xFF) * 1000;
                            int tmpHeight = DataParser.parse2Short((byte[])dataBuffer, (int)10) + 500;
                            if (!this.pickerParameters.isFilterEnabled || tmpHeight > 10 && tmpHeight < 5000) {
                                points[1] = tmpHeight * 1000;
                                points[2] = DataParser.parse2Short((byte[])dataBuffer, (int)16) * 1000;
                            }
                            int tmpClimb3 = DataParser.parse2Short((byte[])dataBuffer, (int)18) + 30000;
                            int tmpClimb10 = DataParser.parse2Short((byte[])dataBuffer, (int)20) + 30000;
                            if (!this.pickerParameters.isFilterEnabled || tmpClimb3 > 20000 && tmpClimb10 > 20000 && tmpClimb3 < 40000 && tmpClimb10 < 40000) {
                                points[3] = tmpClimb3 * 1000;
                                points[4] = tmpClimb10 * 1000;
                            }
                            points[5] = dataBuffer[4] * 1000;
                            points[6] = (dataBuffer[5] + 20) * 1000;
                            break block85;
                        }
                        case 56: {
                            if (dataBuffer.length < 46) return points;
                            short tmpLatitude = DataParser.parse2Short((byte[])dataBuffer, (int)16);
                            short tmpLongitude = DataParser.parse2Short((byte[])dataBuffer, (int)20);
                            int tmpHeight = DataParser.parse2Short((byte[])dataBuffer, (int)14) + 500;
                            int tmpClimb3 = dataBuffer[30] + 120;
                            if (this.pickerParameters.isFilterEnabled && (tmpLatitude != tmpLongitude && tmpLatitude <= 0 || tmpHeight <= 10 || tmpHeight >= 5000 || tmpClimb3 <= 80)) return points;
                            points[0] = (dataBuffer[3] & 0xFF) * 1000;
                            points[1] = tmpLatitude * 10000 + DataParser.parse2Short((byte[])dataBuffer, (int)18);
                            points[1] = dataBuffer[26] == 1 ? -1 * points[1] : points[1];
                            points[2] = tmpLongitude * 10000 + DataParser.parse2Short((byte[])dataBuffer, (int)22);
                            points[2] = dataBuffer[27] == 1 ? -1 * points[2] : points[2];
                            points[3] = tmpHeight * 1000;
                            points[4] = (DataParser.parse2Short((byte[])dataBuffer, (int)28) + 30000) * 1000;
                            points[5] = tmpClimb3 * 1000;
                            points[6] = DataParser.parse2Short((byte[])dataBuffer, (int)10) * 1000;
                            points[7] = DataParser.parse2Short((byte[])dataBuffer, (int)12) * 1000;
                            points[8] = DataParser.parse2Short((byte[])dataBuffer, (int)24) * 500;
                            points[9] = 0;
                            points[10] = dataBuffer[4] * 1000;
                            points[11] = (dataBuffer[5] + 20) * 1000;
                            points[12] = (dataBuffer[32] & 0xFF) * 1000;
                            switch (dataBuffer[33]) {
                                case 45: {
                                    points[13] = 0;
                                    break;
                                }
                                case 50: {
                                    points[13] = 2000;
                                    break;
                                }
                                case 51: {
                                    points[13] = 3000;
                                    break;
                                }
                                case 68: {
                                    points[13] = 4000;
                                    break;
                                }
                                default: {
                                    try {
                                        points[13] = Integer.valueOf(String.format("%c", dataBuffer[33])) * 1000;
                                        break;
                                    }
                                    catch (NumberFormatException e1) {
                                        points[13] = 1000;
                                    }
                                }
                            }
                            points[14] = (dataBuffer[1] & 0xFF) * 1000;
                            points[15] = DataParser.parse2Short((byte[])dataBuffer, (int)34) * 1000;
                            if (log.isLoggable(gde.log.Level.INFO)) {
                                log.log(gde.log.Level.INFO, StringHelper.byte2Hex2CharString((byte[])dataBuffer, (int)36, (int)dataBuffer.length));
                                if (dataBuffer[38] > 40 && dataBuffer[38] <= 100 && dataBuffer[45] > 0 && dataBuffer[45] <= 100) {
                                    log.log(gde.log.Level.INFO, String.format("Sparrow: Voltage GU = %d; servo pulse = %d", dataBuffer[38] * 100, dataBuffer[45] * 1000));
                                }
                                if (dataBuffer[38] == 0 && dataBuffer[36] > -120 && dataBuffer[36] <= 120) {
                                    log.log(gde.log.Level.INFO, String.format("SM GPS-Logger: servo pulse = %d; not used = %d", dataBuffer[36] * 1000, dataBuffer[38]));
                                }
                            }
                            if (dataBuffer[38] > 40 && dataBuffer[38] <= 100 && dataBuffer[45] > 0 && dataBuffer[45] <= 100) {
                                points[16] = dataBuffer[45] * 1000;
                                points[17] = 0;
                                points[18] = dataBuffer[38] * 100;
                                points[19] = dataBuffer[40] * 10000000 + dataBuffer[41] * 100000 + dataBuffer[42] * 1000 + dataBuffer[43] * 10;
                                points[20] = ((dataBuffer[46] - 48) * 1000000 + (dataBuffer[48] - 48) * 10000 + (dataBuffer[47] - 48) * 100) * 10;
                                points[21] = DataParser.parse2Short((byte[])dataBuffer, (int)39) * 1000;
                                points[22] = (dataBuffer[44] & 0xFF) * 1000;
                                points[23] = 4000;
                                break block2;
                            }
                            if (dataBuffer[38] != 0 || dataBuffer[36] <= -120 || dataBuffer[36] > 120) return points;
                            points[16] = dataBuffer[36] * 1000;
                            points[17] = dataBuffer[37] * 1000;
                            points[18] = dataBuffer[38] * 1000;
                            points[19] = DataParser.parse2Short((byte[])dataBuffer, (int)40) * 1000;
                            points[20] = DataParser.parse2Short((byte[])dataBuffer, (int)42) * 1000;
                            points[21] = DataParser.parse2Short((byte[])dataBuffer, (int)44) * 1000;
                            points[22] = (dataBuffer[46] & 0xFF) * 1000;
                            points[23] = 125000;
                            break block2;
                        }
                        case 53: {
                            if (dataBuffer.length < 49) return points;
                            short tmpVoltage = DataParser.parse2Short((byte[])dataBuffer, (int)36);
                            short tmpCapacity = DataParser.parse2Short((byte[])dataBuffer, (int)38);
                            int tmpHeight = DataParser.parse2Short((byte[])dataBuffer, (int)32) + 500;
                            int tmpClimb3 = dataBuffer[44] + 120;
                            short tmpVoltage1 = DataParser.parse2Short((byte[])dataBuffer, (int)22);
                            short tmpVoltage2 = DataParser.parse2Short((byte[])dataBuffer, (int)24);
                            points[0] = (dataBuffer[3] & 0xFF) * 1000;
                            if (this.pickerParameters.isFilterEnabled && (tmpClimb3 <= 30 || tmpHeight <= 10 || tmpHeight >= 5000 || Math.abs(tmpVoltage1) >= 600 || Math.abs(tmpVoltage2) >= 600)) return points;
                            points[1] = tmpVoltage * 1000;
                            points[2] = DataParser.parse2Short((byte[])dataBuffer, (int)34) * 1000;
                            points[3] = tmpCapacity * 1000;
                            points[4] = Double.valueOf((double)points[1] / 1000.0 * (double)points[2]).intValue();
                            if (tmpVoltage > 0) {
                                int i = 0;
                                int j = 0;
                                while (i < 6) {
                                    short tmpCellVoltage = DataParser.parse2Short((byte[])dataBuffer, (int)(j + 10));
                                    int n = points[i + 6] = tmpCellVoltage > 0 ? tmpCellVoltage * 500 : points[i + 6];
                                    if (points[i + 6] > 0) {
                                        maxVotage = points[i + 6] > maxVotage ? points[i + 6] : maxVotage;
                                        minVotage = points[i + 6] < minVotage ? points[i + 6] : minVotage;
                                    }
                                    ++i;
                                    j += 2;
                                }
                                points[5] = (maxVotage != Integer.MIN_VALUE && minVotage != Integer.MAX_VALUE ? maxVotage - minVotage : 0) * 10;
                            }
                            points[12] = DataParser.parse2Short((byte[])dataBuffer, (int)30) * 1000;
                            points[13] = tmpHeight * 1000;
                            points[14] = (DataParser.parse2Short((byte[])dataBuffer, (int)42) + 30000) * 1000;
                            points[15] = tmpClimb3 * 1000;
                            points[16] = DataParser.parse2Short((byte[])dataBuffer, (int)40) * 1000;
                            points[17] = tmpVoltage1 * 1000;
                            points[18] = tmpVoltage2 * 1000;
                            points[19] = DataParser.parse2Short((byte[])dataBuffer, (int)26) * 1000;
                            points[20] = DataParser.parse2Short((byte[])dataBuffer, (int)28) * 1000;
                            break block2;
                        }
                        case 54: {
                            if (dataBuffer.length < 60) return points;
                            short tmpVoltage = DataParser.parse2Short((byte[])dataBuffer, (int)50);
                            short tmpCapacity = DataParser.parse2Short((byte[])dataBuffer, (int)52);
                            int tmpHeight = DataParser.parse2Short((byte[])dataBuffer, (int)46) + 500;
                            int tmpClimb3 = dataBuffer[56] + 120;
                            short tmpVoltage1 = DataParser.parse2Short((byte[])dataBuffer, (int)38);
                            short tmpVoltage2 = DataParser.parse2Short((byte[])dataBuffer, (int)40);
                            points[0] = (dataBuffer[3] & 0xFF) * 1000;
                            if (this.pickerParameters.isFilterEnabled && (tmpClimb3 <= 30 || tmpHeight <= 10 || tmpHeight >= 5000 || Math.abs(tmpVoltage1) >= 600 || Math.abs(tmpVoltage2) >= 600)) return points;
                            points[1] = DataParser.parse2Short((byte[])dataBuffer, (int)50) * 1000;
                            points[2] = DataParser.parse2Short((byte[])dataBuffer, (int)48) * 1000;
                            points[3] = tmpCapacity * 1000;
                            points[4] = Double.valueOf((double)points[1] / 1000.0 * (double)points[2]).intValue();
                            if (tmpVoltage > 0) {
                                int i = 0;
                                int j = 0;
                                while (i < 14) {
                                    short tmpCellVoltage = DataParser.parse2Short((byte[])dataBuffer, (int)(j + 10));
                                    int n = points[i + 6] = tmpCellVoltage > 0 ? tmpCellVoltage * 500 : points[i + 6];
                                    if (points[i + 6] > 0) {
                                        maxVotage = points[i + 6] > maxVotage ? points[i + 6] : maxVotage;
                                        minVotage = points[i + 6] < minVotage ? points[i + 6] : minVotage;
                                    }
                                    ++i;
                                    j += 2;
                                }
                                points[5] = (maxVotage != Integer.MIN_VALUE && minVotage != Integer.MAX_VALUE ? maxVotage - minVotage : 0) * 10;
                            }
                            points[20] = tmpHeight * 1000;
                            points[21] = (DataParser.parse2Short((byte[])dataBuffer, (int)54) + 30000) * 1000;
                            points[22] = (dataBuffer[46] + 120) * 1000;
                            points[23] = tmpVoltage1 * 1000;
                            points[24] = tmpVoltage2 * 1000;
                            points[25] = DataParser.parse2Short((byte[])dataBuffer, (int)42) * 1000;
                            points[26] = DataParser.parse2Short((byte[])dataBuffer, (int)44) * 1000;
                            points[27] = DataParser.parse2Short((byte[])dataBuffer, (int)58) * 1000;
                            break block2;
                        }
                        case 57: {
                            if (dataBuffer.length < 34) return points;
                            points[0] = (dataBuffer[3] & 0xFF) * 1000;
                            short tmpVoltage = DataParser.parse2Short((byte[])dataBuffer, (int)10);
                            short tmpCurrent = DataParser.parse2Short((byte[])dataBuffer, (int)14);
                            short tmpCapacity = DataParser.parse2Short((byte[])dataBuffer, (int)22);
                            short tmpRevolution = DataParser.parse2Short((byte[])dataBuffer, (int)18);
                            short tmpTemperatureFet = DataParser.parse2Short((byte[])dataBuffer, (int)24);
                            if (this.pickerParameters.isFilterEnabled && (tmpVoltage <= 0 || tmpVoltage >= 1000 || tmpCurrent >= 4000 || tmpCurrent <= -10 || tmpRevolution <= -1 || tmpRevolution >= 20000 || points[6] != 0 && points[6] / 1000 - tmpTemperatureFet > 20)) return points;
                            points[1] = tmpVoltage * 1000;
                            points[2] = tmpCurrent * 1000;
                            points[3] = tmpCapacity * 1000;
                            points[4] = Double.valueOf((double)points[1] / 1000.0 * (double)points[2]).intValue();
                            points[5] = tmpRevolution * 1000;
                            points[6] = tmpTemperatureFet * 1000;
                            break block2;
                        }
                        case 64: {
                            if (dataBuffer.length < 74 || !this.pickerParameters.isChannelsChannelEnabled) return points;
                            int i = 0;
                            int j = 0;
                            while (i < 32) {
                                points[3 + i] = (DataParser.parse2Short((byte[])dataBuffer, (int)(8 + j)) / 2 + 1500) * 1000;
                                ++i;
                                j += 2;
                            }
                            if (!log.isLoggable(gde.log.Level.FINE)) return points;
                            StringBuffer sb = new StringBuffer();
                            int i2 = 0;
                            int j2 = 0;
                            while (i2 < 32) {
                                sb.append(String.format("%2d = %4d; ", i2 + 1, DataParser.parse2Short((byte[])dataBuffer, (int)(8 + j2)) / 16 + 50));
                                ++i2;
                                j2 += 2;
                            }
                            log.log(gde.log.Level.FINE, sb.toString());
                        }
                    }
                }
            }
        }
        return points;
    }

    public void addDataBufferAsRawDataPoints(RecordSet recordSet, byte[] dataBuffer, int recordDataSize, boolean doUpdateProgressBar) throws DataInconsitsentException {
        int dataBufferSize = 4 * recordSet.getNoneCalculationRecordNames().length;
        int[] points = new int[recordSet.size()];
        String sThreadId = String.format("%06d", Thread.currentThread().getId());
        int progressCycle = 1;
        if (doUpdateProgressBar) {
            this.application.setProgress(progressCycle, sThreadId);
        }
        int timeStampBufferSize = 4 * recordDataSize;
        int index = 0;
        for (int i = 0; i < recordDataSize; ++i) {
            index = i * dataBufferSize + timeStampBufferSize;
            if (log.isLoggable(Level.FINER)) {
                log.log(Level.FINER, i + " i*dataBufferSize+timeStampBufferSize = " + index);
            }
            for (int j = 0; j < points.length; ++j) {
                points[j] = ((dataBuffer[0 + j * 4 + index] & 0xFF) << 24) + ((dataBuffer[1 + j * 4 + index] & 0xFF) << 16) + ((dataBuffer[2 + j * 4 + index] & 0xFF) << 8) + ((dataBuffer[3 + j * 4 + index] & 0xFF) << 0);
            }
            recordSet.addPoints(points, (double)(((dataBuffer[0 + i * 4] & 0xFF) << 24) + ((dataBuffer[1 + i * 4] & 0xFF) << 16) + ((dataBuffer[2 + i * 4] & 0xFF) << 8) + ((dataBuffer[3 + i * 4] & 0xFF) << 0)) / 10.0);
            if (!doUpdateProgressBar || i % 50 != 0) continue;
            this.application.setProgress(++progressCycle * 5000 / recordDataSize, sThreadId);
        }
        if (doUpdateProgressBar) {
            this.application.setProgress(100, sThreadId);
        }
        recordSet.syncScaleOfSyncableRecords();
    }

    public void addDataBufferAsRawDataPoints(RecordSet recordSet, byte[] dataBuffer, int recordDataSize, int[] maxPoints, int[] minPoints, Analyzer analyzer) throws DataInconsitsentException {
        if (maxPoints.length != minPoints.length || maxPoints.length == 0) {
            throw new DataInconsitsentException("number of max/min points differs: " + maxPoints.length + "/" + minPoints.length);
        }
        int recordTimespan_ms = 10;
        UniversalSampler histoRandomSample = UniversalSampler.createSampler((int)recordSet.getChannelConfigNumber(), (int[])maxPoints, (int[])minPoints, (int)recordTimespan_ms, (Analyzer)analyzer);
        int[] points = histoRandomSample.getPoints();
        IntBuffer intBuffer = ByteBuffer.wrap(dataBuffer).asIntBuffer();
        int pointsLength = points.length;
        for (int i = 0; i < recordDataSize; ++i) {
            int iOffset = i * pointsLength + recordDataSize;
            for (int j = 0; j < pointsLength; ++j) {
                points[j] = intBuffer.get(j + iOffset);
            }
            int timeStep_ms = intBuffer.get(i) / 10;
            if (!histoRandomSample.capturePoints((long)timeStep_ms)) continue;
            recordSet.addPoints(points, (double)timeStep_ms);
        }
        recordSet.syncScaleOfSyncableRecords();
        if (log.isLoggable(gde.log.Level.FINE)) {
            log.log(gde.log.Level.INFO, String.format("%s processed: %,9d", recordSet.getChannelConfigName(), recordDataSize));
        }
    }

    public boolean isHistoImportSupported() {
        return ((Object)((Object)this)).getClass().equals(HoTTAdapter.class) && !((Object)((Object)this)).getClass().equals(HoTTAdapterD.class) && !((Object)((Object)this)).getClass().equals(HoTTAdapterM.class) && !((Object)((Object)this)).getClass().equals(HoTTAdapterX.class) && !((Object)((Object)this)).getClass().equals(HoTTViewer.class);
    }

    private void setSupportedImportExtentions() {
        this.importExtentions = this.isHistoImportSupported() ? Arrays.stream(this.getDataBlockPreferredFileExtention().split(",|;")).map(s -> s.substring(s.lastIndexOf(46))).map(e -> e.toLowerCase()).collect(Collectors.toList()) : new ArrayList<String>();
    }

    public List<String> getSupportedImportExtentions() {
        if (this.importExtentions == null) {
            this.setSupportedImportExtentions();
        }
        return this.importExtentions;
    }

    public void getRecordSetFromImportFile(Supplier<InputStream> inputStream, VaultCollector truss, Analyzer analyzer) throws DataInconsitsentException, IOException, DataTypeException {
        String fileEnding = PathUtils.getFileExtention((String)truss.getVault().getLoadFilePath());
        if (".bin".equals(fileEnding)) {
            HoTTbinHistoReader histoReader = new HoTTbinHistoReader(new PickerParameters(analyzer));
            histoReader.read(inputStream, truss);
        } else if (".log".equals(fileEnding)) {
            HashMap<String, String> infoHeader = null;
            try (BufferedInputStream info_in = new BufferedInputStream(inputStream.get());){
                infoHeader = new HoTTbinReader.InfoParser(s -> {}).getFileInfo(info_in, truss.getVault().getLoadFilePath(), truss.getVault().getLogFileLength());
                if (infoHeader == null || infoHeader.isEmpty()) {
                    return;
                }
                EnumSet<Sensor> detectedSensors = Sensor.getSetFromDetected(infoHeader.get(DETECTED_SENSOR));
                if (!Sensor.getChannelNumbers(detectedSensors).contains(truss.getVault().getVaultChannelNumber())) {
                    return;
                }
                if (Integer.parseInt(infoHeader.get(LOG_COUNT)) <= 1400) {
                    return;
                }
                HoTTlogHistoReader histoReader = new HoTTlogHistoReader(new PickerParameters(analyzer), infoHeader);
                histoReader.read(inputStream, truss);
            }
        } else {
            throw new UnsupportedOperationException(truss.getVault().getLoadFilePath());
        }
    }

    public String[] prepareDataTableRow(RecordSet recordSet, String[] dataTableRow, int rowIndex) {
        try {
            int channel = recordSet.getChannelConfigNumber();
            int index = 0;
            for (Record record : recordSet.getVisibleAndDisplayableRecordsForTable()) {
                int ordinal = record.getOrdinal();
                dataTableRow[index + 1] = channel == 1 && ordinal >= 0 && ordinal <= 5 ? String.format("%.0f", (double)record.realGet(rowIndex).intValue() / 1000.0) : (channel == 6 && ordinal == 38 ? (record.realGet(rowIndex) == 0 ? "" : String.format("'%c'", record.realGet(rowIndex) / 1000 + 64)) : (channel == 3 ? (ordinal == 19 && record.getUnit().endsWith("HH:mm:ss.SSS") ? HoTTAdapter.getFormattedTime(record.realGet(rowIndex)) : (ordinal == 20 && record.getUnit().endsWith("yy-MM-dd") ? HoTTAdapter.getFormattedDate(record.realGet(rowIndex) / 10) : record.getFormattedTableValue(rowIndex))) : record.getFormattedTableValue(rowIndex)));
                ++index;
            }
        }
        catch (RuntimeException e) {
            log.log(Level.SEVERE, e.getMessage(), e);
        }
        return dataTableRow;
    }

    public static String getFormattedTime(int timeValue) {
        int tmpHH = timeValue / 10000000;
        int tmpMM = timeValue / 100000 - tmpHH * 100;
        int tmpSS = timeValue / 1000 - tmpMM * 100 - tmpHH * 10000;
        int tmpSSS = timeValue - tmpSS * 1000 - tmpMM * 100000 - tmpHH * 10000000;
        return String.format("%02d:%02d:%02d.%03d", tmpHH, tmpMM, tmpSS, tmpSSS);
    }

    public static String getFormattedDate(int dateValue) {
        int tmpYY = dateValue / 1000000;
        int tmpMM = dateValue / 10000 - tmpYY * 100;
        int tmpDD = dateValue / 100 - tmpMM * 100 - tmpYY * 10000;
        return String.format("%02d-%02d-%02d", tmpYY, tmpMM, tmpDD);
    }

    public double translateValue(Record record, double value) {
        double factor = record.getFactor();
        double offset = record.getOffset();
        double reduction = record.getReduction();
        double newValue = 0.0;
        if (record.getAbstractParent().getChannelConfigNumber() == 3 && (record.getOrdinal() == 1 || record.getOrdinal() == 2)) {
            int grad = (int)(value / 1000.0);
            double minuten = (value - (double)grad * 1000.0) / 10.0;
            newValue = (double)grad + minuten / 60.0;
        } else if (record.getAbstractParent().getChannelConfigNumber() == 6 && record.getOrdinal() >= 3 && record.getOrdinal() <= 34 && value != 0.0) {
            if (this.pickerParameters.isChannelPercentEnabled) {
                if (!record.getUnit().equals("%")) {
                    record.setUnit("%");
                }
                factor = 0.25;
                reduction = 1500.0;
                newValue = (value - reduction) * factor + 0.001;
            } else {
                if (!record.getUnit().equals("\u00b5sec")) {
                    record.setUnit("\u00b5sec");
                }
                newValue = (value - reduction) * factor + offset;
            }
        } else {
            newValue = (value - reduction) * factor + offset;
        }
        if (log.isLoggable(gde.log.Level.FINE)) {
            log.log(gde.log.Level.FINE, "for " + record.getName() + " in value = " + value + " out value = " + newValue);
        }
        return newValue;
    }

    public double reverseTranslateValue(Record record, double value) {
        double factor = record.getFactor();
        double offset = record.getOffset();
        double reduction = record.getReduction();
        double newValue = 0.0;
        if ((record.getOrdinal() == 1 || record.getOrdinal() == 2) && record.getAbstractParent().getChannelConfigNumber() == 3) {
            int grad = (int)value;
            double minuten = (value - (double)grad * 1.0) * 60.0;
            newValue = ((double)grad + minuten / 100.0) * 1000.0;
        } else if (record.getAbstractParent().getChannelConfigNumber() == 6 && record.getOrdinal() >= 3 && record.getOrdinal() <= 34 && value != 0.0) {
            if (this.pickerParameters.isChannelPercentEnabled) {
                if (!record.getUnit().equals("%")) {
                    record.setUnit("%");
                }
                factor = 0.25;
                reduction = 1500.0;
                newValue = value / factor + reduction - 0.001;
            } else {
                if (!record.getUnit().equals("\u00b5sec")) {
                    record.setUnit("\u00b5sec");
                }
                newValue = (value - reduction) * factor;
            }
        } else {
            newValue = (value - offset) / factor + reduction;
        }
        if (log.isLoggable(gde.log.Level.FINE)) {
            log.log(gde.log.Level.FINE, "for " + record.getName() + " in value = " + value + " out value = " + newValue);
        }
        return newValue;
    }

    public void updateVisibilityStatus(RecordSet recordSet, boolean includeReasonableDataCheck) {
        int channelConfigNumber = recordSet.getChannelConfigNumber();
        int displayableCounter = 0;
        boolean configChanged = this.isChangePropery();
        for (int i = 0; i < recordSet.size(); ++i) {
            Record record = recordSet.get(i);
            if (log.isLoggable(Level.FINE)) {
                log.log(Level.FINE, record.getName() + " = " + DeviceXmlResource.getInstance().getReplacement(this.getMeasurementNames(channelConfigNumber)[i]));
            }
            MeasurementType measurement = this.getMeasurement(channelConfigNumber, i);
            if (record.isActive() && record.isActive() != measurement.isActive()) {
                record.setActive(Boolean.valueOf(measurement.isActive()));
                record.setVisible(measurement.isActive());
                record.setDisplayable(measurement.isActive());
                if (log.isLoggable(Level.FINE)) {
                    log.log(Level.FINE, "switch " + record.getName() + " to " + measurement.isActive());
                }
            }
            if (includeReasonableDataCheck) {
                record.setDisplayable(measurement.isActive() && record.hasReasonableData());
                if (log.isLoggable(Level.FINE)) {
                    log.log(Level.FINE, record.getName() + " hasReasonableData " + record.hasReasonableData());
                }
            }
            if (!record.isActive() || !record.isDisplayable()) continue;
            ++displayableCounter;
            if (!log.isLoggable(Level.FINE)) continue;
            log.log(Level.FINE, "add to displayable counter: " + record.getName());
        }
        if (log.isLoggable(Level.FINE)) {
            log.log(Level.FINE, "displayableCounter = " + displayableCounter);
        }
        recordSet.setConfiguredDisplayable(displayableCounter);
        this.setChangePropery(configChanged);
    }

    public void makeInActiveDisplayable(RecordSet recordSet) {
        this.calculateInactiveRecords(recordSet);
        recordSet.syncScaleOfSyncableRecords();
        this.updateVisibilityStatus(recordSet, true);
        this.application.updateStatisticsData();
    }

    public void calculateInactiveRecords(RecordSet recordSet) {
        if (recordSet.getChannelConfigNumber() == 3) {
            Record recordLatitude = recordSet.get(1);
            Record recordLongitude = recordSet.get(2);
            Record recordAlitude = recordSet.get(3);
            if (recordLatitude.hasReasonableData() && recordLongitude.hasReasonableData() && recordAlitude.hasReasonableData()) {
                int recordSize = recordLatitude.realSize();
                int startAltitude = recordAlitude.get(0);
                int indexGPS = 0;
                for (int i = 0; i < recordSize; ++i) {
                    if (recordLatitude.get(i) == 0 || recordLongitude.get(i) == 0) continue;
                    indexGPS = i++;
                    break;
                }
                startAltitude = recordAlitude.get(indexGPS);
                GPSHelper.calculateTripLength((IDevice)this, (RecordSet)recordSet, (int)1, (int)2, (int)3, (int)startAltitude, (int)9);
            }
        }
    }

    public HoTTAdapterDialog getDialog() {
        return this.dialog;
    }

    public String[] getUsedPropertyKeys() {
        return new String[]{IDevice.OFFSET, IDevice.FACTOR, IDevice.REDUCTION};
    }

    public void open_closeCommPort() {
        switch (this.application.getMenuBar().getSerialPortIconSet()) {
            case 2: {
                this.importDeviceData();
                break;
            }
            case 1: {
                this.serialPort.isInterruptedByUser = true;
            }
        }
    }

    protected void importDeviceData() {
        final FileDialog fd = FileUtils.getImportDirectoryFileDialog((IDevice)this, (String)Messages.getString((String)"GDE_MSGT2400"), (String)"LogData");
        Thread reader = new Thread("reader"){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                try {
                    HoTTAdapter.this.application.setPortConnected(true);
                    boolean isInitialSwitched = false;
                    for (String tmpFileName : fd.getFileNames()) {
                        String selectedImportFile = fd.getFilterPath() + "/" + tmpFileName;
                        if (!selectedImportFile.toLowerCase().endsWith(".bin") && !selectedImportFile.toLowerCase().endsWith(".log")) {
                            log.log(gde.log.Level.WARNING, String.format("skip selectedImportFile %s since it has not a supported file ending", selectedImportFile));
                        }
                        log.log(Level.FINE, "selectedImportFile = " + selectedImportFile);
                        if (fd.getFileName().length() <= 4) continue;
                        String directoryName = ObjectKeyCompliance.getUpcomingObjectKey((Path)Paths.get(selectedImportFile, new String[0]));
                        if (!directoryName.isEmpty()) {
                            ObjectKeyCompliance.createObjectKey((String)directoryName);
                        }
                        try {
                            if (selectedImportFile.toLowerCase().endsWith(".bin")) {
                                HoTTbinReader.read(selectedImportFile, new PickerParameters(HoTTAdapter.this.pickerParameters));
                            } else if (selectedImportFile.toLowerCase().endsWith(".log")) {
                                HoTTlogReader.read(selectedImportFile, new PickerParameters(HoTTAdapter.this.pickerParameters));
                            }
                            if (!isInitialSwitched) {
                                if (HoTTAdapter.this.application.getActiveChannel().getActiveRecordSet() == null) {
                                    Channel selectedChannel = Settings.getInstance().isFirstRecordSetChoice() ? (Channel)HoTTAdapter.this.channels.get((Object)1) : HoTTAdapter.this.application.getActiveChannel();
                                    HoTTbinReader.channels.switchChannel(selectedChannel.getName());
                                } else {
                                    Channel selectedChannel;
                                    String recordSetType = HoTTAdapter.this.application.getActiveChannel().getActiveRecordSet().getName().split(Pattern.quote("["))[0].split(Pattern.quote(")"))[1];
                                    Channel channel = selectedChannel = Settings.getInstance().isFirstRecordSetChoice() ? (Channel)HoTTAdapter.this.channels.get((Object)1) : HoTTAdapter.this.application.getActiveChannel();
                                    if (Settings.getInstance().isFirstRecordSetChoice()) {
                                        String lastCurrentNumber = "";
                                        String lastNameMatch = null;
                                        String[] stringArray = selectedChannel.getRecordSetNames();
                                        int n = stringArray.length;
                                        for (int i = 0; i < n; ++i) {
                                            String tmpName = stringArray[i];
                                            String currentNumber = tmpName.split(Pattern.quote(")"))[0];
                                            if (currentNumber.equals(lastCurrentNumber)) continue;
                                            lastCurrentNumber = currentNumber;
                                            lastNameMatch = tmpName;
                                        }
                                        HoTTbinReader.channels.switchChannel(selectedChannel.getName());
                                        selectedChannel.switchRecordSet(lastNameMatch);
                                    } else {
                                        String lastNameMatch = null;
                                        for (String tmpName : selectedChannel.getRecordSetNames()) {
                                            if (!tmpName.contains(recordSetType)) continue;
                                            lastNameMatch = tmpName;
                                        }
                                        HoTTbinReader.channels.switchChannel(selectedChannel.getName());
                                        selectedChannel.switchRecordSet(lastNameMatch);
                                    }
                                }
                                isInitialSwitched = true;
                            }
                            WaitTimer.delay((long)500L);
                        }
                        catch (Exception e) {
                            log.log(Level.WARNING, e.getMessage(), e);
                        }
                    }
                }
                finally {
                    HoTTAdapter.this.application.setPortConnected(false);
                }
            }
        };
        reader.start();
    }

    public void importDeviceData(final Path filePath) {
        if (!this.application.getDeviceSelectionDialog().checkDataSaved()) {
            return;
        }
        Thread reader = new Thread("reader"){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                try {
                    boolean isInitialSwitched = false;
                    HoTTAdapter.this.application.setPortConnected(true);
                    if (filePath.getFileName().toString().length() > 4) {
                        for (Channel channel : HoTTAdapter.this.channels.values()) {
                            channel.clear();
                        }
                        try {
                            if (((Object)((Object)HoTTAdapter.this)).getClass().equals(HoTTAdapter.class)) {
                                if (filePath.getFileName().toString().endsWith("bin")) {
                                    HoTTbinReader.read(filePath.toString(), new PickerParameters(HoTTAdapter.this.pickerParameters));
                                } else if (filePath.getFileName().toString().endsWith("log")) {
                                    HoTTlogReader.read(filePath.toString(), new PickerParameters(HoTTAdapter.this.pickerParameters));
                                }
                            } else if (((Object)((Object)HoTTAdapter.this)).getClass().equals(HoTTAdapter2.class)) {
                                if (filePath.getFileName().toString().endsWith("bin")) {
                                    HoTTbinReader2.read(filePath.toString(), new PickerParameters(HoTTAdapter.this.pickerParameters));
                                } else if (filePath.getFileName().toString().endsWith("log")) {
                                    HoTTlogReader2.read(filePath.toString(), new PickerParameters(HoTTAdapter.this.pickerParameters));
                                }
                            } else if (((Object)((Object)HoTTAdapter.this)).getClass().equals(HoTTAdapter2M.class)) {
                                if (filePath.getFileName().toString().endsWith("bin")) {
                                    HoTTbinReader2.read(filePath.toString(), new PickerParameters(HoTTAdapter.this.pickerParameters));
                                } else if (filePath.getFileName().toString().endsWith("log")) {
                                    HoTTlogReader2.read(filePath.toString(), new PickerParameters(HoTTAdapter.this.pickerParameters));
                                }
                            } else if (((Object)((Object)HoTTAdapter.this)).getClass().equals(HoTTAdapterD.class)) {
                                if (filePath.getFileName().toString().endsWith("bin")) {
                                    HoTTbinReaderD.read(filePath.toString(), new PickerParameters(HoTTAdapter.this.pickerParameters));
                                } else if (filePath.getFileName().toString().endsWith("log")) {
                                    HoTTlogReaderD.read(filePath.toString(), new PickerParameters(HoTTAdapter.this.pickerParameters));
                                }
                            } else if (((Object)((Object)HoTTAdapter.this)).getClass().equals(HoTTAdapterM.class)) {
                                if (filePath.getFileName().toString().endsWith("bin")) {
                                    HoTTbinReader.read(filePath.toString(), new PickerParameters(HoTTAdapter.this.pickerParameters));
                                } else if (filePath.getFileName().toString().endsWith("log")) {
                                    HoTTlogReader.read(filePath.toString(), new PickerParameters(HoTTAdapter.this.pickerParameters));
                                }
                            } else if (((Object)((Object)HoTTAdapter.this)).getClass().equals(HoTTAdapterX.class)) {
                                HoTTbinReaderX.read(filePath.toString(), new PickerParameters(HoTTAdapter.this.pickerParameters));
                            } else {
                                throw new UnsupportedOperationException();
                            }
                            if (!isInitialSwitched) {
                                Channel selectedChannel;
                                Channel channel = selectedChannel = Settings.getInstance().isFirstRecordSetChoice() ? (Channel)HoTTAdapter.this.channels.get((Object)1) : HoTTAdapter.this.application.getActiveChannel();
                                if (((Object)((Object)HoTTAdapter.this)).getClass().equals(HoTTAdapter.class) || ((Object)((Object)HoTTAdapter.this)).getClass().equals(HoTTAdapterM.class) || ((Object)((Object)HoTTAdapter.this)).getClass().equals(HoTTAdapterX.class)) {
                                    HoTTbinReader.channels.switchChannel(selectedChannel.getName());
                                } else if (((Object)((Object)HoTTAdapter.this)).getClass().equals(HoTTAdapter2.class) || ((Object)((Object)HoTTAdapter.this)).getClass().equals(HoTTAdapter2M.class)) {
                                    HoTTbinReader.channels.switchChannel(selectedChannel.getName());
                                    if (filePath.getFileName().toString().endsWith("bin")) {
                                        selectedChannel.switchRecordSet(HoTTbinReader2.recordSet.getName());
                                    } else if (filePath.getFileName().toString().endsWith("log")) {
                                        selectedChannel.switchRecordSet(HoTTlogReader2.recordSet.getName());
                                    }
                                } else if (((Object)((Object)HoTTAdapter.this)).getClass().equals(HoTTAdapterD.class)) {
                                    HoTTbinReader.channels.switchChannel(selectedChannel.getName());
                                    if (filePath.getFileName().toString().endsWith("bin")) {
                                        selectedChannel.switchRecordSet(HoTTbinReaderD.recordSet.getName());
                                    } else if (filePath.getFileName().toString().endsWith("log")) {
                                        selectedChannel.switchRecordSet(HoTTlogReaderD.recordSet.getName());
                                    }
                                } else {
                                    throw new UnsupportedOperationException();
                                }
                                isInitialSwitched = true;
                            }
                            WaitTimer.delay((long)500L);
                        }
                        catch (Exception e) {
                            log.log(Level.WARNING, e.getMessage(), e);
                        }
                    }
                }
                finally {
                    HoTTAdapter.this.application.setPortConnected(false);
                }
            }
        };
        reader.start();
    }

    public void updateFileExportMenu(Menu exportMenue) {
        if (exportMenue.getItem(exportMenue.getItemCount() - 1).getText().equals(Messages.getString((String)"GDE_MSGT0732"))) {
            new MenuItem(exportMenue, 2);
            MenuItem convertKMZ3DRelativeItem = new MenuItem(exportMenue, 8);
            convertKMZ3DRelativeItem.setText(Messages.getString((String)"GDE_MSGT2405"));
            convertKMZ3DRelativeItem.addListener(13, new Listener(){

                public void handleEvent(Event e) {
                    log.log(Level.FINEST, "convertKMZ3DRelativeItem action performed! " + String.valueOf(e));
                    HoTTAdapter.this.export2KMZ3D(0);
                }
            });
            MenuItem convertKMZDAbsoluteItem = new MenuItem(exportMenue, 8);
            convertKMZDAbsoluteItem.setText(Messages.getString((String)"GDE_MSGT2406"));
            convertKMZDAbsoluteItem.addListener(13, new Listener(){

                public void handleEvent(Event e) {
                    log.log(Level.FINEST, "convertKMZDAbsoluteItem action performed! " + String.valueOf(e));
                    HoTTAdapter.this.export2KMZ3D(1);
                }
            });
            convertKMZDAbsoluteItem = new MenuItem(exportMenue, 8);
            convertKMZDAbsoluteItem.setText(Messages.getString((String)"GDE_MSGT2407"));
            convertKMZDAbsoluteItem.addListener(13, new Listener(){

                public void handleEvent(Event e) {
                    log.log(Level.FINEST, "convertKMZDAbsoluteItem action performed! " + String.valueOf(e));
                    HoTTAdapter.this.export2KMZ3D(2);
                }
            });
        }
    }

    public void updateFileImportMenu(Menu importMenue) {
        if (importMenue.getItem(importMenue.getItemCount() - 1).getText().equals(Messages.getString((String)"GDE_MSGT0018"))) {
            new MenuItem(importMenue, 2);
            MenuItem importDeviceLogItem = new MenuItem(importMenue, 8);
            Object[] messageParams = new String[GDE.MOD1.length + 1];
            System.arraycopy(GDE.MOD1, 0, messageParams, 1, GDE.MOD1.length);
            messageParams[0] = this.getDeviceConfiguration().getDataBlockPreferredFileExtention();
            importDeviceLogItem.setText(Messages.getString((String)"GDE_MSGT2416", (Object[])messageParams));
            importDeviceLogItem.setAccelerator(SWT.MOD1 + Messages.getAcceleratorChar((String)"GDE_MSGT2416"));
            importDeviceLogItem.addListener(13, new Listener(){

                public void handleEvent(Event e) {
                    log.log(Level.FINEST, "importDeviceLogItem action performed! " + String.valueOf(e));
                    HoTTAdapter.this.importDeviceData();
                }
            });
        }
    }

    public void export2KMZ3D(int type) {
        new FileHandler().exportFileKMZ(Messages.getString((String)"GDE_MSGT2403"), 2, 1, 3, 6, 5, 9, -1, type == 0, type == 2);
    }

    public void export2GPX(boolean isGarminExtension) {
        if (isGarminExtension) {
            new FileHandler().exportFileGPX(Messages.getString((String)"GDE_MSGT0730"), 1, 2, 3, 6, -1, -1, -1, -1, new int[]{-1, -1, -1});
        } else {
            new FileHandler().exportFileGPX(Messages.getString((String)"GDE_MSGT0730"), 1, 2, 3, 6, -1, -1, -1, -1, new int[0]);
        }
    }

    public boolean isGPSCoordinates(Record record) {
        if (this.application.getActiveChannelNumber() == 3) {
            return record.getOrdinal() == 1 || record.getOrdinal() == 2;
        }
        return false;
    }

    public String translateGPS2IGC(RecordSet recordSet, int index, char fixValidity, int startAltitude, int offsetAltitude) {
        Record recordLatitude = recordSet.get(1);
        Record recordLongitude = recordSet.get(2);
        Record gpsAlitude = recordSet.get(3);
        return String.format("%02d%05d%s%03d%05d%s%c%05.0f%05.0f", recordLatitude.get(index) / 1000000, Double.valueOf((double)(recordLatitude.get(index) % 1000000) / 10.0 + 0.5).intValue(), recordLatitude.get(index) > 0 ? "N" : "S", recordLongitude.get(index) / 1000000, Double.valueOf((double)(recordLongitude.get(index) % 1000000) / 10.0 + 0.5).intValue(), recordLongitude.get(index) > 0 ? "E" : "W", Character.valueOf(fixValidity), this.translateValue(gpsAlitude, (double)gpsAlitude.get(index).intValue() / 1000.0) + (double)offsetAltitude, this.translateValue(gpsAlitude, (double)gpsAlitude.get(index).intValue() / 1000.0) + (double)offsetAltitude);
    }

    public boolean isActualRecordSetWithGpsData() {
        RecordSet activeRecordSet;
        boolean containsGPSdata = false;
        Channel activeChannel = this.channels.getActiveChannel();
        if (activeChannel != null && activeChannel.getNumber() == 3 && (activeRecordSet = activeChannel.getActiveRecordSet()) != null) {
            containsGPSdata = activeRecordSet.get(1).hasReasonableData() && activeRecordSet.get(2).hasReasonableData();
        }
        return containsGPSdata;
    }

    public String exportFile(String fileEndingType, boolean isExport2TmpDir) {
        RecordSet activeRecordSet;
        String exportFileName = "";
        Channel activeChannel = this.channels.getActiveChannel();
        if (activeChannel != null && (activeRecordSet = activeChannel.getActiveRecordSet()) != null && fileEndingType.contains("kmz")) {
            int additionalMeasurementOrdinal = this.getGPS2KMZMeasurementOrdinal();
            exportFileName = new FileHandler().exportFileKMZ(2, 1, 3, additionalMeasurementOrdinal, 5, 9, -1, true, isExport2TmpDir);
        }
        return exportFileName;
    }

    public Integer getGPS2KMZMeasurementOrdinal() {
        if (this.kmzMeasurementOrdinal == null) {
            return 6;
        }
        return this.kmzMeasurementOrdinal;
    }

    public synchronized void setFilterProperties(boolean isFilterEnabled) {
        this.pickerParameters.isFilterEnabled = isFilterEnabled;
    }

    public synchronized void setTextModusFilter(boolean isTextModusFilterEnabled) {
        this.pickerParameters.isFilterTextModus = isTextModusFilterEnabled;
    }

    public synchronized void setChannelPercent(boolean isChannelPercentEnabled) {
        this.pickerParameters.isChannelPercentEnabled = isChannelPercentEnabled;
    }

    public synchronized void setAltitudeClimbSelectionProperties(int altitudeClimbComboSelectionIndex) {
        this.pickerParameters.altitudeClimbSensorSelection = altitudeClimbComboSelectionIndex;
    }

    public static String getImportToolTip() {
        DeviceConfiguration hoTTConfiguration = Analyzer.getInstance().getDeviceConfigurations().get("HoTTAdapter");
        String fileExtentions = hoTTConfiguration != null ? hoTTConfiguration.getDataBlockPreferredFileExtention() : "?";
        return Messages.getString((String)"GDE_MSGT2404", (Object[])new Object[]{fileExtentions});
    }

    public synchronized void setChannelEnabledProperty(boolean isChannelEnabled) {
        this.pickerParameters.isChannelsChannelEnabled = isChannelEnabled;
    }

    public CTabItem getUtilityDeviceTabItem() {
        GDE.display.asyncExec(new Runnable(){

            @Override
            public void run() {
                CTabItem mdlTabItem;
                if (HoTTAdapter.this.isMdlTabRequested() && (mdlTabItem = HoTTAdapter.this.getMdlTabItem()) != null) {
                    DataExplorer.getInstance().registerCustomTabItem(mdlTabItem);
                    mdlTabItem.getControl().setBackground(Settings.getInstance().getCompareSurroundingBackground());
                }
            }
        });
        return new FileTransferTabItem(this.application.getTabFolder(), 0, this.application.getTabFolder().getItemCount(), this, this.serialPort);
    }

    public boolean isMdlTabRequested() {
        boolean rc = true;
        try {
            String className = "de.treichels.hott.mdlviewer.swt.Launcher";
            ClassLoader loader = Thread.currentThread().getContextClassLoader();
            Class<?> c = loader.loadClass(className);
            Constructor<?> constructor = c.getDeclaredConstructor(new Class[0]);
            if (constructor != null) {
                constructor.newInstance(new Object[0]);
            } else {
                log.log(Level.OFF, "de.treichels.hott.mdlviewer.swt.Launcher can not be loaded");
                rc = false;
            }
        }
        catch (Throwable t) {
            log.log(Level.OFF, "de.treichels.hott.mdlviewer.swt.Launcher can not be loaded");
            rc = false;
        }
        return rc;
    }

    public CTabItem getMdlTabItem() {
        Object inst = null;
        try {
            String className = "de.treichels.hott.mdlviewer.swt.MdlTabItem";
            log.log(Level.OFF, "loading Class " + className);
            ClassLoader loader = Thread.currentThread().getContextClassLoader();
            Class<?> c = loader.loadClass(className);
            Constructor<?> constructor = c.getDeclaredConstructor(CTabFolder.class, Integer.TYPE, Integer.TYPE);
            log.log(Level.OFF, "constructor != null -> " + (constructor != null ? "true" : "false"));
            if (constructor != null) {
                System.setProperty("log.dir", Settings.getLogFilePath().substring(0, Settings.getLogFilePath().lastIndexOf(47)));
                log.log(Level.OFF, "log.dir =  " + System.getProperty("log.dir"));
                System.setProperty("mdl.dir", Settings.getInstance().getDataFilePath());
                log.log(Level.OFF, "mdl.dir =  " + System.getProperty("mdl.dir"));
                URL url = GDE.class.getProtectionDomain().getCodeSource().getLocation();
                System.setProperty("program.dir", url.getFile().substring(0, url.getPath().lastIndexOf(DataExplorer.class.getSimpleName())));
                log.log(Level.OFF, "program.dir =  " + System.getProperty("program.dir"));
                System.setProperty("template.dir", "");
                log.log(Level.OFF, "template.dir =  " + System.getProperty("template.dir"));
                inst = constructor.newInstance(this.application.getTabFolder(), 0, this.application.getTabFolder().getItemCount());
            }
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
        if (log.isLoggable(Level.OFF) && inst != null) {
            log.log(Level.OFF, "loading TabItem " + ((CTabItem)inst).getText());
        }
        if (inst != null) {
            ((CTabItem)inst).setFont(SWTResourceManager.getFont((Control)this.application, (int)(GDE.WIDGET_FONT_SIZE + (GDE.IS_LINUX ? 3 : 1)), (int)0));
        }
        return inst;
    }

    protected void runLabsCalculation(RecordSet recordSet, int channelNumber, int ordinalSourceRx_dbm, int ordinalSmoothRx_dbm, int ordinalDiffRx_dbm, int ordinalLabsRx_dbm, int ordinalSourceDist, int ordinalDiffDist, int ordinalLapsDistance) {
        int lapCount;
        int lapTime;
        Record recordSourceRx_dbm = recordSet.get(ordinalSourceRx_dbm);
        Record recordSmoothRx_dbm = recordSet.get(ordinalSmoothRx_dbm);
        Record recordDiffRx_dbm = recordSet.get(ordinalDiffRx_dbm);
        Record recordLapsRx_dbm = recordSet.get(ordinalLabsRx_dbm);
        Record recordDistanceStart = recordSet.get(ordinalSourceDist);
        Record recordDiffDistance = recordSet.get(ordinalDiffDist);
        Record recordLapsDistance = recordSet.get(ordinalLapsDistance);
        int absorptionLevel = 70;
        long filterStartTime = 0L;
        long filterMaxTime = 300000L;
        long filterLapMinTime_ms = 5000L;
        int filterMinDeltaRxDbm = 3;
        int filterMinDeltaDist = 20;
        if (this.getMeasurementPropertyValue(channelNumber, ordinalLabsRx_dbm, MeasurementPropertyTypes.FILTER_FACTOR.value()).toString().length() > 0) {
            try {
                absorptionLevel = Integer.valueOf(this.getMeasurementPropertyValue(channelNumber, ordinalSmoothRx_dbm, MeasurementPropertyTypes.FILTER_FACTOR.value()).toString().trim());
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
            try {
                filterStartTime = 1000 * Integer.valueOf(this.getMeasurementPropertyValue(channelNumber, ordinalDiffRx_dbm, MeasurementPropertyTypes.FILTER_FACTOR.value()).toString().trim());
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
            try {
                filterMaxTime = 1000 * Integer.valueOf(this.getMeasurementPropertyValue(channelNumber, ordinalSourceRx_dbm, MeasurementPropertyTypes.FILTER_FACTOR.value()).toString().trim());
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
            try {
                filterLapMinTime_ms = 1000 * Integer.valueOf(this.getMeasurementPropertyValue(channelNumber, ordinalLabsRx_dbm, MeasurementPropertyTypes.FILTER_FACTOR.value()).toString().trim());
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
            try {
                filterMinDeltaRxDbm = Integer.valueOf(this.getMeasurementPropertyValue(channelNumber, ordinalDiffRx_dbm, MeasurementPropertyTypes.NONE_SPECIFIED.value()).toString().trim());
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
            try {
                filterMinDeltaDist = Integer.valueOf(this.getMeasurementPropertyValue(channelNumber, ordinalDiffDist, MeasurementPropertyTypes.NONE_SPECIFIED.value()).toString().trim());
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        if (recordSourceRx_dbm != null && recordSmoothRx_dbm != null && recordDiffRx_dbm != null && recordLapsRx_dbm != null) {
            double lastLapTimeStamp_ms = 0.0;
            lapTime = 0;
            int lastRxDbmValue = 0;
            lapCount = 0;
            int lastRxdbm = 0;
            boolean isLapEvent = false;
            int localRxDbmMin = 0;
            for (int i = 0; i < recordSourceRx_dbm.realSize(); ++i) {
                if (recordSourceRx_dbm.get(i) == 0) {
                    recordSmoothRx_dbm.set(i, Integer.valueOf(lastRxdbm));
                } else {
                    recordSmoothRx_dbm.set(i, Integer.valueOf((lastRxdbm * absorptionLevel + recordSourceRx_dbm.get(i)) / (absorptionLevel + 1)));
                }
                lastRxdbm = recordSmoothRx_dbm.get(i);
            }
            LinearRegression thread = new LinearRegression(recordSet, recordSmoothRx_dbm.getName(), recordDiffRx_dbm.getName(), 2);
            thread.start();
            try {
                thread.join();
            }
            catch (InterruptedException e) {
                log.log(gde.log.Level.SEVERE, e.getMessage(), e);
            }
            for (int i = 0; i < recordDiffRx_dbm.realSize(); ++i) {
                if (recordDiffRx_dbm.getTime_ms(i) > (double)filterStartTime && recordDiffRx_dbm.getTime_ms(i) < (double)(filterStartTime + filterMaxTime)) {
                    if (recordDiffRx_dbm.getTime_ms(i) - lastLapTimeStamp_ms > (double)filterLapMinTime_ms) {
                        if (recordSmoothRx_dbm.get(i) / 1000 - localRxDbmMin > filterMinDeltaRxDbm) {
                            if (lastRxDbmValue > 0 && recordDiffRx_dbm.get(i) <= 0) {
                                isLapEvent = true;
                                if (lastLapTimeStamp_ms != 0.0) {
                                    log.log(gde.log.Level.FINE, String.format("Lap time in sec %03.1f", (recordSet.getTime_ms(i) - lastLapTimeStamp_ms) / 1000.0));
                                    lapTime = (int)(recordSet.getTime_ms(i) - lastLapTimeStamp_ms);
                                }
                                lastLapTimeStamp_ms = recordSet.getTime_ms(i);
                                recordLapsRx_dbm.set(i, Integer.valueOf(lapTime));
                                if (lapTime != 0) {
                                    if (lapCount % 2 == 0) {
                                        recordSet.setRecordSetDescription(recordSet.getRecordSetDescription() + String.format(Locale.ENGLISH, "\n%02d  %.1f sec", ++lapCount, (double)lapTime / 1000.0));
                                    } else {
                                        recordSet.setRecordSetDescription(recordSet.getRecordSetDescription() + String.format(Locale.ENGLISH, "  -   %02d  %.1f sec", ++lapCount, (double)lapTime / 1000.0));
                                    }
                                }
                                if (isLapEvent && lapTime == 0) {
                                    recordLapsRx_dbm.set(i, Integer.valueOf((int)filterLapMinTime_ms / 2));
                                }
                                localRxDbmMin = 0;
                            } else if (lapTime == 0) {
                                if (isLapEvent) {
                                    recordLapsRx_dbm.set(i, Integer.valueOf((int)filterLapMinTime_ms / 2));
                                } else {
                                    recordLapsRx_dbm.set(i, Integer.valueOf((int)filterLapMinTime_ms));
                                }
                            } else {
                                recordLapsRx_dbm.set(i, Integer.valueOf(lapTime));
                            }
                        } else if (lapTime == 0) {
                            if (isLapEvent) {
                                recordLapsRx_dbm.set(i, Integer.valueOf((int)filterLapMinTime_ms / 2));
                            } else {
                                recordLapsRx_dbm.set(i, Integer.valueOf((int)filterLapMinTime_ms));
                            }
                        } else {
                            recordLapsRx_dbm.set(i, Integer.valueOf(lapTime));
                        }
                    } else if (lapTime == 0) {
                        if (isLapEvent) {
                            recordLapsRx_dbm.set(i, Integer.valueOf((int)filterLapMinTime_ms / 2));
                        } else {
                            recordLapsRx_dbm.set(i, Integer.valueOf((int)filterLapMinTime_ms));
                        }
                    } else {
                        try {
                            recordLapsRx_dbm.set(i, Integer.valueOf(lapTime));
                        }
                        catch (ArrayIndexOutOfBoundsException e) {
                            log.log(gde.log.Level.SEVERE, String.format("index %d out of range in recordLapsRx_dbm with length %d", i, recordLapsRx_dbm.realSize()));
                        }
                    }
                    if (lastRxDbmValue < 0 && recordDiffRx_dbm.get(i) >= 0 && recordSmoothRx_dbm.get(i) / 1000 < localRxDbmMin) {
                        localRxDbmMin = recordSmoothRx_dbm.get(i) / 1000;
                    }
                } else if (recordDiffRx_dbm.getTime_ms(i) > (double)(filterStartTime + filterMaxTime)) {
                    recordLapsRx_dbm.set(i, Integer.valueOf(0));
                } else {
                    recordLapsRx_dbm.set(i, Integer.valueOf(lapTime));
                }
                lastRxDbmValue = recordDiffRx_dbm.get(i);
            }
        }
        if (recordDistanceStart != null && recordDistanceStart.hasReasonableData() && recordDiffDistance != null && recordLapsDistance != null) {
            double lastLapTimeStamp_ms = 0.0;
            lapTime = 0;
            int lastDistanceValue = 0;
            lapCount = 0;
            boolean isLapEvent = false;
            int localDistMax = 0;
            LinearRegression thread = new LinearRegression(recordSet, recordDistanceStart.getName(), recordDiffDistance.getName(), 4);
            thread.start();
            try {
                thread.join();
            }
            catch (InterruptedException e) {
                log.log(gde.log.Level.SEVERE, e.getMessage(), e);
            }
            for (int i = 0; i < recordDiffDistance.realSize(); ++i) {
                if (recordDiffDistance.getTime_ms(i) > (double)filterStartTime && recordDiffDistance.getTime_ms(i) < (double)(filterStartTime + filterMaxTime)) {
                    if (recordDiffDistance.getTime_ms(i) - lastLapTimeStamp_ms > (double)filterLapMinTime_ms) {
                        if (localDistMax - recordDistanceStart.get(i) / 1000 > filterMinDeltaDist) {
                            if (lastDistanceValue < 0 && recordDiffDistance.get(i) >= 0) {
                                isLapEvent = true;
                                if (lastLapTimeStamp_ms != 0.0) {
                                    log.log(gde.log.Level.FINE, String.format("Lap time in sec %03.1f", (recordSet.getTime_ms(i) - lastLapTimeStamp_ms) / 1000.0));
                                    lapTime = (int)(recordSet.getTime_ms(i) - lastLapTimeStamp_ms);
                                }
                                lastLapTimeStamp_ms = recordSet.getTime_ms(i);
                                recordLapsDistance.set(i, Integer.valueOf(lapTime));
                                if (lapTime != 0) {
                                    if (lapCount % 2 == 0) {
                                        recordSet.setRecordSetDescription(recordSet.getRecordSetDescription() + String.format(Locale.ENGLISH, "\n%02d  %.1f sec", ++lapCount, (double)lapTime / 1000.0));
                                    } else {
                                        recordSet.setRecordSetDescription(recordSet.getRecordSetDescription() + String.format(Locale.ENGLISH, "  -   %02d  %.1f sec", ++lapCount, (double)lapTime / 1000.0));
                                    }
                                }
                                if (isLapEvent && lapTime == 0) {
                                    recordLapsDistance.set(i, Integer.valueOf((int)filterLapMinTime_ms / 2));
                                }
                                localDistMax = 0;
                            } else if (lapTime == 0) {
                                if (isLapEvent) {
                                    recordLapsDistance.set(i, Integer.valueOf((int)filterLapMinTime_ms / 2));
                                } else {
                                    recordLapsDistance.set(i, Integer.valueOf((int)filterLapMinTime_ms));
                                }
                            } else {
                                recordLapsDistance.set(i, Integer.valueOf(lapTime));
                            }
                        } else if (lapTime == 0) {
                            if (isLapEvent) {
                                recordLapsDistance.set(i, Integer.valueOf((int)filterLapMinTime_ms / 2));
                            } else {
                                recordLapsDistance.set(i, Integer.valueOf((int)filterLapMinTime_ms));
                            }
                        } else {
                            recordLapsDistance.set(i, Integer.valueOf(lapTime));
                        }
                    } else if (lapTime == 0) {
                        if (isLapEvent) {
                            recordLapsDistance.set(i, Integer.valueOf((int)filterLapMinTime_ms / 2));
                        } else {
                            recordLapsDistance.set(i, Integer.valueOf((int)filterLapMinTime_ms));
                        }
                    } else {
                        recordLapsDistance.set(i, Integer.valueOf(lapTime));
                    }
                    if (lastDistanceValue > 0 && recordDiffDistance.get(i) <= 0 && recordDistanceStart.get(i) / 1000 > localDistMax) {
                        localDistMax = recordDistanceStart.get(i) / 1000;
                    }
                } else if (recordDiffDistance.getTime_ms(i) > (double)(filterStartTime + filterMaxTime)) {
                    recordLapsDistance.set(i, Integer.valueOf(0));
                } else {
                    recordLapsDistance.set(i, Integer.valueOf(lapTime));
                }
                lastDistanceValue = recordDiffDistance.get(i);
            }
        }
        recordSet.setSaved(true);
    }

    public PickerParameters getPickerParameters() {
        return this.pickerParameters;
    }

    public BitSet getActiveSensors(String sensorSignature) {
        EnumSet<Sensor> sensors = Sensor.getSetFromSignature(sensorSignature);
        return Sensor.getSensors(sensors);
    }

    public int[] getAtlitudeTripSpeedOrdinals() {
        switch (this.application.getActiveChannelNumber()) {
            case 3: {
                return new int[]{3, 9, 6};
            }
        }
        return new int[0];
    }

    public void applyMeasurementSpecialties(String[] fileRecordsProperties, RecordSet recordSet) {
        block13: {
            block14: {
                block12: {
                    if (recordSet.getChannelConfigNumber() != 2 || !recordSet.getChannelConfigName().equals("Vario")) break block12;
                    for (int i = 8; i < recordSet.size() - 1; ++i) {
                        int endIndex;
                        int startIndex;
                        Record record = recordSet.get(i);
                        if (record == null || record.getName().startsWith("vari")) continue;
                        if (fileRecordsProperties[i].contains("factor_DOUBLE=")) {
                            startIndex = fileRecordsProperties[i].indexOf("factor_DOUBLE=") + "factor_DOUBLE=".length();
                            endIndex = fileRecordsProperties[i].indexOf("|-|", startIndex);
                            if (log.isLoggable(gde.log.Level.FINE)) {
                                log.log(gde.log.Level.FINE, record.getName() + " set - factor_DOUBLE " + fileRecordsProperties[i].substring(startIndex, endIndex));
                            }
                            record.setFactor(Double.parseDouble(fileRecordsProperties[i].substring(startIndex, endIndex)));
                        }
                        if (!fileRecordsProperties[i].contains("scale_sync_ref_ordinal_INTEGER=")) continue;
                        startIndex = fileRecordsProperties[i].indexOf("scale_sync_ref_ordinal_INTEGER=") + "scale_sync_ref_ordinal_INTEGER=".length();
                        endIndex = fileRecordsProperties[i].indexOf("|-|", startIndex);
                        if (log.isLoggable(gde.log.Level.FINE)) {
                            log.log(gde.log.Level.FINE, record.getName() + " set - scale_sync_ref_ordinal_INTEGER " + fileRecordsProperties[i].substring(startIndex, endIndex));
                        }
                        record.createProperty(IDevice.SYNC_ORDINAL, DataTypes.INTEGER, (Object)Integer.parseInt(fileRecordsProperties[i].substring(startIndex, endIndex)));
                    }
                    break block13;
                }
                if (recordSet.getChannelConfigNumber() != 3 || !recordSet.getChannelConfigName().equals("GPS")) break block14;
                for (int i = 19; i < recordSet.size() - 1; ++i) {
                    int endIndex;
                    int startIndex;
                    Record record = recordSet.get(i);
                    if (record == null || record.getName().startsWith("vari")) continue;
                    if (fileRecordsProperties[i].contains("factor_DOUBLE=")) {
                        startIndex = fileRecordsProperties[i].indexOf("factor_DOUBLE=") + "factor_DOUBLE=".length();
                        endIndex = fileRecordsProperties[i].indexOf("|-|", startIndex);
                        if (log.isLoggable(gde.log.Level.FINE)) {
                            log.log(gde.log.Level.FINE, record.getName() + " set - factor_DOUBLE " + fileRecordsProperties[i].substring(startIndex, endIndex));
                        }
                        record.setFactor(Double.parseDouble(fileRecordsProperties[i].substring(startIndex, endIndex)));
                    }
                    if (!fileRecordsProperties[i].contains("scale_sync_ref_ordinal_INTEGER=")) continue;
                    startIndex = fileRecordsProperties[i].indexOf("scale_sync_ref_ordinal_INTEGER=") + "scale_sync_ref_ordinal_INTEGER=".length();
                    endIndex = fileRecordsProperties[i].indexOf("|-|", startIndex);
                    if (log.isLoggable(gde.log.Level.FINE)) {
                        log.log(gde.log.Level.FINE, record.getName() + " set - scale_sync_ref_ordinal_INTEGER " + fileRecordsProperties[i].substring(startIndex, endIndex));
                    }
                    record.createProperty(IDevice.SYNC_ORDINAL, DataTypes.INTEGER, (Object)Integer.parseInt(fileRecordsProperties[i].substring(startIndex, endIndex)));
                }
                break block13;
            }
            if (recordSet.getChannelConfigNumber() != 7 || !recordSet.getChannelConfigName().equals("ESC")) break block13;
            for (int i = 14; i < recordSet.size() - 1; ++i) {
                int endIndex;
                int startIndex;
                Record record = recordSet.get(i);
                if (record == null || record.getName().startsWith("vari")) continue;
                if (fileRecordsProperties[i].contains("factor_DOUBLE=")) {
                    startIndex = fileRecordsProperties[i].indexOf("factor_DOUBLE=") + "factor_DOUBLE=".length();
                    endIndex = fileRecordsProperties[i].indexOf("|-|", startIndex);
                    if (log.isLoggable(gde.log.Level.FINE)) {
                        log.log(gde.log.Level.FINE, record.getName() + " set - factor_DOUBLE " + fileRecordsProperties[i].substring(startIndex, endIndex));
                    }
                    record.setFactor(Double.parseDouble(fileRecordsProperties[i].substring(startIndex, endIndex)));
                }
                if (!fileRecordsProperties[i].contains("scale_sync_ref_ordinal_INTEGER=")) continue;
                startIndex = fileRecordsProperties[i].indexOf("scale_sync_ref_ordinal_INTEGER=") + "scale_sync_ref_ordinal_INTEGER=".length();
                endIndex = fileRecordsProperties[i].indexOf("|-|", startIndex);
                if (log.isLoggable(gde.log.Level.FINE)) {
                    log.log(gde.log.Level.FINE, record.getName() + " set - scale_sync_ref_ordinal_INTEGER " + fileRecordsProperties[i].substring(startIndex, endIndex));
                }
                record.createProperty(IDevice.SYNC_ORDINAL, DataTypes.INTEGER, (Object)Integer.parseInt(fileRecordsProperties[i].substring(startIndex, endIndex)));
            }
        }
    }

    protected static void updateVarioTypeDependent(int version, IDevice device, RecordSet tmpRecordSet) {
        if (version > 100 && version < 120) {
            tmpRecordSet.get(8).setName(device.getMeasurementReplacement("acceleration") + " X");
            tmpRecordSet.get(8).setUnit("g");
            tmpRecordSet.get(9).setName(device.getMeasurementReplacement("acceleration") + " Y");
            tmpRecordSet.get(9).setUnit("g");
            tmpRecordSet.get(9).createProperty(IDevice.SYNC_ORDINAL, DataTypes.INTEGER, (Object)8);
            tmpRecordSet.get(10).setName(device.getMeasurementReplacement("acceleration") + " Z");
            tmpRecordSet.get(10).setUnit("g");
            tmpRecordSet.get(10).createProperty(IDevice.SYNC_ORDINAL, DataTypes.INTEGER, (Object)8);
            tmpRecordSet.get(11).setName(device.getMeasurementReplacement("air_speed"));
            tmpRecordSet.get(11).setUnit("km/h");
            tmpRecordSet.get(11).setFactor(2.0);
            tmpRecordSet.get(12).setName("Version");
            tmpRecordSet.get(12).setUnit("");
        }
    }

    protected static long updateGpsTypeDependent(int version, IDevice device, RecordSet tmpRecordSet, long startTimeStamp_ms) {
        if (version > 100) {
            tmpRecordSet.get(16).setName(device.getMeasurementReplacement("servo_impulse"));
            tmpRecordSet.get(16).setUnit("%");
            tmpRecordSet.get(17).setName(device.getMeasurementReplacement("air_speed"));
            tmpRecordSet.get(17).setUnit("km/h");
            tmpRecordSet.get(17).createProperty(IDevice.SYNC_ORDINAL, DataTypes.INTEGER, (Object)6);
            tmpRecordSet.get(19).setName(device.getMeasurementReplacement("acceleration") + " X");
            tmpRecordSet.get(19).setUnit("g");
            tmpRecordSet.get(19).setFactor(0.01);
            tmpRecordSet.get(20).setName(device.getMeasurementReplacement("acceleration") + " Y");
            tmpRecordSet.get(20).setUnit("g");
            tmpRecordSet.get(20).setFactor(0.01);
            tmpRecordSet.get(20).createProperty(IDevice.SYNC_ORDINAL, DataTypes.INTEGER, (Object)19);
            tmpRecordSet.get(21).setName(device.getMeasurementReplacement("acceleration") + " Z");
            tmpRecordSet.get(21).setUnit("g");
            tmpRecordSet.get(21).setFactor(0.01);
            tmpRecordSet.get(21).createProperty(IDevice.SYNC_ORDINAL, DataTypes.INTEGER, (Object)19);
            tmpRecordSet.get(22).setName("ENL");
            tmpRecordSet.get(22).setUnit("");
        } else if (version == 4) {
            tmpRecordSet.get(16).setName(device.getMeasurementReplacement("servo_impulse") + " GPS");
            tmpRecordSet.get(16).setUnit("%");
            tmpRecordSet.get(18).setName(device.getMeasurementReplacement("voltage") + " GPS");
            tmpRecordSet.get(18).setUnit("V");
            tmpRecordSet.get(19).setName(device.getMeasurementReplacement("time") + " GPS");
            tmpRecordSet.get(19).setUnit("HH:mm:ss.SSS");
            tmpRecordSet.get(19).setFactor(1.0);
            tmpRecordSet.get(20).setName(device.getMeasurementReplacement("date") + " GPS");
            tmpRecordSet.get(20).setUnit("yy-MM-dd");
            tmpRecordSet.get(20).setFactor(1.0);
            tmpRecordSet.get(21).setName(device.getMeasurementReplacement("altitude") + " MSL");
            tmpRecordSet.get(21).setUnit("m");
            tmpRecordSet.get(21).setFactor(1.0);
            tmpRecordSet.get(22).setName("ENL");
            tmpRecordSet.get(22).setUnit("%");
            if (startTimeStamp_ms >= 0L) {
                startTimeStamp_ms = HoTTbinReader.getStartTimeStamp(tmpRecordSet.getStartTimeStamp(), (Integer)tmpRecordSet.get(19).lastElement(), 0);
                for (RecordSet recordSet : HoTTbinReader.recordSets.values()) {
                    recordSet.setStartTimeStamp(startTimeStamp_ms);
                }
            }
        } else if (version == 1) {
            tmpRecordSet.get(16).setName("velNorth");
            tmpRecordSet.get(16).setUnit("mm/s");
            tmpRecordSet.get(18).setName("speedAcc");
            tmpRecordSet.get(18).setUnit("cm/s");
            tmpRecordSet.get(19).setName(device.getMeasurementReplacement("time") + " GPS");
            tmpRecordSet.get(19).setUnit("HH:mm:ss.SSS");
            tmpRecordSet.get(19).setFactor(1.0);
            tmpRecordSet.get(21).setName("velEast");
            tmpRecordSet.get(21).setUnit("mm/s");
            tmpRecordSet.get(21).setFactor(1.0);
            tmpRecordSet.get(22).setName("HDOP");
            tmpRecordSet.get(22).setUnit("dm");
            if (startTimeStamp_ms >= 0L) {
                startTimeStamp_ms = HoTTbinReader.getStartTimeStamp(tmpRecordSet.getStartTimeStamp(), (Integer)tmpRecordSet.get(19).lastElement(), 0);
                for (RecordSet recordSet : HoTTbinReader.recordSets.values()) {
                    recordSet.setStartTimeStamp(startTimeStamp_ms);
                }
            }
        } else if (version == 0) {
            tmpRecordSet.get(19).setName(device.getMeasurementReplacement("time") + " GPS");
            tmpRecordSet.get(19).setUnit("HH:mm:ss.SSS");
            tmpRecordSet.get(19).setFactor(1.0);
            tmpRecordSet.get(21).setName(device.getMeasurementReplacement("altitude") + " MSL");
            tmpRecordSet.get(21).setUnit("m");
            tmpRecordSet.get(21).setFactor(1.0);
            if (startTimeStamp_ms >= 0L) {
                startTimeStamp_ms = HoTTbinReader.getStartTimeStamp(tmpRecordSet.getStartTimeStamp(), (Integer)tmpRecordSet.get(19).lastElement(), 0);
                for (RecordSet recordSet : HoTTbinReader.recordSets.values()) {
                    recordSet.setStartTimeStamp(startTimeStamp_ms);
                }
            }
        } else {
            tmpRecordSet.get(16).setName("Byte GPS_1");
            tmpRecordSet.get(17).setName("Byte GPS_2");
            tmpRecordSet.get(18).setName("Byte GPS_3");
            tmpRecordSet.get(19).setName("Short GPS_4");
            tmpRecordSet.get(20).setName("Short GPS_5");
            tmpRecordSet.get(21).setName("Short GPS_6");
            tmpRecordSet.get(22).setName("Byte GPS_7");
        }
        return startTimeStamp_ms;
    }

    protected static void updateEAMTypeDependent(int version, IDevice device, RecordSet tmpRecordSet) {
        if (version == 64) {
            tmpRecordSet.get(5).setName("Holds");
            tmpRecordSet.get(5).setUnit("#");
            tmpRecordSet.get(5).setSymbol("");
            tmpRecordSet.get(5).clearProperties();
            tmpRecordSet.get(5).createProperty(IDevice.FACTOR, DataTypes.DOUBLE, (Object)1.0);
            tmpRecordSet.get(6).setName("Lost Frames");
            tmpRecordSet.get(6).setUnit("#");
            tmpRecordSet.get(6).setSymbol("");
            tmpRecordSet.get(6).clearProperties();
            tmpRecordSet.get(6).createProperty(IDevice.FACTOR, DataTypes.DOUBLE, (Object)1.0);
            tmpRecordSet.get(7).setName("Fades 1");
            tmpRecordSet.get(7).setUnit("#");
            tmpRecordSet.get(7).setSymbol("");
            tmpRecordSet.get(7).clearProperties();
            tmpRecordSet.get(7).createProperty(IDevice.FACTOR, DataTypes.DOUBLE, (Object)1.0);
            tmpRecordSet.get(8).setName("Fades 2");
            tmpRecordSet.get(8).setUnit("#");
            tmpRecordSet.get(8).setSymbol("");
            tmpRecordSet.get(8).clearProperties();
            tmpRecordSet.get(8).createProperty(IDevice.FACTOR, DataTypes.DOUBLE, (Object)1.0);
            tmpRecordSet.get(9).setName(device.getMeasurementReplacement("voltage") + " Bat1");
            tmpRecordSet.get(9).setUnit("V");
            tmpRecordSet.get(9).setSymbol("u1");
            tmpRecordSet.get(9).getProperty(FACTOR).setValue((Object)0.1);
            tmpRecordSet.get(9).getProperty(IDevice.SYNC_ORDINAL).setValue((Object)1);
            tmpRecordSet.get(10).setName(device.getMeasurementReplacement("current") + " Bat1");
            tmpRecordSet.get(10).setUnit("A");
            tmpRecordSet.get(10).setSymbol("i1");
            tmpRecordSet.get(10).getProperty(FACTOR).setValue((Object)0.1);
            tmpRecordSet.get(10).getProperty(IDevice.SYNC_ORDINAL).setValue((Object)2);
            tmpRecordSet.get(11).setName(device.getMeasurementReplacement("capacity") + " Bat1");
            tmpRecordSet.get(11).setUnit("mAh");
            tmpRecordSet.get(11).setSymbol("c1");
            tmpRecordSet.get(11).getProperty(FACTOR).setValue((Object)10);
            tmpRecordSet.get(11).getProperty(IDevice.SYNC_ORDINAL).setValue((Object)3);
            tmpRecordSet.get(12).setName(device.getMeasurementReplacement("voltage") + " Bat2");
            tmpRecordSet.get(12).setUnit("V");
            tmpRecordSet.get(12).setSymbol("u2");
            tmpRecordSet.get(12).getProperty(FACTOR).setValue((Object)0.1);
            tmpRecordSet.get(12).getProperty(IDevice.SYNC_ORDINAL).setValue((Object)1);
            tmpRecordSet.get(13).setName(device.getMeasurementReplacement("current") + " Bat2");
            tmpRecordSet.get(13).setUnit("A");
            tmpRecordSet.get(13).setSymbol("i2");
            tmpRecordSet.get(13).getProperty(FACTOR).setValue((Object)0.1);
            tmpRecordSet.get(13).getProperty(IDevice.SYNC_ORDINAL).setValue((Object)2);
            tmpRecordSet.get(14).setName(device.getMeasurementReplacement("capacity") + " Bat2");
            tmpRecordSet.get(14).setUnit("mAh");
            tmpRecordSet.get(14).setSymbol("c2");
            tmpRecordSet.get(14).getProperty(FACTOR).setValue((Object)10);
            tmpRecordSet.get(14).getProperty(IDevice.SYNC_ORDINAL).setValue((Object)3);
            tmpRecordSet.get(15).setName("misc EAM_1");
            tmpRecordSet.get(15).clearProperties();
            tmpRecordSet.get(15).createProperty(IDevice.FACTOR, DataTypes.DOUBLE, (Object)1.0);
            tmpRecordSet.get(15).createProperty(IDevice.SYNC_ORDINAL, DataTypes.INTEGER, (Object)-1);
            tmpRecordSet.get(16).setName("misc EAM_2");
            tmpRecordSet.get(16).clearProperties();
            tmpRecordSet.get(16).createProperty(IDevice.FACTOR, DataTypes.DOUBLE, (Object)1.0);
            tmpRecordSet.get(16).createProperty(IDevice.SYNC_ORDINAL, DataTypes.INTEGER, (Object)-1);
            tmpRecordSet.get(17).setName("misc EAM_3");
            tmpRecordSet.get(17).clearProperties();
            tmpRecordSet.get(17).createProperty(IDevice.FACTOR, DataTypes.DOUBLE, (Object)1.0);
            tmpRecordSet.get(17).createProperty(IDevice.SYNC_ORDINAL, DataTypes.INTEGER, (Object)-1);
            tmpRecordSet.get(18).setName("misc EAM_4");
            tmpRecordSet.get(18).clearProperties();
            tmpRecordSet.get(18).createProperty(IDevice.FACTOR, DataTypes.DOUBLE, (Object)1.0);
            tmpRecordSet.get(19).createProperty(IDevice.SYNC_ORDINAL, DataTypes.INTEGER, (Object)-1);
            tmpRecordSet.get(19).setName("misc EAM_5");
            tmpRecordSet.get(19).clearProperties();
            tmpRecordSet.get(19).createProperty(IDevice.FACTOR, DataTypes.DOUBLE, (Object)1.0);
            tmpRecordSet.get(19).createProperty(IDevice.SYNC_ORDINAL, DataTypes.INTEGER, (Object)-1);
            tmpRecordSet.get(23).setName("misc EAM_6");
            tmpRecordSet.get(23).clearProperties();
            tmpRecordSet.get(23).createProperty(IDevice.FACTOR, DataTypes.DOUBLE, (Object)1.0);
            tmpRecordSet.get(23).createProperty(IDevice.SYNC_ORDINAL, DataTypes.INTEGER, (Object)-1);
            tmpRecordSet.get(24).setName("misc EAM_7");
            tmpRecordSet.get(24).clearProperties();
            tmpRecordSet.get(24).createProperty(IDevice.FACTOR, DataTypes.DOUBLE, (Object)1.0);
            tmpRecordSet.get(24).createProperty(IDevice.SYNC_ORDINAL, DataTypes.INTEGER, (Object)-1);
            tmpRecordSet.get(25).setName("Status Gyro");
            tmpRecordSet.get(25).setUnit("");
            tmpRecordSet.get(25).setSymbol("");
            tmpRecordSet.get(25).clearProperties();
            tmpRecordSet.get(25).createProperty(IDevice.FACTOR, DataTypes.DOUBLE, (Object)1.0);
            tmpRecordSet.get(25).createProperty(IDevice.SYNC_ORDINAL, DataTypes.INTEGER, (Object)-1);
            tmpRecordSet.get(26).setName("Status SpeedSensor");
            tmpRecordSet.get(26).setUnit("");
            tmpRecordSet.get(26).setSymbol("");
            tmpRecordSet.get(26).clearProperties();
            tmpRecordSet.get(26).createProperty(IDevice.FACTOR, DataTypes.DOUBLE, (Object)1.0);
            tmpRecordSet.get(26).createProperty(IDevice.SYNC_ORDINAL, DataTypes.INTEGER, (Object)-1);
            tmpRecordSet.get(28).setName("Version EAM");
            tmpRecordSet.get(28).setUnit("#");
            tmpRecordSet.get(28).setSymbol("");
        }
    }

    protected static void updateEscTypeDependent(int version, IDevice device, RecordSet tmpRecordSet) {
        if (version == 3) {
            tmpRecordSet.get(14).setName(device.getMeasurementReplacement("speed"));
            tmpRecordSet.get(14).setUnit("km/h");
            device.getMeasurement(7, 14).setStatistics(StatisticsType.fromString((String)"min=true max=true avg=true sigma=false"));
            tmpRecordSet.get(15).setName(device.getMeasurementReplacement("speed") + " max");
            tmpRecordSet.get(15).setUnit("km/h");
            tmpRecordSet.get(16).setName("PWM");
            tmpRecordSet.get(16).setUnit("%");
            tmpRecordSet.get(17).setName(device.getMeasurementReplacement("throttle"));
            tmpRecordSet.get(17).setUnit("%");
            tmpRecordSet.get(18).setName(device.getMeasurementReplacement("voltage_bec"));
            tmpRecordSet.get(18).setUnit("V");
            tmpRecordSet.get(18).setFactor(0.1);
            device.getMeasurement(7, 18).setStatistics(StatisticsType.fromString((String)"min=true max=true avg=true sigma=false"));
            tmpRecordSet.get(19).setName(device.getMeasurementReplacement("voltage_bec_min"));
            tmpRecordSet.get(19).setUnit("V");
            tmpRecordSet.get(19).setFactor(0.1);
            tmpRecordSet.get(19).createProperty(IDevice.SYNC_ORDINAL, DataTypes.INTEGER, (Object)18);
            tmpRecordSet.get(20).setName(device.getMeasurementReplacement("current_bec"));
            tmpRecordSet.get(20).setUnit("A");
            tmpRecordSet.get(20).setFactor(0.1);
            device.getMeasurement(7, 20).setStatistics(StatisticsType.fromString((String)"min=true max=true avg=true sigma=false"));
            tmpRecordSet.get(21).setName(device.getMeasurementReplacement("temperature_bec"));
            tmpRecordSet.get(21).setUnit("\u00b0C");
            tmpRecordSet.get(21).createProperty(IDevice.SYNC_ORDINAL, DataTypes.INTEGER, (Object)6);
            device.getMeasurement(7, 21).setStatistics(StatisticsType.fromString((String)"min=true max=true avg=true sigma=false"));
            tmpRecordSet.get(22).setName(device.getMeasurementReplacement("temperature_capacitor"));
            tmpRecordSet.get(22).setUnit("\u00b0C");
            device.getMeasurement(7, 22).setStatistics(StatisticsType.fromString((String)"min=true max=true avg=true sigma=false"));
            tmpRecordSet.get(22).createProperty(IDevice.SYNC_ORDINAL, DataTypes.INTEGER, (Object)6);
            tmpRecordSet.get(23).setName(device.getMeasurementReplacement("timing"));
            tmpRecordSet.get(23).setUnit("\u00b0");
            tmpRecordSet.get(24).setName(device.getMeasurementReplacement("temperature") + " 3");
            tmpRecordSet.get(24).setUnit("\u00b0C");
            device.getMeasurement(7, 24).setStatistics(StatisticsType.fromString((String)"min=true max=true avg=true sigma=false"));
            tmpRecordSet.get(24).createProperty(IDevice.SYNC_ORDINAL, DataTypes.INTEGER, (Object)6);
            tmpRecordSet.get(25).setName(device.getMeasurementReplacement("gear"));
            tmpRecordSet.get(25).setUnit("");
            tmpRecordSet.get(26).setName("YGEGenExt");
            tmpRecordSet.get(26).setUnit("");
            tmpRecordSet.get(27).setName("MotStatEscNr");
            tmpRecordSet.get(27).setUnit("#");
        } else if (version >= 128) {
            tmpRecordSet.get(1).setName(device.getMeasurementReplacement("voltage") + " ECU");
            tmpRecordSet.get(2).setName(device.getMeasurementReplacement("current") + " ECU");
            tmpRecordSet.get(6).setName(device.getMeasurementReplacement("temperature") + " EGT 1");
            tmpRecordSet.get(7).setName(device.getMeasurementReplacement("temperature") + " EGT 2");
            tmpRecordSet.get(8).setName(device.getMeasurementReplacement("voltage") + " ECU_min");
            tmpRecordSet.get(9).setName(device.getMeasurementReplacement("current") + " ECU_max");
            tmpRecordSet.get(11).setName(device.getMeasurementReplacement("temperature") + " EGT 1_max");
            tmpRecordSet.get(12).setName(device.getMeasurementReplacement("temperature") + " EGT 2_max");
            tmpRecordSet.get(14).setName(device.getMeasurementReplacement("air_speed"));
            tmpRecordSet.get(14).setUnit("km/h");
            device.getMeasurement(7, 14).setStatistics(StatisticsType.fromString((String)"min=true max=true avg=true sigma=false"));
            tmpRecordSet.get(15).setName(device.getMeasurementReplacement("air_speed") + "_max");
            tmpRecordSet.get(15).setUnit("km/h");
            tmpRecordSet.get(16).setName("PWM");
            tmpRecordSet.get(16).setUnit("%");
            tmpRecordSet.get(17).setName(device.getMeasurementReplacement("throttle"));
            tmpRecordSet.get(17).setUnit("%");
            tmpRecordSet.get(18).setName(device.getMeasurementReplacement("voltage_pump"));
            tmpRecordSet.get(18).setUnit("V");
            tmpRecordSet.get(18).setFactor(0.1);
            device.getMeasurement(7, 18).setStatistics(StatisticsType.fromString((String)"min=true max=true avg=true sigma=false"));
            tmpRecordSet.get(19).setName(device.getMeasurementReplacement("voltage_pump_min"));
            tmpRecordSet.get(19).setUnit("V");
            tmpRecordSet.get(19).setFactor(0.1);
            tmpRecordSet.get(20).setName(device.getMeasurementReplacement("flow"));
            tmpRecordSet.get(20).setUnit("ml/min");
            tmpRecordSet.get(20).setFactor(0.1);
            device.getMeasurement(7, 20).setStatistics(StatisticsType.fromString((String)"min=true max=true avg=true sigma=false"));
            tmpRecordSet.get(21).setName(device.getMeasurementReplacement("fuel"));
            tmpRecordSet.get(21).setUnit("ml");
            device.getMeasurement(7, 21).setStatistics(StatisticsType.fromString((String)"min=true max=true avg=true sigma=false"));
            tmpRecordSet.get(22).setName(device.getMeasurementReplacement("power"));
            tmpRecordSet.get(22).setUnit("W");
            device.getMeasurement(7, 22).setStatistics(StatisticsType.fromString((String)"min=true max=true avg=true sigma=false"));
            tmpRecordSet.get(23).setName(device.getMeasurementReplacement("thrust"));
            tmpRecordSet.get(23).setUnit("N");
            tmpRecordSet.get(24).setName(device.getMeasurementReplacement("temperature_pump"));
            tmpRecordSet.get(24).setUnit("\u00b0C");
            device.getMeasurement(7, 24).setStatistics(StatisticsType.fromString((String)"min=true max=true avg=true sigma=false"));
            tmpRecordSet.get(25).setName(device.getMeasurementReplacement("engine"));
            tmpRecordSet.get(25).setUnit("#");
        }
    }

    public boolean useChannelWithSyncedDescription() {
        return true;
    }

    public static final class PickerParameters {
        final Analyzer analyzer;
        final PackageLossDeque reverseChannelPackageLossCounter;
        boolean isChannelsChannelEnabled = false;
        boolean isFilterEnabled = true;
        boolean isFilterTextModus = true;
        boolean isChannelPercentEnabled = true;
        int altitudeClimbSensorSelection = 0;
        double latitudeToleranceFactor = 50.0;
        double longitudeToleranceFactor = 15.0;

        public PickerParameters(Analyzer analyzer) {
            this.analyzer = analyzer;
            this.reverseChannelPackageLossCounter = new PackageLossDeque(100);
        }

        PickerParameters(PickerParameters that) {
            this.analyzer = that.analyzer;
            this.reverseChannelPackageLossCounter = new PackageLossDeque(100);
            this.isChannelsChannelEnabled = that.isChannelsChannelEnabled;
            this.isFilterEnabled = that.isFilterEnabled;
            this.isFilterTextModus = that.isFilterTextModus;
            this.isChannelPercentEnabled = that.isChannelPercentEnabled;
            this.altitudeClimbSensorSelection = that.altitudeClimbSensorSelection;
            this.latitudeToleranceFactor = that.latitudeToleranceFactor;
            this.longitudeToleranceFactor = that.longitudeToleranceFactor;
        }

        public String getReaderSettingsCsv() {
            String d = ",";
            return this.isFilterEnabled + "," + this.altitudeClimbSensorSelection;
        }

        public String toString() {
            return "PickerParameters [analyzer.channels=" + String.valueOf(this.analyzer.getChannels()) + ", isChannelsChannelEnabled=" + this.isChannelsChannelEnabled + ", isFilterEnabled=" + this.isFilterEnabled + ", isFilterTextModus=" + this.isFilterTextModus + ", altitudeClimbSensorSelection=" + this.altitudeClimbSensorSelection + "]";
        }
    }

    public static enum Protocol {
        TYPE_19200_V3("19200 V3"),
        TYPE_19200_V4("19200 V4"),
        TYPE_115200("115200");

        private final String value;

        private Protocol(String v) {
            this.value = v;
        }

        public String value() {
            return this.value;
        }

        public static Protocol fromValue(String v) {
            for (Protocol c : Protocol.values()) {
                if (!c.value.equals(v)) continue;
                return c;
            }
            throw new IllegalArgumentException(v);
        }

        public static String[] valuesAsStingArray() {
            StringBuilder sb = new StringBuilder();
            for (Protocol protocol : Protocol.values()) {
                sb.append(protocol.value).append(";");
            }
            return sb.toString().split(";");
        }
    }

    public static enum Sensor {
        RECEIVER(1, "Receiver", "RECEIVER"){

            @Override
            public HoTTbinReader.BinParser createBinParser(PickerParameters pickerParameters, int[] points, long[] timeSteps_ms, byte[][] buffers) {
                return new HoTTbinReader.RcvBinParser(pickerParameters, points, timeSteps_ms, buffers);
            }

            @Override
            public HoTTlogReader.LogParser createLogParser(PickerParameters pickerParameters, int[] points, long[] timeSteps_ms, byte[] buffer, int numberUsedChannels) {
                return new HoTTlogReader.RcvLogParser(pickerParameters, points, timeSteps_ms, buffer);
            }

            @Override
            public HoTTbinReader.BinParser createBinParser2(PickerParameters pickerParameters, long[] timeSteps_ms, byte[][] buffers) {
                return new HoTTbinReader2.RcvBinParser(pickerParameters, timeSteps_ms, buffers);
            }

            @Override
            public HoTTbinReader.BinParser createBinParser2(PickerParameters pickerParameters, int[] points, long[] timeSteps_ms, byte[][] buffers) {
                return new HoTTbinReader2.RcvBinParser(pickerParameters, points, timeSteps_ms, buffers);
            }

            @Override
            public HoTTbinReader.BinParser createBinParserD(PickerParameters pickerParameters, long[] timeSteps_ms, byte[][] buffers) {
                return new HoTTbinReader2.RcvBinParser(pickerParameters, timeSteps_ms, buffers);
            }

            @Override
            public HoTTbinReader.BinParser createBinParserD(PickerParameters pickerParameters, int[] points, long[] timeSteps_ms, byte[][] buffers) {
                return new HoTTbinReader2.RcvBinParser(pickerParameters, points, timeSteps_ms, buffers);
            }

            @Override
            public HoTTlogReader.LogParser createLogParserD(PickerParameters pickerParameters, int[] points, long[] timeSteps_ms, byte[] buffer, int numberUsedChannels) {
                return new HoTTlogReader.RcvLogParser(pickerParameters, points, timeSteps_ms, buffer);
            }
        }
        ,
        VARIO(2, "Vario", "VARIO"){

            @Override
            public HoTTbinReader.BinParser createBinParser(PickerParameters pickerParameters, int[] points, long[] timeSteps_ms, byte[][] buffers) {
                return new HoTTbinReader.VarBinParser(pickerParameters, points, timeSteps_ms, buffers);
            }

            @Override
            public HoTTlogReader.LogParser createLogParser(PickerParameters pickerParameters, int[] points, long[] timeSteps_ms, byte[] buffer, int numberUsedChannels) {
                return new HoTTlogReader.VarLogParser(pickerParameters, points, timeSteps_ms, buffer);
            }

            @Override
            public HoTTbinReader.BinParser createBinParser2(PickerParameters pickerParameters, long[] timeSteps_ms, byte[][] buffers) {
                return new HoTTbinReader2.VarBinParser(pickerParameters, timeSteps_ms, buffers);
            }

            @Override
            public HoTTbinReader.BinParser createBinParser2(PickerParameters pickerParameters, int[] points, long[] timeSteps_ms, byte[][] buffers) {
                return new HoTTbinReader2.VarBinParser(pickerParameters, points, timeSteps_ms, buffers);
            }

            @Override
            public HoTTbinReader.BinParser createBinParserD(PickerParameters pickerParameters, long[] timeSteps_ms, byte[][] buffers) {
                return new HoTTbinReaderD.VarBinParserD(pickerParameters, timeSteps_ms, buffers);
            }

            @Override
            public HoTTbinReader.BinParser createBinParserD(PickerParameters pickerParameters, int[] points, long[] timeSteps_ms, byte[][] buffers) {
                return new HoTTbinReaderD.VarBinParserD(pickerParameters, points, timeSteps_ms, buffers);
            }

            @Override
            public HoTTlogReader.LogParser createLogParserD(PickerParameters pickerParameters, int[] points, long[] timeSteps_ms, byte[] buffer, int numberUsedChannels) {
                return new HoTTlogReaderD.VarLogParserD(pickerParameters, points, timeSteps_ms, buffer);
            }
        }
        ,
        GPS(3, "GPS", "GPS"){

            @Override
            public HoTTbinReader.BinParser createBinParser(PickerParameters pickerParameters, int[] points, long[] timeSteps_ms, byte[][] buffers) {
                return new HoTTbinReader.GpsBinParser(pickerParameters, points, timeSteps_ms, buffers);
            }

            @Override
            public HoTTlogReader.LogParser createLogParser(PickerParameters pickerParameters, int[] points, long[] timeSteps_ms, byte[] buffer, int numberUsedChannels) {
                return new HoTTlogReader.GpsLogParser(pickerParameters, points, timeSteps_ms, buffer);
            }

            @Override
            public HoTTbinReader.BinParser createBinParser2(PickerParameters pickerParameters, long[] timeSteps_ms, byte[][] buffers) {
                return new HoTTbinReader2.GpsBinParser(pickerParameters, timeSteps_ms, buffers);
            }

            @Override
            public HoTTbinReader.BinParser createBinParser2(PickerParameters pickerParameters, int[] points, long[] timeSteps_ms, byte[][] buffers) {
                return new HoTTbinReader2.GpsBinParser(pickerParameters, points, timeSteps_ms, buffers);
            }

            @Override
            public HoTTbinReader.BinParser createBinParserD(PickerParameters pickerParameters, long[] timeSteps_ms, byte[][] buffers) {
                return new HoTTbinReader2.GpsBinParser(pickerParameters, timeSteps_ms, buffers);
            }

            @Override
            public HoTTbinReader.BinParser createBinParserD(PickerParameters pickerParameters, int[] points, long[] timeSteps_ms, byte[][] buffers) {
                return new HoTTbinReader2.GpsBinParser(pickerParameters, points, timeSteps_ms, buffers);
            }

            @Override
            public HoTTlogReader.LogParser createLogParserD(PickerParameters pickerParameters, int[] points, long[] timeSteps_ms, byte[] buffer, int numberUsedChannels) {
                return new HoTTlogReader.GpsLogParser(pickerParameters, points, timeSteps_ms, buffer);
            }
        }
        ,
        GAM(4, "GAM", "GENERAL"){

            @Override
            public HoTTbinReader.BinParser createBinParser(PickerParameters pickerParameters, int[] points, long[] timeSteps_ms, byte[][] buffers) {
                return new HoTTbinReader.GamBinParser(pickerParameters, points, timeSteps_ms, buffers);
            }

            @Override
            public HoTTlogReader.LogParser createLogParser(PickerParameters pickerParameters, int[] points, long[] timeSteps_ms, byte[] buffer, int numberUsedChannels) {
                return new HoTTlogReader.GamLogParser(pickerParameters, points, timeSteps_ms, buffer);
            }

            @Override
            public HoTTbinReader.BinParser createBinParser2(PickerParameters pickerParameters, long[] timeSteps_ms, byte[][] buffers) {
                return new HoTTbinReader2.GamBinParser(pickerParameters, timeSteps_ms, buffers);
            }

            @Override
            public HoTTbinReader.BinParser createBinParser2(PickerParameters pickerParameters, int[] points, long[] timeSteps_ms, byte[][] buffers) {
                return new HoTTbinReader2.GamBinParser(pickerParameters, points, timeSteps_ms, buffers);
            }

            @Override
            public HoTTbinReader.BinParser createBinParserD(PickerParameters pickerParameters, long[] timeSteps_ms, byte[][] buffers) {
                return new HoTTbinReader2.GamBinParser(pickerParameters, timeSteps_ms, buffers);
            }

            @Override
            public HoTTbinReader.BinParser createBinParserD(PickerParameters pickerParameters, int[] points, long[] timeSteps_ms, byte[][] buffers) {
                return new HoTTbinReader2.GamBinParser(pickerParameters, points, timeSteps_ms, buffers);
            }

            @Override
            public HoTTlogReader.LogParser createLogParserD(PickerParameters pickerParameters, int[] points, long[] timeSteps_ms, byte[] buffer, int numberUsedChannels) {
                return new HoTTlogReader.GamLogParser(pickerParameters, points, timeSteps_ms, buffer);
            }
        }
        ,
        EAM(5, "EAM", "ELECTRIC"){

            @Override
            public HoTTbinReader.BinParser createBinParser(PickerParameters pickerParameters, int[] points, long[] timeSteps_ms, byte[][] buffers) {
                return new HoTTbinReader.EamBinParser(pickerParameters, points, timeSteps_ms, buffers);
            }

            @Override
            public HoTTlogReader.LogParser createLogParser(PickerParameters pickerParameters, int[] points, long[] timeSteps_ms, byte[] buffer, int numberUsedChannels) {
                return new HoTTlogReader.EamLogParser(pickerParameters, points, timeSteps_ms, buffer);
            }

            @Override
            public HoTTbinReader.BinParser createBinParser2(PickerParameters pickerParameters, long[] timeSteps_ms, byte[][] buffers) {
                return new HoTTbinReader2.EamBinParser(pickerParameters, timeSteps_ms, buffers);
            }

            @Override
            public HoTTbinReader.BinParser createBinParser2(PickerParameters pickerParameters, int[] points, long[] timeSteps_ms, byte[][] buffers) {
                return new HoTTbinReader2.EamBinParser(pickerParameters, points, timeSteps_ms, buffers);
            }

            @Override
            public HoTTbinReader.BinParser createBinParserD(PickerParameters pickerParameters, long[] timeSteps_ms, byte[][] buffers) {
                return new HoTTbinReader2.EamBinParser(pickerParameters, timeSteps_ms, buffers);
            }

            @Override
            public HoTTbinReader.BinParser createBinParserD(PickerParameters pickerParameters, int[] points, long[] timeSteps_ms, byte[][] buffers) {
                return new HoTTbinReader2.EamBinParser(pickerParameters, points, timeSteps_ms, buffers);
            }

            @Override
            public HoTTlogReader.LogParser createLogParserD(PickerParameters pickerParameters, int[] points, long[] timeSteps_ms, byte[] buffer, int numberUsedChannels) {
                return new HoTTlogReader.EamLogParser(pickerParameters, points, timeSteps_ms, buffer);
            }
        }
        ,
        ESC(7, "ESC", "AIR_ESC"){

            @Override
            public HoTTbinReader.BinParser createBinParser(PickerParameters pickerParameters, int[] points, long[] timeSteps_ms, byte[][] buffers) {
                return new HoTTbinReader.EscBinParser(pickerParameters, points, timeSteps_ms, buffers);
            }

            @Override
            public HoTTlogReader.LogParser createLogParser(PickerParameters pickerParameters, int[] points, long[] timeSteps_ms, byte[] buffer, int numberUsedChannels) {
                return new HoTTlogReader.EscLogParser(pickerParameters, points, timeSteps_ms, buffer);
            }

            @Override
            public HoTTbinReader.BinParser createBinParser2(PickerParameters pickerParameters, long[] timeSteps_ms, byte[][] buffers) {
                return new HoTTbinReader2.EscBinParser(pickerParameters, timeSteps_ms, buffers);
            }

            @Override
            public HoTTbinReader.BinParser createBinParser2(PickerParameters pickerParameters, int[] points, long[] timeSteps_ms, byte[][] buffers) {
                return new HoTTbinReader2.EscBinParser(pickerParameters, points, timeSteps_ms, buffers);
            }

            @Override
            public HoTTbinReader.BinParser createBinParserD(PickerParameters pickerParameters, long[] timeSteps_ms, byte[][] buffers) {
                return new HoTTbinReaderD.EscBinParser(pickerParameters, timeSteps_ms, buffers);
            }

            @Override
            public HoTTbinReader.BinParser createBinParserD(PickerParameters pickerParameters, int[] points, long[] timeSteps_ms, byte[][] buffers) {
                return new HoTTbinReaderD.EscBinParser(pickerParameters, points, timeSteps_ms, buffers);
            }

            @Override
            public HoTTlogReader.LogParser createLogParserD(PickerParameters pickerParameters, int[] points, long[] timeSteps_ms, byte[] buffer, int numberUsedChannels) {
                return new HoTTlogReader.EscLogParser(pickerParameters, points, timeSteps_ms, buffer);
            }
        }
        ,
        ESC2(8, "ESC2", "AIR_ESC2"){

            @Override
            public HoTTbinReader.BinParser createBinParser(PickerParameters pickerParameters, int[] points, long[] timeSteps_ms, byte[][] buffers) {
                return new HoTTbinReader.EscBinParser(pickerParameters, points, timeSteps_ms, buffers);
            }

            @Override
            public HoTTlogReader.LogParser createLogParser(PickerParameters pickerParameters, int[] points, long[] timeSteps_ms, byte[] buffer, int numberUsedChannels) {
                return new HoTTlogReader.Esc2LogParser(pickerParameters, points, timeSteps_ms, buffer);
            }

            @Override
            public HoTTbinReader.BinParser createBinParser2(PickerParameters pickerParameters, long[] timeSteps_ms, byte[][] buffers) {
                return new HoTTbinReader2.EscBinParser(pickerParameters, timeSteps_ms, buffers);
            }

            @Override
            public HoTTbinReader.BinParser createBinParser2(PickerParameters pickerParameters, int[] points, long[] timeSteps_ms, byte[][] buffers) {
                return new HoTTbinReader2.EscBinParser(pickerParameters, points, timeSteps_ms, buffers);
            }

            @Override
            public HoTTbinReader.BinParser createBinParserD(PickerParameters pickerParameters, long[] timeSteps_ms, byte[][] buffers) {
                return new HoTTbinReaderD.EscBinParser(pickerParameters, timeSteps_ms, buffers);
            }

            @Override
            public HoTTbinReader.BinParser createBinParserD(PickerParameters pickerParameters, int[] points, long[] timeSteps_ms, byte[][] buffers) {
                return new HoTTbinReaderD.EscBinParser(pickerParameters, points, timeSteps_ms, buffers);
            }

            @Override
            public HoTTlogReader.LogParser createLogParserD(PickerParameters pickerParameters, int[] points, long[] timeSteps_ms, byte[] buffer, int numberUsedChannels) {
                return new HoTTlogReader.Esc2LogParser(pickerParameters, points, timeSteps_ms, buffer);
            }
        }
        ,
        ESC3(9, "ESC3", "AIR_ESC3"){

            @Override
            public HoTTbinReader.BinParser createBinParser(PickerParameters pickerParameters, int[] points, long[] timeSteps_ms, byte[][] buffers) {
                return new HoTTbinReader.EscBinParser(pickerParameters, points, timeSteps_ms, buffers);
            }

            @Override
            public HoTTlogReader.LogParser createLogParser(PickerParameters pickerParameters, int[] points, long[] timeSteps_ms, byte[] buffer, int numberUsedChannels) {
                return new HoTTlogReader.Esc3LogParser(pickerParameters, points, timeSteps_ms, buffer);
            }

            @Override
            public HoTTbinReader.BinParser createBinParser2(PickerParameters pickerParameters, long[] timeSteps_ms, byte[][] buffers) {
                return new HoTTbinReader2.EscBinParser(pickerParameters, timeSteps_ms, buffers);
            }

            @Override
            public HoTTbinReader.BinParser createBinParser2(PickerParameters pickerParameters, int[] points, long[] timeSteps_ms, byte[][] buffers) {
                return new HoTTbinReader2.EscBinParser(pickerParameters, points, timeSteps_ms, buffers);
            }

            @Override
            public HoTTbinReader.BinParser createBinParserD(PickerParameters pickerParameters, long[] timeSteps_ms, byte[][] buffers) {
                return new HoTTbinReaderD.EscBinParser(pickerParameters, timeSteps_ms, buffers);
            }

            @Override
            public HoTTbinReader.BinParser createBinParserD(PickerParameters pickerParameters, int[] points, long[] timeSteps_ms, byte[][] buffers) {
                return new HoTTbinReaderD.EscBinParser(pickerParameters, points, timeSteps_ms, buffers);
            }

            @Override
            public HoTTlogReader.LogParser createLogParserD(PickerParameters pickerParameters, int[] points, long[] timeSteps_ms, byte[] buffer, int numberUsedChannels) {
                return new HoTTlogReader.Esc3LogParser(pickerParameters, points, timeSteps_ms, buffer);
            }
        }
        ,
        ESC4(10, "ESC4", "AIR_ESC4"){

            @Override
            public HoTTbinReader.BinParser createBinParser(PickerParameters pickerParameters, int[] points, long[] timeSteps_ms, byte[][] buffers) {
                return new HoTTbinReader.EscBinParser(pickerParameters, points, timeSteps_ms, buffers);
            }

            @Override
            public HoTTlogReader.LogParser createLogParser(PickerParameters pickerParameters, int[] points, long[] timeSteps_ms, byte[] buffer, int numberUsedChannels) {
                return new HoTTlogReader.Esc4LogParser(pickerParameters, points, timeSteps_ms, buffer);
            }

            @Override
            public HoTTbinReader.BinParser createBinParser2(PickerParameters pickerParameters, long[] timeSteps_ms, byte[][] buffers) {
                return new HoTTbinReader2.EscBinParser(pickerParameters, timeSteps_ms, buffers);
            }

            @Override
            public HoTTbinReader.BinParser createBinParser2(PickerParameters pickerParameters, int[] points, long[] timeSteps_ms, byte[][] buffers) {
                return new HoTTbinReader2.EscBinParser(pickerParameters, points, timeSteps_ms, buffers);
            }

            @Override
            public HoTTbinReader.BinParser createBinParserD(PickerParameters pickerParameters, long[] timeSteps_ms, byte[][] buffers) {
                return new HoTTbinReaderD.EscBinParser(pickerParameters, timeSteps_ms, buffers);
            }

            @Override
            public HoTTbinReader.BinParser createBinParserD(PickerParameters pickerParameters, int[] points, long[] timeSteps_ms, byte[][] buffers) {
                return new HoTTbinReaderD.EscBinParser(pickerParameters, points, timeSteps_ms, buffers);
            }

            @Override
            public HoTTlogReader.LogParser createLogParserD(PickerParameters pickerParameters, int[] points, long[] timeSteps_ms, byte[] buffer, int numberUsedChannels) {
                return new HoTTlogReader.Esc4LogParser(pickerParameters, points, timeSteps_ms, buffer);
            }
        }
        ,
        CHANNEL(6, "Channel", "N/A"){

            @Override
            public HoTTbinReader.BinParser createBinParser(PickerParameters pickerParameters, int[] points, long[] timeSteps_ms, byte[][] buffers) {
                return new HoTTbinReader.ChnBinParser(pickerParameters, points, timeSteps_ms, buffers);
            }

            @Override
            public HoTTlogReader.LogParser createLogParser(PickerParameters pickerParameters, int[] points, long[] timeSteps_ms, byte[] buffer, int numberUsedChannels) {
                return new HoTTlogReader.ChnLogParser(pickerParameters, points, timeSteps_ms, buffer, numberUsedChannels);
            }

            @Override
            public HoTTbinReader.BinParser createBinParser2(PickerParameters pickerParameters, long[] timeSteps_ms, byte[][] buffers) {
                return new HoTTbinReader2.ChnBinParser(pickerParameters, timeSteps_ms, buffers);
            }

            @Override
            public HoTTbinReader.BinParser createBinParser2(PickerParameters pickerParameters, int[] points, long[] timeSteps_ms, byte[][] buffers) {
                return new HoTTbinReader2.ChnBinParser(pickerParameters, points, timeSteps_ms, buffers);
            }

            @Override
            public HoTTbinReader.BinParser createBinParserD(PickerParameters pickerParameters, long[] timeSteps_ms, byte[][] buffers) {
                return new HoTTbinReaderD.ChnBinParser(pickerParameters, timeSteps_ms, buffers);
            }

            @Override
            public HoTTbinReader.BinParser createBinParserD(PickerParameters pickerParameters, int[] points, long[] timeSteps_ms, byte[][] buffers) {
                return new HoTTbinReaderD.ChnBinParser(pickerParameters, points, timeSteps_ms, buffers);
            }

            @Override
            public HoTTlogReader.LogParser createLogParserD(PickerParameters pickerParameters, int[] points, long[] timeSteps_ms, byte[] buffer, int numberUsedChannels) {
                return new HoTTlogReader.ChnLogParser(pickerParameters, points, timeSteps_ms, buffer, numberUsedChannels);
            }
        };

        private final String value;
        private final String detectedName;
        private final int channelNumber;
        public static final Sensor[] VALUES;

        private Sensor(int channelNumber, String value, String detectedName) {
            this.value = value;
            this.detectedName = detectedName;
            this.channelNumber = channelNumber;
        }

        public String value() {
            return this.value;
        }

        public abstract HoTTbinReader.BinParser createBinParser(PickerParameters var1, int[] var2, long[] var3, byte[][] var4);

        public abstract HoTTlogReader.LogParser createLogParser(PickerParameters var1, int[] var2, long[] var3, byte[] var4, int var5);

        public abstract HoTTbinReader.BinParser createBinParser2(PickerParameters var1, long[] var2, byte[][] var3);

        public abstract HoTTbinReader.BinParser createBinParser2(PickerParameters var1, int[] var2, long[] var3, byte[][] var4);

        public abstract HoTTbinReader.BinParser createBinParserD(PickerParameters var1, long[] var2, byte[][] var3);

        public abstract HoTTbinReader.BinParser createBinParserD(PickerParameters var1, int[] var2, long[] var3, byte[][] var4);

        public abstract HoTTlogReader.LogParser createLogParserD(PickerParameters var1, int[] var2, long[] var3, byte[] var4, int var5);

        public static Sensor fromOrdinal(int ordinal) {
            return VALUES[ordinal];
        }

        @Nullable
        public static Sensor fromSensorByte(byte sensorByte) {
            Sensor sensor = null;
            switch (sensorByte) {
                case -119: 
                case -112: {
                    sensor = VARIO;
                    break;
                }
                case -118: 
                case -96: {
                    sensor = GPS;
                    break;
                }
                case -115: 
                case -48: {
                    sensor = GAM;
                    break;
                }
                case -114: 
                case -32: {
                    sensor = EAM;
                    break;
                }
                case -116: 
                case -64: {
                    sensor = ESC;
                    break;
                }
            }
            return sensor;
        }

        @Nullable
        public static Sensor fromChannelNumber(int channelNumber) {
            for (Sensor sensor : VALUES) {
                if (channelNumber != sensor.channelNumber) continue;
                return sensor;
            }
            return null;
        }

        @Nullable
        public static Sensor fromValue(String value) {
            for (Sensor sensor : VALUES) {
                if (!value.equalsIgnoreCase(sensor.value)) continue;
                return sensor;
            }
            return null;
        }

        @Nullable
        public static Sensor fromDetectedName(String detectedName) {
            for (Sensor sensor : VALUES) {
                if (!detectedName.equalsIgnoreCase(sensor.detectedName)) continue;
                return sensor;
            }
            return null;
        }

        public static EnumSet<Sensor> getSetFromSignature(String sensorSignature) {
            EnumSet sensors = sensorSignature.isEmpty() ? EnumSet.noneOf(Sensor.class) : Arrays.stream(sensorSignature.split(",")).map(Sensor::fromValue).filter(Objects::nonNull).collect(Collectors.toCollection(() -> EnumSet.noneOf(Sensor.class)));
            sensors.add((Sensor)RECEIVER);
            sensors.remove((Object)CHANNEL);
            return sensors;
        }

        public static EnumSet<Sensor> getSetFromDetected(String detectedSensors) {
            EnumSet sensors = detectedSensors.isEmpty() ? EnumSet.noneOf(Sensor.class) : Arrays.stream(detectedSensors.split(",")).map(Sensor::fromDetectedName).filter(Objects::nonNull).collect(Collectors.toCollection(() -> EnumSet.noneOf(Sensor.class)));
            sensors.add((Sensor)RECEIVER);
            sensors.remove((Object)CHANNEL);
            return sensors;
        }

        public static StringBuilder getSetAsSignature(EnumSet<Sensor> sensors) {
            Object tmpSensors = sensors.clone();
            ((AbstractCollection)tmpSensors).add(RECEIVER);
            return new StringBuilder(tmpSensors.stream().map(s -> s.value).collect(Collectors.joining(",")));
        }

        public static String getSetAsDetected(EnumSet<Sensor> sensors) {
            Object tmpSensors = sensors.clone();
            ((AbstractCollection)tmpSensors).add(RECEIVER);
            return tmpSensors.stream().map(s -> s.detectedName).collect(Collectors.joining(","));
        }

        public static boolean[] getActiveSensors(EnumSet<Sensor> sensors) {
            boolean[] activeSensors = new boolean[VALUES.length];
            for (int i = 0; i < VALUES.length; ++i) {
                Sensor sensor = VALUES[i];
                activeSensors[i] = sensors.contains((Object)sensor);
            }
            return activeSensors;
        }

        public static BitSet getSensors(EnumSet<Sensor> sensors) {
            BitSet sensorBitSet = new BitSet();
            for (Sensor sensor : sensors) {
                sensorBitSet.set(sensor.ordinal());
            }
            return sensorBitSet;
        }

        public static Set<Integer> getChannelNumbers(EnumSet<Sensor> sensors) {
            HashSet<Integer> channelNumbers = new HashSet<Integer>();
            channelNumbers.add(Sensor.RECEIVER.channelNumber);
            channelNumbers.add(Sensor.CHANNEL.channelNumber);
            for (Sensor sensor : sensors) {
                channelNumbers.add(sensor.channelNumber);
            }
            return channelNumbers;
        }

        public int getChannelNumber() {
            return this.channelNumber;
        }

        static {
            VALUES = Sensor.values();
        }
    }

    @FunctionalInterface
    static interface CheckedConsumer<T> {
        public void accept(T var1) throws DataInconsitsentException, IOException, DataTypeException;
    }
}

