/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.graphics;

import org.eclipse.swt.SWT;
import org.eclipse.swt.graphics.RGB;

public final class PaletteData {
    public boolean isDirect;
    public RGB[] colors;
    public int redMask;
    public int greenMask;
    public int blueMask;
    public int redShift;
    public int greenShift;
    public int blueShift;

    public PaletteData(RGB ... colors) {
        if (colors == null) {
            SWT.error(4);
        }
        this.colors = colors;
        this.isDirect = false;
    }

    public PaletteData(int redMask, int greenMask, int blueMask) {
        this.redMask = redMask;
        this.greenMask = greenMask;
        this.blueMask = blueMask;
        this.isDirect = true;
        this.redShift = this.shiftForMask(redMask);
        this.greenShift = this.shiftForMask(greenMask);
        this.blueShift = this.shiftForMask(blueMask);
    }

    public int getPixel(RGB rgb) {
        if (rgb == null) {
            SWT.error(4);
        }
        if (this.isDirect) {
            int pixel = 0;
            pixel |= (this.redShift < 0 ? rgb.red << -this.redShift : rgb.red >>> this.redShift) & this.redMask;
            pixel |= (this.greenShift < 0 ? rgb.green << -this.greenShift : rgb.green >>> this.greenShift) & this.greenMask;
            return pixel |= (this.blueShift < 0 ? rgb.blue << -this.blueShift : rgb.blue >>> this.blueShift) & this.blueMask;
        }
        int i2 = 0;
        while (i2 < this.colors.length) {
            if (this.colors[i2].equals(rgb)) {
                return i2;
            }
            ++i2;
        }
        SWT.error(5);
        return 0;
    }

    public RGB getRGB(int pixel) {
        if (this.isDirect) {
            int r2 = pixel & this.redMask;
            r2 = this.redShift < 0 ? r2 >>> -this.redShift : r2 << this.redShift;
            int g2 = pixel & this.greenMask;
            g2 = this.greenShift < 0 ? g2 >>> -this.greenShift : g2 << this.greenShift;
            int b2 = pixel & this.blueMask;
            b2 = this.blueShift < 0 ? b2 >>> -this.blueShift : b2 << this.blueShift;
            return new RGB(r2, g2, b2);
        }
        if (pixel < 0 || pixel >= this.colors.length) {
            SWT.error(5);
        }
        return this.colors[pixel];
    }

    public RGB[] getRGBs() {
        return this.colors;
    }

    int shiftForMask(int mask) {
        int i2 = 31;
        while (i2 >= 0) {
            if ((mask >> i2 & 1) != 0) {
                return 7 - i2;
            }
            --i2;
        }
        return 32;
    }
}

