/*
 * Decompiled with CFR 0.152.
 */
package kotlin.random;

import kotlin.Metadata;
import kotlin.SinceKotlin;
import kotlin.jvm.internal.Intrinsics;
import kotlin.random.Random;
import kotlin.random.XorWowRandom;
import kotlin.ranges.IntRange;
import kotlin.ranges.LongRange;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=2, d1={"\u0000:\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\u0010\t\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\u0010\u0006\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u001a\u0010\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u0003H\u0007\u001a\u0010\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u0004H\u0007\u001a\u0018\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\bH\u0000\u001a\u0018\u0010\n\u001a\u00020\u000b2\u0006\u0010\u0007\u001a\u00020\f2\u0006\u0010\t\u001a\u00020\fH\u0000\u001a\u0018\u0010\n\u001a\u00020\u000b2\u0006\u0010\u0007\u001a\u00020\u00032\u0006\u0010\t\u001a\u00020\u0003H\u0000\u001a\u0018\u0010\n\u001a\u00020\u000b2\u0006\u0010\u0007\u001a\u00020\u00042\u0006\u0010\t\u001a\u00020\u0004H\u0000\u001a\u0014\u0010\r\u001a\u00020\u0003*\u00020\u00012\u0006\u0010\u000e\u001a\u00020\u000fH\u0007\u001a\u0014\u0010\u0010\u001a\u00020\u0004*\u00020\u00012\u0006\u0010\u000e\u001a\u00020\u0011H\u0007\u001a\u0014\u0010\u0012\u001a\u00020\u0003*\u00020\u00032\u0006\u0010\u0013\u001a\u00020\u0003H\u0000\u00a8\u0006\u0014"}, d2={"Random", "Lkotlin/random/Random;", "seed", "", "", "boundsErrorMessage", "", "from", "", "until", "checkRangeBounds", "", "", "nextInt", "range", "Lkotlin/ranges/IntRange;", "nextLong", "Lkotlin/ranges/LongRange;", "takeUpperBits", "bitCount", "kotlin-stdlib"})
public final class RandomKt {
    @SinceKotlin(version="1.3")
    @NotNull
    public static final Random Random(int seed) {
        return new XorWowRandom(seed, seed >> 31);
    }

    @SinceKotlin(version="1.3")
    @NotNull
    public static final Random Random(long seed) {
        return new XorWowRandom((int)seed, (int)(seed >> 32));
    }

    @SinceKotlin(version="1.3")
    public static final int nextInt(@NotNull Random $receiver, @NotNull IntRange range) {
        Intrinsics.checkParameterIsNotNull($receiver, "receiver$0");
        Intrinsics.checkParameterIsNotNull(range, "range");
        if (range.isEmpty()) {
            throw (Throwable)new IllegalArgumentException("Cannot get random in empty range: " + range);
        }
        return range.getLast() < Integer.MAX_VALUE ? $receiver.nextInt(range.getFirst(), range.getLast() + 1) : (range.getFirst() > Integer.MIN_VALUE ? $receiver.nextInt(range.getFirst() - 1, range.getLast()) + 1 : $receiver.nextInt());
    }

    @SinceKotlin(version="1.3")
    public static final long nextLong(@NotNull Random $receiver, @NotNull LongRange range) {
        Intrinsics.checkParameterIsNotNull($receiver, "receiver$0");
        Intrinsics.checkParameterIsNotNull(range, "range");
        if (range.isEmpty()) {
            throw (Throwable)new IllegalArgumentException("Cannot get random in empty range: " + range);
        }
        return range.getLast() < Long.MAX_VALUE ? $receiver.nextLong(range.getStart(), range.getEndInclusive() + 1L) : (range.getStart() > Long.MIN_VALUE ? $receiver.nextLong(range.getStart() - 1L, range.getEndInclusive()) + 1L : $receiver.nextLong());
    }

    public static final int takeUpperBits(int $receiver, int bitCount) {
        return $receiver >>> 32 - bitCount & -bitCount >> 31;
    }

    public static final void checkRangeBounds(int from, int until) {
        boolean bl;
        boolean bl2 = bl = until > from;
        if (!bl) {
            String string2 = RandomKt.boundsErrorMessage(from, until);
            throw (Throwable)new IllegalArgumentException(string2.toString());
        }
    }

    public static final void checkRangeBounds(long from, long until) {
        boolean bl;
        boolean bl2 = bl = until > from;
        if (!bl) {
            String string2 = RandomKt.boundsErrorMessage(from, until);
            throw (Throwable)new IllegalArgumentException(string2.toString());
        }
    }

    public static final void checkRangeBounds(double from, double until) {
        boolean bl;
        boolean bl2 = bl = until > from;
        if (!bl) {
            String string2 = RandomKt.boundsErrorMessage(from, until);
            throw (Throwable)new IllegalArgumentException(string2.toString());
        }
    }

    @NotNull
    public static final String boundsErrorMessage(@NotNull Object from, @NotNull Object until) {
        Intrinsics.checkParameterIsNotNull(from, "from");
        Intrinsics.checkParameterIsNotNull(until, "until");
        return "Random range is empty: [" + from + ", " + until + ").";
    }
}

