/*
 * Decompiled with CFR 0.152.
 */
package gde.histo.datasources;

import com.sun.istack.Nullable;
import gde.Analyzer;
import gde.GDE;
import gde.device.ScoreLabelTypes;
import gde.exception.DataInconsitsentException;
import gde.exception.DataTypeException;
import gde.exception.NotSupportedFileFormatException;
import gde.exception.ThrowableUtils;
import gde.histo.cache.ExtendedVault;
import gde.histo.cache.VaultCollector;
import gde.histo.cache.VaultReaderWriter;
import gde.histo.datasources.DirectoryScanner;
import gde.histo.datasources.HistoSet;
import gde.histo.datasources.SourceDataSetExplorer;
import gde.histo.datasources.SourceFolders;
import gde.histo.exclusions.ExclusionData;
import gde.histo.recordings.TrailRecordSet;
import gde.log.Logger;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.TreeMap;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.stream.Collectors;

public final class VaultPicker {
    private static final String $CLASS_NAME = VaultPicker.class.getName();
    private static final Logger log = Logger.getLogger($CLASS_NAME);
    private static final int CACHE_BENEFIT = 10;
    private static final DuplicateHandling DUPLICATE_HANDLING = DuplicateHandling.DISCARD;
    private final DirectoryScanner directoryScanner;
    private final SourceDataSetExplorer sourceDataSetExplorer;
    private final Analyzer analyzer;
    private final TreeMap<Long, List<ExtendedVault>> pickedVaults = new TreeMap(Collections.reverseOrder());
    private List<ExtendedVault> suppressedVaults = new ArrayList<ExtendedVault>();
    private long recordSetBytesSum = 0L;
    private int elapsedTime_us = 0;
    private TrailRecordSet trailRecordSet = null;

    public VaultPicker() {
        this.analyzer = Analyzer.getInstance();
        this.directoryScanner = new DirectoryScanner(this.analyzer);
        this.sourceDataSetExplorer = new SourceDataSetExplorer(this.analyzer, this.directoryScanner.getSourceFolders(), false);
    }

    public String toString() {
        String result = String.format("totalTrussesCount=%,d  availableVaultsCount=%,d recordSetBytesSum=%,d elapsedTime_ms=%,d", this.getTrussesCount(), this.getTimeStepSize(), this.recordSetBytesSum, this.getElapsedTime_ms());
        return result;
    }

    public void initialize() {
        for (List<ExtendedVault> timestampHistoVaults : this.pickedVaults.values()) {
            timestampHistoVaults.clear();
        }
        this.pickedVaults.clear();
        this.suppressedVaults.clear();
        this.recordSetBytesSum = 0L;
        this.elapsedTime_us = 0;
        this.trailRecordSet = null;
        log.log(Level.FINER, "done", this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized boolean rebuild4Screening(HistoSet.RebuildStep rebuildStep) throws FileNotFoundException, IOException, NotSupportedFileFormatException, DataInconsitsentException, DataTypeException {
        HistoSet.RebuildStep realRebuildStep = rebuildStep;
        Optional<ProgressManager> progress = GDE.isWithUi() ? Optional.of(new ProgressManager()) : Optional.empty();
        try {
            long startNanoTime = System.nanoTime();
            log.log(Level.FINER, ">", (Object)rebuildStep);
            progress.ifPresent(p -> p.set(LoadProgress.STARTED));
            if (realRebuildStep.isEqualOrBiggerThan(HistoSet.RebuildStep.A_HISTOSET)) {
                this.directoryScanner.initialize();
                log.fine(() -> String.format("directoryScanner      initialize", new Object[0]));
            }
            progress.ifPresent(p -> p.set(LoadProgress.INITIALIZED));
            if (realRebuildStep.isEqualOrBiggerThan(HistoSet.RebuildStep.F_FILE_CHECK)) {
                realRebuildStep = this.directoryScanner.isValidated(rebuildStep);
                log.time(() -> String.format("  %3d file paths verified           time=%,6d [ms]", this.directoryScanner.getValidatedFoldersCount(), TimeUnit.NANOSECONDS.toMillis(System.nanoTime() - startNanoTime + 500000L)));
            }
            progress.ifPresent(p -> p.set(LoadProgress.PATHS_VERIFIED));
            if (realRebuildStep.isEqualOrBiggerThan(HistoSet.RebuildStep.B_HISTOVAULTS)) {
                this.initialize();
                this.sourceDataSetExplorer.setStatusMessages(this.directoryScanner.isSlowFolderAccess());
                boolean reReadFiles = !this.directoryScanner.isChannelChangeOnly();
                this.sourceDataSetExplorer.screen4Trusses(this.directoryScanner.getSourceFolders().getMap(), reReadFiles);
                long millis = TimeUnit.NANOSECONDS.toMillis(System.nanoTime() - startNanoTime);
                if (millis > 0L) {
                    log.time(() -> String.format("%,5d trusses    select folders     time=%,6d [ms] :: per second:%5d", this.sourceDataSetExplorer.getTrusses().size(), millis, (long)(this.sourceDataSetExplorer.getTrusses().size() * 1000) / millis));
                }
                progress.ifPresent(p -> p.set(LoadProgress.SCANNED));
                if (!this.sourceDataSetExplorer.getTrusses().isEmpty()) {
                    TrussJobs trussJobs = TrussJobs.createTrussJobs(this.sourceDataSetExplorer.getTrusses());
                    progress.ifPresent(p -> p.set(LoadProgress.MATCHED));
                    int jobSize = trussJobs.values().parallelStream().mapToInt(List::size).sum();
                    progress.ifPresent(p -> p.reInit(LoadProgress.RESTORED, jobSize, 10));
                    this.loadVaultsFromCache(trussJobs, progress);
                    int totalEstimatedEffort = this.pickedVaults.size() + 10 * (jobSize - this.pickedVaults.size());
                    double timeQuotaDone = this.pickedVaults.size() / totalEstimatedEffort;
                    int progressPercentageDone = (int)((double)(LoadProgress.CACHED.endPercentage - LoadProgress.MATCHED.endPercentage) * timeQuotaDone);
                    progress.ifPresent(p -> p.set(Math.max(GDE.getUiNotification().getProgressPercentage(), LoadProgress.MATCHED.endPercentage + progressPercentageDone)));
                    long recordSetBytesCachedSum = this.recordSetBytesSum;
                    long nanoTime = System.nanoTime();
                    this.loadVaultsFromFiles(trussJobs, progress);
                    long loadCount = trussJobs.values().parallelStream().mapToInt(Collection::size).sum();
                    if (loadCount > 0L) {
                        long micros = TimeUnit.NANOSECONDS.toMicros(System.nanoTime() - nanoTime);
                        log.time(() -> String.format("%,5d recordsets create from files  time=%,6d [ms] :: per second:%5d :: Rate=%,6d MiB/s", loadCount, micros / 1000L, loadCount * 1000000L / micros, (int)((double)(this.recordSetBytesSum - recordSetBytesCachedSum) / 1.024 / 1.024 / (double)micros)));
                    }
                    nanoTime = System.nanoTime();
                    long cacheSize_B = 0L;
                    long loadCount2 = trussJobs.values().parallelStream().mapToInt(Collection::size).sum();
                    if (loadCount2 > 0L) {
                        cacheSize_B = this.analyzer.getDataAccess().getCacheSize();
                        new VaultReaderWriter(this.analyzer, Optional.empty()).storeInCaches(trussJobs);
                        if (this.analyzer.getDataAccess().getCacheSize() - cacheSize_B > 0L) {
                            long micros = TimeUnit.NANOSECONDS.toMicros(System.nanoTime() - nanoTime);
                            log.time(() -> String.format("%,5d recordsets store in cache     time=%,6d [ms] :: per second:%5d :: Rate=%,6d MiB/s", loadCount2, micros / 1000L, loadCount2 * 1000000L / micros, (int)((double)(this.recordSetBytesSum - recordSetBytesCachedSum) / 1.024 / 1.024 / (double)micros)));
                        }
                    }
                }
            }
            progress.ifPresent(p -> p.set(LoadProgress.CACHED));
            if (this.analyzer.getSettings().isSuppressMode()) {
                this.suppressedVaults.addAll(this.removeSuppressedHistoVaults());
            }
            if (realRebuildStep.isEqualOrBiggerThan(HistoSet.RebuildStep.C_TRAILRECORDSET)) {
                long nanoTime = System.nanoTime();
                this.trailRecordSet = TrailRecordSet.createRecordSet(this.analyzer);
                this.trailRecordSet.initializeFromVaults(this.pickedVaults);
                this.trailRecordSet.applyTemplate(true);
                if (this.recordSetBytesSum > 0L) {
                    long micros = TimeUnit.NANOSECONDS.toMicros(System.nanoTime() - nanoTime);
                    log.time(() -> String.format("%,5d timeSteps new TrailRecordSet  time=%,6d [ms] :: per second:%5d", this.pickedVaults.size(), micros / 1000L, this.pickedVaults.size() > 0 ? (long)(this.pickedVaults.size() * 1000000) / micros : 0L));
                }
            } else if (realRebuildStep.isEqualOrBiggerThan(HistoSet.RebuildStep.D_TRAIL_DATA)) {
                long nanoTime = System.nanoTime();
                this.trailRecordSet.initializeTrailSelectors();
                this.trailRecordSet.refillFromVaults(this.pickedVaults);
                long micros = TimeUnit.NANOSECONDS.toMicros(System.nanoTime() - nanoTime);
                log.time(() -> String.format("%,5d timeSteps  to TrailRecordSet  time=%,6d [ms] :: per second:%5d", this.pickedVaults.size(), micros / 1000L, this.pickedVaults.size() > 0 ? (long)(this.pickedVaults.size() * 1000000) / micros : 0L));
            }
            progress.ifPresent(p -> p.set(LoadProgress.RECORDED));
            this.elapsedTime_us = (int)((System.nanoTime() - startNanoTime + 500000L) / 1000L);
            log.time(() -> String.format("%,5d timeSteps  total              time=%,6d [ms] :: per second:%5d :: Rate=%,6d MiB/s", this.pickedVaults.size(), this.elapsedTime_us / 1000, this.pickedVaults.size() * 1000000 / this.elapsedTime_us, (int)((double)this.recordSetBytesSum / 1.024 / 1.024 / (double)this.elapsedTime_us)));
        }
        catch (IOException | UncheckedIOException e) {
            ThrowableUtils.rethrow(e);
        }
        catch (Exception e) {
            log.log(Level.SEVERE, e.getMessage(), e);
        }
        finally {
            progress.ifPresent(p -> p.set(LoadProgress.DONE));
        }
        return realRebuildStep.isEqualOrBiggerThan(HistoSet.RebuildStep.D_TRAIL_DATA);
    }

    private void loadVaultsFromFiles(TrussJobs trussJobs, Optional<ProgressManager> progress) {
        int remainingJobSize = trussJobs.values().parallelStream().mapToInt(List::size).sum();
        if (remainingJobSize <= 0) {
            return;
        }
        progress.ifPresent(p -> p.reInit(LoadProgress.CACHED, remainingJobSize, 1));
        VaultReaderWriter vaultReaderWriter = new VaultReaderWriter(this.analyzer, Optional.empty());
        trussJobs.entrySet().parallelStream().forEach(trussJobsEntry -> {
            vaultReaderWriter.loadFromFile((Path)trussJobsEntry.getKey(), (List)trussJobsEntry.getValue());
            for (VaultCollector vaultCollector : (List)trussJobsEntry.getValue()) {
                ExtendedVault histoVault = vaultCollector.getVault();
                if (!histoVault.isTruss()) {
                    this.putVault(histoVault);
                    this.recordSetBytesSum += (long)histoVault.getScorePoint(ScoreLabelTypes.LOG_RECORD_SET_BYTES.ordinal()).intValue();
                    continue;
                }
                log.info(() -> String.format("vault has no log data %,7d kiB %s", histoVault.getLogFileLength() / 1024L, histoVault.getLoadFilePath()));
            }
            progress.ifPresent(p -> p.countInLoop(((List)trussJobsEntry.getValue()).size()));
        });
    }

    private void loadVaultsFromCache(TrussJobs trussJobs, Optional<ProgressManager> progress) throws IOException {
        long nanoTime = System.nanoTime();
        long hitCount = VaultReaderWriter.getInnerCacheHitCount();
        int tmpHistoSetsSize = this.pickedVaults.size();
        VaultReaderWriter vaultReaderWriter = new VaultReaderWriter(this.analyzer, progress);
        for (ExtendedVault histoVault : vaultReaderWriter.loadFromCaches(trussJobs)) {
            if (!histoVault.isTruss()) {
                this.putVault(histoVault);
                this.recordSetBytesSum += (long)histoVault.getScorePoint(ScoreLabelTypes.LOG_RECORD_SET_BYTES.ordinal()).intValue();
                continue;
            }
            log.info(() -> String.format("vault has no log data %,7d kiB %s", histoVault.getLogFileLength() / 1024L, histoVault.getLoadFilePath()));
        }
        int loadCount = this.pickedVaults.size() - tmpHistoSetsSize;
        if (loadCount > 0) {
            long micros = TimeUnit.NANOSECONDS.toMicros(System.nanoTime() - nanoTime);
            log.time(() -> String.format("%,5d/%,5d      vaults cached/hit  time=%,6d [ms] :: per second:%5d :: Rate=%,6d MiB/s", loadCount, VaultReaderWriter.getInnerCacheHitCount() - hitCount, micros / 1000L, (long)(loadCount * 1000000) / micros, (int)((double)this.recordSetBytesSum / 1.024 / 1.024 / (double)micros)));
        }
    }

    private List<ExtendedVault> removeSuppressedHistoVaults() {
        long totalSize = this.pickedVaults.values().parallelStream().mapToInt(Collection::size).sum();
        ExclusionData exclusionData = new ExclusionData(new DirectoryScanner(this.analyzer).getActiveFolder(), this.analyzer.getDataAccess());
        List<ExtendedVault> removed = this.pickedVaults.values().parallelStream().flatMap(Collection::stream).filter(v -> exclusionData.isExcluded(v.getLoadFileName(), v.getLogRecordsetBaseName())).collect(Collectors.toList());
        for (ExtendedVault vault : removed) {
            log.info(() -> String.format("discarded as per exclusion list   %s %s   %s", vault.getLoadFilePath(), vault.getLogRecordsetBaseName(), vault.getStartTimeStampFormatted()));
            List<ExtendedVault> vaultList = this.pickedVaults.get(vault.getLogStartTimestamp_ms());
            vaultList.remove(vault);
            if (!vaultList.isEmpty()) continue;
            this.pickedVaults.remove(vault.getLogStartTimestamp_ms());
        }
        log.fine(() -> String.format("%04d total trusses --- %04d excluded trusses", totalSize, removed.size()));
        return removed;
    }

    private void putVault(ExtendedVault histoVault) {
        List<ExtendedVault> timeStampHistoVaults = this.pickedVaults.get(histoVault.getLogStartTimestamp_ms());
        if (timeStampHistoVaults == null) {
            timeStampHistoVaults = new ArrayList<ExtendedVault>();
            this.pickedVaults.put(histoVault.getLogStartTimestamp_ms(), timeStampHistoVaults);
            timeStampHistoVaults.add(histoVault);
            log.finer(() -> String.format("added   startTimeStamp=%s  %s  logRecordSetOrdinal=%d  logChannelNumber=%d  %s", histoVault.getStartTimeStampFormatted(), histoVault.getVaultFileName(), histoVault.getLogRecordSetOrdinal(), histoVault.getLogChannelNumber(), histoVault.getLoadFilePath()));
        }
    }

    public int getTrussesCount() {
        return this.sourceDataSetExplorer.getTrusses().size();
    }

    public int getTimeStepSize() {
        return this.getTrailRecordSet() != null ? this.getTrailRecordSet().getTimeStepSize() : 0;
    }

    public int getElapsedTime_ms() {
        return this.elapsedTime_us / 1000;
    }

    @Nullable
    public TrailRecordSet getTrailRecordSet() {
        return this.trailRecordSet;
    }

    public long getRecordSetBytesSum() {
        return this.recordSetBytesSum;
    }

    public List<ExtendedVault> getSuppressedTrusses() {
        return this.suppressedVaults;
    }

    public List<Path> getExcludedFiles() {
        return this.sourceDataSetExplorer.getExcludedFiles();
    }

    public SourceFolders getSourceFolders() {
        return this.directoryScanner.getSourceFolders();
    }

    public int getDirectoryFilesCount() {
        return this.sourceDataSetExplorer.getSourceFiles().size() + this.sourceDataSetExplorer.getNonWorkableCount() + this.sourceDataSetExplorer.getExcludedFiles().size();
    }

    public int getReadFilesCount() {
        return this.sourceDataSetExplorer.getSourceFiles().size();
    }

    public int getMatchingFilesCount() {
        return (int)this.sourceDataSetExplorer.getTrusses().parallelStream().map(VaultCollector::getVault).map(ExtendedVault::getLoadFileAsPath).count();
    }

    public static final class ProgressManager {
        private final GDE.UiNotification presenter = GDE.getUiNotification();
        private double progressCycle = 0.0;
        private int progressStart = 0;
        private int stepSize = 0;
        private int counter = 0;

        public ProgressManager() {
        }

        public ProgressManager(int newEndPercentage, int newTotalCount, int newStepSize) {
            this.reInit(newEndPercentage, newTotalCount, newStepSize);
        }

        public void reInit(LoadProgress loadProgress, int newTotalCount, int newStepSize) {
            this.reInit(loadProgress.endPercentage, newTotalCount, newStepSize);
        }

        public void reInit(int newEndPercentage, int newTotalCount, int newStepSize) {
            this.progressStart = this.presenter.getProgressPercentage();
            this.stepSize = newStepSize;
            this.counter = 0;
            if (newTotalCount == 0) {
                this.presenter.setProgress(newEndPercentage);
                this.progressCycle = 0.0;
            } else {
                this.presenter.setProgress(this.progressStart);
                this.progressCycle = (double)(newEndPercentage - this.progressStart) / (double)newTotalCount;
            }
        }

        public void countInLoop(int increment) {
            int newCounter = this.counter + increment;
            if (this.progressCycle <= 0.0) {
                throw new UnsupportedOperationException();
            }
            if (newCounter % this.stepSize == 0) {
                this.counter = newCounter;
                this.presenter.setProgress((int)((double)(newCounter * this.stepSize) * this.progressCycle + (double)this.progressStart));
            }
        }

        public void set(int percentage) {
            this.presenter.setProgress(percentage);
        }

        public void set(LoadProgress loadProgress) {
            this.presenter.setProgress(loadProgress.endPercentage);
        }
    }

    public static final class TrussJobs {
        private Map<Path, List<VaultCollector>> trussJobs = new HashMap<Path, List<VaultCollector>>();

        public static TrussJobs createTrussJobs(List<VaultCollector> trusses) throws IOException, NotSupportedFileFormatException {
            long nanoTime = System.nanoTime();
            TrussJobs trussJobs = DUPLICATE_HANDLING.getTrussJobs(trusses);
            int jobSize = trussJobs.values().parallelStream().mapToInt(List::size).sum();
            if (jobSize > 0) {
                long micros = TimeUnit.NANOSECONDS.toMicros(System.nanoTime() - nanoTime);
                log.finer(() -> String.format("%,5d trusses    job check          time=%,6d [ms] :: per second:%5d", jobSize, micros / 1000L, (long)(trusses.size() * 1000000) / micros));
            }
            return trussJobs;
        }

        public void clear() {
            this.trussJobs.clear();
        }

        public List<VaultCollector> get(Path path) {
            return this.trussJobs.get(path);
        }

        public synchronized boolean remove(VaultCollector value) {
            Path path = value.getVault().getLoadFileAsPath();
            List<VaultCollector> trussList = this.trussJobs.get(path);
            if (trussList == null) {
                return false;
            }
            boolean removed = trussList.remove(value);
            if (trussList.isEmpty()) {
                this.trussJobs.remove(path);
            }
            return removed;
        }

        private List<VaultCollector> put(Path path, List<VaultCollector> trussList) {
            return this.trussJobs.put(path, trussList);
        }

        public synchronized void add(VaultCollector truss) {
            Path path = truss.getVault().getLoadFileAsPath();
            List<VaultCollector> list = this.get(path);
            if (list == null) {
                list = new ArrayList<VaultCollector>();
                this.put(path, list);
            }
            list.add(truss);
        }

        public Set<Map.Entry<Path, List<VaultCollector>>> entrySet() {
            return this.trussJobs.entrySet();
        }

        public Collection<List<VaultCollector>> values() {
            return this.trussJobs.values();
        }

        public HashMap<String, VaultCollector> getAsVaultNameMap() {
            HashMap<String, VaultCollector> vaultNames = new HashMap<String, VaultCollector>();
            for (Map.Entry<Path, List<VaultCollector>> jobEntry : this.trussJobs.entrySet()) {
                for (VaultCollector vaultCollector : jobEntry.getValue()) {
                    VaultCollector oldVaultCollector = vaultNames.put(vaultCollector.getVault().getVaultName(), vaultCollector);
                    if (oldVaultCollector == null) continue;
                    log.log(Level.WARNING, "duplicate vaultName " + vaultCollector.getVault().getVaultName(), oldVaultCollector.getVault().getLoadFilePath());
                }
            }
            return vaultNames;
        }

        public int size() {
            return this.trussJobs.size();
        }

        public String toString() {
            int maxLen = 10;
            return "TrussJobs [trussJobs=" + (this.trussJobs != null ? this.toString(this.trussJobs.entrySet(), 10) : null) + "]";
        }

        private String toString(Collection<?> collection, int maxLen) {
            StringBuilder builder = new StringBuilder();
            builder.append("[");
            Iterator<?> iterator = collection.iterator();
            for (int i = 0; iterator.hasNext() && i < maxLen; ++i) {
                if (i > 0) {
                    builder.append(", ");
                }
                builder.append(iterator.next());
            }
            builder.append("]");
            return builder.toString();
        }
    }

    public static enum LoadProgress {
        STARTED(2),
        INITIALIZED(5),
        PATHS_VERIFIED(7),
        SCANNED(11),
        MATCHED(22),
        RESTORED(50),
        LOADED(80),
        CACHED(97),
        RECORDED(99),
        DONE(100);

        public int endPercentage;

        private LoadProgress(int endPercentage) {
            this.endPercentage = endPercentage;
        }
    }

    private static enum DuplicateHandling {
        KEEP{

            @Override
            TrussJobs getTrussJobs(List<VaultCollector> trusses) throws IOException, NotSupportedFileFormatException {
                TrussJobs resultMap = new TrussJobs();
                for (VaultCollector truss : trusses) {
                    resultMap.add(truss);
                }
                return resultMap;
            }
        }
        ,
        DISCARD{

            @Override
            TrussJobs getTrussJobs(List<VaultCollector> trusses) throws IOException, NotSupportedFileFormatException {
                TrussJobs resultMap = new TrussJobs();
                HashSet<ExtendedVault> trusses4StartTimes = new HashSet<ExtendedVault>();
                for (VaultCollector truss : trusses) {
                    if (!trusses4StartTimes.add(truss.getVault())) {
                        log.log(Level.WARNING, "duplicate vault was discarded: ", truss);
                        continue;
                    }
                    resultMap.add(truss);
                }
                return resultMap;
            }
        };


        abstract TrussJobs getTrussJobs(List<VaultCollector> var1) throws IOException, NotSupportedFileFormatException;
    }
}

