/*
 * Decompiled with CFR 0.152.
 */
package kotlin.reflect.jvm.internal.impl.name;

import org.jetbrains.annotations.NotNull;

public final class Name
implements Comparable<Name> {
    @NotNull
    private final String name;
    private final boolean special;

    private Name(@NotNull String name, boolean special) {
        this.name = name;
        this.special = special;
    }

    @NotNull
    public String asString() {
        return this.name;
    }

    @NotNull
    public String getIdentifier() {
        if (this.special) {
            throw new IllegalStateException("not identifier: " + this);
        }
        return this.asString();
    }

    public boolean isSpecial() {
        return this.special;
    }

    @Override
    public int compareTo(Name that) {
        return this.name.compareTo(that.name);
    }

    @NotNull
    public static Name identifier(@NotNull String name) {
        return new Name(name, false);
    }

    public static boolean isValidIdentifier(@NotNull String name) {
        if (name.isEmpty() || name.startsWith("<")) {
            return false;
        }
        for (int i2 = 0; i2 < name.length(); ++i2) {
            char ch = name.charAt(i2);
            if (ch != '.' && ch != '/' && ch != '\\') continue;
            return false;
        }
        return true;
    }

    @NotNull
    public static Name special(@NotNull String name) {
        if (!name.startsWith("<")) {
            throw new IllegalArgumentException("special name must start with '<': " + name);
        }
        return new Name(name, true);
    }

    @NotNull
    public static Name guessByFirstCharacter(@NotNull String name) {
        if (name.startsWith("<")) {
            return Name.special(name);
        }
        return Name.identifier(name);
    }

    public String toString() {
        return this.name;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof Name)) {
            return false;
        }
        Name name1 = (Name)o;
        if (this.special != name1.special) {
            return false;
        }
        return this.name.equals(name1.name);
    }

    public int hashCode() {
        int result2 = this.name.hashCode();
        result2 = 31 * result2 + (this.special ? 1 : 0);
        return result2;
    }
}

