/*
 * Decompiled with CFR 0.152.
 */
package de.treichels.hott.report.pdf;

import com.itextpdf.text.DocumentException;
import de.treichels.hott.report.pdf.ITextInlineImageReplacedElementFactory;
import java.io.Closeable;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.io.CloseableKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.xhtmlrenderer.extend.ReplacedElementFactory;
import org.xhtmlrenderer.layout.SharedContext;
import org.xhtmlrenderer.pdf.ITextRenderer;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0016\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bJ\u0018\u0010\u0003\u001a\u00020\u00042\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u0007\u001a\u00020\bH\u0002\u00a8\u0006\u000b"}, d2={"Lde/treichels/hott/report/pdf/PDFReport;", "", "()V", "save", "", "file", "Ljava/io/File;", "html", "", "os", "Ljava/io/OutputStream;", "HoTT-Report-PDF"})
public final class PDFReport {
    public static final PDFReport INSTANCE;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void save(@NotNull File file, @NotNull String html) throws IOException {
        Intrinsics.checkParameterIsNotNull(file, "file");
        Intrinsics.checkParameterIsNotNull(html, "html");
        Closeable closeable = new FileOutputStream(file);
        Throwable throwable = null;
        try {
            FileOutputStream fos = (FileOutputStream)closeable;
            INSTANCE.save(fos, html);
            Unit unit = Unit.INSTANCE;
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            CloseableKt.closeFinally(closeable, throwable);
        }
    }

    private final void save(OutputStream os, String html) throws IOException {
        try {
            SharedContext ctx;
            ITextRenderer renderer = new ITextRenderer();
            SharedContext sharedContext = ctx = renderer.getSharedContext();
            Intrinsics.checkExpressionValueIsNotNull(sharedContext, "ctx");
            ReplacedElementFactory replacedElementFactory = ctx.getReplacedElementFactory();
            Intrinsics.checkExpressionValueIsNotNull(replacedElementFactory, "ctx.replacedElementFactory");
            sharedContext.setReplacedElementFactory(new ITextInlineImageReplacedElementFactory(replacedElementFactory));
            renderer.setDocumentFromString(html);
            renderer.layout();
            renderer.createPDF(os);
        }
        catch (DocumentException e) {
            throw (Throwable)new IOException(e);
        }
    }

    private PDFReport() {
    }

    static {
        PDFReport pDFReport;
        INSTANCE = pDFReport = new PDFReport();
    }
}

