/*
 * Decompiled with CFR 0.152.
 */
package gde.ui.dialog;

import gde.GDE;
import gde.config.Settings;
import gde.data.Record;
import gde.data.RecordSet;
import gde.device.DataTypes;
import gde.device.IDevice;
import gde.messages.Messages;
import gde.ui.DataExplorer;
import gde.ui.SWTResourceManager;
import gde.utils.GPSHelper;
import gde.utils.StringHelper;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.eclipse.swt.custom.CCombo;
import org.eclipse.swt.custom.CLabel;
import org.eclipse.swt.events.HelpEvent;
import org.eclipse.swt.events.HelpListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.events.VerifyEvent;
import org.eclipse.swt.events.VerifyListener;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.layout.RowData;
import org.eclipse.swt.layout.RowLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Dialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public class IgcExportDialog
extends Dialog {
    static final Logger log = Logger.getLogger(IgcExportDialog.class.getName());
    public static final String IGC_PILOT_NAME = "IGC_PILOT_NAME";
    public static final String IGC_CO_PILOT_NAME = "IGC_CO_PILOT_NAME";
    public static final String IGC_GLIDER_CLASS = "IGC_GLIDER_CLASS";
    public static final String IGC_GLIDER_ID = "IGC_GLIDER_ID";
    public static final String IGC_GPS_FIRMWARE_VERSION = "IGC_GPS_FIRMWARE_VERSION";
    public static final String IGC_GPS_HARDWARE_VERSION = "IGC_GPS_HARDWARE_VERSION";
    public static final String IGC_GPS_TYPE_IDENTIFIER = "IGC_GPS_TYPE_IDENTIFIER";
    public static final String IGC_COMPETITION_IDENTIFIER = "IGC_COMPETITION_IDENTIFIER";
    public static final String IGC_COMPETITION_CLASS = "IGC_COMPETITION_CLASS";
    public static final String IGC_UTC_OFFSET = "IGC_UTC_OFFSET";
    Shell dialogShell;
    Group igcHeaderInfoGroup;
    Group extraEntriesGroup;
    Group startAltitudeGroup;
    Group startTimeGroup;
    CLabel separatorLabel;
    CLabel headerARecordLabel;
    CLabel headerRecordDateLabel;
    CLabel headerFixAccuracyLabel;
    CLabel headerPilotLabel;
    CLabel headerCoPilotLabel;
    CLabel headerGliderTypeLabel;
    CLabel headerGliderIdLabel;
    CLabel headerGpsDatumLabel;
    CLabel headerFirmwareVersionLabel;
    CLabel headerHardwareVersionLabel;
    CLabel headerGpsManufacturerModelLabel;
    CLabel headerCompetitionIdLabel;
    CLabel headerCompetitionClassLabel;
    CLabel headerUtcOffsetLabel;
    Text headerARecordText;
    Text headerRecordDateText;
    Text headerFixAccuracyText;
    Text headerPilotText;
    Text headerCoPilotText;
    Text headerGliderIdText;
    Text headerGpsDatumText;
    Text headerFirmwareVersionText;
    Text headerHardwareVersionText;
    Text headerGpsManufacturerModelText;
    Text headerCompetitionIdText;
    Text headerCompetitionClassText;
    CCombo headerGliderTypeText;
    CCombo headerUtcOffsetCombo;
    String headerARecord;
    String headerRecordDate;
    String headerFixAccuracy;
    String headerPilot;
    String headerCoPilot;
    String headerGliderId;
    String headerGpsDatum;
    String headerFirmwareVersion;
    String headerHardwareVersion;
    String headerGpsManufacturerModel;
    String headerCompetitionId;
    String headerCompetitionClass;
    int headerGliderType;
    int headerUtcOffset;
    CLabel startAltitudeLabel;
    CLabel startAltitudeUnitLabel;
    CLabel startTimeLabel;
    CLabel startTimeUnitLabel;
    CLabel latitudeLabel;
    CLabel longitudeLabel;
    Text startAltitudeDescrptionText;
    Text startAltitudeText;
    Text startTimeDescriptionText;
    Text startTimeText;
    Text latitudeText;
    Text longitudeText;
    String startAltitude;
    String startTime;
    String latitude;
    String longitude;
    Button cancelButton;
    Button helpButton;
    Button saveButton;
    final DataExplorer application = DataExplorer.getInstance();
    final Settings settings = Settings.getInstance();
    final String[] gliderTypes = new String[]{"0 - 1500 mm", "1501 - 2000 mm", "2001-2500 mm", "2501-3000 mm", "3001-3500 mm", "3501-4000 mm", "4001-4500 mm", "4501-5000 mm", "5001-5500 mm", "5501-6000 mm", "6001-6500 mm", "6501-7000 mm", "7001-7500 mm", "7501-8000 mm", "8001-8500 mm", "8501-9000 mm", "9001-9500 mm", "9501-10000 mm", "10001-10500 mm", "10501-11000mm"};
    final String[] deltaUTC = new String[]{" -12", " -11", " -10", " -9", " -8", " -7", " -6", " -5", " -4", " -3", " -2", " -1", " 0", " +1", " +2", " +3", " +4", " +5", " +6", " +7", " +8", " +9", " +10", " +11", " +12"};

    public static void main(String[] args) {
        try {
            Display display = Display.getDefault();
            Shell shell = new Shell(display);
            IgcExportDialog inst = new IgcExportDialog(shell, 32768);
            inst.open(3, 4, 5);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public IgcExportDialog(Shell parent, int style) {
        super(parent, style);
    }

    public IgcExportDialog() {
        super(GDE.shell, 32768);
    }

    public void open(int ordinalLongitude, int ordinalLatitude, int ordinalHeight) {
        try {
            this.initializeValues(ordinalLongitude, ordinalLatitude, ordinalHeight);
            Shell parent = this.getParent();
            this.dialogShell = new Shell(parent, 67680);
            this.dialogShell.setLayout((Layout)new FormLayout());
            this.dialogShell.setText(Messages.getString("GDE_MSGT0615"));
            this.dialogShell.layout();
            this.dialogShell.pack();
            this.dialogShell.setSize(800, 480);
            this.dialogShell.addListener(31, new Listener(){

                public void handleEvent(Event event) {
                    switch (event.detail) {
                        case 2: {
                            IgcExportDialog.this.dialogShell.close();
                            event.detail = 0;
                            event.doit = false;
                        }
                    }
                }
            });
            this.dialogShell.addHelpListener(new HelpListener(){

                public void helpRequested(HelpEvent evt) {
                    log.log(Level.FINER, "dialogShell.helpRequested, event=" + String.valueOf(evt));
                    IgcExportDialog.this.application.openHelpDialog("", "HelpInfo_37.html");
                }
            });
            this.igcHeaderInfoGroup = new Group((Composite)this.dialogShell, 0);
            RowLayout personalInfoGroupLayout = new RowLayout(256);
            this.igcHeaderInfoGroup.setLayout((Layout)personalInfoGroupLayout);
            FormData personalInfoGroupLData = new FormData();
            personalInfoGroupLData.width = 500;
            personalInfoGroupLData.height = 364;
            personalInfoGroupLData.left = new FormAttachment(0, 1000, 6);
            personalInfoGroupLData.top = new FormAttachment(0, 1000, 7);
            this.igcHeaderInfoGroup.setLayoutData((Object)personalInfoGroupLData);
            this.igcHeaderInfoGroup.setText(Messages.getString("GDE_MSGT0615"));
            this.igcHeaderInfoGroup.setFont(SWTResourceManager.getFont(GDE.WIDGET_FONT_NAME, GDE.WIDGET_FONT_SIZE + 2, 0));
            this.separatorLabel = new CLabel((Composite)this.igcHeaderInfoGroup, 0);
            RowData headerARecordLabelLData = new RowData();
            headerARecordLabelLData.width = 400;
            headerARecordLabelLData.height = 5;
            this.separatorLabel.setLayoutData((Object)headerARecordLabelLData);
            this.headerARecordLabel = new CLabel((Composite)this.igcHeaderInfoGroup, 0);
            headerARecordLabelLData = new RowData();
            headerARecordLabelLData.width = 236;
            headerARecordLabelLData.height = 22;
            this.headerARecordLabel.setLayoutData((Object)headerARecordLabelLData);
            this.headerARecordLabel.setText(Messages.getString("GDE_MSGT0616"));
            this.headerARecordLabel.setToolTipText(Messages.getString("GDE_MSGT0617"));
            this.headerARecordLabel.setFont(SWTResourceManager.getFont(GDE.WIDGET_FONT_NAME, GDE.WIDGET_FONT_SIZE, 0));
            this.headerARecordText = new Text((Composite)this.igcHeaderInfoGroup, 2060);
            RowData headerARecordTextLData = new RowData();
            headerARecordTextLData.width = 236;
            headerARecordTextLData.height = GDE.IS_LINUX ? 14 : 16;
            this.headerARecordText.setLayoutData((Object)headerARecordTextLData);
            this.headerARecordText.setText(this.headerARecord);
            this.headerARecordText.setFont(SWTResourceManager.getFont(GDE.WIDGET_FONT_NAME, GDE.WIDGET_FONT_SIZE, 0));
            this.headerARecordText.setBackground(this.application.COLOR_LIGHT_GREY);
            this.headerRecordDateLabel = new CLabel((Composite)this.igcHeaderInfoGroup, 0);
            RowData headerRecordDateLabelLData = new RowData();
            headerRecordDateLabelLData.width = 236;
            headerRecordDateLabelLData.height = 22;
            this.headerRecordDateLabel.setLayoutData((Object)headerRecordDateLabelLData);
            this.headerRecordDateLabel.setText(Messages.getString("GDE_MSGT0618"));
            this.headerRecordDateLabel.setToolTipText(Messages.getString("GDE_MSGT0619"));
            this.headerRecordDateLabel.setFont(SWTResourceManager.getFont(GDE.WIDGET_FONT_NAME, GDE.WIDGET_FONT_SIZE, 0));
            this.headerRecordDateText = new Text((Composite)this.igcHeaderInfoGroup, 2048);
            RowData headerRecordDateTextLData = new RowData();
            headerRecordDateTextLData.width = 236;
            headerRecordDateTextLData.height = GDE.IS_LINUX ? 14 : 16;
            this.headerRecordDateText.setLayoutData((Object)headerRecordDateTextLData);
            this.headerRecordDateText.setText(this.headerRecordDate);
            this.headerRecordDateText.setFont(SWTResourceManager.getFont(GDE.WIDGET_FONT_NAME, GDE.WIDGET_FONT_SIZE, 0));
            this.headerRecordDateText.addVerifyListener(new VerifyListener(){

                public void verifyText(VerifyEvent evt) {
                    log.log(Level.FINEST, "headerRecordDateText.verifyText, event=" + String.valueOf(evt));
                    StringHelper.verifyTypedInput(DataTypes.INTEGER, evt.text);
                }
            });
            this.headerFixAccuracyLabel = new CLabel((Composite)this.igcHeaderInfoGroup, 0);
            RowData headerFixAccuracyLabelLData = new RowData();
            headerFixAccuracyLabelLData.width = 236;
            headerFixAccuracyLabelLData.height = 22;
            this.headerFixAccuracyLabel.setLayoutData((Object)headerFixAccuracyLabelLData);
            this.headerFixAccuracyLabel.setText(Messages.getString("GDE_MSGT0620"));
            this.headerFixAccuracyLabel.setFont(SWTResourceManager.getFont(GDE.WIDGET_FONT_NAME, GDE.WIDGET_FONT_SIZE, 0));
            this.headerFixAccuracyLabel.setToolTipText(Messages.getString("GDE_MSGT0621"));
            this.headerFixAccuracyText = new Text((Composite)this.igcHeaderInfoGroup, 2056);
            RowData headerFixAccuracyTextLData = new RowData();
            headerFixAccuracyTextLData.width = 236;
            headerFixAccuracyTextLData.height = GDE.IS_LINUX ? 14 : 16;
            this.headerFixAccuracyText.setLayoutData((Object)headerFixAccuracyTextLData);
            this.headerFixAccuracyText.setText("035");
            this.headerFixAccuracyText.setFont(SWTResourceManager.getFont(GDE.WIDGET_FONT_NAME, GDE.WIDGET_FONT_SIZE, 0));
            this.headerFixAccuracyText.setBackground(this.application.COLOR_LIGHT_GREY);
            this.headerFixAccuracyText.addVerifyListener(new VerifyListener(){

                public void verifyText(VerifyEvent evt) {
                    log.log(Level.FINEST, "headerFixAccuracyText.verifyText, event=" + String.valueOf(evt));
                    StringHelper.verifyTypedInput(DataTypes.INTEGER, evt.text);
                }
            });
            this.headerPilotLabel = new CLabel((Composite)this.igcHeaderInfoGroup, 0);
            RowData headerPilotLabelLData = new RowData();
            headerPilotLabelLData.width = 236;
            headerPilotLabelLData.height = 22;
            this.headerPilotLabel.setLayoutData((Object)headerPilotLabelLData);
            this.headerPilotLabel.setText(Messages.getString("GDE_MSGT0622"));
            this.headerPilotLabel.setFont(SWTResourceManager.getFont(GDE.WIDGET_FONT_NAME, GDE.WIDGET_FONT_SIZE, 0));
            this.headerPilotLabel.setToolTipText(Messages.getString("GDE_MSGT0623"));
            this.headerPilotText = new Text((Composite)this.igcHeaderInfoGroup, 2048);
            RowData headerPilotTextLData = new RowData();
            headerPilotTextLData.width = 236;
            headerPilotTextLData.height = GDE.IS_LINUX ? 14 : 16;
            this.headerPilotText.setLayoutData((Object)headerPilotTextLData);
            this.headerPilotText.setText(this.headerPilot);
            this.headerPilotText.setFont(SWTResourceManager.getFont(GDE.WIDGET_FONT_NAME, GDE.WIDGET_FONT_SIZE, 0));
            this.headerCoPilotLabel = new CLabel((Composite)this.igcHeaderInfoGroup, 0);
            RowData headerCoPilotLabelLData = new RowData();
            headerCoPilotLabelLData.width = 236;
            headerCoPilotLabelLData.height = 22;
            this.headerCoPilotLabel.setLayoutData((Object)headerCoPilotLabelLData);
            this.headerCoPilotLabel.setText(Messages.getString("GDE_MSGT0624"));
            this.headerCoPilotLabel.setFont(SWTResourceManager.getFont(GDE.WIDGET_FONT_NAME, GDE.WIDGET_FONT_SIZE, 0));
            this.headerCoPilotLabel.setToolTipText(Messages.getString("GDE_MSGT0626"));
            RowData headerCoPilotTextLData = new RowData();
            headerCoPilotTextLData.width = 236;
            headerCoPilotTextLData.height = GDE.IS_LINUX ? 14 : 16;
            this.headerCoPilotText = new Text((Composite)this.igcHeaderInfoGroup, 2048);
            this.headerCoPilotText.setLayoutData((Object)headerCoPilotTextLData);
            this.headerGliderTypeLabel = new CLabel((Composite)this.igcHeaderInfoGroup, 0);
            RowData headerGliderTypeLabelLData = new RowData();
            headerGliderTypeLabelLData.width = 236;
            headerGliderTypeLabelLData.height = 22;
            this.headerGliderTypeLabel.setLayoutData((Object)headerGliderTypeLabelLData);
            this.headerGliderTypeLabel.setText(Messages.getString("GDE_MSGT0627"));
            this.headerGliderTypeLabel.setFont(SWTResourceManager.getFont(GDE.WIDGET_FONT_NAME, GDE.WIDGET_FONT_SIZE, 0));
            this.headerGliderTypeLabel.setToolTipText(Messages.getString("GDE_MSGT0628"));
            this.headerGliderTypeText = new CCombo((Composite)this.igcHeaderInfoGroup, 2048);
            RowData headerGliderTypeTextLData = new RowData();
            headerGliderTypeTextLData.width = 236;
            headerGliderTypeTextLData.height = 17;
            this.headerGliderTypeText.setLayoutData((Object)headerGliderTypeTextLData);
            this.headerGliderTypeText.setItems(this.gliderTypes);
            this.headerGliderTypeText.setFont(SWTResourceManager.getFont(GDE.WIDGET_FONT_NAME, GDE.WIDGET_FONT_SIZE, 0));
            this.headerGliderTypeText.select(this.headerGliderType);
            this.headerGliderIdLabel = new CLabel((Composite)this.igcHeaderInfoGroup, 0);
            RowData headerGliderIdLabelLData = new RowData();
            headerGliderIdLabelLData.width = 236;
            headerGliderIdLabelLData.height = 22;
            this.headerGliderIdLabel.setLayoutData((Object)headerGliderIdLabelLData);
            this.headerGliderIdLabel.setText(Messages.getString("GDE_MSGT0629"));
            this.headerGliderIdLabel.setFont(SWTResourceManager.getFont(GDE.WIDGET_FONT_NAME, GDE.WIDGET_FONT_SIZE, 0));
            this.headerGliderIdLabel.setToolTipText(Messages.getString("GDE_MSGT0630"));
            this.headerGliderIdText = new Text((Composite)this.igcHeaderInfoGroup, 2048);
            RowData headerGliderIdTextLData = new RowData();
            headerGliderIdTextLData.width = 236;
            headerGliderIdTextLData.height = GDE.IS_LINUX ? 14 : 16;
            this.headerGliderIdText.setLayoutData((Object)headerGliderIdTextLData);
            this.headerGliderIdText.setText(this.headerGliderId);
            this.headerGliderIdText.setFont(SWTResourceManager.getFont(GDE.WIDGET_FONT_NAME, GDE.WIDGET_FONT_SIZE, 0));
            this.headerGpsDatumLabel = new CLabel((Composite)this.igcHeaderInfoGroup, 0);
            RowData headerGpsDatumLabelLData = new RowData();
            headerGpsDatumLabelLData.width = 236;
            headerGpsDatumLabelLData.height = 22;
            this.headerGpsDatumLabel.setLayoutData((Object)headerGpsDatumLabelLData);
            this.headerGpsDatumLabel.setText(Messages.getString("GDE_MSGT0631"));
            this.headerGpsDatumLabel.setFont(SWTResourceManager.getFont(GDE.WIDGET_FONT_NAME, GDE.WIDGET_FONT_SIZE, 0));
            this.headerGpsDatumLabel.setToolTipText(Messages.getString("GDE_MSGT0632"));
            this.headerGpsDatumText = new Text((Composite)this.igcHeaderInfoGroup, 2056);
            RowData headerGpsDatumTextLData = new RowData();
            headerGpsDatumTextLData.width = 236;
            headerGpsDatumTextLData.height = GDE.IS_LINUX ? 14 : 16;
            this.headerGpsDatumText.setLayoutData((Object)headerGpsDatumTextLData);
            this.headerGpsDatumText.setText(this.headerGpsDatum);
            this.headerGpsDatumText.setFont(SWTResourceManager.getFont(GDE.WIDGET_FONT_NAME, GDE.WIDGET_FONT_SIZE, 0));
            this.headerGpsDatumText.setBackground(this.application.COLOR_LIGHT_GREY);
            this.headerFirmwareVersionLabel = new CLabel((Composite)this.igcHeaderInfoGroup, 0);
            RowData headerFirmwareVersionLabelLData = new RowData();
            headerFirmwareVersionLabelLData.width = 236;
            headerFirmwareVersionLabelLData.height = 22;
            this.headerFirmwareVersionLabel.setLayoutData((Object)headerFirmwareVersionLabelLData);
            this.headerFirmwareVersionLabel.setText(Messages.getString("GDE_MSGT0633"));
            this.headerFirmwareVersionLabel.setFont(SWTResourceManager.getFont(GDE.WIDGET_FONT_NAME, GDE.WIDGET_FONT_SIZE, 0));
            this.headerFirmwareVersionLabel.setToolTipText(Messages.getString("GDE_MSGT0634"));
            this.headerFirmwareVersionText = new Text((Composite)this.igcHeaderInfoGroup, 2048);
            RowData textheaderFirmwareVersionTextLData = new RowData();
            textheaderFirmwareVersionTextLData.width = 236;
            textheaderFirmwareVersionTextLData.height = GDE.IS_LINUX ? 14 : 16;
            this.headerFirmwareVersionText.setLayoutData((Object)textheaderFirmwareVersionTextLData);
            this.headerFirmwareVersionText.setText(this.headerFirmwareVersion);
            this.headerFirmwareVersionText.setFont(SWTResourceManager.getFont(GDE.WIDGET_FONT_NAME, GDE.WIDGET_FONT_SIZE, 0));
            this.headerHardwareVersionLabel = new CLabel((Composite)this.igcHeaderInfoGroup, 0);
            RowData headerHardwareVersionLabelLData = new RowData();
            headerHardwareVersionLabelLData.width = 236;
            headerHardwareVersionLabelLData.height = 22;
            this.headerHardwareVersionLabel.setLayoutData((Object)headerHardwareVersionLabelLData);
            this.headerHardwareVersionLabel.setText(Messages.getString("GDE_MSGT0635"));
            this.headerHardwareVersionLabel.setFont(SWTResourceManager.getFont(GDE.WIDGET_FONT_NAME, GDE.WIDGET_FONT_SIZE, 0));
            this.headerHardwareVersionLabel.setToolTipText(Messages.getString("GDE_MSGT0636"));
            this.headerHardwareVersionText = new Text((Composite)this.igcHeaderInfoGroup, 2048);
            RowData headerHardwareVersionTextLData = new RowData();
            headerHardwareVersionTextLData.width = 236;
            headerHardwareVersionTextLData.height = GDE.IS_LINUX ? 14 : 16;
            this.headerHardwareVersionText.setLayoutData((Object)headerHardwareVersionTextLData);
            this.headerHardwareVersionText.setText(this.headerHardwareVersion);
            this.headerHardwareVersionText.setFont(SWTResourceManager.getFont(GDE.WIDGET_FONT_NAME, GDE.WIDGET_FONT_SIZE, 0));
            this.headerGpsManufacturerModelLabel = new CLabel((Composite)this.igcHeaderInfoGroup, 0);
            RowData headerGpsManufacturerModelLabelLData = new RowData();
            headerGpsManufacturerModelLabelLData.width = 236;
            headerGpsManufacturerModelLabelLData.height = 22;
            this.headerGpsManufacturerModelLabel.setLayoutData((Object)headerGpsManufacturerModelLabelLData);
            this.headerGpsManufacturerModelLabel.setText(Messages.getString("GDE_MSGT0637"));
            this.headerGpsManufacturerModelLabel.setFont(SWTResourceManager.getFont(GDE.WIDGET_FONT_NAME, GDE.WIDGET_FONT_SIZE, 0));
            this.headerGpsManufacturerModelLabel.setToolTipText(Messages.getString("GDE_MSGT0638"));
            this.headerGpsManufacturerModelText = new Text((Composite)this.igcHeaderInfoGroup, 2048);
            RowData headerGpsManufacturerModelTextLData = new RowData();
            headerGpsManufacturerModelTextLData.width = 236;
            headerGpsManufacturerModelTextLData.height = GDE.IS_LINUX ? 14 : 16;
            this.headerGpsManufacturerModelText.setLayoutData((Object)headerGpsManufacturerModelTextLData);
            this.headerGpsManufacturerModelText.setText(this.headerGpsManufacturerModel);
            this.headerGpsManufacturerModelText.setFont(SWTResourceManager.getFont(GDE.WIDGET_FONT_NAME, GDE.WIDGET_FONT_SIZE, 0));
            this.headerCompetitionIdLabel = new CLabel((Composite)this.igcHeaderInfoGroup, 0);
            RowData headerCompetitionIdLabelLData = new RowData();
            headerCompetitionIdLabelLData.width = 236;
            headerCompetitionIdLabelLData.height = 22;
            this.headerCompetitionIdLabel.setLayoutData((Object)headerCompetitionIdLabelLData);
            this.headerCompetitionIdLabel.setText(Messages.getString("GDE_MSGT0639"));
            this.headerCompetitionIdLabel.setFont(SWTResourceManager.getFont(GDE.WIDGET_FONT_NAME, GDE.WIDGET_FONT_SIZE, 0));
            this.headerCompetitionIdLabel.setToolTipText(Messages.getString("GDE_MSGT0640"));
            this.headerCompetitionIdText = new Text((Composite)this.igcHeaderInfoGroup, 2048);
            RowData headerCompetitionIdTextLData = new RowData();
            headerCompetitionIdTextLData.width = 236;
            headerCompetitionIdTextLData.height = GDE.IS_LINUX ? 14 : 16;
            this.headerCompetitionIdText.setLayoutData((Object)headerCompetitionIdTextLData);
            this.headerCompetitionIdText.setText(this.headerCompetitionId);
            this.headerCompetitionIdText.setFont(SWTResourceManager.getFont(GDE.WIDGET_FONT_NAME, GDE.WIDGET_FONT_SIZE, 0));
            this.headerCompetitionClassLabel = new CLabel((Composite)this.igcHeaderInfoGroup, 0);
            RowData headerCompetitionClassLabelLData = new RowData();
            headerCompetitionClassLabelLData.width = 236;
            headerCompetitionClassLabelLData.height = 22;
            this.headerCompetitionClassLabel.setLayoutData((Object)headerCompetitionClassLabelLData);
            this.headerCompetitionClassLabel.setText(Messages.getString("GDE_MSGT0641"));
            this.headerCompetitionClassLabel.setFont(SWTResourceManager.getFont(GDE.WIDGET_FONT_NAME, GDE.WIDGET_FONT_SIZE, 0));
            this.headerCompetitionClassLabel.setToolTipText(Messages.getString("GDE_MSGT0642"));
            this.headerCompetitionClassText = new Text((Composite)this.igcHeaderInfoGroup, 2048);
            RowData headerCompetitionClassTextLData = new RowData();
            headerCompetitionClassTextLData.width = 236;
            headerCompetitionClassTextLData.height = GDE.IS_LINUX ? 14 : 16;
            this.headerCompetitionClassText.setLayoutData((Object)headerCompetitionClassTextLData);
            this.headerCompetitionClassText.setText(this.headerCompetitionClass);
            this.headerCompetitionClassText.setFont(SWTResourceManager.getFont(GDE.WIDGET_FONT_NAME, GDE.WIDGET_FONT_SIZE, 0));
            this.headerUtcOffsetLabel = new CLabel((Composite)this.igcHeaderInfoGroup, 0);
            RowData headerUtcOffsetLabelLData = new RowData();
            headerUtcOffsetLabelLData.width = 236;
            headerUtcOffsetLabelLData.height = 22;
            this.headerUtcOffsetLabel.setLayoutData((Object)headerUtcOffsetLabelLData);
            this.headerUtcOffsetLabel.setText(Messages.getString("GDE_MSGT0643"));
            this.headerUtcOffsetLabel.setFont(SWTResourceManager.getFont(GDE.WIDGET_FONT_NAME, GDE.WIDGET_FONT_SIZE, 0));
            this.headerUtcOffsetLabel.setToolTipText(Messages.getString("GDE_MSGT0644"));
            RowData headerUtcOffsetComboLData = new RowData();
            headerUtcOffsetComboLData.width = 61;
            headerUtcOffsetComboLData.height = 17;
            this.headerUtcOffsetCombo = new CCombo((Composite)this.igcHeaderInfoGroup, 2048);
            this.headerUtcOffsetCombo.setLayoutData((Object)headerUtcOffsetComboLData);
            this.headerUtcOffsetCombo.setItems(this.deltaUTC);
            this.headerUtcOffsetCombo.setFont(SWTResourceManager.getFont(GDE.WIDGET_FONT_NAME, GDE.WIDGET_FONT_SIZE, 0));
            this.headerUtcOffsetCombo.select(this.headerUtcOffset);
            this.extraEntriesGroup = new Group((Composite)this.dialogShell, 0);
            RowLayout extraEntriesGroupLayout = new RowLayout(256);
            this.extraEntriesGroup.setLayout((Layout)extraEntriesGroupLayout);
            FormData extraEntriesGroupLData = new FormData();
            extraEntriesGroupLData.width = 261;
            extraEntriesGroupLData.height = 364;
            extraEntriesGroupLData.top = new FormAttachment(0, 1000, 7);
            extraEntriesGroupLData.right = new FormAttachment(1000, 1000, -7);
            this.extraEntriesGroup.setLayoutData((Object)extraEntriesGroupLData);
            this.extraEntriesGroup.setText(Messages.getString("GDE_MSGT0645"));
            this.extraEntriesGroup.setFont(SWTResourceManager.getFont(GDE.WIDGET_FONT_NAME, GDE.WIDGET_FONT_SIZE + 2, 0));
            this.separatorLabel = new CLabel((Composite)this.extraEntriesGroup, 0);
            headerARecordLabelLData = new RowData();
            headerARecordLabelLData.width = 250;
            headerARecordLabelLData.height = 5;
            this.separatorLabel.setLayoutData((Object)headerARecordLabelLData);
            this.startAltitudeGroup = new Group((Composite)this.extraEntriesGroup, 0);
            RowLayout startAltitudeGroupLayout = new RowLayout(256);
            this.startAltitudeGroup.setLayout((Layout)startAltitudeGroupLayout);
            RowData startAltitudeGroupLData = new RowData();
            startAltitudeGroupLData.width = 247;
            startAltitudeGroupLData.height = 166;
            this.startAltitudeGroup.setLayoutData((Object)startAltitudeGroupLData);
            this.startAltitudeGroup.setText(Messages.getString("GDE_MSGT0646"));
            this.startAltitudeGroup.setFont(SWTResourceManager.getFont(GDE.WIDGET_FONT_NAME, GDE.WIDGET_FONT_SIZE + 2, 0));
            this.separatorLabel = new CLabel((Composite)this.startAltitudeGroup, 0);
            RowData headerARecordLabelLData2 = new RowData();
            headerARecordLabelLData2.width = 240;
            headerARecordLabelLData2.height = 5;
            this.separatorLabel.setLayoutData((Object)headerARecordLabelLData2);
            this.startAltitudeDescrptionText = new Text((Composite)this.startAltitudeGroup, 72);
            RowData startAltitudeLabelLData = new RowData();
            startAltitudeLabelLData.width = 241;
            startAltitudeLabelLData.height = 104;
            this.startAltitudeDescrptionText.setLayoutData((Object)startAltitudeLabelLData);
            this.startAltitudeDescrptionText.setText(Messages.getString("GDE_MSGT0647"));
            this.startAltitudeDescrptionText.setFont(SWTResourceManager.getFont(GDE.WIDGET_FONT_NAME, GDE.WIDGET_FONT_SIZE, 0));
            this.startAltitudeDescrptionText.setBackground(this.application.COLOR_LIGHT_GREY);
            this.latitudeLabel = new CLabel((Composite)this.startAltitudeGroup, 0);
            this.latitudeLabel.setText("lat :");
            this.latitudeLabel.setFont(SWTResourceManager.getFont(GDE.WIDGET_FONT_NAME, GDE.WIDGET_FONT_SIZE, 0));
            this.latitudeText = new Text((Composite)this.startAltitudeGroup, 2056);
            this.latitudeText.setText(this.latitude);
            this.latitudeText.setFont(SWTResourceManager.getFont(GDE.WIDGET_FONT_NAME, GDE.WIDGET_FONT_SIZE, 0));
            this.latitudeText.setBackground(this.application.COLOR_LIGHT_GREY);
            this.longitudeLabel = new CLabel((Composite)this.startAltitudeGroup, 0);
            this.longitudeLabel.setText("long :");
            this.longitudeLabel.setFont(SWTResourceManager.getFont(GDE.WIDGET_FONT_NAME, GDE.WIDGET_FONT_SIZE, 0));
            this.longitudeText = new Text((Composite)this.startAltitudeGroup, 2056);
            this.longitudeText.setText(this.longitude);
            this.longitudeText.setFont(SWTResourceManager.getFont(GDE.WIDGET_FONT_NAME, GDE.WIDGET_FONT_SIZE, 0));
            this.longitudeText.setBackground(this.application.COLOR_LIGHT_GREY);
            this.startAltitudeLabel = new CLabel((Composite)this.startAltitudeGroup, 0);
            startAltitudeLabelLData = new RowData();
            startAltitudeLabelLData.width = 95;
            startAltitudeLabelLData.height = 22;
            this.startAltitudeLabel.setLayoutData((Object)startAltitudeLabelLData);
            this.startAltitudeLabel.setText(Messages.getString("GDE_MSGT0648"));
            this.startAltitudeLabel.setFont(SWTResourceManager.getFont(GDE.WIDGET_FONT_NAME, GDE.WIDGET_FONT_SIZE, 0));
            this.startAltitudeLabel.setToolTipText(Messages.getString("GDE_MSGT0649"));
            this.startAltitudeText = new Text((Composite)this.startAltitudeGroup, 2048);
            RowData startAltitudeTextLData = new RowData();
            startAltitudeTextLData.width = 48;
            startAltitudeTextLData.height = GDE.IS_LINUX ? 14 : 16;
            this.startAltitudeText.setLayoutData((Object)startAltitudeTextLData);
            this.startAltitudeText.setText(this.startAltitude);
            this.startAltitudeText.setFont(SWTResourceManager.getFont(GDE.WIDGET_FONT_NAME, GDE.WIDGET_FONT_SIZE, 0));
            this.startAltitudeText.addVerifyListener(new VerifyListener(){

                public void verifyText(VerifyEvent evt) {
                    log.log(Level.FINEST, "startAltitudeText.verifyText, event=" + String.valueOf(evt));
                    StringHelper.verifyTypedInput(DataTypes.INTEGER, evt.text);
                }
            });
            this.startAltitudeUnitLabel = new CLabel((Composite)this.startAltitudeGroup, 0);
            this.startAltitudeUnitLabel.setText(Messages.getString("GDE_MSGT0613"));
            this.startAltitudeUnitLabel.setFont(SWTResourceManager.getFont(GDE.WIDGET_FONT_NAME, GDE.WIDGET_FONT_SIZE, 0));
            this.startTimeGroup = new Group((Composite)this.extraEntriesGroup, 0);
            RowLayout startTimeGroupLayout = new RowLayout(256);
            this.startTimeGroup.setLayout((Layout)startTimeGroupLayout);
            RowData startTimeGroupLData = new RowData();
            startTimeGroupLData.width = 250;
            startTimeGroupLData.height = 140;
            this.startTimeGroup.setLayoutData((Object)startTimeGroupLData);
            this.startTimeGroup.setText(Messages.getString("GDE_MSGT0650"));
            this.startTimeGroup.setFont(SWTResourceManager.getFont(GDE.WIDGET_FONT_NAME, GDE.WIDGET_FONT_SIZE + 2, 0));
            this.separatorLabel = new CLabel((Composite)this.startTimeGroup, 0);
            headerARecordLabelLData2 = new RowData();
            headerARecordLabelLData2.width = 240;
            headerARecordLabelLData2.height = 5;
            this.separatorLabel.setLayoutData((Object)headerARecordLabelLData2);
            this.startTimeDescriptionText = new Text((Composite)this.startTimeGroup, 72);
            RowData startTimeDescriptionTextLData = new RowData();
            startTimeDescriptionTextLData.width = 227;
            startTimeDescriptionTextLData.height = 105;
            this.startTimeDescriptionText.setLayoutData((Object)startTimeDescriptionTextLData);
            this.startTimeDescriptionText.setText(Messages.getString("GDE_MSGT0651"));
            this.startTimeDescriptionText.setFont(SWTResourceManager.getFont(GDE.WIDGET_FONT_NAME, GDE.WIDGET_FONT_SIZE, 0));
            this.startTimeDescriptionText.setBackground(this.application.COLOR_LIGHT_GREY);
            this.startTimeLabel = new CLabel((Composite)this.startTimeGroup, 0);
            RowData startTimeLabelLData = new RowData();
            startTimeLabelLData.width = 95;
            startTimeLabelLData.height = 22;
            this.startTimeLabel.setLayoutData((Object)startTimeLabelLData);
            this.startTimeLabel.setText(Messages.getString("GDE_MSGT0652"));
            this.startTimeLabel.setFont(SWTResourceManager.getFont(GDE.WIDGET_FONT_NAME, GDE.WIDGET_FONT_SIZE, 0));
            this.startTimeLabel.setToolTipText(Messages.getString("GDE_MSGT0653"));
            this.startTimeText = new Text((Composite)this.startTimeGroup, 2048);
            this.startTimeText.setText(this.startTime);
            this.startTimeText.setFont(SWTResourceManager.getFont(GDE.WIDGET_FONT_NAME, GDE.WIDGET_FONT_SIZE, 0));
            this.startTimeUnitLabel = new CLabel((Composite)this.startTimeGroup, 0);
            this.startTimeUnitLabel.setText(Messages.getString("GDE_MSGT0612"));
            this.startTimeUnitLabel.setFont(SWTResourceManager.getFont(GDE.WIDGET_FONT_NAME, GDE.WIDGET_FONT_SIZE, 0));
            this.cancelButton = new Button((Composite)this.dialogShell, 0x1000008);
            this.cancelButton.setText(Messages.getString("GDE_MSGT0452"));
            this.cancelButton.setFont(SWTResourceManager.getFont(GDE.WIDGET_FONT_NAME, GDE.WIDGET_FONT_SIZE, 0));
            FormData cancelButtonLData = new FormData();
            cancelButtonLData.width = 172;
            cancelButtonLData.height = 34;
            cancelButtonLData.left = new FormAttachment(0, 1000, 173);
            cancelButtonLData.top = new FormAttachment(0, 1000, 407);
            this.cancelButton.setLayoutData((Object)cancelButtonLData);
            this.cancelButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent evt) {
                    log.log(Level.FINEST, "cancelButton.widgetSelected, event=" + String.valueOf(evt));
                    IgcExportDialog.this.dialogShell.close();
                }
            });
            this.helpButton = new Button((Composite)this.dialogShell, 0x1000008);
            this.helpButton.setImage(SWTResourceManager.getImage("gde/resource/QuestionHot.gif"));
            FormData helpButtonLData = new FormData();
            helpButtonLData.width = 60;
            helpButtonLData.height = 34;
            helpButtonLData.left = new FormAttachment(0, 1000, 370);
            helpButtonLData.top = new FormAttachment(0, 1000, 407);
            this.helpButton.setLayoutData((Object)helpButtonLData);
            this.helpButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent evt) {
                    log.log(Level.FINEST, "helpButton.widgetSelected, event=" + String.valueOf(evt));
                    IgcExportDialog.this.application.openHelpDialog("", "HelpInfo_37.html");
                }
            });
            this.saveButton = new Button((Composite)this.dialogShell, 0x1000008);
            FormData saveButtonLData = new FormData();
            saveButtonLData.width = 172;
            saveButtonLData.height = 34;
            saveButtonLData.left = new FormAttachment(0, 1000, 449);
            saveButtonLData.top = new FormAttachment(0, 1000, 407);
            this.saveButton.setLayoutData((Object)saveButtonLData);
            this.saveButton.setText(Messages.getString("GDE_MSGT0486"));
            this.saveButton.setFont(SWTResourceManager.getFont(GDE.WIDGET_FONT_NAME, GDE.WIDGET_FONT_SIZE, 0));
            this.saveButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent evt) {
                    log.log(Level.FINEST, "saveButton.widgetSelected, event=" + String.valueOf(evt));
                    RecordSet recordSet = IgcExportDialog.this.application.getActiveRecordSet();
                    IDevice device = IgcExportDialog.this.application.getActiveDevice();
                    if (recordSet == null || device != null) {
                        // empty if block
                    }
                    IgcExportDialog.this.dialogShell.close();
                }
            });
            this.dialogShell.setLocation(this.getParent().toDisplay(100, 100));
            this.dialogShell.open();
            Display display = this.dialogShell.getDisplay();
            while (!this.dialogShell.isDisposed()) {
                if (display.readAndDispatch()) continue;
                display.sleep();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void initializeValues(int ordinalLongitude, int ordinalLatitude, int ordinalHeight) {
        IDevice device = this.application.getActiveDevice();
        RecordSet recordSet = this.application.getActiveRecordSet();
        this.headerARecord = String.format("%s %s", "DataExplorer", "Version 3.9.3");
        if (recordSet != null) {
            this.headerRecordDate = String.format("%s", new SimpleDateFormat("ddMMyy").format(recordSet.getStartTimeStamp()));
            Record recordLatitude = recordSet.get(ordinalLatitude);
            Record recordLongitude = recordSet.get(ordinalLongitude);
            int startIndex = GPSHelper.getStartIndexGPS(recordSet, ordinalLatitude, ordinalLongitude);
            String latitudeNS = recordLatitude.get(startIndex) > 0 ? "N" : "S";
            String longitudeEW = recordLongitude.get(startIndex) > 0 ? "E" : "W";
            this.latitude = String.format("%08.6f %s", device.translateValue(recordLatitude, (double)recordLatitude.get(startIndex).intValue() / 1000.0), latitudeNS);
            this.longitude = String.format("%09.6f %s", device.translateValue(recordLongitude, (double)recordLongitude.get(startIndex).intValue() / 1000.0), longitudeEW);
            this.startAltitude = String.format("%.0f", device.translateValue(recordSet.get(ordinalHeight), (double)recordSet.get(ordinalHeight).get(startIndex).intValue() / 1000.0));
            this.startTime = new SimpleDateFormat("HH:mm:ss").format(recordSet.getStartTimeStamp());
        } else {
            this.headerRecordDate = String.format("%s", new SimpleDateFormat("ddMMyy").format(new Date().getTime()));
            this.latitude = "53.147619 N";
            this.longitude = "008.443705 E";
            this.startAltitude = "0";
            this.startTime = new SimpleDateFormat("HH:mm:ss").format(new Date().getTime());
        }
        this.headerFixAccuracy = "035";
        this.headerGpsDatum = "WGS-1984";
        if (this.application.isObjectoriented()) {
            String objectText = this.application.getObject().getStyledText();
            this.headerPilot = Messages.getString("GDE_MSGT0655");
            if (objectText.split(IGC_PILOT_NAME).length >= 2) {
                this.headerPilot = objectText.split(IGC_PILOT_NAME)[1].split(":|\\r|\\n")[1].trim();
            }
            this.headerCoPilot = "";
            if (objectText.split(IGC_CO_PILOT_NAME).length >= 2) {
                this.headerCoPilot = objectText.split(IGC_CO_PILOT_NAME)[1].split(":|\\r|\\n")[1].trim();
            }
            this.headerGliderType = 4;
            if (objectText.split(IGC_GLIDER_CLASS).length >= 2) {
                String tmpGliderType = objectText.split(IGC_GLIDER_CLASS)[1].split(":|\\r|\\n")[1].trim().split("-")[0].trim();
                if (tmpGliderType.startsWith("0")) {
                    this.headerGliderType = 0;
                } else if (tmpGliderType.startsWith("15")) {
                    this.headerGliderType = 1;
                } else if (tmpGliderType.startsWith("20")) {
                    this.headerGliderType = 2;
                } else if (tmpGliderType.startsWith("25")) {
                    this.headerGliderType = 3;
                } else if (tmpGliderType.startsWith("30")) {
                    this.headerGliderType = 4;
                } else if (tmpGliderType.startsWith("35")) {
                    this.headerGliderType = 5;
                } else if (tmpGliderType.startsWith("40")) {
                    this.headerGliderType = 6;
                } else if (tmpGliderType.startsWith("45")) {
                    this.headerGliderType = 7;
                } else if (tmpGliderType.startsWith("50")) {
                    this.headerGliderType = 8;
                } else if (tmpGliderType.startsWith("55")) {
                    this.headerGliderType = 9;
                } else if (tmpGliderType.startsWith("60")) {
                    this.headerGliderType = 10;
                } else if (tmpGliderType.startsWith("65")) {
                    this.headerGliderType = 11;
                } else if (tmpGliderType.startsWith("70")) {
                    this.headerGliderType = 12;
                } else if (tmpGliderType.startsWith("75")) {
                    this.headerGliderType = 13;
                } else if (tmpGliderType.startsWith("80")) {
                    this.headerGliderType = 14;
                } else if (tmpGliderType.startsWith("85")) {
                    this.headerGliderType = 15;
                } else if (tmpGliderType.startsWith("90")) {
                    this.headerGliderType = 16;
                } else if (tmpGliderType.startsWith("95")) {
                    this.headerGliderType = 17;
                } else if (tmpGliderType.startsWith("100")) {
                    this.headerGliderType = 18;
                } else if (tmpGliderType.startsWith("105")) {
                    this.headerGliderType = 19;
                }
            }
            this.headerGliderId = this.application.getObjectKey();
            if (objectText.split(IGC_GLIDER_ID).length >= 2) {
                this.headerGliderId = objectText.split(IGC_GLIDER_ID)[1].split(":|\\r|\\n")[1].trim();
            }
            this.headerFirmwareVersion = Messages.getString("GDE_MSGT0658");
            if (objectText.split(IGC_GPS_FIRMWARE_VERSION).length >= 2) {
                this.headerFirmwareVersion = objectText.split(IGC_GPS_FIRMWARE_VERSION)[1].split(":|\\r|\\n")[1].trim();
            }
            this.headerHardwareVersion = Messages.getString("GDE_MSGT0659");
            if (objectText.split(IGC_GPS_HARDWARE_VERSION).length >= 2) {
                this.headerHardwareVersion = objectText.split(IGC_GPS_HARDWARE_VERSION)[1].split(":|\\r|\\n")[1].trim();
            }
            this.headerGpsManufacturerModel = Messages.getString("GDE_MSGT0660");
            if (objectText.split(IGC_GPS_TYPE_IDENTIFIER).length >= 2) {
                this.headerGpsManufacturerModel = objectText.split(IGC_GPS_TYPE_IDENTIFIER)[1].split(":|\\r|\\n")[1].trim();
            }
            this.headerCompetitionId = Messages.getString("GDE_MSGT0661");
            if (objectText.split(IGC_COMPETITION_IDENTIFIER).length >= 2) {
                this.headerCompetitionId = objectText.split(IGC_COMPETITION_IDENTIFIER)[1].split(":|\\r|\\n")[1].trim();
            }
            this.headerCompetitionClass = Messages.getString("GDE_MSGT0662");
            if (objectText.split(IGC_COMPETITION_CLASS).length >= 2) {
                this.headerCompetitionClass = objectText.split(IGC_COMPETITION_CLASS)[1].split(":|\\r|\\n")[1].trim();
            }
            this.headerUtcOffset = 12;
            if (objectText.split(IGC_UTC_OFFSET).length >= 2) {
                String tmpUtcOffset = objectText.split(IGC_UTC_OFFSET)[1].split(":|\\r|\\n")[1].trim();
                this.headerUtcOffset = tmpUtcOffset.startsWith("+") ? 12 + Integer.parseInt(tmpUtcOffset.substring(1)) : (tmpUtcOffset.startsWith("-") ? 12 - Integer.parseInt(tmpUtcOffset.substring(1)) : 12 + Integer.parseInt(tmpUtcOffset));
            }
        } else {
            this.headerPilot = Messages.getString("GDE_MSGT0655");
            this.headerCoPilot = Messages.getString("GDE_MSGT0656");
            this.headerGliderType = 4;
            this.headerGliderId = Messages.getString("GDE_MSGT0657");
            this.headerFirmwareVersion = Messages.getString("GDE_MSGT0658");
            this.headerHardwareVersion = Messages.getString("GDE_MSGT0659");
            this.headerGpsManufacturerModel = Messages.getString("GDE_MSGT0660");
            this.headerCompetitionId = Messages.getString("GDE_MSGT0661");
            this.headerCompetitionClass = Messages.getString("GDE_MSGT0662");
            this.headerUtcOffset = 12;
        }
    }

    public StringBuilder getHeader() {
        StringBuilder header = new StringBuilder();
        if (this.headerRecordDateText != null) {
            header.append(String.format("AXDE %s\r\n", "DataExplorer", "Version 3.9.3".replace(".", "")));
            header.append(String.format("HFDTE%s\r\n", this.headerRecordDateText.getText()));
            header.append(String.format("HFFXA%s\r\n", this.headerFixAccuracyText.getText()));
            header.append(String.format("HFPLTPILOT:%s\r\n", this.headerPilotText.getText()));
            header.append(String.format("HFCM2CREW2:%s\r\n", this.headerCoPilotText.getText()));
            header.append(String.format("HFGTYGLIDERTYPE:%s\r\n", this.headerGliderTypeText.getText().trim()));
            header.append(String.format("HFGIDGLIDERID:%s\r\n", this.headerGliderIdText.getText()));
            header.append(String.format("HFDTM100GPSDATUM:%s\r\n", this.headerGpsDatumText.getText()));
            header.append(String.format("HFRFWFIRMWAREVERSION:%s\r\n", "Version 3.9.3"));
            header.append(String.format("HFRHWHARDWAREVERSION:%s\r\n", this.headerHardwareVersionText.getText()));
            header.append(String.format("HFFTYFRTYPE:%s\r\n", this.headerGpsManufacturerModelText.getText()));
            header.append(String.format("HFCIDCOMPETITIONID:%s\r\n", this.headerCompetitionIdText.getText()));
            header.append(String.format("HFCCLCOMPETITIONCLASS:%s\r\n", this.headerCompetitionClassText.getText()));
            String tmpUtfOffset = this.headerUtcOffsetCombo.getText().trim();
            header.append(String.format("HFTZNTIMEZONE:%s\r\n", tmpUtfOffset.startsWith("+") ? tmpUtfOffset.substring(1) : tmpUtfOffset));
        } else {
            header.append(String.format("AXDE %s %s\r\n", "DataExplorer", "Version 3.9.3".replace(".", "")));
            header.append(String.format("HFDTE%s\r\n", this.headerRecordDate));
            header.append(String.format("HFFXA%s\r\n", this.headerFixAccuracy));
            header.append(String.format("HFPLTPILOT:%s\r\n", this.headerPilot));
            header.append(String.format("HFCM2CREW2:%s\r\n", this.headerCoPilot));
            header.append(String.format("HFGTYGLIDERTYPE:%s\r\n", this.gliderTypes[this.headerGliderType]));
            header.append(String.format("HFGIDGLIDERID:%s\r\n", this.headerGliderId));
            header.append(String.format("HFDTM100GPSDATUM:%s\r\n", this.headerGpsDatum));
            header.append(String.format("HFRFWFIRMWAREVERSION:%s\r\n", "Version 3.9.3"));
            header.append(String.format("HFRHWHARDWAREVERSION:%s\r\n", this.headerHardwareVersion));
            header.append(String.format("HFFTYFRTYPE:%s\r\n", this.headerGpsManufacturerModel));
            header.append(String.format("HFCIDCOMPETITIONID:%s\r\n", this.headerCompetitionId));
            header.append(String.format("HFCCLCOMPETITIONCLASS:%s\r\n", this.headerCompetitionClass));
            String tmpUtfOffset = this.deltaUTC[this.headerUtcOffset];
            header.append(String.format("HFTZNTIMEZONE:%s\r\n", tmpUtfOffset.startsWith("+") ? tmpUtfOffset.substring(1) : tmpUtfOffset));
        }
        return header;
    }
}

