/*
 * Decompiled with CFR 0.152.
 */
package gde.data;

import gde.Analyzer;
import gde.GDE;
import gde.config.GraphicsTemplate;
import gde.config.Settings;
import gde.data.Channels;
import gde.data.Record;
import gde.data.RecordSet;
import gde.device.ChannelTypes;
import gde.log.Level;
import gde.messages.Messages;
import gde.ui.DataExplorer;
import gde.ui.SWTResourceManager;
import gde.utils.RecordSetNameComparator;
import gde.utils.StringHelper;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Vector;
import java.util.logging.Logger;
import org.eclipse.swt.graphics.Color;

public class Channel
extends HashMap<String, RecordSet> {
    static final long serialVersionUID = 26031957L;
    static final Logger log = Logger.getLogger(Channel.class.getName());
    private final Analyzer analyzer;
    final int number;
    final String channelConfigName;
    String name;
    final ChannelTypes type;
    private GraphicsTemplate template;
    private RecordSet activeRecordSet;
    private RecordSet lastActiveRecordSet;
    String objectKey = "";
    private String fileName;
    private String fileDescription;
    private boolean isSaved = false;
    private final Channels parent;
    Comparator<String> comparator = new RecordSetNameComparator();
    public static final String UNSAVED_REASON_ADD_OBJECT_KEY = Messages.getString("GDE_MSGT0400");
    public static final String UNSAVED_REASON_REMOVE_OBJECT_KEY = Messages.getString("GDE_MSGT0401");
    public static final String UNSAVED_REASON_CHANGED_OBJECT_DATA = Messages.getString("GDE_MSGT0402");

    public Channel(Analyzer analyzer, String useChannelConfigName, ChannelTypes channelType) {
        super(4);
        this.analyzer = analyzer;
        this.parent = analyzer.getChannels();
        this.number = this.parent.size() + 1;
        this.channelConfigName = useChannelConfigName;
        this.name = " " + this.number + " : " + this.channelConfigName;
        this.type = channelType;
        String templateFileName = this.analyzer.getActiveDevice().getName() + "_" + this.name.split(":")[0].trim();
        this.template = new GraphicsTemplate(templateFileName);
        this.fileDescription = !this.analyzer.getSettings().getActiveObjectKey().isEmpty() ? StringHelper.getDate() + " " + this.analyzer.getSettings().getActiveObjectKey() : StringHelper.getDate();
    }

    @Override
    public int size() {
        int size;
        if (this.type == ChannelTypes.TYPE_OUTLET) {
            size = super.size();
        } else {
            size = 0;
            Channels channels = this.analyzer.getChannels();
            for (Integer channelNumber : this.parent.keySet()) {
                size += ((Channel)channels.get(channelNumber))._size();
            }
        }
        return size;
    }

    public int maxSize() {
        int size;
        if (this.type == ChannelTypes.TYPE_OUTLET) {
            size = super.size();
        } else {
            size = 0;
            Channels channels = this.analyzer.getChannels();
            for (Integer channelNumber : this.parent.keySet()) {
                size = ((Channel)channels.get(channelNumber))._size() > size ? ((Channel)channels.get(channelNumber))._size() : size;
            }
        }
        return size;
    }

    private int _size() {
        return super.size();
    }

    public int getNextRecordSetNumber() {
        int recordNumber = 1;
        if (this.size() != 0) {
            String[] sortedRecordSetNames = this.getRecordSetNames();
            for (int i = sortedRecordSetNames.length - 1; i >= 0; --i) {
                try {
                    recordNumber = Integer.parseInt(sortedRecordSetNames[i].split("[)]")[0]) + 1;
                    break;
                }
                catch (NumberFormatException numberFormatException) {
                    continue;
                }
            }
        } else {
            recordNumber = 1;
        }
        return recordNumber;
    }

    public int getNextRecordSetNumber(int availableNum) {
        Vector<Integer> sortedNumbers = new Vector<Integer>(this.size());
        if (this.size() != 0) {
            String[] sortedRecordSetNames;
            for (String sortedRecordSetName : sortedRecordSetNames = this.getRecordSetNames()) {
                try {
                    sortedNumbers.add(Integer.parseInt(sortedRecordSetName.split("[)]")[0]));
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
        }
        return !sortedNumbers.contains(availableNum) ? availableNum : this.getNextRecordSetNumber();
    }

    public GraphicsTemplate getTemplate() {
        return this.template;
    }

    public void setTemplate(String templateFileName) {
        this.template = new GraphicsTemplate(templateFileName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized String[] getRecordSetNames() {
        String[] keys;
        if (this.type == ChannelTypes.TYPE_OUTLET) {
            keys = this.keySet().toArray(new String[1]);
        } else {
            Channels channels = this.analyzer.getChannels();
            Vector<String> namesVector = new Vector<String>();
            Channels channels2 = channels;
            synchronized (channels2) {
                for (int i = 1; i <= channels.size(); ++i) {
                    String[] recordSetNames;
                    for (String recordSetName : recordSetNames = ((Channel)channels.get(i)).getUnsortedRecordSetNames()) {
                        if (recordSetName == null) continue;
                        namesVector.add(recordSetName);
                    }
                }
            }
            keys = namesVector.toArray(new String[1]);
        }
        Arrays.sort(keys, this.comparator);
        return keys;
    }

    public String[] getUnsortedRecordSetNames() {
        return this.keySet().toArray(new String[1]);
    }

    public String getLastActiveRecordSetName() {
        return this.lastActiveRecordSet == null ? this.getFirstRecordSetName() : this.lastActiveRecordSet.name;
    }

    public void setLastActiveRecordSet(RecordSet lastRecordSet) {
        this.lastActiveRecordSet = lastRecordSet;
    }

    public String getFirstRecordSetName() {
        if (this.type == ChannelTypes.TYPE_CONFIG && this.keySet() != null) {
            return this.keySet().toArray(new String[1])[0];
        }
        return this.getRecordSetNames()[0];
    }

    public String getName() {
        return this.name;
    }

    public String getChannelConfigKey() {
        return this.channelConfigName;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized HashMap<String, RecordSet> getRecordSets() {
        HashMap<String, RecordSet> content = new HashMap<String, RecordSet>(this.size());
        if (this.type == ChannelTypes.TYPE_OUTLET) {
            for (String key : this.getRecordSetNames()) {
                content.put(key, (RecordSet)this.get(key));
            }
        } else {
            Channels channels;
            Channels channels2 = channels = this.analyzer.getChannels();
            synchronized (channels2) {
                for (int i = 1; i <= channels.size(); ++i) {
                    for (String key : ((Channel)channels.get(i)).getUnsortedRecordSetNames()) {
                        if (key == null || key.length() <= 1) continue;
                        content.put(key, (RecordSet)((Channel)channels.get(i)).get(key));
                    }
                }
            }
        }
        return content;
    }

    public void saveTemplate() {
        RecordSet recordSet = this.getActiveRecordSet();
        if (recordSet != null) {
            for (int i = 0; i < recordSet.size(); ++i) {
                Record record = recordSet.get(i);
                this.template.setProperty(i + "_isVisible", Boolean.valueOf(record.isVisible()).toString());
                this.template.setProperty(i + "_isPositionLeft", Boolean.valueOf(record.isPositionLeft()).toString());
                this.template.setProperty(i + "_color", record.getRGB());
                this.template.setProperty(i + "_lineWidth", Integer.valueOf(record.getLineWidth()).toString());
                this.template.setProperty(i + "_lineStyle", Integer.valueOf(record.getLineStyle()).toString());
                this.template.setProperty(i + "_isRoundOut", Boolean.valueOf(record.isRoundOut()).toString());
                this.template.setProperty(i + "_isStartpointZero", Boolean.valueOf(record.isStartpointZero()).toString());
                this.template.setProperty(i + "_numberFormat", Integer.valueOf(record.getNumberFormat()).toString());
                this.template.setProperty(i + "_isStartEndDefined", Boolean.valueOf(record.isStartEndDefined()).toString());
                this.template.setProperty(i + "_defMaxValue", Double.valueOf(record.getMaxScaleValue()).toString());
                this.template.setProperty(i + "_defMinValue", Double.valueOf(record.getMinScaleValue()).toString());
            }
            this.template.setProperty("RecordSet_smoothAtCurrentDrop", Boolean.toString(recordSet.isSmoothAtCurrentDrop()));
            recordSet.setSmoothAtCurrentDrop(Boolean.valueOf(this.template.getProperty("RecordSet_smoothAtCurrentDrop", "false")));
            this.template.setProperty("RecordSet_smoothVoltageCurve", Boolean.toString(recordSet.isSmoothVoltageCurve()));
            recordSet.setSmoothVoltageCurve(Boolean.valueOf(this.template.getProperty("RecordSet_smoothVoltageCurve", "false")));
            Color color = recordSet.getColorTimeGrid();
            String rgb = color.getRGB().red + "," + color.getRGB().green + "," + color.getRGB().blue;
            this.template.setProperty("RecordSet_timeGridColor", rgb);
            this.template.setProperty("RecordSet_timeGridLineStyle", Integer.valueOf(recordSet.getLineStyleTimeGrid()).toString());
            this.template.setProperty("RecordSet_timeGridType", Integer.valueOf(recordSet.getTimeGridType()).toString());
            color = recordSet.getValueGridColor();
            rgb = color.getRGB().red + "," + color.getRGB().green + "," + color.getRGB().blue;
            this.template.setProperty("RecordSet_horizontalGridColor", rgb);
            this.template.setProperty("RecordSet_horizontalGridLineStyle", Integer.valueOf(recordSet.getValueGridLineStyle()).toString());
            this.template.setProperty("RecordSet_horizontalGridType", Integer.valueOf(recordSet.getValueGridType()).toString());
            if (recordSet.get(recordSet.getValueGridRecordOrdinal()) != null) {
                this.template.setProperty("RecordSet_horizontalGridRecordOrdinal", "" + recordSet.getValueGridRecordOrdinal());
            }
            this.template.store();
            if (log.isLoggable(Level.FINE)) {
                log.log(Level.FINE, "creating graphics template file " + Settings.getApplHomePath() + "/" + this.getActiveRecordSet().getName() + this.name);
            }
        }
    }

    public void applyTemplateBasics(String recordSetKey) {
        RecordSet recordSet = (RecordSet)this.get(recordSetKey);
        RecordSet recordSet2 = this.activeRecordSet = this.analyzer.getActiveChannel() != null ? this.analyzer.getActiveChannel().getActiveRecordSet() : null;
        if (recordSet != null) {
            if (log.isLoggable(Level.FINE) && this.get(this.getLastActiveRecordSetName()) != null && this.get(recordSetKey) != null) {
                log.log(Level.FINE, "this.size() > 1 " + (this.size() > 1) + "; this.lastActiveRecordSet = " + this.getLastActiveRecordSetName() + " - " + ((RecordSet)this.get(this.getLastActiveRecordSetName())).getChannelConfigNumber() + "!=" + ((RecordSet)this.get(recordSetKey)).getChannelConfigNumber());
            }
            if (this.size() <= 1 || this.get(this.getLastActiveRecordSetName()) != null && this.get(recordSetKey) != null && this.type == ChannelTypes.TYPE_CONFIG && ((RecordSet)this.get(this.getLastActiveRecordSetName())).getChannelConfigNumber() != ((RecordSet)this.get(recordSetKey)).getChannelConfigNumber()) {
                if (this.template != null) {
                    this.template.load();
                }
                if (this.template != null && this.template.isAvailable()) {
                    int b;
                    int g;
                    int r;
                    log.log(Level.FINER, "name = " + this.template.getDefaultFileName());
                    for (int i = 0; i < recordSet.realSize(); ++i) {
                        Record record = recordSet.get(i);
                        record.setVisible(Boolean.valueOf(this.template.getProperty(i + "_isVisible", "true")));
                        record.setPositionLeft(Boolean.valueOf(this.template.getProperty(i + "_isPositionLeft", "true")));
                        String color = this.template.getProperty(i + "_color", record.getRGB());
                        r = Integer.valueOf(color.split(",")[0].trim());
                        g = Integer.valueOf(color.split(",")[1].trim());
                        b = Integer.valueOf(color.split(",")[2].trim());
                        record.setColor(SWTResourceManager.getColor(r, g, b));
                        record.setLineWidth(Integer.valueOf(this.template.getProperty(i + "_lineWidth", "1")));
                        record.setLineStyle(Integer.valueOf(this.template.getProperty(i + "_lineStyle", "1")));
                        record.setRoundOut(Boolean.valueOf(this.template.getProperty(i + "_isRoundOut", "false")));
                        record.setStartpointZero(Boolean.valueOf(this.template.getProperty(i + "_isStartpointZero", "false")));
                        record.setStartEndDefined(Boolean.valueOf(this.template.getProperty(i + "_isStartEndDefined", "false")), Double.parseDouble(this.template.getProperty(i + "_defMinValue", "0")), Double.parseDouble(this.template.getProperty(i + "_defMaxValue", "100")));
                        record.setNumberFormat(Integer.valueOf(this.template.getProperty(i + "_numberFormat", "-1")));
                    }
                    recordSet.setSmoothAtCurrentDrop(Boolean.valueOf(this.template.getProperty("RecordSet_smoothAtCurrentDrop", "false")));
                    recordSet.setSmoothVoltageCurve(Boolean.valueOf(this.template.getProperty("RecordSet_smoothVoltageCurve", "false")));
                    String color = this.template.getProperty("RecordSet_timeGridColor", "128,128,128");
                    r = Integer.valueOf(color.split(",")[0].trim());
                    g = Integer.valueOf(color.split(",")[1].trim());
                    b = Integer.valueOf(color.split(",")[2].trim());
                    recordSet.setTimeGridColor(SWTResourceManager.getColor(r, g, b));
                    recordSet.setTimeGridLineStyle(Integer.valueOf(this.template.getProperty("RecordSet_timeGridLineStyle", "3")));
                    recordSet.setTimeGridType(Integer.valueOf(this.template.getProperty("RecordSet_timeGridType", "0")));
                    color = this.template.getProperty("RecordSet_horizontalGridColor", "128,128,128");
                    r = Integer.valueOf(color.split(",")[0].trim());
                    g = Integer.valueOf(color.split(",")[1].trim());
                    b = Integer.valueOf(color.split(",")[2].trim());
                    recordSet.setValueGridColor(SWTResourceManager.getColor(r, g, b));
                    recordSet.setValueGridLineStyle(Integer.valueOf(this.template.getProperty("RecordSet_horizontalGridLineStyle", "3")));
                    recordSet.setValueGridType(Integer.valueOf(this.template.getProperty("RecordSet_horizontalGridType", "0")));
                    recordSet.setValueGridRecordOrdinal(Integer.valueOf(this.template.getProperty("RecordSet_horizontalGridRecordOrdinal", "-1")));
                }
            } else {
                RecordSet _lastActiveRecordSet = (RecordSet)this.get(this.getLastActiveRecordSetName());
                int _lastActiveRecordSetSize = _lastActiveRecordSet.realSize();
                for (int i = 0; i < recordSet.realSize(); ++i) {
                    Record record = recordSet.get(i);
                    if (i < _lastActiveRecordSetSize) {
                        Record lastActiveRecord = _lastActiveRecordSet.get(i);
                        if (log.isLoggable(Level.FINER)) {
                            log.log(Level.FINER, "lastActiveRecord = " + lastActiveRecord.name + " isVisible=" + lastActiveRecord.isVisible + " isPositionLeft=" + lastActiveRecord.isPositionLeft + " isStartpointZero=" + lastActiveRecord.isStartpointZero);
                        }
                        record.setVisible(lastActiveRecord.isVisible);
                        record.setPositionLeft(lastActiveRecord.isPositionLeft);
                        record.setRGB(lastActiveRecord.getRGB());
                        record.setLineWidth(lastActiveRecord.lineWidth);
                        record.setLineStyle(lastActiveRecord.lineStyle);
                        record.setRoundOut(lastActiveRecord.isRoundOut);
                        record.setStartpointZero(lastActiveRecord.isStartpointZero);
                        record.setStartEndDefined(lastActiveRecord.isStartEndDefined, lastActiveRecord.getMinScaleValue(), lastActiveRecord.getMaxScaleValue());
                        record.setNumberFormat(lastActiveRecord.numberFormat);
                    }
                    RecordSet lastActiveParent = _lastActiveRecordSet;
                    recordSet.setSmoothAtCurrentDrop(lastActiveParent.isSmoothAtCurrentDrop);
                    recordSet.setSmoothVoltageCurve(lastActiveParent.isSmoothVoltageCurve);
                    recordSet.setTimeGridColor(lastActiveParent.timeGridColor);
                    recordSet.setTimeGridLineStyle(lastActiveParent.timeGridLineStyle);
                    recordSet.setTimeGridType(lastActiveParent.timeGridType);
                    recordSet.setValueGridColor(lastActiveParent.valueGridColor);
                    recordSet.setValueGridLineStyle(lastActiveParent.valueGridLineStyle);
                    recordSet.setValueGridType(lastActiveParent.valueGridType);
                    recordSet.setValueGridRecordOrdinal(lastActiveParent.valueGridRecordOrdinal >= 0 ? lastActiveParent.valueGridRecordOrdinal : 0);
                    if (!log.isLoggable(Level.FINER)) continue;
                    log.log(Level.FINER, "record = " + record.name + " isVisible=" + record.isVisible + " isPositionLeft=" + record.isPositionLeft + " isStartpointZero=" + record.isStartpointZero);
                }
            }
            if (log.isLoggable(Level.FINE)) {
                log.log(Level.FINE, "applied graphics template file " + this.template.getCurrentFilePath());
            }
            if (this.activeRecordSet != null && recordSet.getName().equals(this.activeRecordSet.name) && GDE.isWithUi()) {
                DataExplorer.getInstance().updateGraphicsWindow();
            }
        }
    }

    public void applyTemplate(String recordSetKey, boolean doUpdateVisibilityStatus) {
        RecordSet recordSet = (RecordSet)this.get(recordSetKey);
        RecordSet recordSet2 = this.activeRecordSet = this.analyzer.getActiveChannel() != null ? this.analyzer.getActiveChannel().getActiveRecordSet() : null;
        if (recordSet != null) {
            if (this.template != null) {
                this.template.load();
            }
            if (this.template != null && this.template.isAvailable()) {
                int b;
                int g;
                int r;
                for (int i = 0; i < recordSet.size(); ++i) {
                    Record record = recordSet.get(i);
                    record.setVisible(Boolean.parseBoolean(this.template.getProperty(i + "_isVisible", "true")));
                    record.setPositionLeft(Boolean.parseBoolean(this.template.getProperty(i + "_isPositionLeft", "true")));
                    String color = this.template.getProperty(i + "_color", record.getRGB());
                    r = Integer.valueOf(color.split(",")[0].trim());
                    g = Integer.valueOf(color.split(",")[1].trim());
                    b = Integer.valueOf(color.split(",")[2].trim());
                    record.setColor(SWTResourceManager.getColor(r, g, b));
                    record.setLineWidth(Integer.parseInt(this.template.getProperty(i + "_lineWidth", "1")));
                    record.setLineStyle(Integer.parseInt(this.template.getProperty(i + "_lineStyle", "1")));
                    record.setRoundOut(Boolean.parseBoolean(this.template.getProperty(i + "_isRoundOut", "false")));
                    record.setStartpointZero(Boolean.parseBoolean(this.template.getProperty(i + "_isStartpointZero", "false")));
                    record.setStartEndDefined(Boolean.parseBoolean(this.template.getProperty(i + "_isStartEndDefined", "false")), Double.parseDouble(this.template.getProperty(i + "_defMinValue", "0")), Double.parseDouble(this.template.getProperty(i + "_defMaxValue", "100")));
                    record.setNumberFormat(Integer.parseInt(this.template.getProperty(i + "_numberFormat", "-1")));
                }
                recordSet.setSmoothAtCurrentDrop(Boolean.parseBoolean(this.template.getProperty("RecordSet_smoothAtCurrentDrop", "false")));
                recordSet.setSmoothVoltageCurve(Boolean.parseBoolean(this.template.getProperty("RecordSet_smoothVoltageCurve", "false")));
                String color = this.template.getProperty("RecordSet_timeGridColor", "128,128,128");
                r = Integer.parseInt(color.split(",")[0].trim());
                g = Integer.parseInt(color.split(",")[1].trim());
                b = Integer.parseInt(color.split(",")[2].trim());
                recordSet.setTimeGridColor(SWTResourceManager.getColor(r, g, b));
                recordSet.setTimeGridLineStyle(Integer.parseInt(this.template.getProperty("RecordSet_timeGridLineStyle", "3")));
                recordSet.setTimeGridType(Integer.parseInt(this.template.getProperty("RecordSet_timeGridType", "0")));
                color = this.template.getProperty("RecordSet_horizontalGridColor", "128,128,128");
                r = Integer.parseInt(color.split(",")[0].trim());
                g = Integer.parseInt(color.split(",")[1].trim());
                b = Integer.parseInt(color.split(",")[2].trim());
                recordSet.setValueGridColor(SWTResourceManager.getColor(r, g, b));
                recordSet.setValueGridLineStyle(Integer.parseInt(this.template.getProperty("RecordSet_horizontalGridLineStyle", "3")));
                recordSet.setValueGridType(Integer.parseInt(this.template.getProperty("RecordSet_horizontalGridType", "0")));
                int gridRecordOrdinal = Integer.parseInt(this.template.getProperty("RecordSet_horizontalGridRecordOrdinal", "-1"));
                if (gridRecordOrdinal >= 0 && gridRecordOrdinal < recordSet.realSize() && recordSet.get((int)gridRecordOrdinal).isVisible) {
                    recordSet.setValueGridRecordOrdinal(gridRecordOrdinal);
                } else {
                    recordSet.setValueGridRecordOrdinal(this.findFirstVisibleRecord(recordSet));
                }
                recordSet.setUnsaved(RecordSet.UNSAVED_REASON_GRAPHICS);
                if (log.isLoggable(Level.FINE)) {
                    log.log(Level.FINE, "applied graphics template file " + this.template.getCurrentFilePath());
                }
                if (doUpdateVisibilityStatus) {
                    recordSet.device.updateVisibilityStatus(recordSet, false);
                }
                if (this.activeRecordSet != null && recordSet.getName().equals(this.activeRecordSet.name) && GDE.isWithUi()) {
                    DataExplorer.getInstance().updateGraphicsWindow();
                }
            }
        }
    }

    protected int findFirstVisibleRecord(RecordSet recordSet) {
        int j;
        for (j = 0; j < recordSet.size() && !recordSet.get((int)j).isVisible; ++j) {
        }
        return j;
    }

    public void applyTemplateScaleEndpoints(String recordSetKey) {
        RecordSet recordSet = (RecordSet)this.get(recordSetKey);
        RecordSet recordSet2 = this.activeRecordSet = this.analyzer.getActiveChannel() != null ? this.analyzer.getActiveChannel().getActiveRecordSet() : null;
        if (recordSet != null) {
            if (this.template != null && this.template.isAvailable()) {
                for (int i = 0; i < recordSet.size(); ++i) {
                    Record record = recordSet.get(i);
                    record.setRoundOut(Boolean.parseBoolean(this.template.getProperty(i + "_isRoundOut", "false")));
                }
                int gridRecordOrdinal = Integer.parseInt(this.template.getProperty("RecordSet_horizontalGridRecordOrdinal", "-1"));
                if (gridRecordOrdinal >= 0 && gridRecordOrdinal < recordSet.realSize() && recordSet.get((int)gridRecordOrdinal).isVisible) {
                    recordSet.setValueGridRecordOrdinal(gridRecordOrdinal);
                } else {
                    recordSet.setValueGridRecordOrdinal(this.findFirstVisibleRecord(recordSet));
                }
            }
            if (this.activeRecordSet != null && recordSet.getName().equals(this.activeRecordSet.name) && GDE.isWithUi()) {
                DataExplorer.getInstance().updateGraphicsWindow();
            }
        }
    }

    public void remove(String deleteRecordSetName) {
        super.remove(deleteRecordSetName);
        this.activeRecordSet = this.size() == 0 ? null : (RecordSet)this.get(this.getRecordSetNames()[0]);
    }

    public RecordSet getActiveRecordSet() {
        return this.activeRecordSet;
    }

    public void setActiveRecordSet(String recordSetKey) {
        DataExplorer.getInstance().checkUpdateFileComment();
        DataExplorer.getInstance().checkUpdateRecordSetComment();
        RecordSet newActiveRecordSet = (RecordSet)this.get(recordSetKey);
        if (newActiveRecordSet != null) {
            this.activeRecordSet = newActiveRecordSet;
        }
    }

    public void setActiveRecordSet(RecordSet newActiveRecordSet) {
        this.activeRecordSet = newActiveRecordSet;
    }

    public synchronized void switchRecordSet(String recordSetName) {
        DataExplorer application;
        int percentage;
        if (!GDE.isWithUi()) {
            throw new UnsupportedOperationException("for use with internal UI only");
        }
        if (log.isLoggable(Level.FINE)) {
            log.log(Level.FINE, String.format("switching to record set threadId = %06d", Thread.currentThread().getId()));
        }
        if ((percentage = (application = DataExplorer.getInstance()).getProgressPercentage()) > 99 || percentage == 0) {
            application.setProgress(0, null);
        }
        final String recordSetKey = recordSetName;
        this.lastActiveRecordSet = (RecordSet)this.get(recordSetKey);
        if (Thread.currentThread().getId() == application.getThreadId()) {
            this.updateForSwitchRecordSet(application, recordSetKey);
        } else {
            GDE.display.asyncExec(new Runnable(){

                @Override
                public void run() {
                    Channel.this.updateForSwitchRecordSet(application, recordSetKey);
                }
            });
        }
    }

    private void updateForSwitchRecordSet(DataExplorer application, String recordSetKey) {
        RecordSet recordSet;
        RecordSet oldRecordSet = this.getActiveRecordSet();
        if (oldRecordSet != null) {
            oldRecordSet.resetZoomAndMeasurement();
        }
        if ((recordSet = (RecordSet)this.get(recordSetKey)) == null) {
            int channelNumber = this.findChannelOfRecordSet(recordSetKey);
            if (channelNumber > 0) {
                this.analyzer.getChannels().switchChannel(channelNumber, recordSetKey);
                recordSet = (RecordSet)this.get(recordSetKey);
                if (recordSet != null && recordSet.isRecalculation) {
                    recordSet.checkAllDisplayable();
                }
            }
        } else {
            this.setActiveRecordSet(recordSetKey);
            if (!recordSet.hasDisplayableData) {
                recordSet.loadFileData(this.getFullQualifiedFileName(), true);
            }
            recordSet.resetZoomAndMeasurement();
            application.resetGraphicsWindowZoomAndMeasurement();
            if (recordSet.isRecalculation) {
                recordSet.checkAllDisplayable();
            }
            application.getMenuToolBar().updateRecordSetSelectCombo();
            application.updateMenusRegardingGPSData();
            application.cleanHeaderAndCommentInGraphicsWindow();
            application.updateAllTabs(true);
        }
    }

    public int findChannelOfRecordSet(String recordSetKey) {
        int channelNumber = 0;
        Channels channels = this.analyzer.getChannels();
        for (Integer tmpNumber : channels.keySet()) {
            Channel channel = (Channel)channels.get(tmpNumber);
            if (channel.get(recordSetKey) == null) continue;
            channelNumber = tmpNumber;
        }
        return channelNumber;
    }

    public ChannelTypes getType() {
        return this.type;
    }

    public void setName(String newName) {
        this.name = newName;
    }

    public String getFileName() {
        return this.fileName != null ? this.fileName.substring(this.fileName.lastIndexOf(47) + 1) : null;
    }

    public String getFullQualifiedFileName() {
        return this.fileName;
    }

    public void setFileName(String newFileName) {
        if (this.type == ChannelTypes.TYPE_CONFIG) {
            Channels channels = this.analyzer.getChannels();
            for (int i = 1; i <= channels.getChannelNames().length; ++i) {
                ((Channel)channels.get((Object)Integer.valueOf((int)i))).fileName = newFileName;
            }
        } else {
            this.fileName = newFileName;
        }
        if (this.fileName != null && this.analyzer.getActiveDevice() != null) {
            DataExplorer.getInstance().updateTitleBar(this.analyzer.getSettings().getActiveObjectKey(), this.analyzer.getActiveDevice().getName(), this.analyzer.getActiveDevice().getPort());
        }
    }

    public String getFileDescription() {
        if (log.isLoggable(Level.FINE)) {
            log.log(Level.FINE, String.format("Channel %s get description %s", this.getName(), this.fileDescription));
        }
        return this.fileDescription;
    }

    public void setFileDescription(String newFileDescription) {
        this.setUnsaved(RecordSet.UNSAVED_REASON_COMMENT);
        this.fileDescription = newFileDescription;
        if (log.isLoggable(Level.INFO)) {
            log.log(Level.INFO, String.format("Channel %s set description %s", this.getName(), newFileDescription));
        }
        DataExplorer.getInstance().updateGraphicsCaptions();
    }

    public void syncFileDescription(Channel syncChannel, String updateComment) {
        this.parent.syncFileDescription(syncChannel, updateComment);
    }

    public boolean isSaved() {
        return this.isSaved;
    }

    public void setSaved(boolean is_saved) {
        if (this.type == ChannelTypes.TYPE_CONFIG) {
            Channels channels = this.analyzer.getChannels();
            for (int i = 1; i <= channels.getChannelNames().length; ++i) {
                ((Channel)channels.get((Object)Integer.valueOf((int)i))).isSaved = is_saved;
            }
        } else {
            this.isSaved = is_saved;
        }
    }

    public void setUnsaved(String unsavedReason) {
        this.activeRecordSet = this.getActiveRecordSet();
        if (this.activeRecordSet != null) {
            this.activeRecordSet.setUnsaved(unsavedReason);
        }
    }

    public synchronized void checkAndLoadData() {
        String fullQualifiedFileName = this.getFullQualifiedFileName();
        for (String tmpRecordSetName : this.getRecordSetNames()) {
            Channel selectedChannel;
            Channel activeChannel;
            if (log.isLoggable(Level.FINER)) {
                log.log(Level.FINER, "tmpRecordSetName = " + tmpRecordSetName);
            }
            if ((activeChannel = this.analyzer.getActiveChannel()) == null) continue;
            Channel channel = selectedChannel = activeChannel.getType().equals((Object)ChannelTypes.TYPE_OUTLET) ? activeChannel : (Channel)this.analyzer.getChannels().get(this.findChannelOfRecordSet(tmpRecordSetName));
            if (log.isLoggable(Level.FINER)) {
                log.log(Level.FINER, "selectedChannel = " + (selectedChannel != null ? selectedChannel.getName() : "null"));
            }
            if (selectedChannel == null) continue;
            RecordSet tmpRecordSet = (RecordSet)selectedChannel.get(tmpRecordSetName);
            if (log.isLoggable(Level.FINER)) {
                log.log(Level.FINER, "tmpRecordSet = " + (tmpRecordSet != null ? tmpRecordSet.getName() : "null"));
            }
            if (tmpRecordSet == null || tmpRecordSet.hasDisplayableData()) continue;
            if (log.isLoggable(Level.FINER)) {
                log.log(Level.FINER, "tmpRecordSetName needs data to loaded");
            }
            if (tmpRecordSet.fileDataSize == 0 || tmpRecordSet.fileDataPointer == 0L) continue;
            if (log.isLoggable(Level.FINER)) {
                log.log(Level.FINER, "loading data ...");
            }
            tmpRecordSet.loadFileData(fullQualifiedFileName, GDE.isWithUi());
        }
    }

    public int getNumber() {
        return this.number;
    }

    public String getObjectKey() {
        return this.objectKey;
    }

    public void setObjectKey(String newObjectKey) {
        if (!this.objectKey.equals(newObjectKey)) {
            this.objectKey = newObjectKey;
            if (this.activeRecordSet != null) {
                if (newObjectKey.equals("")) {
                    this.activeRecordSet.setUnsaved(UNSAVED_REASON_REMOVE_OBJECT_KEY);
                } else {
                    this.activeRecordSet.setUnsaved(UNSAVED_REASON_ADD_OBJECT_KEY);
                }
            }
        }
    }

    @Override
    public void clear() {
        for (String recordSetKey : this.getRecordSetNames()) {
            if (recordSetKey == null || recordSetKey.length() <= 3) continue;
            this.remove(recordSetKey);
        }
        super.clear();
        this.objectKey = "";
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int hashCode = super.hashCode();
        hashCode = 31 * hashCode + (this.name == null ? 0 : this.name.hashCode());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Channel other = (Channel)obj;
        if (this.name == null) {
            if (other.name != null) {
                return false;
            }
        } else {
            if (!this.name.equals(other.name)) {
                return false;
            }
            super.equals(other);
        }
        return true;
    }
}

