/*
 * Decompiled with CFR 0.152.
 */
package com.monstarmike.tlmreader.datablock;

import com.monstarmike.tlmreader.datablock.DataBlock;
import com.monstarmike.tlmreader.primitives.Shorts;

public class RxBlock
extends DataBlock {
    private short lostPacketsReceiverA;
    private short lostPacketsReceiverB;
    private short lostPacketsReceiverL;
    private short lostPacketsReceiverR;
    private short frameLoss;
    private short holds;
    private short voltageInHunderthOfVolts;

    public RxBlock(byte[] rawData) {
        super(rawData);
        this.decode(rawData);
        this.measurementNames.add("LostPacketsReceiver A");
        this.measurementNames.add("LostPacketsReceiver B");
        this.measurementNames.add("LostPacketsReceiver L");
        this.measurementNames.add("LostPacketsReceiver R");
        this.measurementNames.add("FrameLoss");
        this.measurementNames.add("Holds");
        this.measurementNames.add("VoltageRx");
        this.measurementUnits.add("");
        this.measurementUnits.add("");
        this.measurementUnits.add("");
        this.measurementUnits.add("");
        this.measurementUnits.add("");
        this.measurementUnits.add("");
        this.measurementUnits.add("V");
        this.measurementFactors.add(1.0);
        this.measurementFactors.add(1.0);
        this.measurementFactors.add(1.0);
        this.measurementFactors.add(1.0);
        this.measurementFactors.add(1.0);
        this.measurementFactors.add(1.0);
        this.measurementFactors.add(0.01);
    }

    @Override
    public boolean areValuesEquals(DataBlock block) {
        if (block instanceof RxBlock) {
            RxBlock rx = (RxBlock)block;
            return rx.voltageInHunderthOfVolts == this.getVoltageInHunderthOfVolts() && rx.lostPacketsReceiverA == this.getLostPacketsReceiverA() && rx.lostPacketsReceiverB == this.getLostPacketsReceiverB() && rx.lostPacketsReceiverL == this.getLostPacketsReceiverL() && rx.lostPacketsReceiverR == this.getLostPacketsReceiverR() && rx.frameLoss == this.getFrameLoss() && rx.holds == this.getHolds();
        }
        return false;
    }

    private void decode(byte[] rawData) {
        this.lostPacketsReceiverA = Shorts.fromBytes(rawData[6], rawData[7]);
        this.lostPacketsReceiverB = Shorts.fromBytes(rawData[8], rawData[9]);
        this.lostPacketsReceiverL = Shorts.fromBytes(rawData[10], rawData[11]);
        this.lostPacketsReceiverR = Shorts.fromBytes(rawData[12], rawData[13]);
        this.frameLoss = Shorts.fromBytes(rawData[14], rawData[15]);
        this.holds = Shorts.fromBytes(rawData[16], rawData[17]);
        this.voltageInHunderthOfVolts = Shorts.fromBytes(rawData[18], rawData[19]);
        this.measurementValues.add(Integer.valueOf(this.getLostPacketsReceiverA()));
        this.measurementValues.add(Integer.valueOf(this.getLostPacketsReceiverB()));
        this.measurementValues.add(Integer.valueOf(this.getLostPacketsReceiverL()));
        this.measurementValues.add(Integer.valueOf(this.getLostPacketsReceiverR()));
        this.measurementValues.add(Integer.valueOf(this.getFrameLoss()));
        this.measurementValues.add(Integer.valueOf(this.getHolds()));
        this.measurementValues.add(Integer.valueOf(this.getVoltageInHunderthOfVolts()));
    }

    private boolean isValidData(short value) {
        return value >= 0;
    }

    public boolean hasValidDataLostPacketsReceiverA() {
        return this.isValidData(this.lostPacketsReceiverA);
    }

    public short getLostPacketsReceiverA() {
        return (this.lostPacketsReceiverA & 0xF000) < 1 ? this.lostPacketsReceiverA : (short)0;
    }

    public boolean hasValidDataLostPacketsReceiverB() {
        return this.isValidData(this.lostPacketsReceiverB);
    }

    public short getLostPacketsReceiverB() {
        return (this.lostPacketsReceiverB & 0xF000) < 1 ? this.lostPacketsReceiverB : (short)0;
    }

    public boolean hasValidDataLostPacketsReceiverL() {
        return this.isValidData(this.lostPacketsReceiverL);
    }

    public short getLostPacketsReceiverL() {
        return (this.lostPacketsReceiverL & 0xF000) < 1 ? this.lostPacketsReceiverL : (short)0;
    }

    public boolean hasValidDataLostPacketsReceiverR() {
        return this.isValidData(this.lostPacketsReceiverR);
    }

    public short getLostPacketsReceiverR() {
        return (this.lostPacketsReceiverR & 0xF000) < 1 ? this.lostPacketsReceiverR : (short)0;
    }

    public boolean hasValidFrameLosssData() {
        return this.isValidData(this.frameLoss);
    }

    public short getFrameLoss() {
        return (this.frameLoss & 0xF000) < 1 ? this.frameLoss : (short)0;
    }

    public boolean hasValidHoldsData() {
        return this.isValidData(this.holds);
    }

    public short getHolds() {
        return (this.holds & 0xF000) < 1 ? this.holds : (short)0;
    }

    public short getVoltageInHunderthOfVolts() {
        return this.voltageInHunderthOfVolts;
    }
}

