/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.widgets;

import org.eclipse.swt.internal.Converter;
import org.eclipse.swt.internal.gtk.OS;
import org.eclipse.swt.widgets.Dialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;

public class FileDialog
extends Dialog {
    String[] filterNames = new String[0];
    String[] filterExtensions = new String[0];
    String filterPath = "";
    String fileName = "";
    String[] fileNames = new String[0];
    String fullPath = "";
    int filterIndex = -1;
    boolean overwrite = false;
    boolean uriMode;
    int handle;
    static final char SEPARATOR = System.getProperty("file.separator").charAt(0);
    static final char EXTENSION_SEPARATOR = ';';
    static final char FILE_EXTENSION_SEPARATOR = '.';

    public FileDialog(Shell shell) {
        this(shell, 65536);
    }

    public FileDialog(Shell shell, int n) {
        super(shell, FileDialog.checkStyle(shell, n));
        this.checkSubclass();
    }

    String computeResultChooserDialog() {
        int n;
        int n2;
        int n3;
        int n4;
        int n5;
        int n6;
        this.fullPath = null;
        if ((this.style & 2) != 0) {
            n6 = 0;
            n6 = this.uriMode ? OS.gtk_file_chooser_get_uris(this.handle) : OS.gtk_file_chooser_get_filenames(this.handle);
            int n7 = OS.g_slist_length(n6);
            this.fileNames = new String[n7];
            n5 = n6;
            n4 = 0;
            for (n3 = 0; n3 < n7; ++n3) {
                n2 = OS.g_slist_data(n5);
                int n8 = 0;
                if (this.uriMode) {
                    n8 = n2;
                } else {
                    n8 = OS.g_filename_to_utf8(n2, -1, null, null, null);
                    if (n8 == 0) {
                        n8 = OS.g_filename_display_name(n2);
                    }
                }
                if (n2 != n8) {
                    OS.g_free(n2);
                }
                if (n8 != 0) {
                    int[] nArray = new int[1];
                    int n9 = OS.g_utf8_to_utf16(n8, -1, null, nArray, null);
                    OS.g_free(n8);
                    if (n9 != 0) {
                        int n10 = nArray[0];
                        char[] cArray = new char[n10];
                        OS.memmove(cArray, n9, n10 * 2);
                        OS.g_free(n9);
                        this.fullPath = new String(cArray);
                        this.fileNames[n4++] = this.fullPath.substring(this.fullPath.lastIndexOf(SEPARATOR) + 1);
                    }
                }
                n5 = OS.g_slist_next(n5);
            }
            if (n4 != 0 && n4 != n7) {
                String[] stringArray = new String[n4];
                System.arraycopy(this.fileNames, 0, stringArray, 0, n4);
                this.fileNames = stringArray;
            }
            OS.g_slist_free(n6);
        } else {
            n6 = 0;
            if (this.uriMode) {
                n6 = OS.gtk_file_chooser_get_uri(this.handle);
            } else {
                int n11 = OS.gtk_file_chooser_get_filename(this.handle);
                if (n11 != 0) {
                    n6 = OS.g_filename_to_utf8(n11, -1, null, null, null);
                    if (n6 == 0) {
                        n6 = OS.g_filename_display_name(n11);
                    }
                    if (n11 != n6) {
                        OS.g_free(n11);
                    }
                }
            }
            if (n6 != 0) {
                int[] nArray = new int[1];
                n5 = OS.g_utf8_to_utf16(n6, -1, null, nArray, null);
                OS.g_free(n6);
                if (n5 != 0) {
                    n4 = nArray[0];
                    char[] cArray = new char[n4];
                    OS.memmove(cArray, n5, n4 * 2);
                    OS.g_free(n5);
                    this.fullPath = new String(cArray);
                    this.fileNames = new String[1];
                    this.fileNames[0] = this.fullPath.substring(this.fullPath.lastIndexOf(SEPARATOR) + 1);
                }
            }
        }
        this.filterIndex = -1;
        n6 = OS.gtk_file_chooser_get_filter(this.handle);
        if (n6 != 0 && (n = OS.gtk_file_filter_get_name(n6)) != 0) {
            n5 = OS.strlen(n);
            byte[] byArray = new byte[n5];
            OS.memmove(byArray, n, n5);
            String string = new String(Converter.mbcsToWcs(null, byArray));
            for (n2 = 0; n2 < this.filterExtensions.length; ++n2) {
                if (this.filterNames.length > 0) {
                    if (!this.filterNames[n2].equals(string)) continue;
                    this.filterIndex = n2;
                    break;
                }
                if (!this.filterExtensions[n2].equals(string)) continue;
                this.filterIndex = n2;
                break;
            }
        }
        if (this.fullPath != null) {
            int n12 = this.fullPath.lastIndexOf(SEPARATOR);
            this.fileName = this.fullPath.substring(n12 + 1);
            this.filterPath = this.fullPath.substring(0, n12);
            n5 = this.fileName.indexOf(46);
            if ((this.style & 0x2000) != 0 && n5 == -1 && this.filterIndex != -1 && this.filterExtensions.length > this.filterIndex) {
                String string;
                String string2 = this.filterExtensions[this.filterIndex];
                n3 = string2.length();
                n2 = string2.indexOf(59);
                if (n2 == -1) {
                    n2 = n3;
                }
                if (!(string = string2.substring(0, n2).trim()).equals("*") && !string.equals("*.*")) {
                    if (string.startsWith("*.")) {
                        string = string.substring(1);
                    }
                    this.fullPath = this.fullPath + string;
                }
            }
        }
        return this.fullPath;
    }

    public String getFileName() {
        return this.fileName;
    }

    public String[] getFileNames() {
        return this.fileNames;
    }

    public String[] getFilterExtensions() {
        return this.filterExtensions;
    }

    public int getFilterIndex() {
        return this.filterIndex;
    }

    public String[] getFilterNames() {
        return this.filterNames;
    }

    public String getFilterPath() {
        return this.filterPath;
    }

    public boolean getOverwrite() {
        return this.overwrite;
    }

    public String open() {
        return this.openChooserDialog();
    }

    String openChooserDialog() {
        int n;
        byte[] byArray = Converter.wcsToMbcs(null, this.title, true);
        int n2 = (this.style & 0x2000) != 0 ? 1 : 0;
        int n3 = this.parent.topHandle();
        Display display = this.parent != null ? this.parent.getDisplay() : Display.getCurrent();
        this.handle = display.getDismissalAlignment() == 131072 ? OS.gtk_file_chooser_dialog_new(byArray, n3, n2, OS.GTK_STOCK_CANCEL(), -6, OS.GTK_STOCK_OK(), -5, 0) : OS.gtk_file_chooser_dialog_new(byArray, n3, n2, OS.GTK_STOCK_OK(), -5, OS.GTK_STOCK_CANCEL(), -6, 0);
        if (this.handle == 0) {
            this.error(2);
        }
        OS.gtk_window_set_modal(this.handle, true);
        if (OS.GTK_VERSION >= OS.VERSION(2, 10, 0)) {
            n = OS.gtk_window_get_group(0);
            OS.gtk_window_group_add_window(n, this.handle);
        }
        if ((n = OS.gtk_window_get_icon_list(n3)) != 0) {
            OS.gtk_window_set_icon_list(this.handle, n);
            OS.g_list_free(n);
        }
        if (this.uriMode) {
            OS.gtk_file_chooser_set_local_only(this.handle, false);
        }
        this.presetChooserDialog();
        display.addIdleProc();
        String string = null;
        Dialog dialog = null;
        if (OS.gtk_window_get_modal(this.handle)) {
            dialog = display.getModalDialog();
            display.setModalDialog(this);
        }
        int n4 = 0;
        int n5 = 0;
        if ((this.style & 0x4000000) != 0) {
            n4 = OS.g_signal_lookup(OS.map, OS.GTK_TYPE_WIDGET());
            n5 = OS.g_signal_add_emission_hook(n4, 0, display.emissionProc, this.handle, 0);
        }
        int n6 = OS.gtk_dialog_run(this.handle);
        OS.gdk_threads_leave();
        if ((this.style & 0x4000000) != 0) {
            OS.g_signal_remove_emission_hook(n4, n5);
        }
        if (OS.gtk_window_get_modal(this.handle)) {
            display.setModalDialog(dialog);
        }
        if (n6 == -5) {
            string = this.computeResultChooserDialog();
        }
        display.removeIdleProc();
        OS.gtk_widget_destroy(this.handle);
        return string;
    }

    void presetChooserDialog() {
        int n;
        int n2;
        Object object;
        if ((this.style & 0x2002) == 2) {
            OS.gtk_file_chooser_set_select_multiple(this.handle, true);
        }
        if (this.filterPath == null) {
            this.filterPath = "";
        }
        if (this.fileName == null) {
            this.fileName = "";
        }
        if ((this.style & 0x2000) != 0) {
            if (this.filterPath.length() > 0) {
                if (this.uriMode) {
                    object = Converter.wcsToMbcs(null, this.filterPath, true);
                    OS.gtk_file_chooser_set_current_folder_uri(this.handle, (byte[])object);
                } else {
                    object = Converter.wcsToMbcs(null, SEPARATOR + this.filterPath, true);
                    n2 = OS.realpath((byte[])object, null);
                    OS.gtk_file_chooser_set_current_folder(this.handle, n2);
                    OS.g_free(n2);
                }
            }
            if (this.fileName.length() > 0) {
                object = Converter.wcsToMbcs(null, this.fileName, true);
                OS.gtk_file_chooser_set_current_name(this.handle, (byte[])object);
            }
        } else {
            object = new StringBuffer();
            if (this.filterPath.length() > 0) {
                if (!this.uriMode) {
                    ((StringBuffer)object).append(SEPARATOR);
                }
                ((StringBuffer)object).append(this.filterPath);
                ((StringBuffer)object).append(SEPARATOR);
            }
            if (this.fileName.length() > 0) {
                ((StringBuffer)object).append(this.fileName);
            }
            byte[] byArray = Converter.wcsToMbcs(null, ((StringBuffer)object).toString(), true);
            if (this.uriMode) {
                OS.gtk_file_chooser_set_uri(this.handle, byArray);
            } else {
                n = OS.realpath(byArray, null);
                if (n != 0) {
                    if (this.fileName.length() > 0) {
                        OS.gtk_file_chooser_set_filename(this.handle, n);
                    } else {
                        OS.gtk_file_chooser_set_current_folder(this.handle, n);
                    }
                    OS.g_free(n);
                }
            }
        }
        if ((this.style & 0x2000) != 0 && OS.GTK_VERSION >= OS.VERSION(2, 8, 0)) {
            OS.gtk_file_chooser_set_do_overwrite_confirmation(this.handle, this.overwrite);
        }
        if (this.filterNames == null) {
            this.filterNames = new String[0];
        }
        if (this.filterExtensions == null) {
            this.filterExtensions = new String[0];
        }
        int n3 = 0;
        for (n2 = 0; n2 < this.filterExtensions.length; ++n2) {
            byte[] byArray;
            String string;
            byte[] byArray2;
            if (this.filterExtensions[n2] == null) continue;
            n = OS.gtk_file_filter_new();
            if (this.filterNames.length > n2 && this.filterNames[n2] != null) {
                byArray2 = Converter.wcsToMbcs(null, this.filterNames[n2], true);
                OS.gtk_file_filter_set_name(n, byArray2);
            } else {
                byArray2 = Converter.wcsToMbcs(null, this.filterExtensions[n2], true);
                OS.gtk_file_filter_set_name(n, byArray2);
            }
            int n4 = 0;
            int n5 = this.filterExtensions[n2].indexOf(59);
            while (n5 != -1) {
                string = this.filterExtensions[n2].substring(n4, n5);
                byArray = Converter.wcsToMbcs(null, string, true);
                OS.gtk_file_filter_add_pattern(n, byArray);
                n4 = n5 + 1;
                n5 = this.filterExtensions[n2].indexOf(59, n4);
            }
            string = this.filterExtensions[n2].substring(n4);
            byArray = Converter.wcsToMbcs(null, string, true);
            OS.gtk_file_filter_add_pattern(n, byArray);
            OS.gtk_file_chooser_add_filter(this.handle, n);
            if (n2 != this.filterIndex) continue;
            n3 = n;
        }
        if (n3 != 0) {
            OS.gtk_file_chooser_set_filter(this.handle, n3);
        }
        this.fullPath = null;
        this.fileNames = new String[0];
    }

    public void setFileName(String string) {
        this.fileName = string;
    }

    public void setFilterExtensions(String[] stringArray) {
        this.filterExtensions = stringArray;
    }

    public void setFilterIndex(int n) {
        this.filterIndex = n;
    }

    public void setFilterNames(String[] stringArray) {
        this.filterNames = stringArray;
    }

    public void setFilterPath(String string) {
        this.filterPath = string;
    }

    public void setOverwrite(boolean bl) {
        this.overwrite = bl;
    }

    void setURIMode(boolean bl) {
        this.uriMode = bl;
    }
}

