/*
 * Decompiled with CFR 0.152.
 */
package de.treichels.hott.decoder.internal.firmware;

import de.treichels.hott.decoder.internal.firmware.DeviceFirmware;
import de.treichels.hott.decoder.internal.firmware.DeviceFirmwareKt;
import de.treichels.hott.decoder.internal.firmware.StandardDeviceFirmwareKt;
import de.treichels.hott.model.enums.ReceiverType;
import de.treichels.hott.model.enums.Registered;
import de.treichels.hott.serial.SerialPort;
import de.treichels.hott.util.Callback;
import de.treichels.hott.util.StreamSupportKt;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.CountDownLatch;
import javafx.scene.control.Alert;
import javafx.scene.control.ButtonBar;
import javafx.scene.control.ButtonType;
import javafx.stage.Window;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.Triple;
import kotlin.TypeCastException;
import kotlin.UInt;
import kotlin.Unit;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.io.CloseableKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.jvm.internal.StringCompanionObject;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import tornadofx.AsyncKt;
import tornadofx.MessagesKt;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u0011\n\u0002\u0010\u0012\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \u001d2\u00020\u0001:\u0001\u001dB7\u0012\n\u0010\u0002\u001a\u0006\u0012\u0002\b\u00030\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0005\u0012\u0006\u0010\u0007\u001a\u00020\u0005\u0012\f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\t\u00a2\u0006\u0002\u0010\u000bJ\u0013\u0010\u0010\u001a\u00020\u00112\b\u0010\u0012\u001a\u0004\u0018\u00010\u0013H\u0096\u0002J\b\u0010\u0014\u001a\u00020\u0005H\u0016J\b\u0010\u0015\u001a\u00020\u0016H\u0016J\u001a\u0010\u0017\u001a\u00020\u00182\b\u0010\u0019\u001a\u0004\u0018\u00010\u001a2\u0006\u0010\u001b\u001a\u00020\u001cH\u0016R\u0011\u0010\u0006\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0011\u0010\u0007\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\rR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\r\u00a8\u0006\u001e"}, d2={"Lde/treichels/hott/decoder/internal/firmware/StandardDeviceFirmware;", "Lde/treichels/hott/decoder/internal/firmware/DeviceFirmware;", "deviceType", "Lde/treichels/hott/model/enums/Registered;", "version", "", "deviceId", "processId", "packets", "", "", "(Lde/treichels/hott/model/enums/Registered;III[[B)V", "getDeviceId", "()I", "getProcessId", "getVersion", "equals", "", "other", "", "hashCode", "toString", "", "updateDevice", "", "callback", "Lde/treichels/hott/util/Callback;", "port", "Lde/treichels/hott/serial/SerialPort;", "Companion", "HoTT-Decoder"})
public final class StandardDeviceFirmware
extends DeviceFirmware {
    private final int version;
    private final int deviceId;
    private final int processId;
    @NotNull
    private static final List<Registered<?>> devicesNeedButtonBoot;
    public static final Companion Companion;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    @Override
    public void updateDevice(@Nullable Callback callback, @NotNull SerialPort port) {
        Intrinsics.checkParameterIsNotNull(port, "port");
        port.setBaudRate(19200);
        Closeable closeable = port;
        Throwable throwable = null;
        try {
            block30: {
                Triple<Integer, Integer, Integer> triple;
                SerialPort it = (SerialPort)closeable;
                it.open();
                try {
                    triple = Companion.getInfo(it);
                }
                catch (IOException e) {
                    if (devicesNeedButtonBoot.contains(this.getDeviceType())) {
                        Callback callback2 = callback;
                        if (callback2 != null) {
                            String string2 = MessagesKt.get(DeviceFirmware.Companion.getMessages(), "waitForDeviceButton");
                            Intrinsics.checkExpressionValueIsNotNull(string2, "messages[\"waitForDeviceButton\"]");
                            callback2.updateMessage(string2);
                        }
                    } else {
                        Callback callback3 = callback;
                        if (callback3 != null) {
                            String string3 = MessagesKt.get(DeviceFirmware.Companion.getMessages(), "waitForDevice");
                            Intrinsics.checkExpressionValueIsNotNull(string3, "messages[\"waitForDevice\"]");
                            callback3.updateMessage(string3);
                        }
                    }
                    int rc = DeviceFirmwareKt.waitForBoot(it, callback, 5, 10);
                    Callback callback4 = callback;
                    if (callback4 != null) {
                        if (callback4.isCancelled()) {
                            String string4 = MessagesKt.get(DeviceFirmware.Companion.getMessages(), "cancelled");
                            Intrinsics.checkExpressionValueIsNotNull(string4, "messages[\"cancelled\"]");
                            callback.updateMessage(string4);
                            break block30;
                        }
                    }
                    Companion.updateMode(rc, it);
                    Thread.sleep(100L);
                    triple = Companion.getInfo(it);
                }
                Object object = triple;
                int n = ((Number)((Triple)object).component1()).intValue();
                int n2 = ((Number)((Triple)object).component2()).intValue();
                int bootVersion = ((Number)((Triple)object).component3()).intValue();
                try {
                    void doUpdate;
                    void appVersion;
                    void productCode;
                    if (productCode != this.getDeviceType().getProductCode()) {
                        String string5;
                        object = StringCompanionObject.INSTANCE;
                        String string6 = MessagesKt.get(DeviceFirmware.Companion.getMessages(), "invalidDeviceType");
                        Intrinsics.checkExpressionValueIsNotNull(string6, "messages[\"invalidDeviceType\"]");
                        triple = string6;
                        Object[] e = new Object[]{ReceiverType.Companion.forProductCode((int)productCode), this.getDeviceType()};
                        String string7 = String.format(triple, Arrays.copyOf(e, e.length));
                        Intrinsics.checkExpressionValueIsNotNull(string7, "java.lang.String.format(format, *args)");
                        String string8 = string5 = string7;
                        throw (Throwable)new IOException(string8);
                    }
                    CountDownLatch latch = new CountDownLatch(1);
                    triple = new Ref.BooleanRef();
                    ((Ref.BooleanRef)((Object)triple)).element = false;
                    AsyncKt.runLater(new Function0<Unit>((int)appVersion, (Ref.BooleanRef)doUpdate, bootVersion, latch, this, callback){
                        final /* synthetic */ int $appVersion;
                        final /* synthetic */ Ref.BooleanRef $doUpdate;
                        final /* synthetic */ int $bootVersion;
                        final /* synthetic */ CountDownLatch $latch;
                        final /* synthetic */ StandardDeviceFirmware this$0;
                        final /* synthetic */ Callback $callback$inlined;
                        {
                            this.$appVersion = n;
                            this.$doUpdate = booleanRef;
                            this.$bootVersion = n2;
                            this.$latch = countDownLatch;
                            this.this$0 = standardDeviceFirmware;
                            this.$callback$inlined = callback;
                            super(0);
                        }

                        /*
                         * WARNING - void declaration
                         */
                        public final void invoke() {
                            if (this.this$0.getVersion() < this.$appVersion) {
                                Optional buttonClicked$iv$iv;
                                void header$iv;
                                void type$iv$iv;
                                void content$iv;
                                String string2 = MessagesKt.get(DeviceFirmware.Companion.getMessages(), "downgradeWarning");
                                Intrinsics.checkExpressionValueIsNotNull(string2, "messages[\"downgradeWarning\"]");
                                String string3 = string2;
                                Object object = StringCompanionObject.INSTANCE;
                                String string4 = MessagesKt.get(DeviceFirmware.Companion.getMessages(), "downgrageText");
                                Intrinsics.checkExpressionValueIsNotNull(string4, "messages[\"downgrageText\"]");
                                String string5 = string4;
                                Object[] objectArray = new Object[]{StandardDeviceFirmwareKt.access$version(this.$appVersion), StandardDeviceFirmwareKt.access$version(this.this$0.getVersion())};
                                String string6 = String.format(string5, Arrays.copyOf(objectArray, objectArray.length));
                                Intrinsics.checkExpressionValueIsNotNull(string6, "java.lang.String.format(format, *args)");
                                object = string6;
                                ButtonType[] buttonTypeArray = new ButtonType[2];
                                buttonTypeArray[0] = new ButtonType(MessagesKt.get(DeviceFirmware.Companion.getMessages(), "doDowngrade"), ButtonBar.ButtonData.APPLY);
                                ButtonType buttonType = ButtonType.CANCEL;
                                Intrinsics.checkExpressionValueIsNotNull(buttonType, "ButtonType.CANCEL");
                                buttonTypeArray[1] = buttonType;
                                ButtonType[] buttons$iv = buttonTypeArray;
                                Window owner$iv = null;
                                String title$iv = null;
                                Alert.AlertType alertType = Alert.AlertType.WARNING;
                                ButtonType[] buttons$iv$iv = Arrays.copyOf(buttons$iv, buttons$iv.length);
                                String string7 = content$iv;
                                if (string7 == null) {
                                    string7 = "";
                                }
                                Alert alert$iv$iv = new Alert((Alert.AlertType)type$iv$iv, string7, Arrays.copyOf(buttons$iv$iv, buttons$iv$iv.length));
                                alert$iv$iv.setHeaderText((String)header$iv);
                                Optional optional = buttonClicked$iv$iv = alert$iv$iv.showAndWait();
                                Intrinsics.checkExpressionValueIsNotNull(optional, "buttonClicked");
                                if (optional.isPresent()) {
                                    T t = buttonClicked$iv$iv.get();
                                    Intrinsics.checkExpressionValueIsNotNull(t, "buttonClicked.get()");
                                    ButtonType buttonType2 = (ButtonType)t;
                                    Alert $receiver = alert$iv$iv;
                                    ButtonType buttonType3 = (ButtonType)$receiver.getResult();
                                    Intrinsics.checkExpressionValueIsNotNull(buttonType3, "result");
                                    this.$doUpdate.element = buttonType3.getButtonData() == ButtonBar.ButtonData.APPLY;
                                }
                            } else {
                                Optional buttonClicked$iv$iv;
                                void type$iv$iv;
                                String string8 = MessagesKt.get(DeviceFirmware.Companion.getMessages(), "currentVersion");
                                Intrinsics.checkExpressionValueIsNotNull(string8, "messages[\"currentVersion\"]");
                                String header$iv = string8;
                                Object content$iv = StringCompanionObject.INSTANCE;
                                String string9 = MessagesKt.get(DeviceFirmware.Companion.getMessages(), "versionInfo");
                                Intrinsics.checkExpressionValueIsNotNull(string9, "messages[\"versionInfo\"]");
                                String buttons$iv = string9;
                                Object[] owner$iv = new Object[]{this.this$0.getDeviceType(), StandardDeviceFirmwareKt.access$version(this.$appVersion), StandardDeviceFirmwareKt.access$version(this.$bootVersion), StandardDeviceFirmwareKt.access$version(this.this$0.getVersion())};
                                String string10 = String.format(buttons$iv, Arrays.copyOf(owner$iv, owner$iv.length));
                                Intrinsics.checkExpressionValueIsNotNull(string10, "java.lang.String.format(format, *args)");
                                content$iv = string10;
                                ButtonType buttonType = ButtonType.OK;
                                Intrinsics.checkExpressionValueIsNotNull(buttonType, "ButtonType.OK");
                                ButtonType confirmButton$iv = buttonType;
                                ButtonType buttonType4 = ButtonType.CANCEL;
                                Intrinsics.checkExpressionValueIsNotNull(buttonType4, "ButtonType.CANCEL");
                                ButtonType cancelButton$iv = buttonType4;
                                Window owner$iv2 = null;
                                String title$iv = null;
                                Alert.AlertType buttons$iv$iv = Alert.AlertType.CONFIRMATION;
                                ButtonType[] buttons$iv$iv2 = new ButtonType[]{confirmButton$iv, cancelButton$iv};
                                Alert alert$iv$iv = new Alert((Alert.AlertType)type$iv$iv, (String)content$iv, Arrays.copyOf(buttons$iv$iv2, buttons$iv$iv2.length));
                                alert$iv$iv.setHeaderText(header$iv);
                                Optional optional = buttonClicked$iv$iv = alert$iv$iv.showAndWait();
                                Intrinsics.checkExpressionValueIsNotNull(optional, "buttonClicked");
                                if (optional.isPresent()) {
                                    void it$iv;
                                    T t = buttonClicked$iv$iv.get();
                                    Intrinsics.checkExpressionValueIsNotNull(t, "buttonClicked.get()");
                                    ButtonType $receiver = (ButtonType)t;
                                    Alert $receiver$iv = alert$iv$iv;
                                    if (Intrinsics.areEqual(it$iv, confirmButton$iv)) {
                                        this.$doUpdate.element = true;
                                    }
                                }
                            }
                            this.$latch.countDown();
                        }
                    });
                    latch.await();
                    if (doUpdate.element) {
                        int packetCount = ((Object[])this.getPackets()).length;
                        Object[] $receiver$iv = (Object[])this.getPackets();
                        int index$iv = 0;
                        block11: for (Object item$iv : $receiver$iv) {
                            int n3 = index$iv++;
                            byte[] byArray = (byte[])item$iv;
                            int index = n3;
                            int retries = 0;
                            while (true) {
                                try {
                                    void data2;
                                    Object object2;
                                    Callback callback5 = callback;
                                    if (callback5 != null) {
                                        callback5.updateProgress(index + 1, packetCount);
                                    }
                                    if (callback != null) {
                                        String string9;
                                        Callback callback6;
                                        StringCompanionObject stringCompanionObject = StringCompanionObject.INSTANCE;
                                        String string10 = MessagesKt.get(DeviceFirmware.Companion.getMessages(), "writePacket");
                                        Intrinsics.checkExpressionValueIsNotNull(string10, "messages[\"writePacket\"]");
                                        object2 = string10;
                                        Object[] objectArray = new Object[]{index + 1, packetCount};
                                        Intrinsics.checkExpressionValueIsNotNull(String.format((String)object2, Arrays.copyOf(objectArray, objectArray.length)), "java.lang.String.format(format, *args)");
                                        callback6.updateMessage(string9);
                                    }
                                    Callback callback7 = callback;
                                    if (callback7 != null) {
                                        if (callback7.isCancelled()) {
                                            String string11 = MessagesKt.get(DeviceFirmware.Companion.getMessages(), "cancelled");
                                            Intrinsics.checkExpressionValueIsNotNull(string11, "messages[\"cancelled\"]");
                                            callback.updateMessage(string11);
                                            break block30;
                                        }
                                    }
                                    byte[] response = new byte[((void)data2).length];
                                    SerialPort.DefaultImpls.writeBytes$default(it, (byte[])data2, 0L, 0L, 6, null);
                                    SerialPort.DefaultImpls.readBytes$default(it, response, 0L, 0L, 6, null);
                                    object2 = response;
                                    if (!Arrays.equals((byte[])object2, (byte[])data2)) {
                                        throw (Throwable)new IOException(MessagesKt.get(DeviceFirmware.Companion.getMessages(), "transmissionError"));
                                    }
                                    it.expect(1);
                                    continue block11;
                                }
                                catch (IOException e) {
                                    if (retries++ < 5) continue;
                                    throw (Throwable)e;
                                }
                                break;
                            }
                        }
                        it.write(8);
                        it.expect(8);
                        Callback callback8 = callback;
                        if (callback8 != null) {
                            String string12 = MessagesKt.get(DeviceFirmware.Companion.getMessages(), "done");
                            Intrinsics.checkExpressionValueIsNotNull(string12, "messages[\"done\"]");
                            callback8.updateMessage(string12);
                        }
                        break block30;
                    }
                    Callback callback9 = callback;
                    if (callback9 != null) {
                        String string13 = MessagesKt.get(DeviceFirmware.Companion.getMessages(), "cancelled");
                        Intrinsics.checkExpressionValueIsNotNull(string13, "messages[\"cancelled\"]");
                        callback9.updateMessage(string13);
                    }
                    Callback callback10 = callback;
                    if (callback10 != null) {
                        callback10.cancel();
                    }
                }
                catch (IOException e) {
                    Callback callback11 = callback;
                    if (callback11 != null) {
                        String string14 = MessagesKt.get(DeviceFirmware.Companion.getMessages(), "transmissionError");
                        Intrinsics.checkExpressionValueIsNotNull(string14, "messages[\"transmissionError\"]");
                        callback11.updateMessage(string14);
                    }
                    throw (Throwable)e;
                }
            }
            Unit unit = Unit.INSTANCE;
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            CloseableKt.closeFinally(closeable, throwable);
        }
    }

    public boolean equals(@Nullable Object other) {
        Object[] objectArray;
        if (this == other) {
            return true;
        }
        Object object = other;
        if (Intrinsics.areEqual(this.getClass(), object != null ? object.getClass() : null) ^ true) {
            return false;
        }
        Object object2 = other;
        if (object2 == null) {
            throw new TypeCastException("null cannot be cast to non-null type de.treichels.hott.decoder.internal.firmware.StandardDeviceFirmware");
        }
        StandardDeviceFirmware cfr_ignored_0 = (StandardDeviceFirmware)object2;
        if (Intrinsics.areEqual(this.getDeviceType(), ((StandardDeviceFirmware)other).getDeviceType()) ^ true) {
            return false;
        }
        if (this.version != ((StandardDeviceFirmware)other).version) {
            return false;
        }
        Object[] objectArray2 = (Object[])this.getPackets();
        return ArraysKt.contentDeepEquals(objectArray2, objectArray = (Object[])((StandardDeviceFirmware)other).getPackets());
    }

    public int hashCode() {
        int result2 = this.getDeviceType().hashCode();
        result2 = 31 * result2 + this.version;
        Object[] objectArray = (Object[])this.getPackets();
        int n = 31 * result2;
        int n2 = ArraysKt.contentDeepHashCode(objectArray);
        result2 = n + n2;
        return result2;
    }

    @NotNull
    public String toString() {
        return "StandardDeviceFirmware(" + this.getDeviceType() + ", v" + (double)this.version / 1000.0 + ", productCode=" + this.getDeviceType().getProductCode() + ", deviceID=" + this.deviceId + ", processId=" + this.processId + ')';
    }

    public final int getVersion() {
        return this.version;
    }

    public final int getDeviceId() {
        return this.deviceId;
    }

    public final int getProcessId() {
        return this.processId;
    }

    public StandardDeviceFirmware(@NotNull Registered<?> deviceType, int version, int deviceId, int processId, @NotNull byte[][] packets) {
        Intrinsics.checkParameterIsNotNull(deviceType, "deviceType");
        Intrinsics.checkParameterIsNotNull(packets, "packets");
        super(deviceType, packets);
        this.version = version;
        this.deviceId = deviceId;
        this.processId = processId;
    }

    static {
        Companion = new Companion(null);
        devicesNeedButtonBoot = CollectionsKt.listOf(ReceiverType.gr12, ReceiverType.gr12s, ReceiverType.gr16, ReceiverType.gr24, ReceiverType.gr32);
    }

    @Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u001a\u0010\b\u001a\u000e\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\n0\t2\u0006\u0010\u000b\u001a\u00020\fJ \u0010\r\u001a\u0014\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\n0\u000e2\u0006\u0010\u000b\u001a\u00020\fJ\u000e\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012J\u0016\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fR\u001b\u0010\u0003\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00050\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\u0016"}, d2={"Lde/treichels/hott/decoder/internal/firmware/StandardDeviceFirmware$Companion;", "", "()V", "devicesNeedButtonBoot", "", "Lde/treichels/hott/model/enums/Registered;", "getDevicesNeedButtonBoot", "()Ljava/util/List;", "getDeviceId", "Lkotlin/Pair;", "", "port", "Lde/treichels/hott/serial/SerialPort;", "getInfo", "Lkotlin/Triple;", "load", "Lde/treichels/hott/decoder/internal/firmware/StandardDeviceFirmware;", "file", "Ljava/io/File;", "updateMode", "", "rc", "HoTT-Decoder"})
    public static final class Companion {
        @NotNull
        public final List<Registered<?>> getDevicesNeedButtonBoot() {
            return devicesNeedButtonBoot;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * WARNING - void declaration
         */
        @NotNull
        public final StandardDeviceFirmware load(@NotNull File file) {
            Intrinsics.checkParameterIsNotNull(file, "file");
            Object object = file;
            object = new FileInputStream((File)object);
            Throwable throwable = null;
            try {
                FileInputStream stream = (FileInputStream)object;
                int flag1 = StreamSupportKt.readUInt$default(stream, null, 1, null);
                if (flag1 != 591751049 && flag1 != 305419896) {
                    throw (Throwable)new IOException(MessagesKt.get(DeviceFirmware.Companion.getMessages(), "invalidFileHeader"));
                }
                int n = -1;
                int flag2 = StreamSupportKt.readUInt$default(stream, null, 1, null);
                if (UInt.constructor-impl(n - flag2) != flag1) {
                    throw (Throwable)new IOException(MessagesKt.get(DeviceFirmware.Companion.getMessages(), "invalidFileHeader"));
                }
                int deviceId = StreamSupportKt.readInt$default(stream, null, 1, null) & 0xFF;
                int processId = deviceId == 4104 ? StreamSupportKt.readInt$default(stream, null, 1, null) & 0xFF : StreamSupportKt.readInt$default(stream, null, 1, null) >> 4 & 0xF;
                int productCode = StreamSupportKt.readInt$default(stream, null, 1, null);
                Registered<?> registered = DeviceFirmware.Companion.forProductCode$HoTT_Decoder(DeviceFirmwareKt.getDeviceList(), productCode);
                if (registered == null) {
                    String string2;
                    StringCompanionObject stringCompanionObject = StringCompanionObject.INSTANCE;
                    String string3 = MessagesKt.get(DeviceFirmware.Companion.getMessages(), "unknownDevice");
                    Intrinsics.checkExpressionValueIsNotNull(string3, "messages[\"unknownDevice\"]");
                    String string4 = string3;
                    Object[] objectArray = new Object[]{productCode};
                    String string5 = String.format(string4, Arrays.copyOf(objectArray, objectArray.length));
                    Intrinsics.checkExpressionValueIsNotNull(string5, "java.lang.String.format(format, *args)");
                    String string6 = string2 = string5;
                    throw (Throwable)new IOException(string6);
                }
                Registered<?> deviceType = registered;
                int version = StreamSupportKt.readInt$default(stream, null, 1, null);
                int packetCount = StreamSupportKt.readInt$default(stream, null, 1, null);
                stream.skip(36L);
                byte[][] result$iv = new byte[packetCount][];
                int n2 = 0;
                int n3 = result$iv.length;
                while (n2 < n3) {
                    void i$iv;
                    void var20_27 = i$iv;
                    void var13_25 = i$iv++;
                    byte[][] byArrayArray = result$iv;
                    int flag = stream.read();
                    if (flag != 0) {
                        throw (Throwable)new IOException(MessagesKt.get(DeviceFirmware.Companion.getMessages(), "invalidBlock"));
                    }
                    int seq1 = StreamSupportKt.readUShort$default(stream, null, 1, null);
                    int seq2 = StreamSupportKt.readUShort$default(stream, null, 1, null);
                    int n4 = seq1;
                    int n5 = UInt.constructor-impl(n4 & 0xFFFF);
                    n4 = 65535;
                    int n6 = n5;
                    int n7 = n4;
                    int n8 = seq2;
                    int n9 = UInt.constructor-impl(n7 - (n8 = UInt.constructor-impl(n8 & 0xFFFF)));
                    if (n6 != n9) {
                        throw (Throwable)new IOException(MessagesKt.get(DeviceFirmware.Companion.getMessages(), "invalidBlock"));
                    }
                    short size = StreamSupportKt.readUShort$default(stream, null, 1, null);
                    stream.skip(9L);
                    n8 = size;
                    byte[] data2 = new byte[n8 & 0xFFFF];
                    stream.read(data2);
                    byte[] byArray = data2;
                    byArrayArray[var13_25] = byArray;
                }
                byte[][] packets = result$iv;
                StandardDeviceFirmware standardDeviceFirmware = new StandardDeviceFirmware(deviceType, version, deviceId, processId, packets);
                return standardDeviceFirmware;
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                CloseableKt.closeFinally((Closeable)object, throwable);
            }
        }

        public final void updateMode(int rc, @NotNull SerialPort port) {
            Intrinsics.checkParameterIsNotNull(port, "port");
            int expected = rc == 5 ? 9 : rc;
            port.write(expected);
            port.expect(expected);
        }

        @NotNull
        public final Pair<Integer, Integer> getDeviceId(@NotNull SerialPort port) {
            Intrinsics.checkParameterIsNotNull(port, "port");
            port.write(9);
            port.expect(9);
            int deviceId = SerialPort.DefaultImpls.readInt$default(port, null, 1, null) & 0xFF;
            int processId = SerialPort.DefaultImpls.readInt$default(port, null, 1, null) >>> 12;
            return new Pair<Integer, Integer>(deviceId, processId);
        }

        @NotNull
        public final Triple<Integer, Integer, Integer> getInfo(@NotNull SerialPort port) {
            Intrinsics.checkParameterIsNotNull(port, "port");
            port.write(16);
            port.expect(16);
            int productCode = SerialPort.DefaultImpls.readInt$default(port, null, 1, null);
            int appVersion = SerialPort.DefaultImpls.readInt$default(port, null, 1, null);
            int bootVersion = SerialPort.DefaultImpls.readInt$default(port, null, 1, null);
            return new Triple<Integer, Integer, Integer>(productCode, appVersion, bootVersion);
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

