/*
 * Decompiled with CFR 0.152.
 */
package de.treichels.hott.decoder.internal.firmware;

import de.treichels.hott.decoder.internal.firmware.Hex;
import de.treichels.hott.util.ByteOrder;
import de.treichels.hott.util.StreamSupportKt;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.UByte;
import kotlin.UByteArray;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.IntRange;
import kotlin.ranges.RangesKt;
import kotlin.text.CharsKt;
import kotlin.text.StringsKt;
import kotlin.text.UStringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u0012\n\u0002\b\b\n\u0002\u0010\u000e\n\u0002\b\u0003\u0018\u0000 \u00122\u00020\u0001:\u0001\u0012B%\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0003\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\b\u0010\u000f\u001a\u00020\u0010H\u0002J\b\u0010\u0011\u001a\u00020\u0010H\u0016R\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0011\u0010\u0005\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\nR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\n\u00a8\u0006\u0013"}, d2={"Lde/treichels/hott/decoder/internal/firmware/Hex;", "", "size", "", "address", "recordType", "data", "", "(III[B)V", "getAddress", "()I", "getData", "()[B", "getRecordType", "getSize", "dumpData", "", "toString", "Companion", "HoTT-Decoder"})
public final class Hex {
    private final int size;
    private final int address;
    private final int recordType;
    @NotNull
    private final byte[] data;
    public static final Companion Companion = new Companion(null);

    /*
     * WARNING - void declaration
     */
    private final String dumpData() {
        void var3_3;
        void $receiver$iv$iv;
        byte[] $receiver$iv;
        byte[] byArray = $receiver$iv = this.data;
        Collection destination$iv$iv = new ArrayList($receiver$iv.length);
        void var4_4 = $receiver$iv$iv;
        int n = ((void)var4_4).length;
        for (int j = 0; j < n; ++j) {
            String string2;
            void it;
            void item$iv$iv;
            void var8_8 = item$iv$iv = var4_4[j];
            Collection collection = destination$iv$iv;
            int n2 = it & 0xFF;
            int n3 = 16;
            Intrinsics.checkExpressionValueIsNotNull(Integer.toString(n2, CharsKt.checkRadix(n3)), "java.lang.Integer.toStri\u2026(this, checkRadix(radix))");
            collection.add(string2);
        }
        return CollectionsKt.joinToString$default((List)var3_3, " ", null, null, 0, null, dumpData.2.INSTANCE, 30, null);
    }

    @NotNull
    public String toString() {
        int n = this.address;
        int n2 = 16;
        StringBuilder stringBuilder = new StringBuilder().append("Hex(size=").append(this.size).append(", address=0x");
        String string2 = Integer.toString(n, CharsKt.checkRadix(n2));
        Intrinsics.checkExpressionValueIsNotNull(string2, "java.lang.Integer.toStri\u2026(this, checkRadix(radix))");
        String string3 = string2;
        return stringBuilder.append(string3).append(", recordType=").append(this.recordType).append(", data=").append(this.dumpData()).append("})").toString();
    }

    public final int getSize() {
        return this.size;
    }

    public final int getAddress() {
        return this.address;
    }

    public final int getRecordType() {
        return this.recordType;
    }

    @NotNull
    public final byte[] getData() {
        return this.data;
    }

    public Hex(int size, int address, int recordType, @NotNull byte[] data2) {
        Intrinsics.checkParameterIsNotNull(data2, "data");
        this.size = size;
        this.address = address;
        this.recordType = recordType;
        this.data = data2;
    }

    @Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0015\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0000\u00a2\u0006\u0002\b\u0007\u00a8\u0006\b"}, d2={"Lde/treichels/hott/decoder/internal/firmware/Hex$Companion;", "", "()V", "parseLine", "Lde/treichels/hott/decoder/internal/firmware/Hex;", "line", "", "parseLine$HoTT_Decoder", "HoTT-Decoder"})
    public static final class Companion {
        /*
         * WARNING - void declaration
         */
        @NotNull
        public final Hex parseLine$HoTT_Decoder(@NotNull String line2) {
            int n;
            void $receiver$iv;
            byte by;
            int it22;
            int n2;
            Intrinsics.checkParameterIsNotNull(line2, "line");
            if (!StringsKt.startsWith$default(line2, ":", false, 2, null)) {
                throw (Throwable)new IOException("line does not start with \":\"");
            }
            int dataSize = (line2.length() - 1) / 2;
            byte[] byArray = new byte[dataSize];
            int n3 = 0;
            int n4 = byArray.length;
            while (n3 < n4) {
                n2 = n3;
                int n5 = n3++;
                byte[] byArray2 = byArray;
                it22 = n2;
                int n6 = it22 * 2 + 1;
                String s = StringsKt.substring(line2, new IntRange(n6, it22 * 2 + 2));
                by = UStringsKt.toUByte(s, 16);
                byArray2[n5] = it22 = (int)by;
            }
            byte[] values2 = UByteArray.constructor-impl(byArray);
            n3 = UByteArray.get-impl(values2, 0);
            int size = n3 & 0xFF;
            n4 = StreamSupportKt.readUShort-0LuJA-Q(values2, 1, ByteOrder.BigEndian);
            int address = n4 & 0xFFFF;
            n2 = UByteArray.get-impl(values2, 3);
            int recordType = n2 & 0xFF;
            byte[] byArray3 = values2;
            byte[] data2 = ArraysKt.sliceArray(byArray3, RangesKt.until(4, 4 + size));
            byte checksum = CollectionsKt.last(UByteArray.box-impl(values2)).unbox-impl();
            it22 = checksum;
            UByteArray it22 = UByteArray.box-impl(values2);
            int n7 = it22 & 0xFF;
            int sum$iv = 0;
            for (Object element$iv : $receiver$iv) {
                void it;
                by = ((UByte)element$iv).unbox-impl();
                n = sum$iv;
                void var15_23 = it;
                int n8 = var15_23 & 0xFF;
                sum$iv = n + n8;
            }
            n = sum$iv;
            int n9 = n7 - n;
            byte calculated = UByte.constructor-impl((byte)n9);
            if (checksum != calculated) {
                throw (Throwable)new IOException("checksum mismatch " + UByte.box-impl(checksum) + " != " + UByte.box-impl(calculated));
            }
            return new Hex(size, address, recordType, data2);
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

