/*
 * Decompiled with CFR 0.152.
 */
package gde.ui.tab;

import gde.Analyzer;
import gde.GDE;
import gde.config.Settings;
import gde.data.Channel;
import gde.data.Channels;
import gde.data.Record;
import gde.data.RecordSet;
import gde.device.DataTypes;
import gde.device.IDevice;
import gde.device.MeasurementType;
import gde.device.SettlementType;
import gde.device.TransitionGroupType;
import gde.device.resource.DeviceXmlResource;
import gde.histo.transitions.TransitionTableMapper;
import gde.messages.Messages;
import gde.ui.DataExplorer;
import gde.ui.SWTResourceManager;
import gde.ui.menu.TabAreaContextMenu;
import gde.utils.StringHelper;
import java.util.HashMap;
import java.util.Map;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.eclipse.swt.SWT;
import org.eclipse.swt.custom.CTabFolder;
import org.eclipse.swt.custom.CTabItem;
import org.eclipse.swt.custom.TableCursor;
import org.eclipse.swt.custom.TableEditor;
import org.eclipse.swt.dnd.Clipboard;
import org.eclipse.swt.dnd.TextTransfer;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.HelpEvent;
import org.eclipse.swt.events.HelpListener;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.events.VerifyEvent;
import org.eclipse.swt.events.VerifyListener;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Decorations;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Widget;

public class DataTableWindow
extends CTabItem {
    static final Logger log = Logger.getLogger(DataTableWindow.class.getName());
    public static final String TABLE_TIME_STAMP_ABSOLUTE = "table_time_stamp_absolute";
    Table dataTable;
    TableColumn timeColumn;
    TableCursor cursor;
    Vector<Integer> rowVector = new Vector(2);
    Vector<Integer> topindexVector = new Vector(2);
    final DataExplorer application;
    final Channels channels;
    final Settings settings;
    final DeviceXmlResource xmlResource = DeviceXmlResource.getInstance();
    final CTabFolder tabFolder;
    final Menu popupmenu;
    final TabAreaContextMenu contextMenu;
    boolean isAbsoluteDateTime = false;

    public DataTableWindow(CTabFolder dataTab, int style, int position) {
        super(dataTab, style, position);
        SWTResourceManager.registerResourceUser((Widget)this);
        this.tabFolder = dataTab;
        this.application = DataExplorer.getInstance();
        this.channels = Channels.getInstance();
        this.settings = Settings.getInstance();
        this.setFont(SWTResourceManager.getFont((Control)this.application, GDE.WIDGET_FONT_SIZE + (GDE.IS_LINUX ? 3 : 1), 0));
        this.setText(Messages.getString("GDE_MSGT0233"));
        this.popupmenu = new Menu((Decorations)this.application.getShell(), 8);
        this.contextMenu = new TabAreaContextMenu();
    }

    public void create() {
        this.isAbsoluteDateTime = Settings.getInstance().isTimeFormatAbsolute();
        this.dataTable = new Table((Composite)this.tabFolder, 268503042);
        this.setControl((Control)this.dataTable);
        this.dataTable.setLinesVisible(true);
        this.dataTable.setHeaderVisible(true);
        final TableEditor editor = new TableEditor(this.dataTable);
        editor.horizontalAlignment = 16384;
        editor.grabHorizontal = true;
        this.cursor = new TableCursor(this.dataTable, 0);
        this.cursor.addKeyListener(new KeyListener(){

            public void keyReleased(KeyEvent event) {
                if (log.isLoggable(Level.FINEST)) {
                    log.log(Level.FINEST, "cursor.keyReleased, keycode: " + event.keyCode);
                }
                if (DataTableWindow.this.settings.isDataTableEditable()) {
                    TableItem item;
                    Control oldEditor = editor.getEditor();
                    if (oldEditor != null) {
                        oldEditor.dispose();
                    }
                    if ((item = DataTableWindow.this.cursor.getRow()) == null) {
                        return;
                    }
                    final String origText = item.getText(DataTableWindow.this.cursor.getColumn());
                    final Text text = new Text((Composite)DataTableWindow.this.dataTable, 0);
                    text.setText(String.valueOf(event.character));
                    final TableItem row = DataTableWindow.this.cursor.getRow();
                    final int column = DataTableWindow.this.cursor.getColumn();
                    text.addModifyListener(new ModifyListener(){

                        public void modifyText(ModifyEvent me) {
                            Text modifyText = (Text)editor.getEditor();
                            editor.getItem().setText(DataTableWindow.this.cursor.getColumn(), modifyText.getText());
                        }
                    });
                    text.addVerifyListener(new VerifyListener(){

                        public void verifyText(VerifyEvent ve) {
                            ve.doit = StringHelper.verifyTypedInput(DataTypes.DOUBLE, text.getText());
                        }
                    });
                    text.addFocusListener(new FocusListener(){

                        public void focusLost(FocusEvent fe) {
                            DataTableWindow.this.settings.setDataTableEditable(false);
                            if (!DataTableWindow.this.setEditedRecordPoint(row, column)) {
                                DataTableWindow.this.cursor.getRow().setText(column, origText);
                            }
                            text.dispose();
                        }

                        public void focusGained(FocusEvent arg0) {
                        }
                    });
                    text.addKeyListener(new KeyListener(){

                        public void keyReleased(KeyEvent ke) {
                        }

                        public void keyPressed(KeyEvent ke) {
                            if (ke.character == '\r') {
                                row.setText(column, ((Text)editor.getEditor()).getText());
                                DataTableWindow.this.settings.setDataTableEditable(false);
                                if (!DataTableWindow.this.setEditedRecordPoint(row, column)) {
                                    DataTableWindow.this.cursor.getRow().setText(column, origText);
                                }
                                text.dispose();
                            } else if (ke.character == '\u001b') {
                                DataTableWindow.this.cursor.getRow().setText(column, origText);
                                text.dispose();
                                DataTableWindow.this.settings.setDataTableEditable(false);
                            }
                        }
                    });
                    text.selectAll();
                    text.setFocus();
                    editor.setEditor((Control)text, item, DataTableWindow.this.cursor.getColumn());
                }
                if (event.stateMask == SWT.MOD1) {
                    switch (event.keyCode) {
                        case 0x1000007: {
                            DataTableWindow.this.cursor.setSelection(0, 0);
                            break;
                        }
                        case 0x1000008: {
                            DataTableWindow.this.cursor.setSelection(DataTableWindow.this.dataTable.getItemCount() - 1, DataTableWindow.this.dataTable.getColumnCount() - 1);
                            break;
                        }
                        case 99: {
                            DataTableWindow.this.dataTable.getSelectionCount();
                            DataTableWindow.this.dataTable.getSelectionIndices();
                            StringBuilder sb = new StringBuilder();
                            int columns = DataTableWindow.this.dataTable.getColumnCount();
                            for (int i = 0; i < columns; ++i) {
                                sb.append(DataTableWindow.this.dataTable.getColumn(i).getText().trim()).append('\t');
                            }
                            sb.deleteCharAt(sb.length() - 1).append('\n');
                            for (TableItem tmpItem : DataTableWindow.this.dataTable.getSelection()) {
                                for (int i = 0; i < columns; ++i) {
                                    sb.append(tmpItem.getText(i).trim()).append('\t');
                                }
                                sb.deleteCharAt(sb.length() - 1).append('\n');
                            }
                            Clipboard cb = new Clipboard(GDE.display);
                            String textData = sb.toString();
                            TextTransfer textTransfer = TextTransfer.getInstance();
                            cb.setContents(new Object[]{textData}, new Transfer[]{textTransfer});
                        }
                    }
                } else if ((event.stateMask & SWT.MOD2) != 0 && (event.stateMask & SWT.MOD1) != 0) {
                    switch (event.keyCode) {
                        case 0x1000007: {
                            DataTableWindow.this.cursor.setSelection(0, DataTableWindow.this.cursor.getColumn());
                            break;
                        }
                        case 0x1000008: {
                            DataTableWindow.this.cursor.setSelection(DataTableWindow.this.dataTable.getItemCount() - 1, DataTableWindow.this.cursor.getColumn());
                        }
                    }
                } else if (event.stateMask == 0) {
                    switch (event.keyCode) {
                        case 0x1000007: {
                            this.workaroundTableCursor(0);
                            break;
                        }
                        case 0x1000008: {
                            this.workaroundTableCursor(DataTableWindow.this.dataTable.getColumnCount() - 1);
                        }
                    }
                }
                if (DataTableWindow.this.cursor.getRow() != null && ((event.stateMask & SWT.MOD1) == 0 && event.character != 'c' || (event.stateMask & SWT.MOD1) == 0 && event.character != 'a')) {
                    DataTableWindow.this.updateVector(DataTableWindow.this.dataTable.indexOf(DataTableWindow.this.cursor.getRow()), DataTableWindow.this.dataTable.getTopIndex());
                    DataTableWindow.this.dataTable.setSelection(new TableItem[]{DataTableWindow.this.cursor.getRow()});
                }
            }

            private void workaroundTableCursor(int col) {
                int row = DataTableWindow.this.rowVector.get(0);
                if (log.isLoggable(Level.FINER)) {
                    log.log(Level.FINER, "Setting selection to row: " + row);
                }
                DataTableWindow.this.cursor.setSelection(row, col);
                if (log.isLoggable(Level.FINER)) {
                    log.log(Level.FINER, "Setting top index: " + String.valueOf(DataTableWindow.this.topindexVector.get(0)));
                }
                DataTableWindow.this.dataTable.setTopIndex(DataTableWindow.this.topindexVector.get(0).intValue());
                DataTableWindow.this.cursor.setVisible(true);
            }

            public void keyPressed(KeyEvent event) {
                if (log.isLoggable(Level.FINEST)) {
                    log.log(Level.FINEST, "cursor.keyPressed " + String.valueOf(event));
                }
                if (!(DataTableWindow.this.cursor.getRow() == null || event.stateMask == SWT.MOD1 && event.keyCode != 153 || event.stateMask == SWT.MOD1 && event.keyCode != 151 || event.keyCode == SWT.MOD1)) {
                    DataTableWindow.this.dataTable.setSelection(new TableItem[]{DataTableWindow.this.cursor.getRow()});
                } else if (DataTableWindow.this.cursor.getRow() != null && (event.stateMask & SWT.MOD1) == SWT.MOD1 && event.keyCode == 97) {
                    DataTableWindow.this.dataTable.setSelection(DataTableWindow.this.dataTable.getItems());
                }
                if (event.keyCode == SWT.MOD2 && (event.stateMask & SWT.MOD2) == 0 && (event.stateMask & SWT.MOD1) == 0 && (event.stateMask & SWT.MOD3) == 0) {
                    DataTableWindow.this.cursor.setVisible(false);
                    if (DataTableWindow.this.cursor.getRow() != null) {
                        DataTableWindow.this.dataTable.setSelection(new TableItem[]{DataTableWindow.this.cursor.getRow()});
                    }
                }
            }
        });
        this.cursor.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                if (log.isLoggable(Level.FINEST)) {
                    log.log(Level.FINEST, "cursor.widgetSelected " + String.valueOf(event));
                }
                if (DataTableWindow.this.cursor.getRow() != null) {
                    DataTableWindow.this.updateVector(DataTableWindow.this.dataTable.indexOf(DataTableWindow.this.cursor.getRow()), DataTableWindow.this.dataTable.getTopIndex());
                }
            }
        });
        this.dataTable.setFont(SWTResourceManager.getFont(GDE.WIDGET_FONT_NAME, GDE.WIDGET_FONT_SIZE, 0));
        this.dataTable.addHelpListener(new HelpListener(){

            public void helpRequested(HelpEvent evt) {
                if (log.isLoggable(Level.FINER)) {
                    log.log(Level.FINER, "dataTable.helpRequested " + String.valueOf(evt));
                }
                DataExplorer.getInstance().openHelpDialog("", "HelpInfo_6.html");
            }
        });
        this.dataTable.addListener(36, new Listener(){

            public void handleEvent(Event event) {
                RecordSet activeRecordSet;
                Channel activeChannel = DataTableWindow.this.channels.getActiveChannel();
                if (activeChannel != null && (activeRecordSet = activeChannel.getActiveRecordSet()) != null && activeRecordSet.getRecordDataSize(false) > 0) {
                    TableItem item = (TableItem)event.item;
                    int index = DataTableWindow.this.dataTable.indexOf(item);
                    item.setText(activeRecordSet.getDataTableRow(index, DataTableWindow.this.isAbsoluteDateTime));
                }
            }
        });
        this.dataTable.addKeyListener(new KeyListener(){
            int selectionFlowIndex = 0;

            private void workaroundTableCursor(int col) {
                int row = DataTableWindow.this.rowVector.get(DataTableWindow.this.rowVector.size() - 1);
                if (log.isLoggable(Level.FINER)) {
                    log.log(Level.FINER, "Setting selection to row: " + row);
                }
                DataTableWindow.this.cursor.setSelection(row, col);
                if (log.isLoggable(Level.FINER)) {
                    log.log(Level.FINER, "Setting top index: " + String.valueOf(DataTableWindow.this.topindexVector.get(0)));
                }
                DataTableWindow.this.dataTable.setTopIndex(DataTableWindow.this.topindexVector.get(DataTableWindow.this.topindexVector.size() - 1).intValue());
                DataTableWindow.this.cursor.setVisible(true);
                DataTableWindow.this.cursor.setFocus();
            }

            public void keyReleased(KeyEvent event) {
                if (log.isLoggable(Level.FINEST)) {
                    log.log(Level.FINEST, "dataTable.keyReleased, keycode: " + event.keyCode);
                }
                if (event.keyCode == SWT.MOD2 && DataTableWindow.this.rowVector.size() > 0) {
                    int rowIndex = DataTableWindow.this.rowVector.get(DataTableWindow.this.rowVector.size() - 1) + this.selectionFlowIndex;
                    rowIndex = rowIndex < 0 ? 0 : (rowIndex > DataTableWindow.this.dataTable.getItems().length - 1 ? DataTableWindow.this.dataTable.getItems().length - 1 : rowIndex);
                    DataTableWindow.this.updateVector(rowIndex, DataTableWindow.this.dataTable.getTopIndex());
                    this.workaroundTableCursor(DataTableWindow.this.cursor.getColumn());
                    this.selectionFlowIndex = 0;
                    switch (event.keyCode) {
                        default: 
                    }
                }
            }

            public void keyPressed(KeyEvent event) {
                if (log.isLoggable(Level.FINEST)) {
                    log.log(Level.FINEST, "dataTable.keyPressed, keycode: " + event.keyCode);
                }
                if (event.stateMask == SWT.MOD2 && (event.stateMask & SWT.MOD1) == 0 && (event.stateMask & SWT.MOD3) == 0) {
                    switch (event.keyCode) {
                        case 0x1000001: {
                            --this.selectionFlowIndex;
                            break;
                        }
                        case 0x1000002: {
                            ++this.selectionFlowIndex;
                        }
                    }
                }
            }
        });
        this.contextMenu.createMenu(this.popupmenu, TabAreaContextMenu.TabMenuType.TABLE);
        this.cursor.setMenu(this.popupmenu);
    }

    private void updateVector(int row, int topindex) {
        if (this.rowVector.size() == 2) {
            this.rowVector.remove(0);
            this.topindexVector.remove(0);
        }
        this.rowVector.addElement(row);
        this.topindexVector.addElement(topindex);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setHeader() {
        TableColumn[] columns;
        this.dataTable.removeAll();
        for (TableColumn tableColumn : columns = this.dataTable.getColumns()) {
            tableColumn.dispose();
        }
        int extentFactor = 9;
        String time = this.isAbsoluteDateTime ? Messages.getString("GDE_MSGT0436") : Messages.getString("GDE_MSGT0234");
        this.timeColumn = new TableColumn(this.dataTable, 0x1000000);
        this.timeColumn.setWidth(time.length() * 7);
        this.timeColumn.setText(time);
        Channel activeChannel = this.channels.getActiveChannel();
        if (activeChannel != null) {
            RecordSet activeRecordSet = activeChannel.getActiveRecordSet();
            if (activeRecordSet != null) {
                RecordSet recordSet = activeRecordSet;
                synchronized (recordSet) {
                    Object column;
                    StringBuilder sb;
                    if (this.settings.isPartialDataTable()) {
                        for (Record record : activeRecordSet.getVisibleAndDisplayableRecordsForTable()) {
                            sb = new StringBuilder();
                            sb.append(record.getName()).append(" [").append(record.getUnit()).append("]");
                            column = new TableColumn(this.dataTable, 0x1000000);
                            column.setWidth(sb.length() * extentFactor);
                            column.setText(sb.toString());
                        }
                    } else {
                        for (int i = 0; i < activeRecordSet.size(); ++i) {
                            Record record = activeRecordSet.get(i);
                            sb = new StringBuilder();
                            sb.append(record.getName()).append(" [").append(record.getUnit()).append("]");
                            column = new TableColumn(this.dataTable, 0x1000000);
                            column.setWidth(sb.length() * extentFactor);
                            column.setText(sb.toString());
                        }
                    }
                    if (this.settings.isHistoActive() && this.settings.isDataTableTransitions()) {
                        TransitionTableMapper mapper = new TransitionTableMapper(this.application.getActiveRecordSet(), Analyzer.getInstance());
                        for (SettlementType settlementType : mapper.defineActiveAndDisplayableSettlements().values()) {
                            column = new TableColumn(this.dataTable, 0x1000000);
                            String string = this.xmlResource.getReplacement(settlementType.getName());
                            StringBuilder sb2 = new StringBuilder();
                            sb2.append(string).append(" [").append(settlementType.getUnit()).append("]");
                            column.setWidth(sb2.length() > 11 ? 11 * extentFactor : sb2.length() * extentFactor);
                            column.setText(sb2.toString());
                        }
                        IDevice iDevice = this.application.getActiveDevice();
                        HashMap<Integer, TransitionGroupType> transitionGroups = iDevice.getDeviceConfiguration().getChannel(this.channels.getActiveChannelNumber()).getTransitionGroups();
                        for (Map.Entry entry : transitionGroups.entrySet()) {
                            TableColumn column2 = new TableColumn(this.dataTable, 0x1000000);
                            column2.setWidth(6 * extentFactor);
                            if (((TransitionGroupType)entry.getValue()).getComment() != null) {
                                column2.setText(String.format("TG%d: %-22s", entry.getKey(), ((TransitionGroupType)entry.getValue()).getComment()));
                                continue;
                            }
                            column2.setText(String.format("TG%d", entry.getKey()));
                        }
                    }
                }
            }
            IDevice device = this.application.getActiveDevice();
            for (int i = 0; i < device.getNumberOfMeasurements(activeChannel.getNumber()); ++i) {
                MeasurementType measurementType = device.getMeasurement(activeChannel.getNumber(), i);
                StringBuilder sb = new StringBuilder();
                sb.append(this.xmlResource.getReplacement(measurementType.getName().trim())).append(" ").append("[").append(measurementType.getUnit()).append("]");
                TableColumn column = new TableColumn(this.dataTable, 0x1000000);
                column.setWidth(sb.length() * extentFactor);
                column.setText(sb.toString());
            }
            if (System.getProperty("os.name", "").toLowerCase().startsWith("linux")) {
                TableColumn column = new TableColumn(this.dataTable, 0x1000000);
                column.setWidth(100);
            }
        }
    }

    public void setRowCount(int count) {
        this.dataTable.setItemCount(count);
    }

    public synchronized void cleanTable() {
        if (this.dataTable != null && !this.dataTable.isDisposed()) {
            this.dataTable.removeAll();
        }
    }

    public Image getContentAsImage() {
        Rectangle bounds = this.dataTable.getClientArea();
        Image tabContentImage = new Image((Device)GDE.display, bounds.width, bounds.height);
        GC imageGC = new GC((Drawable)tabContentImage);
        this.dataTable.print(imageGC);
        if (GDE.IS_MAC) {
            this.dataTable.print(imageGC);
        }
        imageGC.dispose();
        return tabContentImage;
    }

    public void updateTopIndex() {
        int newTopIndex;
        int height = this.dataTable.getClientArea().height;
        int visibleItemCount = height / this.dataTable.getItemHeight() - 1;
        int topIndex = this.dataTable.getTopIndex();
        int itemCount = this.dataTable.getItemCount();
        if (itemCount > visibleItemCount && topIndex != (newTopIndex = itemCount - visibleItemCount)) {
            this.dataTable.setTopIndex(newTopIndex);
        }
    }

    public void setAbsoluteDateTime(boolean isAbsoluteDateTime) {
        this.isAbsoluteDateTime = isAbsoluteDateTime;
    }

    private synchronized boolean setEditedRecordPoint(TableItem row, int column) {
        String recordName = this.dataTable.getColumn(column).getText();
        recordName = recordName.substring(0, recordName.lastIndexOf(32));
        Record editRecord = this.application.getActiveRecordSet().get(recordName);
        if (editRecord != null && StringHelper.verifyTypedInput(DataTypes.DOUBLE, row.getText(column))) {
            editRecord.set(this.dataTable.indexOf(this.cursor.getRow()), (int)(Double.valueOf(row.getText(column).replace(',', '.')) * 1000.0));
            return true;
        }
        return false;
    }
}

