/*
 * Decompiled with CFR 0.152.
 */
package gde.ui.dialog;

import gde.DataAccess;
import gde.GDE;
import gde.config.DeviceConfigurations;
import gde.config.Settings;
import gde.device.CommaSeparatorTypes;
import gde.device.DecimalSeparatorTypes;
import gde.histo.ui.HistoExplorer;
import gde.histo.ui.datasources.SupplementObjectFolder;
import gde.log.Level;
import gde.messages.Messages;
import gde.ui.DataExplorer;
import gde.ui.ParameterConfigControl;
import gde.ui.SWTResourceManager;
import gde.ui.menu.LogLevelSelectionContextMenu;
import gde.utils.ObjectKeyCompliance;
import gde.utils.ObjectKeyScanner;
import gde.utils.OperatingSystemHelper;
import gde.utils.StringHelper;
import java.io.File;
import java.nio.file.Paths;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.Set;
import java.util.Vector;
import java.util.logging.LogManager;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import org.eclipse.swt.custom.CCombo;
import org.eclipse.swt.custom.CLabel;
import org.eclipse.swt.custom.CTabFolder;
import org.eclipse.swt.custom.CTabItem;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.HelpEvent;
import org.eclipse.swt.events.HelpListener;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.events.VerifyEvent;
import org.eclipse.swt.events.VerifyListener;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.layout.RowData;
import org.eclipse.swt.layout.RowLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Decorations;
import org.eclipse.swt.widgets.Dialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Slider;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeItem;
import org.eclipse.swt.widgets.Widget;

public class SettingsDialog
extends Dialog {
    static final Logger log = Logger.getLogger(SettingsDialog.class.getName());
    static final String DEFAULT_LOG_LEVEL = "WARNING";
    public static final String LOGGER_NAME = "logger_name";
    public static final String LOG_LEVEL = "log_level";
    CCombo configLevelCombo;
    CLabel utilsLevelLabel;
    CCombo utilsLevelCombo;
    CLabel serialIOLevelLabel;
    CCombo serialIOLevelCombo;
    CLabel configLevelLabel;
    Button okButton;
    Button globalLogLevel;
    CLabel commonLevelLabel;
    CCombo commonLevelCombo;
    CLabel deviceLevelLabel;
    CCombo deviceLevelCombo;
    CCombo uiLevelCombo;
    CLabel uiLevelLabel;
    Composite individualLoggingComosite;
    Composite globalLoggingComposite;
    Shell dialogShell;
    CLabel defaultDataPathLabel;
    Group defaultDataPathGroup;
    CLabel localLabel;
    CLabel timeFormatLabel;
    CCombo localCombo;
    CCombo timeFormatCombo;
    Group groupLocale;
    Group groupTimeFormat;
    Button skipBluetoothDevices;
    Button doPortAvailabilityCheck;
    Button enableBlackListButton;
    Button enableWhiteListButton;
    Text serialPortBlackList;
    Text serialPortWhiteList;
    Button suggestObjectKey;
    Button writeTmpFiles;
    Composite generalTabComposite;
    Composite analysisComposite;
    CTabItem generalTabItem;
    CTabItem testTabItem;
    CTabItem histoTabItem;
    Button histoActive;
    Group histoScreening;
    Group histoDisplay;
    Button histoDisplaySettlements;
    Button histoDisplayScores;
    Button histoDisplayTags;
    Group histoBoxplot;
    CLabel histoBoxplotScaleLabel;
    CCombo histoBoxplotScale;
    CLabel histoBoxplotSizeAdaptationLabel;
    CCombo histoBoxplotSizeAdaptation;
    CLabel histoRetrospectLabel;
    Text histoRetrospectMonths;
    Button histoSearchDataPathImports;
    Button histoChannelMix;
    Group histoDisplayOption;
    Group histoXAxis;
    CLabel histoSpreadLabel;
    CCombo histoSpreadGrade;
    Button histoReversed;
    Button histoLogarithmicDistance;
    Group histoFileContents;
    CLabel histoMaxDurationLabel;
    Text histoMaxDuration;
    CLabel histoSamplingLabel;
    CCombo histoSamplingTimespan_ms;
    Group histoForceObject;
    Button histoIgnoreLogObjectKey;
    CCombo histoSubdirectoryLevel;
    CLabel histoSubdirectoryLevelLabel;
    Group timeZone;
    Button dateTimeUtcButton;
    Group fileOpenGroup;
    Button firstRecordSet;
    Button histoObjectQuery;
    CTabItem analysisTabItem;
    CTabFolder settingsTabFolder;
    Slider alphaSlider;
    Button suggestDate;
    Group fileOpenSaveDialogGroup;
    Group objectKeyGroup;
    Button scanObjectKeysButton;
    Button cleanObjectReferecesButton;
    Button removeMimeAssocButton;
    Button createObjectsFromDirectoriesButton;
    Button importLogsButton;
    Group histoToolsGroup;
    Button clearHistoCacheButton;
    Button clearSupplementFoldersButton;
    Group miscDiagGroup;
    Button resourceConsumptionButton;
    Button cleanSettingsButton;
    Button assocMimeTypeButton;
    Button removeLauncherButton;
    Button createLauncherButton;
    Button partialDataTableButton;
    Button blankChargeDischargeButton;
    Button continiousRecordSetButton;
    Button startCommunicationAfterStartupButton;
    Button drawScaleInRecordColorButton;
    Button drawNameInRecordColorButton;
    Button drawNumbersInRecordColorButton;
    Button useMeasurementPopUpButton;
    Button draw10TicksPerRecordButton;
    Button addChannelConfigNameCurveCompareButton;
    ParameterConfigControl fontSizeCorrectionSlider;
    ParameterConfigControl kmzExportTimeStepSlider;
    int[] fontCorrection = new int[1];
    int[] exportTimeStep_ms = new int[1];
    Composite osMiscComposite;
    Composite histoComposite;
    Composite miscComposite;
    Group shellMimeType;
    Group desktopLauncher;
    Group fontSizeGroup;
    Group kmzExportGroup;
    Group dataTableGroup;
    Group chargerSpecials;
    Group graphicsView;
    CTabItem osMiscTabItem;
    CTabItem miscTabItem;
    CLabel fileIOLevelLabel;
    CCombo fileIOLevelCombo;
    Button deviceDialogModalButton;
    Button deviceDialogOnTopButton;
    Button deviceDialogAlphaButton;
    Button deviceImportDialogButton;
    Group deviceDialogGroup;
    Group serialPortGroup;
    Group separatorGroup;
    CCombo listSeparator;
    CLabel listSeparatorLabel;
    CCombo decimalSeparator;
    CLabel decimalSeparatorLabel;
    Button defaultDataPathAdjustButton;
    Text defaultDataPath;
    CCombo globalLoggingCombo;
    Group loggingGroup;
    Group classSelectionGroup;
    Label classBasedLabel;
    Tree tree;
    Group skinColorSchemaGroup;
    Button osSchema;
    Button lightSchema;
    Button darkSchema;
    Thread listPortsThread;
    Vector<String> availablePorts = new Vector();
    final Settings settings;
    final DataExplorer application;
    final String[] supportedLocals = new String[]{"en", "de"};
    boolean isLocaleLanguageChanged = false;
    final LogLevelSelectionContextMenu logLevelMenu = new LogLevelSelectionContextMenu();
    Menu popupmenu;

    public SettingsDialog(Shell parent, int style) {
        super(parent, style);
        this.application = DataExplorer.getInstance();
        this.settings = Settings.getInstance();
    }

    public void open() {
        int shellWidth = 500;
        int shellHeight = GDE.IS_LINUX ? 620 : 620;
        try {
            String importPathLines;
            Shell parent = this.getParent();
            this.dialogShell = new Shell(parent, 34912);
            SWTResourceManager.registerResourceUser((Widget)this.dialogShell);
            this.dialogShell.setLayout((Layout)new FormLayout());
            this.dialogShell.setSize(shellWidth, shellHeight);
            this.dialogShell.layout();
            this.dialogShell.setText("DataExplorer" + Messages.getString("GDE_MSGT0300"));
            this.dialogShell.setImage(SWTResourceManager.getImage("gde/resource/DataExplorer.png"));
            this.dialogShell.addListener(31, new Listener(){

                public void handleEvent(Event event) {
                    switch (event.detail) {
                        case 2: {
                            SettingsDialog.this.dialogShell.close();
                            event.detail = 0;
                            event.doit = false;
                        }
                    }
                }
            });
            this.settingsTabFolder = new CTabFolder((Composite)this.dialogShell, 0x800800);
            this.settingsTabFolder.setSimple(false);
            FormData cTabFolder1LData = new FormData();
            cTabFolder1LData.height = GDE.IS_WINDOWS ? 480 : 530;
            cTabFolder1LData.left = new FormAttachment(0, 1000, 0);
            cTabFolder1LData.right = new FormAttachment(1000, 1000, 0);
            cTabFolder1LData.top = new FormAttachment(0, 1000, 0);
            this.settingsTabFolder.setFont(SWTResourceManager.getFont(GDE.WIDGET_FONT_NAME, GDE.WIDGET_FONT_SIZE, 0));
            this.settingsTabFolder.setLayoutData((Object)cTabFolder1LData);
            this.generalTabItem = new CTabItem(this.settingsTabFolder, 0);
            this.generalTabItem.setFont(SWTResourceManager.getFont(GDE.WIDGET_FONT_NAME, GDE.WIDGET_FONT_SIZE, 0));
            this.generalTabItem.setText(Messages.getString("GDE_MSGT0301"));
            this.generalTabComposite = new Composite((Composite)this.settingsTabFolder, 0);
            this.generalTabItem.setControl((Control)this.generalTabComposite);
            GridLayout generalTabCompositeLayout = new GridLayout(2, true);
            this.generalTabComposite.setLayout((Layout)generalTabCompositeLayout);
            this.groupLocale = new Group(this.generalTabComposite, 0);
            this.groupLocale.setLayout(null);
            this.groupLocale.setFont(SWTResourceManager.getFont(GDE.WIDGET_FONT_NAME, GDE.WIDGET_FONT_SIZE, 0));
            GridData groupLocaleLData = new GridData(256);
            groupLocaleLData.horizontalSpan = 1;
            groupLocaleLData.widthHint = shellWidth / 2 - 24;
            this.groupLocale.setLayoutData((Object)groupLocaleLData);
            this.groupLocale.setText(Messages.getString("GDE_MSGT0305"));
            this.localLabel = new CLabel((Composite)this.groupLocale, 0);
            this.localLabel.setFont(SWTResourceManager.getFont(GDE.WIDGET_FONT_NAME, GDE.WIDGET_FONT_SIZE, 0));
            this.localLabel.setBounds(10, GDE.IS_MAC ? 8 : (GDE.IS_LINUX ? 12 : 20), 120, GDE.IS_LINUX ? 22 : (GDE.IS_MAC ? 20 : 18));
            this.localLabel.setText(Messages.getString("GDE_MSGT0307"));
            this.localLabel.setToolTipText(Messages.getString("GDE_MSGT0308"));
            this.localCombo = new CCombo((Composite)this.groupLocale, 2048);
            this.localCombo.setFont(SWTResourceManager.getFont(GDE.WIDGET_FONT_NAME, GDE.WIDGET_FONT_SIZE, 0));
            this.localCombo.setItems(this.supportedLocals);
            this.localCombo.select(this.getLocalLanguageIndex());
            this.localCombo.setBounds(138, GDE.IS_MAC ? 8 : (GDE.IS_LINUX ? 12 : 20), 65, GDE.IS_LINUX ? 22 : (GDE.IS_MAC ? 20 : 18));
            this.localCombo.setToolTipText(Messages.getString("GDE_MSGT0306"));
            this.localCombo.setEditable(false);
            this.localCombo.setBackground(SWTResourceManager.getColor(255, 255, 255));
            this.localCombo.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent evt) {
                    log.log(Level.FINEST, "localCombo.widgetSelected, event=" + String.valueOf(evt));
                    String newLanguage = SettingsDialog.this.supportedLocals[SettingsDialog.this.localCombo.getSelectionIndex()];
                    SettingsDialog.this.isLocaleLanguageChanged = !SettingsDialog.this.settings.getLocale().getLanguage().equals(newLanguage);
                    SettingsDialog.this.settings.setLocaleLanguage(newLanguage);
                }
            });
            this.groupTimeFormat = new Group(this.generalTabComposite, 0);
            this.groupTimeFormat.setLayout(null);
            this.groupTimeFormat.setFont(SWTResourceManager.getFont(GDE.WIDGET_FONT_NAME, GDE.WIDGET_FONT_SIZE, 0));
            GridData groupTimeFormatLData = new GridData(256);
            groupTimeFormatLData.horizontalSpan = 1;
            groupTimeFormatLData.widthHint = shellWidth / 2 - 24;
            this.groupTimeFormat.setLayoutData((Object)groupTimeFormatLData);
            this.groupTimeFormat.setText(Messages.getString("GDE_MSGT0682"));
            this.timeFormatLabel = new CLabel((Composite)this.groupTimeFormat, 0);
            this.timeFormatLabel.setFont(SWTResourceManager.getFont(GDE.WIDGET_FONT_NAME, GDE.WIDGET_FONT_SIZE, 0));
            this.timeFormatLabel.setBounds(10, GDE.IS_MAC ? 8 : (GDE.IS_LINUX ? 12 : 20), 80, GDE.IS_LINUX ? 22 : (GDE.IS_MAC ? 20 : 18));
            this.timeFormatLabel.setText(Messages.getString("GDE_MSGT0682"));
            this.timeFormatLabel.setToolTipText(Messages.getString("GDE_MSGT0683"));
            this.timeFormatCombo = new CCombo((Composite)this.groupTimeFormat, 2048);
            this.timeFormatCombo.setFont(SWTResourceManager.getFont(GDE.WIDGET_FONT_NAME, GDE.WIDGET_FONT_SIZE, 0));
            this.timeFormatCombo.setItems(new String[]{Messages.getString("GDE_MSGT0684"), Messages.getString("GDE_MSGT0359")});
            this.timeFormatCombo.select(this.getTimeFormatIndex());
            this.timeFormatCombo.setBounds(90, GDE.IS_MAC ? 8 : (GDE.IS_LINUX ? 12 : 20), 140, GDE.IS_LINUX ? 22 : (GDE.IS_MAC ? 20 : 18));
            this.timeFormatCombo.setToolTipText(Messages.getString("GDE_MSGT0683"));
            this.timeFormatCombo.setEditable(false);
            this.timeFormatCombo.setBackground(SWTResourceManager.getColor(255, 255, 255));
            this.timeFormatCombo.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent evt) {
                    log.log(Level.FINEST, "timeFormatCombo.widgetSelected, event=" + String.valueOf(evt));
                    SettingsDialog.this.settings.setTimeFormat(SettingsDialog.this.timeFormatCombo.getItems()[SettingsDialog.this.timeFormatCombo.getSelectionIndex()]);
                }
            });
            this.defaultDataPathGroup = new Group(this.generalTabComposite, 0);
            GridData defaultDataPathGroupLData = new GridData(256);
            defaultDataPathGroupLData.horizontalSpan = 2;
            defaultDataPathGroupLData.widthHint = shellWidth - 25;
            defaultDataPathGroupLData.grabExcessHorizontalSpace = true;
            this.defaultDataPathGroup.setLayoutData((Object)defaultDataPathGroupLData);
            this.defaultDataPathGroup.setFont(SWTResourceManager.getFont(GDE.WIDGET_FONT_NAME, GDE.WIDGET_FONT_SIZE, 0));
            this.defaultDataPathGroup.setText(Messages.getString("GDE_MSGT0310"));
            this.defaultDataPathLabel = new CLabel((Composite)this.defaultDataPathGroup, 0);
            this.defaultDataPathLabel.setFont(SWTResourceManager.getFont(GDE.WIDGET_FONT_NAME, GDE.WIDGET_FONT_SIZE, 0));
            this.defaultDataPathLabel.setText(Messages.getString("GDE_MSGT0311"));
            this.defaultDataPathLabel.setBounds(15, GDE.IS_MAC ? 8 : (GDE.IS_LINUX ? 12 : 20), 90, 18);
            this.defaultDataPath = new Text((Composite)this.defaultDataPathGroup, 2048);
            this.defaultDataPath.setFont(SWTResourceManager.getFont(GDE.WIDGET_FONT_NAME, GDE.WIDGET_FONT_SIZE, 0));
            this.defaultDataPath.setBounds(107, GDE.IS_MAC ? 6 : (GDE.IS_LINUX ? 8 : 18), 295, GDE.IS_MAC ? 20 : (GDE.IS_LINUX ? 22 : 18));
            this.defaultDataPathAdjustButton = new Button((Composite)this.defaultDataPathGroup, 0x1000008);
            this.defaultDataPathAdjustButton.setFont(SWTResourceManager.getFont(GDE.WIDGET_FONT_NAME, GDE.WIDGET_FONT_SIZE, 0));
            this.defaultDataPathAdjustButton.setText(". . . ");
            this.defaultDataPathAdjustButton.setBounds(405, GDE.IS_WINDOWS ? 18 : 8, GDE.IS_WINDOWS ? 30 : 50, GDE.IS_LINUX ? 22 : (GDE.IS_MAC ? 20 : 18));
            this.defaultDataPathAdjustButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent evt) {
                    log.log(Level.FINEST, "defaultDataPathAdjustButton.widgetSelected, event=" + String.valueOf(evt));
                    String defaultDataDirectory = SettingsDialog.this.application.openDirFileDialog(Messages.getString("GDE_MSGT0312"), SettingsDialog.this.settings.getDataFilePath());
                    if (defaultDataDirectory != null && defaultDataDirectory.length() > 5) {
                        log.log(Level.FINE, "default directory from directoy dialog = " + defaultDataDirectory);
                        SettingsDialog.this.settings.setDataFilePath(defaultDataDirectory);
                        SettingsDialog.this.defaultDataPath.setText(defaultDataDirectory);
                        SettingsDialog.this.application.getHistoExplorer().ifPresent(HistoExplorer::resetHisto);
                    }
                }
            });
            this.fileOpenSaveDialogGroup = new Group(this.generalTabComposite, 0);
            this.fileOpenSaveDialogGroup.setFont(SWTResourceManager.getFont(GDE.WIDGET_FONT_NAME, GDE.WIDGET_FONT_SIZE, 0));
            this.fileOpenSaveDialogGroup.setLayout(null);
            GridData fileOpenSaveDialogGroupLData = new GridData(256);
            fileOpenSaveDialogGroupLData.horizontalSpan = 2;
            fileOpenSaveDialogGroupLData.widthHint = shellWidth - 25;
            fileOpenSaveDialogGroupLData.grabExcessHorizontalSpace = true;
            this.fileOpenSaveDialogGroup.setLayoutData((Object)fileOpenSaveDialogGroupLData);
            this.fileOpenSaveDialogGroup.setText(Messages.getString("GDE_MSGT0315"));
            this.suggestDate = new Button((Composite)this.fileOpenSaveDialogGroup, 16416);
            this.suggestDate.setFont(SWTResourceManager.getFont(GDE.WIDGET_FONT_NAME, GDE.WIDGET_FONT_SIZE, 0));
            this.suggestDate.setText(Messages.getString("GDE_MSGT0316"));
            this.suggestDate.setBounds(10, GDE.IS_MAC ? 8 : (GDE.IS_LINUX ? 12 : 20), 170, GDE.IS_LINUX ? 22 : (GDE.IS_MAC ? 20 : 18));
            this.suggestDate.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent evt) {
                    log.log(Level.FINEST, "suggestDate.widgetSelected, event=" + String.valueOf(evt));
                    SettingsDialog.this.settings.setUsageDateAsFileNameLeader(SettingsDialog.this.suggestDate.getSelection());
                }
            });
            this.suggestObjectKey = new Button((Composite)this.fileOpenSaveDialogGroup, 16416);
            this.suggestObjectKey.setFont(SWTResourceManager.getFont(GDE.WIDGET_FONT_NAME, GDE.WIDGET_FONT_SIZE, 0));
            this.suggestObjectKey.setText(Messages.getString("GDE_MSGT0317"));
            this.suggestObjectKey.setBounds(180, GDE.IS_MAC ? 8 : (GDE.IS_LINUX ? 12 : 20), 190, GDE.IS_LINUX ? 22 : (GDE.IS_MAC ? 20 : 18));
            this.suggestObjectKey.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent evt) {
                    log.log(Level.FINEST, "suggestObjectKey.widgetSelected, event=" + String.valueOf(evt));
                    SettingsDialog.this.settings.setUsageObjectKeyInFileName(SettingsDialog.this.suggestObjectKey.getSelection());
                }
            });
            this.writeTmpFiles = new Button((Composite)this.fileOpenSaveDialogGroup, 16416);
            this.writeTmpFiles.setFont(SWTResourceManager.getFont(GDE.WIDGET_FONT_NAME, GDE.WIDGET_FONT_SIZE, 0));
            this.writeTmpFiles.setText(Messages.getString("GDE_MSGT0674"));
            this.writeTmpFiles.setToolTipText(Messages.getString("GDE_MSGT0675", new String[]{Settings.getApplHomePath()}));
            this.writeTmpFiles.setBounds(370, GDE.IS_MAC ? 8 : (GDE.IS_LINUX ? 12 : 20), 95, GDE.IS_LINUX ? 22 : (GDE.IS_MAC ? 20 : 18));
            this.writeTmpFiles.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent evt) {
                    log.log(Level.FINEST, "writeTmpFiles.widgetSelected, event=" + String.valueOf(evt));
                    SettingsDialog.this.settings.setUsageWritingTmpFiles(SettingsDialog.this.writeTmpFiles.getSelection());
                    SettingsDialog.this.application.enableWritingTmpFiles(SettingsDialog.this.writeTmpFiles.getSelection());
                }
            });
            this.skinColorSchemaGroup = new Group(this.generalTabComposite, 0);
            this.skinColorSchemaGroup.setFont(SWTResourceManager.getFont(GDE.WIDGET_FONT_NAME, GDE.WIDGET_FONT_SIZE, 0));
            this.skinColorSchemaGroup.setLayout(null);
            GridData skinColorSchemaGroupLData = new GridData(256);
            skinColorSchemaGroupLData.horizontalSpan = 2;
            skinColorSchemaGroupLData.widthHint = shellWidth - 25;
            skinColorSchemaGroupLData.grabExcessHorizontalSpace = true;
            this.skinColorSchemaGroup.setLayoutData((Object)skinColorSchemaGroupLData);
            this.skinColorSchemaGroup.setText(Messages.getString("GDE_MSGT0954"));
            this.osSchema = new Button((Composite)this.skinColorSchemaGroup, 16416);
            this.osSchema.setFont(SWTResourceManager.getFont(GDE.WIDGET_FONT_NAME, GDE.WIDGET_FONT_SIZE, 0));
            this.osSchema.setText("Standard");
            this.osSchema.setBounds(10, GDE.IS_MAC ? 8 : (GDE.IS_LINUX ? 12 : 20), 170, GDE.IS_LINUX ? 22 : (GDE.IS_MAC ? 20 : 18));
            this.osSchema.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent evt) {
                    log.log(Level.FINEST, "osShema.widgetSelected, event=" + String.valueOf(evt));
                    if (SettingsDialog.this.osSchema.getSelection()) {
                        SettingsDialog.this.settings.setSkinColorSchema("color_schema_system");
                        SettingsDialog.this.lightSchema.setSelection(false);
                        SettingsDialog.this.darkSchema.setSelection(false);
                    }
                }
            });
            this.lightSchema = new Button((Composite)this.skinColorSchemaGroup, 16416);
            this.lightSchema.setFont(SWTResourceManager.getFont(GDE.WIDGET_FONT_NAME, GDE.WIDGET_FONT_SIZE, 0));
            this.lightSchema.setText(Messages.getString("GDE_MSGT0333"));
            this.lightSchema.setBounds(180, GDE.IS_MAC ? 8 : (GDE.IS_LINUX ? 12 : 20), 190, GDE.IS_LINUX ? 22 : (GDE.IS_MAC ? 20 : 18));
            this.lightSchema.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent evt) {
                    log.log(Level.FINEST, "lightSchema.widgetSelected, event=" + String.valueOf(evt));
                    if (SettingsDialog.this.lightSchema.getSelection()) {
                        SettingsDialog.this.settings.setSkinColorSchema("color_schema_light");
                        SettingsDialog.this.osSchema.setSelection(false);
                        SettingsDialog.this.darkSchema.setSelection(false);
                    }
                }
            });
            this.darkSchema = new Button((Composite)this.skinColorSchemaGroup, 16416);
            this.darkSchema.setFont(SWTResourceManager.getFont(GDE.WIDGET_FONT_NAME, GDE.WIDGET_FONT_SIZE, 0));
            this.darkSchema.setText(Messages.getString("GDE_MSGT0334"));
            this.darkSchema.setToolTipText(Messages.getString("GDE_MSGT0675", new String[]{Settings.getApplHomePath()}));
            this.darkSchema.setBounds(370, GDE.IS_MAC ? 8 : (GDE.IS_LINUX ? 12 : 20), 95, GDE.IS_LINUX ? 22 : (GDE.IS_MAC ? 20 : 18));
            this.darkSchema.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent evt) {
                    log.log(Level.FINEST, "darkSchema.widgetSelected, event=" + String.valueOf(evt));
                    if (SettingsDialog.this.darkSchema.getSelection()) {
                        SettingsDialog.this.settings.setSkinColorSchema("color_schema_dark");
                        SettingsDialog.this.lightSchema.setSelection(false);
                        SettingsDialog.this.osSchema.setSelection(false);
                    }
                }
            });
            this.deviceDialogGroup = new Group(this.generalTabComposite, 0);
            this.deviceDialogGroup.setLayout(null);
            GridData deviceDialogLData = new GridData(256);
            deviceDialogLData.horizontalSpan = 2;
            deviceDialogLData.widthHint = shellWidth - 25;
            deviceDialogLData.grabExcessHorizontalSpace = true;
            this.deviceDialogGroup.setLayoutData((Object)deviceDialogLData);
            this.deviceDialogGroup.setFont(SWTResourceManager.getFont(GDE.WIDGET_FONT_NAME, GDE.WIDGET_FONT_SIZE, 0));
            this.deviceDialogGroup.setText(Messages.getString("GDE_MSGT0318"));
            this.deviceDialogModalButton = new Button((Composite)this.deviceDialogGroup, 16416);
            this.deviceDialogModalButton.setFont(SWTResourceManager.getFont(GDE.WIDGET_FONT_NAME, GDE.WIDGET_FONT_SIZE, 0));
            this.deviceDialogModalButton.setText(Messages.getString("GDE_MSGT0319"));
            this.deviceDialogModalButton.setBounds(16, GDE.IS_MAC ? 8 : (GDE.IS_LINUX ? 12 : 20), 254, GDE.IS_LINUX ? 22 : (GDE.IS_MAC ? 20 : 18));
            this.deviceDialogModalButton.setToolTipText(Messages.getString("GDE_MSGT0320"));
            this.deviceDialogModalButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent evt) {
                    log.log(Level.FINEST, "deviceDialogModalButton.widgetSelected, event=" + String.valueOf(evt));
                    SettingsDialog.this.settings.enabelModalDeviceDialogs(SettingsDialog.this.deviceDialogModalButton.getSelection());
                    SettingsDialog.this.deviceDialogOnTopButton.setEnabled(!SettingsDialog.this.deviceDialogModalButton.getSelection());
                }
            });
            this.deviceDialogOnTopButton = new Button((Composite)this.deviceDialogGroup, 16416);
            this.deviceDialogOnTopButton.setFont(SWTResourceManager.getFont(GDE.WIDGET_FONT_NAME, GDE.WIDGET_FONT_SIZE, 0));
            this.deviceDialogOnTopButton.setText(Messages.getString("GDE_MSGT0309"));
            this.deviceDialogOnTopButton.setBounds(282, GDE.IS_MAC ? 8 : (GDE.IS_LINUX ? 12 : 20), 165, GDE.IS_LINUX ? 22 : (GDE.IS_MAC ? 20 : 18));
            this.deviceDialogOnTopButton.setToolTipText(Messages.getString("GDE_MSGT0320"));
            this.deviceDialogOnTopButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent evt) {
                    log.log(Level.FINEST, "deviceDialogOnTopButton.widgetSelected, event=" + String.valueOf(evt));
                    SettingsDialog.this.settings.enabelDeviceDialogsOnTop(SettingsDialog.this.deviceDialogOnTopButton.getSelection());
                }
            });
            this.deviceDialogAlphaButton = new Button((Composite)this.deviceDialogGroup, 16416);
            this.deviceDialogAlphaButton.setFont(SWTResourceManager.getFont(GDE.WIDGET_FONT_NAME, GDE.WIDGET_FONT_SIZE, 0));
            this.deviceDialogAlphaButton.setText(Messages.getString("GDE_MSGT0321"));
            this.deviceDialogAlphaButton.setBounds(16, GDE.IS_MAC ? 30 : (GDE.IS_LINUX ? 36 : 45), 254, GDE.IS_LINUX ? 22 : (GDE.IS_MAC ? 20 : 18));
            this.deviceDialogAlphaButton.setToolTipText(Messages.getString("GDE_MSGT0322"));
            this.deviceDialogAlphaButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent evt) {
                    log.log(Level.FINEST, "deviceDialogButton.widgetSelected, event=" + String.valueOf(evt));
                    SettingsDialog.this.settings.setDeviceDialogAlphaEnabled(SettingsDialog.this.deviceDialogAlphaButton.getSelection());
                    SettingsDialog.this.alphaSlider.setEnabled(SettingsDialog.this.deviceDialogAlphaButton.getSelection());
                }
            });
            this.alphaSlider = new Slider((Composite)this.deviceDialogGroup, 0);
            this.alphaSlider.setBounds(282, GDE.IS_MAC ? 25 : (GDE.IS_LINUX ? 32 : 45), 163, GDE.IS_LINUX ? 22 : (GDE.IS_MAC ? 20 : 18));
            this.alphaSlider.setIncrement(5);
            this.alphaSlider.setMinimum(10);
            this.alphaSlider.setMaximum(180);
            this.alphaSlider.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent evt) {
                    log.log(Level.FINER, "alphaSlider.widgetSelected, event=" + String.valueOf(evt));
                    switch (evt.detail) {
                        case 1: {
                            SettingsDialog.this.dialogShell.setAlpha(SettingsDialog.this.alphaSlider.getSelection());
                            break;
                        }
                        default: {
                            SettingsDialog.this.settings.setDialogAlphaValue(SettingsDialog.this.alphaSlider.getSelection());
                            SettingsDialog.this.dialogShell.setAlpha(254);
                        }
                    }
                    SettingsDialog.this.settings.setDialogAlphaValue(SettingsDialog.this.alphaSlider.getSelection());
                }
            });
            this.deviceImportDialogButton = new Button((Composite)this.deviceDialogGroup, 16416);
            this.deviceImportDialogButton.setFont(SWTResourceManager.getFont(GDE.WIDGET_FONT_NAME, GDE.WIDGET_FONT_SIZE, 0));
            this.deviceImportDialogButton.setText(Messages.getString("GDE_MSGT0409"));
            this.deviceImportDialogButton.setBounds(16, GDE.IS_MAC ? 52 : (GDE.IS_LINUX ? 62 : 72), 435, GDE.IS_LINUX ? 22 : (GDE.IS_MAC ? 20 : 18));
            this.deviceImportDialogButton.setToolTipText(Messages.getString("GDE_MSGT0437"));
            this.deviceImportDialogButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent evt) {
                    log.log(Level.FINEST, "deviceDialogButton.widgetSelected, event=" + String.valueOf(evt));
                    SettingsDialog.this.settings.setDeviceImportDirectoryObjectRelated(SettingsDialog.this.deviceImportDialogButton.getSelection());
                }
            });
            this.separatorGroup = new Group(this.generalTabComposite, 0);
            this.separatorGroup.setLayout(null);
            this.separatorGroup.setFont(SWTResourceManager.getFont(GDE.WIDGET_FONT_NAME, GDE.WIDGET_FONT_SIZE, 0));
            GridData separatorGroupLData = new GridData(256);
            separatorGroupLData.horizontalSpan = 2;
            separatorGroupLData.widthHint = shellWidth - 25;
            separatorGroupLData.grabExcessHorizontalSpace = true;
            this.separatorGroup.setLayoutData((Object)separatorGroupLData);
            this.separatorGroup.setText(Messages.getString("GDE_MSGT0325"));
            this.decimalSeparatorLabel = new CLabel((Composite)this.separatorGroup, 131072);
            this.decimalSeparatorLabel.setFont(SWTResourceManager.getFont(GDE.WIDGET_FONT_NAME, GDE.WIDGET_FONT_SIZE, 0));
            this.decimalSeparatorLabel.setText(Messages.getString("GDE_MSGT0326"));
            this.decimalSeparatorLabel.setToolTipText(Messages.getString("GDE_MSGT0327"));
            this.decimalSeparatorLabel.setBounds(10, GDE.IS_MAC || GDE.IS_LINUX ? 12 : 24, 140, GDE.IS_LINUX ? 22 : (GDE.IS_MAC ? 20 : 18));
            this.decimalSeparator = new CCombo((Composite)this.separatorGroup, 2048);
            this.decimalSeparator.setFont(SWTResourceManager.getFont(GDE.WIDGET_FONT_NAME, GDE.WIDGET_FONT_SIZE, 1));
            this.decimalSeparator.setItems(DecimalSeparatorTypes.valuesAsStingArray());
            this.decimalSeparator.setBounds(153, GDE.IS_MAC || GDE.IS_LINUX ? 12 : 24, 65, GDE.IS_LINUX ? 22 : (GDE.IS_MAC ? 20 : 18));
            this.decimalSeparator.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent evt) {
                    log.log(Level.FINEST, "decimalSeparator.widgetSelected, event=" + String.valueOf(evt));
                    SettingsDialog.this.settings.setDecimalSeparator(SettingsDialog.this.decimalSeparator.getText().trim());
                    SettingsDialog.this.decimalSeparator.setText(" " + SettingsDialog.this.decimalSeparator.getText().trim());
                }
            });
            this.listSeparatorLabel = new CLabel((Composite)this.separatorGroup, 131072);
            this.listSeparatorLabel.setFont(SWTResourceManager.getFont(GDE.WIDGET_FONT_NAME, GDE.WIDGET_FONT_SIZE, 0));
            this.listSeparatorLabel.setText(Messages.getString("GDE_MSGT0328"));
            this.listSeparatorLabel.setToolTipText(Messages.getString("GDE_MSGT0329"));
            this.listSeparatorLabel.setBounds(228, GDE.IS_MAC || GDE.IS_LINUX ? 12 : 24, 140, GDE.IS_LINUX ? 22 : (GDE.IS_MAC ? 20 : 18));
            this.listSeparator = new CCombo((Composite)this.separatorGroup, 2048);
            this.listSeparator.setFont(SWTResourceManager.getFont(GDE.WIDGET_FONT_NAME, GDE.WIDGET_FONT_SIZE, 1));
            this.listSeparator.setItems(CommaSeparatorTypes.valuesAsStingArray());
            this.listSeparator.setBounds(370, GDE.IS_MAC || GDE.IS_LINUX ? 12 : 24, 65, GDE.IS_LINUX ? 22 : (GDE.IS_MAC ? 20 : 18));
            this.listSeparator.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent evt) {
                    log.log(Level.FINEST, "listSeparator.widgetSelected, event=" + String.valueOf(evt));
                    SettingsDialog.this.settings.setListSeparator(SettingsDialog.this.listSeparator.getText().trim());
                    SettingsDialog.this.listSeparator.setText(" " + SettingsDialog.this.listSeparator.getText().trim());
                }
            });
            this.serialPortGroup = new Group(this.generalTabComposite, 0);
            this.serialPortGroup.setLayout(null);
            GridData serialPortGroupLData = new GridData(256);
            serialPortGroupLData.horizontalSpan = 2;
            serialPortGroupLData.widthHint = shellWidth - 25;
            serialPortGroupLData.grabExcessHorizontalSpace = true;
            this.serialPortGroup.setLayoutData((Object)serialPortGroupLData);
            this.serialPortGroup.setFont(SWTResourceManager.getFont(GDE.WIDGET_FONT_NAME, GDE.WIDGET_FONT_SIZE, 0));
            this.serialPortGroup.setText(Messages.getString("GDE_MSGT0330"));
            this.enableBlackListButton = new Button((Composite)this.serialPortGroup, 16416);
            this.enableBlackListButton.setText(Messages.getString("GDE_MSGT0336"));
            this.enableBlackListButton.setBounds(15, GDE.IS_MAC ? 8 : (GDE.IS_LINUX ? 12 : 18), 243, GDE.IS_LINUX ? 22 : (GDE.IS_MAC ? 20 : 18));
            this.enableBlackListButton.setFont(SWTResourceManager.getFont(GDE.WIDGET_FONT_NAME, GDE.WIDGET_FONT_SIZE, 0));
            this.enableBlackListButton.setToolTipText(Messages.getString("GDE_MSGT0337"));
            this.enableBlackListButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent evt) {
                    log.log(Level.FINEST, "enableBlackListButton.widgetSelected, event=" + String.valueOf(evt));
                    if (SettingsDialog.this.enableBlackListButton.getSelection()) {
                        SettingsDialog.this.settings.setSerialPortBlackListEnabled(true);
                        SettingsDialog.this.serialPortBlackList.setEditable(true);
                        SettingsDialog.this.serialPortBlackList.setEnabled(true);
                        SettingsDialog.this.settings.setSerialPortWhiteListEnabled(false);
                        SettingsDialog.this.enableWhiteListButton.setSelection(false);
                        SettingsDialog.this.serialPortWhiteList.setEditable(false);
                        SettingsDialog.this.serialPortWhiteList.setEnabled(false);
                    } else {
                        SettingsDialog.this.settings.setSerialPortBlackListEnabled(false);
                        SettingsDialog.this.serialPortBlackList.setEditable(false);
                        SettingsDialog.this.serialPortBlackList.setEnabled(false);
                    }
                }
            });
            this.serialPortBlackList = new Text((Composite)this.serialPortGroup, 2048);
            this.serialPortBlackList.setFont(SWTResourceManager.getFont(GDE.WIDGET_FONT_NAME, GDE.WIDGET_FONT_SIZE, 0));
            this.serialPortBlackList.setToolTipText(Messages.getString("GDE_MSGT0337"));
            this.serialPortBlackList.setBounds(260, GDE.IS_MAC ? 8 : (GDE.IS_LINUX ? 12 : 18), 181, GDE.IS_LINUX ? 22 : (GDE.IS_MAC ? 20 : 18));
            this.serialPortBlackList.addVerifyListener(new VerifyListener(){

                public void verifyText(VerifyEvent e) {
                    log.log(Level.FINEST, "" + StringHelper.verifyPortInput(e.text.trim()));
                    e.doit = StringHelper.verifyPortInput(e.text.trim());
                }
            });
            this.serialPortBlackList.addKeyListener((KeyListener)new KeyAdapter(){

                public void keyReleased(KeyEvent evt) {
                    log.log(Level.FINEST, "serialPortBlackList.keyReleased, event=" + String.valueOf(evt));
                    SettingsDialog.this.settings.setSerialPortBlackList(SettingsDialog.this.serialPortBlackList.getText());
                }
            });
            this.enableWhiteListButton = new Button((Composite)this.serialPortGroup, 16416);
            this.enableWhiteListButton.setText(Messages.getString("GDE_MSGT0338"));
            this.enableWhiteListButton.setBounds(15, GDE.IS_MAC ? 30 : (GDE.IS_LINUX ? 36 : 45), 243, GDE.IS_LINUX ? 22 : (GDE.IS_MAC ? 20 : 18));
            this.enableWhiteListButton.setFont(SWTResourceManager.getFont(GDE.WIDGET_FONT_NAME, GDE.WIDGET_FONT_SIZE, 0));
            this.enableWhiteListButton.setToolTipText(Messages.getString("GDE_MSGT0339"));
            this.enableWhiteListButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent evt) {
                    log.log(Level.FINEST, "enableWhiteListButton.widgetSelected, event=" + String.valueOf(evt));
                    if (SettingsDialog.this.enableWhiteListButton.getSelection()) {
                        SettingsDialog.this.settings.setSerialPortWhiteListEnabled(true);
                        SettingsDialog.this.serialPortWhiteList.setEditable(true);
                        SettingsDialog.this.serialPortWhiteList.setEnabled(true);
                        SettingsDialog.this.settings.setSerialPortBlackListEnabled(false);
                        SettingsDialog.this.enableBlackListButton.setSelection(false);
                        SettingsDialog.this.serialPortBlackList.setEditable(false);
                        SettingsDialog.this.serialPortBlackList.setEnabled(false);
                        SettingsDialog.this.settings.setSerialPortWhiteList(SettingsDialog.this.serialPortWhiteList.getText());
                    } else {
                        SettingsDialog.this.settings.setSerialPortWhiteListEnabled(false);
                        SettingsDialog.this.serialPortWhiteList.setEditable(false);
                        SettingsDialog.this.serialPortWhiteList.setEnabled(false);
                    }
                }
            });
            this.serialPortWhiteList = new Text((Composite)this.serialPortGroup, 2048);
            this.serialPortWhiteList.setFont(SWTResourceManager.getFont(GDE.WIDGET_FONT_NAME, GDE.WIDGET_FONT_SIZE, 0));
            this.serialPortWhiteList.setToolTipText(Messages.getString("GDE_MSGT0339"));
            this.serialPortWhiteList.setBounds(260, GDE.IS_MAC ? 30 : (GDE.IS_LINUX ? 32 : 45), 181, GDE.IS_LINUX ? 22 : (GDE.IS_MAC ? 20 : 18));
            this.serialPortWhiteList.addVerifyListener(new VerifyListener(){

                public void verifyText(VerifyEvent e) {
                }
            });
            this.serialPortWhiteList.addKeyListener((KeyListener)new KeyAdapter(){

                public void keyReleased(KeyEvent evt) {
                    log.log(Level.FINEST, "serialPortWhiteList.keyReleased, event=" + String.valueOf(evt));
                    SettingsDialog.this.settings.setSerialPortWhiteList(SettingsDialog.this.serialPortWhiteList.getText());
                }
            });
            this.skipBluetoothDevices = new Button((Composite)this.serialPortGroup, 16416);
            this.skipBluetoothDevices.setBounds(260, GDE.IS_MAC ? 52 : (GDE.IS_LINUX ? 62 : 72), 243, GDE.IS_LINUX ? 22 : (GDE.IS_MAC ? 20 : 18));
            this.skipBluetoothDevices.setFont(SWTResourceManager.getFont(GDE.WIDGET_FONT_NAME, GDE.WIDGET_FONT_SIZE, 0));
            this.skipBluetoothDevices.setText(Messages.getString("GDE_MSGT0434"));
            this.skipBluetoothDevices.setToolTipText(Messages.getString("GDE_MSGT0435"));
            this.skipBluetoothDevices.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent evt) {
                    log.log(Level.FINE, "skipBluetoothDevices.widgetSelected, event=" + String.valueOf(evt));
                    SettingsDialog.this.settings.setSkipBluetoothDevices(SettingsDialog.this.skipBluetoothDevices.getSelection());
                    if (!SettingsDialog.this.skipBluetoothDevices.getSelection()) {
                        SettingsDialog.this.application.openMessageDialog(SettingsDialog.this.dialogShell, Messages.getString("GDE_MSGI0049"));
                    }
                }
            });
            this.doPortAvailabilityCheck = new Button((Composite)this.serialPortGroup, 16416);
            this.doPortAvailabilityCheck.setBounds(15, GDE.IS_MAC ? 52 : (GDE.IS_LINUX ? 62 : 72), 243, GDE.IS_LINUX ? 22 : (GDE.IS_MAC ? 20 : 18));
            this.doPortAvailabilityCheck.setFont(SWTResourceManager.getFont(GDE.WIDGET_FONT_NAME, GDE.WIDGET_FONT_SIZE, 0));
            this.doPortAvailabilityCheck.setText(Messages.getString("GDE_MSGT0331"));
            this.doPortAvailabilityCheck.setToolTipText(Messages.getString("GDE_MSGT0332"));
            this.doPortAvailabilityCheck.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent evt) {
                    log.log(Level.FINE, "doPortAvailabilityCheck.widgetSelected, event=" + String.valueOf(evt));
                    SettingsDialog.this.settings.setPortAvailabilityCheck(SettingsDialog.this.doPortAvailabilityCheck.getSelection());
                    if (SettingsDialog.this.doPortAvailabilityCheck.getSelection()) {
                        SettingsDialog.this.application.openMessageDialog(SettingsDialog.this.dialogShell, Messages.getString("GDE_MSGI0036"));
                    }
                }
            });
            this.generalTabComposite.layout();
            this.histoTabItem = new CTabItem(this.settingsTabFolder, 0);
            this.histoTabItem.setFont(SWTResourceManager.getFont(GDE.WIDGET_FONT_NAME, GDE.WIDGET_FONT_SIZE, 0));
            this.histoTabItem.setText(Messages.getString("GDE_MSGT0738"));
            this.histoComposite = new Composite((Composite)this.settingsTabFolder, 0);
            this.histoTabItem.setControl((Control)this.histoComposite);
            RowLayout compositeHistoLayout = new RowLayout(256);
            compositeHistoLayout.marginLeft = GDE.IS_MAC ? 2 : 5;
            compositeHistoLayout.spacing = GDE.IS_MAC ? 2 : 5;
            compositeHistoLayout.marginTop = GDE.IS_MAC ? 3 : 11;
            this.histoComposite.setLayout((Layout)compositeHistoLayout);
            this.histoActive = new Button(this.histoComposite, 32);
            this.histoActive.setLayoutData((Object)new RowData(333, 15));
            this.histoActive.setFont(SWTResourceManager.getFont(GDE.WIDGET_FONT_NAME, GDE.WIDGET_FONT_SIZE, 0));
            this.histoActive.setText(Messages.getString("GDE_MSGT0739"));
            this.histoActive.setToolTipText(Messages.getString("GDE_MSGT0740"));
            this.histoActive.setSelection(this.settings.isHistoActive());
            this.histoActive.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent evt) {
                    log.log(Level.FINEST, "histoActive.widgetSelected, event=" + String.valueOf(evt));
                    SettingsDialog.this.settings.setHistoActive(SettingsDialog.this.histoActive.getSelection());
                    SettingsDialog.this.application.setHisto(SettingsDialog.this.histoActive.getSelection());
                }
            });
            this.histoDisplayOption = new Group(this.histoComposite, 0);
            RowData histoDisplayOptionRData = new RowData();
            histoDisplayOptionRData.width = GDE.IS_MAC ? 485 : 477;
            this.histoDisplayOption.setLayoutData((Object)histoDisplayOptionRData);
            RowLayout histoDisplayOptionRLayout = new RowLayout(256);
            histoDisplayOptionRLayout.marginHeight = 2;
            histoDisplayOptionRLayout.marginRight = 2;
            histoDisplayOptionRLayout.marginLeft = 2;
            histoDisplayOptionRLayout.marginTop = 2;
            this.histoDisplayOption.setLayout((Layout)histoDisplayOptionRLayout);
            this.histoDisplayOption.setFont(SWTResourceManager.getFont(GDE.WIDGET_FONT_NAME, GDE.WIDGET_FONT_SIZE, 0));
            this.histoDisplayOption.setText(Messages.getString("GDE_MSGT0806"));
            this.histoXAxis = new Group((Composite)this.histoDisplayOption, 0);
            RowData histoXAxisGroupLData = new RowData();
            histoXAxisGroupLData.width = 223;
            this.histoXAxis.setLayoutData((Object)histoXAxisGroupLData);
            FormLayout formLayout = new FormLayout();
            formLayout.marginTop = 7;
            formLayout.marginHeight = 0;
            formLayout.marginRight = 0;
            formLayout.marginLeft = 0;
            this.histoXAxis.setLayout((Layout)formLayout);
            this.histoXAxis.setFont(SWTResourceManager.getFont(GDE.WIDGET_FONT_NAME, GDE.WIDGET_FONT_SIZE, 0));
            this.histoXAxis.setText(Messages.getString("GDE_MSGT0816"));
            this.histoReversed = new Button((Composite)this.histoXAxis, 32);
            FormData formData = new FormData();
            formData.left = new FormAttachment(0, 5);
            this.histoReversed.setLayoutData((Object)formData);
            this.histoReversed.setFont(SWTResourceManager.getFont(GDE.WIDGET_FONT_NAME, GDE.WIDGET_FONT_SIZE, 0));
            this.histoReversed.setText(Messages.getString("GDE_MSGT0821"));
            this.histoReversed.setToolTipText(Messages.getString("GDE_MSGT0822"));
            this.histoReversed.setSelection(this.settings.isXAxisReversed());
            this.histoReversed.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent evt) {
                    log.log(Level.FINEST, "histoReversed.widgetSelected, event=" + String.valueOf(evt));
                    SettingsDialog.this.settings.setXAxisReversed(SettingsDialog.this.histoReversed.getSelection());
                    SettingsDialog.this.application.getHistoExplorer().ifPresent(h -> h.updateHistoTabs(false, false, true));
                }
            });
            this.histoSpreadLabel = new CLabel((Composite)this.histoXAxis, 0);
            formData = new FormData();
            formData.top = new FormAttachment((Control)this.histoReversed, 5);
            this.histoSpreadLabel.setLayoutData((Object)formData);
            this.histoSpreadLabel.setFont(SWTResourceManager.getFont(GDE.WIDGET_FONT_NAME, GDE.WIDGET_FONT_SIZE, 0));
            this.histoSpreadLabel.setBounds(10, GDE.IS_MAC ? 8 : 20, 120, 20);
            this.histoSpreadLabel.setText(Messages.getString("GDE_MSGT0817"));
            this.histoSpreadLabel.setToolTipText(Messages.getString("GDE_MSGT0818"));
            this.histoSpreadGrade = new CCombo((Composite)this.histoXAxis, 2048);
            formData = new FormData();
            formData.top = new FormAttachment((Control)this.histoReversed, 5);
            formData.right = new FormAttachment(100, -5);
            formData.height = GDE.IS_LINUX ? 22 : (GDE.IS_MAC ? 20 : 18);
            formData.width = GDE.IS_LINUX ? 80 : 70;
            this.histoSpreadGrade.setLayoutData((Object)formData);
            this.histoSpreadGrade.setFont(SWTResourceManager.getFont(GDE.WIDGET_FONT_NAME, GDE.WIDGET_FONT_SIZE, 0));
            this.histoSpreadGrade.setItems(Settings.getXAxisSpreadGradeNomenclatures());
            this.histoSpreadGrade.setText(" " + this.settings.getXAxisSpreadGrade());
            this.histoSpreadGrade.setToolTipText(Messages.getString("GDE_MSGT0818"));
            this.histoSpreadGrade.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent evt) {
                    log.log(Level.FINEST, "histoSpreadGrade.widgetSelected, event=" + String.valueOf(evt));
                    SettingsDialog.this.settings.setXAxisSpreadGrade(SettingsDialog.this.histoSpreadGrade.getText().trim());
                    SettingsDialog.this.application.getHistoExplorer().ifPresent(h -> h.updateHistoTabs(false, false, true));
                }
            });
            this.histoLogarithmicDistance = new Button((Composite)this.histoXAxis, 32);
            formData = new FormData();
            formData.left = new FormAttachment(0, 5);
            formData.top = new FormAttachment((Control)this.histoSpreadLabel, 10);
            this.histoLogarithmicDistance.setLayoutData((Object)formData);
            this.histoLogarithmicDistance.setFont(SWTResourceManager.getFont(GDE.WIDGET_FONT_NAME, GDE.WIDGET_FONT_SIZE, 0));
            this.histoLogarithmicDistance.setText(Messages.getString("GDE_MSGT0819"));
            this.histoLogarithmicDistance.setToolTipText(Messages.getString("GDE_MSGT0820"));
            this.histoLogarithmicDistance.setSelection(this.settings.isXAxisLogarithmicDistance());
            this.histoLogarithmicDistance.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent evt) {
                    log.log(Level.FINEST, "histoLogarithmicDistance.widgetSelected, event=" + String.valueOf(evt));
                    SettingsDialog.this.settings.setXAxisLogarithmicDistance(SettingsDialog.this.histoLogarithmicDistance.getSelection());
                    SettingsDialog.this.application.getHistoExplorer().ifPresent(h -> h.updateHistoTabs(false, false, true));
                }
            });
            this.histoBoxplot = new Group((Composite)this.histoDisplayOption, 0);
            RowData histoXAxisGroupRData = new RowData();
            histoXAxisGroupRData.width = 223;
            this.histoBoxplot.setLayoutData((Object)histoXAxisGroupRData);
            formLayout = new FormLayout();
            formLayout.marginHeight = 2;
            formLayout.marginRight = 2;
            formLayout.marginLeft = 2;
            formLayout.marginTop = 2;
            this.histoBoxplot.setLayout((Layout)formLayout);
            this.histoBoxplot.setFont(SWTResourceManager.getFont(GDE.WIDGET_FONT_NAME, GDE.WIDGET_FONT_SIZE, 0));
            this.histoBoxplot.setText(Messages.getString("GDE_MSGT0795"));
            this.histoBoxplotScaleLabel = new CLabel((Composite)this.histoBoxplot, 0);
            formData = new FormData();
            this.histoBoxplotScaleLabel.setLayoutData((Object)formData);
            this.histoBoxplotScaleLabel.setFont(SWTResourceManager.getFont(GDE.WIDGET_FONT_NAME, GDE.WIDGET_FONT_SIZE, 0));
            this.histoBoxplotScaleLabel.setBounds(10, GDE.IS_MAC ? 8 : 20, 120, 20);
            this.histoBoxplotScaleLabel.setText(Messages.getString("GDE_MSGT0812"));
            this.histoBoxplotScaleLabel.setToolTipText(Messages.getString("GDE_MSGT0813"));
            this.histoBoxplotScale = new CCombo((Composite)this.histoBoxplot, 2048);
            formData = new FormData();
            formData.right = new FormAttachment(100, -5);
            formData.height = GDE.IS_LINUX ? 22 : (GDE.IS_MAC ? 20 : 18);
            formData.width = GDE.IS_LINUX ? 80 : 70;
            this.histoBoxplotScale.setLayoutData((Object)formData);
            this.histoBoxplotScale.setFont(SWTResourceManager.getFont(GDE.WIDGET_FONT_NAME, GDE.WIDGET_FONT_SIZE, 0));
            this.histoBoxplotScale.setItems(Settings.getBoxplotScaleNomenclatures());
            this.histoBoxplotScale.setText(" " + this.settings.getBoxplotScale());
            this.histoBoxplotScale.setToolTipText(Messages.getString("GDE_MSGT0813"));
            this.histoBoxplotScale.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent evt) {
                    log.log(Level.FINEST, "histoBoxplotScale.widgetSelected, event=" + String.valueOf(evt));
                    SettingsDialog.this.settings.setBoxplotScale(SettingsDialog.this.histoBoxplotScale.getText().trim());
                    SettingsDialog.this.application.getHistoExplorer().ifPresent(h -> h.updateHistoTabs(false, false, true));
                }
            });
            this.histoBoxplotSizeAdaptationLabel = new CLabel((Composite)this.histoBoxplot, 0);
            formData = new FormData();
            formData.top = new FormAttachment((Control)this.histoBoxplotScaleLabel, 5);
            this.histoBoxplotSizeAdaptationLabel.setLayoutData((Object)formData);
            this.histoBoxplotSizeAdaptationLabel.setFont(SWTResourceManager.getFont(GDE.WIDGET_FONT_NAME, GDE.WIDGET_FONT_SIZE, 0));
            this.histoBoxplotSizeAdaptationLabel.setBounds(10, GDE.IS_MAC ? 8 : 20, 120, 20);
            this.histoBoxplotSizeAdaptationLabel.setText(Messages.getString("GDE_MSGT0814"));
            this.histoBoxplotSizeAdaptationLabel.setToolTipText(Messages.getString("GDE_MSGT0815"));
            this.histoBoxplotSizeAdaptation = new CCombo((Composite)this.histoBoxplot, 2048);
            formData = new FormData();
            formData.top = new FormAttachment((Control)this.histoBoxplotScaleLabel, 5);
            formData.right = new FormAttachment(100, -5);
            formData.height = GDE.IS_LINUX ? 22 : (GDE.IS_MAC ? 20 : 18);
            formData.width = GDE.IS_LINUX ? 80 : 70;
            this.histoBoxplotSizeAdaptation.setLayoutData((Object)formData);
            this.histoBoxplotSizeAdaptation.setFont(SWTResourceManager.getFont(GDE.WIDGET_FONT_NAME, GDE.WIDGET_FONT_SIZE, 0));
            this.histoBoxplotSizeAdaptation.setItems(Settings.getBoxplotSizeAdaptationNomenclatures());
            this.histoBoxplotSizeAdaptation.setText(" " + this.settings.getBoxplotSizeAdaptation());
            this.histoBoxplotSizeAdaptation.setToolTipText(Messages.getString("GDE_MSGT0815"));
            this.histoBoxplotSizeAdaptation.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent evt) {
                    log.log(Level.FINEST, "histoBoxplotSizeAdaptation.widgetSelected, event=" + String.valueOf(evt));
                    SettingsDialog.this.settings.setBoxplotSizeAdaptation(SettingsDialog.this.histoBoxplotSizeAdaptation.getText().trim());
                    SettingsDialog.this.application.getHistoExplorer().ifPresent(h -> h.updateHistoTabs(false, false, true));
                }
            });
            this.fileOpenGroup = new Group((Composite)this.histoDisplayOption, 0);
            RowData groupLData = new RowData();
            groupLData.width = 223;
            this.fileOpenGroup.setLayoutData((Object)groupLData);
            formLayout = new FormLayout();
            formLayout.marginTop = 2;
            formLayout.marginBottom = 2;
            formLayout.marginHeight = 2;
            formLayout.marginRight = 2;
            formLayout.marginLeft = 2;
            this.fileOpenGroup.setLayout((Layout)formLayout);
            this.fileOpenGroup.setFont(SWTResourceManager.getFont(GDE.WIDGET_FONT_NAME, GDE.WIDGET_FONT_SIZE, 0));
            this.fileOpenGroup.setText(Messages.getString("GDE_MSGT0880"));
            this.firstRecordSet = new Button((Composite)this.fileOpenGroup, 32);
            formData = new FormData();
            formData.left = new FormAttachment(0, 5);
            this.firstRecordSet.setLayoutData((Object)formData);
            this.firstRecordSet.setFont(SWTResourceManager.getFont(GDE.WIDGET_FONT_NAME, GDE.WIDGET_FONT_SIZE, 0));
            this.firstRecordSet.setText(Messages.getString("GDE_MSGT0881"));
            this.firstRecordSet.setToolTipText(Messages.getString("GDE_MSGT0882"));
            this.firstRecordSet.setSelection(this.settings.isFirstRecordSetChoice());
            this.firstRecordSet.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent evt) {
                    log.log(Level.FINEST, "firstRecordSetButton.widgetSelected, event=" + String.valueOf(evt));
                    SettingsDialog.this.settings.setFirstRecordSetChoice(SettingsDialog.this.firstRecordSet.getSelection());
                }
            });
            this.histoObjectQuery = new Button((Composite)this.fileOpenGroup, 32);
            formData = new FormData();
            formData.left = new FormAttachment(0, 5);
            formData.top = new FormAttachment((Control)this.firstRecordSet, 5);
            this.histoObjectQuery.setLayoutData((Object)formData);
            this.histoObjectQuery.setFont(SWTResourceManager.getFont(GDE.WIDGET_FONT_NAME, GDE.WIDGET_FONT_SIZE, 0));
            this.histoObjectQuery.setText(Messages.getString("GDE_MSGT0927"));
            this.histoObjectQuery.setToolTipText(Messages.getString("GDE_MSGT0928"));
            this.histoObjectQuery.setSelection(this.settings.isObjectQueryActive());
            this.histoObjectQuery.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent evt) {
                    log.log(Level.FINEST, "histoObjectQueryButton.widgetSelected, event=" + String.valueOf(evt));
                    SettingsDialog.this.settings.setObjectQueryActive(SettingsDialog.this.histoObjectQuery.getSelection());
                }
            });
            this.timeZone = new Group((Composite)this.histoDisplayOption, 0);
            groupLData = new RowData();
            groupLData.width = 223;
            this.timeZone.setLayoutData((Object)groupLData);
            formLayout = new FormLayout();
            formLayout.marginTop = 2;
            formLayout.marginBottom = 2;
            formLayout.marginHeight = 2;
            formLayout.marginRight = 2;
            formLayout.marginLeft = 2;
            this.timeZone.setLayout((Layout)formLayout);
            this.timeZone.setFont(SWTResourceManager.getFont(GDE.WIDGET_FONT_NAME, GDE.WIDGET_FONT_SIZE, 0));
            this.timeZone.setText(Messages.getString("GDE_MSGT0805"));
            this.dateTimeUtcButton = new Button((Composite)this.timeZone, 32);
            formData = new FormData();
            formData.left = new FormAttachment(0, 5);
            this.dateTimeUtcButton.setLayoutData((Object)formData);
            this.dateTimeUtcButton.setFont(SWTResourceManager.getFont(GDE.WIDGET_FONT_NAME, GDE.WIDGET_FONT_SIZE, 0));
            this.dateTimeUtcButton.setText(Messages.getString("GDE_MSGT0810"));
            this.dateTimeUtcButton.setToolTipText(Messages.getString("GDE_MSGT0811"));
            this.dateTimeUtcButton.setSelection(this.settings.isDateTimeUtc());
            this.dateTimeUtcButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent evt) {
                    log.log(Level.FINEST, "dateTimeUtcButton.widgetSelected, event=" + String.valueOf(evt));
                    SettingsDialog.this.settings.setDateTimeUtc(SettingsDialog.this.dateTimeUtcButton.getSelection());
                    SettingsDialog.this.application.getHistoExplorer().ifPresent(h -> h.updateHistoTabs(false, false, true));
                }
            });
            this.histoDisplay = new Group((Composite)this.histoDisplayOption, 0);
            RowData groupRData = new RowData();
            groupRData.width = 464;
            this.histoDisplay.setLayoutData((Object)groupRData);
            formLayout = new FormLayout();
            formLayout.marginTop = 2;
            formLayout.marginBottom = 2;
            formLayout.marginHeight = 2;
            formLayout.marginRight = 2;
            formLayout.marginLeft = 2;
            this.histoDisplay.setLayout((Layout)formLayout);
            this.histoDisplay.setFont(SWTResourceManager.getFont(GDE.WIDGET_FONT_NAME, GDE.WIDGET_FONT_SIZE, 0));
            this.histoDisplay.setText(Messages.getString("GDE_MSGT0847"));
            this.histoDisplaySettlements = new Button((Composite)this.histoDisplay, 32);
            formData = new FormData();
            formData.left = new FormAttachment(0, 7);
            this.histoDisplaySettlements.setLayoutData((Object)formData);
            this.histoDisplaySettlements.setFont(SWTResourceManager.getFont(GDE.WIDGET_FONT_NAME, GDE.WIDGET_FONT_SIZE, 0));
            this.histoDisplaySettlements.setText(Messages.getString("GDE_MSGT0788"));
            this.histoDisplaySettlements.setToolTipText(Messages.getString("GDE_MSGT0789"));
            this.histoDisplaySettlements.setSelection(this.settings.isDisplaySettlements());
            this.histoDisplaySettlements.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent evt) {
                    log.log(Level.FINEST, "histoDisplaySettlements.widgetSelected, event=" + String.valueOf(evt));
                    SettingsDialog.this.settings.setDisplaySettlements(SettingsDialog.this.histoDisplaySettlements.getSelection());
                    SettingsDialog.this.application.getHistoExplorer().ifPresent(h -> h.updateHistoTabs(false, false, true));
                }
            });
            this.histoDisplayScores = new Button((Composite)this.histoDisplay, 32);
            formData = new FormData();
            formData.left = new FormAttachment((Control)this.histoDisplaySettlements, 55);
            this.histoDisplayScores.setLayoutData((Object)formData);
            this.histoDisplayScores.setFont(SWTResourceManager.getFont(GDE.WIDGET_FONT_NAME, GDE.WIDGET_FONT_SIZE, 0));
            this.histoDisplayScores.setText(Messages.getString("GDE_MSGT0790"));
            this.histoDisplayScores.setToolTipText(Messages.getString("GDE_MSGT0791"));
            this.histoDisplayScores.setSelection(this.settings.isDisplayScores());
            this.histoDisplayScores.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent evt) {
                    log.log(Level.FINEST, "histoDisplayScores.widgetSelected, event=" + String.valueOf(evt));
                    SettingsDialog.this.settings.setDisplayScores(SettingsDialog.this.histoDisplayScores.getSelection());
                    SettingsDialog.this.application.getHistoExplorer().ifPresent(h -> h.updateHistoTabs(false, false, true));
                }
            });
            this.histoDisplayTags = new Button((Composite)this.histoDisplay, 32);
            formData = new FormData();
            formData.left = new FormAttachment((Control)this.histoDisplayScores, 55);
            this.histoDisplayTags.setLayoutData((Object)formData);
            this.histoDisplayTags.setFont(SWTResourceManager.getFont(GDE.WIDGET_FONT_NAME, GDE.WIDGET_FONT_SIZE, 0));
            this.histoDisplayTags.setText(Messages.getString("GDE_MSGT0746"));
            this.histoDisplayTags.setToolTipText(Messages.getString("GDE_MSGT0747"));
            this.histoDisplayTags.setSelection(this.settings.isDisplayTags());
            this.histoDisplayTags.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent evt) {
                    log.log(Level.FINEST, "histoDisplayTags.widgetSelected, event=" + String.valueOf(evt));
                    SettingsDialog.this.settings.setDisplayTags(SettingsDialog.this.histoDisplayTags.getSelection());
                    SettingsDialog.this.application.getHistoExplorer().ifPresent(h -> h.updateHistoTabs(false, false, true));
                }
            });
            this.histoScreening = new Group(this.histoComposite, 0);
            RowData histoScreeningGroupRData = new RowData();
            histoScreeningGroupRData.width = 233;
            this.histoScreening.setLayoutData((Object)histoScreeningGroupRData);
            FormLayout formLayout2 = new FormLayout();
            formLayout2.marginHeight = 2;
            formLayout2.marginRight = 2;
            formLayout2.marginLeft = 2;
            formLayout2.marginTop = 2;
            this.histoScreening.setLayout((Layout)formLayout2);
            this.histoScreening.setFont(SWTResourceManager.getFont(GDE.WIDGET_FONT_NAME, GDE.WIDGET_FONT_SIZE, 0));
            this.histoScreening.setText(Messages.getString("GDE_MSGT0809"));
            this.histoRetrospectLabel = new CLabel((Composite)this.histoScreening, 0);
            this.histoRetrospectLabel.setFont(SWTResourceManager.getFont(GDE.WIDGET_FONT_NAME, GDE.WIDGET_FONT_SIZE, 0));
            this.histoRetrospectLabel.setText(Messages.getString("GDE_MSGT0832"));
            this.histoRetrospectLabel.setToolTipText(Messages.getString("GDE_MSGT0833"));
            this.histoRetrospectMonths = new Text((Composite)this.histoScreening, 133120);
            FormData formData2 = new FormData();
            formData2.right = new FormAttachment(100, -5);
            this.histoRetrospectMonths.setLayoutData((Object)formData2);
            this.histoRetrospectMonths.setFont(SWTResourceManager.getFont(GDE.WIDGET_FONT_NAME, GDE.WIDGET_FONT_SIZE, 0));
            this.histoRetrospectMonths.setText(String.format("  %9d", this.settings.getRetrospectMonths()));
            this.histoRetrospectMonths.setToolTipText(Messages.getString("GDE_MSGT0833"));
            this.histoRetrospectMonths.addVerifyListener(new VerifyListener(){

                public void verifyText(VerifyEvent e) {
                    log.log(Level.FINEST, "" + StringHelper.verifyPortInput(e.text.trim()));
                    e.doit = StringHelper.verifyPortInput(e.text.trim());
                }
            });
            this.histoRetrospectMonths.addKeyListener((KeyListener)new KeyAdapter(){

                public void keyReleased(KeyEvent evt) {
                    log.log(Level.FINEST, "histoRetrospectMonths.keyReleased, event=" + String.valueOf(evt));
                    SettingsDialog.this.settings.setRetrospectMonths(SettingsDialog.this.histoRetrospectMonths.getText());
                }
            });
            this.histoRetrospectMonths.addVerifyListener(new VerifyListener(){

                public void verifyText(VerifyEvent e) {
                    if (!Character.isDigit(e.character) && e.keyCode != 8 && e.keyCode != 127) {
                        e.doit = false;
                    }
                }
            });
            this.histoRetrospectMonths.addFocusListener(new FocusListener(){
                private String trimmedInitialText;

                public void focusLost(FocusEvent e) {
                    log.log(Level.FINEST, "histoRetrospectMonths.focusLost, event=" + String.valueOf(e));
                    if (!this.trimmedInitialText.equals(SettingsDialog.this.histoRetrospectMonths.getText().trim())) {
                        log.log(Level.FINEST, "setText=" + SettingsDialog.this.settings.getRetrospectMonths());
                        SettingsDialog.this.histoRetrospectMonths.setText(String.format("  %9d", SettingsDialog.this.settings.getRetrospectMonths()));
                        SettingsDialog.this.application.getHistoExplorer().ifPresent(HistoExplorer::resetHisto);
                    }
                }

                public void focusGained(FocusEvent e) {
                    SettingsDialog.this.histoRetrospectMonths.setText(String.format("  %9d", SettingsDialog.this.settings.getRetrospectMonths()));
                    this.trimmedInitialText = SettingsDialog.this.histoRetrospectMonths.getText().trim();
                    log.log(Level.FINEST, "histoRetrospectMonths.focusGained, text=" + this.trimmedInitialText);
                }
            });
            this.histoSearchDataPathImports = new Button((Composite)this.histoScreening, 32);
            formData2 = new FormData();
            formData2.left = new FormAttachment(0, 5);
            formData2.top = new FormAttachment((Control)this.histoRetrospectMonths, 7);
            this.histoSearchDataPathImports.setLayoutData((Object)formData2);
            this.histoSearchDataPathImports.setFont(SWTResourceManager.getFont(GDE.WIDGET_FONT_NAME, GDE.WIDGET_FONT_SIZE, 0));
            this.histoSearchDataPathImports.setText(Messages.getString("GDE_MSGT0834"));
            this.histoSearchDataPathImports.setToolTipText(Messages.getString("GDE_MSGT0835"));
            this.histoSearchDataPathImports.setSelection(this.settings.getSearchDataPathImports());
            this.histoSearchDataPathImports.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent evt) {
                    log.log(Level.FINEST, "histoSearchDataPathImports.widgetSelected, event=" + String.valueOf(evt));
                    SettingsDialog.this.settings.setSearchDataPathImports(SettingsDialog.this.histoSearchDataPathImports.getSelection());
                    SettingsDialog.this.application.getHistoExplorer().ifPresent(HistoExplorer::resetHisto);
                }
            });
            this.histoForceObject = new Group((Composite)this.histoScreening, 0);
            RowLayout histoForceObjectGroupRLayout = new RowLayout(256);
            histoForceObjectGroupRLayout.marginTop = 2;
            histoForceObjectGroupRLayout.marginLeft = 2;
            this.histoForceObject.setLayout((Layout)histoForceObjectGroupRLayout);
            FormData formData3 = new FormData();
            formData3.top = new FormAttachment((Control)this.histoSearchDataPathImports, 7);
            formData3.width = 223;
            this.histoForceObject.setLayoutData((Object)formData3);
            this.histoForceObject.setFont(SWTResourceManager.getFont(GDE.WIDGET_FONT_NAME, GDE.WIDGET_FONT_SIZE, 0));
            this.histoForceObject.setText(Messages.getString("GDE_MSGT0794"));
            this.histoIgnoreLogObjectKey = new Button((Composite)this.histoForceObject, 16416);
            this.histoIgnoreLogObjectKey.setFont(SWTResourceManager.getFont(GDE.WIDGET_FONT_NAME, GDE.WIDGET_FONT_SIZE, 0));
            this.histoIgnoreLogObjectKey.setText(Messages.getString("GDE_MSGT0796"));
            this.histoIgnoreLogObjectKey.setToolTipText(Messages.getString("GDE_MSGT0797"));
            this.histoIgnoreLogObjectKey.setSelection(this.settings.getIgnoreLogObjectKey());
            this.histoIgnoreLogObjectKey.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent evt) {
                    log.log(Level.FINEST, "histoIgnoreLogObjectKey.widgetSelected, event=" + String.valueOf(evt));
                    SettingsDialog.this.settings.setIgnoreLogObjectKey(SettingsDialog.this.histoIgnoreLogObjectKey.getSelection());
                    SettingsDialog.this.application.getHistoExplorer().ifPresent(HistoExplorer::resetHisto);
                }
            });
            this.histoSubdirectoryLevelLabel = new CLabel((Composite)this.histoScreening, 0);
            formData2 = new FormData();
            formData2.top = new FormAttachment((Control)this.histoForceObject, 7);
            this.histoSubdirectoryLevelLabel.setLayoutData((Object)formData2);
            this.histoSubdirectoryLevelLabel.setFont(SWTResourceManager.getFont(GDE.WIDGET_FONT_NAME, GDE.WIDGET_FONT_SIZE, 0));
            this.histoSubdirectoryLevelLabel.setBounds(10, GDE.IS_MAC ? 8 : 20, 120, 20);
            this.histoSubdirectoryLevelLabel.setText(Messages.getString("GDE_MSGT0871"));
            this.histoSubdirectoryLevelLabel.setToolTipText(Messages.getString("GDE_MSGT0872"));
            this.histoSubdirectoryLevel = new CCombo((Composite)this.histoScreening, 2048);
            formData2 = new FormData();
            formData2.top = new FormAttachment((Control)this.histoForceObject, 5);
            formData2.right = new FormAttachment(100, -5);
            formData2.height = GDE.IS_LINUX ? 22 : (GDE.IS_MAC ? 20 : 18);
            formData2.width = GDE.IS_LINUX ? 60 : 40;
            this.histoSubdirectoryLevel.setLayoutData((Object)formData2);
            this.histoSubdirectoryLevel.setFont(SWTResourceManager.getFont(GDE.WIDGET_FONT_NAME, GDE.WIDGET_FONT_SIZE, 0));
            this.histoSubdirectoryLevel.setItems(new String[]{" 0", " 1", " 2", " 3", " 4", " 5"});
            this.histoSubdirectoryLevel.setText(" " + String.valueOf(this.settings.getSubDirectoryLevelMax()));
            this.histoSubdirectoryLevel.setToolTipText(Messages.getString("GDE_MSGT0872"));
            this.histoSubdirectoryLevel.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent evt) {
                    log.log(Level.FINEST, "histoSubdirectoryLevel.widgetSelected, event=" + String.valueOf(evt));
                    SettingsDialog.this.settings.setSubDirectoryLevelMax(SettingsDialog.this.histoSubdirectoryLevel.getText().trim());
                    SettingsDialog.this.application.getHistoExplorer().ifPresent(HistoExplorer::resetHisto);
                }
            });
            this.histoFileContents = new Group(this.histoComposite, 0);
            RowData histoFileContentsGroupRData = new RowData();
            histoFileContentsGroupRData.width = 223;
            this.histoFileContents.setLayoutData((Object)histoFileContentsGroupRData);
            FormLayout formLayout1 = new FormLayout();
            formLayout1.marginHeight = 2;
            formLayout1.marginRight = 2;
            formLayout1.marginLeft = 2;
            formLayout1.marginTop = 2;
            this.histoFileContents.setLayout((Layout)formLayout1);
            this.histoFileContents.setFont(SWTResourceManager.getFont(GDE.WIDGET_FONT_NAME, GDE.WIDGET_FONT_SIZE, 0));
            this.histoFileContents.setText(Messages.getString("GDE_MSGT0804"));
            this.histoSamplingLabel = new CLabel((Composite)this.histoFileContents, 0);
            formData2 = new FormData();
            this.histoSamplingLabel.setLayoutData((Object)formData2);
            this.histoSamplingLabel.setFont(SWTResourceManager.getFont(GDE.WIDGET_FONT_NAME, GDE.WIDGET_FONT_SIZE, 0));
            this.histoSamplingLabel.setBounds(10, GDE.IS_MAC ? 8 : 20, 120, 20);
            this.histoSamplingLabel.setText(Messages.getString("GDE_MSGT0807"));
            this.histoSamplingLabel.setToolTipText(Messages.getString("GDE_MSGT0808"));
            this.histoSamplingTimespan_ms = new CCombo((Composite)this.histoFileContents, 2048);
            formData2 = new FormData();
            formData2.top = new FormAttachment((Control)this.histoMaxDurationLabel, 5);
            formData2.right = new FormAttachment(100, -5);
            formData2.height = GDE.IS_LINUX ? 22 : (GDE.IS_MAC ? 20 : 18);
            formData2.width = GDE.IS_LINUX ? 80 : 70;
            this.histoSamplingTimespan_ms.setLayoutData((Object)formData2);
            this.histoSamplingTimespan_ms.setFont(SWTResourceManager.getFont(GDE.WIDGET_FONT_NAME, GDE.WIDGET_FONT_SIZE, 0));
            this.histoSamplingTimespan_ms.setItems(Settings.getSamplingTimespanValues());
            this.histoSamplingTimespan_ms.setText(String.valueOf((double)this.settings.getSamplingTimespan_ms() / 1000.0));
            this.histoSamplingTimespan_ms.setToolTipText(Messages.getString("GDE_MSGT0808"));
            this.histoSamplingTimespan_ms.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent evt) {
                    log.log(Level.FINEST, "histoSamplingTimespan_ms.widgetSelected, event=" + String.valueOf(evt));
                    SettingsDialog.this.settings.setSamplingTimespan_ms(SettingsDialog.this.histoSamplingTimespan_ms.getText().trim());
                    SettingsDialog.this.application.getHistoExplorer().ifPresent(HistoExplorer::resetHisto);
                }
            });
            this.histoChannelMix = new Button((Composite)this.histoFileContents, 32);
            formData2 = new FormData();
            formData2.left = new FormAttachment(0, 5);
            formData2.top = new FormAttachment((Control)this.histoSamplingLabel, 7);
            this.histoChannelMix.setLayoutData((Object)formData2);
            this.histoChannelMix.setFont(SWTResourceManager.getFont(GDE.WIDGET_FONT_NAME, GDE.WIDGET_FONT_SIZE, 0));
            this.histoChannelMix.setText(Messages.getString("GDE_MSGT0826"));
            this.histoChannelMix.setToolTipText(Messages.getString("GDE_MSGT0827"));
            this.histoChannelMix.setSelection(this.settings.isChannelMix());
            this.histoChannelMix.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent evt) {
                    log.log(Level.FINEST, "histoChannelMix.widgetSelected, event=" + String.valueOf(evt));
                    SettingsDialog.this.settings.setChannelMix(SettingsDialog.this.histoChannelMix.getSelection());
                    SettingsDialog.this.application.getHistoExplorer().ifPresent(HistoExplorer::resetHisto);
                }
            });
            this.miscTabItem = new CTabItem(this.settingsTabFolder, 0);
            this.miscTabItem.setFont(SWTResourceManager.getFont(GDE.WIDGET_FONT_NAME, GDE.WIDGET_FONT_SIZE, 0));
            this.miscTabItem.setText(Messages.getString("GDE_MSGT0691"));
            this.miscComposite = new Composite((Composite)this.settingsTabFolder, 0);
            this.miscTabItem.setControl((Control)this.miscComposite);
            RowLayout composite1Layout = new RowLayout(512);
            this.miscComposite.setLayout((Layout)composite1Layout);
            this.fontSizeGroup = new Group(this.miscComposite, 0);
            RowLayout fontSizeGroupLayout = new RowLayout(256);
            fontSizeGroupLayout.center = true;
            fontSizeGroupLayout.marginTop = 2;
            fontSizeGroupLayout.marginWidth = 20;
            fontSizeGroupLayout.spacing = 5;
            this.fontSizeGroup.setLayout((Layout)fontSizeGroupLayout);
            RowData fontSizeGroupLData = new RowData();
            fontSizeGroupLData.width = 478;
            this.fontSizeGroup.setLayoutData((Object)fontSizeGroupLData);
            this.fontSizeGroup.setFont(SWTResourceManager.getFont(GDE.WIDGET_FONT_NAME, GDE.WIDGET_FONT_SIZE, 0));
            this.fontSizeGroup.setText(Messages.getString("GDE_MSGT0727"));
            this.fontSizeGroup.setToolTipText(Messages.getString("GDE_MSGT0953"));
            this.fontSizeCorrectionSlider = new ParameterConfigControl((Composite)this.fontSizeGroup, this.fontCorrection, 0, "", String.format("%s / 10", Messages.getString("GDE_MSGT0276")), 140, "", 0, true, 30, 250, 10, GDE.IS_LINUX ? 22 : 18);
            this.fontSizeCorrectionSlider.setSliderSelection((int)(this.settings.getFontDisplayDensityAdaptionFactor() * 10.0));
            this.fontSizeGroup.addListener(13, new Listener(){

                public void handleEvent(Event evt) {
                    SettingsDialog.this.settings.setFontDisplayDensityAdaptionFactor((double)SettingsDialog.this.fontCorrection[0] / 10.0);
                }
            });
            this.fontSizeGroup.layout();
            this.graphicsView = new Group(this.miscComposite, 0);
            RowLayout chargerSpecialsLayout = new RowLayout(256);
            chargerSpecialsLayout.center = true;
            chargerSpecialsLayout.marginTop = 2;
            chargerSpecialsLayout.marginWidth = 20;
            chargerSpecialsLayout.spacing = 5;
            this.graphicsView.setLayout((Layout)chargerSpecialsLayout);
            RowData graphicsViewLData = new RowData();
            graphicsViewLData.width = 478;
            this.graphicsView.setLayoutData((Object)graphicsViewLData);
            this.graphicsView.setFont(SWTResourceManager.getFont(GDE.WIDGET_FONT_NAME, GDE.WIDGET_FONT_SIZE, 0));
            this.graphicsView.setText(Messages.getString("GDE_MSGT0692"));
            Label label = new Label((Composite)this.graphicsView, 16384);
            RowData labelLData = new RowData();
            labelLData.width = 460;
            labelLData.height = GDE.IS_LINUX ? 22 : 18;
            label.setLayoutData((Object)labelLData);
            label.setFont(SWTResourceManager.getFont(GDE.WIDGET_FONT_NAME, GDE.WIDGET_FONT_SIZE + 1, 0));
            label.setText(Messages.getString("GDE_MSGT0693"));
            this.drawScaleInRecordColorButton = new Button((Composite)this.graphicsView, 32);
            this.drawScaleInRecordColorButton.setFont(SWTResourceManager.getFont(GDE.WIDGET_FONT_NAME, GDE.WIDGET_FONT_SIZE, 0));
            this.drawScaleInRecordColorButton.setText(Messages.getString("GDE_MSGT0695"));
            this.drawScaleInRecordColorButton.setToolTipText(Messages.getString("GDE_MSGT0694"));
            this.drawScaleInRecordColorButton.setSelection(this.settings.isDrawScaleInRecordColor());
            RowData createLauncerButtonLData = new RowData();
            createLauncerButtonLData.width = 460;
            createLauncerButtonLData.height = GDE.IS_LINUX ? 22 : 18;
            this.drawScaleInRecordColorButton.setLayoutData((Object)createLauncerButtonLData);
            this.drawScaleInRecordColorButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent evt) {
                    log.log(Level.FINEST, "drawScaleInRecordColorButton.widgetSelected, event=" + String.valueOf(evt));
                    SettingsDialog.this.settings.setDrawScaleInRecordColor(SettingsDialog.this.drawScaleInRecordColorButton.getSelection());
                    SettingsDialog.this.application.getHistoExplorer().ifPresent(h -> h.updateHistoTabs(false, false, true));
                }
            });
            this.drawNameInRecordColorButton = new Button((Composite)this.graphicsView, 32);
            this.drawNameInRecordColorButton.setFont(SWTResourceManager.getFont(GDE.WIDGET_FONT_NAME, GDE.WIDGET_FONT_SIZE, 0));
            this.drawNameInRecordColorButton.setText(Messages.getString("GDE_MSGT0696"));
            this.drawNameInRecordColorButton.setToolTipText(Messages.getString("GDE_MSGT0694"));
            this.drawNameInRecordColorButton.setSelection(this.settings.isDrawNameInRecordColor());
            createLauncerButtonLData = new RowData();
            createLauncerButtonLData.width = 460;
            createLauncerButtonLData.height = GDE.IS_LINUX ? 22 : 18;
            this.drawNameInRecordColorButton.setLayoutData((Object)createLauncerButtonLData);
            this.drawNameInRecordColorButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent evt) {
                    log.log(Level.FINEST, "drawNameInRecordColorButton.widgetSelected, event=" + String.valueOf(evt));
                    SettingsDialog.this.settings.setDrawNameInRecordColor(SettingsDialog.this.drawNameInRecordColorButton.getSelection());
                    SettingsDialog.this.application.getHistoExplorer().ifPresent(h -> h.updateHistoTabs(false, false, true));
                }
            });
            this.drawNumbersInRecordColorButton = new Button((Composite)this.graphicsView, 32);
            this.drawNumbersInRecordColorButton.setFont(SWTResourceManager.getFont(GDE.WIDGET_FONT_NAME, GDE.WIDGET_FONT_SIZE, 0));
            this.drawNumbersInRecordColorButton.setText(Messages.getString("GDE_MSGT0697"));
            this.drawNumbersInRecordColorButton.setToolTipText(Messages.getString("GDE_MSGT0694"));
            this.drawNumbersInRecordColorButton.setSelection(this.settings.isDrawNumbersInRecordColor());
            createLauncerButtonLData = new RowData();
            createLauncerButtonLData.width = 460;
            createLauncerButtonLData.height = GDE.IS_LINUX ? 22 : 18;
            this.drawNumbersInRecordColorButton.setLayoutData((Object)createLauncerButtonLData);
            this.drawNumbersInRecordColorButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent evt) {
                    log.log(Level.FINEST, "drawNumbersInRecordColorButton.widgetSelected, event=" + String.valueOf(evt));
                    SettingsDialog.this.settings.setDrawNumbersInRecordColor(SettingsDialog.this.drawNumbersInRecordColorButton.getSelection());
                    SettingsDialog.this.application.getHistoExplorer().ifPresent(h -> h.updateHistoTabs(false, false, true));
                }
            });
            this.useMeasurementPopUpButton = new Button((Composite)this.graphicsView, 32);
            this.useMeasurementPopUpButton.setFont(SWTResourceManager.getFont(GDE.WIDGET_FONT_NAME, GDE.WIDGET_FONT_SIZE, 0));
            this.useMeasurementPopUpButton.setText(Messages.getString("GDE_MSGT0983"));
            String popUpMessage = GDE.IS_LINUX ? Messages.getString("GDE_MSGT0984") + Messages.getString("GDE_MSGT0985") : Messages.getString("GDE_MSGT0984");
            this.useMeasurementPopUpButton.setToolTipText(popUpMessage);
            this.useMeasurementPopUpButton.setSelection(this.settings.isUseMeasurementPopUp());
            RowData createLauncerButtonLData2 = new RowData();
            createLauncerButtonLData2.width = 460;
            createLauncerButtonLData2.height = GDE.IS_LINUX ? 22 : 18;
            this.useMeasurementPopUpButton.setLayoutData((Object)createLauncerButtonLData2);
            this.useMeasurementPopUpButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent evt) {
                    log.log(Level.FINEST, "useMeasurementPopUpButton.widgetSelected, event=" + String.valueOf(evt));
                    SettingsDialog.this.settings.setUseMeasurementPopUp(SettingsDialog.this.useMeasurementPopUpButton.getSelection());
                    SettingsDialog.this.application.getHistoExplorer().ifPresent(h -> h.updateHistoTabs(false, false, true));
                }
            });
            this.draw10TicksPerRecordButton = new Button((Composite)this.graphicsView, 32);
            this.draw10TicksPerRecordButton.setFont(SWTResourceManager.getFont(GDE.WIDGET_FONT_NAME, GDE.WIDGET_FONT_SIZE, 0));
            this.draw10TicksPerRecordButton.setText(Messages.getString("GDE_MSGT0968"));
            this.draw10TicksPerRecordButton.setToolTipText(Messages.getString("GDE_MSGT0969"));
            this.draw10TicksPerRecordButton.setSelection(this.settings.isDraw10TicksPerRecord());
            createLauncerButtonLData = new RowData();
            createLauncerButtonLData.width = 460;
            createLauncerButtonLData.height = GDE.IS_LINUX ? 22 : 18;
            this.draw10TicksPerRecordButton.setLayoutData((Object)createLauncerButtonLData);
            this.draw10TicksPerRecordButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent evt) {
                    log.log(Level.FINEST, "draw10TicksPerRecord.widgetSelected, event=" + String.valueOf(evt));
                    SettingsDialog.this.settings.setDraw10TicksPerRecord(SettingsDialog.this.draw10TicksPerRecordButton.getSelection());
                    if (SettingsDialog.this.draw10TicksPerRecordButton.getSelection()) {
                        SettingsDialog.this.application.updateAllTabs(false);
                    } else if (SettingsDialog.this.application.getActiveRecordSet() != null) {
                        SettingsDialog.this.application.getActiveChannel().applyTemplateScaleEndpoints(SettingsDialog.this.application.getActiveRecordSet().getName());
                    }
                    SettingsDialog.this.application.getHistoExplorer().ifPresent(h -> h.updateHistoTabs(false, false, true));
                }
            });
            label = new Label((Composite)this.graphicsView, 16384);
            labelLData = new RowData();
            labelLData.width = 460;
            labelLData.height = GDE.IS_LINUX ? 22 : 18;
            label.setLayoutData((Object)labelLData);
            label.setFont(SWTResourceManager.getFont(GDE.WIDGET_FONT_NAME, GDE.WIDGET_FONT_SIZE + 1, 0));
            label.setText(Messages.getString("GDE_MSGT0699"));
            this.addChannelConfigNameCurveCompareButton = new Button((Composite)this.graphicsView, 32);
            this.addChannelConfigNameCurveCompareButton.setFont(SWTResourceManager.getFont(GDE.WIDGET_FONT_NAME, GDE.WIDGET_FONT_SIZE, 0));
            this.addChannelConfigNameCurveCompareButton.setText(Messages.getString("GDE_MSGT0700"));
            this.addChannelConfigNameCurveCompareButton.setToolTipText(Messages.getString("GDE_MSGT0701"));
            this.addChannelConfigNameCurveCompareButton.setSelection(this.settings.isCurveCompareChannelConfigName());
            createLauncerButtonLData = new RowData();
            createLauncerButtonLData.width = 460;
            createLauncerButtonLData.height = GDE.IS_LINUX ? 22 : 18;
            this.addChannelConfigNameCurveCompareButton.setLayoutData((Object)createLauncerButtonLData);
            this.addChannelConfigNameCurveCompareButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent evt) {
                    log.log(Level.FINEST, "addChannelConfigNameCurveCompareButton.widgetSelected, event=" + String.valueOf(evt));
                    SettingsDialog.this.settings.setCurveCompareChannelConfigName(SettingsDialog.this.addChannelConfigNameCurveCompareButton.getSelection());
                }
            });
            this.graphicsView.layout();
            this.dataTableGroup = new Group(this.miscComposite, 0);
            chargerSpecialsLayout = new RowLayout(256);
            chargerSpecialsLayout.center = true;
            chargerSpecialsLayout.marginTop = 2;
            chargerSpecialsLayout.marginWidth = 20;
            chargerSpecialsLayout.spacing = 5;
            this.dataTableGroup.setLayout((Layout)chargerSpecialsLayout);
            RowData dataTableGroupLData = new RowData();
            dataTableGroupLData.width = 478;
            this.dataTableGroup.setLayoutData((Object)dataTableGroupLData);
            this.dataTableGroup.setFont(SWTResourceManager.getFont(GDE.WIDGET_FONT_NAME, GDE.WIDGET_FONT_SIZE, 0));
            this.dataTableGroup.setText(Messages.getString("GDE_MSGT0703"));
            this.partialDataTableButton = new Button((Composite)this.dataTableGroup, 32);
            this.partialDataTableButton.setFont(SWTResourceManager.getFont(GDE.WIDGET_FONT_NAME, GDE.WIDGET_FONT_SIZE, 0));
            this.partialDataTableButton.setText(Messages.getString("GDE_MSGT0704"));
            this.partialDataTableButton.setToolTipText(Messages.getString("GDE_MSGT0705"));
            this.partialDataTableButton.setSelection(this.settings.isPartialDataTable());
            createLauncerButtonLData = new RowData();
            createLauncerButtonLData.width = 400;
            createLauncerButtonLData.height = GDE.IS_LINUX ? 22 : 18;
            this.partialDataTableButton.setLayoutData((Object)createLauncerButtonLData);
            this.partialDataTableButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent evt) {
                    log.log(Level.FINEST, "partialDataTableButton.widgetSelected, event=" + String.valueOf(evt));
                    SettingsDialog.this.settings.setPartialDataTable(SettingsDialog.this.partialDataTableButton.getSelection());
                    SettingsDialog.this.application.updateAllTabs(true, false);
                    SettingsDialog.this.application.getHistoExplorer().ifPresent(h -> h.updateHistoTabs(false, false, true));
                }
            });
            this.dataTableGroup.layout();
            this.kmzExportGroup = new Group(this.miscComposite, 0);
            RowLayout kmzExportGroupLayout = new RowLayout(256);
            kmzExportGroupLayout.center = true;
            kmzExportGroupLayout.marginTop = 2;
            kmzExportGroupLayout.marginWidth = 20;
            kmzExportGroupLayout.spacing = 5;
            this.kmzExportGroup.setLayout((Layout)kmzExportGroupLayout);
            RowData kmzExportGroupLData = new RowData();
            kmzExportGroupLData.width = 478;
            this.kmzExportGroup.setLayoutData((Object)kmzExportGroupLData);
            this.kmzExportGroup.setFont(SWTResourceManager.getFont(GDE.WIDGET_FONT_NAME, GDE.WIDGET_FONT_SIZE, 0));
            this.kmzExportGroup.setText("KML/KMZ Export");
            this.kmzExportTimeStepSlider = new ParameterConfigControl((Composite)this.kmzExportGroup, this.exportTimeStep_ms, 0, "", Messages.getString("GDE_MSGT0702"), 80, "[ms]", 40, true, 40, 250, 10, 1000);
            this.kmzExportTimeStepSlider.setSliderSelection(this.settings.getKmzExportTimeStep_ms());
            this.kmzExportGroup.addListener(13, new Listener(){

                public void handleEvent(Event evt) {
                    SettingsDialog.this.settings.setKmzExportTimeStep_ms(SettingsDialog.this.exportTimeStep_ms[0]);
                }
            });
            this.kmzExportGroup.layout();
            this.chargerSpecials = new Group(this.miscComposite, 0);
            chargerSpecialsLayout = new RowLayout(256);
            chargerSpecialsLayout.center = true;
            chargerSpecialsLayout.marginTop = 2;
            chargerSpecialsLayout.marginWidth = 20;
            chargerSpecialsLayout.spacing = 5;
            this.chargerSpecials.setLayout((Layout)chargerSpecialsLayout);
            RowData chargerSpecialsLData = new RowData();
            chargerSpecialsLData.width = 478;
            this.chargerSpecials.setLayoutData((Object)chargerSpecialsLData);
            this.chargerSpecials.setFont(SWTResourceManager.getFont(GDE.WIDGET_FONT_NAME, GDE.WIDGET_FONT_SIZE, 0));
            this.chargerSpecials.setText(Messages.getString("GDE_MSGT0698"));
            this.blankChargeDischargeButton = new Button((Composite)this.chargerSpecials, 32);
            this.blankChargeDischargeButton.setFont(SWTResourceManager.getFont(GDE.WIDGET_FONT_NAME, GDE.WIDGET_FONT_SIZE, 0));
            this.blankChargeDischargeButton.setText(Messages.getString("GDE_MSGT0688"));
            this.blankChargeDischargeButton.setToolTipText(Messages.getString("GDE_MSGT0689"));
            this.blankChargeDischargeButton.setSelection(this.settings.isReduceChargeDischarge());
            createLauncerButtonLData = new RowData();
            createLauncerButtonLData.width = 400;
            createLauncerButtonLData.height = GDE.IS_LINUX ? 22 : 18;
            this.blankChargeDischargeButton.setLayoutData((Object)createLauncerButtonLData);
            this.blankChargeDischargeButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent evt) {
                    log.log(Level.FINEST, "blankChargeDischargeButton.widgetSelected, event=" + String.valueOf(evt));
                    SettingsDialog.this.settings.setReduceChargeDischarge(SettingsDialog.this.blankChargeDischargeButton.getSelection());
                    if (SettingsDialog.this.settings.isContinuousRecordSet() && SettingsDialog.this.settings.isReduceChargeDischarge() && SettingsDialog.this.application.getActiveDevice().getName().startsWith("MC3000") && SettingsDialog.this.application.getActiveDevice().getName().startsWith("Q200")) {
                        SettingsDialog.this.application.openMessageDialogAsync(Messages.getString("GDE_MSGI0059"));
                    }
                }
            });
            this.continiousRecordSetButton = new Button((Composite)this.chargerSpecials, 32);
            this.continiousRecordSetButton.setFont(SWTResourceManager.getFont(GDE.WIDGET_FONT_NAME, GDE.WIDGET_FONT_SIZE, 0));
            this.continiousRecordSetButton.setText(Messages.getString("GDE_MSGT0686"));
            this.continiousRecordSetButton.setToolTipText(Messages.getString("GDE_MSGT0687"));
            this.continiousRecordSetButton.setSelection(this.settings.isContinuousRecordSet());
            createLauncerButtonLData = new RowData();
            createLauncerButtonLData.width = 400;
            createLauncerButtonLData.height = GDE.IS_LINUX ? 22 : 18;
            this.continiousRecordSetButton.setLayoutData((Object)createLauncerButtonLData);
            this.continiousRecordSetButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent evt) {
                    log.log(Level.FINEST, "continiousRecordSetButton.widgetSelected, event=" + String.valueOf(evt));
                    SettingsDialog.this.settings.setContinuousRecordSet(SettingsDialog.this.continiousRecordSetButton.getSelection());
                    if (SettingsDialog.this.settings.isContinuousRecordSet() && SettingsDialog.this.settings.isReduceChargeDischarge() && SettingsDialog.this.application.getActiveDevice().getName().startsWith("MC3000") && SettingsDialog.this.application.getActiveDevice().getName().startsWith("Q200")) {
                        SettingsDialog.this.application.openMessageDialogAsync(Messages.getString("GDE_MSGI0059"));
                    }
                }
            });
            this.startCommunicationAfterStartupButton = new Button((Composite)this.chargerSpecials, 32);
            this.startCommunicationAfterStartupButton.setFont(SWTResourceManager.getFont(GDE.WIDGET_FONT_NAME, GDE.WIDGET_FONT_SIZE, 0));
            this.startCommunicationAfterStartupButton.setText(Messages.getString("GDE_MSGT0690"));
            this.startCommunicationAfterStartupButton.setToolTipText(Messages.getString("GDE_MSGT0970"));
            this.startCommunicationAfterStartupButton.setSelection(this.settings.isStartDeviceCommunicationAfterStartup());
            createLauncerButtonLData = new RowData();
            createLauncerButtonLData.width = 400;
            createLauncerButtonLData.height = GDE.IS_LINUX ? 22 : 18;
            this.startCommunicationAfterStartupButton.setLayoutData((Object)createLauncerButtonLData);
            this.startCommunicationAfterStartupButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent evt) {
                    log.log(Level.FINEST, "startCommunicationAfterStartupButton.widgetSelected, event=" + String.valueOf(evt));
                    SettingsDialog.this.settings.setStartDeviceCommunicationAfterStartup(SettingsDialog.this.startCommunicationAfterStartupButton.getSelection());
                }
            });
            this.chargerSpecials.layout();
            this.osMiscTabItem = new CTabItem(this.settingsTabFolder, 0);
            this.osMiscTabItem.setFont(SWTResourceManager.getFont(GDE.WIDGET_FONT_NAME, GDE.WIDGET_FONT_SIZE, 0));
            this.osMiscTabItem.setText(Messages.getString("GDE_MSGT0303"));
            this.osMiscComposite = new Composite((Composite)this.settingsTabFolder, 0);
            this.osMiscTabItem.setControl((Control)this.osMiscComposite);
            composite1Layout = new FillLayout(512);
            this.osMiscComposite.setLayout((Layout)composite1Layout);
            this.desktopLauncher = new Group(this.osMiscComposite, 0);
            RowLayout desktopLauncherLayout = new RowLayout(256);
            desktopLauncherLayout.center = true;
            desktopLauncherLayout.marginTop = 20;
            desktopLauncherLayout.marginLeft = 55;
            desktopLauncherLayout.spacing = 10;
            this.desktopLauncher.setLayout((Layout)desktopLauncherLayout);
            this.desktopLauncher.setFont(SWTResourceManager.getFont(GDE.WIDGET_FONT_NAME, GDE.WIDGET_FONT_SIZE, 0));
            this.desktopLauncher.setText(Messages.getString("GDE_MSGT0362"));
            this.createLauncherButton = new Button((Composite)this.desktopLauncher, 0x1000008);
            this.createLauncherButton.setFont(SWTResourceManager.getFont(GDE.WIDGET_FONT_NAME, GDE.WIDGET_FONT_SIZE, 0));
            this.createLauncherButton.setText(Messages.getString("GDE_MSGT0363"));
            RowData createLauncerButtonLData3 = new RowData();
            createLauncerButtonLData3.width = 180;
            createLauncerButtonLData3.height = 30;
            this.createLauncherButton.setLayoutData((Object)createLauncerButtonLData3);
            this.createLauncherButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent evt) {
                    log.log(Level.FINEST, "createLauncerButton.widgetSelected, event=" + String.valueOf(evt));
                    OperatingSystemHelper.createDesktopLink();
                }
            });
            this.removeLauncherButton = new Button((Composite)this.desktopLauncher, 0x1000008);
            this.removeLauncherButton.setFont(SWTResourceManager.getFont(GDE.WIDGET_FONT_NAME, GDE.WIDGET_FONT_SIZE, 0));
            this.removeLauncherButton.setText(Messages.getString("GDE_MSGT0364"));
            RowData removeLauncherButtonLData = new RowData();
            removeLauncherButtonLData.width = 180;
            removeLauncherButtonLData.height = 30;
            this.removeLauncherButton.setLayoutData((Object)removeLauncherButtonLData);
            this.removeLauncherButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent evt) {
                    log.log(Level.FINEST, "removeLauncherButton.widgetSelected, event=" + String.valueOf(evt));
                    OperatingSystemHelper.removeDesktopLink();
                }
            });
            if (GDE.IS_MAC) {
                this.createLauncherButton.setEnabled(false);
                this.removeLauncherButton.setEnabled(false);
            }
            this.shellMimeType = new Group(this.osMiscComposite, 0);
            RowLayout shellMimeTypeLayout = new RowLayout(256);
            shellMimeTypeLayout.center = true;
            shellMimeTypeLayout.marginTop = 20;
            shellMimeTypeLayout.marginLeft = 55;
            shellMimeTypeLayout.spacing = 10;
            this.shellMimeType.setLayout((Layout)shellMimeTypeLayout);
            this.shellMimeType.setFont(SWTResourceManager.getFont(GDE.WIDGET_FONT_NAME, GDE.WIDGET_FONT_SIZE, 0));
            this.shellMimeType.setText(Messages.getString("GDE_MSGT0365"));
            this.assocMimeTypeButton = new Button((Composite)this.shellMimeType, 0x1000008);
            this.assocMimeTypeButton.setFont(SWTResourceManager.getFont(GDE.WIDGET_FONT_NAME, GDE.WIDGET_FONT_SIZE, 0));
            this.assocMimeTypeButton.setText(Messages.getString("GDE_MSGT0366"));
            RowData assocMimeTypeButtonLData = new RowData();
            assocMimeTypeButtonLData.width = 180;
            assocMimeTypeButtonLData.height = 30;
            this.assocMimeTypeButton.setLayoutData((Object)assocMimeTypeButtonLData);
            this.assocMimeTypeButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent evt) {
                    log.log(Level.FINEST, "assocMimeTypeButton.widgetSelected, event=" + String.valueOf(evt));
                    OperatingSystemHelper.registerApplication();
                }
            });
            this.removeMimeAssocButton = new Button((Composite)this.shellMimeType, 0x1000008);
            this.removeMimeAssocButton.setFont(SWTResourceManager.getFont(GDE.WIDGET_FONT_NAME, GDE.WIDGET_FONT_SIZE, 0));
            this.removeMimeAssocButton.setText(Messages.getString("GDE_MSGT0367"));
            RowData removeMimeAssocButtonLData = new RowData();
            removeMimeAssocButtonLData.width = 180;
            removeMimeAssocButtonLData.height = 30;
            this.removeMimeAssocButton.setLayoutData((Object)removeMimeAssocButtonLData);
            this.removeMimeAssocButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent evt) {
                    log.log(Level.FINEST, "removeMimeAssocButton.widgetSelected, event=" + String.valueOf(evt));
                    OperatingSystemHelper.deregisterApplication();
                }
            });
            if (GDE.IS_MAC) {
                this.assocMimeTypeButton.setEnabled(false);
                this.removeMimeAssocButton.setEnabled(false);
            }
            this.objectKeyGroup = new Group(this.osMiscComposite, 0);
            RowLayout objectKeyGroupLayout = new RowLayout(256);
            objectKeyGroupLayout.center = true;
            objectKeyGroupLayout.marginTop = 5;
            objectKeyGroupLayout.marginLeft = 55;
            objectKeyGroupLayout.spacing = 10;
            this.objectKeyGroup.setLayout((Layout)objectKeyGroupLayout);
            this.objectKeyGroup.setFont(SWTResourceManager.getFont(GDE.WIDGET_FONT_NAME, GDE.WIDGET_FONT_SIZE, 0));
            this.objectKeyGroup.setText(Messages.getString("GDE_MSGT0206"));
            this.scanObjectKeysButton = new Button((Composite)this.objectKeyGroup, 0x1000008);
            this.scanObjectKeysButton.setFont(SWTResourceManager.getFont(GDE.WIDGET_FONT_NAME, GDE.WIDGET_FONT_SIZE, 0));
            this.scanObjectKeysButton.setText(Messages.getString("GDE_MSGT0207"));
            this.scanObjectKeysButton.setToolTipText(Messages.getString("GDE_MSGT0208", new Object[]{this.settings.getDataFilePath()}));
            RowData scanObjectKeysButtonLData = new RowData();
            scanObjectKeysButtonLData.width = 180;
            scanObjectKeysButtonLData.height = 30;
            this.scanObjectKeysButton.setLayoutData((Object)scanObjectKeysButtonLData);
            this.scanObjectKeysButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent evt) {
                    log.log(Level.FINEST, "scanObjectKeysButton.widgetSelected, event=" + String.valueOf(evt));
                    ObjectKeyCompliance.rebuildObjectKeys();
                }
            });
            this.cleanObjectReferecesButton = new Button((Composite)this.objectKeyGroup, 0x1000008);
            this.cleanObjectReferecesButton.setFont(SWTResourceManager.getFont(GDE.WIDGET_FONT_NAME, GDE.WIDGET_FONT_SIZE, 0));
            this.cleanObjectReferecesButton.setText(Messages.getString("GDE_MSGT0220"));
            this.cleanObjectReferecesButton.setToolTipText(Messages.getString("GDE_MSGT0221", new Object[]{this.settings.getDataFilePath()}));
            RowData cleanObjectReferecesButtonLData = new RowData();
            cleanObjectReferecesButtonLData.width = 180;
            cleanObjectReferecesButtonLData.height = 30;
            this.cleanObjectReferecesButton.setLayoutData((Object)cleanObjectReferecesButtonLData);
            this.cleanObjectReferecesButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent evt) {
                    log.log(Level.FINEST, "cleanObjectReferecesButton.widgetSelected, event=" + String.valueOf(evt));
                    new Thread(){

                        @Override
                        public void run() {
                            ObjectKeyScanner.cleanFileLinks();
                            if (SettingsDialog.this.getParent().isDisposed()) {
                                SettingsDialog.this.application.openMessageDialogAsync(Messages.getString("GDE_MSGI0039"));
                            } else {
                                SettingsDialog.this.application.openMessageDialogAsync(SettingsDialog.this.getParent(), Messages.getString("GDE_MSGI0039"));
                            }
                        }
                    }.start();
                }
            });
            this.createObjectsFromDirectoriesButton = new Button((Composite)this.objectKeyGroup, 0x1000008);
            this.createObjectsFromDirectoriesButton.setFont(SWTResourceManager.getFont(GDE.WIDGET_FONT_NAME, GDE.WIDGET_FONT_SIZE, 0));
            this.createObjectsFromDirectoriesButton.setText(Messages.getString("GDE_MSGT0836"));
            Object toolTipExtension = String.format("\n%s \"%s\"", Messages.getString("GDE_MSGT0523"), this.settings.getDataFilePath());
            String dataPathLines = Arrays.stream(Settings.getInstance().getDataFoldersCsv().split(",")).map(String::trim).filter(s -> !s.isEmpty()).collect(Collectors.joining("\",\n  \""));
            if (!dataPathLines.isEmpty()) {
                toolTipExtension = (String)toolTipExtension + String.format("\n%s \"%s\"", Messages.getString("GDE_MSGT0824"), dataPathLines);
            }
            if (!(importPathLines = Arrays.stream(Settings.getInstance().getImportFoldersCsv().split(",")).map(String::trim).filter(s -> !s.isEmpty()).collect(Collectors.joining("\",\n  \""))).isEmpty()) {
                toolTipExtension = (String)toolTipExtension + String.format("\n%s \"%s\"", Messages.getString("GDE_MSGT0825"), importPathLines);
            }
            this.createObjectsFromDirectoriesButton.setToolTipText(Messages.getString("GDE_MSGT0837", new Object[]{toolTipExtension}));
            RowData createObjectsFromDirectoriesButtonLData = new RowData();
            createObjectsFromDirectoriesButtonLData.width = 180;
            createObjectsFromDirectoriesButtonLData.height = 30;
            this.createObjectsFromDirectoriesButton.setLayoutData((Object)createObjectsFromDirectoriesButtonLData);
            this.createObjectsFromDirectoriesButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent evt) {
                    log.log(Level.FINEST, "createObjectsFromDirectoriesButton.widgetSelected, event=", evt);
                    DeviceConfigurations devices = DataExplorer.getInstance().getDeviceSelectionDialog().getDeviceConfigurations();
                    Set<String> objectCandidates = ObjectKeyCompliance.defineObjectKeyNovelties(devices.getAllConfigurations());
                    if (objectCandidates.size() > 0) {
                        if (32 == SettingsDialog.this.application.openOkCancelMessageDialog(Messages.getString("GDE_MSGI0069", new Object[]{objectCandidates.stream().sorted().collect(Collectors.toList()).toString()}))) {
                            ObjectKeyCompliance.addObjectKeys(objectCandidates);
                        }
                    } else {
                        SettingsDialog.this.application.openMessageDialog(Messages.getString("GDE_MSGI0070"));
                    }
                }
            });
            this.histoToolsGroup = new Group(this.osMiscComposite, 0);
            RowLayout histoToolsGroupLayout = new RowLayout(256);
            histoToolsGroupLayout.center = true;
            histoToolsGroupLayout.marginTop = 20;
            histoToolsGroupLayout.marginLeft = 55;
            histoToolsGroupLayout.spacing = 10;
            this.histoToolsGroup.setLayout((Layout)histoToolsGroupLayout);
            this.histoToolsGroup.setFont(SWTResourceManager.getFont(GDE.WIDGET_FONT_NAME, GDE.WIDGET_FONT_SIZE, 0));
            this.histoToolsGroup.setText(Messages.getString("GDE_MSGT0738"));
            this.clearHistoCacheButton = new Button((Composite)this.histoToolsGroup, 0x1000008);
            this.clearHistoCacheButton.setFont(SWTResourceManager.getFont(GDE.WIDGET_FONT_NAME, GDE.WIDGET_FONT_SIZE, 0));
            this.clearHistoCacheButton.setText(Messages.getString("GDE_MSGT0829"));
            this.clearHistoCacheButton.setToolTipText(Messages.getString("GDE_MSGT0830", new Object[]{Paths.get(GDE.APPL_HOME_PATH, "Cache").toString()}));
            RowData clearHistoCacheButtonLData = new RowData();
            clearHistoCacheButtonLData.width = 180;
            clearHistoCacheButtonLData.height = 30;
            this.clearHistoCacheButton.setLayoutData((Object)clearHistoCacheButtonLData);
            this.clearHistoCacheButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent evt) {
                    log.log(Level.FINEST, "clearHistoCacheButton.widgetSelected, event=" + String.valueOf(evt));
                    ((DataAccess.LocalAccess)DataAccess.getInstance()).resetHistolocations();
                    SettingsDialog.this.application.openMessageDialog(((DataAccess.LocalAccess)DataAccess.getInstance()).resetHistoCache());
                }
            });
            this.clearSupplementFoldersButton = new Button((Composite)this.histoToolsGroup, 0x1000008);
            this.clearSupplementFoldersButton.setFont(SWTResourceManager.getFont(GDE.WIDGET_FONT_NAME, GDE.WIDGET_FONT_SIZE, 0));
            this.clearSupplementFoldersButton.setText(Messages.getString("GDE_MSGT0922"));
            this.clearSupplementFoldersButton.setToolTipText(Messages.getString("GDE_MSGT0923", new Object[]{SupplementObjectFolder.getSupplementObjectsPath().toString()}));
            RowData clearSupplementFoldersButtonLData = new RowData();
            clearSupplementFoldersButtonLData.width = 180;
            clearSupplementFoldersButtonLData.height = 30;
            this.clearSupplementFoldersButton.setLayoutData((Object)clearSupplementFoldersButtonLData);
            this.clearSupplementFoldersButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent evt) {
                    log.log(Level.FINEST, "clearSupplementFoldersButton.widgetSelected, event=" + String.valueOf(evt));
                    SettingsDialog.this.application.openMessageDialog(SupplementObjectFolder.resetFolders());
                }
            });
            this.miscDiagGroup = new Group(this.osMiscComposite, 0);
            RowLayout miscDiagGroupLayout = new RowLayout(256);
            miscDiagGroupLayout.center = true;
            miscDiagGroupLayout.marginTop = 20;
            miscDiagGroupLayout.marginLeft = 55;
            miscDiagGroupLayout.spacing = 10;
            this.miscDiagGroup.setLayout((Layout)miscDiagGroupLayout);
            this.miscDiagGroup.setFont(SWTResourceManager.getFont(GDE.WIDGET_FONT_NAME, GDE.WIDGET_FONT_SIZE, 0));
            this.miscDiagGroup.setText(Messages.getString("GDE_MSGT0209"));
            this.resourceConsumptionButton = new Button((Composite)this.miscDiagGroup, 0x1000008);
            this.resourceConsumptionButton.setFont(SWTResourceManager.getFont(GDE.WIDGET_FONT_NAME, GDE.WIDGET_FONT_SIZE, 0));
            this.resourceConsumptionButton.setText(Messages.getString("GDE_MSGT0210"));
            this.resourceConsumptionButton.setToolTipText(Messages.getString("GDE_MSGT0211"));
            RowData resourceConsumptionButtonLData = new RowData();
            resourceConsumptionButtonLData.width = 180;
            resourceConsumptionButtonLData.height = 30;
            this.resourceConsumptionButton.setLayoutData((Object)resourceConsumptionButtonLData);
            this.resourceConsumptionButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent evt) {
                    log.log(Level.FINEST, "resourceConsumptionButton.widgetSelected, event=" + String.valueOf(evt));
                    SWTResourceManager.listResourceStatus(((Object)((Object)this)).getClass().getSimpleName());
                    log.log(Level.WARNING, String.format("Max Memory=%,11d   Total Memory=%,11d   Free Memory=%,11d", Runtime.getRuntime().maxMemory(), Runtime.getRuntime().totalMemory(), Runtime.getRuntime().freeMemory()));
                }
            });
            this.cleanSettingsButton = new Button((Composite)this.miscDiagGroup, 0x1000008);
            this.cleanSettingsButton.setFont(SWTResourceManager.getFont(GDE.WIDGET_FONT_NAME, GDE.WIDGET_FONT_SIZE, 0));
            this.cleanSettingsButton.setText(Messages.getString("GDE_MSGT0378"));
            this.cleanSettingsButton.setToolTipText(Messages.getString("GDE_MSGT0379"));
            resourceConsumptionButtonLData = new RowData();
            resourceConsumptionButtonLData.width = 180;
            resourceConsumptionButtonLData.height = 30;
            this.cleanSettingsButton.setLayoutData((Object)resourceConsumptionButtonLData);
            this.cleanSettingsButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent evt) {
                    log.log(Level.FINEST, "cleanSettingsButton.widgetSelected, event=" + String.valueOf(evt));
                    if (64 == SettingsDialog.this.application.openYesNoMessageDialog(Messages.getString("GDE_MSGW0544"))) {
                        System.setProperty("CLEAN_SETTINGS_WHILE_SHUTDOWN", "true");
                    }
                }
            });
            this.analysisTabItem = new CTabItem(this.settingsTabFolder, 0);
            this.analysisTabItem.setFont(SWTResourceManager.getFont(GDE.WIDGET_FONT_NAME, GDE.WIDGET_FONT_SIZE, 0));
            this.analysisTabItem.setText(Messages.getString("GDE_MSGT0302"));
            this.loggingGroup = new Group((Composite)this.settingsTabFolder, 0);
            this.loggingGroup.setLayout(null);
            this.loggingGroup.setBounds(13, 8, 456, 399);
            this.loggingGroup.setFont(SWTResourceManager.getFont(GDE.WIDGET_FONT_NAME, GDE.WIDGET_FONT_SIZE, 0));
            this.loggingGroup.setText(Messages.getString("GDE_MSGT0340"));
            this.analysisTabItem.setControl((Control)this.loggingGroup);
            this.globalLoggingComposite = new Composite((Composite)this.loggingGroup, 0);
            this.globalLoggingComposite.setLayout(null);
            this.globalLoggingComposite.setBounds(12, 26, 466, 41);
            this.globalLogLevel = new Button(this.globalLoggingComposite, 16416);
            this.globalLogLevel.setBounds(12, 12, 190, 22);
            this.globalLogLevel.setFont(SWTResourceManager.getFont(GDE.WIDGET_FONT_NAME, GDE.WIDGET_FONT_SIZE, 0));
            this.globalLogLevel.setText(Messages.getString("GDE_MSGT0341"));
            this.globalLogLevel.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent evt) {
                    log.log(Level.FINEST, "globalLogLevel.widgetSelected, event=" + String.valueOf(evt));
                    if (SettingsDialog.this.globalLogLevel.getSelection()) {
                        SettingsDialog.this.enableIndividualLogging(false);
                        SettingsDialog.this.globalLoggingCombo.setEnabled(true);
                        SettingsDialog.this.settings.setIsGlobalLogLevel("true");
                    } else {
                        SettingsDialog.this.enableIndividualLogging(true);
                        SettingsDialog.this.globalLoggingCombo.setEnabled(false);
                        SettingsDialog.this.settings.setIsGlobalLogLevel("false");
                    }
                }
            });
            this.globalLoggingCombo = new CCombo(this.globalLoggingComposite, 2048);
            this.globalLoggingCombo.setFont(SWTResourceManager.getFont(GDE.WIDGET_FONT_NAME, GDE.WIDGET_FONT_SIZE, 0));
            this.globalLoggingCombo.setBounds(214, 12, 212, GDE.IS_LINUX ? 22 : 20);
            this.globalLoggingCombo.setItems(Settings.LOGGING_LEVEL);
            this.globalLoggingCombo.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent evt) {
                    log.log(Level.FINEST, "globalLoggingCombo.widgetSelected, event=" + String.valueOf(evt));
                    SettingsDialog.this.settings.setProperty("global_log_level", SettingsDialog.this.globalLoggingCombo.getText());
                    SettingsDialog.this.globalLoggingCombo.setText(SettingsDialog.this.globalLoggingCombo.getText());
                }
            });
            this.individualLoggingComosite = new Composite((Composite)this.loggingGroup, 0);
            this.individualLoggingComosite.setLayout(null);
            this.individualLoggingComosite.setBounds(11, 90, 263, 317);
            this.uiLevelLabel = new CLabel(this.individualLoggingComosite, 0);
            RowLayout uiLevelLabelLayout = new RowLayout(256);
            this.uiLevelLabel.setFont(SWTResourceManager.getFont(GDE.WIDGET_FONT_NAME, GDE.WIDGET_FONT_SIZE, 0));
            this.uiLevelLabel.setLayout((Layout)uiLevelLabelLayout);
            this.uiLevelLabel.setText(Messages.getString("GDE_MSGT0342"));
            this.uiLevelLabel.setBounds(3, 3, 170, 20);
            this.uiLevelCombo = new CCombo(this.individualLoggingComosite, 2048);
            this.uiLevelCombo.setFont(SWTResourceManager.getFont(GDE.WIDGET_FONT_NAME, GDE.WIDGET_FONT_SIZE, 0));
            this.uiLevelCombo.setItems(Settings.LOGGING_LEVEL);
            this.uiLevelCombo.setBounds(183, 3, 79, GDE.IS_LINUX ? 22 : 20);
            this.uiLevelCombo.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent evt) {
                    log.log(Level.FINEST, "uiLevelCombo.widgetSelected, event=" + String.valueOf(evt));
                    SettingsDialog.this.settings.setProperty("ui_log_level", SettingsDialog.this.uiLevelCombo.getText());
                }
            });
            this.deviceLevelLabel = new CLabel(this.individualLoggingComosite, 0);
            RowLayout cLabel1Layout = new RowLayout(256);
            this.deviceLevelLabel.setFont(SWTResourceManager.getFont(GDE.WIDGET_FONT_NAME, GDE.WIDGET_FONT_SIZE, 0));
            this.deviceLevelLabel.setLayout((Layout)cLabel1Layout);
            this.deviceLevelLabel.setText(Messages.getString("GDE_MSGT0343"));
            this.deviceLevelLabel.setBounds(3, 27, 170, 20);
            this.deviceLevelCombo = new CCombo(this.individualLoggingComosite, 2048);
            this.deviceLevelCombo.setFont(SWTResourceManager.getFont(GDE.WIDGET_FONT_NAME, GDE.WIDGET_FONT_SIZE, 0));
            this.deviceLevelCombo.setItems(Settings.LOGGING_LEVEL);
            this.deviceLevelCombo.setBounds(183, 27, 79, GDE.IS_LINUX ? 22 : 20);
            this.deviceLevelCombo.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent evt) {
                    log.log(Level.FINEST, "deviceLevelCombo.widgetSelected, event=" + String.valueOf(evt));
                    SettingsDialog.this.settings.setProperty("device_log_level", SettingsDialog.this.deviceLevelCombo.getText());
                }
            });
            this.commonLevelLabel = new CLabel(this.individualLoggingComosite, 0);
            RowLayout cLabel2Layout = new RowLayout(256);
            this.commonLevelLabel.setFont(SWTResourceManager.getFont(GDE.WIDGET_FONT_NAME, GDE.WIDGET_FONT_SIZE, 0));
            this.commonLevelLabel.setLayout((Layout)cLabel2Layout);
            this.commonLevelLabel.setText(Messages.getString("GDE_MSGT0344"));
            this.commonLevelLabel.setBounds(3, 51, 170, 20);
            this.commonLevelCombo = new CCombo(this.individualLoggingComosite, 2048);
            this.commonLevelCombo.setFont(SWTResourceManager.getFont(GDE.WIDGET_FONT_NAME, GDE.WIDGET_FONT_SIZE, 0));
            this.commonLevelCombo.setItems(Settings.LOGGING_LEVEL);
            this.commonLevelCombo.setBounds(183, 51, 79, GDE.IS_LINUX ? 22 : 20);
            this.commonLevelCombo.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent evt) {
                    log.log(Level.FINEST, "commonLevelCombo.widgetSelected, event=" + String.valueOf(evt));
                    SettingsDialog.this.settings.setProperty("data_log_level", SettingsDialog.this.commonLevelCombo.getText());
                }
            });
            this.configLevelLabel = new CLabel(this.individualLoggingComosite, 0);
            RowLayout cLabel3Layout = new RowLayout(256);
            this.configLevelLabel.setFont(SWTResourceManager.getFont(GDE.WIDGET_FONT_NAME, GDE.WIDGET_FONT_SIZE, 0));
            this.configLevelLabel.setLayout((Layout)cLabel3Layout);
            this.configLevelLabel.setText(Messages.getString("GDE_MSGT0345"));
            this.configLevelLabel.setBounds(3, 75, 170, 20);
            this.configLevelCombo = new CCombo(this.individualLoggingComosite, 2048);
            this.configLevelCombo.setFont(SWTResourceManager.getFont(GDE.WIDGET_FONT_NAME, GDE.WIDGET_FONT_SIZE, 0));
            this.configLevelCombo.setItems(Settings.LOGGING_LEVEL);
            this.configLevelCombo.setBounds(183, 75, 79, GDE.IS_LINUX ? 22 : 20);
            this.configLevelCombo.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent evt) {
                    log.log(Level.FINEST, "configLevelCombo.widgetSelected, event=" + String.valueOf(evt));
                    SettingsDialog.this.settings.setProperty("config_log_level", SettingsDialog.this.configLevelCombo.getText());
                }
            });
            this.utilsLevelLabel = new CLabel(this.individualLoggingComosite, 0);
            RowLayout cLabel4Layout = new RowLayout(256);
            this.utilsLevelLabel.setFont(SWTResourceManager.getFont(GDE.WIDGET_FONT_NAME, GDE.WIDGET_FONT_SIZE, 0));
            this.utilsLevelLabel.setLayout((Layout)cLabel4Layout);
            this.utilsLevelLabel.setText(Messages.getString("GDE_MSGT0346"));
            this.utilsLevelLabel.setBounds(3, 99, 170, 20);
            this.utilsLevelCombo = new CCombo(this.individualLoggingComosite, 2048);
            this.utilsLevelCombo.setFont(SWTResourceManager.getFont(GDE.WIDGET_FONT_NAME, GDE.WIDGET_FONT_SIZE, 0));
            this.utilsLevelCombo.setItems(Settings.LOGGING_LEVEL);
            this.utilsLevelCombo.setBounds(183, 99, 79, GDE.IS_LINUX ? 22 : 20);
            this.utilsLevelCombo.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent evt) {
                    log.log(Level.FINEST, "utilsLevelCombo.widgetSelected, event=" + String.valueOf(evt));
                    SettingsDialog.this.settings.setProperty("utils_log_level", SettingsDialog.this.utilsLevelCombo.getText());
                }
            });
            this.fileIOLevelLabel = new CLabel(this.individualLoggingComosite, 0);
            this.fileIOLevelLabel.setFont(SWTResourceManager.getFont(GDE.WIDGET_FONT_NAME, GDE.WIDGET_FONT_SIZE, 0));
            cLabel4Layout = new RowLayout(256);
            this.fileIOLevelLabel.setLayout((Layout)cLabel4Layout);
            this.fileIOLevelLabel.setBounds(3, 124, 170, 20);
            this.fileIOLevelLabel.setText(Messages.getString("GDE_MSGT0347"));
            this.fileIOLevelCombo = new CCombo(this.individualLoggingComosite, 2048);
            this.fileIOLevelCombo.setFont(SWTResourceManager.getFont(GDE.WIDGET_FONT_NAME, GDE.WIDGET_FONT_SIZE, 0));
            this.fileIOLevelCombo.setItems(Settings.LOGGING_LEVEL);
            this.fileIOLevelCombo.setBounds(183, 124, 79, GDE.IS_LINUX ? 22 : 20);
            this.fileIOLevelCombo.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent evt) {
                    log.log(Level.FINEST, "fileIOLevelCombo.widgetSelected, event=" + String.valueOf(evt));
                    SettingsDialog.this.settings.setProperty("file_IO_log_level", SettingsDialog.this.fileIOLevelCombo.getText());
                }
            });
            this.serialIOLevelLabel = new CLabel(this.individualLoggingComosite, 0);
            this.serialIOLevelLabel.setFont(SWTResourceManager.getFont(GDE.WIDGET_FONT_NAME, GDE.WIDGET_FONT_SIZE, 0));
            cLabel4Layout = new RowLayout(256);
            this.serialIOLevelLabel.setLayout((Layout)cLabel4Layout);
            this.serialIOLevelLabel.setText(Messages.getString("GDE_MSGT0348"));
            this.serialIOLevelLabel.setBounds(3, 149, 170, 20);
            this.serialIOLevelCombo = new CCombo(this.individualLoggingComosite, 2048);
            this.serialIOLevelCombo.setFont(SWTResourceManager.getFont(GDE.WIDGET_FONT_NAME, GDE.WIDGET_FONT_SIZE, 0));
            this.serialIOLevelCombo.setItems(Settings.LOGGING_LEVEL);
            this.serialIOLevelCombo.setBounds(183, 149, 79, GDE.IS_LINUX ? 22 : 20);
            this.serialIOLevelCombo.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent evt) {
                    log.log(Level.FINEST, "serialIOLevelCombo.widgetSelected, event=" + String.valueOf(evt));
                    SettingsDialog.this.settings.setProperty("serial_IO_log_level", SettingsDialog.this.serialIOLevelCombo.getText());
                }
            });
            this.classBasedLabel = new Label((Composite)this.loggingGroup, 0x1000000);
            this.classBasedLabel.setFont(SWTResourceManager.getFont(GDE.WIDGET_FONT_NAME, GDE.WIDGET_FONT_SIZE, 0));
            this.classBasedLabel.setText(Messages.getString("GDE_MSGT0349"));
            this.classBasedLabel.setBounds(286, 95, 192, 18);
            this.popupmenu = new Menu((Decorations)this.dialogShell, 8);
            this.logLevelMenu.createMenu(this.popupmenu);
            this.tree = new Tree((Composite)this.loggingGroup, 0);
            this.tree.setLayout(null);
            this.tree.setFont(SWTResourceManager.getFont(GDE.WIDGET_FONT_NAME, GDE.WIDGET_FONT_SIZE, 0));
            this.tree.setBounds(286, 120, 192, 290);
            this.tree.setMenu(this.popupmenu);
            this.tree.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent evt) {
                    log.log(Level.FINEST, "tree.widgetSelected, event=" + String.valueOf(evt));
                    TreeItem tmpItem = (TreeItem)evt.item;
                    if (tmpItem != null && tmpItem.getParentItem() != null) {
                        StringBuilder sb = new StringBuilder();
                        TreeItem tmpParent = tmpItem;
                        while (null != (tmpParent = tmpParent.getParentItem())) {
                            sb.append(tmpParent.getText()).append(".");
                        }
                        sb.append(tmpItem.getText());
                        String loggerName = sb.toString();
                        SettingsDialog.this.popupmenu.setData(SettingsDialog.LOGGER_NAME, (Object)loggerName);
                    } else {
                        SettingsDialog.this.popupmenu.setData(SettingsDialog.LOGGER_NAME, (Object)(tmpItem.getText() + "."));
                    }
                }
            });
            this.settingsTabFolder.setSelection(0);
            this.initialize();
            this.dialogShell.addHelpListener(new HelpListener(){

                public void helpRequested(HelpEvent evt) {
                    log.log(Level.FINE, "dialogShell.helpRequested, event=" + String.valueOf(evt));
                    SettingsDialog.this.application.openHelpDialog("", "HelpInfo_1.html");
                }
            });
            this.dialogShell.addDisposeListener(new DisposeListener(){

                public void widgetDisposed(DisposeEvent evt) {
                    log.log(Level.FINEST, "dialogShell.widgetDisposed, event=" + String.valueOf(evt));
                    if (SettingsDialog.this.settings.getActiveDevice().startsWith("---")) {
                        SettingsDialog.this.settings.setActiveDevice("---;---;---");
                    }
                    SettingsDialog.this.settings.store();
                    SettingsDialog.this.settings.updateLogLevel();
                    if (SettingsDialog.this.settings.isSerialPortBlackListEnabled()) {
                        SettingsDialog.this.settings.setSerialPortBlackList(SettingsDialog.this.serialPortBlackList.getText());
                    } else if (SettingsDialog.this.settings.isSerialPortWhiteListEnabled()) {
                        SettingsDialog.this.settings.setSerialPortWhiteList(SettingsDialog.this.serialPortWhiteList.getText());
                    }
                    if (SettingsDialog.this.isLocaleLanguageChanged) {
                        SettingsDialog.this.application.openMessageDialog(SettingsDialog.this.dialogShell, Messages.getString("GDE_MSGT0304"));
                        SettingsDialog.this.application.reloadLanguageRelatedResources();
                    }
                }
            });
            FormData okButtonLData = new FormData();
            okButtonLData.width = 250;
            okButtonLData.height = 30;
            okButtonLData.left = new FormAttachment(0, 1000, 116);
            okButtonLData.bottom = new FormAttachment(1000, 1000, -7);
            okButtonLData.right = new FormAttachment(1000, 1000, -122);
            this.okButton = new Button((Composite)this.dialogShell, 0x1000008);
            this.okButton.setFont(SWTResourceManager.getFont(GDE.WIDGET_FONT_NAME, GDE.WIDGET_FONT_SIZE, 0));
            this.okButton.setLayoutData((Object)okButtonLData);
            this.okButton.setText(Messages.getString("GDE_MSGT0188"));
            this.okButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent evt) {
                    log.log(Level.FINEST, "okButton.widgetSelected, event=" + String.valueOf(evt));
                    SettingsDialog.this.dialogShell.dispose();
                }
            });
            this.dialogShell.setLocation(this.getParent().toDisplay(100, 10));
            this.dialogShell.open();
            Display display = this.dialogShell.getDisplay();
            while (!this.dialogShell.isDisposed()) {
                if (display.readAndDispatch()) continue;
                display.sleep();
            }
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
    }

    private int getLocalLanguageIndex() {
        int index;
        String language = this.settings.getLocale().toString();
        for (index = 0; index < this.supportedLocals.length; ++index) {
            if (!this.supportedLocals[index].equals(language)) continue;
            return index;
        }
        return index;
    }

    private int getTimeFormatIndex() {
        int index;
        String format = this.settings.getTimeFormat().toString().trim().substring(0, 3);
        for (index = 0; index < this.timeFormatCombo.getItemCount(); ++index) {
            if (!this.timeFormatCombo.getItems()[index].trim().startsWith(format)) continue;
            return index;
        }
        return index;
    }

    void enableIndividualLogging(boolean value) {
        this.uiLevelLabel.setEnabled(value);
        this.uiLevelCombo.setEnabled(value);
        this.commonLevelLabel.setEnabled(value);
        this.commonLevelCombo.setEnabled(value);
        this.deviceLevelLabel.setEnabled(value);
        this.deviceLevelCombo.setEnabled(value);
        this.configLevelLabel.setEnabled(value);
        this.configLevelCombo.setEnabled(value);
        this.utilsLevelLabel.setEnabled(value);
        this.utilsLevelCombo.setEnabled(value);
        this.fileIOLevelLabel.setEnabled(value);
        this.fileIOLevelCombo.setEnabled(value);
        this.serialIOLevelLabel.setEnabled(value);
        this.serialIOLevelCombo.setEnabled(value);
        this.tree.setEnabled(value);
    }

    void updateLoggingLevels() {
        if (this.settings.getProperty("global_log_level") == null) {
            this.settings.setProperty("global_log_level", DEFAULT_LOG_LEVEL);
        }
        this.globalLoggingCombo.setText(this.settings.getProperty("global_log_level"));
        if (this.settings.getProperty("ui_log_level") == null) {
            this.settings.setProperty("ui_log_level", DEFAULT_LOG_LEVEL);
        }
        this.uiLevelCombo.setText(this.settings.getProperty("ui_log_level"));
        if (this.settings.getProperty("data_log_level") == null) {
            this.settings.setProperty("data_log_level", DEFAULT_LOG_LEVEL);
        }
        this.commonLevelCombo.setText(this.settings.getProperty("data_log_level"));
        if (this.settings.getProperty("device_log_level") == null) {
            this.settings.setProperty("device_log_level", DEFAULT_LOG_LEVEL);
        }
        this.deviceLevelCombo.setText(this.settings.getProperty("device_log_level"));
        if (this.settings.getProperty("config_log_level") == null) {
            this.settings.setProperty("config_log_level", DEFAULT_LOG_LEVEL);
        }
        this.configLevelCombo.setText(this.settings.getProperty("config_log_level"));
        if (this.settings.getProperty("utils_log_level") == null) {
            this.settings.setProperty("utils_log_level", DEFAULT_LOG_LEVEL);
        }
        this.utilsLevelCombo.setText(this.settings.getProperty("utils_log_level"));
        if (this.settings.getProperty("file_IO_log_level") == null) {
            this.settings.setProperty("file_IO_log_level", DEFAULT_LOG_LEVEL);
        }
        this.fileIOLevelCombo.setText(this.settings.getProperty("file_IO_log_level"));
        if (this.settings.getProperty("serial_IO_log_level") == null) {
            this.settings.setProperty("serial_IO_log_level", DEFAULT_LOG_LEVEL);
        }
        this.serialIOLevelCombo.setText(this.settings.getProperty("serial_IO_log_level"));
    }

    private void initialize() {
        this.defaultDataPath.setText(new File(this.settings.getDataFilePath()).getAbsolutePath());
        this.suggestDate.setSelection(this.settings.getUsageDateAsFileNameLeader());
        this.suggestObjectKey.setSelection(this.settings.getUsageObjectKeyInFileName());
        this.writeTmpFiles.setSelection(this.settings.getUsageWritingTmpFiles());
        this.osSchema.setSelection(this.settings.getSkinColorSchema().equals("color_schema_system"));
        this.lightSchema.setSelection(this.settings.getSkinColorSchema().equals("color_schema_light"));
        this.darkSchema.setSelection(this.settings.getSkinColorSchema().equals("color_schema_dark"));
        this.deviceDialogModalButton.setSelection(this.settings.isDeviceDialogsModal());
        this.deviceDialogOnTopButton.setEnabled(!this.settings.isDeviceDialogsModal());
        this.deviceDialogOnTopButton.setSelection(this.settings.isDeviceDialogsOnTop());
        this.deviceDialogAlphaButton.setSelection(this.settings.isDeviceDialogAlphaEnabled());
        this.alphaSlider.setEnabled(this.settings.isDeviceDialogAlphaEnabled());
        this.alphaSlider.setSelection(this.settings.getDialogAlphaValue());
        this.deviceImportDialogButton.setSelection(this.settings.isDeviceImportDirectoryObjectRelated());
        this.decimalSeparator.setText(" " + this.settings.getDecimalSeparator());
        this.listSeparator.setText(" " + this.settings.getListSeparator());
        this.skipBluetoothDevices.setSelection(this.settings.isSkipBluetoothDevices());
        this.doPortAvailabilityCheck.setSelection(this.settings.doPortAvailabilityCheck());
        this.serialPortBlackList.setText(" " + this.settings.getSerialPortBlackList());
        boolean isBlacklistEnabled = this.settings.isSerialPortBlackListEnabled();
        this.enableBlackListButton.setSelection(isBlacklistEnabled);
        this.serialPortBlackList.setEditable(isBlacklistEnabled);
        this.serialPortBlackList.setEnabled(isBlacklistEnabled);
        this.serialPortWhiteList.setText(" " + this.settings.getSerialPortWhiteListString());
        boolean isWhitelistEnabled = this.settings.isSerialPortWhiteListEnabled();
        this.enableWhiteListButton.setSelection(isWhitelistEnabled);
        this.serialPortWhiteList.setEditable(isWhitelistEnabled);
        this.serialPortWhiteList.setEnabled(isWhitelistEnabled);
        this.globalLogLevel.setSelection(this.settings.isGlobalLogLevel());
        if (this.settings.isGlobalLogLevel()) {
            this.enableIndividualLogging(false);
            this.globalLoggingCombo.setEnabled(true);
        } else {
            this.enableIndividualLogging(true);
            this.globalLoggingCombo.setEnabled(false);
            this.globalLogLevel.setSelection(false);
        }
        this.updateLoggingLevels();
        this.tree.clearAll(true);
        LogManager manager = LogManager.getLogManager();
        Enumeration<String> loggerNames = manager.getLoggerNames();
        StringBuilder sb = new StringBuilder();
        while (loggerNames.hasMoreElements()) {
            String loggerName = loggerNames.nextElement();
            if (!loggerName.startsWith("gde") || loggerName.replace('.', ':').split(":").length < 3) continue;
            sb.append(loggerName).append(";");
        }
        Object[] loggers = sb.toString().split(";");
        Arrays.sort(loggers);
        if (log.isLoggable(Level.FINER)) {
            for (Object string : loggers) {
                log.log(Level.FINER, (String)string);
            }
        }
        this.tree.removeAll();
        Object root = "";
        TreeItem treeItemRoot = null;
        block7: for (Object string : loggers) {
            String[] tmp = ((String)string).replace('.', ':').split(":");
            switch (tmp.length) {
                case 3: {
                    if (!((String)root).equals(tmp[0] + "." + tmp[1])) {
                        root = tmp[0] + "." + tmp[1];
                        treeItemRoot = new TreeItem(this.tree, 4);
                        treeItemRoot.setText((String)root);
                    }
                    TreeItem treeItemNode = new TreeItem(treeItemRoot, 0);
                    treeItemNode.setText(tmp[2]);
                    continue block7;
                }
                case 4: {
                    if (!((String)root).equals(tmp[0] + "." + tmp[1] + "." + tmp[2])) {
                        root = tmp[0] + "." + tmp[1] + "." + tmp[2];
                        treeItemRoot = new TreeItem(this.tree, 4);
                        treeItemRoot.setText((String)root);
                    }
                    TreeItem treeItemNode = new TreeItem(treeItemRoot, 0);
                    treeItemNode.setText(tmp[3]);
                    continue block7;
                }
                case 5: {
                    if (!((String)root).equals(tmp[0] + "." + tmp[1] + "." + tmp[2] + "." + tmp[3])) {
                        root = tmp[0] + "." + tmp[1] + "." + tmp[2] + "." + tmp[3];
                        treeItemRoot = new TreeItem(this.tree, 4);
                        treeItemRoot.setText((String)root);
                    }
                    TreeItem treeItemNode = new TreeItem(treeItemRoot, 0);
                    treeItemNode.setText(tmp[4]);
                }
            }
        }
    }
}

