/*
 * Decompiled with CFR 0.152.
 */
package gde.ui.dialog;

import gde.Analyzer;
import gde.GDE;
import gde.comm.DeviceCommPort;
import gde.config.DeviceConfigurations;
import gde.config.ExportService;
import gde.config.Settings;
import gde.data.Channels;
import gde.device.DeviceConfiguration;
import gde.device.IDevice;
import gde.exception.NotSupportedException;
import gde.log.Level;
import gde.messages.Messages;
import gde.ui.DataExplorer;
import gde.ui.SWTResourceManager;
import gde.utils.StringHelper;
import gde.utils.WaitTimer;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.Date;
import java.util.HashMap;
import java.util.TreeMap;
import java.util.Vector;
import java.util.logging.Logger;
import org.eclipse.swt.custom.CCombo;
import org.eclipse.swt.custom.CLabel;
import org.eclipse.swt.custom.CTabFolder;
import org.eclipse.swt.custom.CTabItem;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.HelpEvent;
import org.eclipse.swt.events.HelpListener;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.layout.RowData;
import org.eclipse.swt.layout.RowLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Dialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Slider;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Widget;

public class DeviceSelectionDialog
extends Dialog {
    static final Logger log = Logger.getLogger(DeviceSelectionDialog.class.getName());
    Shell dialogShell;
    CTabItem cTabItem1;
    Composite composite2;
    Label deviceText;
    TableColumn tableColumn1;
    TableColumn tableColumn2;
    TableColumn tableColumn3;
    Table deviceTable;
    Group deviceGroup;
    Composite composite1;
    CTabItem overviewTabItem;
    Button closeButton;
    Button rtsCheckBox;
    Button dtrCheckBox;
    Label flowControlSelectLabel;
    Label dataBitsSelectLabel;
    Label paritySelectLabel;
    Label stopBitsSelectLabel;
    Label baudeSelectLabel;
    Label rtsDescription;
    Label dtrDescription;
    Label parityDescription;
    Label stopbitsDescription;
    Label dataBitsDescription;
    Label flowcontrolDescription;
    Label baudeDescription;
    Group portSettingsGroup;
    CCombo portSelectCombo;
    CLabel portDescription;
    Group serialPortSelectionGroup;
    Button voltagePerCellButton;
    Button utilityGraphicsButton;
    Button utilityDeviceButton;
    Button analogTabButton;
    Button digitalTabButton;
    Button tableTabButton;
    Group desktopTabsGroup;
    Group deviceSelectionGroup;
    Label internetLinkText;
    Label deviceTypeText;
    Label manufacturerName;
    Label internetLinkDescription;
    Label deviceTypeDescription;
    Label deviceNameDescription;
    Label manufacturerDescription;
    Canvas deviceCanvas;
    Image deviceImage;
    Label deviceGroupText;
    Slider deviceSlider;
    CCombo deviceSelectCombo;
    CTabFolder settingsTabFolder;
    TreeMap<String, ExportService> deviceServices;
    DeviceConfigurations deviceConfigurations;
    final DataExplorer application;
    final Settings settings;
    String activeDeviceName;
    DeviceConfiguration selectedActiveDeviceConfig;
    Thread listPortsThread;
    Vector<String> availablePorts = new Vector();
    boolean isUpdateSerialPorts = true;
    HashMap<String, String> legacyDeviceNames = new HashMap(2);

    public DeviceSelectionDialog(Shell parent, int style, DataExplorer currentApplication) {
        super(parent, style);
        this.application = currentApplication;
        this.settings = Settings.getInstance();
        this.activeDeviceName = this.settings.getActiveDevice();
        this.availablePorts.addAll(DeviceCommPort.getAvailableports().keySet());
        this.legacyDeviceNames.put("GPSLogger", "GPS-Logger");
        this.legacyDeviceNames.put("QuadroControl", "QC-Copter");
        this.legacyDeviceNames.put("PichlerP60", "PichlerP60 50W");
        try {
            File file = new File(Settings.getDevicesPath());
            if (!file.exists()) {
                throw new FileNotFoundException(Settings.getDevicesPath());
            }
            this.deviceServices = Settings.getInstance().getDeviceServices();
            this.deviceConfigurations = Analyzer.getInstance().getDeviceConfigurations();
            this.selectedActiveDeviceConfig = this.deviceConfigurations.getSelectedActiveDeviceConfig();
            if (this.selectedActiveDeviceConfig == null) {
                this.application.setActiveDevice(null);
            }
            log.log(Level.TIME, "time =", StringHelper.getFormatedTime("ss:SSS", new Date().getTime() - GDE.StartTime));
        }
        catch (FileNotFoundException e) {
            log.log(Level.SEVERE, e.getMessage(), e);
            currentApplication.openMessageDialog(this.dialogShell, Messages.getString("GDE_MSGE0007") + e.getClass().getSimpleName() + " - " + e.getMessage());
        }
    }

    public void open() {
        try {
            Shell parent = this.getParent();
            this.dialogShell = new Shell(parent, 34912);
            SWTResourceManager.registerResourceUser((Widget)this.dialogShell);
            this.dialogShell.setImage(SWTResourceManager.getImage("gde/resource/DeviceSelection.gif"));
            this.dialogShell.setLayout((Layout)new FormLayout());
            this.dialogShell.layout();
            this.dialogShell.pack();
            this.dialogShell.setSize(566, 644);
            this.dialogShell.setText(Messages.getString("GDE_MSGT0189"));
            this.dialogShell.addListener(31, new Listener(){

                public void handleEvent(Event event) {
                    switch (event.detail) {
                        case 2: {
                            DeviceSelectionDialog.this.dialogShell.close();
                            event.detail = 0;
                            event.doit = false;
                        }
                    }
                }
            });
            this.dialogShell.addHelpListener(new HelpListener(){

                public void helpRequested(HelpEvent evt) {
                    log.log(Level.FINE, "dialogShell.helpRequested, event=" + String.valueOf(evt));
                    DeviceSelectionDialog.this.application.openHelpDialog("", "HelpInfo_2.html");
                }
            });
            this.dialogShell.addDisposeListener(new DisposeListener(){

                public void widgetDisposed(DisposeEvent evt) {
                    log.log(Level.FINEST, "dialogShell.widgetDisposed, event=" + String.valueOf(evt));
                    for (String deviceKey : DeviceSelectionDialog.this.deviceConfigurations.deviceNames().toArray(new String[0])) {
                        DeviceSelectionDialog.this.checkAndStoreDeviceConfiguration(deviceKey);
                    }
                    if (DeviceSelectionDialog.this.isDeviceChanged()) {
                        DeviceSelectionDialog.this.setupDevice();
                    } else if (DeviceSelectionDialog.this.selectedActiveDeviceConfig == null) {
                        DeviceSelectionDialog.this.application.setActiveDevice(null);
                    }
                    DeviceSelectionDialog.this.application.resetShellIcon();
                    log.log(Level.FINE, "disposed");
                }
            });
            FormData composite1LData = new FormData();
            composite1LData.width = 558;
            composite1LData.height = 559;
            composite1LData.left = new FormAttachment(0, 1000, 0);
            composite1LData.top = new FormAttachment(0, 1000, 0);
            composite1LData.right = new FormAttachment(1000, 1000, 0);
            composite1LData.bottom = new FormAttachment(1000, 1000, -52);
            this.composite1 = new Composite((Composite)this.dialogShell, 0);
            FillLayout composite1Layout = new FillLayout(256);
            this.composite1.setLayout((Layout)composite1Layout);
            this.composite1.setLayoutData((Object)composite1LData);
            this.settingsTabFolder = new CTabFolder(this.composite1, 2048);
            this.settingsTabFolder.setSimple(false);
            this.cTabItem1 = new CTabItem(this.settingsTabFolder, 0);
            this.cTabItem1.setFont(SWTResourceManager.getFont(GDE.WIDGET_FONT_NAME, GDE.WIDGET_FONT_SIZE, 0));
            this.cTabItem1.setText(Messages.getString("GDE_MSGT0154"));
            this.composite2 = new Composite((Composite)this.settingsTabFolder, 0);
            this.cTabItem1.setControl((Control)this.composite2);
            this.composite2.setLayout(null);
            this.deviceSelectionGroup = new Group(this.composite2, 0);
            this.deviceSelectionGroup.setLayout(null);
            this.deviceSelectionGroup.setText(Messages.getString("GDE_MSGT0155"));
            this.deviceSelectionGroup.setBounds(12, 9, 524, 250);
            this.deviceSelectCombo = new CCombo((Composite)this.deviceSelectionGroup, 2048);
            this.deviceSelectCombo.setFont(SWTResourceManager.getFont(GDE.WIDGET_FONT_NAME, GDE.WIDGET_FONT_SIZE, 0));
            this.deviceSelectCombo.setItems(new String[]{Messages.getString("GDE_MSGT0156")});
            this.deviceSelectCombo.setBounds(12, GDE.IS_MAC_COCOA ? 15 : 20, 375, GDE.IS_LINUX ? 22 : 20);
            this.deviceSelectCombo.setEditable(false);
            this.deviceSelectCombo.setBackground(this.application.COLOR_WHITE);
            this.deviceSelectCombo.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent evt) {
                    log.log(Level.FINEST, "deviceSelectCombo.widgetSelected, event=" + String.valueOf(evt));
                    if (DeviceSelectionDialog.this.application.getActiveDevice() == null || DeviceSelectionDialog.this.application.getActiveDevice() != null && DeviceSelectionDialog.this.application.getActiveDevice().getCommunicationPort() == null || DeviceSelectionDialog.this.application.getActiveDevice() != null && DeviceSelectionDialog.this.application.getActiveDevice().getCommunicationPort() != null && !DeviceSelectionDialog.this.application.getActiveDevice().getCommunicationPort().isConnected()) {
                        DeviceSelectionDialog.this.activeDeviceName = DeviceSelectionDialog.this.deviceSelectCombo.getText();
                        log.log(Level.FINE, "activeName = " + DeviceSelectionDialog.this.activeDeviceName);
                        DeviceSelectionDialog.this.selectedActiveDeviceConfig = DeviceSelectionDialog.this.deviceConfigurations.get(DeviceSelectionDialog.this.activeDeviceName);
                        if (DeviceSelectionDialog.this.application.getActiveDevice() != null && DeviceSelectionDialog.this.application.getDeviceDialog() != null && !DeviceSelectionDialog.this.application.getDeviceDialog().isDisposed()) {
                            DeviceSelectionDialog.this.application.getDeviceDialog().dispose();
                        }
                        DeviceSelectionDialog.this.updateDialogEntries();
                    } else {
                        DeviceSelectionDialog.this.application.openMessageDialog(DeviceSelectionDialog.this.dialogShell, Messages.getString("GDE_MSGW0017"));
                    }
                }
            });
            this.deviceSlider = new Slider((Composite)this.deviceSelectionGroup, 256);
            this.deviceSlider.setBounds(393, GDE.IS_WINDOWS ? 18 : (GDE.IS_MAC_COCOA ? 3 : 16), 119, GDE.IS_WINDOWS ? 22 : 28);
            this.deviceSlider.setMinimum(0);
            this.deviceSlider.setMaximum(1);
            this.deviceSlider.setIncrement(1);
            this.deviceSlider.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent evt) {
                    log.log(Level.FINEST, "deviceSlider.widgetSelected, event=" + String.valueOf(evt));
                    if (DeviceSelectionDialog.this.application.getActiveDevice() == null || DeviceSelectionDialog.this.application.getActiveDevice() != null && DeviceSelectionDialog.this.application.getActiveDevice().getCommunicationPort() == null || DeviceSelectionDialog.this.application.getActiveDevice() != null && DeviceSelectionDialog.this.application.getActiveDevice().getCommunicationPort() != null && !DeviceSelectionDialog.this.application.getActiveDevice().getCommunicationPort().isConnected()) {
                        int position = DeviceSelectionDialog.this.deviceSlider.getSelection();
                        log.log(Level.FINE, " Position: " + position);
                        if (DeviceSelectionDialog.this.deviceConfigurations.size() > 0 && !DeviceSelectionDialog.this.deviceConfigurations.get(position).equals(DeviceSelectionDialog.this.activeDeviceName)) {
                            DeviceSelectionDialog.this.activeDeviceName = DeviceSelectionDialog.this.deviceConfigurations.get(position);
                            log.log(Level.FINE, "activeName = " + DeviceSelectionDialog.this.activeDeviceName);
                            DeviceSelectionDialog.this.selectedActiveDeviceConfig = DeviceSelectionDialog.this.deviceConfigurations.get(DeviceSelectionDialog.this.activeDeviceName);
                            if (DeviceSelectionDialog.this.application.getDeviceDialog() != null && !DeviceSelectionDialog.this.application.getDeviceDialog().isDisposed()) {
                                DeviceSelectionDialog.this.application.getDeviceDialog().dispose();
                            }
                            DeviceSelectionDialog.this.updateDialogEntries();
                        }
                    } else {
                        DeviceSelectionDialog.this.application.openMessageDialog(DeviceSelectionDialog.this.dialogShell, Messages.getString("GDE_MSGW0017"));
                    }
                }
            });
            this.deviceGroupText = new Label((Composite)this.deviceSelectionGroup, 64);
            this.deviceGroupText.setBounds(12, 48, 430, 16);
            this.deviceGroupText.setFont(SWTResourceManager.getFont(GDE.WIDGET_FONT_NAME, GDE.WIDGET_FONT_SIZE, 0));
            this.deviceGroupText.setText(Messages.getString("GDE_MSGI0026"));
            this.deviceCanvas = new Canvas((Composite)this.deviceSelectionGroup, 2048);
            this.deviceCanvas.setBounds(12, 70, 227, 165);
            this.deviceCanvas.addPaintListener(event -> {
                if (this.deviceImage != null) {
                    Rectangle canvasBounds = this.deviceCanvas.getClientArea();
                    Rectangle imageBounds = this.deviceImage.getBounds();
                    if (imageBounds.width != canvasBounds.width || imageBounds.height != canvasBounds.height) {
                        event.gc.drawImage(this.deviceImage, 0, 0, imageBounds.width, imageBounds.height, 0, 0, canvasBounds.width, canvasBounds.height);
                    } else {
                        event.gc.drawImage(this.deviceImage, 0, 0);
                    }
                }
            });
            this.manufacturerDescription = new Label((Composite)this.deviceSelectionGroup, 64);
            this.manufacturerDescription.setBounds(251, 70, 101, 16);
            this.manufacturerDescription.setText(Messages.getString("GDE_MSGT0157"));
            this.manufacturerDescription.setFont(SWTResourceManager.getFont(GDE.WIDGET_FONT_NAME, GDE.WIDGET_FONT_SIZE, 0));
            this.deviceNameDescription = new Label((Composite)this.deviceSelectionGroup, 64);
            this.deviceNameDescription.setBounds(251, 92, 101, 16);
            this.deviceNameDescription.setFont(SWTResourceManager.getFont(GDE.WIDGET_FONT_NAME, GDE.WIDGET_FONT_SIZE, 0));
            this.deviceNameDescription.setText(Messages.getString("GDE_MSGT0158"));
            this.deviceTypeDescription = new Label((Composite)this.deviceSelectionGroup, 64);
            this.deviceTypeDescription.setBounds(251, 114, 101, 16);
            this.deviceTypeDescription.setFont(SWTResourceManager.getFont(GDE.WIDGET_FONT_NAME, GDE.WIDGET_FONT_SIZE, 0));
            this.deviceTypeDescription.setText(Messages.getString("GDE_MSGT0159"));
            this.internetLinkDescription = new Label((Composite)this.deviceSelectionGroup, 64);
            this.internetLinkDescription.setBounds(251, 136, 101, 16);
            this.internetLinkDescription.setFont(SWTResourceManager.getFont(GDE.WIDGET_FONT_NAME, GDE.WIDGET_FONT_SIZE, 0));
            this.internetLinkDescription.setText(Messages.getString("GDE_MSGT0160"));
            this.manufacturerName = new Label((Composite)this.deviceSelectionGroup, 0);
            this.manufacturerName.setFont(SWTResourceManager.getFont(GDE.WIDGET_FONT_NAME, GDE.WIDGET_FONT_SIZE, 0));
            this.manufacturerName.setBounds(358, 70, 154, 16);
            this.deviceText = new Label((Composite)this.deviceSelectionGroup, 0);
            this.deviceText.setFont(SWTResourceManager.getFont(GDE.WIDGET_FONT_NAME, GDE.WIDGET_FONT_SIZE, 0));
            this.deviceText.setBounds(358, 92, 154, 16);
            this.deviceTypeText = new Label((Composite)this.deviceSelectionGroup, 0);
            this.deviceTypeText.setFont(SWTResourceManager.getFont(GDE.WIDGET_FONT_NAME, GDE.WIDGET_FONT_SIZE, 0));
            this.deviceTypeText.setBounds(358, 114, 154, 16);
            this.internetLinkText = new Label((Composite)this.deviceSelectionGroup, 0);
            this.internetLinkText.setFont(SWTResourceManager.getFont(GDE.WIDGET_FONT_NAME, GDE.WIDGET_FONT_SIZE, 0));
            this.internetLinkText.setBounds(358, 136, 154, 16);
            this.serialPortSelectionGroup = new Group(this.composite2, 0);
            RowLayout portSelectionGroupLayout = new RowLayout(256);
            portSelectionGroupLayout.center = true;
            this.serialPortSelectionGroup.setLayout((Layout)portSelectionGroupLayout);
            this.serialPortSelectionGroup.setFont(SWTResourceManager.getFont(GDE.WIDGET_FONT_NAME, GDE.WIDGET_FONT_SIZE, 0));
            this.serialPortSelectionGroup.setText(Messages.getString("GDE_MSGT0163"));
            this.serialPortSelectionGroup.setBounds(12, 265, 524, 58);
            this.portDescription = new CLabel((Composite)this.serialPortSelectionGroup, 0);
            this.portDescription.setFont(SWTResourceManager.getFont(GDE.WIDGET_FONT_NAME, GDE.WIDGET_FONT_SIZE, 0));
            this.portDescription.setText(Messages.getString("GDE_MSGT0164"));
            this.portDescription.setLayoutData((Object)new RowData(50, GDE.IS_LINUX ? 22 : (GDE.IS_MAC ? 20 : 18)));
            this.portDescription.setToolTipText(Messages.getString("GDE_MSGT0165"));
            this.portSelectCombo = new CCombo((Composite)this.serialPortSelectionGroup, 0x800800);
            this.portSelectCombo.setFont(SWTResourceManager.getFont(GDE.WIDGET_FONT_NAME, GDE.WIDGET_FONT_SIZE, 0));
            this.portSelectCombo.setLayoutData((Object)new RowData(440, GDE.IS_LINUX ? 22 : (GDE.IS_MAC ? 20 : 18)));
            this.portSelectCombo.setEditable(false);
            this.portSelectCombo.setText(Messages.getString("GDE_MSGT0199"));
            this.portSelectCombo.setToolTipText(Messages.getString("GDE_MSGT0165"));
            this.portSelectCombo.setBackground(this.application.COLOR_WHITE);
            this.portSelectCombo.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent evt) {
                    log.log(Level.FINEST, "portSelectCombo.widgetSelected, event=" + String.valueOf(evt));
                    String selectedPort = DeviceSelectionDialog.this.portSelectCombo.getItem(DeviceSelectionDialog.this.portSelectCombo.getSelectionIndex()).trim().split(" ")[0];
                    DeviceSelectionDialog.this.selectedActiveDeviceConfig.setPort(selectedPort);
                    DeviceSelectionDialog.this.selectedActiveDeviceConfig.storeDeviceProperties();
                    DeviceSelectionDialog.this.application.updateTitleBar(DeviceSelectionDialog.this.application.getObjectKey(), DeviceSelectionDialog.this.selectedActiveDeviceConfig.getName(), DeviceSelectionDialog.this.selectedActiveDeviceConfig.getPort());
                }
            });
            this.serialPortSelectionGroup.layout();
            this.portSettingsGroup = new Group(this.composite2, 0);
            this.portSettingsGroup.setLayout(null);
            this.portSettingsGroup.setFont(SWTResourceManager.getFont(GDE.WIDGET_FONT_NAME, GDE.WIDGET_FONT_SIZE, 0));
            this.portSettingsGroup.setText(Messages.getString("GDE_MSGT0166"));
            this.portSettingsGroup.setBounds(12, 409, 524, 115);
            this.portSettingsGroup.addPaintListener(new PaintListener(){

                public void paintControl(PaintEvent evt) {
                    log.log(Level.FINEST, "portSettingsGroup.paintControl, event=" + String.valueOf(evt));
                    if (!DeviceSelectionDialog.this.portSettingsGroup.isDisposed()) {
                        if (DeviceSelectionDialog.this.portSettingsGroup.getEnabled()) {
                            DeviceSelectionDialog.this.baudeDescription.setEnabled(true);
                            DeviceSelectionDialog.this.baudeDescription.setEnabled(true);
                            DeviceSelectionDialog.this.dataBitsDescription.setEnabled(true);
                            DeviceSelectionDialog.this.stopbitsDescription.setEnabled(true);
                            DeviceSelectionDialog.this.parityDescription.setEnabled(true);
                            DeviceSelectionDialog.this.flowcontrolDescription.setEnabled(true);
                            DeviceSelectionDialog.this.dtrDescription.setEnabled(true);
                            DeviceSelectionDialog.this.rtsDescription.setEnabled(true);
                            DeviceSelectionDialog.this.baudeSelectLabel.setEnabled(true);
                            DeviceSelectionDialog.this.dataBitsSelectLabel.setEnabled(true);
                            DeviceSelectionDialog.this.stopBitsSelectLabel.setEnabled(true);
                            DeviceSelectionDialog.this.paritySelectLabel.setEnabled(true);
                            DeviceSelectionDialog.this.flowControlSelectLabel.setEnabled(true);
                        } else {
                            DeviceSelectionDialog.this.baudeDescription.setEnabled(false);
                            DeviceSelectionDialog.this.baudeDescription.setEnabled(false);
                            DeviceSelectionDialog.this.dataBitsDescription.setEnabled(false);
                            DeviceSelectionDialog.this.stopbitsDescription.setEnabled(false);
                            DeviceSelectionDialog.this.parityDescription.setEnabled(false);
                            DeviceSelectionDialog.this.flowcontrolDescription.setEnabled(false);
                            DeviceSelectionDialog.this.dtrDescription.setEnabled(false);
                            DeviceSelectionDialog.this.rtsDescription.setEnabled(false);
                            DeviceSelectionDialog.this.baudeSelectLabel.setEnabled(false);
                            DeviceSelectionDialog.this.dataBitsSelectLabel.setEnabled(false);
                            DeviceSelectionDialog.this.stopBitsSelectLabel.setEnabled(false);
                            DeviceSelectionDialog.this.paritySelectLabel.setEnabled(false);
                            DeviceSelectionDialog.this.flowControlSelectLabel.setEnabled(false);
                        }
                    }
                }
            });
            this.baudeDescription = new Label((Composite)this.portSettingsGroup, 0);
            this.baudeDescription.setFont(SWTResourceManager.getFont(GDE.WIDGET_FONT_NAME, GDE.WIDGET_FONT_SIZE, 0));
            this.baudeDescription.setText(Messages.getString("GDE_MSGT0167"));
            this.baudeDescription.setBounds(8, GDE.IS_MAC_COCOA ? 9 : 21, 100, 16);
            this.stopbitsDescription = new Label((Composite)this.portSettingsGroup, 0);
            this.stopbitsDescription.setFont(SWTResourceManager.getFont(GDE.WIDGET_FONT_NAME, GDE.WIDGET_FONT_SIZE, 0));
            this.stopbitsDescription.setText(Messages.getString("GDE_MSGT0168"));
            this.stopbitsDescription.setBounds(8, GDE.IS_MAC_COCOA ? 53 : 65, 100, 16);
            this.flowcontrolDescription = new Label((Composite)this.portSettingsGroup, 0);
            this.flowcontrolDescription.setFont(SWTResourceManager.getFont(GDE.WIDGET_FONT_NAME, GDE.WIDGET_FONT_SIZE, 0));
            this.flowcontrolDescription.setText(Messages.getString("GDE_MSGT0169"));
            this.flowcontrolDescription.setBounds(261, GDE.IS_MAC_COCOA ? 9 : 21, 100, 16);
            this.dataBitsDescription = new Label((Composite)this.portSettingsGroup, 0);
            this.dataBitsDescription.setFont(SWTResourceManager.getFont(GDE.WIDGET_FONT_NAME, GDE.WIDGET_FONT_SIZE, 0));
            this.dataBitsDescription.setText(Messages.getString("GDE_MSGT0170"));
            this.dataBitsDescription.setBounds(8, GDE.IS_MAC_COCOA ? 31 : 43, 100, 16);
            this.parityDescription = new Label((Composite)this.portSettingsGroup, 0);
            this.parityDescription.setBounds(8, GDE.IS_MAC_COCOA ? 74 : 86, 100, 16);
            this.parityDescription.setFont(SWTResourceManager.getFont(GDE.WIDGET_FONT_NAME, GDE.WIDGET_FONT_SIZE, 0));
            this.parityDescription.setText(Messages.getString("GDE_MSGT0171"));
            this.dtrDescription = new Label((Composite)this.portSettingsGroup, 0);
            this.dtrDescription.setFont(SWTResourceManager.getFont(GDE.WIDGET_FONT_NAME, GDE.WIDGET_FONT_SIZE, 0));
            this.dtrDescription.setText(Messages.getString("GDE_MSGT0172"));
            this.dtrDescription.setBounds(261, GDE.IS_MAC_COCOA ? 37 : 49, 105, 17);
            this.rtsDescription = new Label((Composite)this.portSettingsGroup, 0);
            this.rtsDescription.setFont(SWTResourceManager.getFont(GDE.WIDGET_FONT_NAME, GDE.WIDGET_FONT_SIZE, 0));
            this.rtsDescription.setText(Messages.getString("GDE_MSGT0173"));
            this.rtsDescription.setBounds(261, GDE.IS_MAC_COCOA ? 60 : 72, 77, 17);
            this.baudeSelectLabel = new Label((Composite)this.portSettingsGroup, 131072);
            this.baudeSelectLabel.setFont(SWTResourceManager.getFont(GDE.WIDGET_FONT_NAME, GDE.WIDGET_FONT_SIZE, 0));
            this.baudeSelectLabel.setBounds(115, GDE.IS_MAC_COCOA ? 11 : 23, 90, 19);
            this.stopBitsSelectLabel = new Label((Composite)this.portSettingsGroup, 131072);
            this.stopBitsSelectLabel.setFont(SWTResourceManager.getFont(GDE.WIDGET_FONT_NAME, GDE.WIDGET_FONT_SIZE, 0));
            this.stopBitsSelectLabel.setBounds(115, GDE.IS_MAC_COCOA ? 55 : 67, 90, 19);
            this.paritySelectLabel = new Label((Composite)this.portSettingsGroup, 131072);
            this.paritySelectLabel.setFont(SWTResourceManager.getFont(GDE.WIDGET_FONT_NAME, GDE.WIDGET_FONT_SIZE, 0));
            this.paritySelectLabel.setBounds(115, GDE.IS_MAC_COCOA ? 77 : 89, 90, 19);
            this.dataBitsSelectLabel = new Label((Composite)this.portSettingsGroup, 131072);
            this.dataBitsSelectLabel.setFont(SWTResourceManager.getFont(GDE.WIDGET_FONT_NAME, GDE.WIDGET_FONT_SIZE, 0));
            this.dataBitsSelectLabel.setBounds(115, GDE.IS_MAC_COCOA ? 33 : 45, 90, 19);
            this.flowControlSelectLabel = new Label((Composite)this.portSettingsGroup, 16384);
            this.flowControlSelectLabel.setFont(SWTResourceManager.getFont(GDE.WIDGET_FONT_NAME, GDE.WIDGET_FONT_SIZE, 0));
            this.flowControlSelectLabel.setBounds(372, GDE.IS_MAC_COCOA ? 9 : 21, 90, 19);
            this.dtrCheckBox = new Button((Composite)this.portSettingsGroup, 16416);
            this.dtrCheckBox.setFont(SWTResourceManager.getFont(GDE.WIDGET_FONT_NAME, GDE.WIDGET_FONT_SIZE, 0));
            this.dtrCheckBox.setBounds(372, GDE.IS_MAC_COCOA ? 37 : 49, 92, 17);
            this.dtrCheckBox.setText(Messages.getString("GDE_MSGT0174"));
            this.dtrCheckBox.setEnabled(false);
            this.rtsCheckBox = new Button((Composite)this.portSettingsGroup, 16416);
            this.rtsCheckBox.setFont(SWTResourceManager.getFont(GDE.WIDGET_FONT_NAME, GDE.WIDGET_FONT_SIZE, 0));
            this.rtsCheckBox.setBounds(372, GDE.IS_MAC_COCOA ? 60 : 72, 102, 17);
            this.rtsCheckBox.setText(Messages.getString("GDE_MSGT0175"));
            this.rtsCheckBox.setEnabled(false);
            this.desktopTabsGroup = new Group(this.composite2, 0);
            this.desktopTabsGroup.setBounds(12, 329, 524, 74);
            this.desktopTabsGroup.setFont(SWTResourceManager.getFont(GDE.WIDGET_FONT_NAME, GDE.WIDGET_FONT_SIZE, 0));
            this.desktopTabsGroup.setText(Messages.getString("GDE_MSGT0176"));
            this.desktopTabsGroup.setToolTipText(Messages.getString("GDE_MSGT0177"));
            this.desktopTabsGroup.setLayout((Layout)new RowLayout(256));
            new Composite((Composite)this.desktopTabsGroup, 0).setLayoutData((Object)new RowData(10, GDE.IS_WINDOWS ? 25 : 20));
            this.tableTabButton = new Button((Composite)this.desktopTabsGroup, 16416);
            this.tableTabButton.setLayoutData((Object)new RowData(GDE.IS_MAC ? 159 : 165, GDE.IS_WINDOWS ? 25 : 20));
            this.tableTabButton.setFont(SWTResourceManager.getFont(GDE.WIDGET_FONT_NAME, GDE.WIDGET_FONT_SIZE, 0));
            this.tableTabButton.setText(Messages.getString("GDE_MSGT0178"));
            this.tableTabButton.setToolTipText(Messages.getString("GDE_MSGT0179"));
            this.tableTabButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent evt) {
                    log.log(Level.FINEST, "tableTabButton.widgetSelected, event=" + String.valueOf(evt));
                    DeviceSelectionDialog.this.selectedActiveDeviceConfig.setTableTabRequested(DeviceSelectionDialog.this.tableTabButton.getSelection());
                    DeviceSelectionDialog.this.application.setDataTableTabItemVisible(DeviceSelectionDialog.this.selectedActiveDeviceConfig.isTableTabRequested());
                }
            });
            this.digitalTabButton = new Button((Composite)this.desktopTabsGroup, 16416);
            this.digitalTabButton.setLayoutData((Object)new RowData(GDE.IS_MAC ? 159 : 165, GDE.IS_WINDOWS ? 25 : 20));
            this.digitalTabButton.setFont(SWTResourceManager.getFont(GDE.WIDGET_FONT_NAME, GDE.WIDGET_FONT_SIZE, 0));
            this.digitalTabButton.setText(Messages.getString("GDE_MSGT0180"));
            this.digitalTabButton.setToolTipText(Messages.getString("GDE_MSGT0181"));
            this.digitalTabButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent evt) {
                    log.log(Level.FINEST, "digitalTabButton.widgetSelected, event=" + String.valueOf(evt));
                    DeviceSelectionDialog.this.selectedActiveDeviceConfig.setDigitalTabRequested(DeviceSelectionDialog.this.digitalTabButton.getSelection());
                    DeviceSelectionDialog.this.application.setDigitalTabItemVisible(DeviceSelectionDialog.this.selectedActiveDeviceConfig.isDigitalTabRequested());
                }
            });
            this.analogTabButton = new Button((Composite)this.desktopTabsGroup, 16416);
            this.analogTabButton.setLayoutData((Object)new RowData(GDE.IS_MAC ? 159 : 165, GDE.IS_WINDOWS ? 25 : 20));
            this.analogTabButton.setFont(SWTResourceManager.getFont(GDE.WIDGET_FONT_NAME, GDE.WIDGET_FONT_SIZE, 0));
            this.analogTabButton.setText(Messages.getString("GDE_MSGT0182"));
            this.analogTabButton.setToolTipText(Messages.getString("GDE_MSGT0183"));
            this.analogTabButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent evt) {
                    log.log(Level.FINEST, "analogTabButton.widgetSelected, event=" + String.valueOf(evt));
                    DeviceSelectionDialog.this.selectedActiveDeviceConfig.setAnalogTabRequested(DeviceSelectionDialog.this.analogTabButton.getSelection());
                    DeviceSelectionDialog.this.application.setAnalogTabItemVisible(DeviceSelectionDialog.this.selectedActiveDeviceConfig.isAnalogTabRequested());
                }
            });
            new Composite((Composite)this.desktopTabsGroup, 0).setLayoutData((Object)new RowData(10, GDE.IS_WINDOWS ? 25 : 20));
            this.voltagePerCellButton = new Button((Composite)this.desktopTabsGroup, 16416);
            this.voltagePerCellButton.setLayoutData((Object)new RowData(GDE.IS_MAC ? 159 : 165, GDE.IS_WINDOWS ? 25 : 20));
            this.voltagePerCellButton.setFont(SWTResourceManager.getFont(GDE.WIDGET_FONT_NAME, GDE.WIDGET_FONT_SIZE, 0));
            this.voltagePerCellButton.setText(Messages.getString("GDE_MSGT0184"));
            this.voltagePerCellButton.setToolTipText(Messages.getString("GDE_MSGT0185"));
            this.voltagePerCellButton.setEnabled(false);
            this.utilityDeviceButton = new Button((Composite)this.desktopTabsGroup, 16416);
            this.utilityDeviceButton.setLayoutData((Object)new RowData(GDE.IS_MAC ? 159 : 165, GDE.IS_WINDOWS ? 25 : 20));
            this.utilityDeviceButton.setFont(SWTResourceManager.getFont(GDE.WIDGET_FONT_NAME, GDE.WIDGET_FONT_SIZE, 0));
            this.utilityDeviceButton.setText(Messages.getString("GDE_MSGT0224"));
            this.utilityDeviceButton.setToolTipText(Messages.getString("GDE_MSGT0225"));
            this.utilityDeviceButton.setEnabled(false);
            this.utilityGraphicsButton = new Button((Composite)this.desktopTabsGroup, 16416);
            this.utilityGraphicsButton.setLayoutData((Object)new RowData(GDE.IS_MAC ? 159 : 165, GDE.IS_WINDOWS ? 25 : 20));
            this.utilityGraphicsButton.setFont(SWTResourceManager.getFont(GDE.WIDGET_FONT_NAME, GDE.WIDGET_FONT_SIZE, 0));
            this.utilityGraphicsButton.setText(Messages.getString("GDE_MSGT0226"));
            this.utilityGraphicsButton.setToolTipText(Messages.getString("GDE_MSGT0227"));
            this.utilityGraphicsButton.setEnabled(false);
            this.desktopTabsGroup.layout();
            this.overviewTabItem = new CTabItem(this.settingsTabFolder, 0);
            this.overviewTabItem.setFont(SWTResourceManager.getFont(GDE.WIDGET_FONT_NAME, GDE.WIDGET_FONT_SIZE, 0));
            this.overviewTabItem.setText(Messages.getString("GDE_MSGT0186"));
            this.deviceGroup = new Group((Composite)this.settingsTabFolder, 0);
            this.deviceGroup.setLayout((Layout)new FormLayout());
            this.overviewTabItem.setControl((Control)this.deviceGroup);
            this.deviceTable = new Table((Composite)this.deviceGroup, 67620);
            FormData deviceTableLData = new FormData();
            deviceTableLData.top = new FormAttachment(0, 1000, 20);
            deviceTableLData.bottom = new FormAttachment(1000, 1000, -20);
            deviceTableLData.left = new FormAttachment(0, 1000, 20);
            deviceTableLData.right = new FormAttachment(1000, 1000, -20);
            this.deviceTable.setLayoutData((Object)deviceTableLData);
            this.deviceTable.setBounds(17, 40, 497, 401);
            this.deviceTable.setFont(SWTResourceManager.getFont(GDE.WIDGET_FONT_NAME, GDE.WIDGET_FONT_SIZE, 0));
            this.deviceTable.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent evt) {
                    TableItem item = (TableItem)evt.item;
                    String deviceName = ((TableItem)evt.item).getText();
                    if (item.getChecked()) {
                        log.log(Level.FINE, "add device = " + deviceName);
                        try {
                            Settings.getInstance().extractDevicePropertiesAndTemplates(DeviceSelectionDialog.this.deviceServices.get(deviceName).getJarFile(), deviceName);
                            DeviceSelectionDialog.this.deviceConfigurations.add(Analyzer.getInstance(), deviceName, deviceName + ".xml", false);
                            DeviceConfiguration tmpDeviceConfiguration = DeviceSelectionDialog.this.deviceConfigurations.get(deviceName);
                            tmpDeviceConfiguration.setUsed(true);
                        }
                        catch (IOException e) {
                            DeviceSelectionDialog.this.application.openMessageDialogAsync(GDE.shell, String.format("failed adding %s", deviceName));
                        }
                        if (DeviceSelectionDialog.this.deviceConfigurations.size() >= 1) {
                            DeviceSelectionDialog.this.selectedActiveDeviceConfig = DeviceSelectionDialog.this.deviceConfigurations.get(deviceName);
                            if (DeviceSelectionDialog.this.selectedActiveDeviceConfig.getUsbPortType() != null) {
                                if (deviceName.startsWith("iCharger")) {
                                    if (GDE.IS_LINUX) {
                                        DeviceSelectionDialog.this.application.openMessageDialogAsync(GDE.shell, Messages.getString("GDE_MSGI0060"));
                                    } else if (GDE.IS_MAC) {
                                        DeviceSelectionDialog.this.application.openMessageDialogAsync(GDE.shell, Messages.getString("GDE_MSGI0061"));
                                    }
                                } else if (GDE.IS_LINUX) {
                                    DeviceSelectionDialog.this.application.openMessageDialogAsync(GDE.shell, Messages.getString("GDE_MSGI0057"));
                                } else if (GDE.IS_MAC) {
                                    DeviceSelectionDialog.this.application.openMessageDialogAsync(GDE.shell, Messages.getString("GDE_MSGI0058"));
                                }
                            }
                        }
                    } else {
                        log.log(Level.FINE, "remove device = " + deviceName);
                        DeviceConfiguration tmpDeviceConfiguration = DeviceSelectionDialog.this.deviceConfigurations.get(deviceName);
                        if (tmpDeviceConfiguration != null) {
                            tmpDeviceConfiguration.setUsed(false);
                            if (DeviceSelectionDialog.this.deviceConfigurations.contains(deviceName)) {
                                DeviceSelectionDialog.this.deviceConfigurations.remove(deviceName);
                                DeviceSelectionDialog.this.deviceConfigurations.synchronizeDeviceUse();
                            }
                            if (DeviceSelectionDialog.this.selectedActiveDeviceConfig != null && DeviceSelectionDialog.this.selectedActiveDeviceConfig.getName().equals(deviceName)) {
                                DeviceSelectionDialog.this.selectedActiveDeviceConfig = DeviceSelectionDialog.this.deviceConfigurations.size() > 0 ? DeviceSelectionDialog.this.deviceConfigurations.get(DeviceSelectionDialog.this.deviceConfigurations.get(0)) : null;
                            }
                        } else {
                            log.log(Level.WARNING, String.format("check %s in DataExplorer.properties versus %s.xml", deviceName, deviceName));
                        }
                    }
                    DeviceSelectionDialog.this.updateDialogEntries();
                }
            });
            this.deviceTable.setLinesVisible(true);
            this.deviceTable.setHeaderVisible(true);
            this.tableColumn1 = new TableColumn(this.deviceTable, 16384);
            this.tableColumn1.setText(Messages.getString("GDE_MSGT0668"));
            this.tableColumn1.setWidth(150);
            this.tableColumn2 = new TableColumn(this.deviceTable, 16384);
            this.tableColumn2.setText(Messages.getString("GDE_MSGT0669"));
            this.tableColumn2.setWidth(180);
            this.tableColumn3 = new TableColumn(this.deviceTable, 16384);
            this.tableColumn3.setText(Messages.getString("GDE_MSGT0670"));
            this.tableColumn3.setWidth(150);
            this.updateDeviceSelectionTable();
            this.settingsTabFolder.setSelection(0);
            this.settingsTabFolder.setBounds(0, 0, 559, 505);
            this.closeButton = new Button((Composite)this.dialogShell, 0x1000008);
            FormData closeButtonLData = new FormData();
            closeButtonLData.left = new FormAttachment(0, 1000, 15);
            closeButtonLData.bottom = new FormAttachment(1000, 1000, -10);
            closeButtonLData.right = new FormAttachment(1000, 1000, -15);
            closeButtonLData.height = 30;
            this.closeButton.setLayoutData((Object)closeButtonLData);
            this.closeButton.setFont(SWTResourceManager.getFont(GDE.WIDGET_FONT_NAME, GDE.WIDGET_FONT_SIZE, 0));
            this.closeButton.setText(Messages.getString("GDE_MSGT0188"));
            this.closeButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent evt) {
                    log.log(Level.FINE, "closeButton.widgetSelected, event=" + String.valueOf(evt));
                    DeviceSelectionDialog.this.dialogShell.dispose();
                }
            });
            this.initializeUI();
            this.updateAvailablePorts();
            this.dialogShell.setLocation(this.getParent().toDisplay(100, 10));
            this.dialogShell.open();
            Display display = this.dialogShell.getDisplay();
            while (!this.dialogShell.isDisposed()) {
                if (display.readAndDispatch()) continue;
                display.sleep();
            }
        }
        catch (Exception e) {
            log.log(Level.SEVERE, e.getMessage(), e);
            this.application.openMessageDialog(this.dialogShell, Messages.getString("GDE_MSGE0007") + e.getMessage());
        }
    }

    private void updateDeviceSelectionTable() {
        if (!this.isDisposed()) {
            this.deviceTable.removeAll();
            for (String deviceKey : this.deviceServices.keySet()) {
                log.log(Level.FINE, deviceKey);
                ExportService exportService = this.deviceServices.get(deviceKey);
                DeviceConfiguration devConfig = this.deviceConfigurations.get(deviceKey);
                TableItem item = new TableItem(this.deviceTable, 0);
                item.setText(new String[]{exportService.getName(), exportService.getManufacturer(), exportService.getDataFeed()});
                if (devConfig != null && devConfig.isUsed()) {
                    item.setChecked(true);
                    continue;
                }
                item.setChecked(false);
            }
        }
    }

    void updateDialogEntries() {
        if (this.activeDeviceName != null) {
            this.checkAndStoreDeviceConfiguration(this.activeDeviceName);
        }
        if (!this.isDisposed()) {
            log.log(Level.FINE, "active devices " + this.deviceConfigurations.toString());
            String[] list = this.deviceConfigurations.deviceNames().toArray(new String[this.deviceConfigurations.size()]);
            if (list.length > 0) {
                this.activeDeviceName = this.selectedActiveDeviceConfig == null ? this.deviceConfigurations.get(0) : this.selectedActiveDeviceConfig.getName();
                this.deviceSelectCombo.setItems(list);
                this.deviceSelectCombo.setVisibleItemCount(this.deviceConfigurations.size() + 1);
                this.deviceSelectCombo.select(this.deviceConfigurations.indexOf(this.activeDeviceName));
                log.log(Level.FINE, this.activeDeviceName + " - " + this.deviceConfigurations.indexOf(this.activeDeviceName));
                this.deviceSlider.setMaximum(this.deviceConfigurations.size());
                this.deviceSlider.setSelection(this.deviceConfigurations.indexOf(this.activeDeviceName));
                log.log(Level.FINE, "activeDevices.size() " + this.deviceConfigurations.size());
                if (this.deviceConfigurations.size() > 1) {
                    this.application.enableDeviceSwitchButtons(true);
                } else {
                    this.application.enableDeviceSwitchButtons(false);
                }
                this.selectedActiveDeviceConfig = this.deviceConfigurations.get(this.activeDeviceName);
            } else {
                this.selectedActiveDeviceConfig = null;
                this.activeDeviceName = "";
                this.deviceSelectCombo.setItems(new String[]{Messages.getString("GDE_MSGT0190")});
                this.deviceSelectCombo.setVisibleItemCount(1);
                this.deviceSelectCombo.select(0);
                log.log(Level.FINE, "no active device");
                this.deviceSlider.setMaximum(1);
                this.deviceSlider.setIncrement(0);
                this.deviceSlider.setSelection(0);
                log.log(Level.FINE, "activeDevices.size() = 0");
                this.application.updateTitleBar(this.application.getObjectKey(), "---", "---");
            }
            if (this.selectedActiveDeviceConfig == null) {
                log.log(Level.FINE, "activeDeviceConfig == null -> no device selected as active");
                this.application.setActiveDevice(null);
                this.manufacturerName.setText("---");
                this.deviceText.setText("---");
                this.deviceTypeText.setText("---");
                this.internetLinkText.setText("---");
                this.portSelectCombo.setItems(DeviceCommPort.prepareSerialPortList());
                this.portSelectCombo.select(0);
                this.baudeSelectLabel.setText("0");
                this.dataBitsSelectLabel.setText("0");
                this.stopBitsSelectLabel.setText("0");
                this.paritySelectLabel.setText("0");
                this.flowControlSelectLabel.setText("0");
                this.dtrCheckBox.setSelection(false);
                this.rtsCheckBox.setSelection(false);
            } else {
                IDevice selectedDevice = this.getInstanceOfDevice();
                if (selectedDevice != null) {
                    log.log(Level.FINE, Settings.getDevicesPath() + this.selectedActiveDeviceConfig.getImageFileName());
                    this.deviceImage = SWTResourceManager.getImage(selectedDevice, "resource/" + this.selectedActiveDeviceConfig.getImageFileName());
                    this.deviceCanvas.redraw();
                    this.manufacturerName.setText(this.selectedActiveDeviceConfig.getManufacturer());
                    this.deviceText.setText(this.selectedActiveDeviceConfig.getName());
                    this.deviceTypeText.setText(this.selectedActiveDeviceConfig.getDeviceGroup().name());
                    String link = this.selectedActiveDeviceConfig.getManufacturerURL() != null ? this.selectedActiveDeviceConfig.getManufacturerURL() : Messages.getString("GDE_MSGT0191");
                    this.internetLinkText.setText(link);
                    if (this.deviceConfigurations.get(this.activeDeviceName).getSerialPortType() != null && !this.deviceConfigurations.get(this.activeDeviceName).getSerialPortType().getPort().equals("USB") && !this.deviceConfigurations.get(this.activeDeviceName).getSerialPortType().getPort().equals("TCP")) {
                        if (!this.serialPortSelectionGroup.getEnabled() || !this.portSettingsGroup.getEnabled()) {
                            this.enableSerialPortEntries(true);
                        }
                        this.baudeSelectLabel.setText(this.selectedActiveDeviceConfig.getBaudeRate().toString());
                        this.dataBitsSelectLabel.setText(" " + this.selectedActiveDeviceConfig.getDataBits().toString().split("_")[1]);
                        this.stopBitsSelectLabel.setText(" " + this.selectedActiveDeviceConfig.getStopBits().toString().split("_")[1]);
                        this.paritySelectLabel.setText(" " + this.selectedActiveDeviceConfig.getParity().toString().split("_")[1]);
                        this.flowControlSelectLabel.setText(" " + this.selectedActiveDeviceConfig.getFlowCtrlModeString().split("_")[1]);
                        this.dtrCheckBox.setSelection(this.selectedActiveDeviceConfig.isDTR());
                        this.rtsCheckBox.setSelection(this.selectedActiveDeviceConfig.isRTS());
                    } else {
                        if (this.serialPortSelectionGroup.getEnabled() || this.portSettingsGroup.getEnabled()) {
                            this.enableSerialPortEntries(false);
                        }
                        this.baudeSelectLabel.setText(" - ");
                        this.dataBitsSelectLabel.setText(" - ");
                        this.stopBitsSelectLabel.setText(" - ");
                        this.paritySelectLabel.setText(" - ");
                        this.flowControlSelectLabel.setText(" - ");
                        this.dtrCheckBox.setSelection(false);
                        this.rtsCheckBox.setSelection(false);
                    }
                    if (this.availablePorts != null && this.availablePorts.size() > 0) {
                        this.portSelectCombo.setItems(DeviceCommPort.prepareSerialPortList());
                        int index = this.availablePorts.indexOf(this.selectedActiveDeviceConfig.getPort());
                        if (index > -1) {
                            this.portSelectCombo.select(index);
                        } else if (this.deviceConfigurations.get(this.activeDeviceName).getSerialPortType() != null) {
                            this.portSelectCombo.setText(Messages.getString("GDE_MSGT0197"));
                        } else if (this.deviceConfigurations.get(this.activeDeviceName).getUsbPortType() != null) {
                            this.portSelectCombo.setText("  USB");
                        } else if (this.deviceConfigurations.get(this.activeDeviceName).getTcpPortType() != null) {
                            this.portSelectCombo.setText("  TCP");
                        } else {
                            this.portSelectCombo.setText("  import");
                        }
                    } else {
                        this.portSelectCombo.setItems(new String[0]);
                        if (this.deviceConfigurations.get(this.activeDeviceName).getSerialPortType() != null) {
                            this.portSelectCombo.setText(Messages.getString("GDE_MSGT0199"));
                        } else if (this.deviceConfigurations.get(this.activeDeviceName).getUsbPortType() != null) {
                            this.portSelectCombo.setText("  USB");
                        } else if (this.deviceConfigurations.get(this.activeDeviceName).getTcpPortType() != null) {
                            this.portSelectCombo.setText("  TCP");
                        } else {
                            this.portSelectCombo.setText("  import");
                        }
                    }
                    this.tableTabButton.setSelection(this.selectedActiveDeviceConfig.isTableTabRequested());
                    this.digitalTabButton.setSelection(this.selectedActiveDeviceConfig.isDigitalTabRequested());
                    this.analogTabButton.setSelection(this.selectedActiveDeviceConfig.isAnalogTabRequested());
                    this.voltagePerCellButton.setSelection(this.selectedActiveDeviceConfig.isVoltagePerCellTabRequested());
                    this.utilityGraphicsButton.setSelection(this.selectedActiveDeviceConfig.isUtilityGraphicsTabRequested());
                    this.utilityDeviceButton.setSelection(this.selectedActiveDeviceConfig.isUtilityDeviceTabRequested());
                    this.application.updateTitleBar(this.application.getObjectKey(), this.selectedActiveDeviceConfig.getName(), this.selectedActiveDeviceConfig.getPort());
                    this.setupDevice();
                }
            }
        }
    }

    private void enableSerialPortEntries(boolean enable) {
        this.isUpdateSerialPorts = enable;
        this.serialPortSelectionGroup.setEnabled(enable);
        this.portDescription.setEnabled(enable);
        this.portSelectCombo.setEnabled(enable);
        this.portSettingsGroup.setEnabled(enable);
        this.portSettingsGroup.redraw();
    }

    public void setupDevice(String newDeviceName) throws NotSupportedException {
        int selection = this.deviceConfigurations.indexOf(newDeviceName = this.exchangeLegacyDeviceNames(newDeviceName));
        if (selection != -1 || this.deviceConfigurations.deviceNames().contains(newDeviceName)) {
            DeviceConfiguration tmpDeviceConfig = this.deviceConfigurations.get(newDeviceName);
            if (!tmpDeviceConfig.isUsed()) {
                tmpDeviceConfig.setUsed(true);
            }
            this.setActiveConfig(tmpDeviceConfig);
            this.setupDevice();
        } else if (selection == -1 && Settings.getInstance().getDeviceServices().get(newDeviceName) != null) {
            try {
                Settings.getInstance().extractDevicePropertiesAndTemplates(this.deviceServices.get(newDeviceName).getJarFile(), newDeviceName);
                this.deviceConfigurations.add(Analyzer.getInstance(), newDeviceName, newDeviceName + ".xml", false);
                DeviceConfiguration tmpDeviceConfig = this.deviceConfigurations.get(newDeviceName);
                if (!tmpDeviceConfig.isUsed()) {
                    tmpDeviceConfig.setUsed(true);
                }
                this.setActiveConfig(tmpDeviceConfig);
                this.setupDevice();
            }
            catch (Exception e) {
                log.log(Level.SEVERE, e.getMessage(), e);
                String msg = Messages.getString("GDE_MSGI0027", new Object[]{newDeviceName});
                throw new NotSupportedException(msg);
            }
        } else {
            String msg = Messages.getString("GDE_MSGI0027", new Object[]{newDeviceName});
            NotSupportedException e = new NotSupportedException(msg);
            log.log(Level.WARNING, e.getMessage(), e);
            throw e;
        }
    }

    private String exchangeLegacyDeviceNames(String checkoutDeviceName) {
        if (this.legacyDeviceNames.get(checkoutDeviceName) != null) {
            return this.legacyDeviceNames.get(checkoutDeviceName);
        }
        return checkoutDeviceName;
    }

    public void setupDevice() {
        IDevice previousActiveDevice = this.application.getActiveDevice();
        if (previousActiveDevice != null) {
            this.checkAndStoreDeviceConfiguration(previousActiveDevice);
            if (previousActiveDevice.getDialog() != null && !previousActiveDevice.getDialog().isDisposed()) {
                previousActiveDevice.getDialog().dispose();
            }
        }
        this.application.getMenuBar().cleanup();
        IDevice activeDevice = this.application.getActiveDevice();
        activeDevice = this.getInstanceOfDevice();
        if (activeDevice != null) {
            this.application.setActiveDevice(activeDevice);
            this.application.setDataTableTabItemVisible(activeDevice.isTableTabRequested());
            this.application.setDigitalTabItemVisible(activeDevice.isDigitalTabRequested());
            this.application.setAnalogTabItemVisible(activeDevice.isAnalogTabRequested());
            this.application.setCellVoltageTabItemVisible(activeDevice.isVoltagePerCellTabRequested());
            this.application.setUtilGraphicsWindowVisible(activeDevice.isUtilityGraphicsTabRequested(), "");
            this.application.registerCustomTabItem(activeDevice.isUtilityDeviceTabRequested() ? activeDevice.getUtilityDeviceTabItem() : null);
            this.setupDataChannels(activeDevice);
            this.application.setupDataTableHeader();
            this.application.updateDigitalWindow();
            this.application.updateAnalogWindow();
            this.application.setCellVoltageWindowOrdinal(activeDevice.getCellVoltageOrdinals());
            this.application.updateCellVoltageWindow();
            this.application.updateFileCommentWindow();
        }
    }

    public void setupDataChannels(IDevice activeDevice) {
        Channels channels = Channels.getInstance();
        channels.cleanup();
        if (activeDevice != null) {
            channels.setupChannels(Analyzer.getInstance());
            channels.switchChannel(activeDevice.getLastChannelNumber(), "");
        }
        this.application.setProgress(0, null);
    }

    public IDevice getInstanceOfDevice() {
        IDevice newInst = null;
        try {
            newInst = this.selectedActiveDeviceConfig.defineInstanceOfDevice();
        }
        catch (Exception e) {
            log.log(Level.SEVERE, e.getMessage(), e);
            String msg = e.getClass().getSimpleName() + " " + e.getMessage() + GDE.LINE_SEPARATOR + Messages.getString("GDE_MSGE0040", new String[]{this.selectedActiveDeviceConfig.getClassImplName()});
            this.application.openMessageDialog(this.dialogShell, msg);
            this.selectedActiveDeviceConfig.setUsed(false);
            this.selectedActiveDeviceConfig.storeDeviceProperties();
            String selectedDeviceName = this.selectedActiveDeviceConfig.getName();
            this.deviceConfigurations.remove(selectedDeviceName);
            this.selectedActiveDeviceConfig = this.deviceConfigurations.size() > 0 ? this.deviceConfigurations.get(this.deviceConfigurations.get(0)) : null;
            this.updateDeviceSelectionTable();
            this.updateDialogEntries();
        }
        return newInst;
    }

    public Slider getDeviceSlider() {
        return this.deviceSlider;
    }

    public DeviceConfiguration getActiveConfig() {
        return this.selectedActiveDeviceConfig;
    }

    public void setActiveConfig(DeviceConfiguration activeConfig) {
        this.selectedActiveDeviceConfig = activeConfig;
    }

    public DeviceConfigurations getDeviceConfigurations() {
        return this.deviceConfigurations;
    }

    public boolean isDeviceChanged() {
        IDevice activeDevice = this.application.getActiveDevice();
        boolean isFirstConfigSelected = this.selectedActiveDeviceConfig != null && activeDevice == null;
        boolean isDeviceSwitched = this.selectedActiveDeviceConfig != null && activeDevice != null && !this.selectedActiveDeviceConfig.getName().equals(activeDevice.getName());
        log.log(Level.FINE, "" + (isFirstConfigSelected || isDeviceSwitched));
        return isFirstConfigSelected || isDeviceSwitched;
    }

    public boolean checkDataSaved() {
        boolean result = true;
        Object unsaved = Channels.getInstance().checkRecordSetsSaved();
        if (((String)unsaved).length() != 0) {
            String msg;
            if (((String)unsaved).length() > 500) {
                unsaved = ((String)unsaved).substring(0, 500) + "........";
            }
            if (this.application.openOkCancelMessageDialog(msg = Messages.getString("GDE_MSGW0020") + ((String)unsaved).toString()) == 256) {
                result = false;
                log.log(Level.FINE, "SWT.CANCEL");
            }
        }
        return result;
    }

    void updateAvailablePorts() {
        this.listPortsThread = new Thread("updateAvailablePorts"){

            @Override
            public void run() {
                try {
                    while (DeviceSelectionDialog.this.dialogShell != null && !DeviceSelectionDialog.this.dialogShell.isDisposed()) {
                        if (DeviceSelectionDialog.this.isUpdateSerialPorts) {
                            DeviceSelectionDialog.this.availablePorts.clear();
                            DeviceSelectionDialog.this.availablePorts.addAll(DeviceCommPort.listConfiguredSerialPorts(DeviceSelectionDialog.this.settings.doPortAvailabilityCheck(), DeviceSelectionDialog.this.settings.isSerialPortBlackListEnabled() ? DeviceSelectionDialog.this.settings.getSerialPortBlackList() : "", DeviceSelectionDialog.this.settings.isSerialPortWhiteListEnabled() ? DeviceSelectionDialog.this.settings.getSerialPortWhiteList() : new Vector()).keySet());
                            if (DeviceSelectionDialog.this.dialogShell != null && !DeviceSelectionDialog.this.dialogShell.isDisposed()) {
                                GDE.display.syncExec(new Runnable(){

                                    @Override
                                    public void run() {
                                        if (!DeviceSelectionDialog.this.dialogShell.isDisposed() && DeviceSelectionDialog.this.selectedActiveDeviceConfig != null) {
                                            if (DeviceSelectionDialog.this.availablePorts != null && DeviceSelectionDialog.this.availablePorts.size() > 0) {
                                                DeviceSelectionDialog.this.portSelectCombo.setItems(DeviceCommPort.prepareSerialPortList());
                                                int index = DeviceSelectionDialog.this.availablePorts.indexOf(DeviceSelectionDialog.this.selectedActiveDeviceConfig.getPort());
                                                if (index > -1) {
                                                    DeviceSelectionDialog.this.portSelectCombo.select(index);
                                                } else if (DeviceSelectionDialog.this.deviceConfigurations.get(DeviceSelectionDialog.this.activeDeviceName).getSerialPortType() != null) {
                                                    DeviceSelectionDialog.this.portSelectCombo.setText(Messages.getString("GDE_MSGT0197"));
                                                } else if (DeviceSelectionDialog.this.deviceConfigurations.get(DeviceSelectionDialog.this.activeDeviceName).getUsbPortType() != null) {
                                                    DeviceSelectionDialog.this.portSelectCombo.setText("  USB");
                                                } else if (DeviceSelectionDialog.this.deviceConfigurations.get(DeviceSelectionDialog.this.activeDeviceName).getTcpPortType() != null) {
                                                    DeviceSelectionDialog.this.portSelectCombo.setText("  TCP");
                                                } else {
                                                    DeviceSelectionDialog.this.portSelectCombo.setText("  import");
                                                }
                                            } else {
                                                DeviceSelectionDialog.this.portSelectCombo.setItems(new String[0]);
                                                if (DeviceSelectionDialog.this.deviceConfigurations.get(DeviceSelectionDialog.this.activeDeviceName).getSerialPortType() != null) {
                                                    DeviceSelectionDialog.this.portSelectCombo.setText(Messages.getString("GDE_MSGT0198"));
                                                } else if (DeviceSelectionDialog.this.deviceConfigurations.get(DeviceSelectionDialog.this.activeDeviceName).getUsbPortType() != null) {
                                                    DeviceSelectionDialog.this.portSelectCombo.setText("  USB");
                                                } else if (DeviceSelectionDialog.this.deviceConfigurations.get(DeviceSelectionDialog.this.activeDeviceName).getTcpPortType() != null) {
                                                    DeviceSelectionDialog.this.portSelectCombo.setText("  TCP");
                                                } else {
                                                    DeviceSelectionDialog.this.portSelectCombo.setText("  import");
                                                }
                                            }
                                        }
                                    }
                                });
                            }
                        }
                        WaitTimer.delay(500L);
                    }
                }
                catch (Throwable t) {
                    log.log(Level.WARNING, t.getMessage(), t);
                }
                log.log(Level.TIME, "updateAvailablePortsThread time =", StringHelper.getFormatedTime("ss:SSS", new Date().getTime() - GDE.StartTime));
            }
        };
        this.listPortsThread.start();
    }

    public int getNumberOfActiveDevices() {
        return this.deviceConfigurations.size();
    }

    public boolean isDisposed() {
        return this.dialogShell != null && this.dialogShell.isDisposed();
    }

    private void initializeUI() {
        if (this.deviceSelectCombo.getSelectionIndex() < 0 && this.deviceSelectCombo.getItemCount() > 0) {
            this.updateDialogEntries();
        }
        if (!this.serialPortSelectionGroup.getEnabled()) {
            this.portDescription.setEnabled(false);
            this.portSelectCombo.setEnabled(false);
        } else {
            this.portDescription.setEnabled(true);
            this.portSelectCombo.setEnabled(true);
        }
    }

    public void checkAndStoreDeviceConfiguration(String deviceName) {
        DeviceConfiguration configuration;
        if (!deviceName.equals("---") && (configuration = this.deviceConfigurations.get(deviceName)) != null && configuration.isChangePropery()) {
            log.log(Level.FINE, configuration.isChangePropery() + " update device properties for " + configuration.getName());
            configuration.storeDeviceProperties();
        }
    }

    public void checkAndStoreDeviceConfiguration(IDevice device) {
        DeviceConfiguration configuration = device.getDeviceConfiguration();
        if (configuration.isChangePropery()) {
            log.log(Level.FINE, configuration.isChangePropery() + " update device properties for " + configuration.getName());
            configuration.storeDeviceProperties();
        }
    }
}

