/*
 * Decompiled with CFR 0.152.
 */
package gde.histo.recordings;

import gde.histo.recordings.TrailRecord;
import gde.histo.recordings.TrailRecordFormatter;
import gde.histo.utils.ElementaryQuantile;
import gde.histo.utils.SingleResponseRegression;
import gde.histo.utils.Spot;
import gde.histo.utils.UniversalQuantile;
import gde.log.Logger;
import java.util.Arrays;
import java.util.Date;
import java.util.Iterator;
import java.util.List;

public final class TrailRecordSection {
    private static final String $CLASS_NAME = TrailRecordSection.class.getName();
    private static final Logger log = Logger.getLogger($CLASS_NAME);
    private final TrailRecord trailrecord;
    private final long lowestTimeStamp_ms;
    private final long topTimeStamp_ms;
    private final SingleResponseRegression<Double> regression;
    private final ElementaryQuantile<Double> quantile;
    private final int[] indexFirstLast;

    public TrailRecordSection(TrailRecord trailrecord, long timeStamp1_ms, long timeStamp2_ms) {
        if (timeStamp1_ms <= 0L || timeStamp2_ms <= 0L) {
            throw new IllegalArgumentException();
        }
        this.trailrecord = trailrecord;
        this.lowestTimeStamp_ms = Math.min(timeStamp1_ms, timeStamp2_ms);
        this.topTimeStamp_ms = Math.max(timeStamp1_ms, timeStamp2_ms);
        this.indexFirstLast = trailrecord.defineRangeIndices(timeStamp1_ms, timeStamp2_ms);
        List subPoints = trailrecord.getSubPoints(this.indexFirstLast[0], this.indexFirstLast[1] + 1);
        if (!subPoints.isEmpty()) {
            this.quantile = ElementaryQuantile.createElementarySpotQuantile(subPoints, trailrecord.getParent().getAnalyzer().getSettings());
            UniversalQuantile<Double> tmpQuantile = UniversalQuantile.createUniversalSpotQuantile(subPoints, 0.674489694, 1.5, trailrecord.getParent().getAnalyzer().getSettings());
            List<Double> outliers = tmpQuantile.getOutliers();
            Iterator<Spot<Double>> iterator = subPoints.iterator();
            while (iterator.hasNext()) {
                Spot<Double> spot = iterator.next();
                if (!outliers.contains(spot.y())) continue;
                iterator.remove();
            }
            this.regression = new SingleResponseRegression(subPoints, SingleResponseRegression.RegressionType.QUADRATIC);
            log.finer(() -> String.format("xAxisSize=%d regressionRealSize=%d starts at %tF %tR", this.quantile.getSize(), this.regression.getRealSize(), new Date(timeStamp1_ms), new Date(timeStamp1_ms)));
        } else {
            this.regression = null;
            this.quantile = null;
        }
    }

    public double getBoundedAvgValue() {
        return this.regression.getAvg();
    }

    public double getBoundedSlopeValue(long timeStamp_ms) {
        return this.regression.getResponse(timeStamp_ms);
    }

    public double[] getBoundedBoxplotValues() {
        return this.quantile.getTukeyBoxPlot();
    }

    public boolean isValidBounds() {
        return this.regression != null || this.quantile != null;
    }

    public List<Spot<Double>> getBoundedParabolaValues() {
        return this.regression.getResponse();
    }

    public double getBoundedParabolaValue(long timeStamp_ms) {
        return this.regression.getResponse(timeStamp_ms);
    }

    public boolean isBoundedParabola() {
        return this.regression.getGamma() != 0.0;
    }

    public String getFormattedBoundsAvg() {
        return new TrailRecordFormatter(this.trailrecord).getScaleValue(this.regression.getAvg());
    }

    public String getFormattedBoundsDelta() {
        return new TrailRecordFormatter(this.trailrecord).getScaleValue(0.0 - this.regression.getDelta());
    }

    public String getFormattedBoundsSlope() {
        return new TrailRecordFormatter(this.trailrecord).getScaleValue(this.regression.getSlope() * 3600000.0 * 24.0 * 365.0 / 12.0);
    }

    public long getLowestTimeStamp_ms() {
        return this.lowestTimeStamp_ms;
    }

    public long getTopTimeStamp_ms() {
        return this.topTimeStamp_ms;
    }

    public boolean isSectionTimeStamp(long timeStamp_ms) {
        return timeStamp_ms >= this.lowestTimeStamp_ms && timeStamp_ms <= this.topTimeStamp_ms;
    }

    public int[] getIndexFirstLast() {
        return this.indexFirstLast;
    }

    public String toString() {
        return "[lowestTimeStamp_ms=" + this.lowestTimeStamp_ms + ", topTimeStamp_ms=" + this.topTimeStamp_ms + ", indexFirstLast=" + Arrays.toString(this.indexFirstLast) + ", trailrecord=" + String.valueOf(this.trailrecord) + " ]";
    }
}

