/*
 * Decompiled with CFR 0.152.
 */
package gde.device.skyrc;

import gde.comm.DeviceCommPort;
import gde.comm.IDeviceCommPort;
import gde.device.IDevice;
import gde.device.InputTypes;
import gde.exception.TimeOutException;
import gde.log.Level;
import gde.ui.DataExplorer;
import gde.utils.Checksum;
import gde.utils.StringHelper;
import java.util.logging.Logger;
import javax.usb.UsbException;
import javax.usb.UsbInterface;

public class MC3000UsbPort
extends DeviceCommPort
implements IDeviceCommPort {
    static final String $CLASS_NAME = MC3000UsbPort.class.getName();
    static final Logger log = Logger.getLogger($CLASS_NAME);
    protected static final short VENDOR_ID = 0;
    protected static final short PRODUCT_ID = 1;
    protected static final byte INTERFACE_ID = 1;
    protected static final byte IN_ENDPOINT = -127;
    protected static final byte OUT_ENDPOINT = 1;
    protected static final int TIMEOUT = 1000;
    protected final byte interfaceId;
    protected final byte endpointIn;
    protected final byte endpointOut;
    byte[] GET_SYSTEM_SETTING = new byte[]{15, 4, 90, 0, 0, 90, -1, -1};
    byte[] START_PROCESSING = new byte[]{15, 3, 5, 0, 5, -1, -1, -1};
    byte[] STOP_PROCESSING = new byte[]{15, 3, -2, 0, -2, -1, -1, -1};
    final int dataSize = this.deviceConfig.getDataBlockSize(InputTypes.SERIAL_IO);
    final int terminalDataSize = 345;
    int retrys = 1;

    public MC3000UsbPort(IDevice currentDevice, DataExplorer currentApplication) {
        super(currentDevice, currentApplication);
        this.interfaceId = this.device.getUsbInterface();
        this.endpointIn = this.device.getUsbEndpointIn();
        this.endpointOut = this.device.getUsbEndpointOut();
        byte[] tmpData = new byte[Math.abs(this.dataSize)];
        System.arraycopy(TakeMtuData.SLOT_0.value(), 0, tmpData, 0, TakeMtuData.SLOT_0.value().length);
        TakeMtuData.SLOT_0.setValue(tmpData);
        tmpData = new byte[Math.abs(this.dataSize)];
        System.arraycopy(TakeMtuData.SLOT_1.value(), 0, tmpData, 0, TakeMtuData.SLOT_1.value().length);
        TakeMtuData.SLOT_1.setValue(tmpData);
        tmpData = new byte[Math.abs(this.dataSize)];
        System.arraycopy(TakeMtuData.SLOT_2.value(), 0, tmpData, 0, TakeMtuData.SLOT_2.value().length);
        TakeMtuData.SLOT_2.setValue(tmpData);
        tmpData = new byte[Math.abs(this.dataSize)];
        System.arraycopy(TakeMtuData.SLOT_3.value(), 0, tmpData, 0, TakeMtuData.SLOT_3.value().length);
        TakeMtuData.SLOT_3.setValue(tmpData);
        tmpData = new byte[Math.abs(this.dataSize)];
        System.arraycopy(QuerySlotData.SLOT_0.value(), 0, tmpData, 0, QuerySlotData.SLOT_0.value().length);
        QuerySlotData.SLOT_0.setValue(tmpData);
        tmpData = new byte[Math.abs(this.dataSize)];
        System.arraycopy(QuerySlotData.SLOT_1.value(), 0, tmpData, 0, QuerySlotData.SLOT_1.value().length);
        QuerySlotData.SLOT_1.setValue(tmpData);
        tmpData = new byte[Math.abs(this.dataSize)];
        System.arraycopy(QuerySlotData.SLOT_2.value(), 0, tmpData, 0, QuerySlotData.SLOT_2.value().length);
        QuerySlotData.SLOT_2.setValue(tmpData);
        tmpData = new byte[Math.abs(this.dataSize)];
        System.arraycopy(QuerySlotData.SLOT_3.value(), 0, tmpData, 0, QuerySlotData.SLOT_3.value().length);
        QuerySlotData.SLOT_3.setValue(tmpData);
        tmpData = new byte[Math.abs(this.dataSize)];
        System.arraycopy(this.GET_SYSTEM_SETTING, 0, tmpData, 0, this.GET_SYSTEM_SETTING.length);
        this.GET_SYSTEM_SETTING = tmpData;
        tmpData = new byte[Math.abs(this.dataSize)];
        System.arraycopy(this.START_PROCESSING, 0, tmpData, 0, this.START_PROCESSING.length);
        this.START_PROCESSING = tmpData;
        tmpData = new byte[Math.abs(this.dataSize)];
        System.arraycopy(this.STOP_PROCESSING, 0, tmpData, 0, this.STOP_PROCESSING.length);
        this.STOP_PROCESSING = tmpData;
    }

    public synchronized void startProcessing(UsbInterface usbInterface) throws Exception {
        String $METHOD_NAME = "startProcessing";
        UsbInterface iface = null;
        boolean isPortOpenedByCall = false;
        try {
            if (usbInterface == null) {
                iface = this.openUsbPort(this.device);
                isPortOpenedByCall = true;
            }
            iface = usbInterface == null ? this.openUsbPort(this.device) : usbInterface;
            this.write(iface, this.endpointIn, this.START_PROCESSING);
        }
        catch (Exception e) {
            if (!(e instanceof TimeOutException)) {
                log.logp(Level.SEVERE, $CLASS_NAME, "startProcessing", e.getMessage(), e);
            }
            throw e;
        }
        finally {
            if (isPortOpenedByCall) {
                this.closeUsbPort(iface);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void stopProcessing(UsbInterface usbInterface) {
        String $METHOD_NAME = "stopProcessing";
        UsbInterface iface = null;
        boolean isPortOpenedByCall = false;
        try {
            if (usbInterface == null) {
                iface = this.openUsbPort(this.device);
                isPortOpenedByCall = true;
            }
            iface = usbInterface == null ? this.openUsbPort(this.device) : usbInterface;
            this.write(iface, this.endpointIn, this.STOP_PROCESSING);
        }
        catch (Exception e) {
            if (!(e instanceof TimeOutException)) {
                log.logp(Level.SEVERE, $CLASS_NAME, "stopProcessing", e.getMessage(), e);
            }
        }
        finally {
            if (isPortOpenedByCall) {
                try {
                    this.closeUsbPort(iface);
                }
                catch (Throwable e) {
                    log.logp(Level.SEVERE, $CLASS_NAME, "stopProcessing", e.getMessage(), e);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized byte[] getSystemSettings(UsbInterface usbInterface) throws Exception {
        String $METHOD_NAME = "getSystemSettings";
        byte[] data = new byte[Math.abs(this.dataSize)];
        UsbInterface iface = null;
        boolean isPortOpenedByCall = false;
        try {
            if (usbInterface == null) {
                iface = this.openUsbPort(this.device);
                isPortOpenedByCall = true;
            }
            iface = usbInterface == null ? this.openUsbPort(this.device) : usbInterface;
            this.write(iface, this.endpointIn, this.GET_SYSTEM_SETTING);
            try {
                Thread.sleep(10L);
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.read(iface, this.endpointOut, data);
            if (log.isLoggable(Level.FINE)) {
                log.logp(Level.FINE, $CLASS_NAME, "getSystemSettings", StringHelper.byte2Hex2CharString((byte[])data, (int)data.length));
            }
            if (log.isLoggable(Level.FINE)) {
                log.logp(Level.FINE, $CLASS_NAME, "getSystemSettings", String.format("Checksum = 0x%02X -> %b", MC3000UsbPort.calculateCheckSum(data, data.length - 2), this.isChecksumOK(data, 16, 30, 31)));
            }
            if (!this.isChecksumOK(data, 16, 30, 31) && this.retrys-- >= 0) {
                log.logp(Level.WARNING, $CLASS_NAME, "getSystemSettings", String.format("Error: Checksum = 0x%02X -> %b", MC3000UsbPort.calculateCheckSum(data, data.length - 2), this.isChecksumOK(data, 16, 30, 31)));
                byte[] byArray = this.getSystemSettings(iface);
                return byArray;
            }
        }
        catch (Exception e) {
            log.logp(Level.WARNING, $CLASS_NAME, "getSystemSettings", e.getMessage(), e);
        }
        finally {
            if (isPortOpenedByCall) {
                this.closeUsbPort(iface);
            }
        }
        this.retrys = 1;
        return data;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized byte[] setSlotProgram(UsbInterface usbInterface, byte[] buffer) throws Exception {
        String $METHOD_NAME = "setSlotProgram";
        byte[] data = new byte[Math.abs(this.dataSize)];
        UsbInterface iface = null;
        boolean isPortOpenedByCall = false;
        try {
            if (usbInterface == null) {
                iface = this.openUsbPort(this.device);
                isPortOpenedByCall = true;
            }
            if (log.isLoggable(Level.FINE)) {
                log.logp(Level.FINE, $CLASS_NAME, "setSlotProgram", StringHelper.byte2Hex2CharString((byte[])buffer, (int)buffer.length));
            }
            iface = usbInterface == null ? this.openUsbPort(this.device) : usbInterface;
            this.write(iface, this.endpointIn, buffer);
            try {
                Thread.sleep(10L);
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.read(iface, this.endpointOut, data);
            if (log.isLoggable(Level.FINE)) {
                log.logp(Level.FINE, $CLASS_NAME, "setSlotProgram", StringHelper.byte2Hex2CharString((byte[])data, (int)data.length));
            }
            if ((data[0] & 0xFF) != 240) {
                log.logp(Level.WARNING, $CLASS_NAME, "setSlotProgram", StringHelper.byte2Hex2CharString((byte[])data, (int)data.length));
                throw new UsbException("Error: answer != 0xF0");
            }
        }
        catch (Exception e) {
            log.logp(Level.WARNING, $CLASS_NAME, "setSlotProgram", e.getMessage(), e);
        }
        finally {
            if (isPortOpenedByCall) {
                this.closeUsbPort(iface);
            }
        }
        this.retrys = 1;
        return data;
    }

    public synchronized byte[] getData(UsbInterface iface, byte[] request) throws Exception {
        String $METHOD_NAME = "getData";
        byte[] data = new byte[Math.abs(this.dataSize)];
        try {
            this.write(iface, this.endpointIn, request);
            try {
                Thread.sleep(10L);
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.read(iface, this.endpointOut, data);
            if (log.isLoggable(Level.FINE)) {
                log.logp(Level.FINE, $CLASS_NAME, "getData", StringHelper.byte2Hex2CharString((byte[])data, (int)data.length));
            }
            if (log.isLoggable(Level.FINER)) {
                log.logp(Level.FINER, $CLASS_NAME, "getData", String.format("Checksum = 0x%02X -> %b", MC3000UsbPort.calculateCheckSum(data), this.isChecksumOK(data)));
            }
            if (!this.isChecksumOK(data) && this.retrys-- >= 0) {
                log.logp(Level.WARNING, $CLASS_NAME, "getData", String.format("Error: Checksum = 0x%02X -> %b", MC3000UsbPort.calculateCheckSum(data), this.isChecksumOK(data)));
                return this.getData(iface, request);
            }
        }
        catch (Exception e) {
            log.logp(Level.WARNING, $CLASS_NAME, "getData", e.getMessage(), e);
        }
        this.retrys = 1;
        return data;
    }

    public synchronized byte[] getSlotData(UsbInterface iface, byte[] request) throws Exception {
        String $METHOD_NAME = "getSlotData";
        byte[] data = new byte[Math.abs(this.dataSize)];
        try {
            this.write(iface, this.endpointIn, request);
            if (log.isLoggable(Level.FINE)) {
                log.logp(Level.FINE, $CLASS_NAME, "getSlotData", StringHelper.byte2Hex2CharString((byte[])request, (int)request.length));
            }
            try {
                Thread.sleep(10L);
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.read(iface, this.endpointOut, data);
            if (log.isLoggable(Level.FINE)) {
                log.logp(Level.FINE, $CLASS_NAME, "getSlotData", StringHelper.byte2Hex2CharString((byte[])data, (int)data.length));
            }
            if (log.isLoggable(Level.FINE)) {
                log.logp(Level.FINE, $CLASS_NAME, "getSlotData", String.format("Checksum = 0x%02X -> %b", MC3000UsbPort.calculateCheckSum(data), this.isChecksumOK(data)));
            }
            if (!this.isChecksumOK(data) && this.retrys-- >= 0) {
                log.logp(Level.WARNING, $CLASS_NAME, "getSlotData", String.format("Error: Checksum = 0x%02X -> %b", MC3000UsbPort.calculateCheckSum(data), this.isChecksumOK(data)));
                return this.getData(iface, request);
            }
        }
        catch (Exception e) {
            log.logp(Level.WARNING, $CLASS_NAME, "getSlotData", e.getMessage(), e);
        }
        this.retrys = 1;
        return data;
    }

    public static byte calculateCheckSum(byte[] buffer) {
        return (byte)(Checksum.ADD((byte[])buffer, (int)0, (int)(buffer.length - 2)) % 256);
    }

    public static byte calculateCheckSum(byte[] buffer, int length) {
        return (byte)(Checksum.ADD((byte[])buffer, (int)2, (int)length) % 256);
    }

    private boolean isChecksumOK(byte[] buffer, int start, int end, int chkSumPosition) {
        String $METHOD_NAME = "isChecksumOK";
        log.logp(Level.FINER, $CLASS_NAME, "isChecksumOK", "CheckSum = " + Checksum.ADD((byte[])buffer, (int)start, (int)end));
        return Checksum.ADD((byte[])buffer, (int)start, (int)end) == 256 - buffer[chkSumPosition];
    }

    private boolean isChecksumOK(byte[] buffer) {
        String $METHOD_NAME = "isChecksumOK";
        log.logp(Level.FINER, $CLASS_NAME, "isChecksumOK", "CheckSum = " + Checksum.ADD((byte[])buffer, (int)2, (int)(buffer.length - 2)));
        return MC3000UsbPort.calculateCheckSum(buffer) == buffer[buffer.length - 1];
    }

    public static enum TakeMtuData {
        SLOT_0(new byte[]{15, 4, 85, 0, 0, 85, -1, -1}),
        SLOT_1(new byte[]{15, 4, 85, 0, 1, 86, -1, -1}),
        SLOT_2(new byte[]{15, 4, 85, 0, 2, 87, -1, -1}),
        SLOT_3(new byte[]{15, 4, 85, 0, 3, 88, -1, -1});

        private byte[] value;

        private TakeMtuData(byte[] v) {
            this.value = v;
        }

        public byte[] value() {
            return this.value;
        }

        public void setValue(byte[] newValue) {
            this.value = newValue;
        }
    }

    public static enum QuerySlotData {
        SLOT_0(new byte[]{15, 4, 95, 0, 0, 95, -1, -1}),
        SLOT_1(new byte[]{15, 4, 95, 0, 1, 96, -1, -1}),
        SLOT_2(new byte[]{15, 4, 95, 0, 2, 97, -1, -1}),
        SLOT_3(new byte[]{15, 4, 95, 0, 3, 98, -1, -1});

        private byte[] value;

        private QuerySlotData(byte[] v) {
            this.value = v;
        }

        public byte[] value() {
            return this.value;
        }

        public void setValue(byte[] newValue) {
            this.value = newValue;
        }
    }
}

