/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.graphics;

import org.eclipse.swt.SWT;

public final class FontData {
    public String name;
    public float height;
    public int style;
    public String nsName;
    String lang;
    String country;
    String variant;

    public FontData() {
        this("", 12, 0);
    }

    public FontData(String string2) {
        if (string2 == null) {
            SWT.error(4);
        }
        int start = 0;
        int end = string2.indexOf(124);
        if (end == -1) {
            SWT.error(5);
        }
        String version1 = string2.substring(start, end);
        try {
            if (Integer.parseInt(version1) != 1) {
                SWT.error(5);
            }
        }
        catch (NumberFormatException numberFormatException) {
            SWT.error(5);
        }
        if ((end = string2.indexOf(124, start = end + 1)) == -1) {
            SWT.error(5);
        }
        String name = string2.substring(start, end);
        start = end + 1;
        if ((end = string2.indexOf(124, start)) == -1) {
            SWT.error(5);
        }
        float height = 0.0f;
        try {
            height = Float.parseFloat(string2.substring(start, end));
        }
        catch (NumberFormatException numberFormatException) {
            SWT.error(5);
        }
        start = end + 1;
        end = string2.indexOf(124, start);
        if (end == -1) {
            SWT.error(5);
        }
        int style = 0;
        try {
            style = Integer.parseInt(string2.substring(start, end));
        }
        catch (NumberFormatException numberFormatException) {
            SWT.error(5);
        }
        start = end + 1;
        end = string2.indexOf(124, start);
        this.setName(name);
        this.setHeight(height);
        this.setStyle(style);
        if (end == -1) {
            return;
        }
        String platform = string2.substring(start, end);
        start = end + 1;
        if ((end = string2.indexOf(124, start)) == -1) {
            return;
        }
        String version2 = string2.substring(start, end);
        if (platform.equals("COCOA") && version2.equals("1") && (start = end + 1) < (end = string2.length())) {
            this.nsName = string2.substring(start, end);
        }
    }

    public FontData(String name, int height, int style) {
        this.setName(name);
        this.setHeight(height);
        this.setStyle(style);
    }

    FontData(String name, float height, int style) {
        this.setName(name);
        this.setHeight(height);
        this.setStyle(style);
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof FontData)) {
            return false;
        }
        FontData data2 = (FontData)object;
        return this.name.equals(data2.name) && this.height == data2.height && this.style == data2.style;
    }

    public int getHeight() {
        return (int)this.height;
    }

    float getHeightF() {
        return this.height;
    }

    public String getLocale() {
        String result2;
        int length;
        StringBuffer buffer = new StringBuffer();
        char sep = '_';
        if (this.lang != null) {
            buffer.append(this.lang);
            buffer.append(sep);
        }
        if (this.country != null) {
            buffer.append(this.country);
            buffer.append(sep);
        }
        if (this.variant != null) {
            buffer.append(this.variant);
        }
        if ((length = (result2 = buffer.toString()).length()) > 0 && result2.charAt(length - 1) == sep) {
            result2 = result2.substring(0, length - 1);
        }
        return result2;
    }

    public String getName() {
        return this.name;
    }

    public int getStyle() {
        return this.style;
    }

    public int hashCode() {
        return this.name.hashCode() ^ this.getHeight() << 8 ^ this.style;
    }

    public void setHeight(int height) {
        if (height < 0) {
            SWT.error(5);
        }
        this.height = height;
    }

    void setHeight(float height) {
        if (height < 0.0f) {
            SWT.error(5);
        }
        this.height = height;
    }

    public void setLocale(String locale) {
        this.variant = null;
        this.country = null;
        this.lang = null;
        if (locale != null) {
            int secondSep;
            int sep = 95;
            int length = locale.length();
            int firstSep = locale.indexOf(sep);
            if (firstSep == -1) {
                firstSep = secondSep = length;
            } else {
                secondSep = locale.indexOf(sep, firstSep + 1);
                if (secondSep == -1) {
                    secondSep = length;
                }
            }
            if (firstSep > 0) {
                this.lang = locale.substring(0, firstSep);
            }
            if (secondSep > firstSep + 1) {
                this.country = locale.substring(firstSep + 1, secondSep);
            }
            if (length > secondSep + 1) {
                this.variant = locale.substring(secondSep + 1);
            }
        }
    }

    public void setName(String name) {
        if (name == null) {
            SWT.error(4);
        }
        this.name = name;
        this.nsName = null;
    }

    public void setStyle(int style) {
        this.style = style;
        this.nsName = null;
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer(128);
        buffer.append("1|");
        buffer.append(this.getName());
        buffer.append("|");
        buffer.append(this.getHeightF());
        buffer.append("|");
        buffer.append(this.getStyle());
        buffer.append("|");
        buffer.append("COCOA|1|");
        if (this.nsName != null) {
            buffer.append(this.nsName);
        }
        return buffer.toString();
    }
}

