/*
 * Decompiled with CFR 0.152.
 */
package gde.device.graupner;

import gde.io.DataParser;
import gde.messages.Messages;
import gde.ui.DataExplorer;
import gde.utils.Checksum;
import gde.utils.FileUtils;
import gde.utils.StringHelper;
import java.io.BufferedReader;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FilterInputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.logging.Level;
import java.util.logging.Logger;

public enum Transmitter {
    MC_32("mc-32"),
    MC_28("mc-28"),
    MC_26("mc-26"),
    MC_20("mc-20"),
    MX_20("mx-20"),
    MC_16("mc-16"),
    MX_16("mx-16"),
    MX_12("mx-12"),
    UNSPECIFIED("unspecified");

    static final Logger log;
    public static final byte[] mc_32_PROD_CODE;
    public static final byte[] mc_28_PROD_CODE;
    public static final byte[] mc_26_PROD_CODE;
    public static final byte[] mc_20_PROD_CODE;
    public static final byte[] mx_20_PROD_CODE;
    public static final byte[] mc_16_PROD_CODE;
    public static final byte[] mx_16_PROD_CODE;
    public static final byte[] mx_12_PROD_CODE;
    public static final byte[] mc_32_APP_VERSION;
    public static final byte[] mc_28_APP_VERSION;
    public static final byte[] mc_26_APP_VERSION;
    public static final byte[] mc_20_APP_VERSION;
    public static final byte[] mx_20_APP_VERSION;
    public static final byte[] mc_16_APP_VERSION;
    public static final byte[] mx_16_APP_VERSION;
    public static final byte[] mx_12_APP_VERSION;
    public static final byte[] MEMORY_VERSION;
    public static final byte[] mc_32_MEM_INFO;
    public static final byte[] mc_28_MEM_INFO;
    public static final byte[] mc_26_MEM_INFO;
    public static final byte[] mc_20_MEM_INFO;
    public static final byte[] mx_20_MEM_INFO;
    public static final byte[] mc_16_MEM_INFO;
    public static final int[] mc_32_20_0x1840_0x1988;
    public static final int[] mc_32_20_0x1840;
    public static final int[] mc_32_20_0x198A_0x1AB6;
    public static final int[] mc_32_20_0x198A;
    public static final int[] mc_32_20_0x1AC5_0x1EDF;
    public static final int[] mc_32_20_0x1AC5;
    public static final int[] mc_32_20_0x21C2_0x238A;
    public static final int[] mc_32_20_0x21C2;
    private final String value;

    private Transmitter(String v) {
        this.value = v;
    }

    public String value() {
        return this.value;
    }

    public static Transmitter fromValue(String v) {
        for (Transmitter c : Transmitter.values()) {
            if (!c.value.equals(v)) continue;
            return c;
        }
        throw new IllegalArgumentException(v);
    }

    public static Transmitter detectTransmitter(String fileName, String fqPathName) {
        byte[] inBytes = new byte[321];
        DataInputStream in = null;
        try {
            in = new DataInputStream(new FileInputStream(new File(fqPathName)));
            in.read(inBytes);
            in.close();
        }
        catch (Exception e) {
            log.log(Level.WARNING, e.getMessage(), e);
        }
        return Transmitter.detectSourceTransmitter(inBytes);
    }

    public static Transmitter detectSourceTransmitter(byte[] inBytes) {
        Transmitter result = UNSPECIFIED;
        if (log.isLoggable(Level.FINE)) {
            log.log(Level.FINE, StringHelper.byte2Hex2CharString((byte[])inBytes, (int)inBytes.length));
        }
        if ((inBytes[8] & 0xFF) == 232) {
            boolean isMC32 = true;
            for (int i = 0; i < 2; ++i) {
                if (inBytes[i] == mc_32_PROD_CODE[i]) continue;
                isMC32 = false;
                break;
            }
            result = isMC32 ? MC_32 : UNSPECIFIED;
        } else if ((inBytes[8] & 0xFF) == 234) {
            int i;
            boolean isMC28 = true;
            boolean isMC26 = true;
            boolean isMC20 = true;
            boolean isMX20 = true;
            boolean isMC16 = true;
            for (i = 0; i < 2; ++i) {
                if (inBytes[i] == mc_28_PROD_CODE[i]) continue;
                isMC28 = false;
                break;
            }
            for (i = 0; i < 2; ++i) {
                if (inBytes[i] == mc_26_PROD_CODE[i]) continue;
                isMC26 = false;
                break;
            }
            for (i = 0; i < 2; ++i) {
                if (inBytes[i] == mc_20_PROD_CODE[i]) continue;
                isMC20 = false;
                break;
            }
            for (i = 0; i < 2; ++i) {
                if ((inBytes[0 + i] & 0xFF) == (mx_20_PROD_CODE[i] & 0xFF)) continue;
                isMX20 = false;
                break;
            }
            for (i = 0; i < 2; ++i) {
                if ((inBytes[0 + i] & 0xFF) == (mc_16_PROD_CODE[i] & 0xFF)) continue;
                isMC16 = false;
                break;
            }
            result = isMC28 ? MC_28 : (isMC26 ? MC_26 : (isMC20 ? MC_20 : (isMX20 ? MX_20 : (isMC16 ? MC_16 : UNSPECIFIED))));
        } else if ((inBytes[8] & 0xFF) == 233) {
            int i;
            boolean isMX16 = true;
            boolean isMX12 = true;
            for (i = 0; i < 2; ++i) {
                if (inBytes[i] == mx_16_PROD_CODE[i]) continue;
                isMX16 = false;
                break;
            }
            for (i = 0; i < 2; ++i) {
                if (inBytes[i] == mx_12_PROD_CODE[i]) continue;
                isMX12 = false;
                break;
            }
            result = isMX16 ? MX_16 : (isMX12 ? MX_12 : UNSPECIFIED);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static void convert2target(String filepath, Transmitter targetTransmitter) {
        FilterInputStream in = null;
        FilterOutputStream out = null;
        byte[] bytes = new byte[targetTransmitter.ordinal() <= 5 ? 12288 : 8192];
        try {
            filepath = filepath.replace('\\', '/');
            File inputFile = new File(filepath);
            in = new DataInputStream(new FileInputStream(inputFile));
            Object outFilePath = filepath.substring(0, filepath.lastIndexOf(47));
            outFilePath = ((String)outFilePath).substring(0, ((String)outFilePath).lastIndexOf(47) + 1) + targetTransmitter.value() + "/";
            FileUtils.checkDirectoryAndCreate((String)outFilePath);
            outFilePath = (String)outFilePath + inputFile.getName();
            File outputFile = new File((String)outFilePath);
            out = new DataOutputStream(new FileOutputStream(outputFile));
            ((DataInputStream)in).read(bytes);
            switch (targetTransmitter.ordinal()) {
                case 0: {
                    if (log.isLoggable(Level.FINE)) {
                        System.out.println("to " + MC_32.value());
                    }
                    Transmitter.cleanReceiverBinding(bytes);
                    switch (Transmitter.detectSourceTransmitter(bytes).ordinal()) {
                        case 1: 
                        case 2: {
                            Transmitter.migrateFromFirstSector(bytes);
                            Transmitter.migrateFromSecondSector(bytes);
                            Transmitter.migrateFromSetPos2PhaseAnouncement(bytes);
                            break;
                        }
                    }
                    Transmitter.cleanSwAssignements(bytes);
                    Transmitter.cleanControlAdustSw(bytes);
                    System.arraycopy(mc_32_PROD_CODE, 0, bytes, 0, mc_32_PROD_CODE.length);
                    bytes[8] = -24;
                    bytes[264] = -24;
                    System.arraycopy(mc_32_MEM_INFO, 0, bytes, 320, mc_32_MEM_INFO.length);
                    bytes[352] = -1;
                    Transmitter.convertCurves(bytes, MC_20.ordinal(), MC_32.ordinal());
                    break;
                }
                case 1: {
                    if (log.isLoggable(Level.FINE)) {
                        System.out.println("to " + MC_28.value());
                    }
                    Transmitter.cleanReceiverBinding(bytes);
                    switch (Transmitter.detectSourceTransmitter(bytes).ordinal()) {
                        case 0: {
                            Transmitter.cleanSwAssignements(bytes);
                            Transmitter.cleanControlAdustSw(bytes);
                            Transmitter.cleanPhaseSetting(bytes);
                            Transmitter.migrateDualMixerChannel(bytes);
                            Transmitter.migrateChannelMapping(bytes);
                            Transmitter.migrateFreeMixerChannel(bytes);
                            Transmitter.convertCurves(bytes, MC_32.ordinal(), MC_20.ordinal());
                            Transmitter.migrateToFirstSector(bytes);
                            Transmitter.migrateToSecondSector(bytes);
                            Transmitter.migrateToSetPos2PhaseAnouncement(bytes);
                            break;
                        }
                        default: {
                            Transmitter.cleanSwAssignements(bytes);
                            Transmitter.cleanControlAdustSw(bytes);
                            Transmitter.cleanPhaseSetting(bytes);
                            Transmitter.migrateDualMixerChannel(bytes);
                            Transmitter.migrateChannelMapping(bytes);
                            Transmitter.migrateFreeMixerChannel(bytes);
                            Transmitter.migrateToFirstSector(bytes);
                            Transmitter.migrateToSecondSector(bytes);
                            Transmitter.migrateToMarkerKey2PhaseAnouncement(bytes);
                        }
                    }
                    System.arraycopy(mc_28_PROD_CODE, 0, bytes, 0, mc_28_PROD_CODE.length);
                    System.arraycopy(mc_28_MEM_INFO, 0, bytes, 320, mc_28_MEM_INFO.length);
                    bytes[352] = 5;
                    break;
                }
                case 2: {
                    if (log.isLoggable(Level.FINE)) {
                        System.out.println("to " + MC_26.value());
                    }
                    Transmitter.cleanReceiverBinding(bytes);
                    switch (Transmitter.detectSourceTransmitter(bytes).ordinal()) {
                        case 0: {
                            Transmitter.cleanSwAssignements(bytes);
                            Transmitter.cleanControlAdustSw(bytes);
                            Transmitter.cleanPhaseSetting(bytes);
                            Transmitter.migrateDualMixerChannel(bytes);
                            Transmitter.migrateChannelMapping(bytes);
                            Transmitter.migrateFreeMixerChannel(bytes);
                            Transmitter.convertCurves(bytes, MC_32.ordinal(), MC_20.ordinal());
                            Transmitter.migrateToSecondSector(bytes);
                            Transmitter.migrateToFirstSector(bytes);
                            Transmitter.migrateToSetPos2PhaseAnouncement(bytes);
                            break;
                        }
                        default: {
                            Transmitter.cleanSwAssignements(bytes);
                            Transmitter.cleanControlAdustSw(bytes);
                            Transmitter.cleanPhaseSetting(bytes);
                            Transmitter.migrateDualMixerChannel(bytes);
                            Transmitter.migrateChannelMapping(bytes);
                            Transmitter.migrateFreeMixerChannel(bytes);
                            Transmitter.migrateToSecondSector(bytes);
                            Transmitter.migrateToFirstSector(bytes);
                            Transmitter.migrateToMarkerKey2PhaseAnouncement(bytes);
                        }
                    }
                    System.arraycopy(mc_26_PROD_CODE, 0, bytes, 0, mc_26_PROD_CODE.length);
                    System.arraycopy(mc_26_MEM_INFO, 0, bytes, 320, mc_26_MEM_INFO.length);
                    bytes[352] = 5;
                    break;
                }
                case 4: {
                    if (log.isLoggable(Level.FINE)) {
                        System.out.println("to " + MX_20.value());
                    }
                    Transmitter.cleanReceiverBinding(bytes);
                    switch (Transmitter.detectSourceTransmitter(bytes).ordinal()) {
                        case 1: 
                        case 2: {
                            Transmitter.migrateFromFirstSector(bytes);
                            Transmitter.migrateFromSecondSector(bytes);
                            Transmitter.migrateFromMarkerKey2PhaseAnouncement(bytes);
                            Transmitter.cleanPhaseSetting(bytes);
                            Transmitter.cleanPhaseSetting(bytes);
                            Transmitter.migrateDualMixerChannel(bytes);
                            Transmitter.migrateChannelMapping(bytes);
                            Transmitter.migrateFreeMixerChannel(bytes);
                            Transmitter.cleanSwAssignements(bytes);
                            Transmitter.cleanControlAdustSw(bytes);
                            break;
                        }
                        case 0: {
                            Transmitter.cleanPhaseSetting(bytes);
                            Transmitter.cleanPhaseSetting(bytes);
                            Transmitter.migrateDualMixerChannel(bytes);
                            Transmitter.migrateChannelMapping(bytes);
                            Transmitter.migrateFreeMixerChannel(bytes);
                            Transmitter.cleanSwAssignements(bytes);
                            Transmitter.cleanControlAdustSw(bytes);
                            Transmitter.convertCurves(bytes, MC_32.ordinal(), MX_20.ordinal());
                            break;
                        }
                    }
                    System.arraycopy(mx_20_PROD_CODE, 0, bytes, 0, mx_20_PROD_CODE.length);
                    bytes[8] = -22;
                    bytes[264] = -22;
                    System.arraycopy(mc_20_MEM_INFO, 0, bytes, 320, mc_20_MEM_INFO.length);
                    bytes[352] = -1;
                    break;
                }
                case 3: {
                    if (log.isLoggable(Level.FINE)) {
                        System.out.println("to " + MC_20.value());
                    }
                    Transmitter.cleanReceiverBinding(bytes);
                    switch (Transmitter.detectSourceTransmitter(bytes).ordinal()) {
                        case 1: 
                        case 2: {
                            Transmitter.migrateFromFirstSector(bytes);
                            Transmitter.migrateFromSecondSector(bytes);
                            Transmitter.migrateFromMarkerKey2PhaseAnouncement(bytes);
                            Transmitter.cleanPhaseSetting(bytes);
                            Transmitter.cleanPhaseSetting(bytes);
                            Transmitter.migrateDualMixerChannel(bytes);
                            Transmitter.migrateChannelMapping(bytes);
                            Transmitter.migrateFreeMixerChannel(bytes);
                            Transmitter.cleanSwAssignements(bytes);
                            Transmitter.cleanControlAdustSw(bytes);
                            break;
                        }
                        case 0: {
                            Transmitter.cleanPhaseSetting(bytes);
                            Transmitter.cleanPhaseSetting(bytes);
                            Transmitter.migrateDualMixerChannel(bytes);
                            Transmitter.migrateChannelMapping(bytes);
                            Transmitter.migrateFreeMixerChannel(bytes);
                            Transmitter.cleanSwAssignements(bytes);
                            Transmitter.cleanControlAdustSw(bytes);
                            Transmitter.convertCurves(bytes, MC_32.ordinal(), MX_20.ordinal());
                            break;
                        }
                    }
                    System.arraycopy(mc_20_PROD_CODE, 0, bytes, 0, mc_20_PROD_CODE.length);
                    bytes[8] = -22;
                    bytes[264] = -22;
                    System.arraycopy(mc_20_MEM_INFO, 0, bytes, 320, mc_20_MEM_INFO.length);
                    bytes[352] = 5;
                    break;
                }
                case 5: {
                    if (log.isLoggable(Level.FINE)) {
                        System.out.println("to " + MC_16.value());
                    }
                    Transmitter.cleanReceiverBinding(bytes);
                    switch (Transmitter.detectSourceTransmitter(bytes).ordinal()) {
                        case 1: 
                        case 2: {
                            Transmitter.migrateFromFirstSector(bytes);
                            Transmitter.migrateFromSecondSector(bytes);
                            Transmitter.migrateFromMarkerKey2PhaseAnouncement(bytes);
                            Transmitter.cleanPhaseSetting(bytes);
                            Transmitter.cleanPhaseSetting(bytes);
                            Transmitter.migrateDualMixerChannel(bytes);
                            Transmitter.migrateChannelMapping(bytes);
                            Transmitter.migrateFreeMixerChannel(bytes);
                            Transmitter.cleanSwAssignements(bytes);
                            Transmitter.cleanControlAdustSw(bytes);
                            break;
                        }
                        case 0: {
                            Transmitter.cleanPhaseSetting(bytes);
                            Transmitter.cleanPhaseSetting(bytes);
                            Transmitter.migrateDualMixerChannel(bytes);
                            Transmitter.migrateChannelMapping(bytes);
                            Transmitter.migrateFreeMixerChannel(bytes);
                            Transmitter.cleanSwAssignements(bytes);
                            Transmitter.cleanControlAdustSw(bytes);
                            Transmitter.convertCurves(bytes, MC_32.ordinal(), MX_20.ordinal());
                            break;
                        }
                    }
                    System.arraycopy(mc_16_PROD_CODE, 0, bytes, 0, mc_16_PROD_CODE.length);
                    bytes[8] = -22;
                    bytes[264] = -22;
                    System.arraycopy(mc_16_MEM_INFO, 0, bytes, 320, mc_16_MEM_INFO.length);
                    bytes[352] = 5;
                    break;
                }
                case 6: {
                    System.arraycopy(mx_16_PROD_CODE, 0, bytes, 0, mx_16_PROD_CODE.length);
                    bytes[4571] = -3;
                    Transmitter.calculateAndWriteCRC(bytes, 4571, 4591);
                    Transmitter.calculateAndWriteCRC(bytes, 4593, 4594);
                    Transmitter.calculateAndWriteCRC(bytes, 4596, 4597);
                    break;
                }
                case 7: {
                    System.arraycopy(mx_12_PROD_CODE, 0, bytes, 0, mx_12_PROD_CODE.length);
                    bytes[4571] = -35;
                    Transmitter.calculateAndWriteCRC(bytes, 4571, 4591);
                    Transmitter.calculateAndWriteCRC(bytes, 4593, 4594);
                    Transmitter.calculateAndWriteCRC(bytes, 4596, 4597);
                    break;
                }
            }
            in.close();
            in = null;
            out.write(bytes);
            out.close();
            out = null;
            if (DataExplorer.getInstance() == null) return;
            switch (targetTransmitter.ordinal()) {
                case 0: {
                    DataExplorer.getInstance().openMessageDialogAsync(Messages.getString((String)"GDE_MSGI2403"));
                    return;
                }
                case 1: 
                case 2: {
                    if (Transmitter.detectSourceTransmitter(bytes) == MC_32) {
                        DataExplorer.getInstance().openMessageDialogAsync(Messages.getString((String)"GDE_MSGI2402"));
                        return;
                    }
                    DataExplorer.getInstance().openMessageDialogAsync(Messages.getString((String)"GDE_MSGI2403"));
                    return;
                }
                case 3: 
                case 4: 
                case 5: {
                    if (Transmitter.detectSourceTransmitter(bytes) == MC_32) {
                        DataExplorer.getInstance().openMessageDialogAsync(Messages.getString((String)"GDE_MSGI2402"));
                        return;
                    }
                    DataExplorer.getInstance().openMessageDialogAsync(Messages.getString((String)"GDE_MSGI2403"));
                    return;
                }
                case 6: 
                case 7: {
                    DataExplorer.getInstance().openMessageDialogAsync(Messages.getString((String)"GDE_MSGI2401"));
                    return;
                }
            }
            return;
        }
        catch (Exception e) {
            log.log(Level.WARNING, e.getMessage(), e);
            DataExplorer.getInstance().openMessageDialogAsync(Messages.getString((String)"GDE_MSGE2401"));
            return;
        }
        finally {
            try {
                if (in != null) {
                    in.close();
                }
                if (out != null) {
                    out.close();
                }
            }
            catch (IOException e) {
                log.log(Level.WARNING, e.getMessage(), e);
            }
        }
    }

    public static void cleanReceiverBinding(byte[] bytes) {
        int i;
        for (i = 0; i < 4; ++i) {
            bytes[4126] = 0;
        }
        for (i = 0; i < 64; ++i) {
            bytes[4130 + i] = 0;
        }
    }

    public static void migrateDualMixerChannel(byte[] bytes) {
        int i;
        if (log.isLoggable(Level.FINE)) {
            StringHelper.printMemHex((String)"0x17CD", (byte[])bytes, (int)6093, (int)1, (int)1, (int)12);
        }
        for (i = 0; i < 4; ++i) {
            if (bytes[6093 + i] <= 12) continue;
            bytes[6550 + i] = 13;
        }
        if (log.isLoggable(Level.FINE)) {
            StringHelper.printMemHex((String)"0x17D1", (byte[])bytes, (int)6097, (int)1, (int)1, (int)12);
        }
        for (i = 0; i < 4; ++i) {
            if (bytes[6097 + i] <= 12) continue;
            bytes[6097 + i] = 13;
        }
        Transmitter.calculateAndWriteCRC(bytes, 6093, 6105);
    }

    public static void migrateChannelMapping(byte[] bytes) {
        if (log.isLoggable(Level.FINE)) {
            StringHelper.printMemHex((String)"0x182E", (byte[])bytes, (int)6190, (int)1, (int)1, (int)16);
        }
        for (int i = 0; i < 12; ++i) {
            if (bytes[6190 + i] <= 12) continue;
            bytes[6190 + i] = 13;
        }
        Transmitter.calculateAndWriteCRC(bytes, 6190, 6206);
    }

    public static void migrateFreeMixerChannel(byte[] bytes) {
        int i;
        if (log.isLoggable(Level.FINE)) {
            StringHelper.printMemHex((String)"0x1996", (byte[])bytes, (int)6550, (int)1, (int)1, (int)12);
        }
        for (i = 0; i < 12; ++i) {
            if (bytes[6550 + i] <= 12) continue;
            bytes[6550 + i] = 13;
        }
        if (log.isLoggable(Level.FINE)) {
            StringHelper.printMemHex((String)"0x19A2", (byte[])bytes, (int)6562, (int)1, (int)1, (int)12);
        }
        for (i = 0; i < 12; ++i) {
            if (bytes[6562 + i] <= 13) continue;
            bytes[6562 + i] = 14;
        }
    }

    public static void cleanSwAssignements(byte[] bytes) {
        int i;
        if (log.isLoggable(Level.FINE)) {
            StringHelper.printMemHex((String)"0x1062", (byte[])bytes, (int)4194, (int)1, (int)2, (int)9);
        }
        for (i = 0; i < 18; ++i) {
            bytes[4194 + i] = -1;
        }
        if (log.isLoggable(Level.FINE)) {
            StringHelper.printMemHex((String)"0x1062", (byte[])bytes, (int)4194, (int)1, (int)2, (int)9);
        }
        Transmitter.calculateAndWriteCRC(bytes, 4096, 4212);
        if (log.isLoggable(Level.FINE)) {
            StringHelper.printMemHex((String)"0x1518", (byte[])bytes, (int)5400, (int)1, (int)6, (int)16);
        }
        for (i = 0; i < 96; ++i) {
            bytes[5400 + i] = -1;
        }
        if (log.isLoggable(Level.FINE)) {
            StringHelper.printMemHex((String)"0x1518", (byte[])bytes, (int)5400, (int)1, (int)6, (int)16);
        }
        Transmitter.calculateAndWriteCRC(bytes, 5304, 5496);
        if (log.isLoggable(Level.FINE)) {
            StringHelper.printMemHex((String)"0x157A", (byte[])bytes, (int)5498, (int)1, (int)2, (int)8);
        }
        for (i = 0; i < 16; ++i) {
            bytes[5498 + i] = -1;
        }
        if (log.isLoggable(Level.FINE)) {
            StringHelper.printMemHex((String)"0x157A", (byte[])bytes, (int)5498, (int)1, (int)2, (int)8);
        }
        if (log.isLoggable(Level.FINE)) {
            StringHelper.printMemHex((String)"0x159A", (byte[])bytes, (int)5530, (int)1, (int)2, (int)8);
        }
        for (i = 0; i < 16; ++i) {
            bytes[5530 + i] = -1;
        }
        if (log.isLoggable(Level.FINE)) {
            StringHelper.printMemHex((String)"0x159A", (byte[])bytes, (int)5530, (int)1, (int)2, (int)8);
        }
        Transmitter.calculateAndWriteCRC(bytes, 5498, 5554);
        if (log.isLoggable(Level.FINE)) {
            StringHelper.printMemHex((String)"0x15B4", (byte[])bytes, (int)5556, (int)1, (int)4, (int)8);
        }
        for (i = 0; i < 32; ++i) {
            bytes[5556 + i] = -1;
        }
        if (log.isLoggable(Level.FINE)) {
            StringHelper.printMemHex((String)"0x15B4", (byte[])bytes, (int)5556, (int)1, (int)4, (int)8);
        }
        Transmitter.calculateAndWriteCRC(bytes, 5556, 5604);
        if (log.isLoggable(Level.FINE)) {
            StringHelper.printMemHex((String)"0x1640", (byte[])bytes, (int)5696, (int)1, (int)2, (int)6);
        }
        for (i = 0; i < 12; ++i) {
            bytes[5696 + i] = -1;
        }
        if (log.isLoggable(Level.FINE)) {
            StringHelper.printMemHex((String)"0x1640", (byte[])bytes, (int)5696, (int)1, (int)2, (int)6);
        }
        Transmitter.calculateAndWriteCRC(bytes, 5696, 5726);
        if (log.isLoggable(Level.FINE)) {
            StringHelper.printMemHex((String)"0x173C", (byte[])bytes, (int)5948, (int)1, (int)2, (int)3);
        }
        for (i = 0; i < 6; ++i) {
            bytes[5948 + i] = -1;
        }
        if (log.isLoggable(Level.FINE)) {
            StringHelper.printMemHex((String)"0x173C", (byte[])bytes, (int)5948, (int)1, (int)2, (int)3);
        }
        Transmitter.calculateAndWriteCRC(bytes, 5940, 5954);
        if (log.isLoggable(Level.FINE)) {
            StringHelper.printMemHex((String)"0x174D", (byte[])bytes, (int)5965, (int)1, (int)2, (int)5);
        }
        for (i = 0; i < 10; ++i) {
            bytes[5965 + i] = -1;
        }
        if (log.isLoggable(Level.FINE)) {
            StringHelper.printMemHex((String)"0x174D", (byte[])bytes, (int)5965, (int)1, (int)2, (int)5);
        }
        Transmitter.calculateAndWriteCRC(bytes, 5956, 5975);
        if (log.isLoggable(Level.FINE)) {
            StringHelper.printMemHex((String)"0x1811", (byte[])bytes, (int)6161, (int)1, (int)1, (int)12);
        }
        for (i = 0; i < 12; ++i) {
            bytes[6161 + i] = 0;
        }
        if (log.isLoggable(Level.FINE)) {
            StringHelper.printMemHex((String)"0x1811", (byte[])bytes, (int)6186, (int)1, (int)1, (int)12);
        }
        if (log.isLoggable(Level.FINE)) {
            StringHelper.printMemHex((String)"0x182A", (byte[])bytes, (int)6186, (int)1, (int)2, (int)1);
        }
        for (i = 0; i < 2; ++i) {
            bytes[6186 + i] = -1;
        }
        if (log.isLoggable(Level.FINE)) {
            StringHelper.printMemHex((String)"0x182A", (byte[])bytes, (int)6186, (int)1, (int)2, (int)1);
        }
        Transmitter.calculateAndWriteCRC(bytes, 6161, 6188);
        if (log.isLoggable(Level.FINE)) {
            StringHelper.printMemHex((String)"0x19AE", (byte[])bytes, (int)6574, (int)1, (int)2, (int)12);
        }
        for (i = 0; i < 24; ++i) {
            bytes[6574 + i] = -1;
        }
        if (log.isLoggable(Level.FINE)) {
            StringHelper.printMemHex((String)"0x19AE", (byte[])bytes, (int)6574, (int)1, (int)2, (int)12);
        }
        Transmitter.calculateAndWriteCRC(bytes, 6538, 6838);
        if (log.isLoggable(Level.FINE)) {
            StringHelper.printMemHex((String)"0x1F59", (byte[])bytes, (int)8025, (int)1, (int)4, (int)16);
        }
        for (i = 0; i < 64; ++i) {
            bytes[8025 + i] = -1;
        }
        if (log.isLoggable(Level.FINE)) {
            StringHelper.printMemHex((String)"0x1F59", (byte[])bytes, (int)8025, (int)1, (int)4, (int)16);
        }
        Transmitter.calculateAndWriteCRC(bytes, 7913, 8089);
        if (log.isLoggable(Level.FINE)) {
            StringHelper.printMemHex((String)"0x2482", (byte[])bytes, (int)9346, (int)1, (int)2, (int)1);
        }
        for (i = 0; i < 2; ++i) {
            bytes[9346 + i] = -1;
        }
        if (log.isLoggable(Level.FINE)) {
            StringHelper.printMemHex((String)"0x2482", (byte[])bytes, (int)9346, (int)1, (int)2, (int)1);
        }
        Transmitter.calculateAndWriteCRC(bytes, 9326, 9348);
        if (log.isLoggable(Level.FINE)) {
            StringHelper.printMemHex((String)"0x24D3", (byte[])bytes, (int)9427, (int)1, (int)2, (int)1);
        }
        for (i = 0; i < 2; ++i) {
            bytes[9427 + i] = -1;
        }
        if (log.isLoggable(Level.FINE)) {
            StringHelper.printMemHex((String)"0x24D3", (byte[])bytes, (int)9427, (int)1, (int)2, (int)1);
        }
        Transmitter.calculateAndWriteCRC(bytes, 9372, 9430);
        if (log.isLoggable(Level.FINE)) {
            StringHelper.printMemHex((String)"0x258F", (byte[])bytes, (int)9615, (int)1, (int)2, (int)8);
        }
        for (i = 0; i < 16; ++i) {
            bytes[9615 + i] = -1;
        }
        if (log.isLoggable(Level.FINE)) {
            StringHelper.printMemHex((String)"0x258F", (byte[])bytes, (int)9615, (int)1, (int)2, (int)8);
        }
        Transmitter.calculateAndWriteCRC(bytes, 9607, 9631);
    }

    public static void cleanControlAdustSw(byte[] bytes) {
        int i;
        if (log.isLoggable(Level.FINE)) {
            StringHelper.printMemHex((String)"0x12CA", (byte[])bytes, (int)4810, (int)1, (int)8, (int)60);
        }
        for (i = 0; i < 480; ++i) {
            bytes[4810 + i] = -1;
        }
        if (log.isLoggable(Level.FINE)) {
            StringHelper.printMemHex((String)"0x12CA", (byte[])bytes, (int)4810, (int)1, (int)8, (int)60);
        }
        if (log.isLoggable(Level.FINE)) {
            StringHelper.printMemHex((String)"0x14AA", (byte[])bytes, (int)5290, (int)1, (int)1, (int)12);
        }
        for (i = 0; i < 10; ++i) {
            bytes[5290 + i] = 1;
        }
        if (log.isLoggable(Level.FINE)) {
            StringHelper.printMemHex((String)"0x14AA", (byte[])bytes, (int)5290, (int)1, (int)1, (int)12);
        }
        Transmitter.calculateAndWriteCRC(bytes, 4330, 5302);
    }

    public static void cleanPhaseSetting(byte[] bytes) {
        int i;
        if (log.isLoggable(Level.FINE)) {
            StringHelper.printMemChar((String)"0x15F6", (byte[])bytes, (int)5622, (int)1, (int)7, (int)8);
        }
        byte[] name = new byte[]{32, 32, 32, 32, 32, 32, 32};
        for (i = 0; i < 8; ++i) {
            System.arraycopy(name, 0, bytes, 5622 + i * name.length, name.length);
        }
        if (log.isLoggable(Level.FINE)) {
            StringHelper.printMemChar((String)"0x15F6", (byte[])bytes, (int)5622, (int)1, (int)7, (int)8);
        }
        if (log.isLoggable(Level.FINE)) {
            StringHelper.printMemHex((String)"0x162E", (byte[])bytes, (int)5678, (int)1, (int)8, (int)1);
        }
        for (i = 0; i < 8; ++i) {
            bytes[5678 + i] = 0;
        }
        if (log.isLoggable(Level.FINE)) {
            StringHelper.printMemHex((String)"0x162E", (byte[])bytes, (int)5678, (int)1, (int)8, (int)1);
        }
        if (log.isLoggable(Level.FINE)) {
            StringHelper.printMemHex((String)"0x1636", (byte[])bytes, (int)5686, (int)1, (int)8, (int)1);
        }
        for (i = 0; i < 8; ++i) {
            bytes[5686 + i] = 0;
        }
        if (log.isLoggable(Level.FINE)) {
            StringHelper.printMemHex((String)"0x1636", (byte[])bytes, (int)5686, (int)1, (int)8, (int)1);
        }
        Transmitter.calculateAndWriteCRC(bytes, 5606, 5694);
    }

    public static void convertCurves(byte[] bytes, int from, int to) {
        int i;
        for (i = 0; i < mc_32_20_0x1840.length; ++i) {
            Transmitter.convertCurve(bytes, mc_32_20_0x1840[i], from, to);
        }
        Transmitter.calculateAndWriteCRC(bytes, mc_32_20_0x1840_0x1988[0], mc_32_20_0x1840_0x1988[1]);
        for (i = 0; i < mc_32_20_0x198A.length; ++i) {
            Transmitter.convertCurve(bytes, mc_32_20_0x198A[i], from, to);
        }
        Transmitter.calculateAndWriteCRC(bytes, mc_32_20_0x198A_0x1AB6[0], mc_32_20_0x198A_0x1AB6[1]);
        for (i = 0; i < mc_32_20_0x1AC5.length; ++i) {
            Transmitter.convertCurve(bytes, mc_32_20_0x1AC5[i], from, to);
        }
        Transmitter.calculateAndWriteCRC(bytes, mc_32_20_0x1AC5_0x1EDF[0], mc_32_20_0x1AC5_0x1EDF[1]);
        for (i = 0; i < mc_32_20_0x21C2.length; ++i) {
            Transmitter.convertCurve(bytes, mc_32_20_0x21C2[i], from, to);
        }
        Transmitter.calculateAndWriteCRC(bytes, mc_32_20_0x21C2_0x238A[0], mc_32_20_0x21C2_0x238A[1]);
    }

    public static void calculateAndWriteCRC(byte[] bytes, int start, int end) {
        short checkSum = Checksum.CRC16CCITT((byte[])bytes, (int)start, (int)(end - start));
        bytes[end] = (byte)(checkSum & 0xFF);
        bytes[end + 1] = (byte)((checkSum & 0xFF00) >> 8);
    }

    public static boolean convertCurve(byte[] bytes, int index, int from, int to) {
        boolean isCheckNeeded = false;
        if (log.isLoggable(Level.FINE)) {
            Transmitter.printCurveData(bytes, index);
        }
        if (from == MC_32.ordinal()) {
            int ptCount = 0;
            for (int i = index; i < index + 8; ++i) {
                if (bytes[32 + i] == 1) {
                    ++ptCount;
                }
                if (ptCount <= 6) continue;
                isCheckNeeded = true;
                break;
            }
            bytes[10 + index] = bytes[14 + index];
            bytes[10 + index + 1] = bytes[14 + index + 1];
            bytes[26 + index] = bytes[30 + index];
            bytes[26 + index + 1] = bytes[30 + index + 1];
            bytes[37 + index] = 1;
            if (index < 8778) {
                bytes[12 + index] = 74;
                bytes[12 + index + 1] = 0;
                bytes[14 + index] = 100;
                bytes[14 + index + 1] = 0;
                if (index >= 6610 && index < 6943 || index == 7023 || index == 7143 || index == 7263 || index == 7503 || index == 7623 || index == 7863) {
                    bytes[28 + index] = 0;
                    bytes[28 + index + 1] = 0;
                    bytes[30 + index] = 0;
                    bytes[30 + index + 1] = 0;
                } else {
                    bytes[28 + index] = 74;
                    bytes[28 + index + 1] = 0;
                    bytes[30 + index] = 100;
                    bytes[30 + index + 1] = 0;
                }
                bytes[38 + index] = 0;
                bytes[39 + index] = 1;
            } else {
                bytes[12 + index] = -1;
                bytes[12 + index + 1] = -1;
                bytes[14 + index] = -1;
                bytes[14 + index + 1] = -1;
                bytes[28 + index] = -1;
                bytes[28 + index + 1] = -1;
                bytes[30 + index] = -1;
                bytes[30 + index + 1] = -1;
                bytes[38 + index] = -1;
                bytes[39 + index] = -1;
            }
            if (index >= 7063 && index <= 7863) {
                bytes[32 + index] = 0;
            }
        } else if (to == MC_32.ordinal()) {
            bytes[14 + index] = bytes[10 + index];
            bytes[14 + index + 1] = bytes[10 + index + 1];
            bytes[30 + index] = bytes[26 + index];
            bytes[30 + index + 1] = bytes[26 + index + 1];
            bytes[37 + index] = 0;
            bytes[38 + index] = 0;
            bytes[39 + index] = 1;
            if (index < 8778) {
                bytes[10 + index] = 70;
                bytes[10 + index + 1] = 0;
                bytes[12 + index] = 85;
                bytes[12 + index + 1] = 0;
                if (index >= 6610 && index < 6943 || index == 7023 || index == 7143 || index == 7263 || index == 7503 || index == 7623 || index == 7863) {
                    bytes[26 + index] = 0;
                    bytes[26 + index + 1] = 0;
                    bytes[28 + index] = 0;
                    bytes[28 + index + 1] = 0;
                } else {
                    bytes[26 + index] = 70;
                    bytes[26 + index + 1] = 0;
                    bytes[28 + index] = 85;
                    bytes[28 + index + 1] = 0;
                }
            } else {
                bytes[10 + index] = 70;
                bytes[10 + index + 1] = 0;
                bytes[12 + index] = 85;
                bytes[12 + index + 1] = 0;
                bytes[26 + index] = 0;
                bytes[26 + index + 1] = 0;
                bytes[28 + index] = 0;
                bytes[28 + index + 1] = 0;
            }
            if (index >= 7063 && index <= 7863) {
                bytes[32 + index] = 1;
            }
        }
        if (log.isLoggable(Level.FINE)) {
            Transmitter.printCurveData(bytes, index);
        }
        return isCheckNeeded;
    }

    public static int printCurveData(byte[] bytes, int _index) {
        int index = _index;
        block3: for (int i = 0; i < 3; ++i) {
            switch (i) {
                default: {
                    int j;
                    for (j = 0; j < 16; j += 2) {
                        System.out.print(DataParser.parse2Short((byte[])bytes, (int)index));
                        System.out.print("; ");
                        index += 2;
                    }
                    if (!log.isLoggable(Level.FINE)) continue block3;
                    System.out.println();
                    continue block3;
                }
                case 2: {
                    int j;
                    for (j = 0; j < 8; ++j) {
                        System.out.print(bytes[index++]);
                        System.out.print("; ");
                    }
                    if (!log.isLoggable(Level.FINE)) continue block3;
                    System.out.println();
                }
            }
        }
        return index;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void migrateToSetPos2PhaseAnouncement(byte[] bytes) {
        byte[] buffer = new byte[1806];
        InputStream is = Transmitter.class.getClassLoader().getResourceAsStream("resource/MC-28_Dummy.mdl");
        BufferedReader br = new BufferedReader(new InputStreamReader(is));
        int bytesRead = 0;
        int offset = 0;
        try {
            is.skip(9738 + offset);
            while ((bytesRead += is.read(buffer)) != -1) {
                System.arraycopy(buffer, 0, bytes, 9738 + offset, bytesRead);
                if (bytesRead == buffer.length) {
                    break;
                }
                offset = bytesRead;
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        finally {
            try {
                br.close();
                is.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    private static void migrateFromSetPos2PhaseAnouncement(byte[] bytes) {
        for (int i = 0; i < 1806; ++i) {
            bytes[9738 + i] = -1;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void migrateToMarkerKey2PhaseAnouncement(byte[] bytes) {
        byte[] buffer = new byte[1871];
        InputStream is = Transmitter.class.getClassLoader().getResourceAsStream("resource/MC-28_Dummy.mdl");
        BufferedReader br = new BufferedReader(new InputStreamReader(is));
        int bytesRead = 0;
        int offset = 0;
        try {
            is.skip(9673 + offset);
            while ((bytesRead += is.read(buffer)) != -1) {
                System.arraycopy(buffer, 0, bytes, 9673 + offset, bytesRead);
                if (bytesRead == buffer.length) {
                    break;
                }
                offset = bytesRead;
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        finally {
            try {
                br.close();
                is.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    private static void migrateFromMarkerKey2PhaseAnouncement(byte[] bytes) {
        for (int i = 0; i < 1871; ++i) {
            bytes[9673 + i] = -1;
        }
    }

    private static void migrateToFirstSector(byte[] bytes) {
        System.arraycopy(bytes, 6190, bytes, 6194, 1901);
        for (int i = 0; i < 31; ++i) {
            bytes[6161 + i] = 0;
        }
        Transmitter.calculateAndWriteCRC(bytes, 6161, 6192);
    }

    private static void migrateFromFirstSector(byte[] bytes) {
        System.arraycopy(bytes, 6165, bytes, 6161, 1926);
        for (int i = 0; i < 27; ++i) {
            bytes[6161 + i] = 0;
        }
        Transmitter.calculateAndWriteCRC(bytes, 6161, 6188);
    }

    private static void migrateToSecondSector(byte[] bytes) {
        System.arraycopy(bytes, 9438, bytes, 9445, 229);
        for (int i = 0; i < 8; ++i) {
            bytes[9436 + i] = -1;
        }
        Transmitter.calculateAndWriteCRC(bytes, 9432, 9443);
    }

    private static void migrateFromSecondSector(byte[] bytes) {
        System.arraycopy(bytes, 9443, bytes, 9436, 230);
        Transmitter.calculateAndWriteCRC(bytes, 9432, 9436);
    }

    static {
        log = Logger.getLogger(Transmitter.class.getName());
        mc_32_PROD_CODE = new byte[]{4, 52, -12, 0, 83, 4, 0, 0};
        mc_28_PROD_CODE = new byte[]{-68, 63, -12, 0, -17, 3, 0, 0};
        mc_26_PROD_CODE = new byte[]{20, 66, -12, 0, -22, 3, 0, 0};
        mc_20_PROD_CODE = new byte[]{-52, 52, -12, 0, -24, 3, 0, 0};
        mx_20_PROD_CODE = new byte[]{116, 50, -12, 0, 95, 4, 0, 0};
        mc_16_PROD_CODE = new byte[]{-8, 53, -12, 0, 9, 3, 0, 0};
        mx_16_PROD_CODE = new byte[]{-28, 48, -12, 0, -77, 6, 0, 0};
        mx_12_PROD_CODE = new byte[]{16, 50, -12, 0, 115, 6, 0, 0};
        mc_32_APP_VERSION = new byte[]{-24, 3, 0, 0};
        mc_28_APP_VERSION = new byte[]{-22, 3, 0, 0};
        mc_26_APP_VERSION = new byte[]{-22, 3, 0, 0};
        mc_20_APP_VERSION = new byte[]{-22, 3, 0, 0};
        mx_20_APP_VERSION = new byte[]{-22, 3, 0, 0};
        mc_16_APP_VERSION = new byte[]{-22, 3, 0, 0};
        mx_16_APP_VERSION = new byte[]{-23, 3, 0, 0};
        mx_12_APP_VERSION = new byte[]{-23, 3, 0, 0};
        MEMORY_VERSION = new byte[]{-1, -1, -1, -1, -1, -1, -1, -1};
        mc_32_MEM_INFO = new byte[]{32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, -1, -1, -1};
        mc_28_MEM_INFO = new byte[]{-1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1};
        mc_26_MEM_INFO = new byte[]{-1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1};
        mc_20_MEM_INFO = new byte[]{32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32};
        mx_20_MEM_INFO = new byte[]{32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32};
        mc_16_MEM_INFO = new byte[]{32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, -1};
        mc_32_20_0x1840_0x1988 = new int[]{6208, 6536};
        mc_32_20_0x1840 = new int[]{6216, 6256, 6296, 6336, 6376, 6416, 6456, 6496};
        mc_32_20_0x198A_0x1AB6 = new int[]{6538, 6838};
        mc_32_20_0x198A = new int[]{6610, 6652, 6694, 6736};
        mc_32_20_0x1AC5_0x1EDF = new int[]{6853, 7903};
        mc_32_20_0x1AC5 = new int[]{6943, 6983, 7023, 7063, 7103, 7143, 7183, 7223, 7263, 7303, 7343, 7423, 7463, 7503, 7543, 7583, 7623, 7663, 7703, 7783, 7823, 7863};
        mc_32_20_0x21C2_0x238A = new int[]{8642, 9098};
        mc_32_20_0x21C2 = new int[]{8778, 8818, 8858, 8898, 8938, 8978, 9018, 9058};
    }
}

